/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.BaseInputStream;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.TDSReader;
import java.io.IOException;
import java.util.logging.Level;

final class SimpleInputStream
extends BaseInputStream {
    private final int payloadLength;
    private final byte[] bSingleByte = new byte[1];
    static final /* synthetic */ boolean $assertionsDisabled;

    SimpleInputStream(TDSReader tDSReader, int n, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        super(tDSReader, inputStreamGetterArgs.isAdaptive, inputStreamGetterArgs.isStreaming, serverDTVImpl);
        this.setLoggingInfo(inputStreamGetterArgs.logContext);
        this.payloadLength = n;
    }

    public void close() throws IOException {
        if (null == this.tdsReader) {
            return;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toLogString() + "Enter Closing SimpleInputStream.");
        }
        this.skip(this.payloadLength - this.streamPos);
        this.closeHelper();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toLogString() + "Exit Closing SimpleInputStream.");
        }
    }

    private final boolean isEOS() throws IOException {
        if (!$assertionsDisabled && this.streamPos > this.payloadLength) {
            throw new AssertionError();
        }
        return this.streamPos == this.payloadLength;
    }

    public long skip(long l) throws IOException {
        this.checkClosed();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toLogString() + " Skipping :" + l);
        }
        if (l < 0L) {
            return 0L;
        }
        if (this.isEOS()) {
            return 0L;
        }
        int n = (long)this.streamPos + l > (long)this.payloadLength ? this.payloadLength - this.streamPos : (int)l;
        try {
            this.tdsReader.skip(n);
        }
        catch (SQLServerException sQLServerException) {
            throw new IOException(sQLServerException.getMessage());
        }
        this.streamPos += n;
        if (this.isReadLimitSet && this.streamPos - this.markedStreamPos > this.readLimit) {
            this.clearCurrentMark();
        }
        return n;
    }

    public int available() throws IOException {
        this.checkClosed();
        if (!$assertionsDisabled && this.streamPos > this.payloadLength) {
            throw new AssertionError();
        }
        int n = this.payloadLength - this.streamPos;
        if (this.tdsReader.available() < n) {
            n = this.tdsReader.available();
        }
        return n;
    }

    public int read() throws IOException {
        this.checkClosed();
        if (this.isEOS()) {
            return -1;
        }
        int n = this.read(this.bSingleByte, 0, 1);
        return 0 == n ? -1 : this.bSingleByte[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        this.checkClosed();
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkClosed();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toLogString() + " Read at offset:" + n + " BytesToRead:" + n2);
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (0 == n2) {
            return 0;
        }
        if (this.isEOS()) {
            return -1;
        }
        int n3 = 0;
        n3 = this.streamPos + n2 > this.payloadLength ? this.payloadLength - this.streamPos : n2;
        try {
            this.tdsReader.readBytes(byArray, n, n3);
        }
        catch (SQLServerException sQLServerException) {
            throw new IOException(sQLServerException.getMessage());
        }
        this.streamPos += n3;
        if (this.isReadLimitSet && this.streamPos - this.markedStreamPos > this.readLimit) {
            this.clearCurrentMark();
        }
        return n3;
    }

    public void mark(int n) {
        if (null != this.tdsReader && n > 0) {
            this.currentMark = this.tdsReader.mark();
            this.markedStreamPos = this.streamPos;
            this.setReadLimit(n);
        }
    }

    public void reset() throws IOException {
        this.resetHelper();
        this.streamPos = this.markedStreamPos;
    }

    final byte[] getBytes() throws SQLServerException {
        if (!$assertionsDisabled && 0 != this.streamPos) {
            throw new AssertionError();
        }
        byte[] byArray = new byte[this.payloadLength];
        try {
            this.read(byArray);
            this.close();
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
        }
        return byArray;
    }

    static {
        $assertionsDisabled = !SimpleInputStream.class.desiredAssertionStatus();
    }
}

