/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io;

import com.sun.cdc.io.BaseInputStream;
import com.sun.cdc.io.BaseOutputStream;
import com.sun.cdc.io.ConnectionBaseInterface;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.StreamConnection;

public abstract class ConnectionBaseAdapter
implements ConnectionBaseInterface,
StreamConnection {
    protected boolean connectionOpen = false;
    protected static int iStreams = 0;
    protected int maxIStreams = 1;
    protected static int oStreams = 0;
    protected int maxOStreams = 1;

    public Connection openPrim(String string, int n, boolean bl) throws IOException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal mode");
            }
        }
        this.connect(string, n, bl);
        this.connectionOpen = true;
        return this;
    }

    protected void checkForPermission() throws SecurityException, InterruptedIOException {
        throw new SecurityException("Permission not granted");
    }

    public Connection openPrim(String string) throws IOException {
        return this.openPrim(string, 3, false);
    }

    public InputStream openInputStream() throws IOException {
        this.ensureOpen();
        BaseInputStream baseInputStream = new BaseInputStream(this);
        ++iStreams;
        return baseInputStream;
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public OutputStream openOutputStream() throws IOException {
        this.ensureOpen();
        BaseOutputStream baseOutputStream = new BaseOutputStream(this);
        ++oStreams;
        return baseOutputStream;
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public void close() throws IOException {
        if (this.connectionOpen) {
            this.connectionOpen = false;
            this.closeCommon();
        }
    }

    protected void closeInputStream() throws IOException {
        --iStreams;
        this.closeCommon();
    }

    protected void closeOutputStream() throws IOException {
        --oStreams;
        this.closeCommon();
    }

    void closeCommon() throws IOException {
        if (!this.connectionOpen && iStreams == 0 && oStreams == 0) {
            this.disconnect();
        }
    }

    protected void ensureOpen() throws IOException {
        if (!this.connectionOpen) {
            throw new IOException("Connection closed");
        }
    }

    protected void ensureNoStreamsOpen() throws IOException {
        if (iStreams > 0 || oStreams > 0) {
            throw new IOException("Stream is still open");
        }
    }

    protected abstract void connect(String var1, int var2, boolean var3) throws IOException;

    protected abstract void disconnect() throws IOException;

    protected abstract int readBytes(byte[] var1, int var2, int var3) throws IOException;

    public int available() throws IOException {
        return 0;
    }

    protected abstract int writeBytes(byte[] var1, int var2, int var3) throws IOException;

    protected void flush() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void mark(int n) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

