/* ----- core/weightsntrup857, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_weightsntrup857_checksums[] = {
  "92a23e9211ac4a5ad98bfab8db60dc8b5976d8e3a95e2e31123ad4672e8c2085",
  "2e9d660f810c309dffeef79278af6f0f197fd37d507d8d8bc7aa2656cf18ab92",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_weightsntrup857_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_weightsntrup857_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_weightsntrup857_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_weightsntrup857_CONSTBYTES

static void *storage_core_weightsntrup857_h;
static unsigned char *test_core_weightsntrup857_h;
static void *storage_core_weightsntrup857_n;
static unsigned char *test_core_weightsntrup857_n;
static void *storage_core_weightsntrup857_k;
static unsigned char *test_core_weightsntrup857_k;
static void *storage_core_weightsntrup857_c;
static unsigned char *test_core_weightsntrup857_c;
static void *storage_core_weightsntrup857_h2;
static unsigned char *test_core_weightsntrup857_h2;
static void *storage_core_weightsntrup857_n2;
static unsigned char *test_core_weightsntrup857_n2;
static void *storage_core_weightsntrup857_k2;
static unsigned char *test_core_weightsntrup857_k2;
static void *storage_core_weightsntrup857_c2;
static unsigned char *test_core_weightsntrup857_c2;

#define precomputed_core_weightsntrup857_NUM 9

static const unsigned char precomputed_core_weightsntrup857_h[precomputed_core_weightsntrup857_NUM][crypto_core_OUTPUTBYTES] = {
  {165,1},
  {175,1},
  {149,1},
  {148,1},
  {0,0},
  {89,3},
  {65,1},
  {66,1},
  {67,1},
} ;

static const unsigned char precomputed_core_weightsntrup857_n[precomputed_core_weightsntrup857_NUM][crypto_core_INPUTBYTES] = {
  {26,34,72,223,159,62,49,161,227,117,245,47,124,200,255,131,176,12,232,215,55,177,224,24,13,189,66,255,230,151,107,136,13,73,98,42,231,209,98,69,93,161,47,3,197,86,88,47,201,158,246,14,90,17,145,183,79,10,153,204,238,99,217,190,52,199,13,199,123,61,131,149,121,157,37,36,174,47,133,223,206,17,157,5,202,44,133,137,242,132,93,116,52,163,80,184,172,208,62,113,56,169,85,99,127,220,42,239,225,150,242,22,229,137,127,214,104,36,222,111,44,160,110,155,191,49,145,48,217,126,10,21,68,87,69,186,109,233,94,227,174,130,243,203,85,10,32,42,133,9,14,101,14,239,90,158,199,104,55,122,234,183,45,197,150,171,108,226,130,214,133,72,91,59,63,238,13,174,223,1,77,4,106,233,218,152,186,2,5,124,94,179,236,31,188,16,152,160,16,219,77,230,16,134,164,188,166,117,185,185,70,213,174,161,100,209,28,151,234,151,131,76,122,62,156,84,97,179,240,152,253,230,64,181,129,232,59,165,174,251,157,146,29,43,182,107,45,224,243,74,174,125,69,157,17,102,67,230,169,61,229,240,208,187,78,124,24,84,29,40,231,142,30,59,84,44,169,29,230,219,168,46,131,227,146,237,232,132,158,128,226,37,100,204,236,241,239,5,175,20,118,108,75,145,48,206,59,17,162,79,105,38,239,78,147,174,221,89,207,50,26,209,117,78,92,202,155,210,118,70,79,156,22,159,96,147,119,235,71,178,170,105,139,110,7,177,226,214,227,105,250,250,121,129,127,232,109,149,146,201,229,32,128,87,205,135,122,56,185,13,125,148,225,90,188,187,194,20,14,243,24,230,78,122,4,179,98,213,43,150,47,186,144,227,223,228,143,216,96,92,194,221,245,43,231,160,152,205,191,224,226,122,21,149,140,208,105,213,206,176,226,238,245,22,230,62,63,42,24,87,181,254,26,89,188,56,167,197,252,132,242,124,209,31,99,191,161,228,216,72,139,37,236,201,148,15,84,231,178,106,2,90,8,126,102,249,164,237,39,78,208,69,102,61,2,34,8,68,97,38,14,236,167,44,56,161,246,81,116,10,68,74,87,209,223,222,21,160,49,71,191,227,225,185,56,25,142,172,44,192,170,27,220,152,157,151,216,125,74,13,226,18,116,8,40,222,168,155,225,166,76,77,79,209,87,146,64,126,62,109,151,41,184,91,34,21,231,72,78,119,242,91,105,245,161,196,165,19,90,5,17,242,162,238,210,94,51,40,172,130,16,225,50,48,93,193,19,251,77,73,123,74,249,2,167,5,243,217,24,207,222,78,89,20,243,139,68,21,230,14,101,196,180,77,198,184,83,136,209,90,190,225,163,144,217,184,240,117,192,203,98,12,240,215,15,58,131,113,151,233,22,73,238,6,169,206,100,218,170,166,106,145,8,35,180,14,174,67,101,146,10,110,157,177,189,86,130,232,43,87,20,35,161,253,125,118,148,6,191,128,46,11,161,26,78,214,125,151,119,209,22,253,63,131,190,250,154,138,169,1,100,16,184,92,75,44,189,5,106,151,89,249,172,27,171,34,241,66,61,69,226,174,34,179,240,7,183,2,80,191,131,25,196,244,241,157,47,37,243,4,5,200,87,104,144,115,115,19,157,147,231,107,64,15,49,126,103,109,232,205,214,108,158,178,246,19,242,96,25,125,96,57,165,31,102,42,169,94,125,89,211,170,135,48,198,124,76,210,166,254,125,12,27,248,166,23,175,17,217,119,32,5,48,47,133,159,189,250,93,52,184,205,160,16,41,81,51,122,56,212,221,115,194,118,194,81,42,146,183,170,140,63,252,190,133,14,129,110,44,127,223,193,240,157,53,60,168,9,45,193,146,186,109,112,21,66,124,207,21,108,187,195,182,111,174,46,176},
  {228,102,209,218,26,136,31,174,26,57,57,200,47,34,242,8,68,101,22,17,26,159,227,173,35,184,224,59,9,210,45,38,90,117,74,152,105,200,72,158,121,232,157,145,12,43,124,172,155,195,227,103,36,41,186,7,183,218,96,239,143,64,75,90,83,138,175,183,136,103,21,58,243,56,212,128,158,132,41,31,72,164,186,206,125,46,198,221,210,87,37,85,142,39,198,33,50,17,31,245,192,17,250,136,13,130,140,109,94,209,218,55,79,213,185,60,37,209,220,138,53,213,205,134,6,5,130,16,167,57,165,1,58,41,111,10,74,117,92,222,149,150,13,241,1,21,247,148,255,29,159,13,184,116,85,226,85,140,97,15,38,224,116,4,28,101,62,250,40,48,27,33,213,88,197,247,41,86,127,148,2,12,118,215,85,144,76,237,40,234,250,224,12,103,53,212,151,59,165,228,16,38,77,128,37,134,61,68,121,133,84,40,231,89,182,102,181,41,125,47,241,236,79,237,236,101,150,57,29,190,142,134,163,14,3,208,76,29,68,196,223,58,203,49,11,101,157,234,188,223,179,50,69,116,126,131,126,170,1,231,12,140,229,138,54,112,14,208,48,152,209,230,53,9,224,13,29,20,37,222,116,194,139,67,146,189,189,94,217,125,48,117,15,176,105,70,229,4,234,76,45,31,140,85,58,245,234,248,83,203,156,69,125,129,1,140,54,226,244,79,90,31,166,10,203,140,95,129,83,13,156,193,215,169,74,52,113,223,86,144,77,221,9,28,152,1,99,202,110,68,167,244,8,118,239,230,122,221,130,253,26,111,163,33,226,24,98,35,253,230,127,56,253,230,148,181,50,67,103,38,203,30,212,185,25,249,112,87,112,217,206,119,31,27,222,254,21,46,229,36,168,223,221,134,118,255,108,41,241,196,24,252,251,151,121,214,18,167,53,139,153,26,197,194,136,247,220,249,43,54,189,238,154,54,23,40,5,159,198,171,12,38,204,137,171,163,211,204,166,120,185,135,245,254,243,60,205,189,97,214,14,11,98,100,4,149,52,22,226,81,102,0,241,80,83,136,20,32,149,186,88,186,92,175,87,154,109,16,18,59,53,75,198,164,69,236,93,168,224,49,11,242,185,234,220,102,155,158,57,85,161,128,221,185,41,74,160,81,187,10,19,92,249,222,97,52,29,106,5,244,105,115,128,245,99,214,200,211,85,168,11,30,102,211,175,71,232,96,133,106,212,77,109,33,34,229,102,105,180,247,222,210,237,116,252,91,217,162,100,34,1,83,102,232,227,155,187,112,73,248,39,232,15,61,170,40,121,88,188,207,224,221,242,249,117,167,18,7,145,149,118,4,195,168,149,183,125,36,138,188,7,208,16,67,132,149,1,233,107,249,246,91,232,5,147,111,201,252,166,219,133,197,86,110,245,203,81,247,67,35,56,219,144,30,162,203,116,4,111,214,8,115,177,38,139,142,242,84,130,25,100,72,166,21,71,173,120,210,170,233,254,140,132,52,100,108,41,49,173,251,53,113,18,73,87,122,206,95,225,223,47,231,127,236,52,65,241,46,154,146,132,63,107,0,247,182,54,31,80,107,183,51,91,254,104,81,156,6,62,200,176,195,34,242,4,154,96,223,28,65,193,89,155,59,172,73,161,77,209,246,86,10,26,103,61,185,6,245,246,209,214,83,172,54,252,140,255,198,56,175,120,192,22,53,189,170,194,162,206,111,132,197,147,129,236,214,176,207,205,126,47,36,117,235,102,80,251,163,33,4,159,232,171,20,107,9,112,82,176,132,29,74,207,54,63,92,199,53,12,112,110,160,230,86,243,105,99,130,24,125,92,91,19,124,135,8,20,47,18,63,71,159,160,208,111,177,88,56,73,95,209,132,179,58,219,75,123,31,27,156,177,171,116,131,185,244,13},
  {153,252,60,73,254,33,165,194,5,0,217,210,185,206,129,148,144,187,129,44,98,40,213,202,53,95,174,235,196,179,226,109,194,155,59,184,124,227,117,11,219,113,235,82,233,172,35,245,209,148,168,183,131,22,27,116,49,231,7,120,60,246,183,209,65,225,250,246,36,58,253,175,231,60,18,242,199,208,7,126,178,63,76,190,41,159,60,81,5,108,212,15,71,142,181,152,128,52,165,45,227,165,102,52,148,136,130,63,127,229,104,26,145,58,177,42,222,216,184,97,31,163,225,159,198,156,255,184,140,176,155,2,69,220,50,166,127,220,183,124,39,241,46,221,86,85,187,225,225,205,86,17,103,187,30,248,46,172,99,233,170,49,181,218,53,69,182,93,131,78,62,112,78,30,32,90,122,204,183,226,100,132,254,67,86,56,64,197,167,46,126,221,25,7,207,9,183,237,236,84,12,97,138,218,27,171,100,178,198,32,68,112,67,144,244,50,245,44,92,224,127,106,155,149,185,104,158,204,220,140,67,189,84,214,136,152,13,130,25,70,52,109,149,59,224,135,10,124,92,86,162,193,37,250,5,56,111,136,252,171,55,27,203,81,182,225,74,5,91,80,242,74,204,210,42,149,102,176,249,105,134,164,11,6,135,190,54,238,49,44,204,181,9,233,16,166,132,91,21,199,200,109,121,100,234,188,209,116,194,155,119,144,59,190,122,57,96,135,245,86,225,238,161,35,229,142,251,196,3,130,9,201,160,87,178,68,5,61,239,191,125,170,34,170,5,207,211,149,57,146,26,189,246,12,7,213,22,117,25,63,206,202,94,52,31,179,31,174,255,182,116,153,95,118,84,126,233,2,5,92,22,233,28,120,81,246,164,226,206,191,167,90,200,244,174,32,153,40,204,251,125,230,85,88,10,89,183,242,194,161,162,148,199,2,242,66,195,21,96,193,143,64,230,244,68,239,187,149,64,188,58,131,37,157,66,185,124,38,202,31,216,132,125,192,174,133,234,3,111,98,79,30,115,138,33,182,190,174,166,93,123,254,127,102,130,132,79,253,98,145,198,83,160,6,158,176,117,233,241,29,80,68,42,206,90,223,121,64,183,63,160,1,125,153,204,114,192,222,69,98,254,72,210,181,106,254,182,124,110,65,158,34,139,150,147,226,91,242,110,209,66,103,39,13,87,143,158,60,207,212,9,22,189,23,170,142,20,25,61,101,106,210,58,239,9,55,54,169,176,106,168,99,9,238,165,127,44,79,233,167,65,93,199,128,226,134,71,92,15,196,60,134,216,19,75,173,218,14,239,14,177,132,152,237,102,53,117,141,78,1,77,42,185,143,142,7,126,17,92,186,95,120,150,5,234,236,4,87,92,180,160,40,207,106,55,7,108,246,13,96,160,116,19,225,68,73,75,222,206,84,151,74,15,212,147,89,143,80,247,161,79,163,37,166,116,163,239,133,102,99,140,118,168,212,116,152,120,49,124,27,82,93,82,99,154,102,117,169,111,135,58,243,16,213,108,35,82,46,136,216,4,73,236,15,134,87,102,215,109,167,210,122,223,59,56,157,233,205,39,66,205,39,42,117,47,1,195,177,95,207,138,172,1,160,62,96,197,76,68,172,248,69,55,160,206,225,225,120,177,252,105,0,34,93,175,50,207,20,241,176,140,202,12,83,10,26,50,51,48,81,244,252,193,114,253,160,171,177,228,64,18,118,77,241,85,148,114,113,136,192,75,28,22,237,139,224,4,68,51,84,121,44,179,182,214,54,148,9,89,239,93,182,14,250,177,12,153,155,201,170,35,21,71,127,104,98,95,107,16,60,185,243,225,58,94,5,216,201,104,181,155,1,26,29,56,247,54,249,75,56,107,72,123,32,72,122,245,4,182,1,102,125,203,44,252,175,61,218,88,18,152,126,43,15,29,100,80},
  {131,168,23,205,243,142,51,90,231,192,16,160,56,89,54,129,90,176,180,254,42,80,118,226,79,16,190,216,71,17,249,200,178,154,185,101,223,47,24,170,94,215,214,53,131,42,185,101,237,183,132,40,224,150,233,212,2,151,144,44,34,112,72,175,55,252,212,64,195,215,80,132,133,142,122,39,195,93,116,250,197,215,251,232,53,131,75,101,78,51,54,181,220,222,132,56,209,16,138,203,23,179,75,95,72,97,44,165,134,83,112,4,190,25,30,73,151,202,87,233,207,71,22,103,140,14,173,237,204,64,18,30,98,66,17,39,83,110,189,63,248,190,18,252,44,89,5,137,191,109,134,87,132,190,5,164,71,74,46,41,102,222,129,174,129,129,30,238,154,201,125,165,236,29,10,126,181,97,182,210,143,10,136,111,85,115,133,14,227,38,48,62,122,127,67,203,76,31,72,191,120,211,73,141,255,200,100,152,37,128,75,217,158,185,158,219,190,47,5,242,85,120,46,155,33,52,171,76,148,228,158,152,218,72,18,79,246,180,33,232,223,146,65,225,105,103,100,144,128,48,6,216,190,59,8,110,187,13,114,163,240,47,169,233,199,202,89,230,148,65,249,254,23,218,33,208,38,238,84,15,70,134,165,86,112,191,65,172,158,41,233,168,81,107,46,66,94,64,23,129,236,110,222,66,64,192,143,220,34,196,24,202,81,233,211,38,141,44,47,36,100,195,158,151,208,114,73,47,36,63,174,79,103,162,97,236,26,38,6,141,50,57,218,125,59,55,70,72,177,61,36,11,223,137,40,46,4,20,3,10,115,224,255,104,102,123,179,240,115,104,209,131,69,138,101,51,58,58,204,27,35,222,82,122,95,95,165,202,69,220,1,47,86,224,82,21,221,144,234,219,43,107,237,140,153,252,141,98,79,61,32,243,65,24,27,20,155,69,157,175,210,146,117,199,7,228,192,170,169,126,204,34,191,74,51,235,188,57,67,102,242,20,92,239,111,188,158,20,244,127,203,46,137,148,48,175,180,122,118,229,84,242,27,56,184,139,156,158,223,180,121,105,145,232,172,196,19,52,115,211,42,208,131,100,149,194,114,189,128,35,98,83,41,68,143,45,83,157,122,183,216,176,91,105,189,34,187,160,94,42,234,145,229,4,127,179,95,53,147,253,199,86,48,229,20,130,7,128,104,241,12,65,67,124,202,224,159,96,3,251,152,5,68,181,74,215,168,40,42,128,152,141,73,36,197,224,205,148,251,120,63,62,16,255,245,98,147,108,60,243,119,163,158,95,67,114,222,180,42,197,223,96,153,44,168,2,56,228,93,55,193,161,7,158,108,132,131,199,108,41,180,211,251,43,61,226,116,246,64,79,186,176,149,39,125,150,113,210,93,205,182,181,181,10,35,130,88,170,165,108,157,197,105,214,119,44,149,246,162,22,185,215,52,173,250,36,2,8,30,148,124,71,150,224,69,118,114,62,106,125,27,110,167,104,148,7,231,46,177,112,234,10,94,204,239,22,237,25,12,159,174,97,43,234,78,86,51,182,124,194,6,176,119,201,206,53,146,92,94,228,104,27,48,34,134,134,111,63,24,238,233,108,171,68,102,36,35,229,137,110,56,119,67,76,220,94,8,131,192,123,210,121,186,49,211,31,140,179,210,183,230,67,248,97,58,62,20,134,166,93,46,226,82,12,94,230,65,170,129,176,150,94,103,170,9,59,19,55,35,79,137,210,242,99,4,135,155,138,253,239,117,55,14,39,250,56,177,78,111,79,156,225,248,121,76,211,35,185,156,254,57,211,221,152,252,100,55,158,179,231,219,205,150,88,54,187,84,95,175,41,33,195,227,201,103,175,70,195,168,32,32,219,28,243,11,205,83,197,54,14,9,208,136,24,12,18,31,226,162,251,76,146,203,17,136,59,174},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
  {0,1,0,0,0,255,1,0,0,0,255,1,0,0,0,0,0,0,255,0,0,0,255,0,1,0,0,1,0,0,0,0,1,255,255,0,0,0,1,1,0,0,255,0,1,0,1,0,1,0,0,0,255,0,0,1,1,0,1,255,0,0,0,0,0,0,255,1,1,255,255,0,1,0,0,0,255,0,0,1,1,255,0,1,0,255,255,0,0,0,0,0,1,0,0,0,0,0,0,255,0,0,255,255,0,255,0,255,0,255,0,255,0,1,1,0,255,1,0,255,0,0,0,255,1,0,0,0,0,0,0,0,0,1,0,0,255,0,0,1,0,1,1,0,0,1,0,0,0,0,255,0,0,0,255,0,0,255,1,1,0,0,0,0,1,0,0,0,0,255,255,1,0,0,0,255,0,255,0,0,0,0,0,0,0,1,0,0,0,0,255,0,0,1,0,0,0,0,0,0,0,0,255,0,0,0,0,1,1,0,1,0,1,0,0,0,255,0,0,255,0,255,1,0,0,255,0,255,0,0,0,0,0,1,0,1,0,0,1,0,255,255,255,255,0,1,0,1,1,0,255,0,0,0,0,0,255,0,255,0,255,1,1,1,0,1,0,0,0,0,1,255,0,255,0,1,0,1,0,0,1,0,0,255,255,1,1,1,0,255,0,1,0,1,0,0,1,0,255,0,0,0,1,255,0,1,0,0,0,255,0,1,0,0,0,0,0,0,1,0,1,255,0,0,0,255,1,0,0,0,0,1,0,0,255,255,1,0,255,0,0,1,255,0,0,1,0,0,1,0,1,1,0,1,0,255,0,255,0,0,0,0,0,0,1,0,255,0,0,0,0,0,1,0,0,0,0,1,0,0,0,255,0,255,1,0,0,0,255,0,0,1,0,0,0,1,0,0,0,1,255,1,0,1,1,0,0,0,0,0,255,255,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,1,1,0,0,0,0,255,0,255,1,0,1,1,0,0,0,0,0,0,255,0,0,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,255,0,0,0,0,0,0,255,1,0,0,0,0,255,0,0,0,1,255,1,0,0,255,0,0,255,0,255,255,0,0,0,255,255,1,255,0,0,0,1,1,255,0,1,1,0,0,0,0,0,0,0,1,0,255,0,255,255,255,1,0,0,0,1,0,0,0,0,0,1,0,0,0,1,1,255,0,0,0,0,1,0,0,0,0,0,0,1,0,255,255,0,255,0,0,255,0,255,0,255,0,0,0,0,1,0,1,1,1,1,0,1,1,0,0,1,0,0,0,0,0,0,1,0,0,0,255,0,0,1,0,1,0,0,0,0,0,255,0,0,0,255,0,0,0,255,0,0,255,0,255,255,0,0,0,0,0,1,1,0,1,255,255,0,255,0,1,255,0,0,255,255,1,1,1,0,0,0,0,0,1,0,255,0,0,0,0,255,0,0,0,1,0,255,0,255,255,1,1,0,1,0,0,0,0,0,1,1,0,0,1,255,0,0,0,0,0,0,0,1,0,0,1,0,0,1,1,0,0,255,1,255,1,0,1,255,0,0,1,0,0,255,255,0,255,0,255,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,255,1,0,0,0,255,1,0,1,0,1,0,1,0,0,0,1,0,0,0,1,0,255,0,0,255,255,0,1,0,1,0,1,1,255,0,0,0,1,255,255,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,255,0,0,0,1,255,255,0,255,0,0,255,0,1,0,0,255,1,0,0,255,0,0,0,1,255,0,255,1,255,255,0,0,0,0,0,0,255,1,0,0,1,0,0,1,255,0,0,255,255,255,0,1,0,0,0,0,1,0},
  {1,0,1,1,0,0,0,255,1,0,0,255,255,0,0,0,0,0,0,0,255,0,0,0,0,0,255,0,255,0,0,0,0,1,1,1,0,0,1,255,0,0,0,1,0,1,255,0,0,1,1,0,255,0,0,0,0,0,0,0,1,255,1,255,0,0,0,0,0,1,0,1,255,0,255,255,255,0,0,1,1,0,255,1,255,0,255,0,0,0,0,0,1,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,1,255,1,255,0,255,0,0,0,1,255,0,1,0,255,255,1,1,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,255,0,1,0,0,1,0,0,0,0,255,0,255,0,0,255,0,0,0,0,0,0,255,0,0,1,0,0,1,0,0,0,0,255,255,0,255,1,1,0,1,0,0,255,0,0,0,0,0,0,0,1,0,0,255,255,0,0,1,255,0,0,0,0,1,0,0,0,255,0,0,0,1,0,0,0,0,1,0,255,1,0,0,0,255,0,0,255,0,1,0,1,0,0,1,255,0,255,0,0,1,1,255,255,0,255,0,1,0,0,255,1,0,0,0,1,1,1,0,1,0,255,0,0,0,255,0,255,0,0,0,0,0,0,255,0,0,0,255,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,1,0,0,255,255,0,0,255,0,0,255,0,255,0,255,255,1,0,255,0,0,0,0,1,0,255,0,0,0,0,255,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,255,0,0,255,0,0,255,1,0,0,255,1,0,255,0,0,0,0,0,0,0,0,255,1,0,0,255,0,0,0,1,1,1,1,255,0,0,0,1,0,0,0,0,255,0,0,0,0,255,0,0,0,0,0,255,0,1,0,0,0,0,0,0,0,0,255,255,0,1,0,0,0,0,0,255,0,1,1,255,0,0,0,0,0,0,0,0,255,1,255,0,0,1,0,255,0,0,0,0,0,255,255,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,1,1,255,0,0,1,0,0,255,0,255,1,0,255,0,0,0,1,0,0,0,0,1,0,0,1,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,255,0,1,0,255,255,1,0,0,0,0,0,1,1,0,0,0,0,0,0,255,255,1,255,1,255,255,0,0,0,255,0,1,1,255,0,0,0,0,0,255,1,0,255,1,0,1,0,0,255,0,0,0,255,255,0,255,0,255,255,1,1,0,0,0,0,255,0,0,1,255,0,255,0,255,0,0,1,0,1,0,255,1,1,0,1,1,255,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,1,255,0,0,255,1,1,1,1,0,1,0,255,0,1,0,0,0,0,0,0,255,1,0,0,0,0,1,255,255,255,1,0,255,0,1,0,0,255,1,0,0,0,0,0,255,0,0,1,0,0,0,0,0,1,0,0,0,1,255,0,255,0,0,0,0,0,255,0,0,0,0,255,0,0,0,0,0,0,1,0,0,0,1,0,255,1,0,0,0,0,0,0,1,1,1,1,0,1,0,0,255,0,1,0,0,0,0,1,0,1,1,255,1,255,255,1,1,1,0,0,0,0,0,0,255,1,0,1,255,255,0,255,255,0,0,1,1,1,0,255,0,1,0,0,255,255,1,0,1,1,1,0,0,255,0,0,0,0,0,0,1,1,1,255,0,0,255,0,0,255,1,0,0,0,255,255,0,0,0,0,0,1,0,1,0,0,1,255,255,0,0,255,0,1,255,0,1,0,0,0,1,1,0,0,255,0,0,255,255,1,0,0,0,0,255,0,0,0,255,0,0,0,1,0,0,0,255,0,0,1,255,0,0,0,1,0,0,0,0,0},
  {0,0,0,255,0,255,0,255,0,0,0,1,0,0,0,0,255,0,255,0,0,1,0,1,1,255,1,255,0,0,0,1,255,255,0,0,1,0,255,1,0,255,0,1,0,1,0,0,0,0,0,0,255,0,0,1,255,0,0,0,0,0,0,0,1,255,1,0,0,0,0,255,255,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,255,255,0,255,0,0,0,0,0,255,0,0,255,0,1,0,0,0,0,0,0,0,0,1,255,0,1,255,0,0,0,255,0,1,0,0,0,0,255,255,0,0,0,255,0,0,0,1,1,0,255,1,1,0,0,0,0,0,0,0,1,0,255,1,0,1,0,0,0,255,255,255,0,0,0,255,1,0,0,0,0,0,1,0,1,0,0,0,255,255,0,255,0,0,1,0,0,1,255,0,0,0,0,0,255,0,255,0,0,1,1,1,255,255,0,1,0,1,255,0,1,0,0,0,0,1,255,0,1,0,0,255,1,0,255,255,1,0,255,0,0,1,1,0,1,0,0,0,0,0,1,0,255,0,255,0,0,255,1,0,0,0,0,0,0,1,1,0,0,0,0,255,0,0,1,0,255,0,0,255,0,0,1,0,255,1,0,255,0,0,0,0,0,0,0,0,0,1,0,0,255,0,255,0,0,1,0,0,255,0,0,0,1,0,0,255,0,0,0,0,0,255,0,1,0,0,255,0,255,0,0,0,0,1,0,1,0,0,1,0,255,0,0,0,0,0,0,0,255,1,255,0,0,0,0,1,255,0,0,0,0,255,0,0,0,1,0,0,255,1,0,1,0,255,0,255,1,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,255,0,1,1,255,0,0,1,0,0,0,0,0,255,1,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0,255,0,255,255,0,0,0,255,255,0,255,0,0,255,0,1,0,0,0,1,255,0,0,0,255,255,1,1,0,0,0,255,1,0,0,0,0,0,0,255,1,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,255,1,255,0,1,0,1,1,255,0,0,0,0,255,0,255,255,1,1,0,0,0,1,0,1,0,1,1,255,0,0,0,1,0,0,1,0,255,0,255,0,0,0,255,0,0,0,0,0,0,0,0,255,0,255,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,0,1,255,0,0,0,0,0,0,1,1,0,0,255,0,255,0,0,0,0,255,255,0,1,1,0,0,0,0,255,0,0,0,255,0,0,0,255,1,0,0,255,0,0,255,1,255,0,0,255,0,0,0,0,0,1,255,0,255,1,255,0,0,1,1,1,1,255,0,0,0,1,0,1,1,255,0,0,0,0,0,0,0,255,0,0,255,0,0,1,255,0,0,0,0,0,255,0,0,0,0,1,0,1,1,1,0,0,255,0,0,0,0,0,255,0,0,255,0,255,0,0,0,0,0,255,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,255,0,255,0,0,0,0,1,1,1,0,0,0,0,255,0,0,0,0,1,1,255,1,0,255,0,0,0,0,1,0,255,0,0,255,0,255,255,0,0,255,0,1,1,1,0,0,1,0,0,0,0,0,255,255,0,0,1,0,255,0,255,0,0,0,1,1,1,0,0,1,0,255,255,255,255,0,1,255,255,0,0,255,0,0,255,0,1,0,255,255,0,0,0,0,255,0,0,0,1,1,0,1,255,1,0,1,1,0,1,0,255,0,1,255,0,1,255,0,255,1,255,255,0,0,0,0,255,0,0,0,255,0,0,0,0,0,255,0,0,255,0,0,255,0,0,255,0,255,0,255,255,0,1,0,1,1,1,255,255,0},
} ;

static const unsigned char precomputed_core_weightsntrup857_k[precomputed_core_weightsntrup857_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_weightsntrup857_c[precomputed_core_weightsntrup857_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
} ;

static void test_core_weightsntrup857_impl(long long impl)
{
  unsigned char *h = test_core_weightsntrup857_h;
  unsigned char *n = test_core_weightsntrup857_n;
  unsigned char *k = test_core_weightsntrup857_k;
  unsigned char *c = test_core_weightsntrup857_c;
  unsigned char *h2 = test_core_weightsntrup857_h2;
  unsigned char *n2 = test_core_weightsntrup857_n2;
  unsigned char *k2 = test_core_weightsntrup857_k2;
  unsigned char *c2 = test_core_weightsntrup857_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_weightsntrup857_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_weightsntrup857(impl);
    printf("core_weightsntrup857 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_weightsntrup857_implementation(impl),ntruprime_dispatch_core_weightsntrup857_compiler(impl));
  } else {
    crypto_core = ntruprime_core_weightsntrup857;
    printf("core_weightsntrup857 selected implementation %s compiler %s\n",ntruprime_core_weightsntrup857_implementation(),ntruprime_core_weightsntrup857_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    checksum_expected(core_weightsntrup857_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_weightsntrup857_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_weightsntrup857_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_weightsntrup857_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_weightsntrup857_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_weightsntrup857_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_weightsntrup857_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_weightsntrup857_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_weightsntrup857_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_weightsntrup857_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_weightsntrup857(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"weightsntrup857")) return;
  storage_core_weightsntrup857_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_weightsntrup857_h = aligned(storage_core_weightsntrup857_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_weightsntrup857_n = callocplus(crypto_core_INPUTBYTES);
  test_core_weightsntrup857_n = aligned(storage_core_weightsntrup857_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_weightsntrup857_k = callocplus(crypto_core_KEYBYTES);
  test_core_weightsntrup857_k = aligned(storage_core_weightsntrup857_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_weightsntrup857_c = callocplus(crypto_core_CONSTBYTES);
  test_core_weightsntrup857_c = aligned(storage_core_weightsntrup857_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_weightsntrup857_h2 = callocplus(maxalloc);
  test_core_weightsntrup857_h2 = aligned(storage_core_weightsntrup857_h2,crypto_core_OUTPUTBYTES);
  storage_core_weightsntrup857_n2 = callocplus(maxalloc);
  test_core_weightsntrup857_n2 = aligned(storage_core_weightsntrup857_n2,crypto_core_INPUTBYTES);
  storage_core_weightsntrup857_k2 = callocplus(maxalloc);
  test_core_weightsntrup857_k2 = aligned(storage_core_weightsntrup857_k2,crypto_core_KEYBYTES);
  storage_core_weightsntrup857_c2 = callocplus(maxalloc);
  test_core_weightsntrup857_c2 = aligned(storage_core_weightsntrup857_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_weightsntrup857 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_weightsntrup857();++impl)
      forked(test_core_weightsntrup857_impl,impl);
    ++test_core_weightsntrup857_h;
    ++test_core_weightsntrup857_n;
    ++test_core_weightsntrup857_k;
    ++test_core_weightsntrup857_c;
    ++test_core_weightsntrup857_h2;
    ++test_core_weightsntrup857_n2;
    ++test_core_weightsntrup857_k2;
    ++test_core_weightsntrup857_c2;
  }
  free(storage_core_weightsntrup857_c2);
  free(storage_core_weightsntrup857_k2);
  free(storage_core_weightsntrup857_n2);
  free(storage_core_weightsntrup857_h2);
  free(storage_core_weightsntrup857_c);
  free(storage_core_weightsntrup857_k);
  free(storage_core_weightsntrup857_n);
  free(storage_core_weightsntrup857_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

