
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file EpsWindAttributes.h
    \\brief Definition of EpsWind Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "EpsWindWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



EpsWindWrapper::EpsWindWrapper(): epswind_(new EpsWind())


{


	

}
EpsWindWrapper::EpsWindWrapper(EpsWind* epswind): epswind_(epswind)
{

	
}

EpsWindWrapper::~EpsWindWrapper()
{

}

void EpsWindWrapper::set(const MagRequest& request)
{

	

	if  (request.countValues("EPS_ROSE_WIND_CONVENTION") ) {
		string convention_value = request("EPS_ROSE_WIND_CONVENTION");
		epswind_->convention_ = convention_value;
		}
	if  (request.countValues("LEGEND") ) {
		string legend_value = request("LEGEND");
		
		epswind_->legend_ = MagTranslator<string, bool>()(legend_value);
		
		}
	
	if  (request.countValues("EPS_ROSE_WIND_COLOUR") ) {
		string colour_value = request("EPS_ROSE_WIND_COLOUR");
		epswind_->colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(colour_value));
	}
		
	if  (request.countValues("EPS_ROSE_WIND_BORDER_COLOUR") ) {
		string border_colour_value = request("EPS_ROSE_WIND_BORDER_COLOUR");
		epswind_->border_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(border_colour_value));
	}
		
	
}

void EpsWindWrapper::print(ostream& out)  const
{
	out << "EpsWindWrapper[]";
}




