*
* $Id: fxg360.F,v 1.1.1.3 1996/11/15 17:32:44 cernlib Exp $
*
* $Log: fxg360.F,v $
* Revision 1.1.1.3  1996/11/15 17:32:44  cernlib
* Import version 7.06
*
* Revision 1.2  1996/11/15 15:07:04  pdflib
* Version 7.06: tabs removed and bug fixed in grsgalo
*
* Revision 1.1.1.1  1996/04/12 15:29:18  plothow
* Version 7.01
*
*
#include "pdf/pilot.h"
C
C------------------------------------------------------------
C------------- Subroutine to compute a point in x and q**2 --
C------------- for the following parton distributions :    --
C------------- UP Valence, DOWN Valence , GLUON , QBAR ,   --
C------------- UBAR , Strange , Charm , Bottom , Top .     --
C------------- Range of validity :                         --
C-------------                     5.E-05 < x < .95        --
C-------------                     1      <Log10 Q**2 < 8  --
C------------------------------------------------------------
C-------------        Authors :    M. Diemoz
C-------------                     F. Ferroni
C-------------                     E. Longo
C-------------                     G. Martinelli
C------------------------------------------------------------
      SUBROUTINE  FXG360(X,QSTAR2,STRFUN,FUNC)
C------------------------------------------------------------
C-------------   X is x and QSTAR2 is Q square  -------------
      CHARACTER*(*) STRFUN
C------------------------------------------------------------
C------------ STRFUN specifies the desired function----------
C------------------------------------------------------------
C------------------------------------------------------------
C        IFUN =  1     UP valence      'UPVAL'
C                2     DOWN valence    'DOVAL'
C                3     Gluon           'GLUON'
C                4     Q bar           'QBAR '
C                5     UP bar          'UBAR '
C                6     Strange         'SBAR '
C                7     Charm           'CBAR '
C                8     Bottom          'BBAR '
C                9     Top             'TBAR '
C------------------------------------------------------------
C-------------  FUNC is the output (parton density value)----
C------------------------------------------------------------
      PARAMETER (IX=104,IQ=9,NARG=2,KFUN=9)
C------------------------------------------------------------
C-----------Input tables are given as 104 x points at 9 Q**2
C-----------positions (log spaced in Q**2 and x up to .6
C-----------(90 points). The remaining 14 x points are ------
C----------linearly spaced)----------------------------------
C------------------------------------------------------------
      DIMENSION ARG(NARG),NENT(NARG),ENT(IX+IQ)
      DIMENSION XQDUM(IX,IQ,KFUN)
      DIMENSION Q2(IQ),XCO(IX)
C------------------------------------------------------------
C----------- Next the 9 Q**2 of the input tables are defined
C------------------------------------------------------------
      DATA Q2 /10.,30.,100.,1000.,10000.,100000.,1000000,
     +         10000000.,100000000./
C----------------------------------------------------------------
C----------- And now the 104 x positions ------------------------
C----------------------------------------------------------------
      DATA XCO   /
     +0.5000E-04,0.5545E-04,0.6150E-04,0.6820E-04,0.7564E-04,0.8389E-04,
     +0.9303E-04,0.1032E-03,0.1144E-03,0.1269E-03,0.1407E-03,0.1561E-03,
     +0.1731E-03,0.1920E-03,0.2129E-03,0.2361E-03,0.2619E-03,0.2904E-03,
     +0.3221E-03,0.3572E-03,0.3961E-03,0.4393E-03,0.4872E-03,0.5404E-03,
     +0.5993E-03,0.6646E-03,0.7371E-03,0.8174E-03,0.9066E-03,0.1005E-02,
     +0.1115E-02,0.1237E-02,0.1371E-02,0.1521E-02,0.1687E-02,0.1871E-02,
     +0.2075E-02,0.2301E-02,0.2552E-02,0.2830E-02,0.3139E-02,0.3481E-02,
     +0.3860E-02,0.4281E-02,0.4748E-02,0.5266E-02,0.5840E-02,0.6476E-02,
     +0.7182E-02,0.7966E-02,0.8834E-02,0.9797E-02,0.1087E-01,0.1205E-01,
     +0.1336E-01,0.1482E-01,0.1644E-01,0.1823E-01,0.2022E-01,0.2242E-01,
     +0.2487E-01,0.2758E-01,0.3058E-01,0.3392E-01,0.3762E-01,0.4172E-01,
     +0.4627E-01,0.5131E-01,0.5690E-01,0.6311E-01,0.6999E-01,0.7762E-01,
     +0.8608E-01,0.9547E-01,0.1059E+00,0.1174E+00,0.1302E+00,0.1444E+00,
     +0.1602E+00,0.1776E+00,0.1970E+00,0.2185E+00,0.2423E+00,0.2687E+00,
     +0.2980E+00,0.3305E+00,0.3666E+00,0.4065E+00,0.4508E+00,0.5000E+00,
     +0.5321E+00,0.5643E+00,0.5964E+00,0.6286E+00,0.6607E+00,0.6929E+00,
     +0.7250E+00,0.7571E+00,0.7893E+00,0.8214E+00,0.8536E+00,0.8857E+00,
     +0.9179E+00,0.9500E+00/
      DATA (XQDUM (I,1,1),I=1,104) /
     +0.1154E-01,0.1220E-01,0.1290E-01,0.1363E-01,0.1441E-01,0.1523E-01,
     +0.1610E-01,0.1702E-01,0.1799E-01,0.1901E-01,0.2010E-01,0.2124E-01,
     +0.2245E-01,0.2373E-01,0.2509E-01,0.2652E-01,0.2803E-01,0.2962E-01,
     +0.3131E-01,0.3309E-01,0.3498E-01,0.3697E-01,0.3908E-01,0.4130E-01,
     +0.4365E-01,0.4613E-01,0.4876E-01,0.5153E-01,0.5445E-01,0.5755E-01,
     +0.6082E-01,0.6427E-01,0.6791E-01,0.7176E-01,0.7583E-01,0.8012E-01,
     +0.8465E-01,0.8943E-01,0.9448E-01,0.9981E-01,0.1054E+00,0.1114E+00,
     +0.1176E+00,0.1242E+00,0.1311E+00,0.1385E+00,0.1462E+00,0.1543E+00,
     +0.1628E+00,0.1718E+00,0.1812E+00,0.1912E+00,0.2016E+00,0.2125E+00,
     +0.2239E+00,0.2359E+00,0.2484E+00,0.2615E+00,0.2751E+00,0.2893E+00,
     +0.3040E+00,0.3193E+00,0.3350E+00,0.3513E+00,0.3679E+00,0.3850E+00,
     +0.4023E+00,0.4198E+00,0.4373E+00,0.4548E+00,0.4719E+00,0.4886E+00,
     +0.5045E+00,0.5193E+00,0.5326E+00,0.5440E+00,0.5530E+00,0.5591E+00,
     +0.5617E+00,0.5601E+00,0.5538E+00,0.5421E+00,0.5243E+00,0.5002E+00,
     +0.4693E+00,0.4318E+00,0.3881E+00,0.3390E+00,0.2860E+00,0.2312E+00,
     +0.1982E+00,0.1679E+00,0.1404E+00,0.1157E+00,0.9371E-01,0.7442E-01,
     +0.5769E-01,0.4337E-01,0.3133E-01,0.2144E-01,0.1357E-01,0.7621E-02,
     +0.3496E-02,0.1057E-02/
      DATA (XQDUM (I,1,2),I=1,104) /
     +0.6591E-02,0.6967E-02,0.7364E-02,0.7784E-02,0.8228E-02,0.8697E-02,
     +0.9193E-02,0.9717E-02,0.1027E-01,0.1086E-01,0.1147E-01,0.1213E-01,
     +0.1282E-01,0.1355E-01,0.1432E-01,0.1514E-01,0.1600E-01,0.1691E-01,
     +0.1787E-01,0.1889E-01,0.1997E-01,0.2110E-01,0.2230E-01,0.2357E-01,
     +0.2491E-01,0.2632E-01,0.2782E-01,0.2940E-01,0.3107E-01,0.3283E-01,
     +0.3469E-01,0.3665E-01,0.3872E-01,0.4091E-01,0.4322E-01,0.4566E-01,
     +0.4823E-01,0.5095E-01,0.5381E-01,0.5683E-01,0.6001E-01,0.6336E-01,
     +0.6689E-01,0.7061E-01,0.7453E-01,0.7864E-01,0.8297E-01,0.8752E-01,
     +0.9230E-01,0.9732E-01,0.1026E+00,0.1081E+00,0.1138E+00,0.1199E+00,
     +0.1262E+00,0.1327E+00,0.1395E+00,0.1466E+00,0.1539E+00,0.1615E+00,
     +0.1693E+00,0.1773E+00,0.1854E+00,0.1938E+00,0.2022E+00,0.2106E+00,
     +0.2191E+00,0.2274E+00,0.2355E+00,0.2433E+00,0.2506E+00,0.2573E+00,
     +0.2633E+00,0.2682E+00,0.2719E+00,0.2741E+00,0.2746E+00,0.2731E+00,
     +0.2694E+00,0.2630E+00,0.2539E+00,0.2419E+00,0.2269E+00,0.2088E+00,
     +0.1881E+00,0.1651E+00,0.1404E+00,0.1149E+00,0.8969E-01,0.6600E-01,
     +0.5296E-01,0.4178E-01,0.3235E-01,0.2453E-01,0.1816E-01,0.1305E-01,
     +0.9059E-02,0.6015E-02,0.3770E-02,0.2186E-02,0.1134E-02,0.4973E-03,
     +0.1640E-03,0.3020E-04/
      DATA (XQDUM (I,1,3),I=1,104) /
     +0.3367E+02,0.3244E+02,0.3126E+02,0.3012E+02,0.2903E+02,0.2797E+02,
     +0.2695E+02,0.2597E+02,0.2502E+02,0.2411E+02,0.2324E+02,0.2239E+02,
     +0.2158E+02,0.2079E+02,0.2003E+02,0.1931E+02,0.1860E+02,0.1793E+02,
     +0.1727E+02,0.1665E+02,0.1604E+02,0.1546E+02,0.1490E+02,0.1436E+02,
     +0.1383E+02,0.1333E+02,0.1285E+02,0.1238E+02,0.1193E+02,0.1150E+02,
     +0.1108E+02,0.1068E+02,0.1029E+02,0.9914E+01,0.9554E+01,0.9206E+01,
     +0.8871E+01,0.8548E+01,0.8236E+01,0.7935E+01,0.7645E+01,0.7365E+01,
     +0.7095E+01,0.6834E+01,0.6582E+01,0.6338E+01,0.6103E+01,0.5876E+01,
     +0.5655E+01,0.5442E+01,0.5236E+01,0.5036E+01,0.4842E+01,0.4654E+01,
     +0.4471E+01,0.4293E+01,0.4119E+01,0.3951E+01,0.3786E+01,0.3625E+01,
     +0.3467E+01,0.3313E+01,0.3161E+01,0.3013E+01,0.2866E+01,0.2722E+01,
     +0.2580E+01,0.2439E+01,0.2301E+01,0.2163E+01,0.2028E+01,0.1893E+01,
     +0.1760E+01,0.1628E+01,0.1499E+01,0.1370E+01,0.1244E+01,0.1121E+01,
     +0.1001E+01,0.8836E+00,0.7708E+00,0.6630E+00,0.5609E+00,0.4653E+00,
     +0.3772E+00,0.2974E+00,0.2267E+00,0.1657E+00,0.1149E+00,0.7438E-01,
     +0.5489E-01,0.3975E-01,0.2816E-01,0.1944E-01,0.1301E-01,0.8390E-02,
     +0.5165E-02,0.3001E-02,0.1618E-02,0.7887E-03,0.3339E-03,0.1143E-03,
     +0.2737E-04,0.0000E+00/
      DATA (XQDUM (I,1,4),I=1,104) /
     +0.6996E+00,0.6996E+00,0.6994E+00,0.6994E+00,0.6994E+00,0.6992E+00,
     +0.6993E+00,0.6992E+00,0.6990E+00,0.6989E+00,0.6988E+00,0.6987E+00,
     +0.6985E+00,0.6983E+00,0.6981E+00,0.6980E+00,0.6977E+00,0.6974E+00,
     +0.6972E+00,0.6968E+00,0.6965E+00,0.6961E+00,0.6957E+00,0.6952E+00,
     +0.6947E+00,0.6941E+00,0.6935E+00,0.6928E+00,0.6920E+00,0.6911E+00,
     +0.6902E+00,0.6891E+00,0.6879E+00,0.6866E+00,0.6852E+00,0.6836E+00,
     +0.6818E+00,0.6799E+00,0.6777E+00,0.6754E+00,0.6727E+00,0.6698E+00,
     +0.6666E+00,0.6631E+00,0.6592E+00,0.6549E+00,0.6502E+00,0.6450E+00,
     +0.6393E+00,0.6331E+00,0.6262E+00,0.6187E+00,0.6105E+00,0.6015E+00,
     +0.5917E+00,0.5811E+00,0.5695E+00,0.5570E+00,0.5435E+00,0.5290E+00,
     +0.5134E+00,0.4966E+00,0.4788E+00,0.4599E+00,0.4400E+00,0.4190E+00,
     +0.3971E+00,0.3744E+00,0.3510E+00,0.3271E+00,0.3028E+00,0.2785E+00,
     +0.2543E+00,0.2305E+00,0.2073E+00,0.1850E+00,0.1638E+00,0.1438E+00,
     +0.1252E+00,0.1079E+00,0.9189E-01,0.7717E-01,0.6363E-01,0.5119E-01,
     +0.3985E-01,0.2967E-01,0.2082E-01,0.1351E-01,0.7893E-02,0.4007E-02,
     +0.2439E-02,0.1414E-02,0.7767E-03,0.4008E-03,0.1924E-03,0.8481E-04,
     +0.3374E-04,0.1182E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,5),I=1,104) /
     +0.2915E+00,0.2915E+00,0.2914E+00,0.2914E+00,0.2914E+00,0.2913E+00,
     +0.2914E+00,0.2913E+00,0.2913E+00,0.2912E+00,0.2912E+00,0.2911E+00,
     +0.2910E+00,0.2910E+00,0.2909E+00,0.2908E+00,0.2907E+00,0.2906E+00,
     +0.2905E+00,0.2904E+00,0.2902E+00,0.2901E+00,0.2899E+00,0.2897E+00,
     +0.2895E+00,0.2892E+00,0.2890E+00,0.2887E+00,0.2883E+00,0.2880E+00,
     +0.2876E+00,0.2871E+00,0.2866E+00,0.2861E+00,0.2855E+00,0.2848E+00,
     +0.2841E+00,0.2833E+00,0.2824E+00,0.2814E+00,0.2803E+00,0.2791E+00,
     +0.2778E+00,0.2763E+00,0.2747E+00,0.2729E+00,0.2709E+00,0.2688E+00,
     +0.2664E+00,0.2638E+00,0.2609E+00,0.2578E+00,0.2544E+00,0.2506E+00,
     +0.2466E+00,0.2421E+00,0.2373E+00,0.2321E+00,0.2265E+00,0.2204E+00,
     +0.2139E+00,0.2069E+00,0.1995E+00,0.1916E+00,0.1833E+00,0.1746E+00,
     +0.1655E+00,0.1560E+00,0.1462E+00,0.1363E+00,0.1262E+00,0.1160E+00,
     +0.1060E+00,0.9604E-01,0.8639E-01,0.7710E-01,0.6826E-01,0.5993E-01,
     +0.5215E-01,0.4494E-01,0.3829E-01,0.3216E-01,0.2651E-01,0.2133E-01,
     +0.1660E-01,0.1236E-01,0.8676E-02,0.5628E-02,0.3289E-02,0.1669E-02,
     +0.1016E-02,0.5892E-03,0.3236E-03,0.1670E-03,0.8017E-04,0.3534E-04,
     +0.1406E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,6),I=1,104) /
     +0.1166E+00,0.1166E+00,0.1166E+00,0.1166E+00,0.1166E+00,0.1165E+00,
     +0.1165E+00,0.1165E+00,0.1165E+00,0.1165E+00,0.1165E+00,0.1164E+00,
     +0.1164E+00,0.1164E+00,0.1164E+00,0.1163E+00,0.1163E+00,0.1162E+00,
     +0.1162E+00,0.1161E+00,0.1161E+00,0.1160E+00,0.1159E+00,0.1159E+00,
     +0.1158E+00,0.1157E+00,0.1156E+00,0.1155E+00,0.1153E+00,0.1152E+00,
     +0.1150E+00,0.1149E+00,0.1147E+00,0.1144E+00,0.1142E+00,0.1139E+00,
     +0.1136E+00,0.1133E+00,0.1130E+00,0.1126E+00,0.1121E+00,0.1116E+00,
     +0.1111E+00,0.1105E+00,0.1099E+00,0.1092E+00,0.1084E+00,0.1075E+00,
     +0.1066E+00,0.1055E+00,0.1044E+00,0.1031E+00,0.1017E+00,0.1002E+00,
     +0.9862E-01,0.9685E-01,0.9492E-01,0.9284E-01,0.9059E-01,0.8816E-01,
     +0.8556E-01,0.8277E-01,0.7980E-01,0.7665E-01,0.7333E-01,0.6983E-01,
     +0.6618E-01,0.6240E-01,0.5850E-01,0.5451E-01,0.5047E-01,0.4642E-01,
     +0.4238E-01,0.3842E-01,0.3456E-01,0.3084E-01,0.2730E-01,0.2397E-01,
     +0.2086E-01,0.1798E-01,0.1531E-01,0.1286E-01,0.1061E-01,0.8532E-02,
     +0.6641E-02,0.4945E-02,0.3470E-02,0.2251E-02,0.1315E-02,0.6679E-03,
     +0.4064E-03,0.2357E-03,0.1294E-03,0.6680E-04,0.3207E-04,0.1413E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,7),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,8),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,1),I=1,104) /
     +0.1281E-01,0.1354E-01,0.1430E-01,0.1512E-01,0.1597E-01,0.1688E-01,
     +0.1784E-01,0.1885E-01,0.1992E-01,0.2104E-01,0.2224E-01,0.2350E-01,
     +0.2483E-01,0.2623E-01,0.2772E-01,0.2928E-01,0.3094E-01,0.3269E-01,
     +0.3454E-01,0.3649E-01,0.3855E-01,0.4072E-01,0.4302E-01,0.4545E-01,
     +0.4801E-01,0.5072E-01,0.5357E-01,0.5659E-01,0.5977E-01,0.6312E-01,
     +0.6667E-01,0.7041E-01,0.7435E-01,0.7851E-01,0.8290E-01,0.8753E-01,
     +0.9241E-01,0.9755E-01,0.1030E+00,0.1087E+00,0.1147E+00,0.1210E+00,
     +0.1277E+00,0.1347E+00,0.1421E+00,0.1499E+00,0.1580E+00,0.1666E+00,
     +0.1756E+00,0.1850E+00,0.1949E+00,0.2052E+00,0.2161E+00,0.2274E+00,
     +0.2392E+00,0.2515E+00,0.2643E+00,0.2776E+00,0.2915E+00,0.3058E+00,
     +0.3205E+00,0.3357E+00,0.3513E+00,0.3672E+00,0.3834E+00,0.3998E+00,
     +0.4162E+00,0.4326E+00,0.4489E+00,0.4647E+00,0.4800E+00,0.4944E+00,
     +0.5077E+00,0.5195E+00,0.5295E+00,0.5372E+00,0.5421E+00,0.5438E+00,
     +0.5417E+00,0.5353E+00,0.5241E+00,0.5075E+00,0.4852E+00,0.4570E+00,
     +0.4230E+00,0.3833E+00,0.3389E+00,0.2907E+00,0.2403E+00,0.1898E+00,
     +0.1602E+00,0.1335E+00,0.1097E+00,0.8874E-01,0.7047E-01,0.5475E-01,
     +0.4141E-01,0.3027E-01,0.2116E-01,0.1393E-01,0.8402E-02,0.4438E-02,
     +0.1871E-02,0.4938E-03/
      DATA (XQDUM (I,2,2),I=1,104) /
     +0.7309E-02,0.7723E-02,0.8161E-02,0.8624E-02,0.9113E-02,0.9629E-02,
     +0.1017E-01,0.1075E-01,0.1136E-01,0.1200E-01,0.1268E-01,0.1340E-01,
     +0.1416E-01,0.1496E-01,0.1580E-01,0.1670E-01,0.1764E-01,0.1864E-01,
     +0.1969E-01,0.2080E-01,0.2197E-01,0.2321E-01,0.2452E-01,0.2590E-01,
     +0.2736E-01,0.2889E-01,0.3052E-01,0.3223E-01,0.3404E-01,0.3594E-01,
     +0.3795E-01,0.4007E-01,0.4231E-01,0.4467E-01,0.4715E-01,0.4977E-01,
     +0.5253E-01,0.5544E-01,0.5849E-01,0.6171E-01,0.6510E-01,0.6867E-01,
     +0.7241E-01,0.7635E-01,0.8048E-01,0.8482E-01,0.8936E-01,0.9413E-01,
     +0.9912E-01,0.1043E+00,0.1098E+00,0.1155E+00,0.1214E+00,0.1276E+00,
     +0.1340E+00,0.1407E+00,0.1475E+00,0.1546E+00,0.1619E+00,0.1694E+00,
     +0.1771E+00,0.1849E+00,0.1928E+00,0.2008E+00,0.2087E+00,0.2166E+00,
     +0.2243E+00,0.2318E+00,0.2389E+00,0.2456E+00,0.2516E+00,0.2569E+00,
     +0.2612E+00,0.2643E+00,0.2661E+00,0.2662E+00,0.2645E+00,0.2608E+00,
     +0.2547E+00,0.2462E+00,0.2351E+00,0.2213E+00,0.2048E+00,0.1859E+00,
     +0.1649E+00,0.1423E+00,0.1188E+00,0.9527E-01,0.7271E-01,0.5214E-01,
     +0.4111E-01,0.3185E-01,0.2419E-01,0.1797E-01,0.1301E-01,0.9132E-02,
     +0.6171E-02,0.3975E-02,0.2406E-02,0.1338E-02,0.6601E-03,0.2712E-03,
     +0.8180E-04,0.1309E-04/
      DATA (XQDUM (I,2,3),I=1,104) /
     +0.4836E+02,0.4656E+02,0.4482E+02,0.4315E+02,0.4153E+02,0.3997E+02,
     +0.3848E+02,0.3703E+02,0.3564E+02,0.3430E+02,0.3300E+02,0.3176E+02,
     +0.3056E+02,0.2940E+02,0.2828E+02,0.2721E+02,0.2617E+02,0.2518E+02,
     +0.2421E+02,0.2329E+02,0.2239E+02,0.2153E+02,0.2070E+02,0.1990E+02,
     +0.1913E+02,0.1839E+02,0.1767E+02,0.1698E+02,0.1632E+02,0.1567E+02,
     +0.1506E+02,0.1446E+02,0.1389E+02,0.1333E+02,0.1280E+02,0.1228E+02,
     +0.1179E+02,0.1131E+02,0.1084E+02,0.1040E+02,0.9968E+01,0.9553E+01,
     +0.9153E+01,0.8766E+01,0.8393E+01,0.8033E+01,0.7685E+01,0.7349E+01,
     +0.7025E+01,0.6711E+01,0.6408E+01,0.6115E+01,0.5832E+01,0.5558E+01,
     +0.5292E+01,0.5036E+01,0.4787E+01,0.4546E+01,0.4312E+01,0.4086E+01,
     +0.3866E+01,0.3652E+01,0.3445E+01,0.3244E+01,0.3049E+01,0.2859E+01,
     +0.2674E+01,0.2495E+01,0.2321E+01,0.2151E+01,0.1987E+01,0.1828E+01,
     +0.1674E+01,0.1524E+01,0.1380E+01,0.1242E+01,0.1109E+01,0.9823E+00,
     +0.8616E+00,0.7475E+00,0.6404E+00,0.5405E+00,0.4485E+00,0.3646E+00,
     +0.2892E+00,0.2227E+00,0.1654E+00,0.1174E+00,0.7854E-01,0.4859E-01,
     +0.3457E-01,0.2394E-01,0.1598E-01,0.1014E-01,0.5946E-02,0.3032E-02,
     +0.1095E-02,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,4),I=1,104) /
     +0.3866E+01,0.3740E+01,0.3619E+01,0.3503E+01,0.3390E+01,0.3282E+01,
     +0.3178E+01,0.3077E+01,0.2980E+01,0.2887E+01,0.2797E+01,0.2711E+01,
     +0.2627E+01,0.2547E+01,0.2469E+01,0.2395E+01,0.2323E+01,0.2253E+01,
     +0.2187E+01,0.2122E+01,0.2060E+01,0.2000E+01,0.1943E+01,0.1887E+01,
     +0.1833E+01,0.1782E+01,0.1732E+01,0.1684E+01,0.1638E+01,0.1593E+01,
     +0.1550E+01,0.1508E+01,0.1467E+01,0.1429E+01,0.1391E+01,0.1354E+01,
     +0.1319E+01,0.1285E+01,0.1251E+01,0.1219E+01,0.1188E+01,0.1157E+01,
     +0.1127E+01,0.1098E+01,0.1070E+01,0.1042E+01,0.1015E+01,0.9875E+00,
     +0.9608E+00,0.9344E+00,0.9082E+00,0.8821E+00,0.8561E+00,0.8300E+00,
     +0.8039E+00,0.7776E+00,0.7510E+00,0.7242E+00,0.6970E+00,0.6695E+00,
     +0.6414E+00,0.6130E+00,0.5841E+00,0.5547E+00,0.5249E+00,0.4948E+00,
     +0.4643E+00,0.4337E+00,0.4030E+00,0.3725E+00,0.3422E+00,0.3125E+00,
     +0.2835E+00,0.2554E+00,0.2284E+00,0.2027E+00,0.1786E+00,0.1560E+00,
     +0.1350E+00,0.1157E+00,0.9789E-01,0.8161E-01,0.6675E-01,0.5326E-01,
     +0.4115E-01,0.3050E-01,0.2143E-01,0.1408E-01,0.8507E-02,0.4656E-02,
     +0.3071E-02,0.2000E-02,0.1292E-02,0.8335E-03,0.5390E-03,0.3499E-03,
     +0.2272E-03,0.1459E-03,0.9105E-04,0.5382E-04,0.2903E-04,0.1346E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,5),I=1,104) /
     +0.1017E+01,0.9884E+00,0.9606E+00,0.9339E+00,0.9082E+00,0.8834E+00,
     +0.8595E+00,0.8365E+00,0.8142E+00,0.7929E+00,0.7722E+00,0.7524E+00,
     +0.7332E+00,0.7148E+00,0.6970E+00,0.6798E+00,0.6633E+00,0.6474E+00,
     +0.6320E+00,0.6172E+00,0.6029E+00,0.5891E+00,0.5758E+00,0.5629E+00,
     +0.5505E+00,0.5385E+00,0.5270E+00,0.5158E+00,0.5049E+00,0.4945E+00,
     +0.4843E+00,0.4745E+00,0.4650E+00,0.4558E+00,0.4468E+00,0.4381E+00,
     +0.4296E+00,0.4213E+00,0.4131E+00,0.4052E+00,0.3974E+00,0.3898E+00,
     +0.3822E+00,0.3748E+00,0.3674E+00,0.3600E+00,0.3527E+00,0.3454E+00,
     +0.3381E+00,0.3307E+00,0.3232E+00,0.3157E+00,0.3080E+00,0.3001E+00,
     +0.2921E+00,0.2839E+00,0.2754E+00,0.2668E+00,0.2578E+00,0.2486E+00,
     +0.2390E+00,0.2292E+00,0.2191E+00,0.2087E+00,0.1980E+00,0.1871E+00,
     +0.1760E+00,0.1647E+00,0.1533E+00,0.1419E+00,0.1305E+00,0.1193E+00,
     +0.1083E+00,0.9760E-01,0.8732E-01,0.7752E-01,0.6827E-01,0.5962E-01,
     +0.5158E-01,0.4416E-01,0.3735E-01,0.3110E-01,0.2540E-01,0.2021E-01,
     +0.1555E-01,0.1145E-01,0.7971E-02,0.5158E-02,0.3045E-02,0.1604E-02,
     +0.1024E-02,0.6403E-03,0.3943E-03,0.2409E-03,0.1474E-03,0.9087E-04,
     +0.5656E-04,0.3525E-04,0.2161E-04,0.1266E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,6),I=1,104) /
     +0.8423E+00,0.8136E+00,0.7859E+00,0.7592E+00,0.7335E+00,0.7087E+00,
     +0.6849E+00,0.6619E+00,0.6397E+00,0.6183E+00,0.5978E+00,0.5780E+00,
     +0.5589E+00,0.5405E+00,0.5227E+00,0.5057E+00,0.4892E+00,0.4733E+00,
     +0.4581E+00,0.4433E+00,0.4292E+00,0.4155E+00,0.4023E+00,0.3896E+00,
     +0.3774E+00,0.3656E+00,0.3542E+00,0.3432E+00,0.3327E+00,0.3225E+00,
     +0.3126E+00,0.3031E+00,0.2940E+00,0.2851E+00,0.2766E+00,0.2684E+00,
     +0.2604E+00,0.2527E+00,0.2452E+00,0.2380E+00,0.2310E+00,0.2242E+00,
     +0.2176E+00,0.2111E+00,0.2049E+00,0.1988E+00,0.1928E+00,0.1870E+00,
     +0.1813E+00,0.1757E+00,0.1701E+00,0.1647E+00,0.1593E+00,0.1539E+00,
     +0.1486E+00,0.1433E+00,0.1380E+00,0.1326E+00,0.1273E+00,0.1220E+00,
     +0.1166E+00,0.1111E+00,0.1056E+00,0.1001E+00,0.9458E-01,0.8899E-01,
     +0.8339E-01,0.7779E-01,0.7220E-01,0.6667E-01,0.6120E-01,0.5585E-01,
     +0.5064E-01,0.4561E-01,0.4079E-01,0.3621E-01,0.3190E-01,0.2787E-01,
     +0.2413E-01,0.2069E-01,0.1752E-01,0.1462E-01,0.1198E-01,0.9578E-02,
     +0.7424E-02,0.5529E-02,0.3913E-02,0.2598E-02,0.1597E-02,0.8963E-03,
     +0.6038E-03,0.4028E-03,0.2674E-03,0.1773E-03,0.1177E-03,0.7823E-04,
     +0.5170E-04,0.3361E-04,0.2114E-04,0.1255E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,7),I=1,104) /
     +0.7258E+00,0.6971E+00,0.6694E+00,0.6427E+00,0.6170E+00,0.5923E+00,
     +0.5684E+00,0.5455E+00,0.5233E+00,0.5020E+00,0.4815E+00,0.4617E+00,
     +0.4426E+00,0.4242E+00,0.4066E+00,0.3895E+00,0.3731E+00,0.3573E+00,
     +0.3421E+00,0.3274E+00,0.3133E+00,0.2997E+00,0.2866E+00,0.2740E+00,
     +0.2619E+00,0.2502E+00,0.2390E+00,0.2282E+00,0.2178E+00,0.2078E+00,
     +0.1981E+00,0.1889E+00,0.1799E+00,0.1714E+00,0.1631E+00,0.1552E+00,
     +0.1476E+00,0.1402E+00,0.1332E+00,0.1265E+00,0.1200E+00,0.1137E+00,
     +0.1078E+00,0.1020E+00,0.9653E-01,0.9126E-01,0.8621E-01,0.8137E-01,
     +0.7673E-01,0.7230E-01,0.6805E-01,0.6400E-01,0.6012E-01,0.5642E-01,
     +0.5288E-01,0.4951E-01,0.4630E-01,0.4323E-01,0.4032E-01,0.3754E-01,
     +0.3490E-01,0.3239E-01,0.3001E-01,0.2775E-01,0.2561E-01,0.2358E-01,
     +0.2166E-01,0.1984E-01,0.1813E-01,0.1651E-01,0.1499E-01,0.1356E-01,
     +0.1221E-01,0.1095E-01,0.9773E-02,0.8676E-02,0.7656E-02,0.6712E-02,
     +0.5841E-02,0.5040E-02,0.4307E-02,0.3640E-02,0.3035E-02,0.2491E-02,
     +0.2006E-02,0.1579E-02,0.1207E-02,0.8920E-03,0.6316E-03,0.4242E-03,
     +0.3236E-03,0.2446E-03,0.1828E-03,0.1349E-03,0.9799E-04,0.6980E-04,
     +0.4846E-04,0.3252E-04,0.2082E-04,0.1248E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,8),I=1,104) /
     +0.2635E+00,0.2528E+00,0.2426E+00,0.2328E+00,0.2233E+00,0.2142E+00,
     +0.2054E+00,0.1969E+00,0.1888E+00,0.1810E+00,0.1734E+00,0.1661E+00,
     +0.1592E+00,0.1524E+00,0.1459E+00,0.1397E+00,0.1337E+00,0.1279E+00,
     +0.1224E+00,0.1170E+00,0.1119E+00,0.1069E+00,0.1022E+00,0.9760E-01,
     +0.9319E-01,0.8896E-01,0.8489E-01,0.8097E-01,0.7720E-01,0.7358E-01,
     +0.7011E-01,0.6676E-01,0.6355E-01,0.6046E-01,0.5750E-01,0.5465E-01,
     +0.5192E-01,0.4929E-01,0.4677E-01,0.4436E-01,0.4204E-01,0.3981E-01,
     +0.3768E-01,0.3564E-01,0.3368E-01,0.3181E-01,0.3001E-01,0.2829E-01,
     +0.2665E-01,0.2508E-01,0.2358E-01,0.2214E-01,0.2077E-01,0.1947E-01,
     +0.1822E-01,0.1703E-01,0.1590E-01,0.1482E-01,0.1380E-01,0.1282E-01,
     +0.1190E-01,0.1102E-01,0.1019E-01,0.9397E-02,0.8650E-02,0.7943E-02,
     +0.7276E-02,0.6646E-02,0.6053E-02,0.5495E-02,0.4970E-02,0.4479E-02,
     +0.4019E-02,0.3590E-02,0.3190E-02,0.2819E-02,0.2476E-02,0.2160E-02,
     +0.1870E-02,0.1605E-02,0.1364E-02,0.1145E-02,0.9493E-03,0.7742E-03,
     +0.6193E-03,0.4839E-03,0.3675E-03,0.2696E-03,0.1895E-03,0.1263E-03,
     +0.9588E-04,0.7212E-04,0.5366E-04,0.3940E-04,0.2847E-04,0.2016E-04,
     +0.1391E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,1),I=1,104) /
     +0.1407E-01,0.1486E-01,0.1570E-01,0.1658E-01,0.1752E-01,0.1851E-01,
     +0.1955E-01,0.2065E-01,0.2182E-01,0.2304E-01,0.2434E-01,0.2571E-01,
     +0.2716E-01,0.2868E-01,0.3030E-01,0.3200E-01,0.3379E-01,0.3569E-01,
     +0.3769E-01,0.3980E-01,0.4203E-01,0.4438E-01,0.4686E-01,0.4948E-01,
     +0.5224E-01,0.5516E-01,0.5823E-01,0.6147E-01,0.6489E-01,0.6849E-01,
     +0.7229E-01,0.7629E-01,0.8051E-01,0.8495E-01,0.8964E-01,0.9457E-01,
     +0.9976E-01,0.1052E+00,0.1110E+00,0.1170E+00,0.1234E+00,0.1301E+00,
     +0.1371E+00,0.1445E+00,0.1522E+00,0.1603E+00,0.1689E+00,0.1778E+00,
     +0.1871E+00,0.1969E+00,0.2071E+00,0.2178E+00,0.2289E+00,0.2405E+00,
     +0.2525E+00,0.2650E+00,0.2780E+00,0.2914E+00,0.3052E+00,0.3194E+00,
     +0.3341E+00,0.3490E+00,0.3642E+00,0.3796E+00,0.3951E+00,0.4107E+00,
     +0.4261E+00,0.4414E+00,0.4561E+00,0.4703E+00,0.4837E+00,0.4959E+00,
     +0.5067E+00,0.5158E+00,0.5227E+00,0.5272E+00,0.5286E+00,0.5266E+00,
     +0.5207E+00,0.5104E+00,0.4954E+00,0.4753E+00,0.4500E+00,0.4193E+00,
     +0.3835E+00,0.3432E+00,0.2991E+00,0.2526E+00,0.2053E+00,0.1589E+00,
     +0.1324E+00,0.1088E+00,0.8812E-01,0.7016E-01,0.5476E-01,0.4175E-01,
     +0.3091E-01,0.2205E-01,0.1498E-01,0.9528E-02,0.5509E-02,0.2752E-02,
     +0.1072E-02,0.2472E-03/
      DATA (XQDUM (I,3,2),I=1,104) /
     +0.8019E-02,0.8471E-02,0.8949E-02,0.9453E-02,0.9986E-02,0.1055E-01,
     +0.1114E-01,0.1177E-01,0.1243E-01,0.1313E-01,0.1387E-01,0.1465E-01,
     +0.1547E-01,0.1634E-01,0.1726E-01,0.1822E-01,0.1925E-01,0.2032E-01,
     +0.2146E-01,0.2266E-01,0.2393E-01,0.2526E-01,0.2667E-01,0.2815E-01,
     +0.2972E-01,0.3137E-01,0.3312E-01,0.3495E-01,0.3689E-01,0.3892E-01,
     +0.4107E-01,0.4334E-01,0.4572E-01,0.4823E-01,0.5087E-01,0.5365E-01,
     +0.5657E-01,0.5964E-01,0.6287E-01,0.6626E-01,0.6983E-01,0.7357E-01,
     +0.7749E-01,0.8160E-01,0.8591E-01,0.9042E-01,0.9514E-01,0.1001E+00,
     +0.1052E+00,0.1106E+00,0.1162E+00,0.1220E+00,0.1280E+00,0.1342E+00,
     +0.1407E+00,0.1474E+00,0.1542E+00,0.1613E+00,0.1685E+00,0.1758E+00,
     +0.1833E+00,0.1908E+00,0.1983E+00,0.2059E+00,0.2133E+00,0.2205E+00,
     +0.2275E+00,0.2341E+00,0.2403E+00,0.2459E+00,0.2507E+00,0.2546E+00,
     +0.2574E+00,0.2590E+00,0.2591E+00,0.2575E+00,0.2540E+00,0.2485E+00,
     +0.2407E+00,0.2306E+00,0.2181E+00,0.2032E+00,0.1861E+00,0.1669E+00,
     +0.1462E+00,0.1243E+00,0.1022E+00,0.8057E-01,0.6031E-01,0.4231E-01,
     +0.3287E-01,0.2507E-01,0.1874E-01,0.1368E-01,0.9719E-02,0.6681E-02,
     +0.4411E-02,0.2767E-02,0.1624E-02,0.8704E-03,0.4101E-03,0.1587E-03,
     +0.4390E-04,0.0000E+00/
      DATA (XQDUM (I,3,3),I=1,104) /
     +0.6518E+02,0.6264E+02,0.6020E+02,0.5785E+02,0.5559E+02,0.5340E+02,
     +0.5130E+02,0.4928E+02,0.4733E+02,0.4546E+02,0.4365E+02,0.4192E+02,
     +0.4024E+02,0.3863E+02,0.3708E+02,0.3558E+02,0.3414E+02,0.3276E+02,
     +0.3143E+02,0.3014E+02,0.2891E+02,0.2772E+02,0.2657E+02,0.2547E+02,
     +0.2441E+02,0.2339E+02,0.2240E+02,0.2146E+02,0.2055E+02,0.1967E+02,
     +0.1882E+02,0.1801E+02,0.1723E+02,0.1648E+02,0.1575E+02,0.1506E+02,
     +0.1439E+02,0.1374E+02,0.1312E+02,0.1252E+02,0.1195E+02,0.1139E+02,
     +0.1086E+02,0.1035E+02,0.9854E+01,0.9379E+01,0.8922E+01,0.8482E+01,
     +0.8058E+01,0.7651E+01,0.7259E+01,0.6881E+01,0.6518E+01,0.6168E+01,
     +0.5831E+01,0.5507E+01,0.5195E+01,0.4895E+01,0.4606E+01,0.4328E+01,
     +0.4060E+01,0.3802E+01,0.3554E+01,0.3315E+01,0.3086E+01,0.2865E+01,
     +0.2653E+01,0.2449E+01,0.2254E+01,0.2066E+01,0.1887E+01,0.1716E+01,
     +0.1552E+01,0.1397E+01,0.1249E+01,0.1110E+01,0.9779E+00,0.8543E+00,
     +0.7390E+00,0.6319E+00,0.5333E+00,0.4432E+00,0.3617E+00,0.2888E+00,
     +0.2248E+00,0.1695E+00,0.1228E+00,0.8468E-01,0.5465E-01,0.3215E-01,
     +0.2190E-01,0.1430E-01,0.8755E-02,0.4801E-02,0.2070E-02,0.2691E-03,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,4),I=1,104) /
     +0.7778E+01,0.7488E+01,0.7209E+01,0.6940E+01,0.6682E+01,0.6433E+01,
     +0.6194E+01,0.5963E+01,0.5742E+01,0.5528E+01,0.5323E+01,0.5126E+01,
     +0.4936E+01,0.4753E+01,0.4577E+01,0.4408E+01,0.4245E+01,0.4089E+01,
     +0.3938E+01,0.3793E+01,0.3654E+01,0.3520E+01,0.3391E+01,0.3267E+01,
     +0.3148E+01,0.3033E+01,0.2922E+01,0.2816E+01,0.2714E+01,0.2616E+01,
     +0.2521E+01,0.2430E+01,0.2343E+01,0.2259E+01,0.2177E+01,0.2099E+01,
     +0.2024E+01,0.1951E+01,0.1882E+01,0.1814E+01,0.1749E+01,0.1686E+01,
     +0.1626E+01,0.1567E+01,0.1510E+01,0.1455E+01,0.1402E+01,0.1350E+01,
     +0.1299E+01,0.1250E+01,0.1202E+01,0.1156E+01,0.1110E+01,0.1065E+01,
     +0.1021E+01,0.9773E+00,0.9345E+00,0.8922E+00,0.8504E+00,0.8089E+00,
     +0.7678E+00,0.7270E+00,0.6864E+00,0.6462E+00,0.6062E+00,0.5666E+00,
     +0.5275E+00,0.4889E+00,0.4509E+00,0.4137E+00,0.3774E+00,0.3423E+00,
     +0.3085E+00,0.2762E+00,0.2455E+00,0.2166E+00,0.1896E+00,0.1646E+00,
     +0.1415E+00,0.1204E+00,0.1011E+00,0.8357E-01,0.6773E-01,0.5354E-01,
     +0.4100E-01,0.3015E-01,0.2109E-01,0.1386E-01,0.8468E-02,0.4756E-02,
     +0.3220E-02,0.2165E-02,0.1452E-02,0.9723E-03,0.6505E-03,0.4333E-03,
     +0.2851E-03,0.1832E-03,0.1130E-03,0.6524E-04,0.3404E-04,0.1509E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,5),I=1,104) /
     +0.1796E+01,0.1734E+01,0.1675E+01,0.1618E+01,0.1563E+01,0.1511E+01,
     +0.1460E+01,0.1411E+01,0.1364E+01,0.1319E+01,0.1275E+01,0.1233E+01,
     +0.1193E+01,0.1154E+01,0.1116E+01,0.1080E+01,0.1046E+01,0.1012E+01,
     +0.9802E+00,0.9494E+00,0.9196E+00,0.8910E+00,0.8635E+00,0.8370E+00,
     +0.8115E+00,0.7869E+00,0.7632E+00,0.7404E+00,0.7184E+00,0.6973E+00,
     +0.6769E+00,0.6572E+00,0.6382E+00,0.6199E+00,0.6022E+00,0.5851E+00,
     +0.5686E+00,0.5526E+00,0.5371E+00,0.5220E+00,0.5074E+00,0.4932E+00,
     +0.4794E+00,0.4660E+00,0.4528E+00,0.4400E+00,0.4273E+00,0.4149E+00,
     +0.4027E+00,0.3906E+00,0.3787E+00,0.3668E+00,0.3551E+00,0.3433E+00,
     +0.3315E+00,0.3197E+00,0.3078E+00,0.2959E+00,0.2839E+00,0.2717E+00,
     +0.2595E+00,0.2471E+00,0.2345E+00,0.2219E+00,0.2091E+00,0.1963E+00,
     +0.1835E+00,0.1706E+00,0.1579E+00,0.1452E+00,0.1328E+00,0.1207E+00,
     +0.1089E+00,0.9766E-01,0.8690E-01,0.7673E-01,0.6720E-01,0.5835E-01,
     +0.5017E-01,0.4266E-01,0.3580E-01,0.2955E-01,0.2390E-01,0.1882E-01,
     +0.1432E-01,0.1043E-01,0.7185E-02,0.4617E-02,0.2725E-02,0.1454E-02,
     +0.9446E-03,0.6066E-03,0.3870E-03,0.2468E-03,0.1579E-03,0.1014E-03,
     +0.6495E-04,0.4102E-04,0.2506E-04,0.1442E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,6),I=1,104) /
     +0.1621E+01,0.1560E+01,0.1501E+01,0.1444E+01,0.1389E+01,0.1336E+01,
     +0.1285E+01,0.1237E+01,0.1189E+01,0.1144E+01,0.1101E+01,0.1059E+01,
     +0.1018E+01,0.9797E+00,0.9423E+00,0.9064E+00,0.8719E+00,0.8387E+00,
     +0.8067E+00,0.7759E+00,0.7464E+00,0.7179E+00,0.6905E+00,0.6642E+00,
     +0.6389E+00,0.6145E+00,0.5911E+00,0.5686E+00,0.5469E+00,0.5261E+00,
     +0.5060E+00,0.4867E+00,0.4682E+00,0.4503E+00,0.4331E+00,0.4166E+00,
     +0.4007E+00,0.3854E+00,0.3706E+00,0.3564E+00,0.3427E+00,0.3295E+00,
     +0.3168E+00,0.3045E+00,0.2926E+00,0.2811E+00,0.2700E+00,0.2593E+00,
     +0.2489E+00,0.2388E+00,0.2289E+00,0.2194E+00,0.2101E+00,0.2010E+00,
     +0.1921E+00,0.1834E+00,0.1749E+00,0.1665E+00,0.1583E+00,0.1502E+00,
     +0.1422E+00,0.1344E+00,0.1266E+00,0.1189E+00,0.1114E+00,0.1039E+00,
     +0.9658E-01,0.8938E-01,0.8233E-01,0.7546E-01,0.6878E-01,0.6234E-01,
     +0.5615E-01,0.5025E-01,0.4466E-01,0.3940E-01,0.3450E-01,0.2995E-01,
     +0.2576E-01,0.2192E-01,0.1842E-01,0.1524E-01,0.1237E-01,0.9804E-02,
     +0.7533E-02,0.5569E-02,0.3925E-02,0.2609E-02,0.1620E-02,0.9302E-03,
     +0.6404E-03,0.4385E-03,0.2993E-03,0.2039E-03,0.1384E-03,0.9330E-04,
     +0.6194E-04,0.4004E-04,0.2479E-04,0.1436E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,7),I=1,104) /
     +0.1505E+01,0.1443E+01,0.1384E+01,0.1327E+01,0.1273E+01,0.1220E+01,
     +0.1169E+01,0.1120E+01,0.1073E+01,0.1028E+01,0.9845E+00,0.9426E+00,
     +0.9023E+00,0.8636E+00,0.8263E+00,0.7905E+00,0.7560E+00,0.7228E+00,
     +0.6910E+00,0.6603E+00,0.6308E+00,0.6024E+00,0.5752E+00,0.5490E+00,
     +0.5238E+00,0.4996E+00,0.4763E+00,0.4540E+00,0.4325E+00,0.4119E+00,
     +0.3921E+00,0.3730E+00,0.3548E+00,0.3372E+00,0.3204E+00,0.3042E+00,
     +0.2887E+00,0.2739E+00,0.2596E+00,0.2460E+00,0.2329E+00,0.2203E+00,
     +0.2083E+00,0.1968E+00,0.1858E+00,0.1752E+00,0.1651E+00,0.1555E+00,
     +0.1463E+00,0.1375E+00,0.1291E+00,0.1211E+00,0.1134E+00,0.1061E+00,
     +0.9917E-01,0.9256E-01,0.8627E-01,0.8029E-01,0.7461E-01,0.6921E-01,
     +0.6410E-01,0.5925E-01,0.5466E-01,0.5031E-01,0.4621E-01,0.4233E-01,
     +0.3868E-01,0.3524E-01,0.3200E-01,0.2896E-01,0.2611E-01,0.2345E-01,
     +0.2097E-01,0.1866E-01,0.1651E-01,0.1453E-01,0.1270E-01,0.1102E-01,
     +0.9492E-02,0.8099E-02,0.6838E-02,0.5705E-02,0.4693E-02,0.3796E-02,
     +0.3010E-02,0.2330E-02,0.1752E-02,0.1271E-02,0.8828E-03,0.5810E-03,
     +0.4375E-03,0.3264E-03,0.2408E-03,0.1753E-03,0.1255E-03,0.8792E-04,
     +0.5994E-04,0.3939E-04,0.2461E-04,0.1432E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,8),I=1,104) /
     +0.1060E+01,0.1016E+01,0.9733E+00,0.9326E+00,0.8935E+00,0.8559E+00,
     +0.8197E+00,0.7848E+00,0.7513E+00,0.7192E+00,0.6882E+00,0.6584E+00,
     +0.6298E+00,0.6023E+00,0.5758E+00,0.5504E+00,0.5260E+00,0.5025E+00,
     +0.4800E+00,0.4583E+00,0.4374E+00,0.4174E+00,0.3982E+00,0.3797E+00,
     +0.3620E+00,0.3450E+00,0.3286E+00,0.3129E+00,0.2979E+00,0.2834E+00,
     +0.2695E+00,0.2562E+00,0.2435E+00,0.2312E+00,0.2195E+00,0.2082E+00,
     +0.1974E+00,0.1871E+00,0.1772E+00,0.1677E+00,0.1586E+00,0.1499E+00,
     +0.1416E+00,0.1336E+00,0.1260E+00,0.1187E+00,0.1118E+00,0.1051E+00,
     +0.9878E-01,0.9272E-01,0.8695E-01,0.8145E-01,0.7620E-01,0.7121E-01,
     +0.6646E-01,0.6193E-01,0.5764E-01,0.5356E-01,0.4968E-01,0.4601E-01,
     +0.4253E-01,0.3924E-01,0.3612E-01,0.3318E-01,0.3040E-01,0.2779E-01,
     +0.2532E-01,0.2301E-01,0.2083E-01,0.1880E-01,0.1690E-01,0.1512E-01,
     +0.1347E-01,0.1194E-01,0.1053E-01,0.9224E-02,0.8028E-02,0.6935E-02,
     +0.5941E-02,0.5042E-02,0.4233E-02,0.3510E-02,0.2869E-02,0.2306E-02,
     +0.1816E-02,0.1395E-02,0.1041E-02,0.7495E-03,0.5164E-03,0.3370E-03,
     +0.2525E-03,0.1874E-03,0.1375E-03,0.9950E-04,0.7080E-04,0.4929E-04,
     +0.3336E-04,0.2173E-04,0.1344E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,1),I=1,104) /
     +0.1618E-01,0.1709E-01,0.1804E-01,0.1905E-01,0.2012E-01,0.2124E-01,
     +0.2243E-01,0.2368E-01,0.2500E-01,0.2639E-01,0.2786E-01,0.2941E-01,
     +0.3105E-01,0.3277E-01,0.3459E-01,0.3651E-01,0.3853E-01,0.4067E-01,
     +0.4292E-01,0.4529E-01,0.4779E-01,0.5042E-01,0.5320E-01,0.5612E-01,
     +0.5920E-01,0.6244E-01,0.6586E-01,0.6946E-01,0.7325E-01,0.7723E-01,
     +0.8142E-01,0.8584E-01,0.9048E-01,0.9536E-01,0.1005E+00,0.1059E+00,
     +0.1115E+00,0.1175E+00,0.1237E+00,0.1303E+00,0.1371E+00,0.1443E+00,
     +0.1518E+00,0.1597E+00,0.1680E+00,0.1766E+00,0.1856E+00,0.1950E+00,
     +0.2048E+00,0.2150E+00,0.2256E+00,0.2366E+00,0.2480E+00,0.2598E+00,
     +0.2720E+00,0.2846E+00,0.2976E+00,0.3109E+00,0.3245E+00,0.3384E+00,
     +0.3525E+00,0.3667E+00,0.3810E+00,0.3953E+00,0.4095E+00,0.4235E+00,
     +0.4371E+00,0.4501E+00,0.4625E+00,0.4738E+00,0.4840E+00,0.4927E+00,
     +0.4996E+00,0.5045E+00,0.5069E+00,0.5065E+00,0.5030E+00,0.4959E+00,
     +0.4849E+00,0.4697E+00,0.4501E+00,0.4260E+00,0.3973E+00,0.3643E+00,
     +0.3275E+00,0.2876E+00,0.2456E+00,0.2027E+00,0.1606E+00,0.1207E+00,
     +0.9860E-01,0.7937E-01,0.6287E-01,0.4888E-01,0.3718E-01,0.2754E-01,
     +0.1974E-01,0.1357E-01,0.8825E-02,0.5321E-02,0.2877E-02,0.1313E-02,
     +0.4461E-03,0.7924E-04/
      DATA (XQDUM (I,4,2),I=1,104) /
     +0.9212E-02,0.9728E-02,0.1027E-01,0.1084E-01,0.1145E-01,0.1209E-01,
     +0.1276E-01,0.1347E-01,0.1422E-01,0.1501E-01,0.1585E-01,0.1673E-01,
     +0.1766E-01,0.1864E-01,0.1967E-01,0.2075E-01,0.2190E-01,0.2311E-01,
     +0.2438E-01,0.2573E-01,0.2714E-01,0.2863E-01,0.3020E-01,0.3185E-01,
     +0.3359E-01,0.3542E-01,0.3735E-01,0.3938E-01,0.4151E-01,0.4375E-01,
     +0.4611E-01,0.4859E-01,0.5120E-01,0.5393E-01,0.5681E-01,0.5982E-01,
     +0.6299E-01,0.6630E-01,0.6978E-01,0.7342E-01,0.7723E-01,0.8121E-01,
     +0.8538E-01,0.8973E-01,0.9427E-01,0.9900E-01,0.1039E+00,0.1091E+00,
     +0.1144E+00,0.1199E+00,0.1256E+00,0.1315E+00,0.1376E+00,0.1439E+00,
     +0.1503E+00,0.1569E+00,0.1636E+00,0.1704E+00,0.1773E+00,0.1843E+00,
     +0.1913E+00,0.1982E+00,0.2050E+00,0.2117E+00,0.2182E+00,0.2243E+00,
     +0.2300E+00,0.2352E+00,0.2398E+00,0.2437E+00,0.2466E+00,0.2485E+00,
     +0.2491E+00,0.2484E+00,0.2461E+00,0.2422E+00,0.2364E+00,0.2286E+00,
     +0.2188E+00,0.2069E+00,0.1929E+00,0.1770E+00,0.1595E+00,0.1406E+00,
     +0.1208E+00,0.1006E+00,0.8085E-01,0.6214E-01,0.4523E-01,0.3072E-01,
     +0.2335E-01,0.1740E-01,0.1269E-01,0.9029E-02,0.6234E-02,0.4153E-02,
     +0.2646E-02,0.1594E-02,0.8916E-03,0.4509E-03,0.1973E-03,0.6898E-04,
     +0.1631E-04,0.0000E+00/
      DATA (XQDUM (I,4,3),I=1,104) /
     +0.9960E+02,0.9539E+02,0.9135E+02,0.8747E+02,0.8374E+02,0.8016E+02,
     +0.7671E+02,0.7341E+02,0.7023E+02,0.6718E+02,0.6425E+02,0.6143E+02,
     +0.5873E+02,0.5613E+02,0.5364E+02,0.5125E+02,0.4895E+02,0.4675E+02,
     +0.4463E+02,0.4260E+02,0.4065E+02,0.3878E+02,0.3699E+02,0.3527E+02,
     +0.3362E+02,0.3204E+02,0.3052E+02,0.2906E+02,0.2767E+02,0.2633E+02,
     +0.2505E+02,0.2382E+02,0.2265E+02,0.2152E+02,0.2044E+02,0.1940E+02,
     +0.1841E+02,0.1747E+02,0.1656E+02,0.1569E+02,0.1486E+02,0.1406E+02,
     +0.1330E+02,0.1257E+02,0.1188E+02,0.1121E+02,0.1057E+02,0.9967E+01,
     +0.9386E+01,0.8831E+01,0.8301E+01,0.7794E+01,0.7311E+01,0.6850E+01,
     +0.6411E+01,0.5992E+01,0.5592E+01,0.5211E+01,0.4848E+01,0.4503E+01,
     +0.4175E+01,0.3862E+01,0.3566E+01,0.3284E+01,0.3017E+01,0.2764E+01,
     +0.2524E+01,0.2297E+01,0.2083E+01,0.1882E+01,0.1692E+01,0.1515E+01,
     +0.1348E+01,0.1193E+01,0.1049E+01,0.9154E+00,0.7922E+00,0.6793E+00,
     +0.5762E+00,0.4828E+00,0.3988E+00,0.3240E+00,0.2581E+00,0.2008E+00,
     +0.1519E+00,0.1108E+00,0.7735E-01,0.5091E-01,0.3090E-01,0.1658E-01,
     +0.1034E-01,0.5887E-02,0.2788E-02,0.7079E-03,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,4),I=1,104) /
     +0.1516E+02,0.1453E+02,0.1394E+02,0.1336E+02,0.1281E+02,0.1228E+02,
     +0.1177E+02,0.1128E+02,0.1081E+02,0.1036E+02,0.9929E+01,0.9513E+01,
     +0.9114E+01,0.8731E+01,0.8363E+01,0.8010E+01,0.7672E+01,0.7347E+01,
     +0.7035E+01,0.6736E+01,0.6449E+01,0.6173E+01,0.5909E+01,0.5656E+01,
     +0.5413E+01,0.5180E+01,0.4956E+01,0.4742E+01,0.4537E+01,0.4340E+01,
     +0.4151E+01,0.3970E+01,0.3796E+01,0.3630E+01,0.3470E+01,0.3317E+01,
     +0.3170E+01,0.3030E+01,0.2895E+01,0.2765E+01,0.2641E+01,0.2522E+01,
     +0.2408E+01,0.2298E+01,0.2193E+01,0.2091E+01,0.1994E+01,0.1900E+01,
     +0.1810E+01,0.1723E+01,0.1639E+01,0.1558E+01,0.1480E+01,0.1404E+01,
     +0.1331E+01,0.1261E+01,0.1192E+01,0.1125E+01,0.1060E+01,0.9975E+00,
     +0.9363E+00,0.8767E+00,0.8187E+00,0.7622E+00,0.7073E+00,0.6541E+00,
     +0.6024E+00,0.5524E+00,0.5042E+00,0.4579E+00,0.4136E+00,0.3714E+00,
     +0.3314E+00,0.2938E+00,0.2586E+00,0.2259E+00,0.1957E+00,0.1680E+00,
     +0.1428E+00,0.1200E+00,0.9941E-01,0.8099E-01,0.6463E-01,0.5027E-01,
     +0.3786E-01,0.2741E-01,0.1891E-01,0.1231E-01,0.7497E-02,0.4238E-02,
     +0.2896E-02,0.1970E-02,0.1336E-02,0.9032E-03,0.6066E-03,0.4025E-03,
     +0.2616E-03,0.1645E-03,0.9839E-04,0.5460E-04,0.2710E-04,0.1128E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,5),I=1,104) /
     +0.3267E+01,0.3139E+01,0.3016E+01,0.2898E+01,0.2785E+01,0.2676E+01,
     +0.2571E+01,0.2471E+01,0.2374E+01,0.2281E+01,0.2192E+01,0.2107E+01,
     +0.2025E+01,0.1946E+01,0.1870E+01,0.1798E+01,0.1728E+01,0.1661E+01,
     +0.1597E+01,0.1535E+01,0.1476E+01,0.1419E+01,0.1364E+01,0.1312E+01,
     +0.1262E+01,0.1213E+01,0.1167E+01,0.1123E+01,0.1080E+01,0.1039E+01,
     +0.9999E+00,0.9622E+00,0.9259E+00,0.8911E+00,0.8577E+00,0.8256E+00,
     +0.7947E+00,0.7649E+00,0.7363E+00,0.7088E+00,0.6823E+00,0.6567E+00,
     +0.6320E+00,0.6082E+00,0.5852E+00,0.5629E+00,0.5412E+00,0.5203E+00,
     +0.4999E+00,0.4800E+00,0.4607E+00,0.4418E+00,0.4233E+00,0.4052E+00,
     +0.3874E+00,0.3699E+00,0.3527E+00,0.3357E+00,0.3189E+00,0.3022E+00,
     +0.2858E+00,0.2695E+00,0.2534E+00,0.2375E+00,0.2217E+00,0.2062E+00,
     +0.1909E+00,0.1760E+00,0.1613E+00,0.1471E+00,0.1333E+00,0.1201E+00,
     +0.1075E+00,0.9553E-01,0.8427E-01,0.7375E-01,0.6400E-01,0.5502E-01,
     +0.4681E-01,0.3935E-01,0.3260E-01,0.2653E-01,0.2112E-01,0.1635E-01,
     +0.1222E-01,0.8737E-02,0.5915E-02,0.3745E-02,0.2191E-02,0.1172E-02,
     +0.7681E-03,0.5006E-03,0.3256E-03,0.2118E-03,0.1378E-03,0.8931E-04,
     +0.5714E-04,0.3560E-04,0.2120E-04,0.1176E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,6),I=1,104) /
     +0.3092E+01,0.2965E+01,0.2842E+01,0.2724E+01,0.2610E+01,0.2501E+01,
     +0.2397E+01,0.2296E+01,0.2200E+01,0.2107E+01,0.2018E+01,0.1933E+01,
     +0.1851E+01,0.1772E+01,0.1697E+01,0.1624E+01,0.1555E+01,0.1488E+01,
     +0.1424E+01,0.1362E+01,0.1303E+01,0.1246E+01,0.1192E+01,0.1140E+01,
     +0.1090E+01,0.1042E+01,0.9962E+00,0.9521E+00,0.9099E+00,0.8694E+00,
     +0.8305E+00,0.7933E+00,0.7576E+00,0.7234E+00,0.6906E+00,0.6592E+00,
     +0.6291E+00,0.6002E+00,0.5725E+00,0.5460E+00,0.5205E+00,0.4961E+00,
     +0.4727E+00,0.4503E+00,0.4287E+00,0.4081E+00,0.3882E+00,0.3692E+00,
     +0.3509E+00,0.3333E+00,0.3163E+00,0.3000E+00,0.2843E+00,0.2692E+00,
     +0.2546E+00,0.2404E+00,0.2268E+00,0.2136E+00,0.2009E+00,0.1886E+00,
     +0.1766E+00,0.1650E+00,0.1538E+00,0.1429E+00,0.1324E+00,0.1222E+00,
     +0.1124E+00,0.1029E+00,0.9381E-01,0.8510E-01,0.7679E-01,0.6890E-01,
     +0.6144E-01,0.5444E-01,0.4790E-01,0.4183E-01,0.3623E-01,0.3111E-01,
     +0.2645E-01,0.2222E-01,0.1842E-01,0.1502E-01,0.1201E-01,0.9361E-02,
     +0.7076E-02,0.5150E-02,0.3580E-02,0.2357E-02,0.1457E-02,0.8395E-03,
     +0.5812E-03,0.4008E-03,0.2753E-03,0.1881E-03,0.1275E-03,0.8523E-04,
     +0.5570E-04,0.3516E-04,0.2109E-04,0.1174E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,7),I=1,104) /
     +0.2976E+01,0.2848E+01,0.2725E+01,0.2607E+01,0.2494E+01,0.2385E+01,
     +0.2281E+01,0.2180E+01,0.2084E+01,0.1991E+01,0.1902E+01,0.1817E+01,
     +0.1735E+01,0.1657E+01,0.1581E+01,0.1509E+01,0.1439E+01,0.1372E+01,
     +0.1308E+01,0.1247E+01,0.1188E+01,0.1132E+01,0.1077E+01,0.1025E+01,
     +0.9756E+00,0.9279E+00,0.8821E+00,0.8383E+00,0.7963E+00,0.7561E+00,
     +0.7175E+00,0.6806E+00,0.6453E+00,0.6115E+00,0.5791E+00,0.5482E+00,
     +0.5186E+00,0.4902E+00,0.4632E+00,0.4373E+00,0.4126E+00,0.3890E+00,
     +0.3664E+00,0.3449E+00,0.3244E+00,0.3048E+00,0.2862E+00,0.2684E+00,
     +0.2515E+00,0.2354E+00,0.2200E+00,0.2055E+00,0.1916E+00,0.1785E+00,
     +0.1660E+00,0.1541E+00,0.1429E+00,0.1323E+00,0.1223E+00,0.1128E+00,
     +0.1038E+00,0.9535E-01,0.8738E-01,0.7988E-01,0.7284E-01,0.6623E-01,
     +0.6003E-01,0.5424E-01,0.4883E-01,0.4379E-01,0.3911E-01,0.3477E-01,
     +0.3075E-01,0.2706E-01,0.2366E-01,0.2056E-01,0.1774E-01,0.1518E-01,
     +0.1287E-01,0.1081E-01,0.8975E-02,0.7353E-02,0.5933E-02,0.4702E-02,
     +0.3648E-02,0.2759E-02,0.2024E-02,0.1431E-02,0.9670E-03,0.6180E-03,
     +0.4567E-03,0.3342E-03,0.2418E-03,0.1723E-03,0.1206E-03,0.8251E-04,
     +0.5473E-04,0.3487E-04,0.2101E-04,0.1172E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,8),I=1,104) /
     +0.2555E+01,0.2444E+01,0.2337E+01,0.2235E+01,0.2136E+01,0.2042E+01,
     +0.1951E+01,0.1864E+01,0.1780E+01,0.1700E+01,0.1623E+01,0.1549E+01,
     +0.1478E+01,0.1410E+01,0.1345E+01,0.1283E+01,0.1223E+01,0.1165E+01,
     +0.1110E+01,0.1057E+01,0.1006E+01,0.9577E+00,0.9112E+00,0.8666E+00,
     +0.8239E+00,0.7829E+00,0.7437E+00,0.7062E+00,0.6703E+00,0.6359E+00,
     +0.6029E+00,0.5715E+00,0.5413E+00,0.5125E+00,0.4850E+00,0.4586E+00,
     +0.4335E+00,0.4094E+00,0.3865E+00,0.3645E+00,0.3436E+00,0.3236E+00,
     +0.3046E+00,0.2864E+00,0.2691E+00,0.2526E+00,0.2369E+00,0.2219E+00,
     +0.2077E+00,0.1942E+00,0.1813E+00,0.1691E+00,0.1575E+00,0.1465E+00,
     +0.1360E+00,0.1262E+00,0.1168E+00,0.1080E+00,0.9960E-01,0.9171E-01,
     +0.8427E-01,0.7726E-01,0.7067E-01,0.6447E-01,0.5866E-01,0.5321E-01,
     +0.4812E-01,0.4336E-01,0.3893E-01,0.3482E-01,0.3100E-01,0.2747E-01,
     +0.2422E-01,0.2123E-01,0.1849E-01,0.1600E-01,0.1374E-01,0.1171E-01,
     +0.9881E-02,0.8253E-02,0.6812E-02,0.5547E-02,0.4447E-02,0.3500E-02,
     +0.2696E-02,0.2024E-02,0.1473E-02,0.1032E-02,0.6915E-03,0.4378E-03,
     +0.3216E-03,0.2339E-03,0.1681E-03,0.1191E-03,0.8277E-04,0.5617E-04,
     +0.3693E-04,0.2329E-04,0.1387E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,1),I=1,104) /
     +0.1805E-01,0.1905E-01,0.2011E-01,0.2123E-01,0.2240E-01,0.2364E-01,
     +0.2495E-01,0.2633E-01,0.2779E-01,0.2932E-01,0.3094E-01,0.3265E-01,
     +0.3444E-01,0.3634E-01,0.3833E-01,0.4044E-01,0.4265E-01,0.4498E-01,
     +0.4744E-01,0.5003E-01,0.5275E-01,0.5562E-01,0.5864E-01,0.6181E-01,
     +0.6516E-01,0.6867E-01,0.7237E-01,0.7625E-01,0.8034E-01,0.8463E-01,
     +0.8914E-01,0.9388E-01,0.9885E-01,0.1041E+00,0.1095E+00,0.1153E+00,
     +0.1213E+00,0.1276E+00,0.1342E+00,0.1411E+00,0.1483E+00,0.1559E+00,
     +0.1638E+00,0.1720E+00,0.1806E+00,0.1895E+00,0.1989E+00,0.2085E+00,
     +0.2186E+00,0.2290E+00,0.2398E+00,0.2510E+00,0.2625E+00,0.2744E+00,
     +0.2866E+00,0.2991E+00,0.3118E+00,0.3249E+00,0.3381E+00,0.3514E+00,
     +0.3649E+00,0.3784E+00,0.3917E+00,0.4049E+00,0.4178E+00,0.4303E+00,
     +0.4422E+00,0.4533E+00,0.4635E+00,0.4724E+00,0.4800E+00,0.4858E+00,
     +0.4897E+00,0.4914E+00,0.4904E+00,0.4865E+00,0.4794E+00,0.4688E+00,
     +0.4545E+00,0.4362E+00,0.4139E+00,0.3876E+00,0.3574E+00,0.3238E+00,
     +0.2872E+00,0.2486E+00,0.2090E+00,0.1695E+00,0.1317E+00,0.9683E-01,
     +0.7787E-01,0.6169E-01,0.4804E-01,0.3667E-01,0.2734E-01,0.1981E-01,
     +0.1384E-01,0.9242E-02,0.5807E-02,0.3357E-02,0.1718E-02,0.7264E-03,
     +0.2179E-03,0.2871E-04/
      DATA (XQDUM (I,5,2),I=1,104) /
     +0.1027E-01,0.1083E-01,0.1143E-01,0.1207E-01,0.1274E-01,0.1344E-01,
     +0.1418E-01,0.1496E-01,0.1579E-01,0.1666E-01,0.1757E-01,0.1854E-01,
     +0.1956E-01,0.2063E-01,0.2176E-01,0.2295E-01,0.2420E-01,0.2551E-01,
     +0.2690E-01,0.2836E-01,0.2990E-01,0.3151E-01,0.3322E-01,0.3500E-01,
     +0.3688E-01,0.3886E-01,0.4094E-01,0.4312E-01,0.4541E-01,0.4781E-01,
     +0.5034E-01,0.5299E-01,0.5576E-01,0.5867E-01,0.6172E-01,0.6492E-01,
     +0.6826E-01,0.7175E-01,0.7541E-01,0.7922E-01,0.8321E-01,0.8736E-01,
     +0.9169E-01,0.9619E-01,0.1009E+00,0.1057E+00,0.1108E+00,0.1160E+00,
     +0.1214E+00,0.1270E+00,0.1327E+00,0.1386E+00,0.1447E+00,0.1509E+00,
     +0.1572E+00,0.1636E+00,0.1701E+00,0.1767E+00,0.1832E+00,0.1898E+00,
     +0.1963E+00,0.2026E+00,0.2088E+00,0.2147E+00,0.2203E+00,0.2254E+00,
     +0.2301E+00,0.2341E+00,0.2374E+00,0.2399E+00,0.2413E+00,0.2416E+00,
     +0.2407E+00,0.2383E+00,0.2344E+00,0.2288E+00,0.2215E+00,0.2123E+00,
     +0.2013E+00,0.1884E+00,0.1738E+00,0.1577E+00,0.1403E+00,0.1220E+00,
     +0.1033E+00,0.8475E-01,0.6693E-01,0.5047E-01,0.3595E-01,0.2383E-01,
     +0.1781E-01,0.1304E-01,0.9338E-02,0.6510E-02,0.4397E-02,0.2858E-02,
     +0.1772E-02,0.1034E-02,0.5566E-03,0.2685E-03,0.1104E-03,0.3528E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,3),I=1,104) /
     +0.1333E+03,0.1273E+03,0.1216E+03,0.1160E+03,0.1107E+03,0.1056E+03,
     +0.1008E+03,0.9608E+02,0.9161E+02,0.8732E+02,0.8322E+02,0.7929E+02,
     +0.7552E+02,0.7192E+02,0.6847E+02,0.6517E+02,0.6201E+02,0.5898E+02,
     +0.5609E+02,0.5332E+02,0.5068E+02,0.4815E+02,0.4573E+02,0.4341E+02,
     +0.4120E+02,0.3909E+02,0.3707E+02,0.3514E+02,0.3330E+02,0.3154E+02,
     +0.2986E+02,0.2826E+02,0.2673E+02,0.2528E+02,0.2389E+02,0.2256E+02,
     +0.2129E+02,0.2009E+02,0.1894E+02,0.1785E+02,0.1681E+02,0.1582E+02,
     +0.1487E+02,0.1397E+02,0.1312E+02,0.1231E+02,0.1154E+02,0.1080E+02,
     +0.1011E+02,0.9446E+01,0.8819E+01,0.8224E+01,0.7659E+01,0.7125E+01,
     +0.6618E+01,0.6139E+01,0.5685E+01,0.5256E+01,0.4851E+01,0.4469E+01,
     +0.4108E+01,0.3768E+01,0.3448E+01,0.3147E+01,0.2864E+01,0.2599E+01,
     +0.2350E+01,0.2118E+01,0.1901E+01,0.1699E+01,0.1512E+01,0.1338E+01,
     +0.1178E+01,0.1030E+01,0.8944E+00,0.7707E+00,0.6584E+00,0.5568E+00,
     +0.4657E+00,0.3844E+00,0.3125E+00,0.2496E+00,0.1952E+00,0.1488E+00,
     +0.1100E+00,0.7819E-01,0.5287E-01,0.3342E-01,0.1915E-01,0.9323E-02,
     +0.5211E-02,0.2386E-02,0.5135E-03,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,4),I=1,104) /
     +0.2315E+02,0.2214E+02,0.2117E+02,0.2024E+02,0.1935E+02,0.1850E+02,
     +0.1768E+02,0.1689E+02,0.1614E+02,0.1542E+02,0.1473E+02,0.1407E+02,
     +0.1343E+02,0.1283E+02,0.1224E+02,0.1169E+02,0.1115E+02,0.1064E+02,
     +0.1015E+02,0.9686E+01,0.9238E+01,0.8809E+01,0.8399E+01,0.8006E+01,
     +0.7630E+01,0.7271E+01,0.6927E+01,0.6598E+01,0.6284E+01,0.5984E+01,
     +0.5696E+01,0.5422E+01,0.5159E+01,0.4908E+01,0.4668E+01,0.4439E+01,
     +0.4220E+01,0.4011E+01,0.3811E+01,0.3620E+01,0.3437E+01,0.3263E+01,
     +0.3096E+01,0.2937E+01,0.2784E+01,0.2639E+01,0.2499E+01,0.2366E+01,
     +0.2238E+01,0.2116E+01,0.1999E+01,0.1887E+01,0.1780E+01,0.1677E+01,
     +0.1578E+01,0.1483E+01,0.1391E+01,0.1304E+01,0.1219E+01,0.1138E+01,
     +0.1060E+01,0.9846E+00,0.9122E+00,0.8427E+00,0.7759E+00,0.7118E+00,
     +0.6505E+00,0.5918E+00,0.5360E+00,0.4830E+00,0.4328E+00,0.3856E+00,
     +0.3414E+00,0.3002E+00,0.2621E+00,0.2271E+00,0.1950E+00,0.1659E+00,
     +0.1397E+00,0.1161E+00,0.9516E-01,0.7660E-01,0.6036E-01,0.4632E-01,
     +0.3441E-01,0.2458E-01,0.1674E-01,0.1078E-01,0.6506E-02,0.3659E-02,
     +0.2496E-02,0.1695E-02,0.1147E-02,0.7717E-03,0.5142E-03,0.3373E-03,
     +0.2157E-03,0.1328E-03,0.7740E-04,0.4164E-04,0.1990E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,5),I=1,104) /
     +0.4717E+01,0.4519E+01,0.4329E+01,0.4146E+01,0.3972E+01,0.3804E+01,
     +0.3643E+01,0.3489E+01,0.3341E+01,0.3199E+01,0.3063E+01,0.2933E+01,
     +0.2808E+01,0.2689E+01,0.2574E+01,0.2464E+01,0.2359E+01,0.2258E+01,
     +0.2162E+01,0.2069E+01,0.1981E+01,0.1896E+01,0.1815E+01,0.1737E+01,
     +0.1663E+01,0.1591E+01,0.1523E+01,0.1458E+01,0.1396E+01,0.1336E+01,
     +0.1278E+01,0.1224E+01,0.1171E+01,0.1121E+01,0.1073E+01,0.1027E+01,
     +0.9826E+00,0.9403E+00,0.8998E+00,0.8609E+00,0.8236E+00,0.7879E+00,
     +0.7535E+00,0.7205E+00,0.6888E+00,0.6583E+00,0.6289E+00,0.6005E+00,
     +0.5732E+00,0.5468E+00,0.5212E+00,0.4965E+00,0.4725E+00,0.4492E+00,
     +0.4265E+00,0.4044E+00,0.3829E+00,0.3619E+00,0.3414E+00,0.3214E+00,
     +0.3018E+00,0.2827E+00,0.2639E+00,0.2456E+00,0.2277E+00,0.2103E+00,
     +0.1934E+00,0.1770E+00,0.1612E+00,0.1460E+00,0.1314E+00,0.1176E+00,
     +0.1045E+00,0.9224E-01,0.8079E-01,0.7019E-01,0.6045E-01,0.5155E-01,
     +0.4348E-01,0.3620E-01,0.2968E-01,0.2389E-01,0.1878E-01,0.1434E-01,
     +0.1057E-01,0.7444E-02,0.4966E-02,0.3103E-02,0.1797E-02,0.9556E-03,
     +0.6265E-03,0.4091E-03,0.2668E-03,0.1739E-03,0.1130E-03,0.7281E-04,
     +0.4606E-04,0.2821E-04,0.1641E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,6),I=1,104) /
     +0.4543E+01,0.4345E+01,0.4155E+01,0.3972E+01,0.3798E+01,0.3630E+01,
     +0.3469E+01,0.3315E+01,0.3167E+01,0.3025E+01,0.2890E+01,0.2760E+01,
     +0.2635E+01,0.2515E+01,0.2401E+01,0.2291E+01,0.2186E+01,0.2086E+01,
     +0.1989E+01,0.1897E+01,0.1809E+01,0.1724E+01,0.1643E+01,0.1566E+01,
     +0.1492E+01,0.1421E+01,0.1353E+01,0.1288E+01,0.1226E+01,0.1167E+01,
     +0.1110E+01,0.1056E+01,0.1004E+01,0.9548E+00,0.9075E+00,0.8622E+00,
     +0.8190E+00,0.7777E+00,0.7382E+00,0.7005E+00,0.6644E+00,0.6300E+00,
     +0.5971E+00,0.5657E+00,0.5357E+00,0.5070E+00,0.4795E+00,0.4533E+00,
     +0.4282E+00,0.4043E+00,0.3813E+00,0.3594E+00,0.3384E+00,0.3183E+00,
     +0.2990E+00,0.2805E+00,0.2628E+00,0.2458E+00,0.2295E+00,0.2139E+00,
     +0.1989E+00,0.1845E+00,0.1707E+00,0.1574E+00,0.1448E+00,0.1326E+00,
     +0.1211E+00,0.1100E+00,0.9957E-01,0.8964E-01,0.8028E-01,0.7148E-01,
     +0.6325E-01,0.5561E-01,0.4854E-01,0.4204E-01,0.3611E-01,0.3072E-01,
     +0.2587E-01,0.2152E-01,0.1764E-01,0.1422E-01,0.1122E-01,0.8634E-02,
     +0.6438E-02,0.4623E-02,0.3172E-02,0.2064E-02,0.1263E-02,0.7229E-03,
     +0.4987E-03,0.3425E-03,0.2342E-03,0.1590E-03,0.1067E-03,0.7041E-04,
     +0.4524E-04,0.2797E-04,0.1635E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,7),I=1,104) /
     +0.4427E+01,0.4229E+01,0.4039E+01,0.3856E+01,0.3681E+01,0.3514E+01,
     +0.3353E+01,0.3199E+01,0.3051E+01,0.2910E+01,0.2774E+01,0.2644E+01,
     +0.2519E+01,0.2400E+01,0.2286E+01,0.2176E+01,0.2071E+01,0.1971E+01,
     +0.1874E+01,0.1782E+01,0.1694E+01,0.1610E+01,0.1529E+01,0.1452E+01,
     +0.1378E+01,0.1307E+01,0.1240E+01,0.1175E+01,0.1114E+01,0.1055E+01,
     +0.9983E+00,0.9445E+00,0.8931E+00,0.8440E+00,0.7972E+00,0.7525E+00,
     +0.7098E+00,0.6692E+00,0.6304E+00,0.5935E+00,0.5582E+00,0.5247E+00,
     +0.4928E+00,0.4624E+00,0.4335E+00,0.4060E+00,0.3799E+00,0.3551E+00,
     +0.3316E+00,0.3092E+00,0.2881E+00,0.2680E+00,0.2490E+00,0.2310E+00,
     +0.2140E+00,0.1979E+00,0.1827E+00,0.1684E+00,0.1549E+00,0.1422E+00,
     +0.1303E+00,0.1191E+00,0.1085E+00,0.9869E-01,0.8948E-01,0.8089E-01,
     +0.7287E-01,0.6542E-01,0.5851E-01,0.5210E-01,0.4619E-01,0.4075E-01,
     +0.3576E-01,0.3120E-01,0.2705E-01,0.2328E-01,0.1989E-01,0.1685E-01,
     +0.1413E-01,0.1173E-01,0.9617E-02,0.7776E-02,0.6187E-02,0.4830E-02,
     +0.3688E-02,0.2743E-02,0.1977E-02,0.1371E-02,0.9079E-03,0.5676E-03,
     +0.4134E-03,0.2982E-03,0.2124E-03,0.1490E-03,0.1025E-03,0.6881E-04,
     +0.4470E-04,0.2781E-04,0.1632E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,8),I=1,104) /
     +0.4025E+01,0.3842E+01,0.3668E+01,0.3500E+01,0.3340E+01,0.3186E+01,
     +0.3038E+01,0.2897E+01,0.2761E+01,0.2632E+01,0.2507E+01,0.2388E+01,
     +0.2274E+01,0.2165E+01,0.2061E+01,0.1961E+01,0.1865E+01,0.1773E+01,
     +0.1685E+01,0.1602E+01,0.1521E+01,0.1444E+01,0.1371E+01,0.1301E+01,
     +0.1234E+01,0.1170E+01,0.1108E+01,0.1050E+01,0.9940E+00,0.9406E+00,
     +0.8897E+00,0.8410E+00,0.7946E+00,0.7503E+00,0.7081E+00,0.6678E+00,
     +0.6294E+00,0.5928E+00,0.5580E+00,0.5248E+00,0.4932E+00,0.4631E+00,
     +0.4345E+00,0.4073E+00,0.3815E+00,0.3569E+00,0.3336E+00,0.3115E+00,
     +0.2905E+00,0.2706E+00,0.2518E+00,0.2340E+00,0.2171E+00,0.2011E+00,
     +0.1861E+00,0.1719E+00,0.1584E+00,0.1458E+00,0.1339E+00,0.1227E+00,
     +0.1122E+00,0.1024E+00,0.9316E-01,0.8453E-01,0.7648E-01,0.6898E-01,
     +0.6200E-01,0.5552E-01,0.4952E-01,0.4398E-01,0.3887E-01,0.3419E-01,
     +0.2990E-01,0.2599E-01,0.2245E-01,0.1924E-01,0.1637E-01,0.1380E-01,
     +0.1152E-01,0.9509E-02,0.7752E-02,0.6229E-02,0.4923E-02,0.3817E-02,
     +0.2893E-02,0.2135E-02,0.1525E-02,0.1049E-02,0.6879E-03,0.4257E-03,
     +0.3080E-03,0.2207E-03,0.1561E-03,0.1087E-03,0.7421E-04,0.4937E-04,
     +0.3176E-04,0.1953E-04,0.1131E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,9),I=1,104) /
     +0.7184E+00,0.6836E+00,0.6503E+00,0.6185E+00,0.5881E+00,0.5591E+00,
     +0.5313E+00,0.5048E+00,0.4794E+00,0.4552E+00,0.4321E+00,0.4101E+00,
     +0.3890E+00,0.3689E+00,0.3498E+00,0.3315E+00,0.3140E+00,0.2974E+00,
     +0.2815E+00,0.2664E+00,0.2520E+00,0.2383E+00,0.2252E+00,0.2127E+00,
     +0.2009E+00,0.1896E+00,0.1788E+00,0.1686E+00,0.1589E+00,0.1497E+00,
     +0.1409E+00,0.1325E+00,0.1246E+00,0.1171E+00,0.1099E+00,0.1032E+00,
     +0.9673E-01,0.9063E-01,0.8485E-01,0.7938E-01,0.7419E-01,0.6928E-01,
     +0.6464E-01,0.6025E-01,0.5610E-01,0.5218E-01,0.4848E-01,0.4498E-01,
     +0.4169E-01,0.3859E-01,0.3567E-01,0.3292E-01,0.3034E-01,0.2792E-01,
     +0.2564E-01,0.2351E-01,0.2151E-01,0.1964E-01,0.1790E-01,0.1627E-01,
     +0.1475E-01,0.1334E-01,0.1203E-01,0.1081E-01,0.9690E-02,0.8653E-02,
     +0.7697E-02,0.6818E-02,0.6013E-02,0.5278E-02,0.4608E-02,0.4001E-02,
     +0.3452E-02,0.2959E-02,0.2517E-02,0.2124E-02,0.1776E-02,0.1471E-02,
     +0.1204E-02,0.9740E-03,0.7768E-03,0.6096E-03,0.4698E-03,0.3544E-03,
     +0.2609E-03,0.1866E-03,0.1289E-03,0.8547E-04,0.5390E-04,0.3193E-04,
     +0.2245E-04,0.1560E-04,0.1070E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,1),I=1,104) /
     +0.1976E-01,0.2085E-01,0.2201E-01,0.2322E-01,0.2450E-01,0.2584E-01,
     +0.2726E-01,0.2876E-01,0.3033E-01,0.3200E-01,0.3374E-01,0.3559E-01,
     +0.3753E-01,0.3957E-01,0.4172E-01,0.4398E-01,0.4637E-01,0.4888E-01,
     +0.5151E-01,0.5429E-01,0.5721E-01,0.6028E-01,0.6351E-01,0.6690E-01,
     +0.7047E-01,0.7421E-01,0.7815E-01,0.8228E-01,0.8661E-01,0.9116E-01,
     +0.9594E-01,0.1009E+00,0.1062E+00,0.1117E+00,0.1174E+00,0.1235E+00,
     +0.1298E+00,0.1364E+00,0.1432E+00,0.1504E+00,0.1579E+00,0.1658E+00,
     +0.1739E+00,0.1824E+00,0.1912E+00,0.2004E+00,0.2099E+00,0.2198E+00,
     +0.2300E+00,0.2405E+00,0.2514E+00,0.2626E+00,0.2741E+00,0.2859E+00,
     +0.2980E+00,0.3103E+00,0.3228E+00,0.3354E+00,0.3482E+00,0.3610E+00,
     +0.3738E+00,0.3864E+00,0.3989E+00,0.4110E+00,0.4227E+00,0.4338E+00,
     +0.4441E+00,0.4535E+00,0.4618E+00,0.4687E+00,0.4740E+00,0.4775E+00,
     +0.4789E+00,0.4779E+00,0.4743E+00,0.4678E+00,0.4580E+00,0.4449E+00,
     +0.4282E+00,0.4079E+00,0.3839E+00,0.3563E+00,0.3255E+00,0.2920E+00,
     +0.2562E+00,0.2192E+00,0.1819E+00,0.1454E+00,0.1112E+00,0.8028E-01,
     +0.6376E-01,0.4985E-01,0.3828E-01,0.2878E-01,0.2111E-01,0.1501E-01,
     +0.1028E-01,0.6698E-02,0.4089E-02,0.2281E-02,0.1114E-02,0.4403E-03,
     +0.1171E-03,0.1032E-04/
      DATA (XQDUM (I,6,2),I=1,104) /
     +0.1123E-01,0.1185E-01,0.1250E-01,0.1319E-01,0.1391E-01,0.1467E-01,
     +0.1548E-01,0.1632E-01,0.1721E-01,0.1815E-01,0.1914E-01,0.2018E-01,
     +0.2128E-01,0.2243E-01,0.2364E-01,0.2492E-01,0.2626E-01,0.2768E-01,
     +0.2916E-01,0.3072E-01,0.3236E-01,0.3409E-01,0.3590E-01,0.3781E-01,
     +0.3980E-01,0.4190E-01,0.4410E-01,0.4641E-01,0.4884E-01,0.5137E-01,
     +0.5403E-01,0.5682E-01,0.5974E-01,0.6279E-01,0.6598E-01,0.6931E-01,
     +0.7279E-01,0.7642E-01,0.8021E-01,0.8416E-01,0.8827E-01,0.9254E-01,
     +0.9699E-01,0.1016E+00,0.1064E+00,0.1113E+00,0.1164E+00,0.1217E+00,
     +0.1271E+00,0.1327E+00,0.1384E+00,0.1443E+00,0.1503E+00,0.1563E+00,
     +0.1625E+00,0.1687E+00,0.1750E+00,0.1812E+00,0.1874E+00,0.1936E+00,
     +0.1995E+00,0.2053E+00,0.2109E+00,0.2161E+00,0.2209E+00,0.2252E+00,
     +0.2289E+00,0.2320E+00,0.2342E+00,0.2355E+00,0.2357E+00,0.2348E+00,
     +0.2326E+00,0.2290E+00,0.2238E+00,0.2171E+00,0.2087E+00,0.1986E+00,
     +0.1868E+00,0.1734E+00,0.1586E+00,0.1425E+00,0.1255E+00,0.1080E+00,
     +0.9035E-01,0.7317E-01,0.5698E-01,0.4230E-01,0.2961E-01,0.1924E-01,
     +0.1418E-01,0.1024E-01,0.7220E-02,0.4951E-02,0.3285E-02,0.2093E-02,
     +0.1268E-02,0.7203E-03,0.3757E-03,0.1741E-03,0.6777E-04,0.1992E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,3),I=1,104) /
     +0.1651E+03,0.1572E+03,0.1497E+03,0.1425E+03,0.1356E+03,0.1290E+03,
     +0.1227E+03,0.1167E+03,0.1109E+03,0.1054E+03,0.1001E+03,0.9512E+02,
     +0.9033E+02,0.8575E+02,0.8137E+02,0.7720E+02,0.7322E+02,0.6942E+02,
     +0.6579E+02,0.6234E+02,0.5904E+02,0.5589E+02,0.5290E+02,0.5004E+02,
     +0.4732E+02,0.4473E+02,0.4226E+02,0.3992E+02,0.3768E+02,0.3555E+02,
     +0.3353E+02,0.3160E+02,0.2977E+02,0.2803E+02,0.2638E+02,0.2481E+02,
     +0.2332E+02,0.2191E+02,0.2056E+02,0.1929E+02,0.1808E+02,0.1694E+02,
     +0.1585E+02,0.1482E+02,0.1385E+02,0.1293E+02,0.1206E+02,0.1123E+02,
     +0.1045E+02,0.9719E+01,0.9024E+01,0.8369E+01,0.7751E+01,0.7169E+01,
     +0.6621E+01,0.6105E+01,0.5620E+01,0.5164E+01,0.4736E+01,0.4335E+01,
     +0.3958E+01,0.3606E+01,0.3277E+01,0.2970E+01,0.2684E+01,0.2417E+01,
     +0.2170E+01,0.1940E+01,0.1728E+01,0.1532E+01,0.1352E+01,0.1186E+01,
     +0.1035E+01,0.8965E+00,0.7713E+00,0.6581E+00,0.5565E+00,0.4656E+00,
     +0.3850E+00,0.3140E+00,0.2521E+00,0.1986E+00,0.1529E+00,0.1146E+00,
     +0.8309E-01,0.5773E-01,0.3794E-01,0.2309E-01,0.1249E-01,0.5436E-02,
     +0.2596E-02,0.7200E-03,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,4),I=1,104) /
     +0.3186E+02,0.3041E+02,0.2901E+02,0.2768E+02,0.2640E+02,0.2518E+02,
     +0.2401E+02,0.2289E+02,0.2181E+02,0.2079E+02,0.1981E+02,0.1887E+02,
     +0.1797E+02,0.1712E+02,0.1630E+02,0.1551E+02,0.1476E+02,0.1405E+02,
     +0.1336E+02,0.1271E+02,0.1209E+02,0.1149E+02,0.1092E+02,0.1038E+02,
     +0.9859E+01,0.9364E+01,0.8892E+01,0.8441E+01,0.8012E+01,0.7602E+01,
     +0.7211E+01,0.6838E+01,0.6483E+01,0.6144E+01,0.5821E+01,0.5513E+01,
     +0.5220E+01,0.4941E+01,0.4675E+01,0.4421E+01,0.4180E+01,0.3950E+01,
     +0.3731E+01,0.3522E+01,0.3324E+01,0.3135E+01,0.2954E+01,0.2783E+01,
     +0.2619E+01,0.2463E+01,0.2315E+01,0.2173E+01,0.2038E+01,0.1909E+01,
     +0.1787E+01,0.1669E+01,0.1557E+01,0.1451E+01,0.1348E+01,0.1251E+01,
     +0.1158E+01,0.1069E+01,0.9846E+00,0.9039E+00,0.8271E+00,0.7540E+00,
     +0.6846E+00,0.6190E+00,0.5570E+00,0.4987E+00,0.4440E+00,0.3930E+00,
     +0.3457E+00,0.3020E+00,0.2618E+00,0.2252E+00,0.1920E+00,0.1621E+00,
     +0.1353E+00,0.1115E+00,0.9052E-01,0.7214E-01,0.5624E-01,0.4268E-01,
     +0.3134E-01,0.2213E-01,0.1490E-01,0.9494E-02,0.5681E-02,0.3170E-02,
     +0.2153E-02,0.1456E-02,0.9795E-03,0.6543E-03,0.4319E-03,0.2799E-03,
     +0.1763E-03,0.1066E-03,0.6080E-04,0.3188E-04,0.1478E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,5),I=1,104) /
     +0.6142E+01,0.5871E+01,0.5610E+01,0.5361E+01,0.5123E+01,0.4895E+01,
     +0.4676E+01,0.4467E+01,0.4266E+01,0.4074E+01,0.3891E+01,0.3715E+01,
     +0.3548E+01,0.3387E+01,0.3233E+01,0.3086E+01,0.2946E+01,0.2811E+01,
     +0.2683E+01,0.2560E+01,0.2443E+01,0.2331E+01,0.2224E+01,0.2121E+01,
     +0.2023E+01,0.1930E+01,0.1841E+01,0.1755E+01,0.1674E+01,0.1596E+01,
     +0.1522E+01,0.1451E+01,0.1383E+01,0.1319E+01,0.1257E+01,0.1198E+01,
     +0.1142E+01,0.1088E+01,0.1036E+01,0.9873E+00,0.9403E+00,0.8954E+00,
     +0.8524E+00,0.8113E+00,0.7719E+00,0.7341E+00,0.6979E+00,0.6632E+00,
     +0.6299E+00,0.5978E+00,0.5670E+00,0.5373E+00,0.5087E+00,0.4811E+00,
     +0.4545E+00,0.4287E+00,0.4038E+00,0.3796E+00,0.3562E+00,0.3335E+00,
     +0.3115E+00,0.2901E+00,0.2694E+00,0.2493E+00,0.2299E+00,0.2112E+00,
     +0.1931E+00,0.1758E+00,0.1592E+00,0.1434E+00,0.1284E+00,0.1142E+00,
     +0.1009E+00,0.8858E-01,0.7713E-01,0.6660E-01,0.5699E-01,0.4827E-01,
     +0.4041E-01,0.3338E-01,0.2713E-01,0.2163E-01,0.1683E-01,0.1271E-01,
     +0.9253E-02,0.6440E-02,0.4244E-02,0.2622E-02,0.1503E-02,0.7938E-03,
     +0.5190E-03,0.3383E-03,0.2203E-03,0.1431E-03,0.9255E-04,0.5914E-04,
     +0.3697E-04,0.2229E-04,0.1271E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,6),I=1,104) /
     +0.5968E+01,0.5697E+01,0.5437E+01,0.5188E+01,0.4949E+01,0.4721E+01,
     +0.4502E+01,0.4293E+01,0.4093E+01,0.3901E+01,0.3718E+01,0.3542E+01,
     +0.3375E+01,0.3214E+01,0.3061E+01,0.2914E+01,0.2774E+01,0.2639E+01,
     +0.2511E+01,0.2389E+01,0.2272E+01,0.2160E+01,0.2053E+01,0.1951E+01,
     +0.1854E+01,0.1761E+01,0.1672E+01,0.1587E+01,0.1506E+01,0.1429E+01,
     +0.1355E+01,0.1285E+01,0.1218E+01,0.1154E+01,0.1093E+01,0.1035E+01,
     +0.9799E+00,0.9272E+00,0.8769E+00,0.8291E+00,0.7835E+00,0.7400E+00,
     +0.6986E+00,0.6592E+00,0.6217E+00,0.5859E+00,0.5519E+00,0.5194E+00,
     +0.4886E+00,0.4591E+00,0.4311E+00,0.4044E+00,0.3789E+00,0.3547E+00,
     +0.3315E+00,0.3095E+00,0.2885E+00,0.2684E+00,0.2493E+00,0.2311E+00,
     +0.2137E+00,0.1971E+00,0.1814E+00,0.1664E+00,0.1521E+00,0.1386E+00,
     +0.1258E+00,0.1136E+00,0.1022E+00,0.9147E-01,0.8142E-01,0.7206E-01,
     +0.6337E-01,0.5535E-01,0.4800E-01,0.4130E-01,0.3522E-01,0.2974E-01,
     +0.2485E-01,0.2049E-01,0.1665E-01,0.1329E-01,0.1038E-01,0.7900E-02,
     +0.5825E-02,0.4135E-02,0.2805E-02,0.1806E-02,0.1094E-02,0.6205E-03,
     +0.4257E-03,0.2907E-03,0.1974E-03,0.1330E-03,0.8838E-04,0.5760E-04,
     +0.3646E-04,0.2215E-04,0.1268E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,7),I=1,104) /
     +0.5852E+01,0.5581E+01,0.5321E+01,0.5072E+01,0.4833E+01,0.4605E+01,
     +0.4386E+01,0.4177E+01,0.3977E+01,0.3786E+01,0.3602E+01,0.3427E+01,
     +0.3259E+01,0.3099E+01,0.2946E+01,0.2799E+01,0.2659E+01,0.2525E+01,
     +0.2397E+01,0.2274E+01,0.2157E+01,0.2046E+01,0.1939E+01,0.1837E+01,
     +0.1740E+01,0.1647E+01,0.1559E+01,0.1474E+01,0.1394E+01,0.1317E+01,
     +0.1244E+01,0.1174E+01,0.1108E+01,0.1044E+01,0.9840E+00,0.9266E+00,
     +0.8720E+00,0.8200E+00,0.7705E+00,0.7235E+00,0.6788E+00,0.6364E+00,
     +0.5961E+00,0.5578E+00,0.5215E+00,0.4871E+00,0.4545E+00,0.4236E+00,
     +0.3943E+00,0.3666E+00,0.3404E+00,0.3157E+00,0.2924E+00,0.2703E+00,
     +0.2496E+00,0.2300E+00,0.2116E+00,0.1943E+00,0.1781E+00,0.1628E+00,
     +0.1486E+00,0.1352E+00,0.1227E+00,0.1111E+00,0.1003E+00,0.9020E-01,
     +0.8086E-01,0.7222E-01,0.6424E-01,0.5689E-01,0.5014E-01,0.4397E-01,
     +0.3834E-01,0.3323E-01,0.2860E-01,0.2444E-01,0.2072E-01,0.1740E-01,
     +0.1447E-01,0.1190E-01,0.9665E-02,0.7734E-02,0.6086E-02,0.4696E-02,
     +0.3541E-02,0.2599E-02,0.1847E-02,0.1262E-02,0.8221E-03,0.5049E-03,
     +0.3635E-03,0.2590E-03,0.1822E-03,0.1262E-03,0.8560E-04,0.5657E-04,
     +0.3613E-04,0.2205E-04,0.1266E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,8),I=1,104) /
     +0.5465E+01,0.5209E+01,0.4963E+01,0.4729E+01,0.4504E+01,0.4289E+01,
     +0.4083E+01,0.3887E+01,0.3698E+01,0.3518E+01,0.3346E+01,0.3181E+01,
     +0.3024E+01,0.2873E+01,0.2729E+01,0.2592E+01,0.2461E+01,0.2335E+01,
     +0.2215E+01,0.2101E+01,0.1991E+01,0.1887E+01,0.1788E+01,0.1693E+01,
     +0.1602E+01,0.1515E+01,0.1433E+01,0.1354E+01,0.1279E+01,0.1208E+01,
     +0.1140E+01,0.1075E+01,0.1014E+01,0.9548E+00,0.8989E+00,0.8458E+00,
     +0.7952E+00,0.7472E+00,0.7015E+00,0.6581E+00,0.6169E+00,0.5778E+00,
     +0.5407E+00,0.5055E+00,0.4721E+00,0.4405E+00,0.4106E+00,0.3822E+00,
     +0.3554E+00,0.3301E+00,0.3062E+00,0.2836E+00,0.2623E+00,0.2422E+00,
     +0.2233E+00,0.2055E+00,0.1888E+00,0.1731E+00,0.1584E+00,0.1446E+00,
     +0.1317E+00,0.1196E+00,0.1084E+00,0.9793E-01,0.8819E-01,0.7916E-01,
     +0.7080E-01,0.6308E-01,0.5596E-01,0.4942E-01,0.4343E-01,0.3796E-01,
     +0.3299E-01,0.2849E-01,0.2443E-01,0.2079E-01,0.1755E-01,0.1467E-01,
     +0.1214E-01,0.9932E-02,0.8018E-02,0.6376E-02,0.4984E-02,0.3818E-02,
     +0.2858E-02,0.2080E-02,0.1465E-02,0.9919E-03,0.6399E-03,0.3888E-03,
     +0.2779E-03,0.1966E-03,0.1373E-03,0.9430E-04,0.6342E-04,0.4151E-04,
     +0.2623E-04,0.1582E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,9),I=1,104) /
     +0.2294E+01,0.2180E+01,0.2071E+01,0.1967E+01,0.1867E+01,0.1772E+01,
     +0.1682E+01,0.1595E+01,0.1513E+01,0.1434E+01,0.1359E+01,0.1288E+01,
     +0.1220E+01,0.1155E+01,0.1093E+01,0.1034E+01,0.9782E+00,0.9248E+00,
     +0.8739E+00,0.8255E+00,0.7795E+00,0.7357E+00,0.6940E+00,0.6544E+00,
     +0.6168E+00,0.5810E+00,0.5471E+00,0.5148E+00,0.4842E+00,0.4551E+00,
     +0.4275E+00,0.4014E+00,0.3766E+00,0.3531E+00,0.3308E+00,0.3097E+00,
     +0.2898E+00,0.2709E+00,0.2530E+00,0.2362E+00,0.2202E+00,0.2051E+00,
     +0.1909E+00,0.1775E+00,0.1648E+00,0.1529E+00,0.1417E+00,0.1311E+00,
     +0.1212E+00,0.1119E+00,0.1031E+00,0.9487E-01,0.8716E-01,0.7994E-01,
     +0.7319E-01,0.6688E-01,0.6098E-01,0.5549E-01,0.5038E-01,0.4563E-01,
     +0.4121E-01,0.3712E-01,0.3334E-01,0.2985E-01,0.2663E-01,0.2367E-01,
     +0.2095E-01,0.1847E-01,0.1620E-01,0.1415E-01,0.1228E-01,0.1060E-01,
     +0.9091E-02,0.7740E-02,0.6540E-02,0.5479E-02,0.4547E-02,0.3734E-02,
     +0.3031E-02,0.2429E-02,0.1917E-02,0.1489E-02,0.1134E-02,0.8450E-03,
     +0.6136E-03,0.4324E-03,0.2941E-03,0.1916E-03,0.1185E-03,0.6871E-04,
     +0.4759E-04,0.3258E-04,0.2198E-04,0.1455E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,1),I=1,104) /
     +0.2135E-01,0.2252E-01,0.2376E-01,0.2506E-01,0.2643E-01,0.2787E-01,
     +0.2939E-01,0.3099E-01,0.3268E-01,0.3445E-01,0.3632E-01,0.3828E-01,
     +0.4035E-01,0.4253E-01,0.4482E-01,0.4723E-01,0.4976E-01,0.5243E-01,
     +0.5523E-01,0.5817E-01,0.6126E-01,0.6451E-01,0.6792E-01,0.7150E-01,
     +0.7527E-01,0.7921E-01,0.8335E-01,0.8769E-01,0.9225E-01,0.9702E-01,
     +0.1020E+00,0.1072E+00,0.1127E+00,0.1185E+00,0.1244E+00,0.1307E+00,
     +0.1372E+00,0.1441E+00,0.1512E+00,0.1586E+00,0.1663E+00,0.1744E+00,
     +0.1827E+00,0.1914E+00,0.2004E+00,0.2097E+00,0.2194E+00,0.2293E+00,
     +0.2396E+00,0.2502E+00,0.2611E+00,0.2723E+00,0.2837E+00,0.2954E+00,
     +0.3073E+00,0.3193E+00,0.3315E+00,0.3438E+00,0.3560E+00,0.3683E+00,
     +0.3804E+00,0.3922E+00,0.4038E+00,0.4149E+00,0.4254E+00,0.4352E+00,
     +0.4442E+00,0.4520E+00,0.4586E+00,0.4638E+00,0.4672E+00,0.4687E+00,
     +0.4680E+00,0.4649E+00,0.4591E+00,0.4505E+00,0.4387E+00,0.4237E+00,
     +0.4053E+00,0.3835E+00,0.3584E+00,0.3302E+00,0.2993E+00,0.2661E+00,
     +0.2314E+00,0.1959E+00,0.1608E+00,0.1270E+00,0.9580E-01,0.6810E-01,
     +0.5351E-01,0.4136E-01,0.3138E-01,0.2329E-01,0.1684E-01,0.1179E-01,
     +0.7924E-02,0.5057E-02,0.3011E-02,0.1628E-02,0.7625E-03,0.2828E-03,
     +0.6643E-04,0.0000E+00/
      DATA (XQDUM (I,7,2),I=1,104) /
     +0.1212E-01,0.1278E-01,0.1348E-01,0.1422E-01,0.1499E-01,0.1581E-01,
     +0.1667E-01,0.1757E-01,0.1852E-01,0.1952E-01,0.2057E-01,0.2168E-01,
     +0.2285E-01,0.2407E-01,0.2536E-01,0.2672E-01,0.2814E-01,0.2964E-01,
     +0.3121E-01,0.3286E-01,0.3460E-01,0.3642E-01,0.3833E-01,0.4033E-01,
     +0.4243E-01,0.4464E-01,0.4695E-01,0.4937E-01,0.5190E-01,0.5455E-01,
     +0.5732E-01,0.6022E-01,0.6326E-01,0.6642E-01,0.6973E-01,0.7317E-01,
     +0.7677E-01,0.8051E-01,0.8440E-01,0.8845E-01,0.9266E-01,0.9702E-01,
     +0.1015E+00,0.1062E+00,0.1111E+00,0.1160E+00,0.1212E+00,0.1265E+00,
     +0.1319E+00,0.1375E+00,0.1431E+00,0.1489E+00,0.1548E+00,0.1607E+00,
     +0.1667E+00,0.1727E+00,0.1787E+00,0.1846E+00,0.1905E+00,0.1962E+00,
     +0.2017E+00,0.2070E+00,0.2120E+00,0.2166E+00,0.2207E+00,0.2242E+00,
     +0.2271E+00,0.2293E+00,0.2306E+00,0.2309E+00,0.2302E+00,0.2283E+00,
     +0.2250E+00,0.2204E+00,0.2143E+00,0.2067E+00,0.1975E+00,0.1868E+00,
     +0.1745E+00,0.1609E+00,0.1460E+00,0.1302E+00,0.1137E+00,0.9687E-01,
     +0.8025E-01,0.6428E-01,0.4946E-01,0.3624E-01,0.2499E-01,0.1596E-01,
     +0.1163E-01,0.8295E-02,0.5772E-02,0.3902E-02,0.2549E-02,0.1596E-02,
     +0.9482E-03,0.5263E-03,0.2668E-03,0.1192E-03,0.4414E-04,0.1195E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,3),I=1,104) /
     +0.1958E+03,0.1861E+03,0.1767E+03,0.1678E+03,0.1593E+03,0.1512E+03,
     +0.1434E+03,0.1360E+03,0.1290E+03,0.1223E+03,0.1159E+03,0.1098E+03,
     +0.1040E+03,0.9842E+02,0.9315E+02,0.8813E+02,0.8334E+02,0.7879E+02,
     +0.7447E+02,0.7035E+02,0.6643E+02,0.6271E+02,0.5917E+02,0.5580E+02,
     +0.5261E+02,0.4957E+02,0.4669E+02,0.4395E+02,0.4135E+02,0.3889E+02,
     +0.3655E+02,0.3434E+02,0.3224E+02,0.3025E+02,0.2837E+02,0.2659E+02,
     +0.2490E+02,0.2330E+02,0.2179E+02,0.2036E+02,0.1902E+02,0.1774E+02,
     +0.1654E+02,0.1541E+02,0.1434E+02,0.1333E+02,0.1238E+02,0.1148E+02,
     +0.1064E+02,0.9848E+01,0.9103E+01,0.8404E+01,0.7748E+01,0.7132E+01,
     +0.6555E+01,0.6015E+01,0.5509E+01,0.5037E+01,0.4595E+01,0.4184E+01,
     +0.3800E+01,0.3443E+01,0.3111E+01,0.2804E+01,0.2519E+01,0.2255E+01,
     +0.2012E+01,0.1787E+01,0.1582E+01,0.1393E+01,0.1220E+01,0.1063E+01,
     +0.9210E+00,0.7921E+00,0.6762E+00,0.5724E+00,0.4799E+00,0.3980E+00,
     +0.3261E+00,0.2633E+00,0.2091E+00,0.1628E+00,0.1238E+00,0.9145E-01,
     +0.6520E-01,0.4441E-01,0.2847E-01,0.1674E-01,0.8565E-02,0.3294E-02,
     +0.1249E-02,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,4),I=1,104) /
     +0.4037E+02,0.3845E+02,0.3662E+02,0.3488E+02,0.3320E+02,0.3161E+02,
     +0.3008E+02,0.2862E+02,0.2723E+02,0.2589E+02,0.2462E+02,0.2341E+02,
     +0.2225E+02,0.2114E+02,0.2009E+02,0.1908E+02,0.1812E+02,0.1720E+02,
     +0.1633E+02,0.1549E+02,0.1470E+02,0.1394E+02,0.1322E+02,0.1253E+02,
     +0.1187E+02,0.1125E+02,0.1066E+02,0.1009E+02,0.9549E+01,0.9036E+01,
     +0.8547E+01,0.8083E+01,0.7641E+01,0.7220E+01,0.6820E+01,0.6440E+01,
     +0.6079E+01,0.5735E+01,0.5409E+01,0.5099E+01,0.4804E+01,0.4524E+01,
     +0.4259E+01,0.4006E+01,0.3767E+01,0.3539E+01,0.3323E+01,0.3118E+01,
     +0.2923E+01,0.2738E+01,0.2563E+01,0.2396E+01,0.2238E+01,0.2087E+01,
     +0.1944E+01,0.1809E+01,0.1680E+01,0.1557E+01,0.1441E+01,0.1331E+01,
     +0.1226E+01,0.1127E+01,0.1032E+01,0.9430E+00,0.8585E+00,0.7787E+00,
     +0.7035E+00,0.6328E+00,0.5665E+00,0.5045E+00,0.4469E+00,0.3934E+00,
     +0.3441E+00,0.2989E+00,0.2577E+00,0.2203E+00,0.1867E+00,0.1566E+00,
     +0.1298E+00,0.1062E+00,0.8548E-01,0.6755E-01,0.5219E-01,0.3923E-01,
     +0.2852E-01,0.1993E-01,0.1329E-01,0.8387E-02,0.4973E-02,0.2752E-02,
     +0.1859E-02,0.1250E-02,0.8362E-03,0.5544E-03,0.3627E-03,0.2324E-03,
     +0.1445E-03,0.8603E-04,0.4818E-04,0.2474E-04,0.1119E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,5),I=1,104) /
     +0.7537E+01,0.7190E+01,0.6858E+01,0.6541E+01,0.6237E+01,0.5947E+01,
     +0.5670E+01,0.5405E+01,0.5152E+01,0.4910E+01,0.4678E+01,0.4457E+01,
     +0.4246E+01,0.4045E+01,0.3852E+01,0.3669E+01,0.3493E+01,0.3326E+01,
     +0.3166E+01,0.3013E+01,0.2868E+01,0.2729E+01,0.2597E+01,0.2471E+01,
     +0.2350E+01,0.2235E+01,0.2126E+01,0.2022E+01,0.1922E+01,0.1828E+01,
     +0.1737E+01,0.1651E+01,0.1569E+01,0.1491E+01,0.1417E+01,0.1346E+01,
     +0.1278E+01,0.1214E+01,0.1152E+01,0.1094E+01,0.1038E+01,0.9851E+00,
     +0.9344E+00,0.8860E+00,0.8398E+00,0.7957E+00,0.7536E+00,0.7133E+00,
     +0.6747E+00,0.6379E+00,0.6025E+00,0.5686E+00,0.5361E+00,0.5049E+00,
     +0.4749E+00,0.4461E+00,0.4183E+00,0.3916E+00,0.3658E+00,0.3410E+00,
     +0.3171E+00,0.2940E+00,0.2718E+00,0.2504E+00,0.2299E+00,0.2102E+00,
     +0.1914E+00,0.1734E+00,0.1563E+00,0.1401E+00,0.1249E+00,0.1106E+00,
     +0.9724E-01,0.8491E-01,0.7356E-01,0.6318E-01,0.5376E-01,0.4527E-01,
     +0.3766E-01,0.3090E-01,0.2493E-01,0.1970E-01,0.1520E-01,0.1137E-01,
     +0.8193E-02,0.5642E-02,0.3679E-02,0.2250E-02,0.1278E-02,0.6700E-03,
     +0.4366E-03,0.2837E-03,0.1841E-03,0.1191E-03,0.7657E-04,0.4853E-04,
     +0.3000E-04,0.1784E-04,0.1000E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,6),I=1,104) /
     +0.7363E+01,0.7016E+01,0.6684E+01,0.6367E+01,0.6064E+01,0.5774E+01,
     +0.5497E+01,0.5232E+01,0.4978E+01,0.4736E+01,0.4505E+01,0.4285E+01,
     +0.4074E+01,0.3872E+01,0.3680E+01,0.3497E+01,0.3321E+01,0.3154E+01,
     +0.2995E+01,0.2843E+01,0.2697E+01,0.2559E+01,0.2427E+01,0.2301E+01,
     +0.2181E+01,0.2067E+01,0.1958E+01,0.1854E+01,0.1755E+01,0.1661E+01,
     +0.1572E+01,0.1486E+01,0.1405E+01,0.1328E+01,0.1255E+01,0.1185E+01,
     +0.1118E+01,0.1055E+01,0.9949E+00,0.9378E+00,0.8836E+00,0.8320E+00,
     +0.7830E+00,0.7365E+00,0.6923E+00,0.6503E+00,0.6104E+00,0.5726E+00,
     +0.5366E+00,0.5025E+00,0.4701E+00,0.4393E+00,0.4101E+00,0.3823E+00,
     +0.3560E+00,0.3310E+00,0.3072E+00,0.2847E+00,0.2633E+00,0.2430E+00,
     +0.2238E+00,0.2055E+00,0.1882E+00,0.1719E+00,0.1564E+00,0.1418E+00,
     +0.1281E+00,0.1152E+00,0.1031E+00,0.9181E-01,0.8131E-01,0.7159E-01,
     +0.6263E-01,0.5442E-01,0.4693E-01,0.4014E-01,0.3403E-01,0.2856E-01,
     +0.2369E-01,0.1940E-01,0.1564E-01,0.1238E-01,0.9588E-02,0.7229E-02,
     +0.5279E-02,0.3710E-02,0.2492E-02,0.1588E-02,0.9538E-03,0.5358E-03,
     +0.3655E-03,0.2481E-03,0.1674E-03,0.1118E-03,0.7365E-04,0.4747E-04,
     +0.2967E-04,0.1775E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,7),I=1,104) /
     +0.7247E+01,0.6900E+01,0.6568E+01,0.6251E+01,0.5948E+01,0.5658E+01,
     +0.5381E+01,0.5116E+01,0.4863E+01,0.4621E+01,0.4390E+01,0.4169E+01,
     +0.3959E+01,0.3757E+01,0.3565E+01,0.3382E+01,0.3207E+01,0.3040E+01,
     +0.2880E+01,0.2728E+01,0.2584E+01,0.2445E+01,0.2314E+01,0.2188E+01,
     +0.2068E+01,0.1954E+01,0.1846E+01,0.1742E+01,0.1644E+01,0.1550E+01,
     +0.1461E+01,0.1376E+01,0.1296E+01,0.1219E+01,0.1146E+01,0.1077E+01,
     +0.1011E+01,0.9490E+00,0.8898E+00,0.8336E+00,0.7804E+00,0.7299E+00,
     +0.6820E+00,0.6367E+00,0.5939E+00,0.5533E+00,0.5150E+00,0.4787E+00,
     +0.4445E+00,0.4122E+00,0.3818E+00,0.3531E+00,0.3260E+00,0.3006E+00,
     +0.2767E+00,0.2542E+00,0.2332E+00,0.2134E+00,0.1950E+00,0.1777E+00,
     +0.1616E+00,0.1465E+00,0.1325E+00,0.1195E+00,0.1074E+00,0.9626E-01,
     +0.8593E-01,0.7641E-01,0.6766E-01,0.5964E-01,0.5231E-01,0.4564E-01,
     +0.3958E-01,0.3411E-01,0.2920E-01,0.2480E-01,0.2088E-01,0.1742E-01,
     +0.1439E-01,0.1174E-01,0.9458E-02,0.7504E-02,0.5851E-02,0.4471E-02,
     +0.3337E-02,0.2422E-02,0.1701E-02,0.1148E-02,0.7376E-03,0.4463E-03,
     +0.3181E-03,0.2244E-03,0.1562E-03,0.1070E-03,0.7170E-04,0.4677E-04,
     +0.2944E-04,0.1769E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,8),I=1,104) /
     +0.6872E+01,0.6540E+01,0.6223E+01,0.5919E+01,0.5630E+01,0.5352E+01,
     +0.5088E+01,0.4835E+01,0.4593E+01,0.4363E+01,0.4142E+01,0.3932E+01,
     +0.3731E+01,0.3539E+01,0.3357E+01,0.3182E+01,0.3016E+01,0.2857E+01,
     +0.2705E+01,0.2561E+01,0.2423E+01,0.2292E+01,0.2167E+01,0.2048E+01,
     +0.1935E+01,0.1827E+01,0.1724E+01,0.1627E+01,0.1534E+01,0.1445E+01,
     +0.1361E+01,0.1281E+01,0.1205E+01,0.1133E+01,0.1065E+01,0.9995E+00,
     +0.9378E+00,0.8792E+00,0.8236E+00,0.7710E+00,0.7210E+00,0.6738E+00,
     +0.6290E+00,0.5867E+00,0.5467E+00,0.5088E+00,0.4731E+00,0.4393E+00,
     +0.4075E+00,0.3774E+00,0.3491E+00,0.3225E+00,0.2974E+00,0.2739E+00,
     +0.2518E+00,0.2310E+00,0.2116E+00,0.1934E+00,0.1764E+00,0.1605E+00,
     +0.1457E+00,0.1319E+00,0.1190E+00,0.1071E+00,0.9611E-01,0.8592E-01,
     +0.7653E-01,0.6788E-01,0.5995E-01,0.5270E-01,0.4609E-01,0.4008E-01,
     +0.3465E-01,0.2976E-01,0.2537E-01,0.2146E-01,0.1800E-01,0.1495E-01,
     +0.1228E-01,0.9967E-02,0.7981E-02,0.6292E-02,0.4873E-02,0.3697E-02,
     +0.2738E-02,0.1970E-02,0.1371E-02,0.9164E-03,0.5830E-03,0.3487E-03,
     +0.2467E-03,0.1727E-03,0.1193E-03,0.8098E-04,0.5378E-04,0.3473E-04,
     +0.2162E-04,0.1282E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,9),I=1,104) /
     +0.3814E+01,0.3619E+01,0.3434E+01,0.3257E+01,0.3088E+01,0.2927E+01,
     +0.2774E+01,0.2628E+01,0.2488E+01,0.2356E+01,0.2230E+01,0.2109E+01,
     +0.1995E+01,0.1886E+01,0.1782E+01,0.1684E+01,0.1590E+01,0.1501E+01,
     +0.1416E+01,0.1336E+01,0.1259E+01,0.1186E+01,0.1117E+01,0.1052E+01,
     +0.9897E+00,0.9307E+00,0.8748E+00,0.8218E+00,0.7715E+00,0.7239E+00,
     +0.6788E+00,0.6361E+00,0.5957E+00,0.5575E+00,0.5213E+00,0.4871E+00,
     +0.4549E+00,0.4244E+00,0.3956E+00,0.3684E+00,0.3428E+00,0.3187E+00,
     +0.2959E+00,0.2745E+00,0.2544E+00,0.2354E+00,0.2176E+00,0.2009E+00,
     +0.1852E+00,0.1706E+00,0.1568E+00,0.1439E+00,0.1319E+00,0.1206E+00,
     +0.1101E+00,0.1003E+00,0.9122E-01,0.8276E-01,0.7490E-01,0.6761E-01,
     +0.6087E-01,0.5465E-01,0.4890E-01,0.4362E-01,0.3877E-01,0.3433E-01,
     +0.3027E-01,0.2657E-01,0.2321E-01,0.2017E-01,0.1743E-01,0.1497E-01,
     +0.1277E-01,0.1081E-01,0.9084E-02,0.7564E-02,0.6237E-02,0.5087E-02,
     +0.4099E-02,0.3259E-02,0.2552E-02,0.1964E-02,0.1481E-02,0.1092E-02,
     +0.7843E-03,0.5460E-03,0.3664E-03,0.2353E-03,0.1432E-03,0.8149E-04,
     +0.5573E-04,0.3766E-04,0.2505E-04,0.1634E-04,0.1039E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,1),I=1,104) /
     +0.2284E-01,0.2408E-01,0.2540E-01,0.2678E-01,0.2823E-01,0.2976E-01,
     +0.3137E-01,0.3307E-01,0.3485E-01,0.3673E-01,0.3871E-01,0.4079E-01,
     +0.4297E-01,0.4527E-01,0.4769E-01,0.5022E-01,0.5289E-01,0.5570E-01,
     +0.5864E-01,0.6173E-01,0.6498E-01,0.6839E-01,0.7197E-01,0.7572E-01,
     +0.7965E-01,0.8377E-01,0.8810E-01,0.9262E-01,0.9736E-01,0.1023E+00,
     +0.1075E+00,0.1129E+00,0.1186E+00,0.1245E+00,0.1307E+00,0.1372E+00,
     +0.1439E+00,0.1509E+00,0.1582E+00,0.1658E+00,0.1737E+00,0.1820E+00,
     +0.1905E+00,0.1993E+00,0.2084E+00,0.2178E+00,0.2276E+00,0.2376E+00,
     +0.2479E+00,0.2585E+00,0.2694E+00,0.2805E+00,0.2918E+00,0.3033E+00,
     +0.3150E+00,0.3267E+00,0.3386E+00,0.3504E+00,0.3622E+00,0.3738E+00,
     +0.3853E+00,0.3964E+00,0.4071E+00,0.4172E+00,0.4267E+00,0.4354E+00,
     +0.4430E+00,0.4495E+00,0.4547E+00,0.4582E+00,0.4600E+00,0.4598E+00,
     +0.4574E+00,0.4525E+00,0.4450E+00,0.4346E+00,0.4212E+00,0.4047E+00,
     +0.3851E+00,0.3623E+00,0.3365E+00,0.3081E+00,0.2772E+00,0.2447E+00,
     +0.2110E+00,0.1771E+00,0.1440E+00,0.1125E+00,0.8385E-01,0.5879E-01,
     +0.4576E-01,0.3502E-01,0.2629E-01,0.1929E-01,0.1377E-01,0.9507E-02,
     +0.6291E-02,0.3941E-02,0.2294E-02,0.1206E-02,0.5435E-03,0.1898E-03,
     +0.3901E-04,0.0000E+00/
      DATA (XQDUM (I,8,2),I=1,104) /
     +0.1295E-01,0.1366E-01,0.1440E-01,0.1518E-01,0.1600E-01,0.1686E-01,
     +0.1777E-01,0.1873E-01,0.1973E-01,0.2079E-01,0.2190E-01,0.2307E-01,
     +0.2430E-01,0.2559E-01,0.2695E-01,0.2837E-01,0.2987E-01,0.3144E-01,
     +0.3309E-01,0.3482E-01,0.3664E-01,0.3855E-01,0.4054E-01,0.4263E-01,
     +0.4483E-01,0.4712E-01,0.4953E-01,0.5204E-01,0.5467E-01,0.5742E-01,
     +0.6029E-01,0.6329E-01,0.6642E-01,0.6968E-01,0.7308E-01,0.7662E-01,
     +0.8030E-01,0.8413E-01,0.8811E-01,0.9223E-01,0.9651E-01,0.1009E+00,
     +0.1055E+00,0.1102E+00,0.1151E+00,0.1201E+00,0.1253E+00,0.1305E+00,
     +0.1359E+00,0.1415E+00,0.1471E+00,0.1527E+00,0.1585E+00,0.1643E+00,
     +0.1701E+00,0.1759E+00,0.1816E+00,0.1872E+00,0.1927E+00,0.1981E+00,
     +0.2032E+00,0.2080E+00,0.2124E+00,0.2164E+00,0.2199E+00,0.2228E+00,
     +0.2250E+00,0.2264E+00,0.2269E+00,0.2264E+00,0.2248E+00,0.2220E+00,
     +0.2180E+00,0.2126E+00,0.2058E+00,0.1975E+00,0.1877E+00,0.1765E+00,
     +0.1640E+00,0.1502E+00,0.1355E+00,0.1199E+00,0.1039E+00,0.8785E-01,
     +0.7214E-01,0.5724E-01,0.4358E-01,0.3157E-01,0.2149E-01,0.1352E-01,
     +0.9751E-02,0.6880E-02,0.4733E-02,0.3160E-02,0.2036E-02,0.1256E-02,
     +0.7331E-03,0.3986E-03,0.1970E-03,0.8519E-04,0.3007E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,3),I=1,104) /
     +0.2253E+03,0.2135E+03,0.2024E+03,0.1918E+03,0.1817E+03,0.1720E+03,
     +0.1629E+03,0.1541E+03,0.1458E+03,0.1379E+03,0.1304E+03,0.1232E+03,
     +0.1164E+03,0.1100E+03,0.1038E+03,0.9800E+02,0.9246E+02,0.8720E+02,
     +0.8220E+02,0.7746E+02,0.7296E+02,0.6869E+02,0.6464E+02,0.6081E+02,
     +0.5717E+02,0.5372E+02,0.5046E+02,0.4737E+02,0.4445E+02,0.4168E+02,
     +0.3907E+02,0.3659E+02,0.3425E+02,0.3205E+02,0.2996E+02,0.2799E+02,
     +0.2613E+02,0.2438E+02,0.2273E+02,0.2117E+02,0.1970E+02,0.1832E+02,
     +0.1702E+02,0.1580E+02,0.1465E+02,0.1357E+02,0.1256E+02,0.1161E+02,
     +0.1072E+02,0.9885E+01,0.9104E+01,0.8372E+01,0.7688E+01,0.7049E+01,
     +0.6452E+01,0.5896E+01,0.5378E+01,0.4895E+01,0.4447E+01,0.4030E+01,
     +0.3644E+01,0.3287E+01,0.2956E+01,0.2651E+01,0.2370E+01,0.2111E+01,
     +0.1873E+01,0.1656E+01,0.1457E+01,0.1276E+01,0.1112E+01,0.9631E+00,
     +0.8290E+00,0.7086E+00,0.6009E+00,0.5052E+00,0.4206E+00,0.3462E+00,
     +0.2814E+00,0.2253E+00,0.1773E+00,0.1366E+00,0.1028E+00,0.7497E-01,
     +0.5268E-01,0.3527E-01,0.2211E-01,0.1260E-01,0.6116E-02,0.2049E-02,
     +0.5238E-03,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,4),I=1,104) /
     +0.4865E+02,0.4627E+02,0.4400E+02,0.4183E+02,0.3976E+02,0.3779E+02,
     +0.3590E+02,0.3411E+02,0.3239E+02,0.3075E+02,0.2919E+02,0.2771E+02,
     +0.2629E+02,0.2494E+02,0.2365E+02,0.2242E+02,0.2125E+02,0.2014E+02,
     +0.1908E+02,0.1807E+02,0.1711E+02,0.1619E+02,0.1532E+02,0.1449E+02,
     +0.1371E+02,0.1296E+02,0.1225E+02,0.1157E+02,0.1093E+02,0.1032E+02,
     +0.9737E+01,0.9186E+01,0.8663E+01,0.8166E+01,0.7695E+01,0.7248E+01,
     +0.6824E+01,0.6421E+01,0.6040E+01,0.5678E+01,0.5336E+01,0.5011E+01,
     +0.4703E+01,0.4412E+01,0.4136E+01,0.3874E+01,0.3626E+01,0.3392E+01,
     +0.3170E+01,0.2960E+01,0.2761E+01,0.2572E+01,0.2394E+01,0.2225E+01,
     +0.2066E+01,0.1915E+01,0.1772E+01,0.1636E+01,0.1509E+01,0.1388E+01,
     +0.1273E+01,0.1165E+01,0.1064E+01,0.9676E+00,0.8772E+00,0.7924E+00,
     +0.7128E+00,0.6384E+00,0.5690E+00,0.5046E+00,0.4449E+00,0.3899E+00,
     +0.3394E+00,0.2934E+00,0.2517E+00,0.2141E+00,0.1804E+00,0.1505E+00,
     +0.1240E+00,0.1008E+00,0.8057E-01,0.6320E-01,0.4844E-01,0.3611E-01,
     +0.2603E-01,0.1803E-01,0.1192E-01,0.7455E-02,0.4384E-02,0.2406E-02,
     +0.1617E-02,0.1081E-02,0.7188E-03,0.4732E-03,0.3069E-03,0.1948E-03,
     +0.1197E-03,0.7031E-04,0.3877E-04,0.1955E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,5),I=1,104) /
     +0.8897E+01,0.8473E+01,0.8069E+01,0.7682E+01,0.7314E+01,0.6961E+01,
     +0.6625E+01,0.6304E+01,0.5998E+01,0.5706E+01,0.5427E+01,0.5161E+01,
     +0.4907E+01,0.4665E+01,0.4434E+01,0.4214E+01,0.4005E+01,0.3805E+01,
     +0.3614E+01,0.3433E+01,0.3260E+01,0.3096E+01,0.2939E+01,0.2790E+01,
     +0.2648E+01,0.2513E+01,0.2384E+01,0.2262E+01,0.2145E+01,0.2034E+01,
     +0.1929E+01,0.1829E+01,0.1733E+01,0.1643E+01,0.1557E+01,0.1475E+01,
     +0.1397E+01,0.1323E+01,0.1252E+01,0.1185E+01,0.1121E+01,0.1061E+01,
     +0.1003E+01,0.9483E+00,0.8961E+00,0.8463E+00,0.7990E+00,0.7538E+00,
     +0.7107E+00,0.6696E+00,0.6304E+00,0.5929E+00,0.5571E+00,0.5229E+00,
     +0.4901E+00,0.4587E+00,0.4286E+00,0.3997E+00,0.3720E+00,0.3455E+00,
     +0.3201E+00,0.2957E+00,0.2723E+00,0.2499E+00,0.2285E+00,0.2082E+00,
     +0.1888E+00,0.1703E+00,0.1529E+00,0.1366E+00,0.1212E+00,0.1069E+00,
     +0.9362E-01,0.8139E-01,0.7020E-01,0.6002E-01,0.5082E-01,0.4257E-01,
     +0.3522E-01,0.2872E-01,0.2302E-01,0.1807E-01,0.1382E-01,0.1026E-01,
     +0.7327E-02,0.4999E-02,0.3230E-02,0.1957E-02,0.1103E-02,0.5740E-03,
     +0.3726E-03,0.2413E-03,0.1560E-03,0.1005E-03,0.6419E-04,0.4035E-04,
     +0.2470E-04,0.1450E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,6),I=1,104) /
     +0.8723E+01,0.8300E+01,0.7895E+01,0.7509E+01,0.7140E+01,0.6788E+01,
     +0.6452E+01,0.6131E+01,0.5825E+01,0.5533E+01,0.5254E+01,0.4988E+01,
     +0.4735E+01,0.4493E+01,0.4262E+01,0.4043E+01,0.3833E+01,0.3634E+01,
     +0.3444E+01,0.3263E+01,0.3090E+01,0.2926E+01,0.2770E+01,0.2621E+01,
     +0.2480E+01,0.2345E+01,0.2217E+01,0.2095E+01,0.1979E+01,0.1869E+01,
     +0.1765E+01,0.1665E+01,0.1571E+01,0.1481E+01,0.1396E+01,0.1315E+01,
     +0.1238E+01,0.1165E+01,0.1096E+01,0.1031E+01,0.9688E+00,0.9099E+00,
     +0.8541E+00,0.8012E+00,0.7510E+00,0.7035E+00,0.6585E+00,0.6159E+00,
     +0.5755E+00,0.5373E+00,0.5011E+00,0.4668E+00,0.4344E+00,0.4037E+00,
     +0.3746E+00,0.3472E+00,0.3212E+00,0.2966E+00,0.2733E+00,0.2513E+00,
     +0.2306E+00,0.2110E+00,0.1925E+00,0.1751E+00,0.1587E+00,0.1434E+00,
     +0.1290E+00,0.1155E+00,0.1029E+00,0.9129E-01,0.8051E-01,0.7057E-01,
     +0.6146E-01,0.5316E-01,0.4562E-01,0.3883E-01,0.3274E-01,0.2733E-01,
     +0.2254E-01,0.1834E-01,0.1469E-01,0.1154E-01,0.8871E-02,0.6635E-02,
     +0.4804E-02,0.3347E-02,0.2229E-02,0.1408E-02,0.8382E-03,0.4669E-03,
     +0.3167E-03,0.2137E-03,0.1433E-03,0.9502E-04,0.6205E-04,0.3960E-04,
     +0.2447E-04,0.1444E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,7),I=1,104) /
     +0.8607E+01,0.8184E+01,0.7779E+01,0.7393E+01,0.7025E+01,0.6673E+01,
     +0.6336E+01,0.6016E+01,0.5710E+01,0.5418E+01,0.5139E+01,0.4873E+01,
     +0.4620E+01,0.4378E+01,0.4148E+01,0.3928E+01,0.3719E+01,0.3520E+01,
     +0.3330E+01,0.3149E+01,0.2977E+01,0.2813E+01,0.2657E+01,0.2508E+01,
     +0.2367E+01,0.2233E+01,0.2105E+01,0.1984E+01,0.1868E+01,0.1759E+01,
     +0.1655E+01,0.1556E+01,0.1462E+01,0.1373E+01,0.1289E+01,0.1208E+01,
     +0.1133E+01,0.1061E+01,0.9925E+00,0.9280E+00,0.8669E+00,0.8092E+00,
     +0.7546E+00,0.7030E+00,0.6542E+00,0.6082E+00,0.5648E+00,0.5239E+00,
     +0.4853E+00,0.4490E+00,0.4149E+00,0.3828E+00,0.3526E+00,0.3243E+00,
     +0.2977E+00,0.2728E+00,0.2496E+00,0.2278E+00,0.2075E+00,0.1886E+00,
     +0.1709E+00,0.1546E+00,0.1393E+00,0.1252E+00,0.1122E+00,0.1002E+00,
     +0.8912E-01,0.7895E-01,0.6964E-01,0.6114E-01,0.5340E-01,0.4639E-01,
     +0.4005E-01,0.3435E-01,0.2925E-01,0.2472E-01,0.2070E-01,0.1717E-01,
     +0.1409E-01,0.1143E-01,0.9142E-02,0.7200E-02,0.5571E-02,0.4222E-02,
     +0.3123E-02,0.2246E-02,0.1561E-02,0.1042E-02,0.6620E-03,0.3954E-03,
     +0.2794E-03,0.1954E-03,0.1348E-03,0.9138E-04,0.6062E-04,0.3910E-04,
     +0.2431E-04,0.1440E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,8),I=1,104) /
     +0.8243E+01,0.7834E+01,0.7444E+01,0.7071E+01,0.6715E+01,0.6376E+01,
     +0.6052E+01,0.5743E+01,0.5448E+01,0.5167E+01,0.4899E+01,0.4643E+01,
     +0.4399E+01,0.4167E+01,0.3945E+01,0.3735E+01,0.3534E+01,0.3342E+01,
     +0.3160E+01,0.2987E+01,0.2822E+01,0.2665E+01,0.2515E+01,0.2373E+01,
     +0.2238E+01,0.2110E+01,0.1988E+01,0.1872E+01,0.1762E+01,0.1657E+01,
     +0.1558E+01,0.1464E+01,0.1375E+01,0.1290E+01,0.1210E+01,0.1134E+01,
     +0.1062E+01,0.9933E+00,0.9287E+00,0.8676E+00,0.8098E+00,0.7552E+00,
     +0.7036E+00,0.6549E+00,0.6089E+00,0.5655E+00,0.5246E+00,0.4861E+00,
     +0.4498E+00,0.4157E+00,0.3836E+00,0.3535E+00,0.3253E+00,0.2988E+00,
     +0.2739E+00,0.2507E+00,0.2290E+00,0.2087E+00,0.1898E+00,0.1722E+00,
     +0.1558E+00,0.1407E+00,0.1266E+00,0.1135E+00,0.1015E+00,0.9044E-01,
     +0.8027E-01,0.7094E-01,0.6241E-01,0.5464E-01,0.4759E-01,0.4121E-01,
     +0.3546E-01,0.3031E-01,0.2571E-01,0.2164E-01,0.1804E-01,0.1490E-01,
     +0.1216E-01,0.9810E-02,0.7801E-02,0.6105E-02,0.4691E-02,0.3529E-02,
     +0.2590E-02,0.1846E-02,0.1272E-02,0.8406E-03,0.5283E-03,0.3118E-03,
     +0.2186E-03,0.1517E-03,0.1037E-03,0.6971E-04,0.4580E-04,0.2923E-04,
     +0.1796E-04,0.1050E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,9),I=1,104) /
     +0.5281E+01,0.5006E+01,0.4743E+01,0.4493E+01,0.4255E+01,0.4028E+01,
     +0.3813E+01,0.3607E+01,0.3412E+01,0.3226E+01,0.3049E+01,0.2881E+01,
     +0.2721E+01,0.2569E+01,0.2424E+01,0.2287E+01,0.2157E+01,0.2033E+01,
     +0.1915E+01,0.1804E+01,0.1698E+01,0.1598E+01,0.1502E+01,0.1412E+01,
     +0.1327E+01,0.1246E+01,0.1169E+01,0.1096E+01,0.1028E+01,0.9628E+00,
     +0.9013E+00,0.8432E+00,0.7884E+00,0.7365E+00,0.6876E+00,0.6414E+00,
     +0.5978E+00,0.5567E+00,0.5180E+00,0.4815E+00,0.4472E+00,0.4149E+00,
     +0.3846E+00,0.3560E+00,0.3293E+00,0.3041E+00,0.2805E+00,0.2585E+00,
     +0.2378E+00,0.2184E+00,0.2004E+00,0.1835E+00,0.1677E+00,0.1530E+00,
     +0.1394E+00,0.1267E+00,0.1149E+00,0.1039E+00,0.9382E-01,0.8446E-01,
     +0.7582E-01,0.6786E-01,0.6055E-01,0.5384E-01,0.4769E-01,0.4208E-01,
     +0.3698E-01,0.3234E-01,0.2815E-01,0.2437E-01,0.2097E-01,0.1793E-01,
     +0.1523E-01,0.1284E-01,0.1073E-01,0.8888E-02,0.7288E-02,0.5910E-02,
     +0.4733E-02,0.3737E-02,0.2905E-02,0.2219E-02,0.1660E-02,0.1213E-02,
     +0.8627E-03,0.5943E-03,0.3943E-03,0.2500E-03,0.1500E-03,0.8403E-04,
     +0.5685E-04,0.3798E-04,0.2497E-04,0.1608E-04,0.1009E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,1),I=1,104) /
     +0.2424E-01,0.2555E-01,0.2693E-01,0.2839E-01,0.2992E-01,0.3153E-01,
     +0.3323E-01,0.3502E-01,0.3689E-01,0.3887E-01,0.4094E-01,0.4312E-01,
     +0.4541E-01,0.4782E-01,0.5035E-01,0.5301E-01,0.5580E-01,0.5874E-01,
     +0.6181E-01,0.6504E-01,0.6843E-01,0.7198E-01,0.7570E-01,0.7960E-01,
     +0.8369E-01,0.8797E-01,0.9246E-01,0.9715E-01,0.1021E+00,0.1072E+00,
     +0.1125E+00,0.1181E+00,0.1240E+00,0.1301E+00,0.1364E+00,0.1431E+00,
     +0.1500E+00,0.1571E+00,0.1646E+00,0.1724E+00,0.1804E+00,0.1887E+00,
     +0.1974E+00,0.2063E+00,0.2155E+00,0.2250E+00,0.2348E+00,0.2448E+00,
     +0.2552E+00,0.2657E+00,0.2765E+00,0.2875E+00,0.2987E+00,0.3100E+00,
     +0.3214E+00,0.3329E+00,0.3443E+00,0.3558E+00,0.3671E+00,0.3782E+00,
     +0.3890E+00,0.3994E+00,0.4093E+00,0.4185E+00,0.4270E+00,0.4346E+00,
     +0.4411E+00,0.4464E+00,0.4502E+00,0.4524E+00,0.4528E+00,0.4511E+00,
     +0.4472E+00,0.4408E+00,0.4318E+00,0.4200E+00,0.4053E+00,0.3877E+00,
     +0.3671E+00,0.3436E+00,0.3175E+00,0.2889E+00,0.2584E+00,0.2265E+00,
     +0.1940E+00,0.1616E+00,0.1302E+00,0.1008E+00,0.7432E-01,0.5148E-01,
     +0.3973E-01,0.3014E-01,0.2241E-01,0.1628E-01,0.1149E-01,0.7834E-02,
     +0.5110E-02,0.3148E-02,0.1796E-02,0.9200E-03,0.4002E-03,0.1318E-03,
     +0.2336E-04,0.0000E+00/
      DATA (XQDUM (I,9,2),I=1,104) /
     +0.1373E-01,0.1448E-01,0.1526E-01,0.1608E-01,0.1694E-01,0.1785E-01,
     +0.1880E-01,0.1981E-01,0.2086E-01,0.2197E-01,0.2314E-01,0.2437E-01,
     +0.2565E-01,0.2700E-01,0.2842E-01,0.2991E-01,0.3148E-01,0.3312E-01,
     +0.3483E-01,0.3664E-01,0.3853E-01,0.4051E-01,0.4258E-01,0.4475E-01,
     +0.4702E-01,0.4940E-01,0.5189E-01,0.5448E-01,0.5720E-01,0.6003E-01,
     +0.6299E-01,0.6607E-01,0.6928E-01,0.7262E-01,0.7610E-01,0.7972E-01,
     +0.8348E-01,0.8738E-01,0.9142E-01,0.9561E-01,0.9994E-01,0.1044E+00,
     +0.1090E+00,0.1138E+00,0.1187E+00,0.1237E+00,0.1288E+00,0.1341E+00,
     +0.1394E+00,0.1449E+00,0.1504E+00,0.1560E+00,0.1616E+00,0.1672E+00,
     +0.1728E+00,0.1784E+00,0.1839E+00,0.1892E+00,0.1944E+00,0.1994E+00,
     +0.2041E+00,0.2084E+00,0.2124E+00,0.2159E+00,0.2188E+00,0.2210E+00,
     +0.2226E+00,0.2233E+00,0.2231E+00,0.2219E+00,0.2197E+00,0.2162E+00,
     +0.2115E+00,0.2054E+00,0.1980E+00,0.1892E+00,0.1790E+00,0.1675E+00,
     +0.1548E+00,0.1411E+00,0.1264E+00,0.1112E+00,0.9574E-01,0.8036E-01,
     +0.6548E-01,0.5152E-01,0.3887E-01,0.2786E-01,0.1875E-01,0.1164E-01,
     +0.8321E-02,0.5815E-02,0.3960E-02,0.2615E-02,0.1664E-02,0.1013E-02,
     +0.5819E-03,0.3105E-03,0.1500E-03,0.6292E-04,0.2123E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,3),I=1,104) /
     +0.2532E+03,0.2396E+03,0.2266E+03,0.2143E+03,0.2027E+03,0.1915E+03,
     +0.1810E+03,0.1709E+03,0.1614E+03,0.1523E+03,0.1437E+03,0.1356E+03,
     +0.1278E+03,0.1205E+03,0.1135E+03,0.1069E+03,0.1007E+03,0.9472E+02,
     +0.8910E+02,0.8377E+02,0.7873E+02,0.7395E+02,0.6944E+02,0.6517E+02,
     +0.6112E+02,0.5731E+02,0.5370E+02,0.5029E+02,0.4707E+02,0.4403E+02,
     +0.4116E+02,0.3846E+02,0.3591E+02,0.3350E+02,0.3124E+02,0.2911E+02,
     +0.2710E+02,0.2522E+02,0.2344E+02,0.2177E+02,0.2021E+02,0.1874E+02,
     +0.1736E+02,0.1607E+02,0.1485E+02,0.1372E+02,0.1265E+02,0.1166E+02,
     +0.1073E+02,0.9864E+01,0.9054E+01,0.8298E+01,0.7594E+01,0.6939E+01,
     +0.6329E+01,0.5763E+01,0.5238E+01,0.4750E+01,0.4299E+01,0.3881E+01,
     +0.3496E+01,0.3140E+01,0.2813E+01,0.2512E+01,0.2236E+01,0.1983E+01,
     +0.1752E+01,0.1542E+01,0.1351E+01,0.1177E+01,0.1021E+01,0.8797E+00,
     +0.7533E+00,0.6404E+00,0.5401E+00,0.4514E+00,0.3735E+00,0.3054E+00,
     +0.2465E+00,0.1959E+00,0.1529E+00,0.1169E+00,0.8704E-01,0.6283E-01,
     +0.4359E-01,0.2874E-01,0.1767E-01,0.9789E-02,0.4516E-02,0.1294E-02,
     +0.1249E-03,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,4),I=1,104) /
     +0.5669E+02,0.5384E+02,0.5113E+02,0.4854E+02,0.4608E+02,0.4373E+02,
     +0.4149E+02,0.3935E+02,0.3732E+02,0.3538E+02,0.3353E+02,0.3178E+02,
     +0.3010E+02,0.2851E+02,0.2699E+02,0.2555E+02,0.2418E+02,0.2288E+02,
     +0.2163E+02,0.2046E+02,0.1933E+02,0.1827E+02,0.1726E+02,0.1629E+02,
     +0.1538E+02,0.1452E+02,0.1369E+02,0.1291E+02,0.1217E+02,0.1147E+02,
     +0.1080E+02,0.1017E+02,0.9571E+01,0.9004E+01,0.8467E+01,0.7958E+01,
     +0.7476E+01,0.7019E+01,0.6588E+01,0.6179E+01,0.5793E+01,0.5427E+01,
     +0.5082E+01,0.4755E+01,0.4446E+01,0.4154E+01,0.3879E+01,0.3618E+01,
     +0.3372E+01,0.3140E+01,0.2921E+01,0.2714E+01,0.2518E+01,0.2334E+01,
     +0.2160E+01,0.1996E+01,0.1841E+01,0.1695E+01,0.1558E+01,0.1428E+01,
     +0.1306E+01,0.1191E+01,0.1084E+01,0.9823E+00,0.8875E+00,0.7987E+00,
     +0.7159E+00,0.6388E+00,0.5672E+00,0.5011E+00,0.4401E+00,0.3841E+00,
     +0.3331E+00,0.2867E+00,0.2449E+00,0.2074E+00,0.1739E+00,0.1443E+00,
     +0.1183E+00,0.9558E-01,0.7597E-01,0.5921E-01,0.4507E-01,0.3335E-01,
     +0.2386E-01,0.1640E-01,0.1075E-01,0.6673E-02,0.3893E-02,0.2120E-02,
     +0.1418E-02,0.9432E-03,0.6232E-03,0.4076E-03,0.2623E-03,0.1650E-03,
     +0.1003E-03,0.5825E-04,0.3168E-04,0.1572E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,5),I=1,104) /
     +0.1022E+02,0.9719E+01,0.9241E+01,0.8786E+01,0.8351E+01,0.7937E+01,
     +0.7542E+01,0.7165E+01,0.6806E+01,0.6464E+01,0.6138E+01,0.5828E+01,
     +0.5532E+01,0.5250E+01,0.4982E+01,0.4727E+01,0.4484E+01,0.4252E+01,
     +0.4032E+01,0.3823E+01,0.3624E+01,0.3434E+01,0.3254E+01,0.3083E+01,
     +0.2920E+01,0.2765E+01,0.2618E+01,0.2479E+01,0.2346E+01,0.2220E+01,
     +0.2101E+01,0.1987E+01,0.1879E+01,0.1777E+01,0.1680E+01,0.1588E+01,
     +0.1500E+01,0.1417E+01,0.1339E+01,0.1264E+01,0.1193E+01,0.1126E+01,
     +0.1062E+01,0.1001E+01,0.9432E+00,0.8885E+00,0.8364E+00,0.7870E+00,
     +0.7399E+00,0.6951E+00,0.6525E+00,0.6120E+00,0.5733E+00,0.5364E+00,
     +0.5013E+00,0.4677E+00,0.4357E+00,0.4051E+00,0.3758E+00,0.3479E+00,
     +0.3212E+00,0.2958E+00,0.2715E+00,0.2484E+00,0.2264E+00,0.2055E+00,
     +0.1857E+00,0.1670E+00,0.1494E+00,0.1330E+00,0.1176E+00,0.1033E+00,
     +0.9016E-01,0.7809E-01,0.6708E-01,0.5712E-01,0.4816E-01,0.4015E-01,
     +0.3306E-01,0.2681E-01,0.2136E-01,0.1666E-01,0.1266E-01,0.9324E-02,
     +0.6609E-02,0.4473E-02,0.2866E-02,0.1723E-02,0.9632E-03,0.4981E-03,
     +0.3222E-03,0.2079E-03,0.1339E-03,0.8583E-04,0.5450E-04,0.3401E-04,
     +0.2063E-04,0.1198E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,6),I=1,104) /
     +0.1005E+02,0.9546E+01,0.9068E+01,0.8613E+01,0.8178E+01,0.7764E+01,
     +0.7369E+01,0.6993E+01,0.6634E+01,0.6292E+01,0.5966E+01,0.5656E+01,
     +0.5360E+01,0.5079E+01,0.4811E+01,0.4555E+01,0.4313E+01,0.4082E+01,
     +0.3862E+01,0.3653E+01,0.3454E+01,0.3265E+01,0.3085E+01,0.2915E+01,
     +0.2752E+01,0.2598E+01,0.2452E+01,0.2313E+01,0.2181E+01,0.2056E+01,
     +0.1937E+01,0.1825E+01,0.1718E+01,0.1617E+01,0.1521E+01,0.1430E+01,
     +0.1343E+01,0.1262E+01,0.1185E+01,0.1111E+01,0.1042E+01,0.9765E+00,
     +0.9145E+00,0.8559E+00,0.8004E+00,0.7480E+00,0.6984E+00,0.6516E+00,
     +0.6073E+00,0.5655E+00,0.5261E+00,0.4888E+00,0.4536E+00,0.4204E+00,
     +0.3890E+00,0.3594E+00,0.3315E+00,0.3052E+00,0.2804E+00,0.2571E+00,
     +0.2351E+00,0.2145E+00,0.1950E+00,0.1768E+00,0.1598E+00,0.1438E+00,
     +0.1289E+00,0.1150E+00,0.1022E+00,0.9027E-01,0.7931E-01,0.6926E-01,
     +0.6008E-01,0.5175E-01,0.4423E-01,0.3748E-01,0.3146E-01,0.2613E-01,
     +0.2144E-01,0.1735E-01,0.1381E-01,0.1079E-01,0.8234E-02,0.6114E-02,
     +0.4394E-02,0.3038E-02,0.2007E-02,0.1258E-02,0.7430E-03,0.4105E-03,
     +0.2770E-03,0.1860E-03,0.1239E-03,0.8162E-04,0.5288E-04,0.3345E-04,
     +0.2046E-04,0.1194E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,7),I=1,104) /
     +0.9930E+01,0.9430E+01,0.8952E+01,0.8497E+01,0.8063E+01,0.7649E+01,
     +0.7254E+01,0.6877E+01,0.6519E+01,0.6177E+01,0.5851E+01,0.5541E+01,
     +0.5245E+01,0.4964E+01,0.4696E+01,0.4441E+01,0.4199E+01,0.3968E+01,
     +0.3748E+01,0.3539E+01,0.3341E+01,0.3152E+01,0.2973E+01,0.2803E+01,
     +0.2641E+01,0.2487E+01,0.2341E+01,0.2203E+01,0.2071E+01,0.1946E+01,
     +0.1828E+01,0.1716E+01,0.1610E+01,0.1509E+01,0.1414E+01,0.1324E+01,
     +0.1239E+01,0.1158E+01,0.1082E+01,0.1010E+01,0.9414E+00,0.8771E+00,
     +0.8164E+00,0.7591E+00,0.7051E+00,0.6543E+00,0.6064E+00,0.5613E+00,
     +0.5189E+00,0.4791E+00,0.4417E+00,0.4067E+00,0.3738E+00,0.3430E+00,
     +0.3142E+00,0.2873E+00,0.2622E+00,0.2387E+00,0.2169E+00,0.1966E+00,
     +0.1777E+00,0.1603E+00,0.1441E+00,0.1292E+00,0.1154E+00,0.1027E+00,
     +0.9106E-01,0.8041E-01,0.7069E-01,0.6184E-01,0.5382E-01,0.4657E-01,
     +0.4005E-01,0.3421E-01,0.2901E-01,0.2440E-01,0.2034E-01,0.1678E-01,
     +0.1370E-01,0.1105E-01,0.8785E-02,0.6875E-02,0.5283E-02,0.3975E-02,
     +0.2918E-02,0.2081E-02,0.1434E-02,0.9483E-03,0.5962E-03,0.3521E-03,
     +0.2469E-03,0.1713E-03,0.1172E-03,0.7881E-04,0.5181E-04,0.3308E-04,
     +0.2035E-04,0.1191E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,8),I=1,104) /
     +0.9575E+01,0.9089E+01,0.8625E+01,0.8183E+01,0.7761E+01,0.7360E+01,
     +0.6977E+01,0.6612E+01,0.6264E+01,0.5932E+01,0.5617E+01,0.5317E+01,
     +0.5031E+01,0.4758E+01,0.4499E+01,0.4253E+01,0.4018E+01,0.3795E+01,
     +0.3583E+01,0.3382E+01,0.3190E+01,0.3008E+01,0.2835E+01,0.2671E+01,
     +0.2515E+01,0.2368E+01,0.2227E+01,0.2094E+01,0.1968E+01,0.1848E+01,
     +0.1735E+01,0.1627E+01,0.1525E+01,0.1429E+01,0.1338E+01,0.1252E+01,
     +0.1170E+01,0.1093E+01,0.1020E+01,0.9512E+00,0.8863E+00,0.8250E+00,
     +0.7672E+00,0.7127E+00,0.6614E+00,0.6131E+00,0.5676E+00,0.5249E+00,
     +0.4848E+00,0.4471E+00,0.4117E+00,0.3786E+00,0.3476E+00,0.3185E+00,
     +0.2914E+00,0.2661E+00,0.2424E+00,0.2204E+00,0.2000E+00,0.1810E+00,
     +0.1633E+00,0.1470E+00,0.1319E+00,0.1180E+00,0.1052E+00,0.9345E-01,
     +0.8267E-01,0.7283E-01,0.6386E-01,0.5571E-01,0.4834E-01,0.4170E-01,
     +0.3574E-01,0.3043E-01,0.2570E-01,0.2153E-01,0.1787E-01,0.1468E-01,
     +0.1192E-01,0.9559E-02,0.7555E-02,0.5875E-02,0.4483E-02,0.3348E-02,
     +0.2438E-02,0.1724E-02,0.1177E-02,0.7702E-03,0.4790E-03,0.2794E-03,
     +0.1944E-03,0.1337E-03,0.9070E-04,0.6041E-04,0.3931E-04,0.2483E-04,
     +0.1508E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,9),I=1,104) /
     +0.6697E+01,0.6341E+01,0.6002E+01,0.5679E+01,0.5372E+01,0.5080E+01,
     +0.4802E+01,0.4538E+01,0.4287E+01,0.4049E+01,0.3822E+01,0.3607E+01,
     +0.3402E+01,0.3208E+01,0.3024E+01,0.2849E+01,0.2683E+01,0.2526E+01,
     +0.2377E+01,0.2236E+01,0.2102E+01,0.1975E+01,0.1855E+01,0.1741E+01,
     +0.1633E+01,0.1531E+01,0.1435E+01,0.1344E+01,0.1258E+01,0.1177E+01,
     +0.1100E+01,0.1028E+01,0.9592E+00,0.8947E+00,0.8340E+00,0.7767E+00,
     +0.7228E+00,0.6720E+00,0.6243E+00,0.5793E+00,0.5371E+00,0.4975E+00,
     +0.4603E+00,0.4254E+00,0.3927E+00,0.3620E+00,0.3334E+00,0.3065E+00,
     +0.2815E+00,0.2581E+00,0.2362E+00,0.2159E+00,0.1969E+00,0.1793E+00,
     +0.1629E+00,0.1478E+00,0.1337E+00,0.1207E+00,0.1087E+00,0.9759E-01,
     +0.8738E-01,0.7801E-01,0.6941E-01,0.6155E-01,0.5437E-01,0.4783E-01,
     +0.4190E-01,0.3653E-01,0.3169E-01,0.2734E-01,0.2344E-01,0.1997E-01,
     +0.1689E-01,0.1418E-01,0.1180E-01,0.9732E-02,0.7942E-02,0.6407E-02,
     +0.5103E-02,0.4007E-02,0.3095E-02,0.2348E-02,0.1744E-02,0.1265E-02,
     +0.8919E-03,0.6089E-03,0.3999E-03,0.2508E-03,0.1487E-03,0.8208E-04,
     +0.5500E-04,0.3638E-04,0.2366E-04,0.1507E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA XMIN/5.E-05/,XMAX/.95/
      DATA ISTEP/0/
      IF(ISTEP.EQ.0) THEN
        DO 2 I=1,IX
          ENT(I)=LOG10(XCO(I))
    2   CONTINUE
        NENT(1)=IX
        NENT(2)=IQ
        DO 3 I=1,IQ
          ENT(IX+I)=LOG10(Q2(I))
    3   CONTINUE
        ISTEP=1
      ENDIF
      IF (STRFUN(1:2) .EQ. 'UP' ) THEN
      IFUN =1
      ELSE IF (STRFUN(1:2) .EQ. 'DO') THEN
      IFUN =2
      ELSE IF (STRFUN(1:2) .EQ. 'GL') THEN
      IFUN =3
      ELSE IF (STRFUN(1:2) .EQ. 'QB') THEN
      IFUN =4
      ELSE IF (STRFUN(1:2) .EQ. 'UB') THEN
      IFUN =5
      ELSE IF (STRFUN(1:2) .EQ. 'SB') THEN
      IFUN =6
      ELSE IF (STRFUN(1:2) .EQ. 'CB') THEN
      IFUN =7
      ELSE IF (STRFUN(1:2) .EQ. 'BB') THEN
      IFUN =8
      ELSE IF (STRFUN(1:2) .EQ. 'TB') THEN
      IFUN =9
      ENDIF
      FUNC=0.
C     IF(X.GT.XMIN.AND.X.LT.XMAX) THEN
      IF(X.LT.XMAX) THEN
      ARG(1)=LOG10(X)
      ARG(2)=LOG10(QSTAR2)
      FUNC =FINT(NARG,ARG,NENT,ENT,XQDUM(1,1,IFUN))
      ENDIF
      IF (FUNC.LT.0.) FUNC=0.
      END
