/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import sharpen.core.Configuration;
import sharpen.core.MemberKind;
import sharpen.core.SharpenCommandLine;
import sharpen.core.framework.CommandLineParser;
import sharpen.core.io.IO;

class SharpenCommandLineParser
extends CommandLineParser {
    private final SharpenCommandLine _cmdLine;

    public SharpenCommandLineParser(String[] args) {
        this(args, new SharpenCommandLine());
    }

    private SharpenCommandLineParser(String[] args, SharpenCommandLine cmdLine) {
        super(args);
        this._cmdLine = cmdLine;
        this.parse();
    }

    @Override
    protected void processResponseFile(String arg) {
        new SharpenCommandLineParser(IO.linesFromFile(arg.substring(1)), this._cmdLine);
    }

    @Override
    protected void validate() {
        if (this._cmdLine.project == null) {
            SharpenCommandLineParser.illegalArgument("unspecified source folder");
        }
    }

    @Override
    protected void processArgument(String arg) {
        if (this._cmdLine.project != null) {
            SharpenCommandLineParser.illegalArgument(arg);
        }
        if (arg.indexOf(47) > -1) {
            String projectName = arg.split("/")[0];
            String srcFolder = arg.substring(projectName.length() + 1);
            this._cmdLine.project = projectName;
            this._cmdLine.sourceFolders.add(srcFolder);
        } else {
            this._cmdLine.project = arg;
        }
    }

    @Override
    protected void processOption(String arg) {
        if (this.areEqual(arg, "-pascalCase")) {
            this._cmdLine.pascalCase = SharpenCommandLine.PascalCaseOptions.Identifiers;
        } else if (this.areEqual(arg, "-pascalCase+")) {
            this._cmdLine.pascalCase = SharpenCommandLine.PascalCaseOptions.NamespaceAndIdentifiers;
        } else if (this.areEqual(arg, "-cp")) {
            this._cmdLine.classpath.add(this.consumeNext());
        } else if (this.areEqual(arg, "-srcFolder")) {
            this._cmdLine.sourceFolders.add(this.consumeNext());
        } else if (this.areEqual(arg, "-nativeTypeSystem")) {
            this._cmdLine.nativeTypeSystem = true;
        } else if (this.areEqual(arg, "-nativeInterfaces")) {
            this._cmdLine.nativeInterfaces = true;
        } else if (this.areEqual(arg, "-organizeUsings")) {
            this._cmdLine.organizeUsings = true;
        } else if (this.areEqual(arg, "-fullyQualify")) {
            this._cmdLine.fullyQualifiedTypes.add(this.consumeNext());
        } else if (this.areEqual(arg, "-namespaceMapping")) {
            this._cmdLine.namespaceMappings.add(this.consumeNameMapping());
        } else if (this.areEqual(arg, "-methodMapping")) {
            String from = this.consumeNext();
            String to = this.consumeNext();
            this._cmdLine.memberMappings.put(from, new Configuration.MemberMapping(to, MemberKind.Method));
        } else if (this.areEqual(arg, "-typeMapping")) {
            this._cmdLine.typeMappings.add(this.consumeNameMapping());
        } else if (this.areEqual(arg, "-propertyMapping")) {
            String from = this.consumeNext();
            String to = this.consumeNext();
            this._cmdLine.memberMappings.put(from, new Configuration.MemberMapping(to, MemberKind.Property));
        } else if (this.areEqual(arg, "-fieldMapping")) {
            String from = this.consumeNext();
            String to = this.consumeNext();
            this._cmdLine.memberMappings.put(from, new Configuration.MemberMapping(to, MemberKind.Field));
        } else if (this.areEqual(arg, "-makePartial")) {
            this._cmdLine.partialTypes.add(this.consumeNext());
        } else if (this.areEqual(arg, "-runtimeTypeName")) {
            this._cmdLine.runtimeTypeName = this.consumeNext();
        } else if (this.areEqual(arg, "-header")) {
            this._cmdLine.headerFile = this.consumeNext();
        } else if (this.areEqual(arg, "-xmldoc")) {
            this._cmdLine.xmldoc = this.consumeNext();
        } else if (this.areEqual(arg, "-eventMapping")) {
            this._cmdLine.eventMappings.add(this.consumeNameMapping());
        } else if (this.areEqual(arg, "-eventAddMapping")) {
            this._cmdLine.eventAddMappings.add(this.consumeNext());
        } else if (this.areEqual(arg, "-conditionalCompilation")) {
            this._cmdLine.conditionalCompilation.put(this.consumeNext(), this.consumeNext());
        } else if (this.areEqual(arg, "-configurationClass")) {
            this._cmdLine.configurationClass = this.consumeNext();
        } else if (this.areEqual(arg, "-junitConversion")) {
            this._cmdLine.junitConversion = true;
        } else if (this.areEqual(arg, "-flatDirectoryStructure")) {
            this._cmdLine.flatNamespaceDirectoryStructure = true;
        } else {
            SharpenCommandLineParser.illegalArgument(arg);
        }
    }

    private Configuration.NameMapping consumeNameMapping() {
        String from = this.consumeNext();
        String to = this.consumeNext();
        Configuration.NameMapping nameMapping = new Configuration.NameMapping(from, to);
        return nameMapping;
    }

    public SharpenCommandLine commandLine() {
        return this._cmdLine;
    }
}

