/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

var incrspace = require( '@stdlib/array/incrspace' );
var logaddexp = require( './../lib' );

var x;
var v;
var i;
var j;

x = incrspace( -100.0, 100.0, 1.0 );
for ( i = 0; i < x.length; i++ ) {
	for ( j = i; j < x.length; j++ ) {
		v = logaddexp( x[ i ], x[ j ] );
		console.log( 'x: %d, y: %d, f(x, y): %d', x[ i ], x[ j ], v );
	}
}
