// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GeomPlate_BuildPlateSurface_HeaderFile
#define _GeomPlate_BuildPlateSurface_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Handle_GeomPlate_HSequenceOfCurveConstraint_HeaderFile
#include <Handle_GeomPlate_HSequenceOfCurveConstraint.hxx>
#endif
#ifndef _Handle_GeomPlate_HArray1OfSequenceOfReal_HeaderFile
#include <Handle_GeomPlate_HArray1OfSequenceOfReal.hxx>
#endif
#ifndef _Handle_GeomPlate_HSequenceOfPointConstraint_HeaderFile
#include <Handle_GeomPlate_HSequenceOfPointConstraint.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Handle_GeomPlate_Surface_HeaderFile
#include <Handle_GeomPlate_Surface.hxx>
#endif
#ifndef _Plate_Plate_HeaderFile
#include <Plate_Plate.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Extrema_ExtPS_HeaderFile
#include <Extrema_ExtPS.hxx>
#endif
#ifndef _Handle_GeomPlate_HArray1OfHCurveOnSurface_HeaderFile
#include <Handle_GeomPlate_HArray1OfHCurveOnSurface.hxx>
#endif
#ifndef _Handle_GeomPlate_CurveConstraint_HeaderFile
#include <Handle_GeomPlate_CurveConstraint.hxx>
#endif
#ifndef _Handle_GeomPlate_PointConstraint_HeaderFile
#include <Handle_GeomPlate_PointConstraint.hxx>
#endif
#ifndef _Handle_TColGeom2d_HArray1OfCurve_HeaderFile
#include <Handle_TColGeom2d_HArray1OfCurve.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Handle_Adaptor3d_HCurve_HeaderFile
#include <Handle_Adaptor3d_HCurve.hxx>
#endif
#ifndef _Handle_Adaptor2d_HCurve2d_HeaderFile
#include <Handle_Adaptor2d_HCurve2d.hxx>
#endif
class GeomPlate_HSequenceOfCurveConstraint;
class GeomPlate_HArray1OfSequenceOfReal;
class GeomPlate_HSequenceOfPointConstraint;
class Geom_Surface;
class GeomPlate_Surface;
class TColStd_HArray1OfInteger;
class Standard_ConstructionError;
class Standard_RangeError;
class GeomPlate_HArray1OfHCurveOnSurface;
class GeomPlate_CurveConstraint;
class GeomPlate_PointConstraint;
class TColgp_SequenceOfXY;
class TColgp_SequenceOfXYZ;
class TColGeom2d_HArray1OfCurve;
class TColStd_HArray1OfReal;
class gp_Pnt2d;
class gp_Pnt;
class Geom2d_Curve;
class Adaptor3d_HCurve;
class Adaptor2d_HCurve2d;



//! This class provides an algorithm for constructing such a plate surface that <br>
//! it conforms to given curve and/or point constraints. <br>
//! The algorithm accepts or constructs an initial surface <br>
//! and looks for a deformation of it satisfying the <br>
//! constraints and minimizing energy input. <br>
//! A BuildPlateSurface object provides a framework for: <br>
//! -   defining or setting constraints <br>
//! -   implementing the construction algorithm <br>
//! -   consulting the result. <br>
class GeomPlate_BuildPlateSurface  {
public:

  DEFINE_STANDARD_ALLOC

  //! Constructor  compatible  with  the  old  version <br>
//! with this constructor the constraint are given in a Array of Curve on Surface <br>
//! The array NbPoints  contains the number of points for each constraint. <br>
//! The Array Tang contains the order of constraint for each Constraint: The possible values for this <br>
//! order has to be -1 , 0 , 1 , 2 . Order i means constraint Gi. <br>
//! NbIter is the maximum number of iteration to optimise the number of points for resolution <br>
//! Degree is the degree of resolution for Plate <br>
//! Tol2d is the tolerance used to test if two points of different constraint are identical in the <br>
//! parametric space of the initial surface <br>
//! Tol3d is used to test if two identical points in the 2d space are identical in 3d space <br>
//! TolAng is used to compare the angle between normal of two identical points in the 2d space <br>
//! Raises  ConstructionError; <br>
  Standard_EXPORT   GeomPlate_BuildPlateSurface(const Handle(TColStd_HArray1OfInteger)& NPoints,const Handle(GeomPlate_HArray1OfHCurveOnSurface)& TabCurve,const Handle(TColStd_HArray1OfInteger)& Tang,const Standard_Integer Degree,const Standard_Integer NbIter = 3,const Standard_Real Tol2d = 0.00001,const Standard_Real Tol3d = 0.0001,const Standard_Real TolAng = 0.01,const Standard_Real TolCurv = 0.1,const Standard_Boolean Anisotropie = Standard_False);
  
  Standard_EXPORT   GeomPlate_BuildPlateSurface(const Handle(Geom_Surface)& Surf,const Standard_Integer Degree = 3,const Standard_Integer NbPtsOnCur = 10,const Standard_Integer NbIter = 3,const Standard_Real Tol2d = 0.00001,const Standard_Real Tol3d = 0.0001,const Standard_Real TolAng = 0.01,const Standard_Real TolCurv = 0.1,const Standard_Boolean Anisotropie = Standard_False);
  //! Initializes the BuildPlateSurface framework for <br>
//! deforming plate surfaces using curve and point <br>
//! constraints. You use the first constructor if you have <br>
//! an initial surface to work with at construction time. If <br>
//! not, you use the second. You can add one later by <br>
//! using the method LoadInitSurface. If no initial <br>
//! surface is loaded, one will automatically be computed. <br>
//! The curve and point constraints will be defined by <br>
//! using the method Add. <br>
//! Before the call to the algorithm, the curve constraints <br>
//! will be transformed into sequences of discrete points. <br>
//! Each curve defined as a constraint will be given the <br>
//! value of NbPtsOnCur as the average number of points on it. <br>
//! Several arguments serve to improve performance of <br>
//! the algorithm. NbIter, for example, expresses the <br>
//! number of iterations allowed and is used to control the <br>
//! duration of computation. To optimize resolution, <br>
//! Degree will have the default value of 3. <br>
//! The surface generated must respect several tolerance values: <br>
//! -   2d tolerance given by Tol2d, with a default value of 0.00001 <br>
//! -   3d tolerance expressed by Tol3d, with a default value of 0.0001 <br>
//! -   angular tolerance given by TolAng, with a default <br>
//!   value of 0.01, defining the greatest angle allowed <br>
//!   between the constraint and the target surface. <br>
//! Exceptions <br>
//! Standard_ConstructionError if NbIter is less than 1 or Degree is less than 3. <br>
  Standard_EXPORT   GeomPlate_BuildPlateSurface(const Standard_Integer Degree = 3,const Standard_Integer NbPtsOnCur = 10,const Standard_Integer NbIter = 3,const Standard_Real Tol2d = 0.00001,const Standard_Real Tol3d = 0.0001,const Standard_Real TolAng = 0.01,const Standard_Real TolCurv = 0.1,const Standard_Boolean Anisotropie = Standard_False);
  //!  Resets all constraints <br>
  Standard_EXPORT     void Init() ;
  //! Loads the initial Surface <br>
  Standard_EXPORT     void LoadInitSurface(const Handle(Geom_Surface)& Surf) ;
  //! Adds the linear constraint cont. <br>
  Standard_EXPORT     void Add(const Handle(GeomPlate_CurveConstraint)& Cont) ;
  
  Standard_EXPORT     void SetNbBounds(const Standard_Integer NbBounds) ;
  //! Adds the point constraint cont. <br>
  Standard_EXPORT     void Add(const Handle(GeomPlate_PointConstraint)& Cont) ;
  
//! Calls the algorithm and computes the plate surface using <br>
//! the loaded constraints. If no initial surface is given, the <br>
//! algorithm automatically computes one. <br>
//! Exceptions <br>
//! Standard_RangeError if the value of the constraint is <br>
//! null or if plate is not done. <br>
  Standard_EXPORT     void Perform() ;
  //! returns the CurveConstraints of order order <br>
//! <br>
  Standard_EXPORT     Handle_GeomPlate_CurveConstraint CurveConstraint(const Standard_Integer order) const;
  //! returns the PointConstraint of order order <br>
//! <br>
  Standard_EXPORT     Handle_GeomPlate_PointConstraint PointConstraint(const Standard_Integer order) const;
  
  Standard_EXPORT     void Disc2dContour(const Standard_Integer nbp,TColgp_SequenceOfXY& Seq2d) ;
  
  Standard_EXPORT     void Disc3dContour(const Standard_Integer nbp,const Standard_Integer iordre,TColgp_SequenceOfXYZ& Seq3d) ;
  
//! Tests whether computation of the plate has been completed. <br>
  Standard_EXPORT     Standard_Boolean IsDone() const;
  
//! Returns the result of the computation. This surface can <br>
//! then be used by GeomPlate_MakeApprox for <br>
//! converting the resulting surface into a BSpline. <br>
  Standard_EXPORT     Handle_GeomPlate_Surface Surface() const;
  //! Returns the initial surface <br>
  Standard_EXPORT     Handle_Geom_Surface SurfInit() const;
  
//! Allows you to ensure that the array of curves returned by <br>
//! Curves2d has the correct orientation. Returns the <br>
//! orientation of the curves in the the array returned by <br>
//! Curves2d. Computation changes the orientation of <br>
//! these curves. Consequently, this method returns the <br>
//! orientation prior to computation. <br>
  Standard_EXPORT     Handle_TColStd_HArray1OfInteger Sense() const;
  
//! Extracts the array of curves on the plate surface which <br>
//! correspond to the curve constraints set in Add. <br>
  Standard_EXPORT     Handle_TColGeom2d_HArray1OfCurve Curves2d() const;
  
//! Returns the order of the curves in the array returned by <br>
//! Curves2d. Computation changes this order. <br>
//! Consequently, this method returns the order of the <br>
//! curves prior to computation. <br>
  Standard_EXPORT     Handle_TColStd_HArray1OfInteger Order() const;
  //! Returns the max distance betwen the result and the constraints <br>
  Standard_EXPORT     Standard_Real G0Error() const;
  //! Returns  the max angle betwen the result and the constraints <br>
  Standard_EXPORT     Standard_Real G1Error() const;
  //! Returns  the max difference of curvature betwen the result and the constraints <br>
//! <br>
  Standard_EXPORT     Standard_Real G2Error() const;
  //! Returns   the max distance between the result and the constraint Index <br>
  Standard_EXPORT     Standard_Real G0Error(const Standard_Integer Index) ;
  //! Returns the max angle between the result and the constraint Index <br>
  Standard_EXPORT     Standard_Real G1Error(const Standard_Integer Index) ;
  //! Returns the max difference of curvature between the result and the constraint Index <br>
//! <br>
  Standard_EXPORT     Standard_Real G2Error(const Standard_Integer Index) ;





protected:





private:

  //! Evaluates the distance, the angle between normals, and the "courbure" <br>
//!   on middle points of contraints an corresponding points on the GeomPlate_Surface <br>
//!   the results are given for a curve c <br>
  Standard_EXPORT     void EcartContraintesMil(const Standard_Integer c,Handle(TColStd_HArray1OfReal)& d,Handle(TColStd_HArray1OfReal)& an,Handle(TColStd_HArray1OfReal)& courb) ;
  
  Standard_EXPORT     gp_Pnt2d ProjectPoint(const gp_Pnt& P) ;
  
  Standard_EXPORT     Handle_Geom2d_Curve ProjectCurve(const Handle(Adaptor3d_HCurve)& Curv) ;
  
  Standard_EXPORT     Handle_Adaptor2d_HCurve2d ProjectedCurve(Handle(Adaptor3d_HCurve)& Curv) ;
  
  Standard_EXPORT     void ComputeSurfInit() ;
  
  Standard_EXPORT     void Intersect(Handle(GeomPlate_HArray1OfSequenceOfReal)& PntInter,Handle(GeomPlate_HArray1OfSequenceOfReal)& PntG1G1) ;
  
  Standard_EXPORT     void Discretise(const Handle(GeomPlate_HArray1OfSequenceOfReal)& PntInter,const Handle(GeomPlate_HArray1OfSequenceOfReal)& PntG1G1) ;
  
  Standard_EXPORT     void LoadCurve(const Standard_Integer NbBoucle,const Standard_Integer OrderMax = 2) ;
  
  Standard_EXPORT     void LoadPoint(const Standard_Integer NbBoucle,const Standard_Integer OrderMax = 2) ;
  
  Standard_EXPORT     void CalculNbPtsInit() ;
  
  Standard_EXPORT     Standard_Boolean VerifSurface(const Standard_Integer NbLoop) ;
  
  Standard_EXPORT     void VerifPoints(Standard_Real& dist,Standard_Real& ang,Standard_Real& curv) const;
  
  Standard_EXPORT     Standard_Boolean CourbeJointive(const Standard_Real tolerance) ;
  
  Standard_EXPORT     Standard_Real ComputeAnisotropie() const;
  
  Standard_EXPORT     Standard_Boolean IsOrderG1() const;


Handle_GeomPlate_HSequenceOfCurveConstraint myLinCont;
Handle_GeomPlate_HArray1OfSequenceOfReal myParCont;
Handle_GeomPlate_HArray1OfSequenceOfReal myPlateCont;
Handle_GeomPlate_HSequenceOfPointConstraint myPntCont;
Handle_Geom_Surface mySurfInit;
Handle_Geom_Surface myPlanarSurfInit;
Handle_GeomPlate_Surface myGeomPlateSurface;
Plate_Plate myPlate;
Plate_Plate myPrevPlate;
Standard_Boolean myAnisotropie;
Handle_TColStd_HArray1OfInteger mySense;
Standard_Integer myDegree;
Handle_TColStd_HArray1OfInteger myInitOrder;
Standard_Real myG0Error;
Standard_Real myG1Error;
Standard_Real myG2Error;
Standard_Integer myNbPtsOnCur;
Standard_Boolean mySurfInitIsGive;
Standard_Integer myNbIter;
Extrema_ExtPS myProj;
Standard_Real myTol2d;
Standard_Real myTol3d;
Standard_Real myTolAng;
Standard_Real myTolU;
Standard_Real myTolV;
Standard_Integer myNbBounds;
Standard_Boolean myIsLinear;
Standard_Boolean myFree;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
