// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Visual3d_ViewManager_HeaderFile
#define _Visual3d_ViewManager_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Visual3d_ViewManager_HeaderFile
#include <Handle_Visual3d_ViewManager.hxx>
#endif

#ifndef _Visual3d_SetOfView_HeaderFile
#include <Visual3d_SetOfView.hxx>
#endif
#ifndef _Handle_Visual3d_Layer_HeaderFile
#include <Handle_Visual3d_Layer.hxx>
#endif
#ifndef _Aspect_GenId_HeaderFile
#include <Aspect_GenId.hxx>
#endif
#ifndef _Handle_Graphic3d_GraphicDriver_HeaderFile
#include <Handle_Graphic3d_GraphicDriver.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TColStd_MapOfInteger_HeaderFile
#include <TColStd_MapOfInteger.hxx>
#endif
#ifndef _TColStd_SequenceOfInteger_HeaderFile
#include <TColStd_SequenceOfInteger.hxx>
#endif
#ifndef _Graphic3d_StructureManager_HeaderFile
#include <Graphic3d_StructureManager.hxx>
#endif
#ifndef _Handle_Visual3d_HSetOfView_HeaderFile
#include <Handle_Visual3d_HSetOfView.hxx>
#endif
#ifndef _Handle_Aspect_Window_HeaderFile
#include <Handle_Aspect_Window.hxx>
#endif
#ifndef _Graphic3d_Vertex_HeaderFile
#include <Graphic3d_Vertex.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Visual3d_View_HeaderFile
#include <Handle_Visual3d_View.hxx>
#endif
#ifndef _Handle_Graphic3d_Structure_HeaderFile
#include <Handle_Graphic3d_Structure.hxx>
#endif
#ifndef _Aspect_TypeOfHighlightMethod_HeaderFile
#include <Aspect_TypeOfHighlightMethod.hxx>
#endif
#ifndef _Graphic3d_CView_HeaderFile
#include <Graphic3d_CView.hxx>
#endif
#ifndef _Handle_Graphic3d_DataStructureManager_HeaderFile
#include <Handle_Graphic3d_DataStructureManager.hxx>
#endif
class Visual3d_Layer;
class Graphic3d_GraphicDriver;
class Visual3d_View;
class Visual3d_HSetOfView;
class Aspect_Window;
class Graphic3d_Vector;
class Graphic3d_Structure;
class TColStd_SequenceOfInteger;
class Aspect_GenId;
class TColStd_Array2OfReal;
class Graphic3d_DataStructureManager;


//! This class allows the definition of a manager to <br>
//!	    which the views are associated. <br>
//!	    It allows them to be globally manipulated. <br>
//!	    It activates the pick. <br>
class Visual3d_ViewManager : public Graphic3d_StructureManager {

public:

  //! Creates a 3D visualizer. <br>
//!  Currently creating of more than 100 viewer instances <br>
//!  is not supported and leads to InitializationError and <br>
//!  initialisation failure. <br>
//!  This limitation might be addressed in some future OCCT releases. <br>
//! <br>
//! Category: Methods to modify the class definition <br>
//! <br>
  Standard_EXPORT   Visual3d_ViewManager(const Handle(Graphic3d_GraphicDriver)& theDriver);
  //! Activates all the views of the manager <me>. <br>
  Standard_EXPORT     void Activate() ;
  //! Deactivates all the views of the manager <me>. <br>
  Standard_EXPORT     void Deactivate() ;
  //! Deletes and erases the 3D visualiser <me>. <br>
  Standard_EXPORT   virtual  void Destroy() ;
~Visual3d_ViewManager()
{
  Destroy();
}
  //! Erases all of the structures displayed in the <br>
//!	    visualiser <me>. <br>
  Standard_EXPORT     void Erase() ;
  //! Redraws all the displayed structures. <br>
  Standard_EXPORT     void Redraw() const;
  //! Deletes and erases the 3D visualiser <me>. <br>
  Standard_EXPORT     void Remove() ;
  //! Updates screen in function of modifications of <br>
//!	    the structures. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Not necessary if the update mode is TOU_ASAP. <br>
  Standard_EXPORT     void Update() const;
  //! Returns the group of views activated in the visualiser <me>. <br>
  Standard_EXPORT     Handle_Visual3d_HSetOfView ActivatedView() const;
  //! Applies the view orientation transformation, the <br>
//!	    view mapping transformation and view clip, the <br>
//!	    display transformation to the vertex <AVertex>. <br>
//!	    Returns the pixel coordinates <AU>, <AV>. <br>
//!  Warning: Returns <AU> = <AV> = IntegerLast () if the <br>
//!	    evaluation is impossible. <br>
//!	    -- Bad Window, Numeric error... <br>
  Standard_EXPORT     void ConvertCoord(const Handle(Aspect_Window)& AWindow,const Graphic3d_Vertex& AVertex,Standard_Integer& AU,Standard_Integer& AV) const;
  //! Applies the inverse of the display transformation, the <br>
//!	    inverse of the view mapping transformation and view clip, <br>
//!	    the inverse of the view orientation transformation to <br>
//!	    the pixel coordinates <AU>, <AV>. <br>
//!	    Returns the world coordinates <AVertex>. <br>
//!  Warning: Returns AVertex (X, Y, Z) with X = Y = Z = RealLast () <br>
//!	    if the evaluation is impossible. <br>
//!	    -- Bad Window, Numeric error... <br>
  Standard_EXPORT     Graphic3d_Vertex ConvertCoord(const Handle(Aspect_Window)& AWindow,const Standard_Integer AU,const Standard_Integer AV) const;
  //! Applies the inverse of the display transformation, the <br>
//!	    inverse of the view mapping transformation and view clip, <br>
//!	    the inverse of the view orientation transformation to <br>
//!	    the pixel coordinates <AU>, <AV>. <br>
//!	    Returns the world coordinates <AVertex> and projection ray <AVector>. <br>
//!  Warning: Returns AVertex (X, Y, Z) with X = Y = Z = RealLast () and <br>
//!          AVector (VX, VY, VZ) with VX = VY = VZ = 0. <br>
//!	    if the evaluation is impossible. <br>
//!	    -- Bad Window, Numeric error... <br>
  Standard_EXPORT     void ConvertCoordWithProj(const Handle(Aspect_Window)& AWindow,const Standard_Integer AU,const Standard_Integer AV,Graphic3d_Vertex& Point,Graphic3d_Vector& Proj) const;
  //! Returns the group of views defined in the visualiser <me>. <br>
  Standard_EXPORT     Handle_Visual3d_HSetOfView DefinedView() const;
  //! Returns the theoretical maximum number of <br>
//!	    definable views in the view manager <me>. <br>
//!  Warning: It's not possible to accept an infinite <br>
//!	    number of definable views because each <br>
//!	    view must have an identification and we <br>
//!	    have different view managers. <br>
  Standard_EXPORT     Standard_Integer MaxNumOfViews() const;
  //! Returns : <br>
//!	    a new identification number for a new view <br>
//!	    in the visualiser. <br>
  Standard_EXPORT     Standard_Integer Identification(const Handle(Visual3d_View)& AView) ;
  //! Release a unique ID of the view reserved for the view on its creation. <br>
  Standard_EXPORT     void UnIdentification(const Standard_Integer aViewId) ;
  //! Returns the structure with the identification number <AId>. <br>
  Standard_EXPORT     Handle_Graphic3d_Structure Identification(const Standard_Integer AId) const;
  //! Returns the identification number of the visualiser. <br>
  Standard_EXPORT     Standard_Integer Identification() const;
  //! Changes the display priority of the structure <AStructure>. <br>
  Standard_EXPORT     void ChangeDisplayPriority(const Handle(Graphic3d_Structure)& AStructure,const Standard_Integer OldPriority,const Standard_Integer NewPriority) ;
  //! Change Z layer for structure. The layer mechanism allows <br>
//! to display structures in higher layers in overlay of structures in <br>
//! lower layers. <br>
  Standard_EXPORT     void ChangeZLayer(const Handle(Graphic3d_Structure)& theStructure,const Standard_Integer theLayerId) ;
  //! Get Z layer ID assigned for the structure. <br>
  Standard_EXPORT     Standard_Integer GetZLayer(const Handle(Graphic3d_Structure)& theStructure) const;
  //! Add a new top-level Z layer and get its ID as <br>
//! <theLayerId> value. The method returns Standard_False if the layer <br>
//! can not be created. The layer mechanism allows to display <br>
//! structures in higher layers in overlay of structures in lower layers. <br>
  Standard_EXPORT     Standard_Boolean AddZLayer(Standard_Integer& theLayerId) ;
  //! Remove Z layer with ID <theLayerId>. Method returns <br>
//! Standard_False if the layer can not be removed or doesn't exists. <br>
//! By default, there are always default bottom-level layer that can't <br>
//! be removed. <br>
  Standard_EXPORT     Standard_Boolean RemoveZLayer(const Standard_Integer theLayerId) ;
  //! Return all Z layer ids in sequence ordered by overlay level <br>
//! from lowest layer to highest ( foreground ). The first layer ID <br>
//! in sequence is the default layer that can't be removed. <br>
  Standard_EXPORT     void GetAllZLayers(TColStd_SequenceOfInteger& theLayerSeq) const;
  //! Clears the structure <AStructure>. <br>
  Standard_EXPORT     void Clear(const Handle(Graphic3d_Structure)& AStructure,const Standard_Boolean WithDestruction) ;
  //! Connects the structures <AMother> and <ADaughter>. <br>
  Standard_EXPORT     void Connect(const Handle(Graphic3d_Structure)& AMother,const Handle(Graphic3d_Structure)& ADaughter) ;
  //! Disconnects the structures <AMother> and <ADaughter>. <br>
  Standard_EXPORT     void Disconnect(const Handle(Graphic3d_Structure)& AMother,const Handle(Graphic3d_Structure)& ADaughter) ;
  //! Display of the structure <AStructure>. <br>
  Standard_EXPORT     void Display(const Handle(Graphic3d_Structure)& AStructure) ;
  //! Erases the structure <AStructure>. <br>
  Standard_EXPORT     void Erase(const Handle(Graphic3d_Structure)& AStructure) ;
  //! Highlights the structure <AStructure>. <br>
  Standard_EXPORT     void Highlight(const Handle(Graphic3d_Structure)& AStructure,const Aspect_TypeOfHighlightMethod AMethod) ;
  
  Standard_EXPORT     void SetTransform(const Handle(Graphic3d_Structure)& AStructure,const TColStd_Array2OfReal& ATrsf) ;
  //! Suppress the highlighting on all the structures. <br>
  Standard_EXPORT     void UnHighlight() ;
  //! Suppress the highlighting on the structure <AStructure>. <br>
  Standard_EXPORT     void UnHighlight(const Handle(Graphic3d_Structure)& AStructure) ;
  //! Returns Standard_True if the view associated to the <br>
//!	    window <AWindow> exists and is activated. <br>
//!	    <TheViewId> contains the internal identification of <br>
//!	    the associated view. <br>
  Standard_EXPORT     Standard_Boolean ViewExists(const Handle(Aspect_Window)& AWindow,Graphic3d_CView& TheCView) const;
  //! Returns the underlay of the viewer <me>. <br>
  Standard_EXPORT    const Handle_Visual3d_Layer& UnderLayer() const;
  //! Returns the underlay of the viewer <me>. <br>
  Standard_EXPORT    const Handle_Visual3d_Layer& OverLayer() const;
  //! Forces a new construction of the structure <AStructure> <br>
//!	    if <AStructure> is displayed and TOS_COMPUTED. <br>
  Standard_EXPORT     void ReCompute(const Handle(Graphic3d_Structure)& AStructure) ;
  //! Forces a new construction of the structure <AStructure> <br>
//!	    if <AStructure> is displayed in <AProjector> and TOS_COMPUTED. <br>
  Standard_EXPORT     void ReCompute(const Handle(Graphic3d_Structure)& AStructure,const Handle(Graphic3d_DataStructureManager)& AProjector) ;
  //! Returns Standard_True if the transparency <br>
//!	    is activated in all activated views. <br>
//!	    Default Standard_False <br>
  Standard_EXPORT     Standard_Boolean Transparency() const;
  //! if <AFlag> is Standard_True then the transparency <br>
//!	    is managed. <br>
//!	    Default Standard_False <br>
  Standard_EXPORT     void SetTransparency(const Standard_Boolean AFlag) ;
  //! Returns Standard_True if the zbuffer activity <br>
//!	    is managed automatically. <br>
//!	    Default Standard_False <br>
  Standard_EXPORT     Standard_Boolean ZBufferAuto() const;
  //! if <AFlag> is  Standard_True then the zbuffer activity <br>
//!	    is managed automatically. <br>
//!	    Default Standard_False <br>
  Standard_EXPORT     void SetZBufferAuto(const Standard_Boolean AFlag) ;

friend class Visual3d_View;
friend class Visual3d_Layer;


  DEFINE_STANDARD_RTTI(Visual3d_ViewManager)

protected:

  //! Returns global instance of z layer ids generator. <br>
  Standard_EXPORT   static  Aspect_GenId& getZLayerGenId() ;



private: 

  //! Install z layers managed by the view manager into the <br>
//! controlled view. This method used on the view initialization to <br>
//! make the layer lists consistent. <br>
  Standard_EXPORT     void InstallZLayers(const Handle(Visual3d_View)& theView) const;
  //! Adds a new layer in all the views of <me>. <br>
  Standard_EXPORT     void SetLayer(const Handle(Visual3d_Layer)& ALayer) ;

Visual3d_SetOfView MyDefinedView;
Handle_Visual3d_Layer MyUnderLayer;
Handle_Visual3d_Layer MyOverLayer;
Aspect_GenId MyViewGenId;
Handle_Graphic3d_GraphicDriver MyGraphicDriver;
Standard_Boolean MyZBufferAuto;
Standard_Boolean MyTransparency;
TColStd_MapOfInteger myLayerIds;
TColStd_SequenceOfInteger myLayerSeq;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
