// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _AIS_AttributeFilter_HeaderFile
#define _AIS_AttributeFilter_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_AIS_AttributeFilter.hxx>

#include <Quantity_NameOfColor.hxx>
#include <Standard_Real.hxx>
#include <Standard_Boolean.hxx>
#include <SelectMgr_Filter.hxx>
#include <Handle_SelectMgr_EntityOwner.hxx>
class SelectMgr_EntityOwner;


//! Selects Interactive Objects, which have the desired width or color.
//! The filter questions each Interactive Object in local
//! context to determine whether it has an non-null
//! owner, and if so, whether it has the required color
//! and width attributes. If the object returns true in each
//! case, it is kept. If not, it is rejected.
//! This filter is used only in an open local context.
//! In the Collector viewer, you can only locate
//! Interactive Objects, which answer positively to the
//! filters, which are in position when a local context is open.
class AIS_AttributeFilter : public SelectMgr_Filter
{

public:

  

  //! Constructs an empty attribute filter object.
  //! This filter object determines whether selectable
  //! interactive objects have a non-null owner.
  Standard_EXPORT AIS_AttributeFilter();
  

  //! Constructs an attribute filter object defined by the
  //! color attribute aCol.
  Standard_EXPORT AIS_AttributeFilter(const Quantity_NameOfColor aCol);
  

  //! Constructs an attribute filter object defined by the line
  //! width attribute aWidth.
  Standard_EXPORT AIS_AttributeFilter(const Standard_Real aWidth);
  

  //! Indicates that the Interactive Object has the color
  //! setting specified by the argument aCol at construction time.
      Standard_Boolean HasColor()  const;
  

  //! Indicates that the Interactive Object has the width
  //! setting specified by the argument aWidth at
  //! construction time.
      Standard_Boolean HasWidth()  const;
  
  //! Sets the color aCol.
  //! This must be chosen from the list of colors in Quantity_NameOfColor.
      void SetColor (const Quantity_NameOfColor aCol) ;
  
  //! Sets the line width aWidth.
      void SetWidth (const Standard_Real aWidth) ;
  

  //! Removes the setting for color from the filter.
      void UnsetColor() ;
  

  //! Removes the setting for width from the filter.
      void UnsetWidth() ;
  
  //! Indicates that the selected Interactive Object passes
  //! the filter. The owner, anObj, can be either direct or
  //! user. A direct owner is the corresponding
  //! construction element, whereas a user is the
  //! compound shape of which the entity forms a part.
  //! If the Interactive Object returns Standard_True
  //! when detected by the Local Context selector through
  //! the mouse, the object is kept; if not, it is rejected.
  Standard_EXPORT virtual   Standard_Boolean IsOk (const Handle(SelectMgr_EntityOwner)& anObj)  const;




  DEFINE_STANDARD_RTTI(AIS_AttributeFilter)

protected:




private: 


  Quantity_NameOfColor myCol;
  Standard_Real myWid;
  Standard_Boolean hasC;
  Standard_Boolean hasW;


};


#include <AIS_AttributeFilter.lxx>





#endif // _AIS_AttributeFilter_HeaderFile
