// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeUpgrade_ConvertSurfaceToBezierBasis_HeaderFile
#define _ShapeUpgrade_ConvertSurfaceToBezierBasis_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_ShapeUpgrade_ConvertSurfaceToBezierBasis.hxx>

#include <Handle_ShapeExtend_CompositeSurface.hxx>
#include <Standard_Boolean.hxx>
#include <ShapeUpgrade_SplitSurface.hxx>
class ShapeExtend_CompositeSurface;


//! Converts a plane, bspline surface, surface of revolution, surface
//! of extrusion, offset surface to grid of bezier basis surface (
//! bezier surface,
//! surface of revolution based on bezier curve,
//! offset surface based on any previous type).
class ShapeUpgrade_ConvertSurfaceToBezierBasis : public ShapeUpgrade_SplitSurface
{

public:

  
  //! Empty constructor.
  Standard_EXPORT ShapeUpgrade_ConvertSurfaceToBezierBasis();
  
  //! Splits a list of beziers computed by Compute method according
  //! the split values and splitting parameters.
  Standard_EXPORT virtual   void Build (const Standard_Boolean Segment) ;
  
  //! Converts surface into a grid of bezier based surfaces, and
  //! stores this grid.
  Standard_EXPORT virtual   void Compute (const Standard_Boolean Segment) ;
  
  //! Returns the grid of bezier based surfaces correspondent to
  //! original surface.
  Standard_EXPORT   Handle(ShapeExtend_CompositeSurface) Segments()  const;
  
  //! Sets mode for conversion Geom_Plane to Bezier
      void SetPlaneMode (const Standard_Boolean mode) ;
  
  //! Returns the Geom_Pline conversion mode.
      Standard_Boolean GetPlaneMode()  const;
  
  //! Sets mode for conversion Geom_SurfaceOfRevolution to Bezier
      void SetRevolutionMode (const Standard_Boolean mode) ;
  
  //! Returns the Geom_SurfaceOfRevolution conversion mode.
      Standard_Boolean GetRevolutionMode()  const;
  
  //! Sets mode for conversion Geom_SurfaceOfLinearExtrusion to Bezier
      void SetExtrusionMode (const Standard_Boolean mode) ;
  
  //! Returns the Geom_SurfaceOfLinearExtrusion conversion mode.
      Standard_Boolean GetExtrusionMode()  const;
  
  //! Sets mode for conversion Geom_BSplineSurface to Bezier
      void SetBSplineMode (const Standard_Boolean mode) ;
  
  //! Returns the Geom_BSplineSurface conversion mode.
      Standard_Boolean GetBSplineMode()  const;




  DEFINE_STANDARD_RTTI(ShapeUpgrade_ConvertSurfaceToBezierBasis)

protected:




private: 


  Handle(ShapeExtend_CompositeSurface) mySegments;
  Standard_Boolean myPlaneMode;
  Standard_Boolean myRevolutionMode;
  Standard_Boolean myExtrusionMode;
  Standard_Boolean myBSplineMode;


};


#include <ShapeUpgrade_ConvertSurfaceToBezierBasis.lxx>





#endif // _ShapeUpgrade_ConvertSurfaceToBezierBasis_HeaderFile
