# OpenVAS
# $Id$
# Description: RPM spec file for openvas-client
#
# Authors:
# Jan-Oliver Wagner <jan-oliver.wagner@intevation.de>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.de
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

%define PACKAGE_NAME openvas-client
%define PROGNAME OpenVAS-Client
%define PACKAGE_VERSION 1.0.3
%define release 1.suse102.openvas
%define _prefix /usr

Summary: OpenVAS-Client, a GTK GUI for the OpenVAS Network Security Scanner
Name:    %PACKAGE_NAME
Version: %PACKAGE_VERSION
Release: %{release}
Source0: openvas-client-%{version}.tar.gz
License: GNU GPLv2 
Group: Productivity/Networking/Security
Vendor: OpenVAS Development Team, http://www.openvas.org 
Distribution: OpenSUSE 10.2
BuildRoot: %{_builddir}/%{name}-root
Prefix: %{_prefix}
URL: http://www.openvas.org
Requires: openssl gtk2
BuildRequires: openssl-devel gtk2-devel gettext-devel gcc-c++

%description
A GTK+ GUI for the OpenVAS Network Vulnerability Scanner.
Includes SLADinstaller, a GUI for remotely
installing SLAD.

%prep
%setup -b 0

%build
%configure --prefix=%{_prefix}
make
cd po
make

%install
%makeinstall
mkdir -p $RPM_BUILD_ROOT/usr/share/pixmaps/
cp src/xpm/OpenVAS-logo.xpm $RPM_BUILD_ROOT/usr/share/pixmaps/OpenVAS-Client.xpm
mkdir -p $RPM_BUILD_ROOT/usr/share/applications/
cp nessus/OpenVAS-Client.desktop $RPM_BUILD_ROOT/usr/share/applications
cd po
make install DESTDIR=$RPM_BUILD_ROOT

%post
%{run_ldconfig}

%postun
%{run_ldconfig}

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%{_bindir}/%{PROGNAME}
%{_bindir}/openvasclient-mkcert
#%{_bindir}/openvasclient-mkrand
%{_mandir}/man1/%{PROGNAME}.1*
%{_mandir}/man1/openvasclient-mkcert.1*
%{_mandir}/man1/openvasclient-mkrand.1*
%{_datadir}/applications/%{PROGNAME}.desktop
%{_datadir}/pixmaps/%{PROGNAME}.xpm
%{_datadir}/locale/*/LC_MESSAGES/%{PROGNAME}.mo

%changelog
* Tue Apr 15 2008 Jan-Oliver Wagner <jan@intevation.de>
  Initial SUSE 10.2 spec file, tested for i586
