# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1767-1 (multipath-tools)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63794);
 script_cve_id("CVE-2009-0115");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.9");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1767-1 (multipath-tools)";
 script_name(name);

 desc = "The remote host is missing an update to multipath-tools
announced via advisory DSA 1767-1.


It was discovered that multipathd of multipath-tools, a tool-chain to manage
disk multipath device maps, uses insecure permissions on its unix domain
control socket which enables local attackers to issue commands to multipathd
prevent access to storage devices or corrupt file system data.

For the oldstable distribution (etch), this problem has been fixed in
version 0.4.7-1.1etch2.

For the stable distribution (lenny), this problem has been fixed in
version 0.4.8-14+lenny1.

For the testing distribution (squeeze), this problem will be fixed soon.

For the unstable distribution (sid), this problem has been fixed in
version 0.4.8-15.

We recommend that you upgrade your multipath-tools packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201767-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1767-1 (multipath-tools)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"multipath-tools", ver:"0.4.7-1.1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"multipath-tools-boot", ver:"0.4.8-14+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"multipath-tools", ver:"0.4.8-14+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpartx", ver:"0.4.8-14+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
