# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1846-1 (kvm)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64557);
 script_cve_id("CVE-2009-2287");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.9");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Debian Security Advisory DSA 1846-1 (kvm)");

 desc = "The remote host is missing an update to kvm
announced via advisory DSA 1846-1.

Matt T. Yourst discovered an issue in the kvm subsystem. Local
users with permission to manipulate /dev/kvm can cause a denial
of service (hang) by providing an invalid cr3 value to the
KVM_SET_SREGS call.

For the stable distribution (lenny), these problems have been fixed
in version 72+dfsg-5~lenny2.

For the unstable distribution (sid), these problems will be fixed soon.

We recommend that you upgrade your kvm packages, and rebuild any kernel

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201846-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1846-1 (kvm)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kvm-source", ver:"72+dfsg-5~lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kvm", ver:"72+dfsg-5~lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
