# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3720 (argyllcms)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63839);
 script_cve_id("CVE-2009-0792", "CVE-2009-0583");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Fedora Core 9 FEDORA-2009-3720 (argyllcms)";
 script_name(name);

 desc = "The remote host is missing an update to argyllcms
announced via advisory FEDORA-2009-3720.

Update Information:

Apply patch for CVE-2009-0792.

ChangeLog:

* Thu Apr 16 2009 Jon Ciesla  - 1.0.3-5
- Actually *apply* previous patch.
* Wed Apr  8 2009 Jon Ciesla  - 1.0.3-4
- Patch for ICC library CVE-2009-0792.
* Mon Mar 23 2009 Jon Ciesla  - 1.0.3-3
- Patch for ICC library CVE-2009-{0583, 0584} by Tim Waugh.

References:

[ 1 ] Bug #491853 - CVE-2009-0792 ghostscript, argyllcms: Incomplete fix for CVE-2009-0583
https://bugzilla.redhat.com/show_bug.cgi?id=491853

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update argyllcms' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3720

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-3720 (argyllcms)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"argyllcms", rpm:"argyllcms~1.0.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"argyllcms-doc", rpm:"argyllcms-doc~1.0.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"argyllcms-debuginfo", rpm:"argyllcms-debuginfo~1.0.3~5.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
