###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_thunderbird_vuln_jun09_lin.nasl 2940 2009-06-16 11:30:36Z jun $
#
# Mozilla Thunderbird Multiple Vulnerabilities Jun-09 (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800639);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1832", "CVE-2009-1833", "CVE-2009-1836", "CVE-2009-1838",
                "CVE-2009-1840", "CVE-2009-1841", "CVE-2009-1392");
  script_bugtraq_id(35326);
  script_name("Mozilla Thunderbird Multiple Vulnerability Jun-09 (Linux)");
  desc = "

  Overview: The host is installed with Thunderbird, which is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  - Error in js/src/xpconnect/src/xpcwrappedjsclass.cpp file will allow attacker
    to execute arbitrary web script.
  - An error when handling a non-200 response returned by a proxy in reply to a
    CONNECT request, which could cause the body of the response to be rendered
    within the context of the request 'Host:' header.
  - An error when handling event listeners attached to an element whose owner
    document is null.
  - Due to content-loading policies not being checked before loading external
    script files into XUL documents, which could be exploited to bypass
    restrictions.
  - An error when handling event listeners attached to an element whose owner
    document is null.
  - Error exists in JavaScript engine is caused via vectors related to
    js_LeaveSharpObject, ParseXMLSource, and a certain assertion in jsinterp.c.
  - Error exists via vectors involving 'double frame construction.'

  Impact:
  Successful exploitation could result in remote arbitrary JavaScript code
  execution, spoofing attacks, sensitive information disclosure, and can cause
  denial of service.

  Impact Level: System/Application

  Affected Software/OS:
  Thunderbire version prior to 2.0.0.22 on Linux.

  Fix: Upgrade to Firefox version 2.0.0.22
  http://www.mozilla.com/en-US/thunderbird/all.html

  References:
  http://www.vupen.com/english/advisories/2009/1572
  http://www.mozilla.org/security/announce/2009/mfsa2009-24.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-27.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-29.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-31.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-32.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Thunderbird");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_thunderbird_detect_lin.nasl");
  script_require_keys("Thunderbird/Linux/Ver");
  exit(0);
}


include("version_func.inc");

thunderbirdVer = get_kb_item("Thunderbird/Linux/Ver");
# Check for Thunderbird Version < 2.0.0.22
if(thunderbirdVer != NULL)
{
  if(version_is_less(version:thunderbirdVer ,test_version:"2.0.0.22")){
    security_hole(0);
  }
}
