###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for samba vulnerability USN-893-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840381);
  script_version("$Revision: 7480 $: 1.0");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "893-1");
  script_cve_id("CVE-2009-3297");
  script_name("Ubuntu Update for samba vulnerability USN-893-1");
  desc = "

  Vulnerability Insight:

  Ronald Volgers discovered that the mount.cifs utility, when installed as a
  setuid program, suffered from a race condition when verifying user
  permissions. A local attacker could trick samba into mounting over
  arbitrary locations, leading to a root privilege escalation.

  Affected Software/OS:
  samba vulnerability on Ubuntu 6.06 LTS ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-January/001039.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of samba vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.3.2-1ubuntu3.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.3.2-1ubuntu3.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient", ver:"3.3.2-1ubuntu3.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libwbclient0", ver:"3.3.2-1ubuntu3.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-common", ver:"3.3.2-1ubuntu3.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-dbg", ver:"3.3.2-1ubuntu3.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba", ver:"3.3.2-1ubuntu3.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbclient", ver:"3.3.2-1ubuntu3.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbfs", ver:"3.3.2-1ubuntu3.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"winbind", ver:"3.3.2-1ubuntu3.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-tools", ver:"3.3.2-1ubuntu3.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"swat", ver:"3.3.2-1ubuntu3.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.3.2-1ubuntu3.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc", ver:"3.3.2-1ubuntu3.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.0.22-1ubuntu3.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.0.22-1ubuntu3.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient", ver:"3.0.22-1ubuntu3.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-samba", ver:"3.0.22-1ubuntu3.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-common", ver:"3.0.22-1ubuntu3.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-dbg", ver:"3.0.22-1ubuntu3.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba", ver:"3.0.22-1ubuntu3.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbclient", ver:"3.0.22-1ubuntu3.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbfs", ver:"3.0.22-1ubuntu3.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"swat", ver:"3.0.22-1ubuntu3.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"winbind", ver:"3.0.22-1ubuntu3.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.0.22-1ubuntu3.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc", ver:"3.0.22-1ubuntu3.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.2.3-1ubuntu3.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.2.3-1ubuntu3.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient", ver:"3.2.3-1ubuntu3.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libwbclient0", ver:"3.2.3-1ubuntu3.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-common", ver:"3.2.3-1ubuntu3.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-dbg", ver:"3.2.3-1ubuntu3.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-tools", ver:"3.2.3-1ubuntu3.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba", ver:"3.2.3-1ubuntu3.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbclient", ver:"3.2.3-1ubuntu3.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbfs", ver:"3.2.3-1ubuntu3.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"swat", ver:"3.2.3-1ubuntu3.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"winbind", ver:"3.2.3-1ubuntu3.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.2.3-1ubuntu3.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc", ver:"3.2.3-1ubuntu3.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.0.28a-1ubuntu4.10", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.0.28a-1ubuntu4.10", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient", ver:"3.0.28a-1ubuntu4.10", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-common", ver:"3.0.28a-1ubuntu4.10", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-dbg", ver:"3.0.28a-1ubuntu4.10", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba", ver:"3.0.28a-1ubuntu4.10", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbclient", ver:"3.0.28a-1ubuntu4.10", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbfs", ver:"3.0.28a-1ubuntu4.10", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"swat", ver:"3.0.28a-1ubuntu4.10", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"winbind", ver:"3.0.28a-1ubuntu4.10", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.0.28a-1ubuntu4.10", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc", ver:"3.0.28a-1ubuntu4.10", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.4.0-3ubuntu5.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.4.0-3ubuntu5.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient", ver:"3.4.0-3ubuntu5.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libwbclient0", ver:"3.4.0-3ubuntu5.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-common-bin", ver:"3.4.0-3ubuntu5.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-dbg", ver:"3.4.0-3ubuntu5.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba", ver:"3.4.0-3ubuntu5.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbclient", ver:"3.4.0-3ubuntu5.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbfs", ver:"3.4.0-3ubuntu5.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"winbind", ver:"3.4.0-3ubuntu5.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-tools", ver:"3.4.0-3ubuntu5.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"swat", ver:"3.4.0-3ubuntu5.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-common", ver:"3.4.0-3ubuntu5.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.4.0-3ubuntu5.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc", ver:"3.4.0-3ubuntu5.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}