/**
 * @file
 *
 * @author jeffrey.daily@gmail.com
 *
 * Copyright (c) 2015 Battelle Memorial Institute.
 *
 * This file was converted to C code from the raw file found at
 * ftp://ftp.cbi.pku.edu.cn/pub/software/blast/matrices/BLOSUM35, the
 * Center for Bioinformatics, Peking University, China.
 */
#ifndef _PARASAIL_BLOSUM35_H_
#define _PARASAIL_BLOSUM35_H_

#include "parasail.h"
#include "blosum_map.h"

#ifdef __cplusplus
extern "C" {
#endif

/* #  Matrix made by matblas from blosum35.iij */
/* #  * column uses minimum score */
/* #  BLOSUM Clustered Scoring Matrix in 1/4 Bit Units */
/* #  Blocks Database = /data/blocks_5.0/blocks.dat */
/* #  Cluster Percentage: >= 35 */
/* #  Entropy =   0.2111, Expected =  -0.1550 */

static const int parasail_blosum35_[] = {
/*        A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   * */
/* A */   5, -1, -1, -1, -2,  0, -1,  0, -2, -1, -2,  0,  0, -2, -2,  1,  0, -2, -1,  0, -1, -1,  0, -5,
/* R */  -1,  8, -1, -1, -3,  2, -1, -2, -1, -3, -2,  2,  0, -1, -2, -1, -2,  0,  0, -1, -1,  0, -1, -5,
/* N */  -1, -1,  7,  1, -1,  1, -1,  1,  1, -1, -2,  0, -1, -1, -2,  0,  0, -2, -2, -2,  4,  0,  0, -5,
/* D */  -1, -1,  1,  8, -3, -1,  2, -2,  0, -3, -2, -1, -3, -3, -1, -1, -1, -3, -2, -2,  5,  1, -1, -5,
/* C */  -2, -3, -1, -3, 15, -3, -1, -3, -4, -4, -2, -2, -4, -4, -4, -3, -1, -5, -5, -2, -2, -2, -2, -5,
/* Q */   0,  2,  1, -1, -3,  7,  2, -2, -1, -2, -2,  0, -1, -4,  0,  0,  0, -1,  0, -3,  0,  4, -1, -5,
/* E */  -1, -1, -1,  2, -1,  2,  6, -2, -1, -3, -1,  1, -2, -3,  0,  0, -1, -1, -1, -2,  0,  5, -1, -5,
/* G */   0, -2,  1, -2, -3, -2, -2,  7, -2, -3, -3, -1, -1, -3, -2,  1, -2, -1, -2, -3,  0, -2, -1, -5,
/* H */  -2, -1,  1,  0, -4, -1, -1, -2, 12, -3, -2, -2,  1, -3, -1, -1, -2, -4,  0, -4,  0, -1, -1, -5,
/* I */  -1, -3, -1, -3, -4, -2, -3, -3, -3,  5,  2, -2,  1,  1, -1, -2, -1, -1,  0,  4, -2, -3,  0, -5,
/* L */  -2, -2, -2, -2, -2, -2, -1, -3, -2,  2,  5, -2,  3,  2, -3, -2,  0,  0,  0,  2, -2, -2,  0, -5,
/* K */   0,  2,  0, -1, -2,  0,  1, -1, -2, -2, -2,  5,  0, -1,  0,  0,  0,  0, -1, -2,  0,  1,  0, -5,
/* M */   0,  0, -1, -3, -4, -1, -2, -1,  1,  1,  3,  0,  6,  0, -3, -1,  0,  1,  0,  1, -2, -2,  0, -5,
/* F */  -2, -1, -1, -3, -4, -4, -3, -3, -3,  1,  2, -1,  0,  8, -4, -1, -1,  1,  3,  1, -2, -3, -1, -5,
/* P */  -2, -2, -2, -1, -4,  0,  0, -2, -1, -1, -3,  0, -3, -4, 10, -2,  0, -4, -3, -3, -1,  0, -1, -5,
/* S */   1, -1,  0, -1, -3,  0,  0,  1, -1, -2, -2,  0, -1, -1, -2,  4,  2, -2, -1, -1,  0,  0,  0, -5,
/* T */   0, -2,  0, -1, -1,  0, -1, -2, -2, -1,  0,  0,  0, -1,  0,  2,  5, -2, -2,  1, -1, -1,  0, -5,
/* W */  -2,  0, -2, -3, -5, -1, -1, -1, -4, -1,  0,  0,  1,  1, -4, -2, -2, 16,  3, -2, -3, -1, -1, -5,
/* Y */  -1,  0, -2, -2, -5,  0, -1, -2,  0,  0,  0, -1,  0,  3, -3, -1, -2,  3,  8,  0, -2, -1, -1, -5,
/* V */   0, -1, -2, -2, -2, -3, -2, -3, -4,  4,  2, -2,  1,  1, -3, -1,  1, -2,  0,  5, -2, -2,  0, -5,
/* B */  -1, -1,  4,  5, -2,  0,  0,  0,  0, -2, -2,  0, -2, -2, -1,  0, -1, -3, -2, -2,  5,  0, -1, -5,
/* Z */  -1,  0,  0,  1, -2,  4,  5, -2, -1, -3, -2,  1, -2, -3,  0,  0, -1, -1, -1, -2,  0,  4,  0, -5,
/* X */   0, -1,  0, -1, -2, -1, -1, -1, -1,  0,  0,  0,  0, -1, -1,  0,  0, -1, -1,  0, -1,  0, -1, -5,
/* * */  -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,  1
};

static const parasail_matrix_t parasail_blosum35 = {
    "blosum35",
    parasail_blosum35_,
    parasail_blosum_map,
    24,
    16,
    -5,
    NULL,
    PARASAIL_MATRIX_TYPE_SQUARE,
    24,
    "ARNDCQEGHILKMFPSTWYVBZX*",
    NULL
};

#ifdef __cplusplus
}
#endif

#endif /* _PARASAIL_BLOSUM35_H_ */

