/*
 * OpenTest.java
 *
 * Created on 24. Juni 2006, 11:14
 *
 */

package pauker.program.gui.swing;

import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import junit.framework.TestCase;
import org.netbeans.jemmy.ClassReference;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JCheckBoxMenuItemOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JFileChooserOperator;
import org.netbeans.jemmy.operators.JFrameOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.JMenuItemOperator;
import org.netbeans.jemmy.operators.JMenuOperator;
import org.netbeans.jemmy.util.NameComponentChooser;
import screenshots.Screenshots;

/**
 *
 * @author Ronny.Standtke@gmx.net
 */
public class OpenTest extends TestCase {

    private JFrameOperator frameOperator;
    private JMenuOperator fileMenuOperator;

    /**
     * runs the test
     * @throws java.lang.Exception
     */
    public void testOpen() throws Exception {

        assertFalse("Only screenshots are generated!",
                Screenshots.UPDATE_SCREENSHOTS);

        ResourceBundle strings = ResourceBundle.getBundle("pauker/Strings");

        // get path of test lesson
        String internalPath = "/testLessons/1.pau.gz";
        String testFilePath = getClass().getResource(internalPath).getPath();
        File testFile = new File(testFilePath);

        ClassReference classReference = new ClassReference(
                "pauker.program.gui.swing.PaukerFrame");
        classReference.startApplication(new String[]{testFilePath});
        frameOperator = new JFrameOperator();
        final JButtonOperator newButtonOperator = new JButtonOperator(
                frameOperator, new NameComponentChooser("newButton"));
        JLabelOperator summaryLabelOperator = new JLabelOperator(
                frameOperator, new NameComponentChooser("summaryLabel"));
        fileMenuOperator = new JMenuOperator(
                frameOperator, new NameComponentChooser("fileMenu"));
        JButtonOperator saveButtonOperator = new JButtonOperator(
                frameOperator, new NameComponentChooser("saveButton"));
        JMenuOperator extraMenuOperator = new JMenuOperator(
                frameOperator, new NameComponentChooser("extraMenu"));
        JListOperator batchListOperator = new JListOperator(
                frameOperator, new NameComponentChooser("batchList"));

        // check, if command line open was successfull
        String summaryString = strings.getString("SummaryLabel");
        String formattedSummary = MessageFormat.format(summaryString,
                Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1));
        assertEquals(formattedSummary, summaryLabelOperator.getText());

        // ensure that toolbar is visible
        extraMenuOperator.doClick();
        JCheckBoxMenuItemOperator showToolBarMenuItem =
                new JCheckBoxMenuItemOperator(frameOperator);
        showToolBarMenuItem.setSelected(true);

        Tools.doClick(newButtonOperator);

        // test opening via menu item
        openFile(testFile, false);
        summaryLabelOperator.waitText(formattedSummary);

        // test merging of lessons
        fileMenuOperator.doClick();
        JMenuItemOperator openMenuItemOperator = new JMenuItemOperator(
                frameOperator, new NameComponentChooser("openMenuItem"));
        openMenuItemOperator.push();
        JDialogOperator openFileDialogOperator = new JDialogOperator();
        JFileChooserOperator fileChooserOperator = new JFileChooserOperator();
        fileChooserOperator.setSelectedFile(testFile);
        JCheckBoxOperator mergingCheckBoxOperator = new JCheckBoxOperator(
                openFileDialogOperator, 
                new NameComponentChooser("mergingCheckBox"));
        mergingCheckBoxOperator.setSelected(true);
        JButtonOperator openButtonOperator = new JButtonOperator(
                openFileDialogOperator, new NameComponentChooser("openButton"));
        Tools.doClick(openButtonOperator);
        formattedSummary = MessageFormat.format(summaryString,
                Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(2));
        assertEquals(formattedSummary, summaryLabelOperator.getText());
        saveButtonOperator.waitComponentEnabled();
        Tools.clickComponentOperator(summaryLabelOperator);
        batchListOperator.waitComponentShowing(true);
        assertEquals("summary batch was not correctly updated when merging " +
                "lessons!", 2, batchListOperator.getModel().getSize());

        newButtonOperator.pushNoBlock();
        JDialogOperator dialogOperator = new JDialogOperator();
        JButtonOperator dontSaveButtonOperator = new JButtonOperator(
                dialogOperator, strings.getString("DontSave"));
        Tools.doClick(dontSaveButtonOperator);

        // test recent file menu
        fileMenuOperator.doClick();
        JMenuOperator recentFilesMenuOperator = new JMenuOperator(
                frameOperator, new NameComponentChooser("recentFilesMenu"));
        recentFilesMenuOperator.doClick();
        JMenuItemOperator recentFilesMenuItem1Operator = new JMenuItemOperator(
                (JMenuItem) recentFilesMenuOperator.getMenuComponent(0));
        Tools.clickComponentOperator(recentFilesMenuItem1Operator);
        formattedSummary = MessageFormat.format(summaryString,
                Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1));
        summaryLabelOperator.waitText(formattedSummary);

        // try opening unzipped xml lesson
        internalPath = "/testLessons/Laender-Hauptstaedte.xml";
        testFilePath = getClass().getResource(internalPath).getPath();
        testFile = new File(testFilePath);
        openFile(testFile, true);
        formattedSummary = MessageFormat.format(summaryString,
                Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(191));
        assertEquals(formattedSummary, summaryLabelOperator.getText());

        // test that selecting a file that is no Pauker lesson is shown
        // in the file chooser accessory
        internalPath = "/testLessons/noPaukerLesson.txt";
        String noLessonPath = getClass().getResource(internalPath).getPath();
        File noLessonFile = new File(noLessonPath);

        // select a lesson
        testAccessory(testFile, true);
        testAccessory(noLessonFile, false);
        testAccessory(testFile, true);
        testAccessory(noLessonFile, false);

        // try opening a CSV file
        internalPath = "/testLessons/Test.csv";
        String csvLessonPath = getClass().getResource(internalPath).getPath();
        File csvLessonFile = new File(csvLessonPath);
        testAccessory(csvLessonFile, true);
    }

    private void testAccessory(File file, boolean lessonPanelVisible) {
        fileMenuOperator.doClick();
        JMenuItemOperator openMenuItemOperator = new JMenuItemOperator(
                frameOperator, new NameComponentChooser("openMenuItem"));
        openMenuItemOperator.push();
        JDialogOperator openFileDialogOperator = new JDialogOperator();
        JFileChooserOperator fileChooserOperator = new JFileChooserOperator();
        fileChooserOperator.setFileFilter(
                fileChooserOperator.getAcceptAllFileFilter());
        fileChooserOperator.setSelectedFile(file);
        if (lessonPanelVisible) {
            JComponentOperator lessonPanelOperator = new JComponentOperator(
                    openFileDialogOperator, 
                    new NameComponentChooser("lessonPanel"));
            assertTrue("lesson preview is not showing!",
                    lessonPanelOperator.isShowing());
        } else {
            JComponentOperator noLessonPanelOperator = new JComponentOperator(
                    openFileDialogOperator, 
                    new NameComponentChooser("noLessonPanel"));
            assertTrue(noLessonPanelOperator.isShowing());
        }
        openFileDialogOperator.close();
    }

    private void openFile(File file, boolean setAcceptAllFileFilter) {
        fileMenuOperator.doClick();
        JMenuItemOperator openMenuItemOperator = new JMenuItemOperator(
                frameOperator, new NameComponentChooser("openMenuItem"));
        openMenuItemOperator.push();
        JDialogOperator openFileDialogOperator = new JDialogOperator();
        JFileChooserOperator fileChooserOperator = new JFileChooserOperator();
        fileChooserOperator.setSelectedFile(file);
        if (setAcceptAllFileFilter) {
            fileChooserOperator.setFileFilter(
                    fileChooserOperator.getAcceptAllFileFilter());
        }
        JButtonOperator openButtonOperator = new JButtonOperator(
                openFileDialogOperator, new NameComponentChooser("openButton"));
        openButtonOperator.doClick();
    }
}
