/*
 * Software License Agreement (BSD License)
 *
 *  Point Cloud Library (PCL) - www.pointclouds.org
 *  Copyright (c) 2010-2012, Willow Garage, Inc.
 *
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/or other materials provided
 *     with the distribution.
 *   * Neither the name of the copyright holder(s) nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 *  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id$
 *
 */

#include <gtest/gtest.h>
#include <pcl/pcl_tests.h>
#include <pcl/filters/convolution.h>
#include <pcl/point_types.h>

using namespace pcl;
using namespace pcl::test;

PointCloud<PointXYZI>::Ptr input (new PointCloud<PointXYZI> ());
Eigen::ArrayXf filter(7);

TEST (Convolution, convolveRows)
{
  using namespace pcl::common;
  using namespace pcl::filters;
  pcl::filters::Convolution<PointXYZI, PointXYZI> convolve;
  PointCloud<PointXYZI>::Ptr output;
  output.reset (new PointCloud<PointXYZI> ());
  convolve.setInputCloud (input);
  convolve.setKernel (filter);
  convolve.convolveRows (*output);

  // first output row
  Eigen::ArrayXf output_0 (64);
  output_0[0] = 0; output_0[1] = 0; output_0[2] = 0; output_0[3] = 94.1702; output_0[4] = 93.3588; output_0[5] = 92.8969; output_0[6] = 92.8653; output_0[7] = 92.484; output_0[8] = 92.0451; output_0[9] = 91.6455; output_0[10] = 90.9415; output_0[11] = 90.0539; output_0[12] = 89.3048; output_0[13] = 88.7623; output_0[14] = 88.3004; output_0[15] = 88.0044; output_0[16] = 87.7579; output_0[17] = 87.5424; output_0[18] = 87.4441; output_0[19] = 87.0711; output_0[20] = 86.1525; output_0[21] = 84.9014; output_0[22] = 84.1213; output_0[23] = 83.7668; output_0[24] = 83.5469; output_0[25] = 83.5159; output_0[26] = 83.538; output_0[27] = 83.641; output_0[28] = 83.3946; output_0[29] = 82.7889; output_0[30] = 82.3278; output_0[31] = 82.0983; output_0[32] = 82.2605; output_0[33] = 82.376; output_0[34] = 82.1481; output_0[35] = 81.5513; output_0[36] = 81.1708; output_0[37] = 81.3049; output_0[38] = 81.6366; output_0[39] = 81.5826; output_0[40] = 80.9955; output_0[41] = 80.3633; output_0[42] = 80.1213; output_0[43] = 80.3048; output_0[44] = 80.695; output_0[45] = 80.8831; output_0[46] = 80.6995; output_0[47] = 80.3633; output_0[48] = 80.435; output_0[49] = 81.278; output_0[50] = 83.3201; output_0[51] = 86.7523; output_0[52] = 88.1634; output_0[53] = 83.7249; output_0[54] = 77.6666; output_0[55] = 75.8489; output_0[56] = 77.8468; output_0[57] = 79.8108; output_0[58] = 80.4707; output_0[59] = 80.9244; output_0[60] = 81.8518; output_0[61] = 0; output_0[62] = 0; output_0[63] = 0;

  // last output row
  Eigen::ArrayXf output_47 (64);
  output_47[0] = 0; output_47[1] = 0; output_47[2] = 0; output_47[3] = 121.887; output_47[4] = 121.395; output_47[5] = 120.547; output_47[6] = 119.866; output_47[7] = 119.493; output_47[8] = 119.153; output_47[9] = 118.484; output_47[10] = 117.753; output_47[11] = 117.009; output_47[12] = 116.35; output_47[13] = 115.941; output_47[14] = 115.349; output_47[15] = 114.35; output_47[16] = 113.588; output_47[17] = 112.99; output_47[18] = 111.645; output_47[19] = 110.009; output_47[20] = 109.13; output_47[21] = 108.771; output_47[22] = 108.592; output_47[23] = 108.641; output_47[24] = 108.345; output_47[25] = 107.592; output_47[26] = 107.063; output_47[27] = 106.767; output_47[28] = 106.592; output_47[29] = 106.645; output_47[30] = 106.399; output_47[31] = 105.843; output_47[32] = 105.57; output_47[33] = 105.502; output_47[34] = 105.557; output_47[35] = 105.672; output_47[36] = 105.56; output_47[37] = 104.897; output_47[38] = 104.642; output_47[39] = 104.708; output_47[40] = 104.054; output_47[41] = 103.556; output_47[42] = 103.982; output_47[43] = 104.43; output_47[44] = 104.682; output_47[45] = 104.596; output_47[46] = 104.104; output_47[47] = 103.852; output_47[48] = 103.964; output_47[49] = 103.91; output_47[50] = 103.556; output_47[51] = 102.614; output_47[52] = 102.126; output_47[53] = 102.762; output_47[54] = 103.466; output_47[55] = 103.273; output_47[56] = 102.292; output_47[57] = 101.363; output_47[58] = 100.821; output_47[59] = 100.538; output_47[60] = 100.332; output_47[61] = 0; output_47[62] = 0; output_47[63] = 0;

  uint32_t j = 0;
  for (uint32_t i = 0; i < output->width ; ++i)
    EXPECT_NEAR ((*output) (i,j).intensity, output_0[i], 1e-3);
  j = 47;
  for (uint32_t i = 0; i < output->width ; ++i)
    EXPECT_NEAR ((*output) (i,j).intensity, output_47[i], 1e-3);

  // std::cout << "output size " << output->width << "x" << output->height << std::endl;
  // for(uint32_t j = 0; j < input.height; ++j)
  // {
  //   uint32_t i;
  //   for (i = 0; i < 3; ++i)
  //     EXPECT_EQ ((*output) (i,j).intensity, 0);
  //   for (i = 3; i < 61; ++i)
  //     std::cout << (*output) (i,j).intensity << " ";
  //   for (i = 61; i < 64; ++i)
  //     EXPECT_EQ ((*output) (i,j).intensity, 0);
  //   std::cout << std::endl;
  // }

}

int
main (int argc, char** argv)
{
  filter << 0.00443305, 0.0540056, 0.242036, 0.39905, 0.242036, 0.0540056, 0.00443305;
  input->width = 64;
  input->height = 48;
  input->resize (64 * 48);
  // To avoid linking to pcl_io, set a point cloud 64x48
  (*input) (0,0).intensity = 97;
  (*input) (1,0).intensity = 96;
  (*input) (2,0).intensity = 94;
  (*input) (3,0).intensity = 95;
  (*input) (4,0).intensity = 93;
  (*input) (5,0).intensity = 92;
  (*input) (6,0).intensity = 94;
  (*input) (7,0).intensity = 92;
  (*input) (8,0).intensity = 92;
  (*input) (9,0).intensity = 92;
  (*input) (10,0).intensity = 91;
  (*input) (11,0).intensity = 90;
  (*input) (12,0).intensity = 89;
  (*input) (13,0).intensity = 89;
  (*input) (14,0).intensity = 88;
  (*input) (15,0).intensity = 88;
  (*input) (16,0).intensity = 88;
  (*input) (17,0).intensity = 87;
  (*input) (18,0).intensity = 88;
  (*input) (19,0).intensity = 87;
  (*input) (20,0).intensity = 87;
  (*input) (21,0).intensity = 84;
  (*input) (22,0).intensity = 84;
  (*input) (23,0).intensity = 84;
  (*input) (24,0).intensity = 83;
  (*input) (25,0).intensity = 84;
  (*input) (26,0).intensity = 83;
  (*input) (27,0).intensity = 84;
  (*input) (28,0).intensity = 84;
  (*input) (29,0).intensity = 82;
  (*input) (30,0).intensity = 83;
  (*input) (31,0).intensity = 81;
  (*input) (32,0).intensity = 83;
  (*input) (33,0).intensity = 82;
  (*input) (34,0).intensity = 83;
  (*input) (35,0).intensity = 81;
  (*input) (36,0).intensity = 81;
  (*input) (37,0).intensity = 81;
  (*input) (38,0).intensity = 82;
  (*input) (39,0).intensity = 82;
  (*input) (40,0).intensity = 81;
  (*input) (41,0).intensity = 80;
  (*input) (42,0).intensity = 80;
  (*input) (43,0).intensity = 80;
  (*input) (44,0).intensity = 81;
  (*input) (45,0).intensity = 81;
  (*input) (46,0).intensity = 81;
  (*input) (47,0).intensity = 80;
  (*input) (48,0).intensity = 80;
  (*input) (49,0).intensity = 81;
  (*input) (50,0).intensity = 82;
  (*input) (51,0).intensity = 86;
  (*input) (52,0).intensity = 95;
  (*input) (53,0).intensity = 84;
  (*input) (54,0).intensity = 74;
  (*input) (55,0).intensity = 73;
  (*input) (56,0).intensity = 79;
  (*input) (57,0).intensity = 81;
  (*input) (58,0).intensity = 80;
  (*input) (59,0).intensity = 81;
  (*input) (60,0).intensity = 81;
  (*input) (61,0).intensity = 84;
  (*input) (62,0).intensity = 84;
  (*input) (63,0).intensity = 85;
  (*input) (0,1).intensity = 97;
  (*input) (1,1).intensity = 96;
  (*input) (2,1).intensity = 95;
  (*input) (3,1).intensity = 93;
  (*input) (4,1).intensity = 94;
  (*input) (5,1).intensity = 92;
  (*input) (6,1).intensity = 93;
  (*input) (7,1).intensity = 92;
  (*input) (8,1).intensity = 92;
  (*input) (9,1).intensity = 91;
  (*input) (10,1).intensity = 91;
  (*input) (11,1).intensity = 89;
  (*input) (12,1).intensity = 88;
  (*input) (13,1).intensity = 88;
  (*input) (14,1).intensity = 88;
  (*input) (15,1).intensity = 88;
  (*input) (16,1).intensity = 86;
  (*input) (17,1).intensity = 86;
  (*input) (18,1).intensity = 89;
  (*input) (19,1).intensity = 87;
  (*input) (20,1).intensity = 88;
  (*input) (21,1).intensity = 85;
  (*input) (22,1).intensity = 85;
  (*input) (23,1).intensity = 82;
  (*input) (24,1).intensity = 83;
  (*input) (25,1).intensity = 84;
  (*input) (26,1).intensity = 82;
  (*input) (27,1).intensity = 83;
  (*input) (28,1).intensity = 82;
  (*input) (29,1).intensity = 83;
  (*input) (30,1).intensity = 80;
  (*input) (31,1).intensity = 79;
  (*input) (32,1).intensity = 81;
  (*input) (33,1).intensity = 81;
  (*input) (34,1).intensity = 82;
  (*input) (35,1).intensity = 79;
  (*input) (36,1).intensity = 79;
  (*input) (37,1).intensity = 80;
  (*input) (38,1).intensity = 79;
  (*input) (39,1).intensity = 81;
  (*input) (40,1).intensity = 78;
  (*input) (41,1).intensity = 79;
  (*input) (42,1).intensity = 77;
  (*input) (43,1).intensity = 77;
  (*input) (44,1).intensity = 80;
  (*input) (45,1).intensity = 78;
  (*input) (46,1).intensity = 79;
  (*input) (47,1).intensity = 78;
  (*input) (48,1).intensity = 77;
  (*input) (49,1).intensity = 78;
  (*input) (50,1).intensity = 79;
  (*input) (51,1).intensity = 81;
  (*input) (52,1).intensity = 89;
  (*input) (53,1).intensity = 92;
  (*input) (54,1).intensity = 88;
  (*input) (55,1).intensity = 80;
  (*input) (56,1).intensity = 77;
  (*input) (57,1).intensity = 77;
  (*input) (58,1).intensity = 78;
  (*input) (59,1).intensity = 78;
  (*input) (60,1).intensity = 77;
  (*input) (61,1).intensity = 79;
  (*input) (62,1).intensity = 77;
  (*input) (63,1).intensity = 79;
  (*input) (0,2).intensity = 96;
  (*input) (1,2).intensity = 96;
  (*input) (2,2).intensity = 94;
  (*input) (3,2).intensity = 94;
  (*input) (4,2).intensity = 92;
  (*input) (5,2).intensity = 92;
  (*input) (6,2).intensity = 94;
  (*input) (7,2).intensity = 92;
  (*input) (8,2).intensity = 90;
  (*input) (9,2).intensity = 88;
  (*input) (10,2).intensity = 89;
  (*input) (11,2).intensity = 88;
  (*input) (12,2).intensity = 87;
  (*input) (13,2).intensity = 85;
  (*input) (14,2).intensity = 86;
  (*input) (15,2).intensity = 85;
  (*input) (16,2).intensity = 83;
  (*input) (17,2).intensity = 83;
  (*input) (18,2).intensity = 87;
  (*input) (19,2).intensity = 85;
  (*input) (20,2).intensity = 86;
  (*input) (21,2).intensity = 82;
  (*input) (22,2).intensity = 83;
  (*input) (23,2).intensity = 82;
  (*input) (24,2).intensity = 81;
  (*input) (25,2).intensity = 82;
  (*input) (26,2).intensity = 82;
  (*input) (27,2).intensity = 82;
  (*input) (28,2).intensity = 82;
  (*input) (29,2).intensity = 82;
  (*input) (30,2).intensity = 81;
  (*input) (31,2).intensity = 80;
  (*input) (32,2).intensity = 81;
  (*input) (33,2).intensity = 79;
  (*input) (34,2).intensity = 81;
  (*input) (35,2).intensity = 79;
  (*input) (36,2).intensity = 81;
  (*input) (37,2).intensity = 83;
  (*input) (38,2).intensity = 79;
  (*input) (39,2).intensity = 78;
  (*input) (40,2).intensity = 81;
  (*input) (41,2).intensity = 83;
  (*input) (42,2).intensity = 81;
  (*input) (43,2).intensity = 80;
  (*input) (44,2).intensity = 81;
  (*input) (45,2).intensity = 80;
  (*input) (46,2).intensity = 78;
  (*input) (47,2).intensity = 79;
  (*input) (48,2).intensity = 79;
  (*input) (49,2).intensity = 80;
  (*input) (50,2).intensity = 80;
  (*input) (51,2).intensity = 81;
  (*input) (52,2).intensity = 82;
  (*input) (53,2).intensity = 83;
  (*input) (54,2).intensity = 84;
  (*input) (55,2).intensity = 81;
  (*input) (56,2).intensity = 79;
  (*input) (57,2).intensity = 78;
  (*input) (58,2).intensity = 77;
  (*input) (59,2).intensity = 77;
  (*input) (60,2).intensity = 76;
  (*input) (61,2).intensity = 74;
  (*input) (62,2).intensity = 77;
  (*input) (63,2).intensity = 79;
  (*input) (0,3).intensity = 93;
  (*input) (1,3).intensity = 93;
  (*input) (2,3).intensity = 94;
  (*input) (3,3).intensity = 92;
  (*input) (4,3).intensity = 92;
  (*input) (5,3).intensity = 92;
  (*input) (6,3).intensity = 93;
  (*input) (7,3).intensity = 93;
  (*input) (8,3).intensity = 92;
  (*input) (9,3).intensity = 90;
  (*input) (10,3).intensity = 92;
  (*input) (11,3).intensity = 91;
  (*input) (12,3).intensity = 90;
  (*input) (13,3).intensity = 89;
  (*input) (14,3).intensity = 90;
  (*input) (15,3).intensity = 90;
  (*input) (16,3).intensity = 89;
  (*input) (17,3).intensity = 90;
  (*input) (18,3).intensity = 91;
  (*input) (19,3).intensity = 91;
  (*input) (20,3).intensity = 93;
  (*input) (21,3).intensity = 89;
  (*input) (22,3).intensity = 91;
  (*input) (23,3).intensity = 91;
  (*input) (24,3).intensity = 90;
  (*input) (25,3).intensity = 91;
  (*input) (26,3).intensity = 89;
  (*input) (27,3).intensity = 88;
  (*input) (28,3).intensity = 91;
  (*input) (29,3).intensity = 90;
  (*input) (30,3).intensity = 90;
  (*input) (31,3).intensity = 91;
  (*input) (32,3).intensity = 89;
  (*input) (33,3).intensity = 89;
  (*input) (34,3).intensity = 87;
  (*input) (35,3).intensity = 88;
  (*input) (36,3).intensity = 90;
  (*input) (37,3).intensity = 91;
  (*input) (38,3).intensity = 90;
  (*input) (39,3).intensity = 87;
  (*input) (40,3).intensity = 92;
  (*input) (41,3).intensity = 91;
  (*input) (42,3).intensity = 91;
  (*input) (43,3).intensity = 91;
  (*input) (44,3).intensity = 91;
  (*input) (45,3).intensity = 90;
  (*input) (46,3).intensity = 89;
  (*input) (47,3).intensity = 87;
  (*input) (48,3).intensity = 90;
  (*input) (49,3).intensity = 90;
  (*input) (50,3).intensity = 90;
  (*input) (51,3).intensity = 88;
  (*input) (52,3).intensity = 89;
  (*input) (53,3).intensity = 87;
  (*input) (54,3).intensity = 88;
  (*input) (55,3).intensity = 87;
  (*input) (56,3).intensity = 88;
  (*input) (57,3).intensity = 85;
  (*input) (58,3).intensity = 86;
  (*input) (59,3).intensity = 85;
  (*input) (60,3).intensity = 84;
  (*input) (61,3).intensity = 82;
  (*input) (62,3).intensity = 79;
  (*input) (63,3).intensity = 68;
  (*input) (0,4).intensity = 99;
  (*input) (1,4).intensity = 96;
  (*input) (2,4).intensity = 98;
  (*input) (3,4).intensity = 98;
  (*input) (4,4).intensity = 96;
  (*input) (5,4).intensity = 98;
  (*input) (6,4).intensity = 98;
  (*input) (7,4).intensity = 98;
  (*input) (8,4).intensity = 96;
  (*input) (9,4).intensity = 96;
  (*input) (10,4).intensity = 98;
  (*input) (11,4).intensity = 99;
  (*input) (12,4).intensity = 99;
  (*input) (13,4).intensity = 97;
  (*input) (14,4).intensity = 97;
  (*input) (15,4).intensity = 98;
  (*input) (16,4).intensity = 98;
  (*input) (17,4).intensity = 99;
  (*input) (18,4).intensity = 97;
  (*input) (19,4).intensity = 95;
  (*input) (20,4).intensity = 98;
  (*input) (21,4).intensity = 96;
  (*input) (22,4).intensity = 98;
  (*input) (23,4).intensity = 98;
  (*input) (24,4).intensity = 97;
  (*input) (25,4).intensity = 97;
  (*input) (26,4).intensity = 99;
  (*input) (27,4).intensity = 97;
  (*input) (28,4).intensity = 96;
  (*input) (29,4).intensity = 96;
  (*input) (30,4).intensity = 96;
  (*input) (31,4).intensity = 97;
  (*input) (32,4).intensity = 96;
  (*input) (33,4).intensity = 96;
  (*input) (34,4).intensity = 96;
  (*input) (35,4).intensity = 97;
  (*input) (36,4).intensity = 97;
  (*input) (37,4).intensity = 96;
  (*input) (38,4).intensity = 96;
  (*input) (39,4).intensity = 94;
  (*input) (40,4).intensity = 96;
  (*input) (41,4).intensity = 95;
  (*input) (42,4).intensity = 97;
  (*input) (43,4).intensity = 97;
  (*input) (44,4).intensity = 97;
  (*input) (45,4).intensity = 96;
  (*input) (46,4).intensity = 94;
  (*input) (47,4).intensity = 94;
  (*input) (48,4).intensity = 96;
  (*input) (49,4).intensity = 96;
  (*input) (50,4).intensity = 97;
  (*input) (51,4).intensity = 93;
  (*input) (52,4).intensity = 95;
  (*input) (53,4).intensity = 92;
  (*input) (54,4).intensity = 92;
  (*input) (55,4).intensity = 94;
  (*input) (56,4).intensity = 93;
  (*input) (57,4).intensity = 93;
  (*input) (58,4).intensity = 92;
  (*input) (59,4).intensity = 92;
  (*input) (60,4).intensity = 90;
  (*input) (61,4).intensity = 86;
  (*input) (62,4).intensity = 70;
  (*input) (63,4).intensity = 49;
  (*input) (0,5).intensity = 95;
  (*input) (1,5).intensity = 93;
  (*input) (2,5).intensity = 93;
  (*input) (3,5).intensity = 94;
  (*input) (4,5).intensity = 93;
  (*input) (5,5).intensity = 94;
  (*input) (6,5).intensity = 93;
  (*input) (7,5).intensity = 92;
  (*input) (8,5).intensity = 93;
  (*input) (9,5).intensity = 93;
  (*input) (10,5).intensity = 90;
  (*input) (11,5).intensity = 92;
  (*input) (12,5).intensity = 89;
  (*input) (13,5).intensity = 90;
  (*input) (14,5).intensity = 89;
  (*input) (15,5).intensity = 89;
  (*input) (16,5).intensity = 90;
  (*input) (17,5).intensity = 90;
  (*input) (18,5).intensity = 88;
  (*input) (19,5).intensity = 86;
  (*input) (20,5).intensity = 87;
  (*input) (21,5).intensity = 89;
  (*input) (22,5).intensity = 88;
  (*input) (23,5).intensity = 89;
  (*input) (24,5).intensity = 88;
  (*input) (25,5).intensity = 90;
  (*input) (26,5).intensity = 91;
  (*input) (27,5).intensity = 89;
  (*input) (28,5).intensity = 87;
  (*input) (29,5).intensity = 87;
  (*input) (30,5).intensity = 89;
  (*input) (31,5).intensity = 87;
  (*input) (32,5).intensity = 89;
  (*input) (33,5).intensity = 89;
  (*input) (34,5).intensity = 88;
  (*input) (35,5).intensity = 92;
  (*input) (36,5).intensity = 92;
  (*input) (37,5).intensity = 90;
  (*input) (38,5).intensity = 91;
  (*input) (39,5).intensity = 90;
  (*input) (40,5).intensity = 91;
  (*input) (41,5).intensity = 87;
  (*input) (42,5).intensity = 91;
  (*input) (43,5).intensity = 91;
  (*input) (44,5).intensity = 91;
  (*input) (45,5).intensity = 91;
  (*input) (46,5).intensity = 90;
  (*input) (47,5).intensity = 92;
  (*input) (48,5).intensity = 91;
  (*input) (49,5).intensity = 91;
  (*input) (50,5).intensity = 91;
  (*input) (51,5).intensity = 90;
  (*input) (52,5).intensity = 90;
  (*input) (53,5).intensity = 88;
  (*input) (54,5).intensity = 86;
  (*input) (55,5).intensity = 91;
  (*input) (56,5).intensity = 89;
  (*input) (57,5).intensity = 89;
  (*input) (58,5).intensity = 90;
  (*input) (59,5).intensity = 88;
  (*input) (60,5).intensity = 86;
  (*input) (61,5).intensity = 80;
  (*input) (62,5).intensity = 64;
  (*input) (63,5).intensity = 46;
  (*input) (0,6).intensity = 93;
  (*input) (1,6).intensity = 90;
  (*input) (2,6).intensity = 91;
  (*input) (3,6).intensity = 91;
  (*input) (4,6).intensity = 93;
  (*input) (5,6).intensity = 92;
  (*input) (6,6).intensity = 91;
  (*input) (7,6).intensity = 90;
  (*input) (8,6).intensity = 90;
  (*input) (9,6).intensity = 90;
  (*input) (10,6).intensity = 88;
  (*input) (11,6).intensity = 90;
  (*input) (12,6).intensity = 89;
  (*input) (13,6).intensity = 89;
  (*input) (14,6).intensity = 85;
  (*input) (15,6).intensity = 87;
  (*input) (16,6).intensity = 89;
  (*input) (17,6).intensity = 87;
  (*input) (18,6).intensity = 88;
  (*input) (19,6).intensity = 86;
  (*input) (20,6).intensity = 85;
  (*input) (21,6).intensity = 87;
  (*input) (22,6).intensity = 87;
  (*input) (23,6).intensity = 87;
  (*input) (24,6).intensity = 86;
  (*input) (25,6).intensity = 87;
  (*input) (26,6).intensity = 87;
  (*input) (27,6).intensity = 88;
  (*input) (28,6).intensity = 85;
  (*input) (29,6).intensity = 86;
  (*input) (30,6).intensity = 85;
  (*input) (31,6).intensity = 83;
  (*input) (32,6).intensity = 86;
  (*input) (33,6).intensity = 87;
  (*input) (34,6).intensity = 85;
  (*input) (35,6).intensity = 86;
  (*input) (36,6).intensity = 87;
  (*input) (37,6).intensity = 85;
  (*input) (38,6).intensity = 86;
  (*input) (39,6).intensity = 85;
  (*input) (40,6).intensity = 85;
  (*input) (41,6).intensity = 84;
  (*input) (42,6).intensity = 85;
  (*input) (43,6).intensity = 85;
  (*input) (44,6).intensity = 84;
  (*input) (45,6).intensity = 84;
  (*input) (46,6).intensity = 85;
  (*input) (47,6).intensity = 84;
  (*input) (48,6).intensity = 82;
  (*input) (49,6).intensity = 84;
  (*input) (50,6).intensity = 85;
  (*input) (51,6).intensity = 83;
  (*input) (52,6).intensity = 84;
  (*input) (53,6).intensity = 83;
  (*input) (54,6).intensity = 82;
  (*input) (55,6).intensity = 85;
  (*input) (56,6).intensity = 83;
  (*input) (57,6).intensity = 82;
  (*input) (58,6).intensity = 82;
  (*input) (59,6).intensity = 83;
  (*input) (60,6).intensity = 80;
  (*input) (61,6).intensity = 77;
  (*input) (62,6).intensity = 62;
  (*input) (63,6).intensity = 52;
  (*input) (0,7).intensity = 91;
  (*input) (1,7).intensity = 88;
  (*input) (2,7).intensity = 86;
  (*input) (3,7).intensity = 87;
  (*input) (4,7).intensity = 90;
  (*input) (5,7).intensity = 87;
  (*input) (6,7).intensity = 86;
  (*input) (7,7).intensity = 84;
  (*input) (8,7).intensity = 82;
  (*input) (9,7).intensity = 82;
  (*input) (10,7).intensity = 79;
  (*input) (11,7).intensity = 80;
  (*input) (12,7).intensity = 79;
  (*input) (13,7).intensity = 81;
  (*input) (14,7).intensity = 75;
  (*input) (15,7).intensity = 75;
  (*input) (16,7).intensity = 77;
  (*input) (17,7).intensity = 75;
  (*input) (18,7).intensity = 77;
  (*input) (19,7).intensity = 77;
  (*input) (20,7).intensity = 74;
  (*input) (21,7).intensity = 74;
  (*input) (22,7).intensity = 75;
  (*input) (23,7).intensity = 75;
  (*input) (24,7).intensity = 75;
  (*input) (25,7).intensity = 75;
  (*input) (26,7).intensity = 74;
  (*input) (27,7).intensity = 75;
  (*input) (28,7).intensity = 76;
  (*input) (29,7).intensity = 76;
  (*input) (30,7).intensity = 76;
  (*input) (31,7).intensity = 76;
  (*input) (32,7).intensity = 76;
  (*input) (33,7).intensity = 74;
  (*input) (34,7).intensity = 75;
  (*input) (35,7).intensity = 76;
  (*input) (36,7).intensity = 78;
  (*input) (37,7).intensity = 77;
  (*input) (38,7).intensity = 76;
  (*input) (39,7).intensity = 74;
  (*input) (40,7).intensity = 76;
  (*input) (41,7).intensity = 76;
  (*input) (42,7).intensity = 76;
  (*input) (43,7).intensity = 75;
  (*input) (44,7).intensity = 76;
  (*input) (45,7).intensity = 74;
  (*input) (46,7).intensity = 75;
  (*input) (47,7).intensity = 75;
  (*input) (48,7).intensity = 73;
  (*input) (49,7).intensity = 75;
  (*input) (50,7).intensity = 74;
  (*input) (51,7).intensity = 75;
  (*input) (52,7).intensity = 75;
  (*input) (53,7).intensity = 73;
  (*input) (54,7).intensity = 74;
  (*input) (55,7).intensity = 74;
  (*input) (56,7).intensity = 74;
  (*input) (57,7).intensity = 73;
  (*input) (58,7).intensity = 73;
  (*input) (59,7).intensity = 74;
  (*input) (60,7).intensity = 73;
  (*input) (61,7).intensity = 73;
  (*input) (62,7).intensity = 74;
  (*input) (63,7).intensity = 67;
  (*input) (0,8).intensity = 86;
  (*input) (1,8).intensity = 87;
  (*input) (2,8).intensity = 85;
  (*input) (3,8).intensity = 84;
  (*input) (4,8).intensity = 87;
  (*input) (5,8).intensity = 87;
  (*input) (6,8).intensity = 86;
  (*input) (7,8).intensity = 83;
  (*input) (8,8).intensity = 83;
  (*input) (9,8).intensity = 79;
  (*input) (10,8).intensity = 82;
  (*input) (11,8).intensity = 82;
  (*input) (12,8).intensity = 84;
  (*input) (13,8).intensity = 83;
  (*input) (14,8).intensity = 78;
  (*input) (15,8).intensity = 79;
  (*input) (16,8).intensity = 80;
  (*input) (17,8).intensity = 82;
  (*input) (18,8).intensity = 83;
  (*input) (19,8).intensity = 84;
  (*input) (20,8).intensity = 84;
  (*input) (21,8).intensity = 80;
  (*input) (22,8).intensity = 84;
  (*input) (23,8).intensity = 84;
  (*input) (24,8).intensity = 83;
  (*input) (25,8).intensity = 82;
  (*input) (26,8).intensity = 80;
  (*input) (27,8).intensity = 82;
  (*input) (28,8).intensity = 84;
  (*input) (29,8).intensity = 83;
  (*input) (30,8).intensity = 83;
  (*input) (31,8).intensity = 84;
  (*input) (32,8).intensity = 83;
  (*input) (33,8).intensity = 83;
  (*input) (34,8).intensity = 83;
  (*input) (35,8).intensity = 80;
  (*input) (36,8).intensity = 81;
  (*input) (37,8).intensity = 83;
  (*input) (38,8).intensity = 81;
  (*input) (39,8).intensity = 81;
  (*input) (40,8).intensity = 82;
  (*input) (41,8).intensity = 81;
  (*input) (42,8).intensity = 82;
  (*input) (43,8).intensity = 81;
  (*input) (44,8).intensity = 81;
  (*input) (45,8).intensity = 80;
  (*input) (46,8).intensity = 81;
  (*input) (47,8).intensity = 80;
  (*input) (48,8).intensity = 80;
  (*input) (49,8).intensity = 79;
  (*input) (50,8).intensity = 80;
  (*input) (51,8).intensity = 77;
  (*input) (52,8).intensity = 79;
  (*input) (53,8).intensity = 80;
  (*input) (54,8).intensity = 79;
  (*input) (55,8).intensity = 79;
  (*input) (56,8).intensity = 78;
  (*input) (57,8).intensity = 76;
  (*input) (58,8).intensity = 76;
  (*input) (59,8).intensity = 77;
  (*input) (60,8).intensity = 75;
  (*input) (61,8).intensity = 76;
  (*input) (62,8).intensity = 75;
  (*input) (63,8).intensity = 58;
  (*input) (0,9).intensity = 93;
  (*input) (1,9).intensity = 93;
  (*input) (2,9).intensity = 92;
  (*input) (3,9).intensity = 91;
  (*input) (4,9).intensity = 92;
  (*input) (5,9).intensity = 92;
  (*input) (6,9).intensity = 89;
  (*input) (7,9).intensity = 87;
  (*input) (8,9).intensity = 88;
  (*input) (9,9).intensity = 83;
  (*input) (10,9).intensity = 85;
  (*input) (11,9).intensity = 86;
  (*input) (12,9).intensity = 90;
  (*input) (13,9).intensity = 89;
  (*input) (14,9).intensity = 84;
  (*input) (15,9).intensity = 87;
  (*input) (16,9).intensity = 85;
  (*input) (17,9).intensity = 87;
  (*input) (18,9).intensity = 89;
  (*input) (19,9).intensity = 89;
  (*input) (20,9).intensity = 89;
  (*input) (21,9).intensity = 86;
  (*input) (22,9).intensity = 89;
  (*input) (23,9).intensity = 90;
  (*input) (24,9).intensity = 87;
  (*input) (25,9).intensity = 89;
  (*input) (26,9).intensity = 85;
  (*input) (27,9).intensity = 87;
  (*input) (28,9).intensity = 87;
  (*input) (29,9).intensity = 86;
  (*input) (30,9).intensity = 87;
  (*input) (31,9).intensity = 88;
  (*input) (32,9).intensity = 86;
  (*input) (33,9).intensity = 86;
  (*input) (34,9).intensity = 87;
  (*input) (35,9).intensity = 87;
  (*input) (36,9).intensity = 86;
  (*input) (37,9).intensity = 85;
  (*input) (38,9).intensity = 84;
  (*input) (39,9).intensity = 84;
  (*input) (40,9).intensity = 83;
  (*input) (41,9).intensity = 84;
  (*input) (42,9).intensity = 85;
  (*input) (43,9).intensity = 85;
  (*input) (44,9).intensity = 84;
  (*input) (45,9).intensity = 82;
  (*input) (46,9).intensity = 80;
  (*input) (47,9).intensity = 82;
  (*input) (48,9).intensity = 82;
  (*input) (49,9).intensity = 81;
  (*input) (50,9).intensity = 82;
  (*input) (51,9).intensity = 78;
  (*input) (52,9).intensity = 78;
  (*input) (53,9).intensity = 82;
  (*input) (54,9).intensity = 81;
  (*input) (55,9).intensity = 79;
  (*input) (56,9).intensity = 79;
  (*input) (57,9).intensity = 76;
  (*input) (58,9).intensity = 76;
  (*input) (59,9).intensity = 77;
  (*input) (60,9).intensity = 76;
  (*input) (61,9).intensity = 66;
  (*input) (62,9).intensity = 48;
  (*input) (63,9).intensity = 33;
  (*input) (0,10).intensity = 96;
  (*input) (1,10).intensity = 97;
  (*input) (2,10).intensity = 94;
  (*input) (3,10).intensity = 95;
  (*input) (4,10).intensity = 93;
  (*input) (5,10).intensity = 92;
  (*input) (6,10).intensity = 89;
  (*input) (7,10).intensity = 88;
  (*input) (8,10).intensity = 90;
  (*input) (9,10).intensity = 85;
  (*input) (10,10).intensity = 87;
  (*input) (11,10).intensity = 88;
  (*input) (12,10).intensity = 90;
  (*input) (13,10).intensity = 89;
  (*input) (14,10).intensity = 88;
  (*input) (15,10).intensity = 88;
  (*input) (16,10).intensity = 88;
  (*input) (17,10).intensity = 89;
  (*input) (18,10).intensity = 88;
  (*input) (19,10).intensity = 88;
  (*input) (20,10).intensity = 88;
  (*input) (21,10).intensity = 87;
  (*input) (22,10).intensity = 88;
  (*input) (23,10).intensity = 87;
  (*input) (24,10).intensity = 88;
  (*input) (25,10).intensity = 88;
  (*input) (26,10).intensity = 85;
  (*input) (27,10).intensity = 88;
  (*input) (28,10).intensity = 86;
  (*input) (29,10).intensity = 85;
  (*input) (30,10).intensity = 87;
  (*input) (31,10).intensity = 86;
  (*input) (32,10).intensity = 83;
  (*input) (33,10).intensity = 84;
  (*input) (34,10).intensity = 86;
  (*input) (35,10).intensity = 85;
  (*input) (36,10).intensity = 85;
  (*input) (37,10).intensity = 84;
  (*input) (38,10).intensity = 82;
  (*input) (39,10).intensity = 83;
  (*input) (40,10).intensity = 83;
  (*input) (41,10).intensity = 83;
  (*input) (42,10).intensity = 83;
  (*input) (43,10).intensity = 83;
  (*input) (44,10).intensity = 84;
  (*input) (45,10).intensity = 81;
  (*input) (46,10).intensity = 80;
  (*input) (47,10).intensity = 81;
  (*input) (48,10).intensity = 82;
  (*input) (49,10).intensity = 81;
  (*input) (50,10).intensity = 81;
  (*input) (51,10).intensity = 79;
  (*input) (52,10).intensity = 79;
  (*input) (53,10).intensity = 81;
  (*input) (54,10).intensity = 80;
  (*input) (55,10).intensity = 80;
  (*input) (56,10).intensity = 79;
  (*input) (57,10).intensity = 75;
  (*input) (58,10).intensity = 75;
  (*input) (59,10).intensity = 77;
  (*input) (60,10).intensity = 74;
  (*input) (61,10).intensity = 50;
  (*input) (62,10).intensity = 31;
  (*input) (63,10).intensity = 19;
  (*input) (0,11).intensity = 97;
  (*input) (1,11).intensity = 97;
  (*input) (2,11).intensity = 97;
  (*input) (3,11).intensity = 96;
  (*input) (4,11).intensity = 94;
  (*input) (5,11).intensity = 91;
  (*input) (6,11).intensity = 90;
  (*input) (7,11).intensity = 90;
  (*input) (8,11).intensity = 92;
  (*input) (9,11).intensity = 89;
  (*input) (10,11).intensity = 90;
  (*input) (11,11).intensity = 89;
  (*input) (12,11).intensity = 90;
  (*input) (13,11).intensity = 91;
  (*input) (14,11).intensity = 91;
  (*input) (15,11).intensity = 92;
  (*input) (16,11).intensity = 90;
  (*input) (17,11).intensity = 89;
  (*input) (18,11).intensity = 89;
  (*input) (19,11).intensity = 89;
  (*input) (20,11).intensity = 89;
  (*input) (21,11).intensity = 89;
  (*input) (22,11).intensity = 89;
  (*input) (23,11).intensity = 87;
  (*input) (24,11).intensity = 88;
  (*input) (25,11).intensity = 87;
  (*input) (26,11).intensity = 87;
  (*input) (27,11).intensity = 88;
  (*input) (28,11).intensity = 87;
  (*input) (29,11).intensity = 85;
  (*input) (30,11).intensity = 87;
  (*input) (31,11).intensity = 85;
  (*input) (32,11).intensity = 84;
  (*input) (33,11).intensity = 83;
  (*input) (34,11).intensity = 85;
  (*input) (35,11).intensity = 85;
  (*input) (36,11).intensity = 85;
  (*input) (37,11).intensity = 83;
  (*input) (38,11).intensity = 82;
  (*input) (39,11).intensity = 83;
  (*input) (40,11).intensity = 82;
  (*input) (41,11).intensity = 83;
  (*input) (42,11).intensity = 84;
  (*input) (43,11).intensity = 83;
  (*input) (44,11).intensity = 83;
  (*input) (45,11).intensity = 81;
  (*input) (46,11).intensity = 80;
  (*input) (47,11).intensity = 80;
  (*input) (48,11).intensity = 81;
  (*input) (49,11).intensity = 82;
  (*input) (50,11).intensity = 80;
  (*input) (51,11).intensity = 79;
  (*input) (52,11).intensity = 79;
  (*input) (53,11).intensity = 80;
  (*input) (54,11).intensity = 80;
  (*input) (55,11).intensity = 79;
  (*input) (56,11).intensity = 79;
  (*input) (57,11).intensity = 75;
  (*input) (58,11).intensity = 75;
  (*input) (59,11).intensity = 79;
  (*input) (60,11).intensity = 76;
  (*input) (61,11).intensity = 43;
  (*input) (62,11).intensity = 32;
  (*input) (63,11).intensity = 24;
  (*input) (0,12).intensity = 98;
  (*input) (1,12).intensity = 98;
  (*input) (2,12).intensity = 98;
  (*input) (3,12).intensity = 97;
  (*input) (4,12).intensity = 96;
  (*input) (5,12).intensity = 93;
  (*input) (6,12).intensity = 94;
  (*input) (7,12).intensity = 94;
  (*input) (8,12).intensity = 93;
  (*input) (9,12).intensity = 92;
  (*input) (10,12).intensity = 92;
  (*input) (11,12).intensity = 91;
  (*input) (12,12).intensity = 91;
  (*input) (13,12).intensity = 92;
  (*input) (14,12).intensity = 93;
  (*input) (15,12).intensity = 91;
  (*input) (16,12).intensity = 92;
  (*input) (17,12).intensity = 92;
  (*input) (18,12).intensity = 90;
  (*input) (19,12).intensity = 90;
  (*input) (20,12).intensity = 90;
  (*input) (21,12).intensity = 90;
  (*input) (22,12).intensity = 89;
  (*input) (23,12).intensity = 87;
  (*input) (24,12).intensity = 89;
  (*input) (25,12).intensity = 88;
  (*input) (26,12).intensity = 88;
  (*input) (27,12).intensity = 89;
  (*input) (28,12).intensity = 88;
  (*input) (29,12).intensity = 86;
  (*input) (30,12).intensity = 86;
  (*input) (31,12).intensity = 87;
  (*input) (32,12).intensity = 85;
  (*input) (33,12).intensity = 84;
  (*input) (34,12).intensity = 85;
  (*input) (35,12).intensity = 84;
  (*input) (36,12).intensity = 85;
  (*input) (37,12).intensity = 83;
  (*input) (38,12).intensity = 83;
  (*input) (39,12).intensity = 82;
  (*input) (40,12).intensity = 82;
  (*input) (41,12).intensity = 83;
  (*input) (42,12).intensity = 83;
  (*input) (43,12).intensity = 82;
  (*input) (44,12).intensity = 84;
  (*input) (45,12).intensity = 81;
  (*input) (46,12).intensity = 81;
  (*input) (47,12).intensity = 80;
  (*input) (48,12).intensity = 81;
  (*input) (49,12).intensity = 81;
  (*input) (50,12).intensity = 81;
  (*input) (51,12).intensity = 80;
  (*input) (52,12).intensity = 80;
  (*input) (53,12).intensity = 81;
  (*input) (54,12).intensity = 80;
  (*input) (55,12).intensity = 80;
  (*input) (56,12).intensity = 81;
  (*input) (57,12).intensity = 78;
  (*input) (58,12).intensity = 80;
  (*input) (59,12).intensity = 83;
  (*input) (60,12).intensity = 68;
  (*input) (61,12).intensity = 48;
  (*input) (62,12).intensity = 49;
  (*input) (63,12).intensity = 51;
  (*input) (0,13).intensity = 102;
  (*input) (1,13).intensity = 98;
  (*input) (2,13).intensity = 98;
  (*input) (3,13).intensity = 97;
  (*input) (4,13).intensity = 97;
  (*input) (5,13).intensity = 93;
  (*input) (6,13).intensity = 96;
  (*input) (7,13).intensity = 97;
  (*input) (8,13).intensity = 94;
  (*input) (9,13).intensity = 94;
  (*input) (10,13).intensity = 95;
  (*input) (11,13).intensity = 93;
  (*input) (12,13).intensity = 92;
  (*input) (13,13).intensity = 94;
  (*input) (14,13).intensity = 95;
  (*input) (15,13).intensity = 90;
  (*input) (16,13).intensity = 93;
  (*input) (17,13).intensity = 93;
  (*input) (18,13).intensity = 91;
  (*input) (19,13).intensity = 90;
  (*input) (20,13).intensity = 90;
  (*input) (21,13).intensity = 90;
  (*input) (22,13).intensity = 89;
  (*input) (23,13).intensity = 88;
  (*input) (24,13).intensity = 90;
  (*input) (25,13).intensity = 88;
  (*input) (26,13).intensity = 90;
  (*input) (27,13).intensity = 89;
  (*input) (28,13).intensity = 89;
  (*input) (29,13).intensity = 87;
  (*input) (30,13).intensity = 86;
  (*input) (31,13).intensity = 87;
  (*input) (32,13).intensity = 87;
  (*input) (33,13).intensity = 85;
  (*input) (34,13).intensity = 85;
  (*input) (35,13).intensity = 84;
  (*input) (36,13).intensity = 85;
  (*input) (37,13).intensity = 84;
  (*input) (38,13).intensity = 85;
  (*input) (39,13).intensity = 82;
  (*input) (40,13).intensity = 82;
  (*input) (41,13).intensity = 83;
  (*input) (42,13).intensity = 83;
  (*input) (43,13).intensity = 82;
  (*input) (44,13).intensity = 84;
  (*input) (45,13).intensity = 83;
  (*input) (46,13).intensity = 82;
  (*input) (47,13).intensity = 80;
  (*input) (48,13).intensity = 81;
  (*input) (49,13).intensity = 81;
  (*input) (50,13).intensity = 81;
  (*input) (51,13).intensity = 81;
  (*input) (52,13).intensity = 81;
  (*input) (53,13).intensity = 82;
  (*input) (54,13).intensity = 80;
  (*input) (55,13).intensity = 81;
  (*input) (56,13).intensity = 81;
  (*input) (57,13).intensity = 81;
  (*input) (58,13).intensity = 86;
  (*input) (59,13).intensity = 81;
  (*input) (60,13).intensity = 53;
  (*input) (61,13).intensity = 57;
  (*input) (62,13).intensity = 115;
  (*input) (63,13).intensity = 116;
  (*input) (0,14).intensity = 101;
  (*input) (1,14).intensity = 99;
  (*input) (2,14).intensity = 98;
  (*input) (3,14).intensity = 99;
  (*input) (4,14).intensity = 98;
  (*input) (5,14).intensity = 98;
  (*input) (6,14).intensity = 99;
  (*input) (7,14).intensity = 98;
  (*input) (8,14).intensity = 95;
  (*input) (9,14).intensity = 95;
  (*input) (10,14).intensity = 95;
  (*input) (11,14).intensity = 94;
  (*input) (12,14).intensity = 93;
  (*input) (13,14).intensity = 93;
  (*input) (14,14).intensity = 94;
  (*input) (15,14).intensity = 91;
  (*input) (16,14).intensity = 92;
  (*input) (17,14).intensity = 94;
  (*input) (18,14).intensity = 92;
  (*input) (19,14).intensity = 89;
  (*input) (20,14).intensity = 90;
  (*input) (21,14).intensity = 92;
  (*input) (22,14).intensity = 91;
  (*input) (23,14).intensity = 91;
  (*input) (24,14).intensity = 91;
  (*input) (25,14).intensity = 90;
  (*input) (26,14).intensity = 90;
  (*input) (27,14).intensity = 90;
  (*input) (28,14).intensity = 89;
  (*input) (29,14).intensity = 88;
  (*input) (30,14).intensity = 88;
  (*input) (31,14).intensity = 89;
  (*input) (32,14).intensity = 88;
  (*input) (33,14).intensity = 88;
  (*input) (34,14).intensity = 88;
  (*input) (35,14).intensity = 85;
  (*input) (36,14).intensity = 87;
  (*input) (37,14).intensity = 86;
  (*input) (38,14).intensity = 86;
  (*input) (39,14).intensity = 84;
  (*input) (40,14).intensity = 83;
  (*input) (41,14).intensity = 83;
  (*input) (42,14).intensity = 84;
  (*input) (43,14).intensity = 83;
  (*input) (44,14).intensity = 86;
  (*input) (45,14).intensity = 85;
  (*input) (46,14).intensity = 83;
  (*input) (47,14).intensity = 82;
  (*input) (48,14).intensity = 83;
  (*input) (49,14).intensity = 81;
  (*input) (50,14).intensity = 84;
  (*input) (51,14).intensity = 82;
  (*input) (52,14).intensity = 81;
  (*input) (53,14).intensity = 83;
  (*input) (54,14).intensity = 82;
  (*input) (55,14).intensity = 83;
  (*input) (56,14).intensity = 83;
  (*input) (57,14).intensity = 84;
  (*input) (58,14).intensity = 86;
  (*input) (59,14).intensity = 75;
  (*input) (60,14).intensity = 34;
  (*input) (61,14).intensity = 50;
  (*input) (62,14).intensity = 126;
  (*input) (63,14).intensity = 143;
  (*input) (0,15).intensity = 102;
  (*input) (1,15).intensity = 100;
  (*input) (2,15).intensity = 99;
  (*input) (3,15).intensity = 100;
  (*input) (4,15).intensity = 99;
  (*input) (5,15).intensity = 99;
  (*input) (6,15).intensity = 100;
  (*input) (7,15).intensity = 98;
  (*input) (8,15).intensity = 98;
  (*input) (9,15).intensity = 97;
  (*input) (10,15).intensity = 95;
  (*input) (11,15).intensity = 96;
  (*input) (12,15).intensity = 94;
  (*input) (13,15).intensity = 96;
  (*input) (14,15).intensity = 95;
  (*input) (15,15).intensity = 93;
  (*input) (16,15).intensity = 93;
  (*input) (17,15).intensity = 93;
  (*input) (18,15).intensity = 93;
  (*input) (19,15).intensity = 90;
  (*input) (20,15).intensity = 92;
  (*input) (21,15).intensity = 92;
  (*input) (22,15).intensity = 93;
  (*input) (23,15).intensity = 93;
  (*input) (24,15).intensity = 92;
  (*input) (25,15).intensity = 90;
  (*input) (26,15).intensity = 91;
  (*input) (27,15).intensity = 91;
  (*input) (28,15).intensity = 89;
  (*input) (29,15).intensity = 89;
  (*input) (30,15).intensity = 90;
  (*input) (31,15).intensity = 89;
  (*input) (32,15).intensity = 89;
  (*input) (33,15).intensity = 89;
  (*input) (34,15).intensity = 89;
  (*input) (35,15).intensity = 86;
  (*input) (36,15).intensity = 88;
  (*input) (37,15).intensity = 87;
  (*input) (38,15).intensity = 88;
  (*input) (39,15).intensity = 86;
  (*input) (40,15).intensity = 85;
  (*input) (41,15).intensity = 84;
  (*input) (42,15).intensity = 85;
  (*input) (43,15).intensity = 83;
  (*input) (44,15).intensity = 87;
  (*input) (45,15).intensity = 86;
  (*input) (46,15).intensity = 84;
  (*input) (47,15).intensity = 84;
  (*input) (48,15).intensity = 85;
  (*input) (49,15).intensity = 83;
  (*input) (50,15).intensity = 85;
  (*input) (51,15).intensity = 84;
  (*input) (52,15).intensity = 83;
  (*input) (53,15).intensity = 85;
  (*input) (54,15).intensity = 83;
  (*input) (55,15).intensity = 85;
  (*input) (56,15).intensity = 84;
  (*input) (57,15).intensity = 86;
  (*input) (58,15).intensity = 88;
  (*input) (59,15).intensity = 68;
  (*input) (60,15).intensity = 33;
  (*input) (61,15).intensity = 51;
  (*input) (62,15).intensity = 119;
  (*input) (63,15).intensity = 144;
  (*input) (0,16).intensity = 102;
  (*input) (1,16).intensity = 101;
  (*input) (2,16).intensity = 100;
  (*input) (3,16).intensity = 101;
  (*input) (4,16).intensity = 100;
  (*input) (5,16).intensity = 100;
  (*input) (6,16).intensity = 99;
  (*input) (7,16).intensity = 98;
  (*input) (8,16).intensity = 98;
  (*input) (9,16).intensity = 97;
  (*input) (10,16).intensity = 96;
  (*input) (11,16).intensity = 96;
  (*input) (12,16).intensity = 95;
  (*input) (13,16).intensity = 96;
  (*input) (14,16).intensity = 94;
  (*input) (15,16).intensity = 94;
  (*input) (16,16).intensity = 93;
  (*input) (17,16).intensity = 94;
  (*input) (18,16).intensity = 93;
  (*input) (19,16).intensity = 91;
  (*input) (20,16).intensity = 92;
  (*input) (21,16).intensity = 92;
  (*input) (22,16).intensity = 95;
  (*input) (23,16).intensity = 93;
  (*input) (24,16).intensity = 92;
  (*input) (25,16).intensity = 91;
  (*input) (26,16).intensity = 92;
  (*input) (27,16).intensity = 91;
  (*input) (28,16).intensity = 91;
  (*input) (29,16).intensity = 91;
  (*input) (30,16).intensity = 92;
  (*input) (31,16).intensity = 90;
  (*input) (32,16).intensity = 89;
  (*input) (33,16).intensity = 90;
  (*input) (34,16).intensity = 89;
  (*input) (35,16).intensity = 88;
  (*input) (36,16).intensity = 90;
  (*input) (37,16).intensity = 88;
  (*input) (38,16).intensity = 88;
  (*input) (39,16).intensity = 88;
  (*input) (40,16).intensity = 87;
  (*input) (41,16).intensity = 85;
  (*input) (42,16).intensity = 88;
  (*input) (43,16).intensity = 85;
  (*input) (44,16).intensity = 87;
  (*input) (45,16).intensity = 87;
  (*input) (46,16).intensity = 86;
  (*input) (47,16).intensity = 86;
  (*input) (48,16).intensity = 87;
  (*input) (49,16).intensity = 85;
  (*input) (50,16).intensity = 86;
  (*input) (51,16).intensity = 86;
  (*input) (52,16).intensity = 84;
  (*input) (53,16).intensity = 86;
  (*input) (54,16).intensity = 86;
  (*input) (55,16).intensity = 85;
  (*input) (56,16).intensity = 86;
  (*input) (57,16).intensity = 86;
  (*input) (58,16).intensity = 89;
  (*input) (59,16).intensity = 72;
  (*input) (60,16).intensity = 47;
  (*input) (61,16).intensity = 48;
  (*input) (62,16).intensity = 76;
  (*input) (63,16).intensity = 120;
  (*input) (0,17).intensity = 102;
  (*input) (1,17).intensity = 102;
  (*input) (2,17).intensity = 101;
  (*input) (3,17).intensity = 100;
  (*input) (4,17).intensity = 101;
  (*input) (5,17).intensity = 100;
  (*input) (6,17).intensity = 99;
  (*input) (7,17).intensity = 99;
  (*input) (8,17).intensity = 99;
  (*input) (9,17).intensity = 98;
  (*input) (10,17).intensity = 96;
  (*input) (11,17).intensity = 97;
  (*input) (12,17).intensity = 97;
  (*input) (13,17).intensity = 98;
  (*input) (14,17).intensity = 97;
  (*input) (15,17).intensity = 96;
  (*input) (16,17).intensity = 95;
  (*input) (17,17).intensity = 94;
  (*input) (18,17).intensity = 94;
  (*input) (19,17).intensity = 93;
  (*input) (20,17).intensity = 95;
  (*input) (21,17).intensity = 94;
  (*input) (22,17).intensity = 94;
  (*input) (23,17).intensity = 94;
  (*input) (24,17).intensity = 92;
  (*input) (25,17).intensity = 92;
  (*input) (26,17).intensity = 92;
  (*input) (27,17).intensity = 92;
  (*input) (28,17).intensity = 91;
  (*input) (29,17).intensity = 92;
  (*input) (30,17).intensity = 94;
  (*input) (31,17).intensity = 90;
  (*input) (32,17).intensity = 90;
  (*input) (33,17).intensity = 90;
  (*input) (34,17).intensity = 89;
  (*input) (35,17).intensity = 89;
  (*input) (36,17).intensity = 90;
  (*input) (37,17).intensity = 89;
  (*input) (38,17).intensity = 89;
  (*input) (39,17).intensity = 89;
  (*input) (40,17).intensity = 89;
  (*input) (41,17).intensity = 87;
  (*input) (42,17).intensity = 88;
  (*input) (43,17).intensity = 86;
  (*input) (44,17).intensity = 88;
  (*input) (45,17).intensity = 88;
  (*input) (46,17).intensity = 88;
  (*input) (47,17).intensity = 88;
  (*input) (48,17).intensity = 90;
  (*input) (49,17).intensity = 87;
  (*input) (50,17).intensity = 88;
  (*input) (51,17).intensity = 88;
  (*input) (52,17).intensity = 88;
  (*input) (53,17).intensity = 87;
  (*input) (54,17).intensity = 88;
  (*input) (55,17).intensity = 87;
  (*input) (56,17).intensity = 89;
  (*input) (57,17).intensity = 89;
  (*input) (58,17).intensity = 89;
  (*input) (59,17).intensity = 84;
  (*input) (60,17).intensity = 65;
  (*input) (61,17).intensity = 56;
  (*input) (62,17).intensity = 64;
  (*input) (63,17).intensity = 98;
  (*input) (0,18).intensity = 102;
  (*input) (1,18).intensity = 102;
  (*input) (2,18).intensity = 103;
  (*input) (3,18).intensity = 101;
  (*input) (4,18).intensity = 103;
  (*input) (5,18).intensity = 102;
  (*input) (6,18).intensity = 99;
  (*input) (7,18).intensity = 100;
  (*input) (8,18).intensity = 100;
  (*input) (9,18).intensity = 99;
  (*input) (10,18).intensity = 98;
  (*input) (11,18).intensity = 97;
  (*input) (12,18).intensity = 98;
  (*input) (13,18).intensity = 97;
  (*input) (14,18).intensity = 98;
  (*input) (15,18).intensity = 97;
  (*input) (16,18).intensity = 96;
  (*input) (17,18).intensity = 96;
  (*input) (18,18).intensity = 96;
  (*input) (19,18).intensity = 94;
  (*input) (20,18).intensity = 96;
  (*input) (21,18).intensity = 96;
  (*input) (22,18).intensity = 95;
  (*input) (23,18).intensity = 96;
  (*input) (24,18).intensity = 94;
  (*input) (25,18).intensity = 92;
  (*input) (26,18).intensity = 94;
  (*input) (27,18).intensity = 92;
  (*input) (28,18).intensity = 93;
  (*input) (29,18).intensity = 93;
  (*input) (30,18).intensity = 94;
  (*input) (31,18).intensity = 92;
  (*input) (32,18).intensity = 91;
  (*input) (33,18).intensity = 91;
  (*input) (34,18).intensity = 91;
  (*input) (35,18).intensity = 90;
  (*input) (36,18).intensity = 92;
  (*input) (37,18).intensity = 91;
  (*input) (38,18).intensity = 90;
  (*input) (39,18).intensity = 91;
  (*input) (40,18).intensity = 90;
  (*input) (41,18).intensity = 90;
  (*input) (42,18).intensity = 89;
  (*input) (43,18).intensity = 89;
  (*input) (44,18).intensity = 89;
  (*input) (45,18).intensity = 90;
  (*input) (46,18).intensity = 88;
  (*input) (47,18).intensity = 89;
  (*input) (48,18).intensity = 90;
  (*input) (49,18).intensity = 89;
  (*input) (50,18).intensity = 89;
  (*input) (51,18).intensity = 90;
  (*input) (52,18).intensity = 88;
  (*input) (53,18).intensity = 87;
  (*input) (54,18).intensity = 89;
  (*input) (55,18).intensity = 88;
  (*input) (56,18).intensity = 89;
  (*input) (57,18).intensity = 89;
  (*input) (58,18).intensity = 90;
  (*input) (59,18).intensity = 95;
  (*input) (60,18).intensity = 87;
  (*input) (61,18).intensity = 85;
  (*input) (62,18).intensity = 99;
  (*input) (63,18).intensity = 101;
  (*input) (0,19).intensity = 103;
  (*input) (1,19).intensity = 103;
  (*input) (2,19).intensity = 102;
  (*input) (3,19).intensity = 101;
  (*input) (4,19).intensity = 102;
  (*input) (5,19).intensity = 102;
  (*input) (6,19).intensity = 100;
  (*input) (7,19).intensity = 100;
  (*input) (8,19).intensity = 99;
  (*input) (9,19).intensity = 101;
  (*input) (10,19).intensity = 99;
  (*input) (11,19).intensity = 98;
  (*input) (12,19).intensity = 99;
  (*input) (13,19).intensity = 98;
  (*input) (14,19).intensity = 98;
  (*input) (15,19).intensity = 97;
  (*input) (16,19).intensity = 97;
  (*input) (17,19).intensity = 96;
  (*input) (18,19).intensity = 96;
  (*input) (19,19).intensity = 95;
  (*input) (20,19).intensity = 96;
  (*input) (21,19).intensity = 98;
  (*input) (22,19).intensity = 95;
  (*input) (23,19).intensity = 97;
  (*input) (24,19).intensity = 94;
  (*input) (25,19).intensity = 94;
  (*input) (26,19).intensity = 94;
  (*input) (27,19).intensity = 93;
  (*input) (28,19).intensity = 93;
  (*input) (29,19).intensity = 93;
  (*input) (30,19).intensity = 96;
  (*input) (31,19).intensity = 93;
  (*input) (32,19).intensity = 94;
  (*input) (33,19).intensity = 92;
  (*input) (34,19).intensity = 93;
  (*input) (35,19).intensity = 92;
  (*input) (36,19).intensity = 92;
  (*input) (37,19).intensity = 92;
  (*input) (38,19).intensity = 93;
  (*input) (39,19).intensity = 91;
  (*input) (40,19).intensity = 91;
  (*input) (41,19).intensity = 92;
  (*input) (42,19).intensity = 89;
  (*input) (43,19).intensity = 90;
  (*input) (44,19).intensity = 90;
  (*input) (45,19).intensity = 92;
  (*input) (46,19).intensity = 91;
  (*input) (47,19).intensity = 90;
  (*input) (48,19).intensity = 91;
  (*input) (49,19).intensity = 89;
  (*input) (50,19).intensity = 91;
  (*input) (51,19).intensity = 89;
  (*input) (52,19).intensity = 89;
  (*input) (53,19).intensity = 89;
  (*input) (54,19).intensity = 90;
  (*input) (55,19).intensity = 89;
  (*input) (56,19).intensity = 90;
  (*input) (57,19).intensity = 91;
  (*input) (58,19).intensity = 90;
  (*input) (59,19).intensity = 96;
  (*input) (60,19).intensity = 94;
  (*input) (61,19).intensity = 107;
  (*input) (62,19).intensity = 127;
  (*input) (63,19).intensity = 94;
  (*input) (0,20).intensity = 103;
  (*input) (1,20).intensity = 103;
  (*input) (2,20).intensity = 103;
  (*input) (3,20).intensity = 103;
  (*input) (4,20).intensity = 103;
  (*input) (5,20).intensity = 103;
  (*input) (6,20).intensity = 102;
  (*input) (7,20).intensity = 101;
  (*input) (8,20).intensity = 100;
  (*input) (9,20).intensity = 101;
  (*input) (10,20).intensity = 99;
  (*input) (11,20).intensity = 99;
  (*input) (12,20).intensity = 99;
  (*input) (13,20).intensity = 98;
  (*input) (14,20).intensity = 98;
  (*input) (15,20).intensity = 98;
  (*input) (16,20).intensity = 97;
  (*input) (17,20).intensity = 97;
  (*input) (18,20).intensity = 96;
  (*input) (19,20).intensity = 95;
  (*input) (20,20).intensity = 96;
  (*input) (21,20).intensity = 98;
  (*input) (22,20).intensity = 97;
  (*input) (23,20).intensity = 98;
  (*input) (24,20).intensity = 97;
  (*input) (25,20).intensity = 95;
  (*input) (26,20).intensity = 96;
  (*input) (27,20).intensity = 94;
  (*input) (28,20).intensity = 95;
  (*input) (29,20).intensity = 95;
  (*input) (30,20).intensity = 95;
  (*input) (31,20).intensity = 94;
  (*input) (32,20).intensity = 94;
  (*input) (33,20).intensity = 93;
  (*input) (34,20).intensity = 94;
  (*input) (35,20).intensity = 93;
  (*input) (36,20).intensity = 94;
  (*input) (37,20).intensity = 92;
  (*input) (38,20).intensity = 93;
  (*input) (39,20).intensity = 93;
  (*input) (40,20).intensity = 92;
  (*input) (41,20).intensity = 92;
  (*input) (42,20).intensity = 91;
  (*input) (43,20).intensity = 92;
  (*input) (44,20).intensity = 92;
  (*input) (45,20).intensity = 91;
  (*input) (46,20).intensity = 92;
  (*input) (47,20).intensity = 91;
  (*input) (48,20).intensity = 90;
  (*input) (49,20).intensity = 90;
  (*input) (50,20).intensity = 91;
  (*input) (51,20).intensity = 90;
  (*input) (52,20).intensity = 88;
  (*input) (53,20).intensity = 89;
  (*input) (54,20).intensity = 90;
  (*input) (55,20).intensity = 90;
  (*input) (56,20).intensity = 89;
  (*input) (57,20).intensity = 90;
  (*input) (58,20).intensity = 90;
  (*input) (59,20).intensity = 93;
  (*input) (60,20).intensity = 101;
  (*input) (61,20).intensity = 115;
  (*input) (62,20).intensity = 121;
  (*input) (63,20).intensity = 81;
  (*input) (0,21).intensity = 104;
  (*input) (1,21).intensity = 105;
  (*input) (2,21).intensity = 104;
  (*input) (3,21).intensity = 104;
  (*input) (4,21).intensity = 103;
  (*input) (5,21).intensity = 102;
  (*input) (6,21).intensity = 103;
  (*input) (7,21).intensity = 102;
  (*input) (8,21).intensity = 101;
  (*input) (9,21).intensity = 101;
  (*input) (10,21).intensity = 100;
  (*input) (11,21).intensity = 100;
  (*input) (12,21).intensity = 99;
  (*input) (13,21).intensity = 99;
  (*input) (14,21).intensity = 98;
  (*input) (15,21).intensity = 98;
  (*input) (16,21).intensity = 98;
  (*input) (17,21).intensity = 97;
  (*input) (18,21).intensity = 97;
  (*input) (19,21).intensity = 96;
  (*input) (20,21).intensity = 95;
  (*input) (21,21).intensity = 97;
  (*input) (22,21).intensity = 97;
  (*input) (23,21).intensity = 97;
  (*input) (24,21).intensity = 96;
  (*input) (25,21).intensity = 96;
  (*input) (26,21).intensity = 96;
  (*input) (27,21).intensity = 96;
  (*input) (28,21).intensity = 96;
  (*input) (29,21).intensity = 96;
  (*input) (30,21).intensity = 95;
  (*input) (31,21).intensity = 95;
  (*input) (32,21).intensity = 96;
  (*input) (33,21).intensity = 94;
  (*input) (34,21).intensity = 94;
  (*input) (35,21).intensity = 93;
  (*input) (36,21).intensity = 94;
  (*input) (37,21).intensity = 92;
  (*input) (38,21).intensity = 94;
  (*input) (39,21).intensity = 94;
  (*input) (40,21).intensity = 93;
  (*input) (41,21).intensity = 92;
  (*input) (42,21).intensity = 93;
  (*input) (43,21).intensity = 93;
  (*input) (44,21).intensity = 92;
  (*input) (45,21).intensity = 92;
  (*input) (46,21).intensity = 93;
  (*input) (47,21).intensity = 91;
  (*input) (48,21).intensity = 90;
  (*input) (49,21).intensity = 91;
  (*input) (50,21).intensity = 91;
  (*input) (51,21).intensity = 89;
  (*input) (52,21).intensity = 90;
  (*input) (53,21).intensity = 92;
  (*input) (54,21).intensity = 90;
  (*input) (55,21).intensity = 91;
  (*input) (56,21).intensity = 89;
  (*input) (57,21).intensity = 91;
  (*input) (58,21).intensity = 91;
  (*input) (59,21).intensity = 92;
  (*input) (60,21).intensity = 100;
  (*input) (61,21).intensity = 110;
  (*input) (62,21).intensity = 99;
  (*input) (63,21).intensity = 82;
  (*input) (0,22).intensity = 105;
  (*input) (1,22).intensity = 104;
  (*input) (2,22).intensity = 105;
  (*input) (3,22).intensity = 105;
  (*input) (4,22).intensity = 103;
  (*input) (5,22).intensity = 104;
  (*input) (6,22).intensity = 103;
  (*input) (7,22).intensity = 102;
  (*input) (8,22).intensity = 102;
  (*input) (9,22).intensity = 101;
  (*input) (10,22).intensity = 102;
  (*input) (11,22).intensity = 100;
  (*input) (12,22).intensity = 99;
  (*input) (13,22).intensity = 99;
  (*input) (14,22).intensity = 99;
  (*input) (15,22).intensity = 99;
  (*input) (16,22).intensity = 98;
  (*input) (17,22).intensity = 98;
  (*input) (18,22).intensity = 98;
  (*input) (19,22).intensity = 98;
  (*input) (20,22).intensity = 96;
  (*input) (21,22).intensity = 96;
  (*input) (22,22).intensity = 98;
  (*input) (23,22).intensity = 98;
  (*input) (24,22).intensity = 97;
  (*input) (25,22).intensity = 97;
  (*input) (26,22).intensity = 96;
  (*input) (27,22).intensity = 97;
  (*input) (28,22).intensity = 97;
  (*input) (29,22).intensity = 97;
  (*input) (30,22).intensity = 97;
  (*input) (31,22).intensity = 96;
  (*input) (32,22).intensity = 95;
  (*input) (33,22).intensity = 94;
  (*input) (34,22).intensity = 94;
  (*input) (35,22).intensity = 95;
  (*input) (36,22).intensity = 96;
  (*input) (37,22).intensity = 93;
  (*input) (38,22).intensity = 94;
  (*input) (39,22).intensity = 94;
  (*input) (40,22).intensity = 94;
  (*input) (41,22).intensity = 92;
  (*input) (42,22).intensity = 93;
  (*input) (43,22).intensity = 93;
  (*input) (44,22).intensity = 93;
  (*input) (45,22).intensity = 91;
  (*input) (46,22).intensity = 93;
  (*input) (47,22).intensity = 90;
  (*input) (48,22).intensity = 90;
  (*input) (49,22).intensity = 92;
  (*input) (50,22).intensity = 92;
  (*input) (51,22).intensity = 91;
  (*input) (52,22).intensity = 92;
  (*input) (53,22).intensity = 90;
  (*input) (54,22).intensity = 90;
  (*input) (55,22).intensity = 92;
  (*input) (56,22).intensity = 90;
  (*input) (57,22).intensity = 90;
  (*input) (58,22).intensity = 92;
  (*input) (59,22).intensity = 90;
  (*input) (60,22).intensity = 94;
  (*input) (61,22).intensity = 89;
  (*input) (62,22).intensity = 87;
  (*input) (63,22).intensity = 89;
  (*input) (0,23).intensity = 106;
  (*input) (1,23).intensity = 105;
  (*input) (2,23).intensity = 107;
  (*input) (3,23).intensity = 105;
  (*input) (4,23).intensity = 104;
  (*input) (5,23).intensity = 102;
  (*input) (6,23).intensity = 103;
  (*input) (7,23).intensity = 104;
  (*input) (8,23).intensity = 103;
  (*input) (9,23).intensity = 102;
  (*input) (10,23).intensity = 102;
  (*input) (11,23).intensity = 100;
  (*input) (12,23).intensity = 100;
  (*input) (13,23).intensity = 101;
  (*input) (14,23).intensity = 99;
  (*input) (15,23).intensity = 100;
  (*input) (16,23).intensity = 97;
  (*input) (17,23).intensity = 98;
  (*input) (18,23).intensity = 98;
  (*input) (19,23).intensity = 99;
  (*input) (20,23).intensity = 97;
  (*input) (21,23).intensity = 97;
  (*input) (22,23).intensity = 98;
  (*input) (23,23).intensity = 99;
  (*input) (24,23).intensity = 97;
  (*input) (25,23).intensity = 97;
  (*input) (26,23).intensity = 97;
  (*input) (27,23).intensity = 97;
  (*input) (28,23).intensity = 98;
  (*input) (29,23).intensity = 97;
  (*input) (30,23).intensity = 97;
  (*input) (31,23).intensity = 96;
  (*input) (32,23).intensity = 96;
  (*input) (33,23).intensity = 96;
  (*input) (34,23).intensity = 95;
  (*input) (35,23).intensity = 95;
  (*input) (36,23).intensity = 96;
  (*input) (37,23).intensity = 94;
  (*input) (38,23).intensity = 94;
  (*input) (39,23).intensity = 94;
  (*input) (40,23).intensity = 94;
  (*input) (41,23).intensity = 94;
  (*input) (42,23).intensity = 93;
  (*input) (43,23).intensity = 94;
  (*input) (44,23).intensity = 94;
  (*input) (45,23).intensity = 92;
  (*input) (46,23).intensity = 93;
  (*input) (47,23).intensity = 92;
  (*input) (48,23).intensity = 92;
  (*input) (49,23).intensity = 94;
  (*input) (50,23).intensity = 92;
  (*input) (51,23).intensity = 93;
  (*input) (52,23).intensity = 94;
  (*input) (53,23).intensity = 92;
  (*input) (54,23).intensity = 91;
  (*input) (55,23).intensity = 93;
  (*input) (56,23).intensity = 91;
  (*input) (57,23).intensity = 90;
  (*input) (58,23).intensity = 93;
  (*input) (59,23).intensity = 92;
  (*input) (60,23).intensity = 93;
  (*input) (61,23).intensity = 87;
  (*input) (62,23).intensity = 91;
  (*input) (63,23).intensity = 93;
  (*input) (0,24).intensity = 107;
  (*input) (1,24).intensity = 105;
  (*input) (2,24).intensity = 106;
  (*input) (3,24).intensity = 105;
  (*input) (4,24).intensity = 104;
  (*input) (5,24).intensity = 105;
  (*input) (6,24).intensity = 103;
  (*input) (7,24).intensity = 102;
  (*input) (8,24).intensity = 103;
  (*input) (9,24).intensity = 102;
  (*input) (10,24).intensity = 103;
  (*input) (11,24).intensity = 100;
  (*input) (12,24).intensity = 101;
  (*input) (13,24).intensity = 100;
  (*input) (14,24).intensity = 100;
  (*input) (15,24).intensity = 100;
  (*input) (16,24).intensity = 99;
  (*input) (17,24).intensity = 98;
  (*input) (18,24).intensity = 99;
  (*input) (19,24).intensity = 100;
  (*input) (20,24).intensity = 99;
  (*input) (21,24).intensity = 98;
  (*input) (22,24).intensity = 99;
  (*input) (23,24).intensity = 99;
  (*input) (24,24).intensity = 98;
  (*input) (25,24).intensity = 98;
  (*input) (26,24).intensity = 98;
  (*input) (27,24).intensity = 97;
  (*input) (28,24).intensity = 98;
  (*input) (29,24).intensity = 97;
  (*input) (30,24).intensity = 99;
  (*input) (31,24).intensity = 97;
  (*input) (32,24).intensity = 96;
  (*input) (33,24).intensity = 96;
  (*input) (34,24).intensity = 96;
  (*input) (35,24).intensity = 95;
  (*input) (36,24).intensity = 96;
  (*input) (37,24).intensity = 96;
  (*input) (38,24).intensity = 97;
  (*input) (39,24).intensity = 96;
  (*input) (40,24).intensity = 94;
  (*input) (41,24).intensity = 96;
  (*input) (42,24).intensity = 94;
  (*input) (43,24).intensity = 94;
  (*input) (44,24).intensity = 96;
  (*input) (45,24).intensity = 93;
  (*input) (46,24).intensity = 94;
  (*input) (47,24).intensity = 91;
  (*input) (48,24).intensity = 93;
  (*input) (49,24).intensity = 95;
  (*input) (50,24).intensity = 94;
  (*input) (51,24).intensity = 93;
  (*input) (52,24).intensity = 95;
  (*input) (53,24).intensity = 91;
  (*input) (54,24).intensity = 92;
  (*input) (55,24).intensity = 93;
  (*input) (56,24).intensity = 93;
  (*input) (57,24).intensity = 91;
  (*input) (58,24).intensity = 92;
  (*input) (59,24).intensity = 91;
  (*input) (60,24).intensity = 92;
  (*input) (61,24).intensity = 90;
  (*input) (62,24).intensity = 92;
  (*input) (63,24).intensity = 93;
  (*input) (0,25).intensity = 108;
  (*input) (1,25).intensity = 106;
  (*input) (2,25).intensity = 105;
  (*input) (3,25).intensity = 106;
  (*input) (4,25).intensity = 105;
  (*input) (5,25).intensity = 103;
  (*input) (6,25).intensity = 104;
  (*input) (7,25).intensity = 102;
  (*input) (8,25).intensity = 104;
  (*input) (9,25).intensity = 103;
  (*input) (10,25).intensity = 103;
  (*input) (11,25).intensity = 100;
  (*input) (12,25).intensity = 101;
  (*input) (13,25).intensity = 101;
  (*input) (14,25).intensity = 101;
  (*input) (15,25).intensity = 101;
  (*input) (16,25).intensity = 99;
  (*input) (17,25).intensity = 99;
  (*input) (18,25).intensity = 100;
  (*input) (19,25).intensity = 99;
  (*input) (20,25).intensity = 100;
  (*input) (21,25).intensity = 99;
  (*input) (22,25).intensity = 99;
  (*input) (23,25).intensity = 100;
  (*input) (24,25).intensity = 99;
  (*input) (25,25).intensity = 99;
  (*input) (26,25).intensity = 99;
  (*input) (27,25).intensity = 98;
  (*input) (28,25).intensity = 98;
  (*input) (29,25).intensity = 98;
  (*input) (30,25).intensity = 98;
  (*input) (31,25).intensity = 96;
  (*input) (32,25).intensity = 98;
  (*input) (33,25).intensity = 96;
  (*input) (34,25).intensity = 96;
  (*input) (35,25).intensity = 96;
  (*input) (36,25).intensity = 96;
  (*input) (37,25).intensity = 96;
  (*input) (38,25).intensity = 96;
  (*input) (39,25).intensity = 96;
  (*input) (40,25).intensity = 96;
  (*input) (41,25).intensity = 96;
  (*input) (42,25).intensity = 96;
  (*input) (43,25).intensity = 96;
  (*input) (44,25).intensity = 96;
  (*input) (45,25).intensity = 94;
  (*input) (46,25).intensity = 96;
  (*input) (47,25).intensity = 94;
  (*input) (48,25).intensity = 94;
  (*input) (49,25).intensity = 94;
  (*input) (50,25).intensity = 93;
  (*input) (51,25).intensity = 96;
  (*input) (52,25).intensity = 95;
  (*input) (53,25).intensity = 92;
  (*input) (54,25).intensity = 93;
  (*input) (55,25).intensity = 93;
  (*input) (56,25).intensity = 94;
  (*input) (57,25).intensity = 91;
  (*input) (58,25).intensity = 92;
  (*input) (59,25).intensity = 93;
  (*input) (60,25).intensity = 92;
  (*input) (61,25).intensity = 92;
  (*input) (62,25).intensity = 91;
  (*input) (63,25).intensity = 94;
  (*input) (0,26).intensity = 110;
  (*input) (1,26).intensity = 106;
  (*input) (2,26).intensity = 105;
  (*input) (3,26).intensity = 106;
  (*input) (4,26).intensity = 105;
  (*input) (5,26).intensity = 105;
  (*input) (6,26).intensity = 105;
  (*input) (7,26).intensity = 101;
  (*input) (8,26).intensity = 104;
  (*input) (9,26).intensity = 103;
  (*input) (10,26).intensity = 102;
  (*input) (11,26).intensity = 99;
  (*input) (12,26).intensity = 101;
  (*input) (13,26).intensity = 100;
  (*input) (14,26).intensity = 101;
  (*input) (15,26).intensity = 101;
  (*input) (16,26).intensity = 101;
  (*input) (17,26).intensity = 101;
  (*input) (18,26).intensity = 100;
  (*input) (19,26).intensity = 99;
  (*input) (20,26).intensity = 101;
  (*input) (21,26).intensity = 98;
  (*input) (22,26).intensity = 99;
  (*input) (23,26).intensity = 101;
  (*input) (24,26).intensity = 99;
  (*input) (25,26).intensity = 100;
  (*input) (26,26).intensity = 99;
  (*input) (27,26).intensity = 98;
  (*input) (28,26).intensity = 98;
  (*input) (29,26).intensity = 99;
  (*input) (30,26).intensity = 99;
  (*input) (31,26).intensity = 98;
  (*input) (32,26).intensity = 98;
  (*input) (33,26).intensity = 97;
  (*input) (34,26).intensity = 96;
  (*input) (35,26).intensity = 97;
  (*input) (36,26).intensity = 97;
  (*input) (37,26).intensity = 97;
  (*input) (38,26).intensity = 97;
  (*input) (39,26).intensity = 98;
  (*input) (40,26).intensity = 96;
  (*input) (41,26).intensity = 97;
  (*input) (42,26).intensity = 96;
  (*input) (43,26).intensity = 96;
  (*input) (44,26).intensity = 96;
  (*input) (45,26).intensity = 93;
  (*input) (46,26).intensity = 96;
  (*input) (47,26).intensity = 94;
  (*input) (48,26).intensity = 96;
  (*input) (49,26).intensity = 94;
  (*input) (50,26).intensity = 94;
  (*input) (51,26).intensity = 94;
  (*input) (52,26).intensity = 96;
  (*input) (53,26).intensity = 93;
  (*input) (54,26).intensity = 94;
  (*input) (55,26).intensity = 93;
  (*input) (56,26).intensity = 96;
  (*input) (57,26).intensity = 93;
  (*input) (58,26).intensity = 91;
  (*input) (59,26).intensity = 93;
  (*input) (60,26).intensity = 93;
  (*input) (61,26).intensity = 92;
  (*input) (62,26).intensity = 92;
  (*input) (63,26).intensity = 93;
  (*input) (0,27).intensity = 110;
  (*input) (1,27).intensity = 107;
  (*input) (2,27).intensity = 106;
  (*input) (3,27).intensity = 106;
  (*input) (4,27).intensity = 106;
  (*input) (5,27).intensity = 105;
  (*input) (6,27).intensity = 106;
  (*input) (7,27).intensity = 103;
  (*input) (8,27).intensity = 105;
  (*input) (9,27).intensity = 103;
  (*input) (10,27).intensity = 103;
  (*input) (11,27).intensity = 102;
  (*input) (12,27).intensity = 102;
  (*input) (13,27).intensity = 101;
  (*input) (14,27).intensity = 101;
  (*input) (15,27).intensity = 102;
  (*input) (16,27).intensity = 100;
  (*input) (17,27).intensity = 101;
  (*input) (18,27).intensity = 100;
  (*input) (19,27).intensity = 100;
  (*input) (20,27).intensity = 101;
  (*input) (21,27).intensity = 99;
  (*input) (22,27).intensity = 100;
  (*input) (23,27).intensity = 100;
  (*input) (24,27).intensity = 99;
  (*input) (25,27).intensity = 100;
  (*input) (26,27).intensity = 100;
  (*input) (27,27).intensity = 99;
  (*input) (28,27).intensity = 98;
  (*input) (29,27).intensity = 100;
  (*input) (30,27).intensity = 99;
  (*input) (31,27).intensity = 98;
  (*input) (32,27).intensity = 98;
  (*input) (33,27).intensity = 97;
  (*input) (34,27).intensity = 97;
  (*input) (35,27).intensity = 98;
  (*input) (36,27).intensity = 96;
  (*input) (37,27).intensity = 98;
  (*input) (38,27).intensity = 97;
  (*input) (39,27).intensity = 97;
  (*input) (40,27).intensity = 97;
  (*input) (41,27).intensity = 98;
  (*input) (42,27).intensity = 97;
  (*input) (43,27).intensity = 96;
  (*input) (44,27).intensity = 96;
  (*input) (45,27).intensity = 95;
  (*input) (46,27).intensity = 97;
  (*input) (47,27).intensity = 96;
  (*input) (48,27).intensity = 96;
  (*input) (49,27).intensity = 93;
  (*input) (50,27).intensity = 94;
  (*input) (51,27).intensity = 94;
  (*input) (52,27).intensity = 96;
  (*input) (53,27).intensity = 94;
  (*input) (54,27).intensity = 95;
  (*input) (55,27).intensity = 94;
  (*input) (56,27).intensity = 96;
  (*input) (57,27).intensity = 94;
  (*input) (58,27).intensity = 93;
  (*input) (59,27).intensity = 94;
  (*input) (60,27).intensity = 93;
  (*input) (61,27).intensity = 94;
  (*input) (62,27).intensity = 92;
  (*input) (63,27).intensity = 92;
  (*input) (0,28).intensity = 111;
  (*input) (1,28).intensity = 108;
  (*input) (2,28).intensity = 109;
  (*input) (3,28).intensity = 107;
  (*input) (4,28).intensity = 106;
  (*input) (5,28).intensity = 106;
  (*input) (6,28).intensity = 106;
  (*input) (7,28).intensity = 105;
  (*input) (8,28).intensity = 104;
  (*input) (9,28).intensity = 103;
  (*input) (10,28).intensity = 104;
  (*input) (11,28).intensity = 101;
  (*input) (12,28).intensity = 103;
  (*input) (13,28).intensity = 102;
  (*input) (14,28).intensity = 100;
  (*input) (15,28).intensity = 102;
  (*input) (16,28).intensity = 100;
  (*input) (17,28).intensity = 101;
  (*input) (18,28).intensity = 99;
  (*input) (19,28).intensity = 101;
  (*input) (20,28).intensity = 101;
  (*input) (21,28).intensity = 99;
  (*input) (22,28).intensity = 101;
  (*input) (23,28).intensity = 100;
  (*input) (24,28).intensity = 99;
  (*input) (25,28).intensity = 101;
  (*input) (26,28).intensity = 100;
  (*input) (27,28).intensity = 99;
  (*input) (28,28).intensity = 99;
  (*input) (29,28).intensity = 99;
  (*input) (30,28).intensity = 99;
  (*input) (31,28).intensity = 99;
  (*input) (32,28).intensity = 99;
  (*input) (33,28).intensity = 98;
  (*input) (34,28).intensity = 99;
  (*input) (35,28).intensity = 98;
  (*input) (36,28).intensity = 97;
  (*input) (37,28).intensity = 98;
  (*input) (38,28).intensity = 97;
  (*input) (39,28).intensity = 98;
  (*input) (40,28).intensity = 98;
  (*input) (41,28).intensity = 98;
  (*input) (42,28).intensity = 98;
  (*input) (43,28).intensity = 96;
  (*input) (44,28).intensity = 97;
  (*input) (45,28).intensity = 96;
  (*input) (46,28).intensity = 97;
  (*input) (47,28).intensity = 96;
  (*input) (48,28).intensity = 96;
  (*input) (49,28).intensity = 95;
  (*input) (50,28).intensity = 95;
  (*input) (51,28).intensity = 95;
  (*input) (52,28).intensity = 95;
  (*input) (53,28).intensity = 94;
  (*input) (54,28).intensity = 95;
  (*input) (55,28).intensity = 94;
  (*input) (56,28).intensity = 96;
  (*input) (57,28).intensity = 96;
  (*input) (58,28).intensity = 93;
  (*input) (59,28).intensity = 93;
  (*input) (60,28).intensity = 94;
  (*input) (61,28).intensity = 93;
  (*input) (62,28).intensity = 94;
  (*input) (63,28).intensity = 92;
  (*input) (0,29).intensity = 114;
  (*input) (1,29).intensity = 110;
  (*input) (2,29).intensity = 110;
  (*input) (3,29).intensity = 108;
  (*input) (4,29).intensity = 108;
  (*input) (5,29).intensity = 107;
  (*input) (6,29).intensity = 106;
  (*input) (7,29).intensity = 106;
  (*input) (8,29).intensity = 104;
  (*input) (9,29).intensity = 105;
  (*input) (10,29).intensity = 106;
  (*input) (11,29).intensity = 103;
  (*input) (12,29).intensity = 103;
  (*input) (13,29).intensity = 102;
  (*input) (14,29).intensity = 101;
  (*input) (15,29).intensity = 103;
  (*input) (16,29).intensity = 101;
  (*input) (17,29).intensity = 101;
  (*input) (18,29).intensity = 101;
  (*input) (19,29).intensity = 102;
  (*input) (20,29).intensity = 101;
  (*input) (21,29).intensity = 99;
  (*input) (22,29).intensity = 101;
  (*input) (23,29).intensity = 99;
  (*input) (24,29).intensity = 101;
  (*input) (25,29).intensity = 100;
  (*input) (26,29).intensity = 101;
  (*input) (27,29).intensity = 101;
  (*input) (28,29).intensity = 101;
  (*input) (29,29).intensity = 100;
  (*input) (30,29).intensity = 101;
  (*input) (31,29).intensity = 99;
  (*input) (32,29).intensity = 99;
  (*input) (33,29).intensity = 99;
  (*input) (34,29).intensity = 100;
  (*input) (35,29).intensity = 98;
  (*input) (36,29).intensity = 99;
  (*input) (37,29).intensity = 99;
  (*input) (38,29).intensity = 97;
  (*input) (39,29).intensity = 98;
  (*input) (40,29).intensity = 99;
  (*input) (41,29).intensity = 99;
  (*input) (42,29).intensity = 98;
  (*input) (43,29).intensity = 97;
  (*input) (44,29).intensity = 97;
  (*input) (45,29).intensity = 98;
  (*input) (46,29).intensity = 98;
  (*input) (47,29).intensity = 98;
  (*input) (48,29).intensity = 97;
  (*input) (49,29).intensity = 96;
  (*input) (50,29).intensity = 97;
  (*input) (51,29).intensity = 97;
  (*input) (52,29).intensity = 96;
  (*input) (53,29).intensity = 96;
  (*input) (54,29).intensity = 96;
  (*input) (55,29).intensity = 94;
  (*input) (56,29).intensity = 96;
  (*input) (57,29).intensity = 96;
  (*input) (58,29).intensity = 95;
  (*input) (59,29).intensity = 94;
  (*input) (60,29).intensity = 94;
  (*input) (61,29).intensity = 95;
  (*input) (62,29).intensity = 94;
  (*input) (63,29).intensity = 92;
  (*input) (0,30).intensity = 115;
  (*input) (1,30).intensity = 112;
  (*input) (2,30).intensity = 111;
  (*input) (3,30).intensity = 109;
  (*input) (4,30).intensity = 109;
  (*input) (5,30).intensity = 107;
  (*input) (6,30).intensity = 106;
  (*input) (7,30).intensity = 106;
  (*input) (8,30).intensity = 105;
  (*input) (9,30).intensity = 106;
  (*input) (10,30).intensity = 106;
  (*input) (11,30).intensity = 103;
  (*input) (12,30).intensity = 103;
  (*input) (13,30).intensity = 104;
  (*input) (14,30).intensity = 103;
  (*input) (15,30).intensity = 103;
  (*input) (16,30).intensity = 101;
  (*input) (17,30).intensity = 102;
  (*input) (18,30).intensity = 101;
  (*input) (19,30).intensity = 102;
  (*input) (20,30).intensity = 101;
  (*input) (21,30).intensity = 100;
  (*input) (22,30).intensity = 102;
  (*input) (23,30).intensity = 99;
  (*input) (24,30).intensity = 101;
  (*input) (25,30).intensity = 101;
  (*input) (26,30).intensity = 101;
  (*input) (27,30).intensity = 101;
  (*input) (28,30).intensity = 100;
  (*input) (29,30).intensity = 99;
  (*input) (30,30).intensity = 101;
  (*input) (31,30).intensity = 101;
  (*input) (32,30).intensity = 100;
  (*input) (33,30).intensity = 99;
  (*input) (34,30).intensity = 101;
  (*input) (35,30).intensity = 99;
  (*input) (36,30).intensity = 99;
  (*input) (37,30).intensity = 99;
  (*input) (38,30).intensity = 97;
  (*input) (39,30).intensity = 98;
  (*input) (40,30).intensity = 97;
  (*input) (41,30).intensity = 98;
  (*input) (42,30).intensity = 99;
  (*input) (43,30).intensity = 98;
  (*input) (44,30).intensity = 98;
  (*input) (45,30).intensity = 98;
  (*input) (46,30).intensity = 98;
  (*input) (47,30).intensity = 98;
  (*input) (48,30).intensity = 98;
  (*input) (49,30).intensity = 97;
  (*input) (50,30).intensity = 97;
  (*input) (51,30).intensity = 96;
  (*input) (52,30).intensity = 95;
  (*input) (53,30).intensity = 96;
  (*input) (54,30).intensity = 96;
  (*input) (55,30).intensity = 95;
  (*input) (56,30).intensity = 96;
  (*input) (57,30).intensity = 97;
  (*input) (58,30).intensity = 95;
  (*input) (59,30).intensity = 94;
  (*input) (60,30).intensity = 96;
  (*input) (61,30).intensity = 94;
  (*input) (62,30).intensity = 94;
  (*input) (63,30).intensity = 94;
  (*input) (0,31).intensity = 115;
  (*input) (1,31).intensity = 114;
  (*input) (2,31).intensity = 111;
  (*input) (3,31).intensity = 111;
  (*input) (4,31).intensity = 111;
  (*input) (5,31).intensity = 109;
  (*input) (6,31).intensity = 107;
  (*input) (7,31).intensity = 106;
  (*input) (8,31).intensity = 106;
  (*input) (9,31).intensity = 105;
  (*input) (10,31).intensity = 106;
  (*input) (11,31).intensity = 105;
  (*input) (12,31).intensity = 103;
  (*input) (13,31).intensity = 104;
  (*input) (14,31).intensity = 102;
  (*input) (15,31).intensity = 103;
  (*input) (16,31).intensity = 101;
  (*input) (17,31).intensity = 101;
  (*input) (18,31).intensity = 103;
  (*input) (19,31).intensity = 102;
  (*input) (20,31).intensity = 101;
  (*input) (21,31).intensity = 100;
  (*input) (22,31).intensity = 102;
  (*input) (23,31).intensity = 100;
  (*input) (24,31).intensity = 101;
  (*input) (25,31).intensity = 100;
  (*input) (26,31).intensity = 101;
  (*input) (27,31).intensity = 100;
  (*input) (28,31).intensity = 101;
  (*input) (29,31).intensity = 100;
  (*input) (30,31).intensity = 101;
  (*input) (31,31).intensity = 100;
  (*input) (32,31).intensity = 100;
  (*input) (33,31).intensity = 99;
  (*input) (34,31).intensity = 101;
  (*input) (35,31).intensity = 98;
  (*input) (36,31).intensity = 100;
  (*input) (37,31).intensity = 100;
  (*input) (38,31).intensity = 98;
  (*input) (39,31).intensity = 99;
  (*input) (40,31).intensity = 99;
  (*input) (41,31).intensity = 99;
  (*input) (42,31).intensity = 99;
  (*input) (43,31).intensity = 98;
  (*input) (44,31).intensity = 98;
  (*input) (45,31).intensity = 98;
  (*input) (46,31).intensity = 99;
  (*input) (47,31).intensity = 99;
  (*input) (48,31).intensity = 98;
  (*input) (49,31).intensity = 98;
  (*input) (50,31).intensity = 98;
  (*input) (51,31).intensity = 97;
  (*input) (52,31).intensity = 97;
  (*input) (53,31).intensity = 96;
  (*input) (54,31).intensity = 96;
  (*input) (55,31).intensity = 94;
  (*input) (56,31).intensity = 95;
  (*input) (57,31).intensity = 97;
  (*input) (58,31).intensity = 96;
  (*input) (59,31).intensity = 94;
  (*input) (60,31).intensity = 96;
  (*input) (61,31).intensity = 96;
  (*input) (62,31).intensity = 94;
  (*input) (63,31).intensity = 94;
  (*input) (0,32).intensity = 115;
  (*input) (1,32).intensity = 114;
  (*input) (2,32).intensity = 111;
  (*input) (3,32).intensity = 111;
  (*input) (4,32).intensity = 111;
  (*input) (5,32).intensity = 110;
  (*input) (6,32).intensity = 108;
  (*input) (7,32).intensity = 107;
  (*input) (8,32).intensity = 107;
  (*input) (9,32).intensity = 105;
  (*input) (10,32).intensity = 106;
  (*input) (11,32).intensity = 105;
  (*input) (12,32).intensity = 103;
  (*input) (13,32).intensity = 105;
  (*input) (14,32).intensity = 104;
  (*input) (15,32).intensity = 103;
  (*input) (16,32).intensity = 102;
  (*input) (17,32).intensity = 102;
  (*input) (18,32).intensity = 102;
  (*input) (19,32).intensity = 102;
  (*input) (20,32).intensity = 102;
  (*input) (21,32).intensity = 101;
  (*input) (22,32).intensity = 102;
  (*input) (23,32).intensity = 102;
  (*input) (24,32).intensity = 101;
  (*input) (25,32).intensity = 99;
  (*input) (26,32).intensity = 101;
  (*input) (27,32).intensity = 101;
  (*input) (28,32).intensity = 101;
  (*input) (29,32).intensity = 100;
  (*input) (30,32).intensity = 101;
  (*input) (31,32).intensity = 101;
  (*input) (32,32).intensity = 101;
  (*input) (33,32).intensity = 100;
  (*input) (34,32).intensity = 101;
  (*input) (35,32).intensity = 99;
  (*input) (36,32).intensity = 99;
  (*input) (37,32).intensity = 99;
  (*input) (38,32).intensity = 99;
  (*input) (39,32).intensity = 100;
  (*input) (40,32).intensity = 98;
  (*input) (41,32).intensity = 99;
  (*input) (42,32).intensity = 99;
  (*input) (43,32).intensity = 97;
  (*input) (44,32).intensity = 98;
  (*input) (45,32).intensity = 98;
  (*input) (46,32).intensity = 98;
  (*input) (47,32).intensity = 98;
  (*input) (48,32).intensity = 98;
  (*input) (49,32).intensity = 98;
  (*input) (50,32).intensity = 98;
  (*input) (51,32).intensity = 96;
  (*input) (52,32).intensity = 97;
  (*input) (53,32).intensity = 96;
  (*input) (54,32).intensity = 96;
  (*input) (55,32).intensity = 97;
  (*input) (56,32).intensity = 96;
  (*input) (57,32).intensity = 96;
  (*input) (58,32).intensity = 96;
  (*input) (59,32).intensity = 94;
  (*input) (60,32).intensity = 96;
  (*input) (61,32).intensity = 94;
  (*input) (62,32).intensity = 94;
  (*input) (63,32).intensity = 95;
  (*input) (0,33).intensity = 115;
  (*input) (1,33).intensity = 115;
  (*input) (2,33).intensity = 112;
  (*input) (3,33).intensity = 111;
  (*input) (4,33).intensity = 112;
  (*input) (5,33).intensity = 110;
  (*input) (6,33).intensity = 110;
  (*input) (7,33).intensity = 108;
  (*input) (8,33).intensity = 109;
  (*input) (9,33).intensity = 105;
  (*input) (10,33).intensity = 108;
  (*input) (11,33).intensity = 105;
  (*input) (12,33).intensity = 105;
  (*input) (13,33).intensity = 104;
  (*input) (14,33).intensity = 103;
  (*input) (15,33).intensity = 103;
  (*input) (16,33).intensity = 103;
  (*input) (17,33).intensity = 102;
  (*input) (18,33).intensity = 102;
  (*input) (19,33).intensity = 102;
  (*input) (20,33).intensity = 102;
  (*input) (21,33).intensity = 102;
  (*input) (22,33).intensity = 101;
  (*input) (23,33).intensity = 103;
  (*input) (24,33).intensity = 101;
  (*input) (25,33).intensity = 101;
  (*input) (26,33).intensity = 102;
  (*input) (27,33).intensity = 101;
  (*input) (28,33).intensity = 101;
  (*input) (29,33).intensity = 100;
  (*input) (30,33).intensity = 101;
  (*input) (31,33).intensity = 100;
  (*input) (32,33).intensity = 100;
  (*input) (33,33).intensity = 100;
  (*input) (34,33).intensity = 100;
  (*input) (35,33).intensity = 98;
  (*input) (36,33).intensity = 100;
  (*input) (37,33).intensity = 99;
  (*input) (38,33).intensity = 100;
  (*input) (39,33).intensity = 100;
  (*input) (40,33).intensity = 100;
  (*input) (41,33).intensity = 100;
  (*input) (42,33).intensity = 100;
  (*input) (43,33).intensity = 98;
  (*input) (44,33).intensity = 98;
  (*input) (45,33).intensity = 98;
  (*input) (46,33).intensity = 99;
  (*input) (47,33).intensity = 99;
  (*input) (48,33).intensity = 99;
  (*input) (49,33).intensity = 98;
  (*input) (50,33).intensity = 97;
  (*input) (51,33).intensity = 98;
  (*input) (52,33).intensity = 97;
  (*input) (53,33).intensity = 96;
  (*input) (54,33).intensity = 97;
  (*input) (55,33).intensity = 97;
  (*input) (56,33).intensity = 97;
  (*input) (57,33).intensity = 96;
  (*input) (58,33).intensity = 96;
  (*input) (59,33).intensity = 94;
  (*input) (60,33).intensity = 95;
  (*input) (61,33).intensity = 95;
  (*input) (62,33).intensity = 96;
  (*input) (63,33).intensity = 96;
  (*input) (0,34).intensity = 115;
  (*input) (1,34).intensity = 115;
  (*input) (2,34).intensity = 113;
  (*input) (3,34).intensity = 111;
  (*input) (4,34).intensity = 112;
  (*input) (5,34).intensity = 112;
  (*input) (6,34).intensity = 112;
  (*input) (7,34).intensity = 109;
  (*input) (8,34).intensity = 110;
  (*input) (9,34).intensity = 107;
  (*input) (10,34).intensity = 108;
  (*input) (11,34).intensity = 105;
  (*input) (12,34).intensity = 106;
  (*input) (13,34).intensity = 105;
  (*input) (14,34).intensity = 105;
  (*input) (15,34).intensity = 103;
  (*input) (16,34).intensity = 104;
  (*input) (17,34).intensity = 103;
  (*input) (18,34).intensity = 103;
  (*input) (19,34).intensity = 102;
  (*input) (20,34).intensity = 103;
  (*input) (21,34).intensity = 103;
  (*input) (22,34).intensity = 102;
  (*input) (23,34).intensity = 103;
  (*input) (24,34).intensity = 102;
  (*input) (25,34).intensity = 100;
  (*input) (26,34).intensity = 102;
  (*input) (27,34).intensity = 101;
  (*input) (28,34).intensity = 102;
  (*input) (29,34).intensity = 101;
  (*input) (30,34).intensity = 101;
  (*input) (31,34).intensity = 100;
  (*input) (32,34).intensity = 100;
  (*input) (33,34).intensity = 101;
  (*input) (34,34).intensity = 99;
  (*input) (35,34).intensity = 100;
  (*input) (36,34).intensity = 101;
  (*input) (37,34).intensity = 100;
  (*input) (38,34).intensity = 101;
  (*input) (39,34).intensity = 100;
  (*input) (40,34).intensity = 101;
  (*input) (41,34).intensity = 101;
  (*input) (42,34).intensity = 101;
  (*input) (43,34).intensity = 99;
  (*input) (44,34).intensity = 98;
  (*input) (45,34).intensity = 99;
  (*input) (46,34).intensity = 98;
  (*input) (47,34).intensity = 99;
  (*input) (48,34).intensity = 99;
  (*input) (49,34).intensity = 99;
  (*input) (50,34).intensity = 97;
  (*input) (51,34).intensity = 98;
  (*input) (52,34).intensity = 97;
  (*input) (53,34).intensity = 96;
  (*input) (54,34).intensity = 98;
  (*input) (55,34).intensity = 98;
  (*input) (56,34).intensity = 98;
  (*input) (57,34).intensity = 96;
  (*input) (58,34).intensity = 97;
  (*input) (59,34).intensity = 96;
  (*input) (60,34).intensity = 95;
  (*input) (61,34).intensity = 96;
  (*input) (62,34).intensity = 97;
  (*input) (63,34).intensity = 95;
  (*input) (0,35).intensity = 116;
  (*input) (1,35).intensity = 115;
  (*input) (2,35).intensity = 115;
  (*input) (3,35).intensity = 112;
  (*input) (4,35).intensity = 111;
  (*input) (5,35).intensity = 112;
  (*input) (6,35).intensity = 112;
  (*input) (7,35).intensity = 110;
  (*input) (8,35).intensity = 111;
  (*input) (9,35).intensity = 110;
  (*input) (10,35).intensity = 109;
  (*input) (11,35).intensity = 105;
  (*input) (12,35).intensity = 106;
  (*input) (13,35).intensity = 106;
  (*input) (14,35).intensity = 106;
  (*input) (15,35).intensity = 103;
  (*input) (16,35).intensity = 104;
  (*input) (17,35).intensity = 105;
  (*input) (18,35).intensity = 105;
  (*input) (19,35).intensity = 102;
  (*input) (20,35).intensity = 102;
  (*input) (21,35).intensity = 104;
  (*input) (22,35).intensity = 103;
  (*input) (23,35).intensity = 105;
  (*input) (24,35).intensity = 103;
  (*input) (25,35).intensity = 103;
  (*input) (26,35).intensity = 102;
  (*input) (27,35).intensity = 101;
  (*input) (28,35).intensity = 101;
  (*input) (29,35).intensity = 102;
  (*input) (30,35).intensity = 101;
  (*input) (31,35).intensity = 101;
  (*input) (32,35).intensity = 101;
  (*input) (33,35).intensity = 101;
  (*input) (34,35).intensity = 100;
  (*input) (35,35).intensity = 100;
  (*input) (36,35).intensity = 101;
  (*input) (37,35).intensity = 100;
  (*input) (38,35).intensity = 102;
  (*input) (39,35).intensity = 100;
  (*input) (40,35).intensity = 100;
  (*input) (41,35).intensity = 100;
  (*input) (42,35).intensity = 101;
  (*input) (43,35).intensity = 101;
  (*input) (44,35).intensity = 100;
  (*input) (45,35).intensity = 100;
  (*input) (46,35).intensity = 99;
  (*input) (47,35).intensity = 99;
  (*input) (48,35).intensity = 99;
  (*input) (49,35).intensity = 99;
  (*input) (50,35).intensity = 98;
  (*input) (51,35).intensity = 99;
  (*input) (52,35).intensity = 97;
  (*input) (53,35).intensity = 97;
  (*input) (54,35).intensity = 98;
  (*input) (55,35).intensity = 98;
  (*input) (56,35).intensity = 98;
  (*input) (57,35).intensity = 97;
  (*input) (58,35).intensity = 97;
  (*input) (59,35).intensity = 97;
  (*input) (60,35).intensity = 96;
  (*input) (61,35).intensity = 96;
  (*input) (62,35).intensity = 97;
  (*input) (63,35).intensity = 96;
  (*input) (0,36).intensity = 116;
  (*input) (1,36).intensity = 117;
  (*input) (2,36).intensity = 116;
  (*input) (3,36).intensity = 114;
  (*input) (4,36).intensity = 112;
  (*input) (5,36).intensity = 115;
  (*input) (6,36).intensity = 114;
  (*input) (7,36).intensity = 112;
  (*input) (8,36).intensity = 111;
  (*input) (9,36).intensity = 110;
  (*input) (10,36).intensity = 109;
  (*input) (11,36).intensity = 106;
  (*input) (12,36).intensity = 105;
  (*input) (13,36).intensity = 107;
  (*input) (14,36).intensity = 106;
  (*input) (15,36).intensity = 103;
  (*input) (16,36).intensity = 105;
  (*input) (17,36).intensity = 105;
  (*input) (18,36).intensity = 105;
  (*input) (19,36).intensity = 104;
  (*input) (20,36).intensity = 103;
  (*input) (21,36).intensity = 105;
  (*input) (22,36).intensity = 103;
  (*input) (23,36).intensity = 103;
  (*input) (24,36).intensity = 102;
  (*input) (25,36).intensity = 102;
  (*input) (26,36).intensity = 103;
  (*input) (27,36).intensity = 101;
  (*input) (28,36).intensity = 102;
  (*input) (29,36).intensity = 102;
  (*input) (30,36).intensity = 100;
  (*input) (31,36).intensity = 101;
  (*input) (32,36).intensity = 102;
  (*input) (33,36).intensity = 102;
  (*input) (34,36).intensity = 101;
  (*input) (35,36).intensity = 102;
  (*input) (36,36).intensity = 101;
  (*input) (37,36).intensity = 101;
  (*input) (38,36).intensity = 103;
  (*input) (39,36).intensity = 102;
  (*input) (40,36).intensity = 101;
  (*input) (41,36).intensity = 99;
  (*input) (42,36).intensity = 101;
  (*input) (43,36).intensity = 101;
  (*input) (44,36).intensity = 101;
  (*input) (45,36).intensity = 101;
  (*input) (46,36).intensity = 99;
  (*input) (47,36).intensity = 99;
  (*input) (48,36).intensity = 99;
  (*input) (49,36).intensity = 99;
  (*input) (50,36).intensity = 98;
  (*input) (51,36).intensity = 99;
  (*input) (52,36).intensity = 98;
  (*input) (53,36).intensity = 98;
  (*input) (54,36).intensity = 100;
  (*input) (55,36).intensity = 97;
  (*input) (56,36).intensity = 98;
  (*input) (57,36).intensity = 96;
  (*input) (58,36).intensity = 97;
  (*input) (59,36).intensity = 97;
  (*input) (60,36).intensity = 96;
  (*input) (61,36).intensity = 96;
  (*input) (62,36).intensity = 97;
  (*input) (63,36).intensity = 96;
  (*input) (0,37).intensity = 118;
  (*input) (1,37).intensity = 118;
  (*input) (2,37).intensity = 117;
  (*input) (3,37).intensity = 116;
  (*input) (4,37).intensity = 114;
  (*input) (5,37).intensity = 115;
  (*input) (6,37).intensity = 114;
  (*input) (7,37).intensity = 114;
  (*input) (8,37).intensity = 112;
  (*input) (9,37).intensity = 111;
  (*input) (10,37).intensity = 110;
  (*input) (11,37).intensity = 107;
  (*input) (12,37).intensity = 105;
  (*input) (13,37).intensity = 108;
  (*input) (14,37).intensity = 106;
  (*input) (15,37).intensity = 105;
  (*input) (16,37).intensity = 105;
  (*input) (17,37).intensity = 105;
  (*input) (18,37).intensity = 105;
  (*input) (19,37).intensity = 104;
  (*input) (20,37).intensity = 103;
  (*input) (21,37).intensity = 104;
  (*input) (22,37).intensity = 103;
  (*input) (23,37).intensity = 103;
  (*input) (24,37).intensity = 103;
  (*input) (25,37).intensity = 104;
  (*input) (26,37).intensity = 103;
  (*input) (27,37).intensity = 102;
  (*input) (28,37).intensity = 102;
  (*input) (29,37).intensity = 103;
  (*input) (30,37).intensity = 101;
  (*input) (31,37).intensity = 102;
  (*input) (32,37).intensity = 102;
  (*input) (33,37).intensity = 102;
  (*input) (34,37).intensity = 102;
  (*input) (35,37).intensity = 101;
  (*input) (36,37).intensity = 101;
  (*input) (37,37).intensity = 101;
  (*input) (38,37).intensity = 102;
  (*input) (39,37).intensity = 101;
  (*input) (40,37).intensity = 100;
  (*input) (41,37).intensity = 99;
  (*input) (42,37).intensity = 102;
  (*input) (43,37).intensity = 100;
  (*input) (44,37).intensity = 102;
  (*input) (45,37).intensity = 101;
  (*input) (46,37).intensity = 99;
  (*input) (47,37).intensity = 100;
  (*input) (48,37).intensity = 99;
  (*input) (49,37).intensity = 101;
  (*input) (50,37).intensity = 99;
  (*input) (51,37).intensity = 99;
  (*input) (52,37).intensity = 99;
  (*input) (53,37).intensity = 98;
  (*input) (54,37).intensity = 99;
  (*input) (55,37).intensity = 98;
  (*input) (56,37).intensity = 97;
  (*input) (57,37).intensity = 97;
  (*input) (58,37).intensity = 97;
  (*input) (59,37).intensity = 98;
  (*input) (60,37).intensity = 97;
  (*input) (61,37).intensity = 97;
  (*input) (62,37).intensity = 97;
  (*input) (63,37).intensity = 96;
  (*input) (0,38).intensity = 120;
  (*input) (1,38).intensity = 118;
  (*input) (2,38).intensity = 119;
  (*input) (3,38).intensity = 116;
  (*input) (4,38).intensity = 114;
  (*input) (5,38).intensity = 116;
  (*input) (6,38).intensity = 115;
  (*input) (7,38).intensity = 115;
  (*input) (8,38).intensity = 113;
  (*input) (9,38).intensity = 111;
  (*input) (10,38).intensity = 111;
  (*input) (11,38).intensity = 108;
  (*input) (12,38).intensity = 106;
  (*input) (13,38).intensity = 109;
  (*input) (14,38).intensity = 107;
  (*input) (15,38).intensity = 105;
  (*input) (16,38).intensity = 105;
  (*input) (17,38).intensity = 105;
  (*input) (18,38).intensity = 105;
  (*input) (19,38).intensity = 106;
  (*input) (20,38).intensity = 105;
  (*input) (21,38).intensity = 104;
  (*input) (22,38).intensity = 103;
  (*input) (23,38).intensity = 103;
  (*input) (24,38).intensity = 104;
  (*input) (25,38).intensity = 103;
  (*input) (26,38).intensity = 103;
  (*input) (27,38).intensity = 103;
  (*input) (28,38).intensity = 103;
  (*input) (29,38).intensity = 104;
  (*input) (30,38).intensity = 101;
  (*input) (31,38).intensity = 102;
  (*input) (32,38).intensity = 103;
  (*input) (33,38).intensity = 104;
  (*input) (34,38).intensity = 102;
  (*input) (35,38).intensity = 102;
  (*input) (36,38).intensity = 100;
  (*input) (37,38).intensity = 102;
  (*input) (38,38).intensity = 102;
  (*input) (39,38).intensity = 102;
  (*input) (40,38).intensity = 101;
  (*input) (41,38).intensity = 99;
  (*input) (42,38).intensity = 102;
  (*input) (43,38).intensity = 101;
  (*input) (44,38).intensity = 103;
  (*input) (45,38).intensity = 101;
  (*input) (46,38).intensity = 101;
  (*input) (47,38).intensity = 100;
  (*input) (48,38).intensity = 99;
  (*input) (49,38).intensity = 99;
  (*input) (50,38).intensity = 100;
  (*input) (51,38).intensity = 99;
  (*input) (52,38).intensity = 100;
  (*input) (53,38).intensity = 99;
  (*input) (54,38).intensity = 100;
  (*input) (55,38).intensity = 98;
  (*input) (56,38).intensity = 98;
  (*input) (57,38).intensity = 97;
  (*input) (58,38).intensity = 98;
  (*input) (59,38).intensity = 98;
  (*input) (60,38).intensity = 97;
  (*input) (61,38).intensity = 97;
  (*input) (62,38).intensity = 98;
  (*input) (63,38).intensity = 97;
  (*input) (0,39).intensity = 120;
  (*input) (1,39).intensity = 118;
  (*input) (2,39).intensity = 119;
  (*input) (3,39).intensity = 117;
  (*input) (4,39).intensity = 116;
  (*input) (5,39).intensity = 115;
  (*input) (6,39).intensity = 115;
  (*input) (7,39).intensity = 114;
  (*input) (8,39).intensity = 114;
  (*input) (9,39).intensity = 112;
  (*input) (10,39).intensity = 111;
  (*input) (11,39).intensity = 108;
  (*input) (12,39).intensity = 108;
  (*input) (13,39).intensity = 110;
  (*input) (14,39).intensity = 107;
  (*input) (15,39).intensity = 105;
  (*input) (16,39).intensity = 106;
  (*input) (17,39).intensity = 105;
  (*input) (18,39).intensity = 105;
  (*input) (19,39).intensity = 105;
  (*input) (20,39).intensity = 106;
  (*input) (21,39).intensity = 105;
  (*input) (22,39).intensity = 103;
  (*input) (23,39).intensity = 103;
  (*input) (24,39).intensity = 103;
  (*input) (25,39).intensity = 105;
  (*input) (26,39).intensity = 104;
  (*input) (27,39).intensity = 103;
  (*input) (28,39).intensity = 103;
  (*input) (29,39).intensity = 103;
  (*input) (30,39).intensity = 103;
  (*input) (31,39).intensity = 103;
  (*input) (32,39).intensity = 103;
  (*input) (33,39).intensity = 103;
  (*input) (34,39).intensity = 103;
  (*input) (35,39).intensity = 101;
  (*input) (36,39).intensity = 101;
  (*input) (37,39).intensity = 103;
  (*input) (38,39).intensity = 101;
  (*input) (39,39).intensity = 102;
  (*input) (40,39).intensity = 101;
  (*input) (41,39).intensity = 101;
  (*input) (42,39).intensity = 103;
  (*input) (43,39).intensity = 101;
  (*input) (44,39).intensity = 102;
  (*input) (45,39).intensity = 102;
  (*input) (46,39).intensity = 101;
  (*input) (47,39).intensity = 101;
  (*input) (48,39).intensity = 99;
  (*input) (49,39).intensity = 101;
  (*input) (50,39).intensity = 101;
  (*input) (51,39).intensity = 99;
  (*input) (52,39).intensity = 99;
  (*input) (53,39).intensity = 99;
  (*input) (54,39).intensity = 100;
  (*input) (55,39).intensity = 100;
  (*input) (56,39).intensity = 98;
  (*input) (57,39).intensity = 98;
  (*input) (58,39).intensity = 98;
  (*input) (59,39).intensity = 98;
  (*input) (60,39).intensity = 97;
  (*input) (61,39).intensity = 97;
  (*input) (62,39).intensity = 98;
  (*input) (63,39).intensity = 97;
  (*input) (0,40).intensity = 121;
  (*input) (1,40).intensity = 119;
  (*input) (2,40).intensity = 119;
  (*input) (3,40).intensity = 118;
  (*input) (4,40).intensity = 116;
  (*input) (5,40).intensity = 117;
  (*input) (6,40).intensity = 117;
  (*input) (7,40).intensity = 114;
  (*input) (8,40).intensity = 115;
  (*input) (9,40).intensity = 113;
  (*input) (10,40).intensity = 112;
  (*input) (11,40).intensity = 110;
  (*input) (12,40).intensity = 111;
  (*input) (13,40).intensity = 111;
  (*input) (14,40).intensity = 107;
  (*input) (15,40).intensity = 107;
  (*input) (16,40).intensity = 107;
  (*input) (17,40).intensity = 106;
  (*input) (18,40).intensity = 106;
  (*input) (19,40).intensity = 106;
  (*input) (20,40).intensity = 107;
  (*input) (21,40).intensity = 106;
  (*input) (22,40).intensity = 104;
  (*input) (23,40).intensity = 105;
  (*input) (24,40).intensity = 104;
  (*input) (25,40).intensity = 105;
  (*input) (26,40).intensity = 103;
  (*input) (27,40).intensity = 105;
  (*input) (28,40).intensity = 104;
  (*input) (29,40).intensity = 103;
  (*input) (30,40).intensity = 105;
  (*input) (31,40).intensity = 103;
  (*input) (32,40).intensity = 105;
  (*input) (33,40).intensity = 104;
  (*input) (34,40).intensity = 103;
  (*input) (35,40).intensity = 102;
  (*input) (36,40).intensity = 102;
  (*input) (37,40).intensity = 103;
  (*input) (38,40).intensity = 102;
  (*input) (39,40).intensity = 101;
  (*input) (40,40).intensity = 102;
  (*input) (41,40).intensity = 102;
  (*input) (42,40).intensity = 103;
  (*input) (43,40).intensity = 103;
  (*input) (44,40).intensity = 102;
  (*input) (45,40).intensity = 102;
  (*input) (46,40).intensity = 102;
  (*input) (47,40).intensity = 101;
  (*input) (48,40).intensity = 101;
  (*input) (49,40).intensity = 100;
  (*input) (50,40).intensity = 102;
  (*input) (51,40).intensity = 99;
  (*input) (52,40).intensity = 101;
  (*input) (53,40).intensity = 99;
  (*input) (54,40).intensity = 99;
  (*input) (55,40).intensity = 99;
  (*input) (56,40).intensity = 97;
  (*input) (57,40).intensity = 99;
  (*input) (58,40).intensity = 98;
  (*input) (59,40).intensity = 99;
  (*input) (60,40).intensity = 98;
  (*input) (61,40).intensity = 99;
  (*input) (62,40).intensity = 98;
  (*input) (63,40).intensity = 98;
  (*input) (0,41).intensity = 121;
  (*input) (1,41).intensity = 120;
  (*input) (2,41).intensity = 119;
  (*input) (3,41).intensity = 119;
  (*input) (4,41).intensity = 117;
  (*input) (5,41).intensity = 118;
  (*input) (6,41).intensity = 116;
  (*input) (7,41).intensity = 115;
  (*input) (8,41).intensity = 116;
  (*input) (9,41).intensity = 114;
  (*input) (10,41).intensity = 114;
  (*input) (11,41).intensity = 111;
  (*input) (12,41).intensity = 112;
  (*input) (13,41).intensity = 111;
  (*input) (14,41).intensity = 109;
  (*input) (15,41).intensity = 108;
  (*input) (16,41).intensity = 108;
  (*input) (17,41).intensity = 107;
  (*input) (18,41).intensity = 107;
  (*input) (19,41).intensity = 107;
  (*input) (20,41).intensity = 107;
  (*input) (21,41).intensity = 107;
  (*input) (22,41).intensity = 106;
  (*input) (23,41).intensity = 105;
  (*input) (24,41).intensity = 104;
  (*input) (25,41).intensity = 105;
  (*input) (26,41).intensity = 104;
  (*input) (27,41).intensity = 105;
  (*input) (28,41).intensity = 105;
  (*input) (29,41).intensity = 104;
  (*input) (30,41).intensity = 105;
  (*input) (31,41).intensity = 104;
  (*input) (32,41).intensity = 105;
  (*input) (33,41).intensity = 104;
  (*input) (34,41).intensity = 104;
  (*input) (35,41).intensity = 103;
  (*input) (36,41).intensity = 102;
  (*input) (37,41).intensity = 103;
  (*input) (38,41).intensity = 102;
  (*input) (39,41).intensity = 102;
  (*input) (40,41).intensity = 102;
  (*input) (41,41).intensity = 101;
  (*input) (42,41).intensity = 104;
  (*input) (43,41).intensity = 103;
  (*input) (44,41).intensity = 102;
  (*input) (45,41).intensity = 101;
  (*input) (46,41).intensity = 103;
  (*input) (47,41).intensity = 101;
  (*input) (48,41).intensity = 102;
  (*input) (49,41).intensity = 101;
  (*input) (50,41).intensity = 102;
  (*input) (51,41).intensity = 100;
  (*input) (52,41).intensity = 100;
  (*input) (53,41).intensity = 99;
  (*input) (54,41).intensity = 99;
  (*input) (55,41).intensity = 99;
  (*input) (56,41).intensity = 98;
  (*input) (57,41).intensity = 99;
  (*input) (58,41).intensity = 99;
  (*input) (59,41).intensity = 97;
  (*input) (60,41).intensity = 98;
  (*input) (61,41).intensity = 99;
  (*input) (62,41).intensity = 98;
  (*input) (63,41).intensity = 98;
  (*input) (0,42).intensity = 121;
  (*input) (1,42).intensity = 122;
  (*input) (2,42).intensity = 119;
  (*input) (3,42).intensity = 119;
  (*input) (4,42).intensity = 118;
  (*input) (5,42).intensity = 118;
  (*input) (6,42).intensity = 116;
  (*input) (7,42).intensity = 116;
  (*input) (8,42).intensity = 117;
  (*input) (9,42).intensity = 114;
  (*input) (10,42).intensity = 115;
  (*input) (11,42).intensity = 113;
  (*input) (12,42).intensity = 114;
  (*input) (13,42).intensity = 112;
  (*input) (14,42).intensity = 109;
  (*input) (15,42).intensity = 109;
  (*input) (16,42).intensity = 109;
  (*input) (17,42).intensity = 106;
  (*input) (18,42).intensity = 107;
  (*input) (19,42).intensity = 105;
  (*input) (20,42).intensity = 108;
  (*input) (21,42).intensity = 106;
  (*input) (22,42).intensity = 107;
  (*input) (23,42).intensity = 106;
  (*input) (24,42).intensity = 105;
  (*input) (25,42).intensity = 104;
  (*input) (26,42).intensity = 103;
  (*input) (27,42).intensity = 105;
  (*input) (28,42).intensity = 105;
  (*input) (29,42).intensity = 104;
  (*input) (30,42).intensity = 105;
  (*input) (31,42).intensity = 103;
  (*input) (32,42).intensity = 104;
  (*input) (33,42).intensity = 104;
  (*input) (34,42).intensity = 105;
  (*input) (35,42).intensity = 106;
  (*input) (36,42).intensity = 102;
  (*input) (37,42).intensity = 104;
  (*input) (38,42).intensity = 104;
  (*input) (39,42).intensity = 102;
  (*input) (40,42).intensity = 104;
  (*input) (41,42).intensity = 102;
  (*input) (42,42).intensity = 105;
  (*input) (43,42).intensity = 103;
  (*input) (44,42).intensity = 102;
  (*input) (45,42).intensity = 103;
  (*input) (46,42).intensity = 102;
  (*input) (47,42).intensity = 100;
  (*input) (48,42).intensity = 102;
  (*input) (49,42).intensity = 101;
  (*input) (50,42).intensity = 103;
  (*input) (51,42).intensity = 100;
  (*input) (52,42).intensity = 100;
  (*input) (53,42).intensity = 99;
  (*input) (54,42).intensity = 99;
  (*input) (55,42).intensity = 100;
  (*input) (56,42).intensity = 99;
  (*input) (57,42).intensity = 100;
  (*input) (58,42).intensity = 98;
  (*input) (59,42).intensity = 98;
  (*input) (60,42).intensity = 99;
  (*input) (61,42).intensity = 101;
  (*input) (62,42).intensity = 99;
  (*input) (63,42).intensity = 98;
  (*input) (0,43).intensity = 122;
  (*input) (1,43).intensity = 120;
  (*input) (2,43).intensity = 119;
  (*input) (3,43).intensity = 120;
  (*input) (4,43).intensity = 119;
  (*input) (5,43).intensity = 118;
  (*input) (6,43).intensity = 118;
  (*input) (7,43).intensity = 117;
  (*input) (8,43).intensity = 117;
  (*input) (9,43).intensity = 116;
  (*input) (10,43).intensity = 114;
  (*input) (11,43).intensity = 113;
  (*input) (12,43).intensity = 114;
  (*input) (13,43).intensity = 112;
  (*input) (14,43).intensity = 111;
  (*input) (15,43).intensity = 110;
  (*input) (16,43).intensity = 110;
  (*input) (17,43).intensity = 107;
  (*input) (18,43).intensity = 108;
  (*input) (19,43).intensity = 106;
  (*input) (20,43).intensity = 109;
  (*input) (21,43).intensity = 107;
  (*input) (22,43).intensity = 107;
  (*input) (23,43).intensity = 106;
  (*input) (24,43).intensity = 106;
  (*input) (25,43).intensity = 105;
  (*input) (26,43).intensity = 106;
  (*input) (27,43).intensity = 106;
  (*input) (28,43).intensity = 105;
  (*input) (29,43).intensity = 105;
  (*input) (30,43).intensity = 104;
  (*input) (31,43).intensity = 104;
  (*input) (32,43).intensity = 104;
  (*input) (33,43).intensity = 104;
  (*input) (34,43).intensity = 105;
  (*input) (35,43).intensity = 106;
  (*input) (36,43).intensity = 103;
  (*input) (37,43).intensity = 105;
  (*input) (38,43).intensity = 105;
  (*input) (39,43).intensity = 105;
  (*input) (40,43).intensity = 105;
  (*input) (41,43).intensity = 102;
  (*input) (42,43).intensity = 105;
  (*input) (43,43).intensity = 103;
  (*input) (44,43).intensity = 102;
  (*input) (45,43).intensity = 103;
  (*input) (46,43).intensity = 103;
  (*input) (47,43).intensity = 102;
  (*input) (48,43).intensity = 103;
  (*input) (49,43).intensity = 102;
  (*input) (50,43).intensity = 103;
  (*input) (51,43).intensity = 100;
  (*input) (52,43).intensity = 101;
  (*input) (53,43).intensity = 100;
  (*input) (54,43).intensity = 99;
  (*input) (55,43).intensity = 100;
  (*input) (56,43).intensity = 100;
  (*input) (57,43).intensity = 100;
  (*input) (58,43).intensity = 98;
  (*input) (59,43).intensity = 98;
  (*input) (60,43).intensity = 99;
  (*input) (61,43).intensity = 100;
  (*input) (62,43).intensity = 99;
  (*input) (63,43).intensity = 98;
  (*input) (0,44).intensity = 123;
  (*input) (1,44).intensity = 122;
  (*input) (2,44).intensity = 120;
  (*input) (3,44).intensity = 121;
  (*input) (4,44).intensity = 120;
  (*input) (5,44).intensity = 118;
  (*input) (6,44).intensity = 118;
  (*input) (7,44).intensity = 118;
  (*input) (8,44).intensity = 117;
  (*input) (9,44).intensity = 118;
  (*input) (10,44).intensity = 114;
  (*input) (11,44).intensity = 115;
  (*input) (12,44).intensity = 115;
  (*input) (13,44).intensity = 113;
  (*input) (14,44).intensity = 112;
  (*input) (15,44).intensity = 110;
  (*input) (16,44).intensity = 110;
  (*input) (17,44).intensity = 108;
  (*input) (18,44).intensity = 109;
  (*input) (19,44).intensity = 106;
  (*input) (20,44).intensity = 109;
  (*input) (21,44).intensity = 106;
  (*input) (22,44).intensity = 107;
  (*input) (23,44).intensity = 106;
  (*input) (24,44).intensity = 107;
  (*input) (25,44).intensity = 106;
  (*input) (26,44).intensity = 106;
  (*input) (27,44).intensity = 106;
  (*input) (28,44).intensity = 105;
  (*input) (29,44).intensity = 106;
  (*input) (30,44).intensity = 103;
  (*input) (31,44).intensity = 103;
  (*input) (32,44).intensity = 105;
  (*input) (33,44).intensity = 105;
  (*input) (34,44).intensity = 105;
  (*input) (35,44).intensity = 106;
  (*input) (36,44).intensity = 104;
  (*input) (37,44).intensity = 105;
  (*input) (38,44).intensity = 105;
  (*input) (39,44).intensity = 105;
  (*input) (40,44).intensity = 105;
  (*input) (41,44).intensity = 104;
  (*input) (42,44).intensity = 106;
  (*input) (43,44).intensity = 103;
  (*input) (44,44).intensity = 103;
  (*input) (45,44).intensity = 106;
  (*input) (46,44).intensity = 103;
  (*input) (47,44).intensity = 102;
  (*input) (48,44).intensity = 102;
  (*input) (49,44).intensity = 103;
  (*input) (50,44).intensity = 103;
  (*input) (51,44).intensity = 101;
  (*input) (52,44).intensity = 101;
  (*input) (53,44).intensity = 100;
  (*input) (54,44).intensity = 100;
  (*input) (55,44).intensity = 102;
  (*input) (56,44).intensity = 101;
  (*input) (57,44).intensity = 101;
  (*input) (58,44).intensity = 99;
  (*input) (59,44).intensity = 99;
  (*input) (60,44).intensity = 99;
  (*input) (61,44).intensity = 100;
  (*input) (62,44).intensity = 99;
  (*input) (63,44).intensity = 98;
  (*input) (0,45).intensity = 123;
  (*input) (1,45).intensity = 122;
  (*input) (2,45).intensity = 121;
  (*input) (3,45).intensity = 122;
  (*input) (4,45).intensity = 121;
  (*input) (5,45).intensity = 118;
  (*input) (6,45).intensity = 120;
  (*input) (7,45).intensity = 118;
  (*input) (8,45).intensity = 118;
  (*input) (9,45).intensity = 118;
  (*input) (10,45).intensity = 115;
  (*input) (11,45).intensity = 114;
  (*input) (12,45).intensity = 115;
  (*input) (13,45).intensity = 114;
  (*input) (14,45).intensity = 113;
  (*input) (15,45).intensity = 111;
  (*input) (16,45).intensity = 111;
  (*input) (17,45).intensity = 110;
  (*input) (18,45).intensity = 111;
  (*input) (19,45).intensity = 107;
  (*input) (20,45).intensity = 108;
  (*input) (21,45).intensity = 108;
  (*input) (22,45).intensity = 107;
  (*input) (23,45).intensity = 108;
  (*input) (24,45).intensity = 108;
  (*input) (25,45).intensity = 107;
  (*input) (26,45).intensity = 107;
  (*input) (27,45).intensity = 106;
  (*input) (28,45).intensity = 105;
  (*input) (29,45).intensity = 106;
  (*input) (30,45).intensity = 105;
  (*input) (31,45).intensity = 103;
  (*input) (32,45).intensity = 106;
  (*input) (33,45).intensity = 104;
  (*input) (34,45).intensity = 105;
  (*input) (35,45).intensity = 105;
  (*input) (36,45).intensity = 105;
  (*input) (37,45).intensity = 103;
  (*input) (38,45).intensity = 103;
  (*input) (39,45).intensity = 105;
  (*input) (40,45).intensity = 105;
  (*input) (41,45).intensity = 105;
  (*input) (42,45).intensity = 105;
  (*input) (43,45).intensity = 105;
  (*input) (44,45).intensity = 104;
  (*input) (45,45).intensity = 105;
  (*input) (46,45).intensity = 103;
  (*input) (47,45).intensity = 105;
  (*input) (48,45).intensity = 103;
  (*input) (49,45).intensity = 103;
  (*input) (50,45).intensity = 103;
  (*input) (51,45).intensity = 101;
  (*input) (52,45).intensity = 102;
  (*input) (53,45).intensity = 102;
  (*input) (54,45).intensity = 101;
  (*input) (55,45).intensity = 102;
  (*input) (56,45).intensity = 101;
  (*input) (57,45).intensity = 101;
  (*input) (58,45).intensity = 100;
  (*input) (59,45).intensity = 101;
  (*input) (60,45).intensity = 100;
  (*input) (61,45).intensity = 99;
  (*input) (62,45).intensity = 99;
  (*input) (63,45).intensity = 99;
  (*input) (0,46).intensity = 124;
  (*input) (1,46).intensity = 122;
  (*input) (2,46).intensity = 123;
  (*input) (3,46).intensity = 121;
  (*input) (4,46).intensity = 122;
  (*input) (5,46).intensity = 120;
  (*input) (6,46).intensity = 119;
  (*input) (7,46).intensity = 118;
  (*input) (8,46).intensity = 118;
  (*input) (9,46).intensity = 118;
  (*input) (10,46).intensity = 117;
  (*input) (11,46).intensity = 115;
  (*input) (12,46).intensity = 116;
  (*input) (13,46).intensity = 114;
  (*input) (14,46).intensity = 115;
  (*input) (15,46).intensity = 112;
  (*input) (16,46).intensity = 111;
  (*input) (17,46).intensity = 112;
  (*input) (18,46).intensity = 112;
  (*input) (19,46).intensity = 109;
  (*input) (20,46).intensity = 108;
  (*input) (21,46).intensity = 108;
  (*input) (22,46).intensity = 109;
  (*input) (23,46).intensity = 108;
  (*input) (24,46).intensity = 109;
  (*input) (25,46).intensity = 107;
  (*input) (26,46).intensity = 107;
  (*input) (27,46).intensity = 106;
  (*input) (28,46).intensity = 105;
  (*input) (29,46).intensity = 107;
  (*input) (30,46).intensity = 105;
  (*input) (31,46).intensity = 103;
  (*input) (32,46).intensity = 106;
  (*input) (33,46).intensity = 105;
  (*input) (34,46).intensity = 106;
  (*input) (35,46).intensity = 105;
  (*input) (36,46).intensity = 106;
  (*input) (37,46).intensity = 103;
  (*input) (38,46).intensity = 103;
  (*input) (39,46).intensity = 106;
  (*input) (40,46).intensity = 103;
  (*input) (41,46).intensity = 105;
  (*input) (42,46).intensity = 104;
  (*input) (43,46).intensity = 104;
  (*input) (44,46).intensity = 106;
  (*input) (45,46).intensity = 105;
  (*input) (46,46).intensity = 103;
  (*input) (47,46).intensity = 104;
  (*input) (48,46).intensity = 104;
  (*input) (49,46).intensity = 103;
  (*input) (50,46).intensity = 104;
  (*input) (51,46).intensity = 102;
  (*input) (52,46).intensity = 101;
  (*input) (53,46).intensity = 102;
  (*input) (54,46).intensity = 102;
  (*input) (55,46).intensity = 103;
  (*input) (56,46).intensity = 102;
  (*input) (57,46).intensity = 102;
  (*input) (58,46).intensity = 103;
  (*input) (59,46).intensity = 101;
  (*input) (60,46).intensity = 100;
  (*input) (61,46).intensity = 100;
  (*input) (62,46).intensity = 102;
  (*input) (63,46).intensity = 100;
  (*input) (0,47).intensity = 123;
  (*input) (1,47).intensity = 122;
  (*input) (2,47).intensity = 122;
  (*input) (3,47).intensity = 122;
  (*input) (4,47).intensity = 122;
  (*input) (5,47).intensity = 120;
  (*input) (6,47).intensity = 120;
  (*input) (7,47).intensity = 119;
  (*input) (8,47).intensity = 120;
  (*input) (9,47).intensity = 118;
  (*input) (10,47).intensity = 118;
  (*input) (11,47).intensity = 117;
  (*input) (12,47).intensity = 116;
  (*input) (13,47).intensity = 116;
  (*input) (14,47).intensity = 116;
  (*input) (15,47).intensity = 114;
  (*input) (16,47).intensity = 113;
  (*input) (17,47).intensity = 114;
  (*input) (18,47).intensity = 112;
  (*input) (19,47).intensity = 109;
  (*input) (20,47).intensity = 109;
  (*input) (21,47).intensity = 109;
  (*input) (22,47).intensity = 108;
  (*input) (23,47).intensity = 109;
  (*input) (24,47).intensity = 109;
  (*input) (25,47).intensity = 107;
  (*input) (26,47).intensity = 107;
  (*input) (27,47).intensity = 107;
  (*input) (28,47).intensity = 106;
  (*input) (29,47).intensity = 107;
  (*input) (30,47).intensity = 107;
  (*input) (31,47).intensity = 105;
  (*input) (32,47).intensity = 106;
  (*input) (33,47).intensity = 105;
  (*input) (34,47).intensity = 106;
  (*input) (35,47).intensity = 105;
  (*input) (36,47).intensity = 107;
  (*input) (37,47).intensity = 104;
  (*input) (38,47).intensity = 104;
  (*input) (39,47).intensity = 106;
  (*input) (40,47).intensity = 104;
  (*input) (41,47).intensity = 102;
  (*input) (42,47).intensity = 105;
  (*input) (43,47).intensity = 104;
  (*input) (44,47).intensity = 105;
  (*input) (45,47).intensity = 105;
  (*input) (46,47).intensity = 104;
  (*input) (47,47).intensity = 103;
  (*input) (48,47).intensity = 105;
  (*input) (49,47).intensity = 103;
  (*input) (50,47).intensity = 105;
  (*input) (51,47).intensity = 102;
  (*input) (52,47).intensity = 101;
  (*input) (53,47).intensity = 103;
  (*input) (54,47).intensity = 104;
  (*input) (55,47).intensity = 104;
  (*input) (56,47).intensity = 102;
  (*input) (57,47).intensity = 101;
  (*input) (58,47).intensity = 101;
  (*input) (59,47).intensity = 100;
  (*input) (60,47).intensity = 101;
  (*input) (61,47).intensity = 100;
  (*input) (62,47).intensity = 98;
  (*input) (63,47).intensity = 96;
  testing::InitGoogleTest (&argc, argv);
  return (RUN_ALL_TESTS ());
}
