#!/usr/bin/env python

# Copyright (c) 2009 Google Inc. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

"""
Verifies simple actions when using an explicit build target of 'all'.
"""

import TestGyp

test = TestGyp.TestGyp()

test.run_gyp('all.gyp', chdir='src')
test.relocate('src', 'relocate/src')

# Build all.
test.build('all.gyp', chdir='relocate/src')

if test.format=='xcode':
  chdir = 'relocate/src/dir1'
else:
  chdir = 'relocate/src'

# Output is as expected.
file_content = 'Hello from emit.py\n'
test.built_file_must_match('out2.txt', file_content, chdir=chdir)

test.built_file_must_not_exist('out.txt', chdir='relocate/src')
test.built_file_must_not_exist('lib1.dll', chdir='relocate/src')

# TODO(mmoss) Make consistent with scons, with 'dir1' before 'out/Default'?
if test.format == 'make':
  chdir='relocate/src'
else:
  chdir='relocate/src/dir1'

# Build the action explicitly.
test.build('actions.gyp', 'action1_target', chdir=chdir)

# Check that things got run.
file_content = 'Hello from emit.py\n'
test.built_file_must_exist('out.txt', chdir=chdir)

# Build the shared library explicitly.
test.build('actions.gyp', 'foolib1', chdir=chdir)

if test.format == 'make':
  # TODO(mmoss) Make consistent with scons, with 'dir1' before 'out/Default'?
  test.must_exist('relocate/src/out/Default/lib.target/dir1/'
                  + test.dll_ + 'foolib1' + test._dll)
else:
  test.built_file_must_exist('foolib1',
                             type=test.SHARED_LIB,
                             chdir=chdir)

test.pass_test()
