sub CreateLink()
{
	my $Link = '';
	foreach my $Key ( $cgi->param() )
	{
		$Link .= $Key.'='.url_encode( $cgi->param( $Key ) ).'&amp;';
	}

	return $Link;
}

sub PageNav_Init()
{
	  # By default, display 'by_page' alerts per page,
	  # starting from the first page, in reverse order :
	if ( ! defined( $cgi->param( 'page_num' ) ) ) {$cgi->param( 'page_num', 0 );};
	$cgi->param( 'page_num', int( $cgi->param( 'page_num' ) ) );

	if ( ( ! $cgi->param( 'by_page' ) ) || ($cgi->param( 'by_page' ) !~ m/^\d+$/) )
	{
		$cgi->param( 'by_page', $conf{'nb_resbypage'} );
	}
	else
	{
		$cgi->param( 'by_page', int( $cgi->param( 'by_page' ) ) || $conf{'nb_resbypage'} );
	}

	if ( ! defined( $cgi->param( 'desc' ) ) ) {$cgi->param( 'desc', '' );};
}

sub AlertList($)
{
	my $Filter = shift;

	my $Statement_L = $Filter->SQL_EltList();

	debug( "Res: $Statement_L" );

	my $Sth = $dbh->prepare( $Statement_L );
	LIMIT_values( $Sth, $cgi->param( 'by_page' ), $cgi->param( 'page_num' )*$cgi->param( 'by_page' ) );
	$Sth->execute() || debug( 'SQL Error : '.$dbh->errstr );

	my %KeyDisplayed = ();
	my %KeyOutput = ();

	my $AlertDisplayedNb = 0;
	my @DisplayList = ();

	while( our $AlertId = $Sth->fetchrow_array() )
	{
		our %Cache = ();

		local *TEMP;
		open( TEMP, '>generated/tmp_'.$ENV{'REMOTE_ADDR'} ) || 
			debug( 'ERROR : '.$! );
		select( TEMP );
		ParseComponent( 'AlertList_Body' );
		select( STDOUT );
		close( TEMP );

		open( TEMP, '<generated/tmp_'.$ENV{'REMOTE_ADDR'} ) ||
			debug( 'ERROR : '.$! );
		while( my $Line = <TEMP> )
		{
			if ( $KeyOutput{$AlertId} )
			{
				$KeyOutput{$AlertId} .= $Line;
			}
			else
			{
				$KeyOutput{$AlertId} = $Line;
			}
		}
		close( TEMP );

		push @DisplayList, $AlertId;

		$AlertDisplayedNb ++;
	}
	$Sth->finish();

	my $DisplayCnt = 0;

	if ( $cgi->param( 'sortby' ) eq 'groupkey' )
	{
		@DisplayList = sort @DisplayList;
	}

	my @Styles = ( 'odd', 'even' );
	foreach my $AlertKey ( @DisplayList )
	{
		if ( $DisplayCnt < $cgi->param( 'by_page' ) )
		{
			my $Style = " class=\"".( $Styles[$DisplayCnt % ( $#Styles + 1 ) ] )."\"";
			$KeyOutput{$AlertKey} =~ s/STYLE_HERE/$Style/mg;

			print $KeyOutput{$AlertKey};

			$DisplayCnt ++;
		}
	}

	unlink( 'generated/tmp_'.$ENV{'REMOTE_ADDR'} );
}

###########################################################################

sub FilterEdit_Link()
{
	if ( $cgi->param( 'mode' ) ne 'edit' )
	{
		if ( $cgi->param( 'load' ) )
		{
			print "<a href=\"Filters".$conf{'extension'}.'?mode=edit&amp;load='.url_encode( $cgi->param( 'load' ) );
			foreach my $Key ( $cgi->param() )
			{
				if ( $Key =~ m/^val([A-Z])$/ )
				{
					my $val = $1;
					print '&amp;val'.$val.'='.url_encode( $cgi->param( 'val'.$val ) );
				}
			}
			print "\" target=_top>Edit current filter</a>";

			return 1;
		}
	}

	print 'Edit current filter';

	return 0;
}

sub Statistics_Link()
{
	if ( $cgi->param( 'mode' ) ne 'edit' )
	{
		if ( $cgi->param( 'load' ) )
		{
			if ( $cgi->param( 'load' ) !~ m/^defaults\// )
			{
				print "<a href=\"Stats".$conf{'extension'}.'?load='.url_encode( $cgi->param( 'load' ) );
				print "\" target=_top>Statistics</a>";

				return 1;
			}
		}
	}

	print 'Statistics';

	return 0;
}

###########################################################################

sub ValueInput($)
{
	my $Index = shift;

	print "<input type=text name=\"Value_".$Index."\" value=\"".$cgi->param( 'Value_'.$Index )."\">\n";
}

sub TableList($)
{
	my $Index = shift;

	print "<select name=\"Table_$Index\">\n";

	foreach my $Table ( sort keys %db_table_type )
	{
		if ( int( $db_table_type{$Table} ) > 1 )
		{
			print "  <option value=\"$Table\"";
			if ( $cgi->param( 'Table_'.$Index ) eq $Table ) {print ' selected';};
			print ">$Table\n";
		}
	}

	print "</select>\n";
	print "<input type=text name=\"Field_$Index\" value=\"".( $cgi->param( 'Field_'.$Index ) )."\">\n";
}

sub OperatorList($)
{
	my $Index = shift;

	my %OpList = ();
	(%OpList) = (%OpList,'=','equals to');
	(%OpList) = (%OpList,'!=','differs from');
	(%OpList) = (%OpList,'>','is greater than');
	(%OpList) = (%OpList,'<','is lower than');
	(%OpList) = (%OpList,'>=','is greater or equal');
	(%OpList) = (%OpList,'<=','is lower or equal');
	(%OpList) = (%OpList,'S','starts with');
	(%OpList) = (%OpList,'C','contains');
	(%OpList) = (%OpList,'E','ends with');
	(%OpList) = (%OpList,'M','matches (% as wildcard)');

	print "<select name=\"Operator_".$Index."\">\n";
	foreach my $Op ( '=','!=','>','<','>=','<=','S','C','E','M' )
	{
		print "  <option value=\"".$Op."\"";
		if ( $Op eq $cgi->param( 'Operator_'.$Index ) ) {print ' selected';};
		print "> ($Op) $OpList{$Op}\n";
	}
	print "</select>\n";
}

sub GroupBy($)
{
	my $crit = shift;

	if ( $cgi->param( 'groupby' ) =~ m/$crit/ ) {print ' selected';};
}

sub Page_Navigation($$$$)
{
	my $Current_Page_Num = shift;
	my $ResNb_by_Page = shift;
	my $TotalResultNb = shift;

	my $Show_ResNb = shift;

	my $PageNb = $TotalResultNb / $ResNb_by_Page;
	if ( $PageNb ne int( $PageNb ) ) {$PageNb = int( $PageNb ) + 1;};

	print "<center>";

	if ( $Show_ResNb )
	{
		print "$TotalResultNb results for those filters.";
		print " Page ".( $Current_Page_Num + 1 )."/$PageNb.";
	}

	if ( $TotalResultNb >= $ResNb_by_Page )
	{
		print "<table class=\"bordered\" width=\"30%\"><tr>";

		my %done;
		foreach my $i ( 0, ( $Current_Page_Num - 1 ), ( $Current_Page_Num + 1 ), $PageNb - 1 )
		{
			if ( ! exists( $done{$i} ) )
			{
				  # Set this for CreateLink :
				$cgi->param( 'page_num', $i );

				my ( $Link_Start, $Link_End ) = ( '', '' );

				if ( ( $i ne $Current_Page_Num ) and  ( $i >= 0 ) and ( $i < $PageNb ) )
				{
					$Link_Start = "<a href=\"?".CreateLink()."\">";
					$Link_End = '</a>';
				}

				#

				my @List = ();

				if ( $i eq 0 ) {push @List, 'First';};
				if ( $i eq ( $Current_Page_Num - 1 ) ) {push @List, 'Prev';};
				if ( $i eq ( $Current_Page_Num + 1 ) ) {push @List, 'Next';};
				if ( $i eq ( $PageNb - 1 ) ) {push @List, 'Last';};

				foreach my $elt ( @List )
				{
					print '<td align=center>';
					print $Link_Start;
					print $elt;
					print $Link_End;
					print '</td>';
				}
				$done{$i} = 1;
			}
		}
		print '</tr></table>';

		  # Restore initial value :
		$cgi->param( 'page_num', $Current_Page_Num );
	}

	print '</center><br/>';
}

1;
