/* Copyright (c) 2001-2007, David A. Clunie DBA Pixelmed Publishing. All rights reserved. */

// Automatically generated from template - EDITS WILL BE LOST

package com.pixelmed.dicom;

import java.util.HashMap;
import java.util.TreeSet;
import java.util.Iterator;

/**
 * <p>The {@link com.pixelmed.dicom.DicomDictionary DicomDictionary} class
 * is a complete standard dictionary of DICOM attributes and associated information.</p>
 *
 * <p>The accessor methods that an application would normally use are defined in the
 * {@link com.pixelmed.dicom.DicomDictionaryBase DicomDictionaryBase} class.</p>
 *
 * @author	dclunie
 */

public class DicomDictionary extends DicomDictionaryBase {

	private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DicomDictionary.java,v 1.131 2015/11/16 18:07:05 dclunie Exp $";

	protected void createTagList() {

		tagList = new TreeSet();	// sorted, based on AttributeTag's implementation of Comparable

		tagList.add(TagFromName.CommandGroupLength);
		tagList.add(TagFromName.CommandLengthToEnd);
		tagList.add(TagFromName.AffectedSOPClassUID);
		tagList.add(TagFromName.RequestedSOPClassUID);
		tagList.add(TagFromName.CommandRecognitionCode);
		tagList.add(TagFromName.CommandField);
		tagList.add(TagFromName.MessageID);
		tagList.add(TagFromName.MessageIDBeingRespondedTo);
		tagList.add(TagFromName.Initiator);
		tagList.add(TagFromName.Receiver);
		tagList.add(TagFromName.FindLocation);
		tagList.add(TagFromName.MoveDestination);
		tagList.add(TagFromName.Priority);
		tagList.add(TagFromName.CommandDataSetType);
		tagList.add(TagFromName.NumberOfMatches);
		tagList.add(TagFromName.ResponseSequenceNumber);
		tagList.add(TagFromName.Status);
		tagList.add(TagFromName.OffendingElement);
		tagList.add(TagFromName.ErrorComment);
		tagList.add(TagFromName.ErrorID);
		tagList.add(TagFromName.AffectedSOPInstanceUID);
		tagList.add(TagFromName.RequestedSOPInstanceUID);
		tagList.add(TagFromName.EventTypeID);
		tagList.add(TagFromName.AttributeIdentifierList);
		tagList.add(TagFromName.ActionTypeID);
		tagList.add(TagFromName.NumberOfRemainingSuboperations);
		tagList.add(TagFromName.NumberOfCompletedSuboperations);
		tagList.add(TagFromName.NumberOfFailedSuboperations);
		tagList.add(TagFromName.NumberOfWarningSuboperations);
		tagList.add(TagFromName.MoveOriginatorApplicationEntityTitle);
		tagList.add(TagFromName.MoveOriginatorMessageID);
		tagList.add(TagFromName.DialogReceiver);
		tagList.add(TagFromName.TerminalType);
		tagList.add(TagFromName.MessageSetID);
		tagList.add(TagFromName.EndMessageID);
		tagList.add(TagFromName.DisplayFormat);
		tagList.add(TagFromName.PagePositionID);
		tagList.add(TagFromName.TextFormatID);
		tagList.add(TagFromName.NormalReverse);
		tagList.add(TagFromName.AddGrayScale);
		tagList.add(TagFromName.Borders);
		tagList.add(TagFromName.Copies);
		tagList.add(TagFromName.CommandMagnificationType);
		tagList.add(TagFromName.Erase);
		tagList.add(TagFromName.Print);
		tagList.add(TagFromName.Overlays);
		tagList.add(TagFromName.FileMetaInformationGroupLength);
		tagList.add(TagFromName.FileMetaInformationVersion);
		tagList.add(TagFromName.MediaStorageSOPClassUID);
		tagList.add(TagFromName.MediaStorageSOPInstanceUID);
		tagList.add(TagFromName.TransferSyntaxUID);
		tagList.add(TagFromName.ImplementationClassUID);
		tagList.add(TagFromName.ImplementationVersionName);
		tagList.add(TagFromName.SourceApplicationEntityTitle);
		tagList.add(TagFromName.SendingApplicationEntityTitle);
		tagList.add(TagFromName.ReceivingApplicationEntityTitle);
		tagList.add(TagFromName.PrivateInformationCreatorUID);
		tagList.add(TagFromName.PrivateInformation);
		tagList.add(TagFromName.FileSetID);
		tagList.add(TagFromName.FileSetDescriptorFileID);
		tagList.add(TagFromName.SpecificCharacterSetOfFileSetDescriptorFile);
		tagList.add(TagFromName.OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity);
		tagList.add(TagFromName.OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity);
		tagList.add(TagFromName.FileSetConsistencyFlag);
		tagList.add(TagFromName.DirectoryRecordSequence);
		tagList.add(TagFromName.OffsetOfTheNextDirectoryRecord);
		tagList.add(TagFromName.RecordInUseFlag);
		tagList.add(TagFromName.OffsetOfReferencedLowerLevelDirectoryEntity);
		tagList.add(TagFromName.DirectoryRecordType);
		tagList.add(TagFromName.PrivateRecordUID);
		tagList.add(TagFromName.ReferencedFileID);
		tagList.add(TagFromName.MRDRDirectoryRecordOffset);
		tagList.add(TagFromName.ReferencedSOPClassUIDInFile);
		tagList.add(TagFromName.ReferencedSOPInstanceUIDInFile);
		tagList.add(TagFromName.ReferencedTransferSyntaxUIDInFile);
		tagList.add(TagFromName.ReferencedRelatedGeneralSOPClassUIDInFile);
		tagList.add(TagFromName.NumberOfReferences);
		tagList.add(TagFromName.LengthToEnd);
		tagList.add(TagFromName.SpecificCharacterSet);
		tagList.add(TagFromName.LanguageCodeSequence);
		tagList.add(TagFromName.ImageType);
		tagList.add(TagFromName.RecognitionCode);
		tagList.add(TagFromName.InstanceCreationDate);
		tagList.add(TagFromName.InstanceCreationTime);
		tagList.add(TagFromName.InstanceCreatorUID);
		tagList.add(TagFromName.InstanceCoercionDateTime);
		tagList.add(TagFromName.SOPClassUID);
		tagList.add(TagFromName.SOPInstanceUID);
		tagList.add(TagFromName.RelatedGeneralSOPClassUID);
		tagList.add(TagFromName.OriginalSpecializedSOPClassUID);
		tagList.add(TagFromName.StudyDate);
		tagList.add(TagFromName.SeriesDate);
		tagList.add(TagFromName.AcquisitionDate);
		tagList.add(TagFromName.ContentDate);
		tagList.add(TagFromName.OverlayDate);
		tagList.add(TagFromName.CurveDate);
		tagList.add(TagFromName.AcquisitionDateTime);
		tagList.add(TagFromName.StudyTime);
		tagList.add(TagFromName.SeriesTime);
		tagList.add(TagFromName.AcquisitionTime);
		tagList.add(TagFromName.ContentTime);
		tagList.add(TagFromName.OverlayTime);
		tagList.add(TagFromName.CurveTime);
		tagList.add(TagFromName.DataSetType);
		tagList.add(TagFromName.DataSetSubtype);
		tagList.add(TagFromName.NuclearMedicineSeriesType);
		tagList.add(TagFromName.AccessionNumber);
		tagList.add(TagFromName.IssuerOfAccessionNumberSequence);
		tagList.add(TagFromName.QueryRetrieveLevel);
		tagList.add(TagFromName.QueryRetrieveView);
		tagList.add(TagFromName.RetrieveAETitle);
		tagList.add(TagFromName.InstanceAvailability);
		tagList.add(TagFromName.FailedSOPInstanceUIDList);
		tagList.add(TagFromName.Modality);
		tagList.add(TagFromName.ModalitiesInStudy);
		tagList.add(TagFromName.SOPClassesInStudy);
		tagList.add(TagFromName.ConversionType);
		tagList.add(TagFromName.PresentationIntentType);
		tagList.add(TagFromName.Manufacturer);
		tagList.add(TagFromName.InstitutionName);
		tagList.add(TagFromName.InstitutionAddress);
		tagList.add(TagFromName.InstitutionCodeSequence);
		tagList.add(TagFromName.ReferringPhysicianName);
		tagList.add(TagFromName.ReferringPhysicianAddress);
		tagList.add(TagFromName.ReferringPhysicianTelephoneNumbers);
		tagList.add(TagFromName.ReferringPhysicianIdentificationSequence);
		tagList.add(TagFromName.ConsultingPhysicianName);
		tagList.add(TagFromName.ConsultingPhysicianIdentificationSequence);
		tagList.add(TagFromName.CodeValue);
		tagList.add(TagFromName.ExtendedCodeValue);
		tagList.add(TagFromName.CodingSchemeDesignator);
		tagList.add(TagFromName.CodingSchemeVersion);
		tagList.add(TagFromName.CodeMeaning);
		tagList.add(TagFromName.MappingResource);
		tagList.add(TagFromName.ContextGroupVersion);
		tagList.add(TagFromName.ContextGroupLocalVersion);
		tagList.add(TagFromName.ExtendedCodeMeaning);
		tagList.add(TagFromName.ContextGroupExtensionFlag);
		tagList.add(TagFromName.CodingSchemeUID);
		tagList.add(TagFromName.ContextGroupExtensionCreatorUID);
		tagList.add(TagFromName.ContextIdentifier);
		tagList.add(TagFromName.CodingSchemeIdentificationSequence);
		tagList.add(TagFromName.CodingSchemeRegistry);
		tagList.add(TagFromName.CodingSchemeExternalID);
		tagList.add(TagFromName.CodingSchemeName);
		tagList.add(TagFromName.CodingSchemeResponsibleOrganization);
		tagList.add(TagFromName.ContextUID);
		tagList.add(TagFromName.MappingResourceUID);
		tagList.add(TagFromName.LongCodeValue);
		tagList.add(TagFromName.URNCodeValue);
		tagList.add(TagFromName.EquivalentCodeSequence);
		tagList.add(TagFromName.TimezoneOffsetFromUTC);
		tagList.add(TagFromName.PrivateDataElementCharacteristicsSequence);
		tagList.add(TagFromName.PrivateGroupReference);
		tagList.add(TagFromName.PrivateCreatorReference);
		tagList.add(TagFromName.BlockIdentifyingInformationStatus);
		tagList.add(TagFromName.NonidentifyingPrivateElements);
		tagList.add(TagFromName.DeidentificationActionSequence);
		tagList.add(TagFromName.IdentifyingPrivateElements);
		tagList.add(TagFromName.DeidentificationAction);
		tagList.add(TagFromName.NetworkID);
		tagList.add(TagFromName.StationName);
		tagList.add(TagFromName.StudyDescription);
		tagList.add(TagFromName.ProcedureCodeSequence);
		tagList.add(TagFromName.SeriesDescription);
		tagList.add(TagFromName.SeriesDescriptionCodeSequence);
		tagList.add(TagFromName.InstitutionalDepartmentName);
		tagList.add(TagFromName.PhysiciansOfRecord);
		tagList.add(TagFromName.PhysiciansOfRecordIdentificationSequence);
		tagList.add(TagFromName.PerformingPhysicianName);
		tagList.add(TagFromName.PerformingPhysicianIdentificationSequence);
		tagList.add(TagFromName.NameOfPhysiciansReadingStudy);
		tagList.add(TagFromName.PhysiciansReadingStudyIdentificationSequence);
		tagList.add(TagFromName.OperatorsName);
		tagList.add(TagFromName.OperatorIdentificationSequence);
		tagList.add(TagFromName.AdmittingDiagnosesDescription);
		tagList.add(TagFromName.AdmittingDiagnosesCodeSequence);
		tagList.add(TagFromName.ManufacturerModelName);
		tagList.add(TagFromName.ReferencedResultsSequence);
		tagList.add(TagFromName.ReferencedStudySequence);
		tagList.add(TagFromName.ReferencedPerformedProcedureStepSequence);
		tagList.add(TagFromName.ReferencedSeriesSequence);
		tagList.add(TagFromName.ReferencedPatientSequence);
		tagList.add(TagFromName.ReferencedVisitSequence);
		tagList.add(TagFromName.ReferencedOverlaySequence);
		tagList.add(TagFromName.ReferencedStereometricInstanceSequence);
		tagList.add(TagFromName.ReferencedWaveformSequence);
		tagList.add(TagFromName.ReferencedImageSequence);
		tagList.add(TagFromName.ReferencedCurveSequence);
		tagList.add(TagFromName.ReferencedInstanceSequence);
		tagList.add(TagFromName.ReferencedRealWorldValueMappingInstanceSequence);
		tagList.add(TagFromName.ReferencedSOPClassUID);
		tagList.add(TagFromName.ReferencedSOPInstanceUID);
		tagList.add(TagFromName.SOPClassesSupported);
		tagList.add(TagFromName.ReferencedFrameNumber);
		tagList.add(TagFromName.SimpleFrameList);
		tagList.add(TagFromName.CalculatedFrameList);
		tagList.add(TagFromName.TimeRange);
		tagList.add(TagFromName.FrameExtractionSequence);
		tagList.add(TagFromName.MultiFrameSourceSOPInstanceUID);
		tagList.add(TagFromName.RetrieveURL);
		tagList.add(TagFromName.TransactionUID);
		tagList.add(TagFromName.WarningReason);
		tagList.add(TagFromName.FailureReason);
		tagList.add(TagFromName.FailedSOPSequence);
		tagList.add(TagFromName.ReferencedSOPSequence);
		tagList.add(TagFromName.OtherFailuresSequence);
		tagList.add(TagFromName.StudiesContainingOtherReferencedInstancesSequence);
		tagList.add(TagFromName.RelatedSeriesSequence);
		tagList.add(TagFromName.LossyImageCompressionRetired);
		tagList.add(TagFromName.DerivationDescription);
		tagList.add(TagFromName.SourceImageSequence);
		tagList.add(TagFromName.StageName);
		tagList.add(TagFromName.StageNumber);
		tagList.add(TagFromName.NumberOfStages);
		tagList.add(TagFromName.ViewName);
		tagList.add(TagFromName.ViewNumber);
		tagList.add(TagFromName.NumberOfEventTimers);
		tagList.add(TagFromName.NumberOfViewsInStage);
		tagList.add(TagFromName.EventElapsedTimes);
		tagList.add(TagFromName.EventTimerNames);
		tagList.add(TagFromName.EventTimerSequence);
		tagList.add(TagFromName.EventTimeOffset);
		tagList.add(TagFromName.EventCodeSequence);
		tagList.add(TagFromName.StartTrim);
		tagList.add(TagFromName.StopTrim);
		tagList.add(TagFromName.RecommendedDisplayFrameRate);
		tagList.add(TagFromName.TransducerPosition);
		tagList.add(TagFromName.TransducerOrientation);
		tagList.add(TagFromName.AnatomicStructure);
		tagList.add(TagFromName.AnatomicRegionSequence);
		tagList.add(TagFromName.AnatomicRegionModifierSequence);
		tagList.add(TagFromName.PrimaryAnatomicStructureSequence);
		tagList.add(TagFromName.AnatomicStructureSpaceOrRegionSequence);
		tagList.add(TagFromName.PrimaryAnatomicStructureModifierSequence);
		tagList.add(TagFromName.TransducerPositionSequence);
		tagList.add(TagFromName.TransducerPositionModifierSequence);
		tagList.add(TagFromName.TransducerOrientationSequence);
		tagList.add(TagFromName.TransducerOrientationModifierSequence);
		tagList.add(TagFromName.AnatomicStructureSpaceOrRegionCodeSequenceTrial);
		tagList.add(TagFromName.AnatomicPortalOfEntranceCodeSequenceTrial);
		tagList.add(TagFromName.AnatomicApproachDirectionCodeSequenceTrial);
		tagList.add(TagFromName.AnatomicPerspectiveDescriptionTrial);
		tagList.add(TagFromName.AnatomicPerspectiveCodeSequenceTrial);
		tagList.add(TagFromName.AnatomicLocationOfExaminingInstrumentDescriptionTrial);
		tagList.add(TagFromName.AnatomicLocationOfExaminingInstrumentCodeSequenceTrial);
		tagList.add(TagFromName.AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial);
		tagList.add(TagFromName.OnAxisBackgroundAnatomicStructureCodeSequenceTrial);
		tagList.add(TagFromName.AlternateRepresentationSequence);
		tagList.add(TagFromName.IrradiationEventUID);
		tagList.add(TagFromName.SourceIrradiationEventSequence);
		tagList.add(TagFromName.RadiopharmaceuticalAdministrationEventUID);
		tagList.add(TagFromName.IdentifyingComments);
		tagList.add(TagFromName.FrameType);
		tagList.add(TagFromName.ReferencedImageEvidenceSequence);
		tagList.add(TagFromName.ReferencedRawDataSequence);
		tagList.add(TagFromName.CreatorVersionUID);
		tagList.add(TagFromName.DerivationImageSequence);
		tagList.add(TagFromName.SourceImageEvidenceSequence);
		tagList.add(TagFromName.PixelPresentation);
		tagList.add(TagFromName.VolumetricProperties);
		tagList.add(TagFromName.VolumeBasedCalculationTechnique);
		tagList.add(TagFromName.ComplexImageComponent);
		tagList.add(TagFromName.AcquisitionContrast);
		tagList.add(TagFromName.DerivationCodeSequence);
		tagList.add(TagFromName.ReferencedPresentationStateSequence);
		tagList.add(TagFromName.ReferencedOtherPlaneSequence);
		tagList.add(TagFromName.FrameDisplaySequence);
		tagList.add(TagFromName.RecommendedDisplayFrameRateInFloat);
		tagList.add(TagFromName.SkipFrameRangeFlag);
		tagList.add(TagFromName.PatientName);
		tagList.add(TagFromName.PatientID);
		tagList.add(TagFromName.IssuerOfPatientID);
		tagList.add(TagFromName.TypeOfPatientID);
		tagList.add(TagFromName.IssuerOfPatientIDQualifiersSequence);
		tagList.add(TagFromName.SourcePatientGroupIdentificationSequence);
		tagList.add(TagFromName.GroupOfPatientsIdentificationSequence);
		tagList.add(TagFromName.SubjectRelativePositionInImage);
		tagList.add(TagFromName.PatientBirthDate);
		tagList.add(TagFromName.PatientBirthTime);
		tagList.add(TagFromName.PatientSex);
		tagList.add(TagFromName.PatientInsurancePlanCodeSequence);
		tagList.add(TagFromName.PatientPrimaryLanguageCodeSequence);
		tagList.add(TagFromName.PatientPrimaryLanguageModifierCodeSequence);
		tagList.add(TagFromName.QualityControlSubject);
		tagList.add(TagFromName.QualityControlSubjectTypeCodeSequence);
		tagList.add(TagFromName.StrainDescription);
		tagList.add(TagFromName.StrainNomenclature);
		tagList.add(TagFromName.StrainStockNumber);
		tagList.add(TagFromName.StrainSourceRegistryCodeSequence);
		tagList.add(TagFromName.StrainStockSequence);
		tagList.add(TagFromName.StrainSource);
		tagList.add(TagFromName.StrainAdditionalInformation);
		tagList.add(TagFromName.StrainCodeSequence);
		tagList.add(TagFromName.OtherPatientIDs);
		tagList.add(TagFromName.OtherPatientNames);
		tagList.add(TagFromName.OtherPatientIDsSequence);
		tagList.add(TagFromName.PatientBirthName);
		tagList.add(TagFromName.PatientAge);
		tagList.add(TagFromName.PatientSize);
		tagList.add(TagFromName.PatientSizeCodeSequence);
		tagList.add(TagFromName.PatientWeight);
		tagList.add(TagFromName.PatientAddress);
		tagList.add(TagFromName.InsurancePlanIdentification);
		tagList.add(TagFromName.PatientMotherBirthName);
		tagList.add(TagFromName.MilitaryRank);
		tagList.add(TagFromName.BranchOfService);
		tagList.add(TagFromName.MedicalRecordLocator);
		tagList.add(TagFromName.ReferencedPatientPhotoSequence);
		tagList.add(TagFromName.MedicalAlerts);
		tagList.add(TagFromName.Allergies);
		tagList.add(TagFromName.CountryOfResidence);
		tagList.add(TagFromName.RegionOfResidence);
		tagList.add(TagFromName.PatientTelephoneNumbers);
		tagList.add(TagFromName.PatientTelecomInformation);
		tagList.add(TagFromName.EthnicGroup);
		tagList.add(TagFromName.Occupation);
		tagList.add(TagFromName.SmokingStatus);
		tagList.add(TagFromName.AdditionalPatientHistory);
		tagList.add(TagFromName.PregnancyStatus);
		tagList.add(TagFromName.LastMenstrualDate);
		tagList.add(TagFromName.PatientReligiousPreference);
		tagList.add(TagFromName.PatientSpeciesDescription);
		tagList.add(TagFromName.PatientSpeciesCodeSequence);
		tagList.add(TagFromName.PatientSexNeutered);
		tagList.add(TagFromName.AnatomicalOrientationType);
		tagList.add(TagFromName.PatientBreedDescription);
		tagList.add(TagFromName.PatientBreedCodeSequence);
		tagList.add(TagFromName.BreedRegistrationSequence);
		tagList.add(TagFromName.BreedRegistrationNumber);
		tagList.add(TagFromName.BreedRegistryCodeSequence);
		tagList.add(TagFromName.ResponsiblePerson);
		tagList.add(TagFromName.ResponsiblePersonRole);
		tagList.add(TagFromName.ResponsibleOrganization);
		tagList.add(TagFromName.PatientComments);
		tagList.add(TagFromName.ExaminedBodyThickness);
		tagList.add(TagFromName.ClinicalTrialSponsorName);
		tagList.add(TagFromName.ClinicalTrialProtocolID);
		tagList.add(TagFromName.ClinicalTrialProtocolName);
		tagList.add(TagFromName.ClinicalTrialSiteID);
		tagList.add(TagFromName.ClinicalTrialSiteName);
		tagList.add(TagFromName.ClinicalTrialSubjectID);
		tagList.add(TagFromName.ClinicalTrialSubjectReadingID);
		tagList.add(TagFromName.ClinicalTrialTimePointID);
		tagList.add(TagFromName.ClinicalTrialTimePointDescription);
		tagList.add(TagFromName.ClinicalTrialCoordinatingCenterName);
		tagList.add(TagFromName.PatientIdentityRemoved);
		tagList.add(TagFromName.DeidentificationMethod);
		tagList.add(TagFromName.DeidentificationMethodCodeSequence);
		tagList.add(TagFromName.ClinicalTrialSeriesID);
		tagList.add(TagFromName.ClinicalTrialSeriesDescription);
		tagList.add(TagFromName.ClinicalTrialProtocolEthicsCommitteeName);
		tagList.add(TagFromName.ClinicalTrialProtocolEthicsCommitteeApprovalNumber);
		tagList.add(TagFromName.ConsentForClinicalTrialUseSequence);
		tagList.add(TagFromName.DistributionType);
		tagList.add(TagFromName.ConsentForDistributionFlag);
		tagList.add(TagFromName.CADFileFormatRetired);
		tagList.add(TagFromName.ComponentReferenceSystemRetired);
		tagList.add(TagFromName.ComponentManufacturingProcedure);
		tagList.add(TagFromName.ComponentManufacturer);
		tagList.add(TagFromName.MaterialThickness);
		tagList.add(TagFromName.MaterialPipeDiameter);
		tagList.add(TagFromName.MaterialIsolationDiameter);
		tagList.add(TagFromName.MaterialGrade);
		tagList.add(TagFromName.MaterialPropertiesDescription);
		tagList.add(TagFromName.MaterialPropertiesFileFormatRetired);
		tagList.add(TagFromName.MaterialNotes);
		tagList.add(TagFromName.ComponentShape);
		tagList.add(TagFromName.CurvatureType);
		tagList.add(TagFromName.OuterDiameter);
		tagList.add(TagFromName.InnerDiameter);
		tagList.add(TagFromName.ComponentWelderIDs);
		tagList.add(TagFromName.SecondaryApprovalStatus);
		tagList.add(TagFromName.SecondaryReviewDate);
		tagList.add(TagFromName.SecondaryReviewTime);
		tagList.add(TagFromName.SecondaryReviewerName);
		tagList.add(TagFromName.RepairID);
		tagList.add(TagFromName.MultipleComponentApprovalSequence);
		tagList.add(TagFromName.OtherApprovalStatus);
		tagList.add(TagFromName.OtherSecondaryApprovalStatus);
		tagList.add(TagFromName.ActualEnvironmentalConditions);
		tagList.add(TagFromName.ExpiryDate);
		tagList.add(TagFromName.EnvironmentalConditions);
		tagList.add(TagFromName.EvaluatorSequence);
		tagList.add(TagFromName.EvaluatorNumber);
		tagList.add(TagFromName.EvaluatorName);
		tagList.add(TagFromName.EvaluationAttempt);
		tagList.add(TagFromName.IndicationSequence);
		tagList.add(TagFromName.IndicationNumber);
		tagList.add(TagFromName.IndicationLabel);
		tagList.add(TagFromName.IndicationDescription);
		tagList.add(TagFromName.IndicationType);
		tagList.add(TagFromName.IndicationDisposition);
		tagList.add(TagFromName.IndicationROISequence);
		tagList.add(TagFromName.IndicationPhysicalPropertySequence);
		tagList.add(TagFromName.PropertyLabel);
		tagList.add(TagFromName.CoordinateSystemNumberOfAxes);
		tagList.add(TagFromName.CoordinateSystemAxesSequence);
		tagList.add(TagFromName.CoordinateSystemAxisDescription);
		tagList.add(TagFromName.CoordinateSystemDataSetMapping);
		tagList.add(TagFromName.CoordinateSystemAxisNumber);
		tagList.add(TagFromName.CoordinateSystemAxisType);
		tagList.add(TagFromName.CoordinateSystemAxisUnits);
		tagList.add(TagFromName.CoordinateSystemAxisValues);
		tagList.add(TagFromName.CoordinateSystemTransformSequence);
		tagList.add(TagFromName.TransformDescription);
		tagList.add(TagFromName.TransformNumberOfAxes);
		tagList.add(TagFromName.TransformOrderOfAxes);
		tagList.add(TagFromName.TransformedAxisUnits);
		tagList.add(TagFromName.CoordinateSystemTransformRotationAndScaleMatrix);
		tagList.add(TagFromName.CoordinateSystemTransformTranslationMatrix);
		tagList.add(TagFromName.InternalDetectorFrameTime);
		tagList.add(TagFromName.NumberOfFramesIntegrated);
		tagList.add(TagFromName.DetectorTemperatureSequence);
		tagList.add(TagFromName.SensorName);
		tagList.add(TagFromName.HorizontalOffsetOfSensor);
		tagList.add(TagFromName.VerticalOffsetOfSensor);
		tagList.add(TagFromName.SensorTemperature);
		tagList.add(TagFromName.DarkCurrentSequence);
		tagList.add(TagFromName.DarkCurrentCounts);
		tagList.add(TagFromName.GainCorrectionReferenceSequence);
		tagList.add(TagFromName.AirCounts);
		tagList.add(TagFromName.KVUsedInGainCalibration);
		tagList.add(TagFromName.MAUsedInGainCalibration);
		tagList.add(TagFromName.NumberOfFramesUsedForIntegration);
		tagList.add(TagFromName.FilterMaterialUsedInGainCalibration);
		tagList.add(TagFromName.FilterThicknessUsedInGainCalibration);
		tagList.add(TagFromName.DateOfGainCalibration);
		tagList.add(TagFromName.TimeOfGainCalibration);
		tagList.add(TagFromName.BadPixelImage);
		tagList.add(TagFromName.CalibrationNotes);
		tagList.add(TagFromName.PulserEquipmentSequence);
		tagList.add(TagFromName.PulserType);
		tagList.add(TagFromName.PulserNotes);
		tagList.add(TagFromName.ReceiverEquipmentSequence);
		tagList.add(TagFromName.AmplifierType);
		tagList.add(TagFromName.ReceiverNotes);
		tagList.add(TagFromName.PreAmplifierEquipmentSequence);
		tagList.add(TagFromName.PreAmplifierNotes);
		tagList.add(TagFromName.TransmitTransducerSequence);
		tagList.add(TagFromName.ReceiveTransducerSequence);
		tagList.add(TagFromName.NumberOfElements);
		tagList.add(TagFromName.ElementShape);
		tagList.add(TagFromName.ElementDimensionA);
		tagList.add(TagFromName.ElementDimensionB);
		tagList.add(TagFromName.ElementPitchA);
		tagList.add(TagFromName.MeasuredBeamDimensionA);
		tagList.add(TagFromName.MeasuredBeamDimensionB);
		tagList.add(TagFromName.LocationOfMeasuredBeamDiameter);
		tagList.add(TagFromName.NominalFrequency);
		tagList.add(TagFromName.MeasuredCenterFrequency);
		tagList.add(TagFromName.MeasuredBandwidth);
		tagList.add(TagFromName.ElementPitchB);
		tagList.add(TagFromName.PulserSettingsSequence);
		tagList.add(TagFromName.PulseWidth);
		tagList.add(TagFromName.ExcitationFrequency);
		tagList.add(TagFromName.ModulationType);
		tagList.add(TagFromName.Damping);
		tagList.add(TagFromName.ReceiverSettingsSequence);
		tagList.add(TagFromName.AcquiredSoundpathLength);
		tagList.add(TagFromName.AcquisitionCompressionType);
		tagList.add(TagFromName.AcquisitionSampleSize);
		tagList.add(TagFromName.RectifierSmoothing);
		tagList.add(TagFromName.DACSequence);
		tagList.add(TagFromName.DACType);
		tagList.add(TagFromName.DACGainPoints);
		tagList.add(TagFromName.DACTimePoints);
		tagList.add(TagFromName.DACAmplitude);
		tagList.add(TagFromName.PreAmplifierSettingsSequence);
		tagList.add(TagFromName.TransmitTransducerSettingsSequence);
		tagList.add(TagFromName.ReceiveTransducerSettingsSequence);
		tagList.add(TagFromName.IncidentAngle);
		tagList.add(TagFromName.CouplingTechnique);
		tagList.add(TagFromName.CouplingMedium);
		tagList.add(TagFromName.CouplingVelocity);
		tagList.add(TagFromName.ProbeCenterLocationX);
		tagList.add(TagFromName.ProbeCenterLocationZ);
		tagList.add(TagFromName.SoundPathLength);
		tagList.add(TagFromName.DelayLawIdentifier);
		tagList.add(TagFromName.GateSettingsSequence);
		tagList.add(TagFromName.GateThreshold);
		tagList.add(TagFromName.VelocityOfSound);
		tagList.add(TagFromName.CalibrationSettingsSequence);
		tagList.add(TagFromName.CalibrationProcedure);
		tagList.add(TagFromName.ProcedureVersion);
		tagList.add(TagFromName.ProcedureCreationDate);
		tagList.add(TagFromName.ProcedureExpirationDate);
		tagList.add(TagFromName.ProcedureLastModifiedDate);
		tagList.add(TagFromName.CalibrationTime);
		tagList.add(TagFromName.CalibrationDate);
		tagList.add(TagFromName.ProbeDriveEquipmentSequence);
		tagList.add(TagFromName.DriveType);
		tagList.add(TagFromName.ProbeDriveNotes);
		tagList.add(TagFromName.DriveProbeSequence);
		tagList.add(TagFromName.ProbeInductance);
		tagList.add(TagFromName.ProbeResistance);
		tagList.add(TagFromName.ReceiveProbeSequence);
		tagList.add(TagFromName.ProbeDriveSettingsSequence);
		tagList.add(TagFromName.BridgeResistors);
		tagList.add(TagFromName.ProbeOrientationAngle);
		tagList.add(TagFromName.UserSelectedGainY);
		tagList.add(TagFromName.UserSelectedPhase);
		tagList.add(TagFromName.UserSelectedOffsetX);
		tagList.add(TagFromName.UserSelectedOffsetY);
		tagList.add(TagFromName.ChannelSettingsSequence);
		tagList.add(TagFromName.ChannelThreshold);
		tagList.add(TagFromName.ScannerSettingsSequence);
		tagList.add(TagFromName.ScanProcedure);
		tagList.add(TagFromName.TranslationRateX);
		tagList.add(TagFromName.TranslationRateY);
		tagList.add(TagFromName.ChannelOverlap);
		tagList.add(TagFromName.ImageQualityIndicatorType);
		tagList.add(TagFromName.ImageQualityIndicatorMaterial);
		tagList.add(TagFromName.ImageQualityIndicatorSize);
		tagList.add(TagFromName.LINACEnergy);
		tagList.add(TagFromName.LINACOutput);
		tagList.add(TagFromName.ActiveAperture);
		tagList.add(TagFromName.TotalAperture);
		tagList.add(TagFromName.ApertureElevation);
		tagList.add(TagFromName.MainLobeAngle);
		tagList.add(TagFromName.MainRoofAngle);
		tagList.add(TagFromName.ConnectorType);
		tagList.add(TagFromName.WedgeModelNumber);
		tagList.add(TagFromName.WedgeAngleFloat);
		tagList.add(TagFromName.WedgeRoofAngle);
		tagList.add(TagFromName.WedgeElement1Position);
		tagList.add(TagFromName.WedgeMaterialVelocity);
		tagList.add(TagFromName.WedgeMaterial);
		tagList.add(TagFromName.WedgeOffsetZ);
		tagList.add(TagFromName.WedgeOriginOffsetX);
		tagList.add(TagFromName.WedgeTimeDelay);
		tagList.add(TagFromName.WedgeName);
		tagList.add(TagFromName.WedgeManufacturerName);
		tagList.add(TagFromName.WedgeDescription);
		tagList.add(TagFromName.NominalBeamAngle);
		tagList.add(TagFromName.WedgeOffsetX);
		tagList.add(TagFromName.WedgeOffsetY);
		tagList.add(TagFromName.WedgeTotalLength);
		tagList.add(TagFromName.WedgeInContactLength);
		tagList.add(TagFromName.WedgeFrontGap);
		tagList.add(TagFromName.WedgeTotalHeight);
		tagList.add(TagFromName.WedgeFrontHeight);
		tagList.add(TagFromName.WedgeRearHeight);
		tagList.add(TagFromName.WedgeTotalWidth);
		tagList.add(TagFromName.WedgeInContactWidth);
		tagList.add(TagFromName.WedgeChamferHeight);
		tagList.add(TagFromName.WedgeCurve);
		tagList.add(TagFromName.RadiusAlongWedge);
		tagList.add(TagFromName.ContrastBolusAgent);
		tagList.add(TagFromName.ContrastBolusAgentSequence);
		tagList.add(TagFromName.ContrastBolusT1Relaxivity);
		tagList.add(TagFromName.ContrastBolusAdministrationRouteSequence);
		tagList.add(TagFromName.BodyPartExamined);
		tagList.add(TagFromName.ScanningSequence);
		tagList.add(TagFromName.SequenceVariant);
		tagList.add(TagFromName.ScanOptions);
		tagList.add(TagFromName.MRAcquisitionType);
		tagList.add(TagFromName.SequenceName);
		tagList.add(TagFromName.AngioFlag);
		tagList.add(TagFromName.InterventionDrugInformationSequence);
		tagList.add(TagFromName.InterventionDrugStopTime);
		tagList.add(TagFromName.InterventionDrugDose);
		tagList.add(TagFromName.InterventionDrugCodeSequence);
		tagList.add(TagFromName.AdditionalDrugSequence);
		tagList.add(TagFromName.Radionuclide);
		tagList.add(TagFromName.Radiopharmaceutical);
		tagList.add(TagFromName.EnergyWindowCenterline);
		tagList.add(TagFromName.EnergyWindowTotalWidth);
		tagList.add(TagFromName.InterventionDrugName);
		tagList.add(TagFromName.InterventionDrugStartTime);
		tagList.add(TagFromName.InterventionSequence);
		tagList.add(TagFromName.TherapyType);
		tagList.add(TagFromName.InterventionStatus);
		tagList.add(TagFromName.TherapyDescription);
		tagList.add(TagFromName.InterventionDescription);
		tagList.add(TagFromName.CineRate);
		tagList.add(TagFromName.InitialCineRunState);
		tagList.add(TagFromName.SliceThickness);
		tagList.add(TagFromName.KVP);
		tagList.add(TagFromName.CountsAccumulated);
		tagList.add(TagFromName.AcquisitionTerminationCondition);
		tagList.add(TagFromName.EffectiveDuration);
		tagList.add(TagFromName.AcquisitionStartCondition);
		tagList.add(TagFromName.AcquisitionStartConditionData);
		tagList.add(TagFromName.AcquisitionTerminationConditionData);
		tagList.add(TagFromName.RepetitionTime);
		tagList.add(TagFromName.EchoTime);
		tagList.add(TagFromName.InversionTime);
		tagList.add(TagFromName.NumberOfAverages);
		tagList.add(TagFromName.ImagingFrequency);
		tagList.add(TagFromName.ImagedNucleus);
		tagList.add(TagFromName.EchoNumbers);
		tagList.add(TagFromName.MagneticFieldStrength);
		tagList.add(TagFromName.SpacingBetweenSlices);
		tagList.add(TagFromName.NumberOfPhaseEncodingSteps);
		tagList.add(TagFromName.DataCollectionDiameter);
		tagList.add(TagFromName.EchoTrainLength);
		tagList.add(TagFromName.PercentSampling);
		tagList.add(TagFromName.PercentPhaseFieldOfView);
		tagList.add(TagFromName.PixelBandwidth);
		tagList.add(TagFromName.DeviceSerialNumber);
		tagList.add(TagFromName.DeviceUID);
		tagList.add(TagFromName.DeviceID);
		tagList.add(TagFromName.PlateID);
		tagList.add(TagFromName.GeneratorID);
		tagList.add(TagFromName.GridID);
		tagList.add(TagFromName.CassetteID);
		tagList.add(TagFromName.GantryID);
		tagList.add(TagFromName.SecondaryCaptureDeviceID);
		tagList.add(TagFromName.HardcopyCreationDeviceID);
		tagList.add(TagFromName.DateOfSecondaryCapture);
		tagList.add(TagFromName.TimeOfSecondaryCapture);
		tagList.add(TagFromName.SecondaryCaptureDeviceManufacturer);
		tagList.add(TagFromName.HardcopyDeviceManufacturer);
		tagList.add(TagFromName.SecondaryCaptureDeviceManufacturerModelName);
		tagList.add(TagFromName.SecondaryCaptureDeviceSoftwareVersions);
		tagList.add(TagFromName.HardcopyDeviceSoftwareVersion);
		tagList.add(TagFromName.HardcopyDeviceManufacturerModelName);
		tagList.add(TagFromName.SoftwareVersions);
		tagList.add(TagFromName.VideoImageFormatAcquired);
		tagList.add(TagFromName.DigitalImageFormatAcquired);
		tagList.add(TagFromName.ProtocolName);
		tagList.add(TagFromName.ContrastBolusRoute);
		tagList.add(TagFromName.ContrastBolusVolume);
		tagList.add(TagFromName.ContrastBolusStartTime);
		tagList.add(TagFromName.ContrastBolusStopTime);
		tagList.add(TagFromName.ContrastBolusTotalDose);
		tagList.add(TagFromName.SyringeCounts);
		tagList.add(TagFromName.ContrastFlowRate);
		tagList.add(TagFromName.ContrastFlowDuration);
		tagList.add(TagFromName.ContrastBolusIngredient);
		tagList.add(TagFromName.ContrastBolusIngredientConcentration);
		tagList.add(TagFromName.SpatialResolution);
		tagList.add(TagFromName.TriggerTime);
		tagList.add(TagFromName.TriggerSourceOrType);
		tagList.add(TagFromName.NominalInterval);
		tagList.add(TagFromName.FrameTime);
		tagList.add(TagFromName.CardiacFramingType);
		tagList.add(TagFromName.FrameTimeVector);
		tagList.add(TagFromName.FrameDelay);
		tagList.add(TagFromName.ImageTriggerDelay);
		tagList.add(TagFromName.MultiplexGroupTimeOffset);
		tagList.add(TagFromName.TriggerTimeOffset);
		tagList.add(TagFromName.SynchronizationTrigger);
		tagList.add(TagFromName.SynchronizationChannel);
		tagList.add(TagFromName.TriggerSamplePosition);
		tagList.add(TagFromName.RadiopharmaceuticalRoute);
		tagList.add(TagFromName.RadiopharmaceuticalVolume);
		tagList.add(TagFromName.RadiopharmaceuticalStartTime);
		tagList.add(TagFromName.RadiopharmaceuticalStopTime);
		tagList.add(TagFromName.RadionuclideTotalDose);
		tagList.add(TagFromName.RadionuclideHalfLife);
		tagList.add(TagFromName.RadionuclidePositronFraction);
		tagList.add(TagFromName.RadiopharmaceuticalSpecificActivity);
		tagList.add(TagFromName.RadiopharmaceuticalStartDateTime);
		tagList.add(TagFromName.RadiopharmaceuticalStopDateTime);
		tagList.add(TagFromName.BeatRejectionFlag);
		tagList.add(TagFromName.LowRRValue);
		tagList.add(TagFromName.HighRRValue);
		tagList.add(TagFromName.IntervalsAcquired);
		tagList.add(TagFromName.IntervalsRejected);
		tagList.add(TagFromName.PVCRejection);
		tagList.add(TagFromName.SkipBeats);
		tagList.add(TagFromName.HeartRate);
		tagList.add(TagFromName.CardiacNumberOfImages);
		tagList.add(TagFromName.TriggerWindow);
		tagList.add(TagFromName.ReconstructionDiameter);
		tagList.add(TagFromName.DistanceSourceToDetector);
		tagList.add(TagFromName.DistanceSourceToPatient);
		tagList.add(TagFromName.EstimatedRadiographicMagnificationFactor);
		tagList.add(TagFromName.GantryDetectorTilt);
		tagList.add(TagFromName.GantryDetectorSlew);
		tagList.add(TagFromName.TableHeight);
		tagList.add(TagFromName.TableTraverse);
		tagList.add(TagFromName.TableMotion);
		tagList.add(TagFromName.TableVerticalIncrement);
		tagList.add(TagFromName.TableLateralIncrement);
		tagList.add(TagFromName.TableLongitudinalIncrement);
		tagList.add(TagFromName.TableAngle);
		tagList.add(TagFromName.TableType);
		tagList.add(TagFromName.RotationDirection);
		tagList.add(TagFromName.AngularPosition);
		tagList.add(TagFromName.RadialPosition);
		tagList.add(TagFromName.ScanArc);
		tagList.add(TagFromName.AngularStep);
		tagList.add(TagFromName.CenterOfRotationOffset);
		tagList.add(TagFromName.RotationOffset);
		tagList.add(TagFromName.FieldOfViewShape);
		tagList.add(TagFromName.FieldOfViewDimensions);
		tagList.add(TagFromName.ExposureTime);
		tagList.add(TagFromName.XRayTubeCurrent);
		tagList.add(TagFromName.Exposure);
		tagList.add(TagFromName.ExposureInuAs);
		tagList.add(TagFromName.AveragePulseWidth);
		tagList.add(TagFromName.RadiationSetting);
		tagList.add(TagFromName.RectificationType);
		tagList.add(TagFromName.RadiationMode);
		tagList.add(TagFromName.ImageAndFluoroscopyAreaDoseProduct);
		tagList.add(TagFromName.FilterType);
		tagList.add(TagFromName.TypeOfFilters);
		tagList.add(TagFromName.IntensifierSize);
		tagList.add(TagFromName.ImagerPixelSpacing);
		tagList.add(TagFromName.Grid);
		tagList.add(TagFromName.GeneratorPower);
		tagList.add(TagFromName.CollimatorGridName);
		tagList.add(TagFromName.CollimatorType);
		tagList.add(TagFromName.FocalDistance);
		tagList.add(TagFromName.XFocusCenter);
		tagList.add(TagFromName.YFocusCenter);
		tagList.add(TagFromName.FocalSpots);
		tagList.add(TagFromName.AnodeTargetMaterial);
		tagList.add(TagFromName.BodyPartThickness);
		tagList.add(TagFromName.CompressionForce);
		tagList.add(TagFromName.PaddleDescription);
		tagList.add(TagFromName.DateOfLastCalibration);
		tagList.add(TagFromName.TimeOfLastCalibration);
		tagList.add(TagFromName.DateTimeOfLastCalibration);
		tagList.add(TagFromName.ConvolutionKernel);
		tagList.add(TagFromName.UpperLowerPixelValues);
		tagList.add(TagFromName.ActualFrameDuration);
		tagList.add(TagFromName.CountRate);
		tagList.add(TagFromName.PreferredPlaybackSequencing);
		tagList.add(TagFromName.ReceiveCoilName);
		tagList.add(TagFromName.TransmitCoilName);
		tagList.add(TagFromName.PlateType);
		tagList.add(TagFromName.PhosphorType);
		tagList.add(TagFromName.ScanVelocity);
		tagList.add(TagFromName.WholeBodyTechnique);
		tagList.add(TagFromName.ScanLength);
		tagList.add(TagFromName.AcquisitionMatrix);
		tagList.add(TagFromName.InPlanePhaseEncodingDirection);
		tagList.add(TagFromName.FlipAngle);
		tagList.add(TagFromName.VariableFlipAngleFlag);
		tagList.add(TagFromName.SAR);
		tagList.add(TagFromName.dBdt);
		tagList.add(TagFromName.B1rms);
		tagList.add(TagFromName.AcquisitionDeviceProcessingDescription);
		tagList.add(TagFromName.AcquisitionDeviceProcessingCode);
		tagList.add(TagFromName.CassetteOrientation);
		tagList.add(TagFromName.CassetteSize);
		tagList.add(TagFromName.ExposuresOnPlate);
		tagList.add(TagFromName.RelativeXRayExposure);
		tagList.add(TagFromName.ExposureIndex);
		tagList.add(TagFromName.TargetExposureIndex);
		tagList.add(TagFromName.DeviationIndex);
		tagList.add(TagFromName.ColumnAngulation);
		tagList.add(TagFromName.TomoLayerHeight);
		tagList.add(TagFromName.TomoAngle);
		tagList.add(TagFromName.TomoTime);
		tagList.add(TagFromName.TomoType);
		tagList.add(TagFromName.TomoClass);
		tagList.add(TagFromName.NumberOfTomosynthesisSourceImages);
		tagList.add(TagFromName.PositionerMotion);
		tagList.add(TagFromName.PositionerType);
		tagList.add(TagFromName.PositionerPrimaryAngle);
		tagList.add(TagFromName.PositionerSecondaryAngle);
		tagList.add(TagFromName.PositionerPrimaryAngleIncrement);
		tagList.add(TagFromName.PositionerSecondaryAngleIncrement);
		tagList.add(TagFromName.DetectorPrimaryAngle);
		tagList.add(TagFromName.DetectorSecondaryAngle);
		tagList.add(TagFromName.ShutterShape);
		tagList.add(TagFromName.ShutterLeftVerticalEdge);
		tagList.add(TagFromName.ShutterRightVerticalEdge);
		tagList.add(TagFromName.ShutterUpperHorizontalEdge);
		tagList.add(TagFromName.ShutterLowerHorizontalEdge);
		tagList.add(TagFromName.CenterOfCircularShutter);
		tagList.add(TagFromName.RadiusOfCircularShutter);
		tagList.add(TagFromName.VerticesOfThePolygonalShutter);
		tagList.add(TagFromName.ShutterPresentationValue);
		tagList.add(TagFromName.ShutterOverlayGroup);
		tagList.add(TagFromName.ShutterPresentationColorCIELabValue);
		tagList.add(TagFromName.CollimatorShape);
		tagList.add(TagFromName.CollimatorLeftVerticalEdge);
		tagList.add(TagFromName.CollimatorRightVerticalEdge);
		tagList.add(TagFromName.CollimatorUpperHorizontalEdge);
		tagList.add(TagFromName.CollimatorLowerHorizontalEdge);
		tagList.add(TagFromName.CenterOfCircularCollimator);
		tagList.add(TagFromName.RadiusOfCircularCollimator);
		tagList.add(TagFromName.VerticesOfThePolygonalCollimator);
		tagList.add(TagFromName.AcquisitionTimeSynchronized);
		tagList.add(TagFromName.TimeSource);
		tagList.add(TagFromName.TimeDistributionProtocol);
		tagList.add(TagFromName.NTPSourceAddress);
		tagList.add(TagFromName.PageNumberVector);
		tagList.add(TagFromName.FrameLabelVector);
		tagList.add(TagFromName.FramePrimaryAngleVector);
		tagList.add(TagFromName.FrameSecondaryAngleVector);
		tagList.add(TagFromName.SliceLocationVector);
		tagList.add(TagFromName.DisplayWindowLabelVector);
		tagList.add(TagFromName.NominalScannedPixelSpacing);
		tagList.add(TagFromName.DigitizingDeviceTransportDirection);
		tagList.add(TagFromName.RotationOfScannedFilm);
		tagList.add(TagFromName.BiopsyTargetSequence);
		tagList.add(TagFromName.TargetUID);
		tagList.add(TagFromName.LocalizingCursorPosition);
		tagList.add(TagFromName.CalculatedTargetPosition);
		tagList.add(TagFromName.TargetLabel);
		tagList.add(TagFromName.DisplayedZValue);
		tagList.add(TagFromName.IVUSAcquisition);
		tagList.add(TagFromName.IVUSPullbackRate);
		tagList.add(TagFromName.IVUSGatedRate);
		tagList.add(TagFromName.IVUSPullbackStartFrameNumber);
		tagList.add(TagFromName.IVUSPullbackStopFrameNumber);
		tagList.add(TagFromName.LesionNumber);
		tagList.add(TagFromName.AcquisitionComments);
		tagList.add(TagFromName.OutputPower);
		tagList.add(TagFromName.TransducerData);
		tagList.add(TagFromName.FocusDepth);
		tagList.add(TagFromName.ProcessingFunction);
		tagList.add(TagFromName.PostprocessingFunction);
		tagList.add(TagFromName.MechanicalIndex);
		tagList.add(TagFromName.BoneThermalIndex);
		tagList.add(TagFromName.CranialThermalIndex);
		tagList.add(TagFromName.SoftTissueThermalIndex);
		tagList.add(TagFromName.SoftTissueFocusThermalIndex);
		tagList.add(TagFromName.SoftTissueSurfaceThermalIndex);
		tagList.add(TagFromName.DynamicRange);
		tagList.add(TagFromName.TotalGain);
		tagList.add(TagFromName.DepthOfScanField);
		tagList.add(TagFromName.PatientPosition);
		tagList.add(TagFromName.ViewPosition);
		tagList.add(TagFromName.ProjectionEponymousNameCodeSequence);
		tagList.add(TagFromName.ImageTransformationMatrix);
		tagList.add(TagFromName.ImageTranslationVector);
		tagList.add(TagFromName.Sensitivity);
		tagList.add(TagFromName.SequenceOfUltrasoundRegions);
		tagList.add(TagFromName.RegionSpatialFormat);
		tagList.add(TagFromName.RegionDataType);
		tagList.add(TagFromName.RegionFlags);
		tagList.add(TagFromName.RegionLocationMinX0);
		tagList.add(TagFromName.RegionLocationMinY0);
		tagList.add(TagFromName.RegionLocationMaxX1);
		tagList.add(TagFromName.RegionLocationMaxY1);
		tagList.add(TagFromName.ReferencePixelX0);
		tagList.add(TagFromName.ReferencePixelY0);
		tagList.add(TagFromName.PhysicalUnitsXDirection);
		tagList.add(TagFromName.PhysicalUnitsYDirection);
		tagList.add(TagFromName.ReferencePixelPhysicalValueX);
		tagList.add(TagFromName.ReferencePixelPhysicalValueY);
		tagList.add(TagFromName.PhysicalDeltaX);
		tagList.add(TagFromName.PhysicalDeltaY);
		tagList.add(TagFromName.TransducerFrequency);
		tagList.add(TagFromName.TransducerType);
		tagList.add(TagFromName.PulseRepetitionFrequency);
		tagList.add(TagFromName.DopplerCorrectionAngle);
		tagList.add(TagFromName.SteeringAngle);
		tagList.add(TagFromName.DopplerSampleVolumeXPositionRetired);
		tagList.add(TagFromName.DopplerSampleVolumeXPosition);
		tagList.add(TagFromName.DopplerSampleVolumeYPositionRetired);
		tagList.add(TagFromName.DopplerSampleVolumeYPosition);
		tagList.add(TagFromName.TMLinePositionX0Retired);
		tagList.add(TagFromName.TMLinePositionX0);
		tagList.add(TagFromName.TMLinePositionY0Retired);
		tagList.add(TagFromName.TMLinePositionY0);
		tagList.add(TagFromName.TMLinePositionX1Retired);
		tagList.add(TagFromName.TMLinePositionX1);
		tagList.add(TagFromName.TMLinePositionY1Retired);
		tagList.add(TagFromName.TMLinePositionY1);
		tagList.add(TagFromName.PixelComponentOrganization);
		tagList.add(TagFromName.PixelComponentMask);
		tagList.add(TagFromName.PixelComponentRangeStart);
		tagList.add(TagFromName.PixelComponentRangeStop);
		tagList.add(TagFromName.PixelComponentPhysicalUnits);
		tagList.add(TagFromName.PixelComponentDataType);
		tagList.add(TagFromName.NumberOfTableBreakPoints);
		tagList.add(TagFromName.TableOfXBreakPoints);
		tagList.add(TagFromName.TableOfYBreakPoints);
		tagList.add(TagFromName.NumberOfTableEntries);
		tagList.add(TagFromName.TableOfPixelValues);
		tagList.add(TagFromName.TableOfParameterValues);
		tagList.add(TagFromName.RWaveTimeVector);
		tagList.add(TagFromName.DetectorConditionsNominalFlag);
		tagList.add(TagFromName.DetectorTemperature);
		tagList.add(TagFromName.DetectorType);
		tagList.add(TagFromName.DetectorConfiguration);
		tagList.add(TagFromName.DetectorDescription);
		tagList.add(TagFromName.DetectorMode);
		tagList.add(TagFromName.DetectorID);
		tagList.add(TagFromName.DateOfLastDetectorCalibration);
		tagList.add(TagFromName.TimeOfLastDetectorCalibration);
		tagList.add(TagFromName.ExposuresOnDetectorSinceLastCalibration);
		tagList.add(TagFromName.ExposuresOnDetectorSinceManufactured);
		tagList.add(TagFromName.DetectorTimeSinceLastExposure);
		tagList.add(TagFromName.DetectorActiveTime);
		tagList.add(TagFromName.DetectorActivationOffsetFromExposure);
		tagList.add(TagFromName.DetectorBinning);
		tagList.add(TagFromName.DetectorElementPhysicalSize);
		tagList.add(TagFromName.DetectorElementSpacing);
		tagList.add(TagFromName.DetectorActiveShape);
		tagList.add(TagFromName.DetectorActiveDimensions);
		tagList.add(TagFromName.DetectorActiveOrigin);
		tagList.add(TagFromName.DetectorManufacturerName);
		tagList.add(TagFromName.DetectorManufacturerModelName);
		tagList.add(TagFromName.FieldOfViewOrigin);
		tagList.add(TagFromName.FieldOfViewRotation);
		tagList.add(TagFromName.FieldOfViewHorizontalFlip);
		tagList.add(TagFromName.PixelDataAreaOriginRelativeToFOV);
		tagList.add(TagFromName.PixelDataAreaRotationAngleRelativeToFOV);
		tagList.add(TagFromName.GridAbsorbingMaterial);
		tagList.add(TagFromName.GridSpacingMaterial);
		tagList.add(TagFromName.GridThickness);
		tagList.add(TagFromName.GridPitch);
		tagList.add(TagFromName.GridAspectRatio);
		tagList.add(TagFromName.GridPeriod);
		tagList.add(TagFromName.GridFocalDistance);
		tagList.add(TagFromName.FilterMaterial);
		tagList.add(TagFromName.FilterThicknessMinimum);
		tagList.add(TagFromName.FilterThicknessMaximum);
		tagList.add(TagFromName.FilterBeamPathLengthMinimum);
		tagList.add(TagFromName.FilterBeamPathLengthMaximum);
		tagList.add(TagFromName.ExposureControlMode);
		tagList.add(TagFromName.ExposureControlModeDescription);
		tagList.add(TagFromName.ExposureStatus);
		tagList.add(TagFromName.PhototimerSetting);
		tagList.add(TagFromName.ExposureTimeInuS);
		tagList.add(TagFromName.XRayTubeCurrentInuA);
		tagList.add(TagFromName.ContentQualification);
		tagList.add(TagFromName.PulseSequenceName);
		tagList.add(TagFromName.MRImagingModifierSequence);
		tagList.add(TagFromName.EchoPulseSequence);
		tagList.add(TagFromName.InversionRecovery);
		tagList.add(TagFromName.FlowCompensation);
		tagList.add(TagFromName.MultipleSpinEcho);
		tagList.add(TagFromName.MultiPlanarExcitation);
		tagList.add(TagFromName.PhaseContrast);
		tagList.add(TagFromName.TimeOfFlightContrast);
		tagList.add(TagFromName.Spoiling);
		tagList.add(TagFromName.SteadyStatePulseSequence);
		tagList.add(TagFromName.EchoPlanarPulseSequence);
		tagList.add(TagFromName.TagAngleFirstAxis);
		tagList.add(TagFromName.MagnetizationTransfer);
		tagList.add(TagFromName.T2Preparation);
		tagList.add(TagFromName.BloodSignalNulling);
		tagList.add(TagFromName.SaturationRecovery);
		tagList.add(TagFromName.SpectrallySelectedSuppression);
		tagList.add(TagFromName.SpectrallySelectedExcitation);
		tagList.add(TagFromName.SpatialPresaturation);
		tagList.add(TagFromName.Tagging);
		tagList.add(TagFromName.OversamplingPhase);
		tagList.add(TagFromName.TagSpacingFirstDimension);
		tagList.add(TagFromName.GeometryOfKSpaceTraversal);
		tagList.add(TagFromName.SegmentedKSpaceTraversal);
		tagList.add(TagFromName.RectilinearPhaseEncodeReordering);
		tagList.add(TagFromName.TagThickness);
		tagList.add(TagFromName.PartialFourierDirection);
		tagList.add(TagFromName.CardiacSynchronizationTechnique);
		tagList.add(TagFromName.ReceiveCoilManufacturerName);
		tagList.add(TagFromName.MRReceiveCoilSequence);
		tagList.add(TagFromName.ReceiveCoilType);
		tagList.add(TagFromName.QuadratureReceiveCoil);
		tagList.add(TagFromName.MultiCoilDefinitionSequence);
		tagList.add(TagFromName.MultiCoilConfiguration);
		tagList.add(TagFromName.MultiCoilElementName);
		tagList.add(TagFromName.MultiCoilElementUsed);
		tagList.add(TagFromName.MRTransmitCoilSequence);
		tagList.add(TagFromName.TransmitCoilManufacturerName);
		tagList.add(TagFromName.TransmitCoilType);
		tagList.add(TagFromName.SpectralWidth);
		tagList.add(TagFromName.ChemicalShiftReference);
		tagList.add(TagFromName.VolumeLocalizationTechnique);
		tagList.add(TagFromName.MRAcquisitionFrequencyEncodingSteps);
		tagList.add(TagFromName.Decoupling);
		tagList.add(TagFromName.DecoupledNucleus);
		tagList.add(TagFromName.DecouplingFrequency);
		tagList.add(TagFromName.DecouplingMethod);
		tagList.add(TagFromName.DecouplingChemicalShiftReference);
		tagList.add(TagFromName.KSpaceFiltering);
		tagList.add(TagFromName.TimeDomainFiltering);
		tagList.add(TagFromName.NumberOfZeroFills);
		tagList.add(TagFromName.BaselineCorrection);
		tagList.add(TagFromName.ParallelReductionFactorInPlane);
		tagList.add(TagFromName.CardiacRRIntervalSpecified);
		tagList.add(TagFromName.AcquisitionDuration);
		tagList.add(TagFromName.FrameAcquisitionDateTime);
		tagList.add(TagFromName.DiffusionDirectionality);
		tagList.add(TagFromName.DiffusionGradientDirectionSequence);
		tagList.add(TagFromName.ParallelAcquisition);
		tagList.add(TagFromName.ParallelAcquisitionTechnique);
		tagList.add(TagFromName.InversionTimes);
		tagList.add(TagFromName.MetaboliteMapDescription);
		tagList.add(TagFromName.PartialFourier);
		tagList.add(TagFromName.EffectiveEchoTime);
		tagList.add(TagFromName.MetaboliteMapCodeSequence);
		tagList.add(TagFromName.ChemicalShiftSequence);
		tagList.add(TagFromName.CardiacSignalSource);
		tagList.add(TagFromName.DiffusionBValue);
		tagList.add(TagFromName.DiffusionGradientOrientation);
		tagList.add(TagFromName.VelocityEncodingDirection);
		tagList.add(TagFromName.VelocityEncodingMinimumValue);
		tagList.add(TagFromName.VelocityEncodingAcquisitionSequence);
		tagList.add(TagFromName.NumberOfKSpaceTrajectories);
		tagList.add(TagFromName.CoverageOfKSpace);
		tagList.add(TagFromName.SpectroscopyAcquisitionPhaseRows);
		tagList.add(TagFromName.ParallelReductionFactorInPlaneRetired);
		tagList.add(TagFromName.TransmitterFrequency);
		tagList.add(TagFromName.ResonantNucleus);
		tagList.add(TagFromName.FrequencyCorrection);
		tagList.add(TagFromName.MRSpectroscopyFOVGeometrySequence);
		tagList.add(TagFromName.SlabThickness);
		tagList.add(TagFromName.SlabOrientation);
		tagList.add(TagFromName.MidSlabPosition);
		tagList.add(TagFromName.MRSpatialSaturationSequence);
		tagList.add(TagFromName.MRTimingAndRelatedParametersSequence);
		tagList.add(TagFromName.MREchoSequence);
		tagList.add(TagFromName.MRModifierSequence);
		tagList.add(TagFromName.MRDiffusionSequence);
		tagList.add(TagFromName.CardiacSynchronizationSequence);
		tagList.add(TagFromName.MRAveragesSequence);
		tagList.add(TagFromName.MRFOVGeometrySequence);
		tagList.add(TagFromName.VolumeLocalizationSequence);
		tagList.add(TagFromName.SpectroscopyAcquisitionDataColumns);
		tagList.add(TagFromName.DiffusionAnisotropyType);
		tagList.add(TagFromName.FrameReferenceDateTime);
		tagList.add(TagFromName.MRMetaboliteMapSequence);
		tagList.add(TagFromName.ParallelReductionFactorOutOfPlane);
		tagList.add(TagFromName.SpectroscopyAcquisitionOutOfPlanePhaseSteps);
		tagList.add(TagFromName.BulkMotionStatus);
		tagList.add(TagFromName.ParallelReductionFactorSecondInPlane);
		tagList.add(TagFromName.CardiacBeatRejectionTechnique);
		tagList.add(TagFromName.RespiratoryMotionCompensationTechnique);
		tagList.add(TagFromName.RespiratorySignalSource);
		tagList.add(TagFromName.BulkMotionCompensationTechnique);
		tagList.add(TagFromName.BulkMotionSignalSource);
		tagList.add(TagFromName.ApplicableSafetyStandardAgency);
		tagList.add(TagFromName.ApplicableSafetyStandardDescription);
		tagList.add(TagFromName.OperatingModeSequence);
		tagList.add(TagFromName.OperatingModeType);
		tagList.add(TagFromName.OperatingMode);
		tagList.add(TagFromName.SpecificAbsorptionRateDefinition);
		tagList.add(TagFromName.GradientOutputType);
		tagList.add(TagFromName.SpecificAbsorptionRateValue);
		tagList.add(TagFromName.GradientOutput);
		tagList.add(TagFromName.FlowCompensationDirection);
		tagList.add(TagFromName.TaggingDelay);
		tagList.add(TagFromName.RespiratoryMotionCompensationTechniqueDescription);
		tagList.add(TagFromName.RespiratorySignalSourceID);
		tagList.add(TagFromName.ChemicalShiftMinimumIntegrationLimitInHz);
		tagList.add(TagFromName.ChemicalShiftMaximumIntegrationLimitInHz);
		tagList.add(TagFromName.MRVelocityEncodingSequence);
		tagList.add(TagFromName.FirstOrderPhaseCorrection);
		tagList.add(TagFromName.WaterReferencedPhaseCorrection);
		tagList.add(TagFromName.MRSpectroscopyAcquisitionType);
		tagList.add(TagFromName.RespiratoryCyclePosition);
		tagList.add(TagFromName.VelocityEncodingMaximumValue);
		tagList.add(TagFromName.TagSpacingSecondDimension);
		tagList.add(TagFromName.TagAngleSecondAxis);
		tagList.add(TagFromName.FrameAcquisitionDuration);
		tagList.add(TagFromName.MRImageFrameTypeSequence);
		tagList.add(TagFromName.MRSpectroscopyFrameTypeSequence);
		tagList.add(TagFromName.MRAcquisitionPhaseEncodingStepsInPlane);
		tagList.add(TagFromName.MRAcquisitionPhaseEncodingStepsOutOfPlane);
		tagList.add(TagFromName.SpectroscopyAcquisitionPhaseColumns);
		tagList.add(TagFromName.CardiacCyclePosition);
		tagList.add(TagFromName.SpecificAbsorptionRateSequence);
		tagList.add(TagFromName.RFEchoTrainLength);
		tagList.add(TagFromName.GradientEchoTrainLength);
		tagList.add(TagFromName.ArterialSpinLabelingContrast);
		tagList.add(TagFromName.MRArterialSpinLabelingSequence);
		tagList.add(TagFromName.ASLTechniqueDescription);
		tagList.add(TagFromName.ASLSlabNumber);
		tagList.add(TagFromName.ASLSlabThickness);
		tagList.add(TagFromName.ASLSlabOrientation);
		tagList.add(TagFromName.ASLMidSlabPosition);
		tagList.add(TagFromName.ASLContext);
		tagList.add(TagFromName.ASLPulseTrainDuration);
		tagList.add(TagFromName.ASLCrusherFlag);
		tagList.add(TagFromName.ASLCrusherFlowLimit);
		tagList.add(TagFromName.ASLCrusherDescription);
		tagList.add(TagFromName.ASLBolusCutoffFlag);
		tagList.add(TagFromName.ASLBolusCutoffTimingSequence);
		tagList.add(TagFromName.ASLBolusCutoffTechnique);
		tagList.add(TagFromName.ASLBolusCutoffDelayTime);
		tagList.add(TagFromName.ASLSlabSequence);
		tagList.add(TagFromName.ChemicalShiftMinimumIntegrationLimitInppm);
		tagList.add(TagFromName.ChemicalShiftMaximumIntegrationLimitInppm);
		tagList.add(TagFromName.WaterReferenceAcquisition);
		tagList.add(TagFromName.EchoPeakPosition);
		tagList.add(TagFromName.CTAcquisitionTypeSequence);
		tagList.add(TagFromName.AcquisitionType);
		tagList.add(TagFromName.TubeAngle);
		tagList.add(TagFromName.CTAcquisitionDetailsSequence);
		tagList.add(TagFromName.RevolutionTime);
		tagList.add(TagFromName.SingleCollimationWidth);
		tagList.add(TagFromName.TotalCollimationWidth);
		tagList.add(TagFromName.CTTableDynamicsSequence);
		tagList.add(TagFromName.TableSpeed);
		tagList.add(TagFromName.TableFeedPerRotation);
		tagList.add(TagFromName.SpiralPitchFactor);
		tagList.add(TagFromName.CTGeometrySequence);
		tagList.add(TagFromName.DataCollectionCenterPatient);
		tagList.add(TagFromName.CTReconstructionSequence);
		tagList.add(TagFromName.ReconstructionAlgorithm);
		tagList.add(TagFromName.ConvolutionKernelGroup);
		tagList.add(TagFromName.ReconstructionFieldOfView);
		tagList.add(TagFromName.ReconstructionTargetCenterPatient);
		tagList.add(TagFromName.ReconstructionAngle);
		tagList.add(TagFromName.ImageFilter);
		tagList.add(TagFromName.CTExposureSequence);
		tagList.add(TagFromName.ReconstructionPixelSpacing);
		tagList.add(TagFromName.ExposureModulationType);
		tagList.add(TagFromName.EstimatedDoseSaving);
		tagList.add(TagFromName.CTXRayDetailsSequence);
		tagList.add(TagFromName.CTPositionSequence);
		tagList.add(TagFromName.TablePosition);
		tagList.add(TagFromName.ExposureTimeInms);
		tagList.add(TagFromName.CTImageFrameTypeSequence);
		tagList.add(TagFromName.XRayTubeCurrentInmA);
		tagList.add(TagFromName.ExposureInmAs);
		tagList.add(TagFromName.ConstantVolumeFlag);
		tagList.add(TagFromName.FluoroscopyFlag);
		tagList.add(TagFromName.DistanceSourceToDataCollectionCenter);
		tagList.add(TagFromName.ContrastBolusAgentNumber);
		tagList.add(TagFromName.ContrastBolusIngredientCodeSequence);
		tagList.add(TagFromName.ContrastAdministrationProfileSequence);
		tagList.add(TagFromName.ContrastBolusUsageSequence);
		tagList.add(TagFromName.ContrastBolusAgentAdministered);
		tagList.add(TagFromName.ContrastBolusAgentDetected);
		tagList.add(TagFromName.ContrastBolusAgentPhase);
		tagList.add(TagFromName.CTDIvol);
		tagList.add(TagFromName.CTDIPhantomTypeCodeSequence);
		tagList.add(TagFromName.CalciumScoringMassFactorPatient);
		tagList.add(TagFromName.CalciumScoringMassFactorDevice);
		tagList.add(TagFromName.EnergyWeightingFactor);
		tagList.add(TagFromName.CTAdditionalXRaySourceSequence);
		tagList.add(TagFromName.ProjectionPixelCalibrationSequence);
		tagList.add(TagFromName.DistanceSourceToIsocenter);
		tagList.add(TagFromName.DistanceObjectToTableTop);
		tagList.add(TagFromName.ObjectPixelSpacingInCenterOfBeam);
		tagList.add(TagFromName.PositionerPositionSequence);
		tagList.add(TagFromName.TablePositionSequence);
		tagList.add(TagFromName.CollimatorShapeSequence);
		tagList.add(TagFromName.PlanesInAcquisition);
		tagList.add(TagFromName.XAXRFFrameCharacteristicsSequence);
		tagList.add(TagFromName.FrameAcquisitionSequence);
		tagList.add(TagFromName.XRayReceptorType);
		tagList.add(TagFromName.AcquisitionProtocolName);
		tagList.add(TagFromName.AcquisitionProtocolDescription);
		tagList.add(TagFromName.ContrastBolusIngredientOpaque);
		tagList.add(TagFromName.DistanceReceptorPlaneToDetectorHousing);
		tagList.add(TagFromName.IntensifierActiveShape);
		tagList.add(TagFromName.IntensifierActiveDimensions);
		tagList.add(TagFromName.PhysicalDetectorSize);
		tagList.add(TagFromName.PositionOfIsocenterProjection);
		tagList.add(TagFromName.FieldOfViewSequence);
		tagList.add(TagFromName.FieldOfViewDescription);
		tagList.add(TagFromName.ExposureControlSensingRegionsSequence);
		tagList.add(TagFromName.ExposureControlSensingRegionShape);
		tagList.add(TagFromName.ExposureControlSensingRegionLeftVerticalEdge);
		tagList.add(TagFromName.ExposureControlSensingRegionRightVerticalEdge);
		tagList.add(TagFromName.ExposureControlSensingRegionUpperHorizontalEdge);
		tagList.add(TagFromName.ExposureControlSensingRegionLowerHorizontalEdge);
		tagList.add(TagFromName.CenterOfCircularExposureControlSensingRegion);
		tagList.add(TagFromName.RadiusOfCircularExposureControlSensingRegion);
		tagList.add(TagFromName.VerticesOfThePolygonalExposureControlSensingRegion);
		tagList.add(TagFromName.ColumnAngulationPatient);
		tagList.add(TagFromName.BeamAngle);
		tagList.add(TagFromName.FrameDetectorParametersSequence);
		tagList.add(TagFromName.CalculatedAnatomyThickness);
		tagList.add(TagFromName.CalibrationSequence);
		tagList.add(TagFromName.ObjectThicknessSequence);
		tagList.add(TagFromName.PlaneIdentification);
		tagList.add(TagFromName.FieldOfViewDimensionsInFloat);
		tagList.add(TagFromName.IsocenterReferenceSystemSequence);
		tagList.add(TagFromName.PositionerIsocenterPrimaryAngle);
		tagList.add(TagFromName.PositionerIsocenterSecondaryAngle);
		tagList.add(TagFromName.PositionerIsocenterDetectorRotationAngle);
		tagList.add(TagFromName.TableXPositionToIsocenter);
		tagList.add(TagFromName.TableYPositionToIsocenter);
		tagList.add(TagFromName.TableZPositionToIsocenter);
		tagList.add(TagFromName.TableHorizontalRotationAngle);
		tagList.add(TagFromName.TableHeadTiltAngle);
		tagList.add(TagFromName.TableCradleTiltAngle);
		tagList.add(TagFromName.FrameDisplayShutterSequence);
		tagList.add(TagFromName.AcquiredImageAreaDoseProduct);
		tagList.add(TagFromName.CArmPositionerTabletopRelationship);
		tagList.add(TagFromName.XRayGeometrySequence);
		tagList.add(TagFromName.IrradiationEventIdentificationSequence);
		tagList.add(TagFromName.XRay3DFrameTypeSequence);
		tagList.add(TagFromName.ContributingSourcesSequence);
		tagList.add(TagFromName.XRay3DAcquisitionSequence);
		tagList.add(TagFromName.PrimaryPositionerScanArc);
		tagList.add(TagFromName.SecondaryPositionerScanArc);
		tagList.add(TagFromName.PrimaryPositionerScanStartAngle);
		tagList.add(TagFromName.SecondaryPositionerScanStartAngle);
		tagList.add(TagFromName.PrimaryPositionerIncrement);
		tagList.add(TagFromName.SecondaryPositionerIncrement);
		tagList.add(TagFromName.StartAcquisitionDateTime);
		tagList.add(TagFromName.EndAcquisitionDateTime);
		tagList.add(TagFromName.PrimaryPositionerIncrementSign);
		tagList.add(TagFromName.SecondaryPositionerIncrementSign);
		tagList.add(TagFromName.ApplicationName);
		tagList.add(TagFromName.ApplicationVersion);
		tagList.add(TagFromName.ApplicationManufacturer);
		tagList.add(TagFromName.AlgorithmType);
		tagList.add(TagFromName.AlgorithmDescription);
		tagList.add(TagFromName.XRay3DReconstructionSequence);
		tagList.add(TagFromName.ReconstructionDescription);
		tagList.add(TagFromName.PerProjectionAcquisitionSequence);
		tagList.add(TagFromName.DetectorPositionSequence);
		tagList.add(TagFromName.XRayAcquisitionDoseSequence);
		tagList.add(TagFromName.XRaySourceIsocenterPrimaryAngle);
		tagList.add(TagFromName.XRaySourceIsocenterSecondaryAngle);
		tagList.add(TagFromName.BreastSupportIsocenterPrimaryAngle);
		tagList.add(TagFromName.BreastSupportIsocenterSecondaryAngle);
		tagList.add(TagFromName.BreastSupportXPositionToIsocenter);
		tagList.add(TagFromName.BreastSupportYPositionToIsocenter);
		tagList.add(TagFromName.BreastSupportZPositionToIsocenter);
		tagList.add(TagFromName.DetectorIsocenterPrimaryAngle);
		tagList.add(TagFromName.DetectorIsocenterSecondaryAngle);
		tagList.add(TagFromName.DetectorXPositionToIsocenter);
		tagList.add(TagFromName.DetectorYPositionToIsocenter);
		tagList.add(TagFromName.DetectorZPositionToIsocenter);
		tagList.add(TagFromName.XRayGridSequence);
		tagList.add(TagFromName.XRayFilterSequence);
		tagList.add(TagFromName.DetectorActiveAreaTLHCPosition);
		tagList.add(TagFromName.DetectorActiveAreaOrientation);
		tagList.add(TagFromName.PositionerPrimaryAngleDirection);
		tagList.add(TagFromName.DiffusionBMatrixSequence);
		tagList.add(TagFromName.DiffusionBValueXX);
		tagList.add(TagFromName.DiffusionBValueXY);
		tagList.add(TagFromName.DiffusionBValueXZ);
		tagList.add(TagFromName.DiffusionBValueYY);
		tagList.add(TagFromName.DiffusionBValueYZ);
		tagList.add(TagFromName.DiffusionBValueZZ);
		tagList.add(TagFromName.DecayCorrectionDateTime);
		tagList.add(TagFromName.StartDensityThreshold);
		tagList.add(TagFromName.StartRelativeDensityDifferenceThreshold);
		tagList.add(TagFromName.StartCardiacTriggerCountThreshold);
		tagList.add(TagFromName.StartRespiratoryTriggerCountThreshold);
		tagList.add(TagFromName.TerminationCountsThreshold);
		tagList.add(TagFromName.TerminationDensityThreshold);
		tagList.add(TagFromName.TerminationRelativeDensityThreshold);
		tagList.add(TagFromName.TerminationTimeThreshold);
		tagList.add(TagFromName.TerminationCardiacTriggerCountThreshold);
		tagList.add(TagFromName.TerminationRespiratoryTriggerCountThreshold);
		tagList.add(TagFromName.DetectorGeometry);
		tagList.add(TagFromName.TransverseDetectorSeparation);
		tagList.add(TagFromName.AxialDetectorDimension);
		tagList.add(TagFromName.RadiopharmaceuticalAgentNumber);
		tagList.add(TagFromName.PETFrameAcquisitionSequence);
		tagList.add(TagFromName.PETDetectorMotionDetailsSequence);
		tagList.add(TagFromName.PETTableDynamicsSequence);
		tagList.add(TagFromName.PETPositionSequence);
		tagList.add(TagFromName.PETFrameCorrectionFactorsSequence);
		tagList.add(TagFromName.RadiopharmaceuticalUsageSequence);
		tagList.add(TagFromName.AttenuationCorrectionSource);
		tagList.add(TagFromName.NumberOfIterations);
		tagList.add(TagFromName.NumberOfSubsets);
		tagList.add(TagFromName.PETReconstructionSequence);
		tagList.add(TagFromName.PETFrameTypeSequence);
		tagList.add(TagFromName.TimeOfFlightInformationUsed);
		tagList.add(TagFromName.ReconstructionType);
		tagList.add(TagFromName.DecayCorrected);
		tagList.add(TagFromName.AttenuationCorrected);
		tagList.add(TagFromName.ScatterCorrected);
		tagList.add(TagFromName.DeadTimeCorrected);
		tagList.add(TagFromName.GantryMotionCorrected);
		tagList.add(TagFromName.PatientMotionCorrected);
		tagList.add(TagFromName.CountLossNormalizationCorrected);
		tagList.add(TagFromName.RandomsCorrected);
		tagList.add(TagFromName.NonUniformRadialSamplingCorrected);
		tagList.add(TagFromName.SensitivityCalibrated);
		tagList.add(TagFromName.DetectorNormalizationCorrection);
		tagList.add(TagFromName.IterativeReconstructionMethod);
		tagList.add(TagFromName.AttenuationCorrectionTemporalRelationship);
		tagList.add(TagFromName.PatientPhysiologicalStateSequence);
		tagList.add(TagFromName.PatientPhysiologicalStateCodeSequence);
		tagList.add(TagFromName.DepthsOfFocus);
		tagList.add(TagFromName.ExcludedIntervalsSequence);
		tagList.add(TagFromName.ExclusionStartDateTime);
		tagList.add(TagFromName.ExclusionDuration);
		tagList.add(TagFromName.USImageDescriptionSequence);
		tagList.add(TagFromName.ImageDataTypeSequence);
		tagList.add(TagFromName.DataType);
		tagList.add(TagFromName.TransducerScanPatternCodeSequence);
		tagList.add(TagFromName.AliasedDataType);
		tagList.add(TagFromName.PositionMeasuringDeviceUsed);
		tagList.add(TagFromName.TransducerGeometryCodeSequence);
		tagList.add(TagFromName.TransducerBeamSteeringCodeSequence);
		tagList.add(TagFromName.TransducerApplicationCodeSequence);
		tagList.add(TagFromName.ZeroVelocityPixelValue);
		tagList.add(TagFromName.ContributingEquipmentSequence);
		tagList.add(TagFromName.ContributionDateTime);
		tagList.add(TagFromName.ContributionDescription);
		tagList.add(TagFromName.StudyInstanceUID);
		tagList.add(TagFromName.SeriesInstanceUID);
		tagList.add(TagFromName.StudyID);
		tagList.add(TagFromName.SeriesNumber);
		tagList.add(TagFromName.AcquisitionNumber);
		tagList.add(TagFromName.InstanceNumber);
		tagList.add(TagFromName.IsotopeNumber);
		tagList.add(TagFromName.PhaseNumber);
		tagList.add(TagFromName.IntervalNumber);
		tagList.add(TagFromName.TimeSlotNumber);
		tagList.add(TagFromName.AngleNumber);
		tagList.add(TagFromName.ItemNumber);
		tagList.add(TagFromName.PatientOrientation);
		tagList.add(TagFromName.OverlayNumber);
		tagList.add(TagFromName.CurveNumber);
		tagList.add(TagFromName.LUTNumber);
		tagList.add(TagFromName.ImagePosition);
		tagList.add(TagFromName.ImagePositionPatient);
		tagList.add(TagFromName.ImageOrientation);
		tagList.add(TagFromName.ImageOrientationPatient);
		tagList.add(TagFromName.Location);
		tagList.add(TagFromName.FrameOfReferenceUID);
		tagList.add(TagFromName.Laterality);
		tagList.add(TagFromName.ImageLaterality);
		tagList.add(TagFromName.ImageGeometryType);
		tagList.add(TagFromName.MaskingImage);
		tagList.add(TagFromName.ReportNumber);
		tagList.add(TagFromName.TemporalPositionIdentifier);
		tagList.add(TagFromName.NumberOfTemporalPositions);
		tagList.add(TagFromName.TemporalResolution);
		tagList.add(TagFromName.SynchronizationFrameOfReferenceUID);
		tagList.add(TagFromName.SOPInstanceUIDOfConcatenationSource);
		tagList.add(TagFromName.SeriesInStudy);
		tagList.add(TagFromName.AcquisitionsInSeries);
		tagList.add(TagFromName.ImagesInAcquisition);
		tagList.add(TagFromName.ImagesInSeries);
		tagList.add(TagFromName.AcquisitionsInStudy);
		tagList.add(TagFromName.ImagesInStudy);
		tagList.add(TagFromName.Reference);
		tagList.add(TagFromName.PositionReferenceIndicator);
		tagList.add(TagFromName.SliceLocation);
		tagList.add(TagFromName.OtherStudyNumbers);
		tagList.add(TagFromName.NumberOfPatientRelatedStudies);
		tagList.add(TagFromName.NumberOfPatientRelatedSeries);
		tagList.add(TagFromName.NumberOfPatientRelatedInstances);
		tagList.add(TagFromName.NumberOfStudyRelatedSeries);
		tagList.add(TagFromName.NumberOfStudyRelatedInstances);
		tagList.add(TagFromName.NumberOfSeriesRelatedInstances);
		tagList.add(TagFromName.SourceImageID);
		tagList.add(TagFromName.ModifyingDeviceID);
		tagList.add(TagFromName.ModifiedImageID);
		tagList.add(TagFromName.ModifiedImageDate);
		tagList.add(TagFromName.ModifyingDeviceManufacturer);
		tagList.add(TagFromName.ModifiedImageTime);
		tagList.add(TagFromName.ModifiedImageDescription);
		tagList.add(TagFromName.ImageComments);
		tagList.add(TagFromName.OriginalImageIdentification);
		tagList.add(TagFromName.OriginalImageIdentificationNomenclature);
		tagList.add(TagFromName.StackID);
		tagList.add(TagFromName.InStackPositionNumber);
		tagList.add(TagFromName.FrameAnatomySequence);
		tagList.add(TagFromName.FrameLaterality);
		tagList.add(TagFromName.FrameContentSequence);
		tagList.add(TagFromName.PlanePositionSequence);
		tagList.add(TagFromName.PlaneOrientationSequence);
		tagList.add(TagFromName.TemporalPositionIndex);
		tagList.add(TagFromName.NominalCardiacTriggerDelayTime);
		tagList.add(TagFromName.NominalCardiacTriggerTimePriorToRPeak);
		tagList.add(TagFromName.ActualCardiacTriggerTimePriorToRPeak);
		tagList.add(TagFromName.FrameAcquisitionNumber);
		tagList.add(TagFromName.DimensionIndexValues);
		tagList.add(TagFromName.FrameComments);
		tagList.add(TagFromName.ConcatenationUID);
		tagList.add(TagFromName.InConcatenationNumber);
		tagList.add(TagFromName.InConcatenationTotalNumber);
		tagList.add(TagFromName.DimensionOrganizationUID);
		tagList.add(TagFromName.DimensionIndexPointer);
		tagList.add(TagFromName.FunctionalGroupPointer);
		tagList.add(TagFromName.UnassignedSharedConvertedAttributesSequence);
		tagList.add(TagFromName.UnassignedPerFrameConvertedAttributesSequence);
		tagList.add(TagFromName.ConversionSourceAttributesSequence);
		tagList.add(TagFromName.DimensionIndexPrivateCreator);
		tagList.add(TagFromName.DimensionOrganizationSequence);
		tagList.add(TagFromName.DimensionIndexSequence);
		tagList.add(TagFromName.ConcatenationFrameOffsetNumber);
		tagList.add(TagFromName.FunctionalGroupPrivateCreator);
		tagList.add(TagFromName.NominalPercentageOfCardiacPhase);
		tagList.add(TagFromName.NominalPercentageOfRespiratoryPhase);
		tagList.add(TagFromName.StartingRespiratoryAmplitude);
		tagList.add(TagFromName.StartingRespiratoryPhase);
		tagList.add(TagFromName.EndingRespiratoryAmplitude);
		tagList.add(TagFromName.EndingRespiratoryPhase);
		tagList.add(TagFromName.RespiratoryTriggerType);
		tagList.add(TagFromName.RRIntervalTimeNominal);
		tagList.add(TagFromName.ActualCardiacTriggerDelayTime);
		tagList.add(TagFromName.RespiratorySynchronizationSequence);
		tagList.add(TagFromName.RespiratoryIntervalTime);
		tagList.add(TagFromName.NominalRespiratoryTriggerDelayTime);
		tagList.add(TagFromName.RespiratoryTriggerDelayThreshold);
		tagList.add(TagFromName.ActualRespiratoryTriggerDelayTime);
		tagList.add(TagFromName.ImagePositionVolume);
		tagList.add(TagFromName.ImageOrientationVolume);
		tagList.add(TagFromName.UltrasoundAcquisitionGeometry);
		tagList.add(TagFromName.ApexPosition);
		tagList.add(TagFromName.VolumeToTransducerMappingMatrix);
		tagList.add(TagFromName.VolumeToTableMappingMatrix);
		tagList.add(TagFromName.VolumeToTransducerRelationship);
		tagList.add(TagFromName.PatientFrameOfReferenceSource);
		tagList.add(TagFromName.TemporalPositionTimeOffset);
		tagList.add(TagFromName.PlanePositionVolumeSequence);
		tagList.add(TagFromName.PlaneOrientationVolumeSequence);
		tagList.add(TagFromName.TemporalPositionSequence);
		tagList.add(TagFromName.DimensionOrganizationType);
		tagList.add(TagFromName.VolumeFrameOfReferenceUID);
		tagList.add(TagFromName.TableFrameOfReferenceUID);
		tagList.add(TagFromName.DimensionDescriptionLabel);
		tagList.add(TagFromName.PatientOrientationInFrameSequence);
		tagList.add(TagFromName.FrameLabel);
		tagList.add(TagFromName.AcquisitionIndex);
		tagList.add(TagFromName.ContributingSOPInstancesReferenceSequence);
		tagList.add(TagFromName.ReconstructionIndex);
		tagList.add(TagFromName.LightPathFilterPassThroughWavelength);
		tagList.add(TagFromName.LightPathFilterPassBand);
		tagList.add(TagFromName.ImagePathFilterPassThroughWavelength);
		tagList.add(TagFromName.ImagePathFilterPassBand);
		tagList.add(TagFromName.PatientEyeMovementCommanded);
		tagList.add(TagFromName.PatientEyeMovementCommandCodeSequence);
		tagList.add(TagFromName.SphericalLensPower);
		tagList.add(TagFromName.CylinderLensPower);
		tagList.add(TagFromName.CylinderAxis);
		tagList.add(TagFromName.EmmetropicMagnification);
		tagList.add(TagFromName.IntraOcularPressure);
		tagList.add(TagFromName.HorizontalFieldOfView);
		tagList.add(TagFromName.PupilDilated);
		tagList.add(TagFromName.DegreeOfDilation);
		tagList.add(TagFromName.StereoBaselineAngle);
		tagList.add(TagFromName.StereoBaselineDisplacement);
		tagList.add(TagFromName.StereoHorizontalPixelOffset);
		tagList.add(TagFromName.StereoVerticalPixelOffset);
		tagList.add(TagFromName.StereoRotation);
		tagList.add(TagFromName.AcquisitionDeviceTypeCodeSequence);
		tagList.add(TagFromName.IlluminationTypeCodeSequence);
		tagList.add(TagFromName.LightPathFilterTypeStackCodeSequence);
		tagList.add(TagFromName.ImagePathFilterTypeStackCodeSequence);
		tagList.add(TagFromName.LensesCodeSequence);
		tagList.add(TagFromName.ChannelDescriptionCodeSequence);
		tagList.add(TagFromName.RefractiveStateSequence);
		tagList.add(TagFromName.MydriaticAgentCodeSequence);
		tagList.add(TagFromName.RelativeImagePositionCodeSequence);
		tagList.add(TagFromName.CameraAngleOfView);
		tagList.add(TagFromName.StereoPairsSequence);
		tagList.add(TagFromName.LeftImageSequence);
		tagList.add(TagFromName.RightImageSequence);
		tagList.add(TagFromName.StereoPairsPresent);
		tagList.add(TagFromName.AxialLengthOfTheEye);
		tagList.add(TagFromName.OphthalmicFrameLocationSequence);
		tagList.add(TagFromName.ReferenceCoordinates);
		tagList.add(TagFromName.DepthSpatialResolution);
		tagList.add(TagFromName.MaximumDepthDistortion);
		tagList.add(TagFromName.AlongScanSpatialResolution);
		tagList.add(TagFromName.MaximumAlongScanDistortion);
		tagList.add(TagFromName.OphthalmicImageOrientation);
		tagList.add(TagFromName.DepthOfTransverseImage);
		tagList.add(TagFromName.MydriaticAgentConcentrationUnitsSequence);
		tagList.add(TagFromName.AcrossScanSpatialResolution);
		tagList.add(TagFromName.MaximumAcrossScanDistortion);
		tagList.add(TagFromName.MydriaticAgentConcentration);
		tagList.add(TagFromName.IlluminationWaveLength);
		tagList.add(TagFromName.IlluminationPower);
		tagList.add(TagFromName.IlluminationBandwidth);
		tagList.add(TagFromName.MydriaticAgentSequence);
		tagList.add(TagFromName.OphthalmicAxialMeasurementsRightEyeSequence);
		tagList.add(TagFromName.OphthalmicAxialMeasurementsLeftEyeSequence);
		tagList.add(TagFromName.OphthalmicAxialMeasurementsDeviceType);
		tagList.add(TagFromName.OphthalmicAxialLengthMeasurementsType);
		tagList.add(TagFromName.OphthalmicAxialLengthSequence);
		tagList.add(TagFromName.OphthalmicAxialLength);
		tagList.add(TagFromName.LensStatusCodeSequence);
		tagList.add(TagFromName.VitreousStatusCodeSequence);
		tagList.add(TagFromName.IOLFormulaCodeSequence);
		tagList.add(TagFromName.IOLFormulaDetail);
		tagList.add(TagFromName.KeratometerIndex);
		tagList.add(TagFromName.SourceOfOphthalmicAxialLengthCodeSequence);
		tagList.add(TagFromName.TargetRefraction);
		tagList.add(TagFromName.RefractiveProcedureOccurred);
		tagList.add(TagFromName.RefractiveSurgeryTypeCodeSequence);
		tagList.add(TagFromName.OphthalmicUltrasoundMethodCodeSequence);
		tagList.add(TagFromName.OphthalmicAxialLengthMeasurementsSequence);
		tagList.add(TagFromName.IOLPower);
		tagList.add(TagFromName.PredictedRefractiveError);
		tagList.add(TagFromName.OphthalmicAxialLengthVelocity);
		tagList.add(TagFromName.LensStatusDescription);
		tagList.add(TagFromName.VitreousStatusDescription);
		tagList.add(TagFromName.IOLPowerSequence);
		tagList.add(TagFromName.LensConstantSequence);
		tagList.add(TagFromName.IOLManufacturer);
		tagList.add(TagFromName.LensConstantDescription);
		tagList.add(TagFromName.ImplantName);
		tagList.add(TagFromName.KeratometryMeasurementTypeCodeSequence);
		tagList.add(TagFromName.ImplantPartNumber);
		tagList.add(TagFromName.ReferencedOphthalmicAxialMeasurementsSequence);
		tagList.add(TagFromName.OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence);
		tagList.add(TagFromName.RefractiveErrorBeforeRefractiveSurgeryCodeSequence);
		tagList.add(TagFromName.IOLPowerForExactEmmetropia);
		tagList.add(TagFromName.IOLPowerForExactTargetRefraction);
		tagList.add(TagFromName.AnteriorChamberDepthDefinitionCodeSequence);
		tagList.add(TagFromName.LensThicknessSequence);
		tagList.add(TagFromName.AnteriorChamberDepthSequence);
		tagList.add(TagFromName.LensThickness);
		tagList.add(TagFromName.AnteriorChamberDepth);
		tagList.add(TagFromName.SourceOfLensThicknessDataCodeSequence);
		tagList.add(TagFromName.SourceOfAnteriorChamberDepthDataCodeSequence);
		tagList.add(TagFromName.SourceOfRefractiveMeasurementsSequence);
		tagList.add(TagFromName.SourceOfRefractiveMeasurementsCodeSequence);
		tagList.add(TagFromName.OphthalmicAxialLengthMeasurementModified);
		tagList.add(TagFromName.OphthalmicAxialLengthDataSourceCodeSequence);
		tagList.add(TagFromName.OphthalmicAxialLengthAcquisitionMethodCodeSequence);
		tagList.add(TagFromName.SignalToNoiseRatio);
		tagList.add(TagFromName.OphthalmicAxialLengthDataSourceDescription);
		tagList.add(TagFromName.OphthalmicAxialLengthMeasurementsTotalLengthSequence);
		tagList.add(TagFromName.OphthalmicAxialLengthMeasurementsSegmentalLengthSequence);
		tagList.add(TagFromName.OphthalmicAxialLengthMeasurementsLengthSummationSequence);
		tagList.add(TagFromName.UltrasoundOphthalmicAxialLengthMeasurementsSequence);
		tagList.add(TagFromName.OpticalOphthalmicAxialLengthMeasurementsSequence);
		tagList.add(TagFromName.UltrasoundSelectedOphthalmicAxialLengthSequence);
		tagList.add(TagFromName.OphthalmicAxialLengthSelectionMethodCodeSequence);
		tagList.add(TagFromName.OpticalSelectedOphthalmicAxialLengthSequence);
		tagList.add(TagFromName.SelectedSegmentalOphthalmicAxialLengthSequence);
		tagList.add(TagFromName.SelectedTotalOphthalmicAxialLengthSequence);
		tagList.add(TagFromName.OphthalmicAxialLengthQualityMetricSequence);
		tagList.add(TagFromName.OphthalmicAxialLengthQualityMetricTypeCodeSequence);
		tagList.add(TagFromName.OphthalmicAxialLengthQualityMetricTypeDescription);
		tagList.add(TagFromName.IntraocularLensCalculationsRightEyeSequence);
		tagList.add(TagFromName.IntraocularLensCalculationsLeftEyeSequence);
		tagList.add(TagFromName.ReferencedOphthalmicAxialLengthMeasurementQCImageSequence);
		tagList.add(TagFromName.OphthalmicMappingDeviceType);
		tagList.add(TagFromName.AcquisitionMethodCodeSequence);
		tagList.add(TagFromName.AcquisitionMethodAlgorithmSequence);
		tagList.add(TagFromName.OphthalmicThicknessMapTypeCodeSequence);
		tagList.add(TagFromName.OphthalmicThicknessMappingNormalsSequence);
		tagList.add(TagFromName.RetinalThicknessDefinitionCodeSequence);
		tagList.add(TagFromName.PixelValueMappingToCodedConceptSequence);
		tagList.add(TagFromName.MappedPixelValue);
		tagList.add(TagFromName.PixelValueMappingExplanation);
		tagList.add(TagFromName.OphthalmicThicknessMapQualityThresholdSequence);
		tagList.add(TagFromName.OphthalmicThicknessMapThresholdQualityRating);
		tagList.add(TagFromName.AnatomicStructureReferencePoint);
		tagList.add(TagFromName.RegistrationToLocalizerSequence);
		tagList.add(TagFromName.RegisteredLocalizerUnits);
		tagList.add(TagFromName.RegisteredLocalizerTopLeftHandCorner);
		tagList.add(TagFromName.RegisteredLocalizerBottomRightHandCorner);
		tagList.add(TagFromName.OphthalmicThicknessMapQualityRatingSequence);
		tagList.add(TagFromName.RelevantOPTAttributesSequence);
		tagList.add(TagFromName.TransformationMethodCodeSequence);
		tagList.add(TagFromName.TransformationAlgorithmSequence);
		tagList.add(TagFromName.OphthalmicAxialLengthMethod);
		tagList.add(TagFromName.OphthalmicFOV);
		tagList.add(TagFromName.TwoDimensionalToThreeDimensionalMapSequence);
		tagList.add(TagFromName.WideFieldOphthalmicPhotographyQualityRatingSequence);
		tagList.add(TagFromName.WideFieldOphthalmicPhotographyQualityThresholdSequence);
		tagList.add(TagFromName.WideFieldOphthalmicPhotographyThresholdQualityRating);
		tagList.add(TagFromName.XCoordinatesCenterPixelViewAngle);
		tagList.add(TagFromName.YCoordinatesCenterPixelViewAngle);
		tagList.add(TagFromName.NumberOfMapPoints);
		tagList.add(TagFromName.TwoDimensionalToThreeDimensionalMapData);
		tagList.add(TagFromName.VisualFieldHorizontalExtent);
		tagList.add(TagFromName.VisualFieldVerticalExtent);
		tagList.add(TagFromName.VisualFieldShape);
		tagList.add(TagFromName.ScreeningTestModeCodeSequence);
		tagList.add(TagFromName.MaximumStimulusLuminance);
		tagList.add(TagFromName.BackgroundLuminance);
		tagList.add(TagFromName.StimulusColorCodeSequence);
		tagList.add(TagFromName.BackgroundIlluminationColorCodeSequence);
		tagList.add(TagFromName.StimulusArea);
		tagList.add(TagFromName.StimulusPresentationTime);
		tagList.add(TagFromName.FixationSequence);
		tagList.add(TagFromName.FixationMonitoringCodeSequence);
		tagList.add(TagFromName.VisualFieldCatchTrialSequence);
		tagList.add(TagFromName.FixationCheckedQuantity);
		tagList.add(TagFromName.PatientNotProperlyFixatedQuantity);
		tagList.add(TagFromName.PresentedVisualStimuliDataFlag);
		tagList.add(TagFromName.NumberOfVisualStimuli);
		tagList.add(TagFromName.ExcessiveFixationLossesDataFlag);
		tagList.add(TagFromName.ExcessiveFixationLosses);
		tagList.add(TagFromName.StimuliRetestingQuantity);
		tagList.add(TagFromName.CommentsOnPatientPerformanceOfVisualField);
		tagList.add(TagFromName.FalseNegativesEstimateFlag);
		tagList.add(TagFromName.FalseNegativesEstimate);
		tagList.add(TagFromName.NegativeCatchTrialsQuantity);
		tagList.add(TagFromName.FalseNegativesQuantity);
		tagList.add(TagFromName.ExcessiveFalseNegativesDataFlag);
		tagList.add(TagFromName.ExcessiveFalseNegatives);
		tagList.add(TagFromName.FalsePositivesEstimateFlag);
		tagList.add(TagFromName.FalsePositivesEstimate);
		tagList.add(TagFromName.CatchTrialsDataFlag);
		tagList.add(TagFromName.PositiveCatchTrialsQuantity);
		tagList.add(TagFromName.TestPointNormalsDataFlag);
		tagList.add(TagFromName.TestPointNormalsSequence);
		tagList.add(TagFromName.GlobalDeviationProbabilityNormalsFlag);
		tagList.add(TagFromName.FalsePositivesQuantity);
		tagList.add(TagFromName.ExcessiveFalsePositivesDataFlag);
		tagList.add(TagFromName.ExcessiveFalsePositives);
		tagList.add(TagFromName.VisualFieldTestNormalsFlag);
		tagList.add(TagFromName.ResultsNormalsSequence);
		tagList.add(TagFromName.AgeCorrectedSensitivityDeviationAlgorithmSequence);
		tagList.add(TagFromName.GlobalDeviationFromNormal);
		tagList.add(TagFromName.GeneralizedDefectSensitivityDeviationAlgorithmSequence);
		tagList.add(TagFromName.LocalizedDeviationFromNormal);
		tagList.add(TagFromName.PatientReliabilityIndicator);
		tagList.add(TagFromName.VisualFieldMeanSensitivity);
		tagList.add(TagFromName.GlobalDeviationProbability);
		tagList.add(TagFromName.LocalDeviationProbabilityNormalsFlag);
		tagList.add(TagFromName.LocalizedDeviationProbability);
		tagList.add(TagFromName.ShortTermFluctuationCalculated);
		tagList.add(TagFromName.ShortTermFluctuation);
		tagList.add(TagFromName.ShortTermFluctuationProbabilityCalculated);
		tagList.add(TagFromName.ShortTermFluctuationProbability);
		tagList.add(TagFromName.CorrectedLocalizedDeviationFromNormalCalculated);
		tagList.add(TagFromName.CorrectedLocalizedDeviationFromNormal);
		tagList.add(TagFromName.CorrectedLocalizedDeviationFromNormalProbabilityCalculated);
		tagList.add(TagFromName.CorrectedLocalizedDeviationFromNormalProbability);
		tagList.add(TagFromName.GlobalDeviationProbabilitySequence);
		tagList.add(TagFromName.LocalizedDeviationProbabilitySequence);
		tagList.add(TagFromName.FovealSensitivityMeasured);
		tagList.add(TagFromName.FovealSensitivity);
		tagList.add(TagFromName.VisualFieldTestDuration);
		tagList.add(TagFromName.VisualFieldTestPointSequence);
		tagList.add(TagFromName.VisualFieldTestPointXCoordinate);
		tagList.add(TagFromName.VisualFieldTestPointYCoordinate);
		tagList.add(TagFromName.AgeCorrectedSensitivityDeviationValue);
		tagList.add(TagFromName.StimulusResults);
		tagList.add(TagFromName.SensitivityValue);
		tagList.add(TagFromName.RetestStimulusSeen);
		tagList.add(TagFromName.RetestSensitivityValue);
		tagList.add(TagFromName.VisualFieldTestPointNormalsSequence);
		tagList.add(TagFromName.QuantifiedDefect);
		tagList.add(TagFromName.AgeCorrectedSensitivityDeviationProbabilityValue);
		tagList.add(TagFromName.GeneralizedDefectCorrectedSensitivityDeviationFlag);
		tagList.add(TagFromName.GeneralizedDefectCorrectedSensitivityDeviationValue);
		tagList.add(TagFromName.GeneralizedDefectCorrectedSensitivityDeviationProbabilityValue);
		tagList.add(TagFromName.MinimumSensitivityValue);
		tagList.add(TagFromName.BlindSpotLocalized);
		tagList.add(TagFromName.BlindSpotXCoordinate);
		tagList.add(TagFromName.BlindSpotYCoordinate);
		tagList.add(TagFromName.VisualAcuityMeasurementSequence);
		tagList.add(TagFromName.RefractiveParametersUsedOnPatientSequence);
		tagList.add(TagFromName.MeasurementLaterality);
		tagList.add(TagFromName.OphthalmicPatientClinicalInformationLeftEyeSequence);
		tagList.add(TagFromName.OphthalmicPatientClinicalInformationRightEyeSequence);
		tagList.add(TagFromName.FovealPointNormativeDataFlag);
		tagList.add(TagFromName.FovealPointProbabilityValue);
		tagList.add(TagFromName.ScreeningBaselineMeasured);
		tagList.add(TagFromName.ScreeningBaselineMeasuredSequence);
		tagList.add(TagFromName.ScreeningBaselineType);
		tagList.add(TagFromName.ScreeningBaselineValue);
		tagList.add(TagFromName.AlgorithmSource);
		tagList.add(TagFromName.DataSetName);
		tagList.add(TagFromName.DataSetVersion);
		tagList.add(TagFromName.DataSetSource);
		tagList.add(TagFromName.DataSetDescription);
		tagList.add(TagFromName.VisualFieldTestReliabilityGlobalIndexSequence);
		tagList.add(TagFromName.VisualFieldGlobalResultsIndexSequence);
		tagList.add(TagFromName.DataObservationSequence);
		tagList.add(TagFromName.IndexNormalsFlag);
		tagList.add(TagFromName.IndexProbability);
		tagList.add(TagFromName.IndexProbabilitySequence);
		tagList.add(TagFromName.SamplesPerPixel);
		tagList.add(TagFromName.SamplesPerPixelUsed);
		tagList.add(TagFromName.PhotometricInterpretation);
		tagList.add(TagFromName.ImageDimensions);
		tagList.add(TagFromName.PlanarConfiguration);
		tagList.add(TagFromName.NumberOfFrames);
		tagList.add(TagFromName.FrameIncrementPointer);
		tagList.add(TagFromName.FrameDimensionPointer);
		tagList.add(TagFromName.Rows);
		tagList.add(TagFromName.Columns);
		tagList.add(TagFromName.Planes);
		tagList.add(TagFromName.UltrasoundColorDataPresent);
		tagList.add(TagFromName.PixelSpacing);
		tagList.add(TagFromName.ZoomFactor);
		tagList.add(TagFromName.ZoomCenter);
		tagList.add(TagFromName.PixelAspectRatio);
		tagList.add(TagFromName.ImageFormat);
		tagList.add(TagFromName.ManipulatedImage);
		tagList.add(TagFromName.CorrectedImage);
		tagList.add(TagFromName.CompressionRecognitionCode);
		tagList.add(TagFromName.CompressionCode);
		tagList.add(TagFromName.CompressionOriginator);
		tagList.add(TagFromName.CompressionLabel);
		tagList.add(TagFromName.CompressionDescription);
		tagList.add(TagFromName.CompressionSequence);
		tagList.add(TagFromName.CompressionStepPointers);
		tagList.add(TagFromName.RepeatInterval);
		tagList.add(TagFromName.BitsGrouped);
		tagList.add(TagFromName.PerimeterTable);
		tagList.add(TagFromName.PerimeterValue);
		tagList.add(TagFromName.PredictorRows);
		tagList.add(TagFromName.PredictorColumns);
		tagList.add(TagFromName.PredictorConstants);
		tagList.add(TagFromName.BlockedPixels);
		tagList.add(TagFromName.BlockRows);
		tagList.add(TagFromName.BlockColumns);
		tagList.add(TagFromName.RowOverlap);
		tagList.add(TagFromName.ColumnOverlap);
		tagList.add(TagFromName.BitsAllocated);
		tagList.add(TagFromName.BitsStored);
		tagList.add(TagFromName.HighBit);
		tagList.add(TagFromName.PixelRepresentation);
		tagList.add(TagFromName.SmallestValidPixelValue);
		tagList.add(TagFromName.LargestValidPixelValue);
		tagList.add(TagFromName.SmallestImagePixelValue);
		tagList.add(TagFromName.LargestImagePixelValue);
		tagList.add(TagFromName.SmallestPixelValueInSeries);
		tagList.add(TagFromName.LargestPixelValueInSeries);
		tagList.add(TagFromName.SmallestImagePixelValueInPlane);
		tagList.add(TagFromName.LargestImagePixelValueInPlane);
		tagList.add(TagFromName.PixelPaddingValue);
		tagList.add(TagFromName.PixelPaddingRangeLimit);
		tagList.add(TagFromName.FloatPixelPaddingValue);
		tagList.add(TagFromName.DoubleFloatPixelPaddingValue);
		tagList.add(TagFromName.FloatPixelPaddingRangeLimit);
		tagList.add(TagFromName.DoubleFloatPixelPaddingRangeLimit);
		tagList.add(TagFromName.ImageLocation);
		tagList.add(TagFromName.QualityControlImage);
		tagList.add(TagFromName.BurnedInAnnotation);
		tagList.add(TagFromName.RecognizableVisualFeatures);
		tagList.add(TagFromName.LongitudinalTemporalInformationModified);
		tagList.add(TagFromName.ReferencedColorPaletteInstanceUID);
		tagList.add(TagFromName.TransformLabel);
		tagList.add(TagFromName.TransformVersionNumber);
		tagList.add(TagFromName.NumberOfTransformSteps);
		tagList.add(TagFromName.SequenceOfCompressedData);
		tagList.add(TagFromName.DetailsOfCoefficients);
		tagList.add(TagFromName.DCTLabel);
		tagList.add(TagFromName.DataBlockDescription);
		tagList.add(TagFromName.DataBlock);
		tagList.add(TagFromName.NormalizationFactorFormat);
		tagList.add(TagFromName.ZonalMapNumberFormat);
		tagList.add(TagFromName.ZonalMapLocation);
		tagList.add(TagFromName.ZonalMapFormat);
		tagList.add(TagFromName.AdaptiveMapFormat);
		tagList.add(TagFromName.CodeNumberFormat);
		tagList.add(TagFromName.PixelSpacingCalibrationType);
		tagList.add(TagFromName.PixelSpacingCalibrationDescription);
		tagList.add(TagFromName.PixelIntensityRelationship);
		tagList.add(TagFromName.PixelIntensityRelationshipSign);
		tagList.add(TagFromName.WindowCenter);
		tagList.add(TagFromName.WindowWidth);
		tagList.add(TagFromName.RescaleIntercept);
		tagList.add(TagFromName.RescaleSlope);
		tagList.add(TagFromName.RescaleType);
		tagList.add(TagFromName.WindowCenterWidthExplanation);
		tagList.add(TagFromName.VOILUTFunction);
		tagList.add(TagFromName.GrayScale);
		tagList.add(TagFromName.RecommendedViewingMode);
		tagList.add(TagFromName.GrayLookupTableDescriptor);
		tagList.add(TagFromName.RedPaletteColorLookupTableDescriptor);
		tagList.add(TagFromName.GreenPaletteColorLookupTableDescriptor);
		tagList.add(TagFromName.BluePaletteColorLookupTableDescriptor);
		tagList.add(TagFromName.AlphaPaletteColorLookupTableDescriptor);
		tagList.add(TagFromName.LargeRedPaletteColorLookupTableDescriptor);
		tagList.add(TagFromName.LargeGreenPaletteColorLookupTableDescriptor);
		tagList.add(TagFromName.LargeBluePaletteColorLookupTableDescriptor);
		tagList.add(TagFromName.PaletteColorLookupTableUID);
		tagList.add(TagFromName.GrayLookupTableData);
		tagList.add(TagFromName.RedPaletteColorLookupTableData);
		tagList.add(TagFromName.GreenPaletteColorLookupTableData);
		tagList.add(TagFromName.BluePaletteColorLookupTableData);
		tagList.add(TagFromName.AlphaPaletteColorLookupTableData);
		tagList.add(TagFromName.LargeRedPaletteColorLookupTableData);
		tagList.add(TagFromName.LargeGreenPaletteColorLookupTableData);
		tagList.add(TagFromName.LargeBluePaletteColorLookupTableData);
		tagList.add(TagFromName.LargePaletteColorLookupTableUID);
		tagList.add(TagFromName.SegmentedRedPaletteColorLookupTableData);
		tagList.add(TagFromName.SegmentedGreenPaletteColorLookupTableData);
		tagList.add(TagFromName.SegmentedBluePaletteColorLookupTableData);
		tagList.add(TagFromName.SegmentedAlphaPaletteColorLookupTableData);
		tagList.add(TagFromName.BreastImplantPresent);
		tagList.add(TagFromName.PartialView);
		tagList.add(TagFromName.PartialViewDescription);
		tagList.add(TagFromName.PartialViewCodeSequence);
		tagList.add(TagFromName.SpatialLocationsPreserved);
		tagList.add(TagFromName.DataFrameAssignmentSequence);
		tagList.add(TagFromName.DataPathAssignment);
		tagList.add(TagFromName.BitsMappedToColorLookupTable);
		tagList.add(TagFromName.BlendingLUT1Sequence);
		tagList.add(TagFromName.BlendingLUT1TransferFunction);
		tagList.add(TagFromName.BlendingWeightConstant);
		tagList.add(TagFromName.BlendingLookupTableDescriptor);
		tagList.add(TagFromName.BlendingLookupTableData);
		tagList.add(TagFromName.EnhancedPaletteColorLookupTableSequence);
		tagList.add(TagFromName.BlendingLUT2Sequence);
		tagList.add(TagFromName.BlendingLUT2TransferFunction);
		tagList.add(TagFromName.DataPathID);
		tagList.add(TagFromName.RGBLUTTransferFunction);
		tagList.add(TagFromName.AlphaLUTTransferFunction);
		tagList.add(TagFromName.ICCProfile);
		tagList.add(TagFromName.ColorSpace);
		tagList.add(TagFromName.LossyImageCompression);
		tagList.add(TagFromName.LossyImageCompressionRatio);
		tagList.add(TagFromName.LossyImageCompressionMethod);
		tagList.add(TagFromName.ModalityLUTSequence);
		tagList.add(TagFromName.LUTDescriptor);
		tagList.add(TagFromName.LUTExplanation);
		tagList.add(TagFromName.ModalityLUTType);
		tagList.add(TagFromName.LUTData);
		tagList.add(TagFromName.VOILUTSequence);
		tagList.add(TagFromName.SoftcopyVOILUTSequence);
		tagList.add(TagFromName.ImagePresentationComments);
		tagList.add(TagFromName.BiPlaneAcquisitionSequence);
		tagList.add(TagFromName.RepresentativeFrameNumber);
		tagList.add(TagFromName.FrameNumbersOfInterest);
		tagList.add(TagFromName.FrameOfInterestDescription);
		tagList.add(TagFromName.FrameOfInterestType);
		tagList.add(TagFromName.MaskPointers);
		tagList.add(TagFromName.RWavePointer);
		tagList.add(TagFromName.MaskSubtractionSequence);
		tagList.add(TagFromName.MaskOperation);
		tagList.add(TagFromName.ApplicableFrameRange);
		tagList.add(TagFromName.MaskFrameNumbers);
		tagList.add(TagFromName.ContrastFrameAveraging);
		tagList.add(TagFromName.MaskSubPixelShift);
		tagList.add(TagFromName.TIDOffset);
		tagList.add(TagFromName.MaskOperationExplanation);
		tagList.add(TagFromName.EquipmentAdministratorSequence);
		tagList.add(TagFromName.NumberOfDisplaySubsystems);
		tagList.add(TagFromName.CurrentConfigurationID);
		tagList.add(TagFromName.DisplaySystemID);
		tagList.add(TagFromName.DisplaySubsystemName);
		tagList.add(TagFromName.DisplaySubsystemDescription);
		tagList.add(TagFromName.SystemStatus);
		tagList.add(TagFromName.SystemStatusComment);
		tagList.add(TagFromName.TargetLuminanceCharacteristicsSequence);
		tagList.add(TagFromName.LuminanceCharacteristicsID);
		tagList.add(TagFromName.DisplaySubsystemConfigurationSequence);
		tagList.add(TagFromName.ConfigurationID);
		tagList.add(TagFromName.ConfigurationName);
		tagList.add(TagFromName.ConfigurationDescription);
		tagList.add(TagFromName.ReferencedTargetLuminanceCharacteristicsID);
		tagList.add(TagFromName.QAResultsSequence);
		tagList.add(TagFromName.DisplaySubsystemQAResultsSequence);
		tagList.add(TagFromName.ConfigurationQAResultsSequence);
		tagList.add(TagFromName.MeasurementEquipmentSequence);
		tagList.add(TagFromName.MeasurementFunctions);
		tagList.add(TagFromName.MeasurementEquipmentType);
		tagList.add(TagFromName.VisualEvaluationResultSequence);
		tagList.add(TagFromName.DisplayCalibrationResultSequence);
		tagList.add(TagFromName.DDLValue);
		tagList.add(TagFromName.CIExyWhitePoint);
		tagList.add(TagFromName.DisplayFunctionType);
		tagList.add(TagFromName.GammaValue);
		tagList.add(TagFromName.NumberOfLuminancePoints);
		tagList.add(TagFromName.LuminanceResponseSequence);
		tagList.add(TagFromName.TargetMinimumLuminance);
		tagList.add(TagFromName.TargetMaximumLuminance);
		tagList.add(TagFromName.LuminanceValue);
		tagList.add(TagFromName.LuminanceResponseDescription);
		tagList.add(TagFromName.WhitePointFlag);
		tagList.add(TagFromName.DisplayDeviceTypeCodeSequence);
		tagList.add(TagFromName.DisplaySubsystemSequence);
		tagList.add(TagFromName.LuminanceResultSequence);
		tagList.add(TagFromName.AmbientLightValueSource);
		tagList.add(TagFromName.MeasuredCharacteristics);
		tagList.add(TagFromName.LuminanceUniformityResultSequence);
		tagList.add(TagFromName.VisualEvaluationTestSequence);
		tagList.add(TagFromName.TestResult);
		tagList.add(TagFromName.TestResultComment);
		tagList.add(TagFromName.TestImageValidation);
		tagList.add(TagFromName.TestPatternCodeSequence);
		tagList.add(TagFromName.MeasurementPatternCodeSequence);
		tagList.add(TagFromName.VisualEvaluationMethodCodeSequence);
		tagList.add(TagFromName.PixelDataProviderURL);
		tagList.add(TagFromName.DataPointRows);
		tagList.add(TagFromName.DataPointColumns);
		tagList.add(TagFromName.SignalDomainColumns);
		tagList.add(TagFromName.LargestMonochromePixelValue);
		tagList.add(TagFromName.DataRepresentation);
		tagList.add(TagFromName.PixelMeasuresSequence);
		tagList.add(TagFromName.FrameVOILUTSequence);
		tagList.add(TagFromName.PixelValueTransformationSequence);
		tagList.add(TagFromName.SignalDomainRows);
		tagList.add(TagFromName.DisplayFilterPercentage);
		tagList.add(TagFromName.FramePixelShiftSequence);
		tagList.add(TagFromName.SubtractionItemID);
		tagList.add(TagFromName.PixelIntensityRelationshipLUTSequence);
		tagList.add(TagFromName.FramePixelDataPropertiesSequence);
		tagList.add(TagFromName.GeometricalProperties);
		tagList.add(TagFromName.GeometricMaximumDistortion);
		tagList.add(TagFromName.ImageProcessingApplied);
		tagList.add(TagFromName.MaskSelectionMode);
		tagList.add(TagFromName.LUTFunction);
		tagList.add(TagFromName.MaskVisibilityPercentage);
		tagList.add(TagFromName.PixelShiftSequence);
		tagList.add(TagFromName.RegionPixelShiftSequence);
		tagList.add(TagFromName.VerticesOfTheRegion);
		tagList.add(TagFromName.MultiFramePresentationSequence);
		tagList.add(TagFromName.PixelShiftFrameRange);
		tagList.add(TagFromName.LUTFrameRange);
		tagList.add(TagFromName.ImageToEquipmentMappingMatrix);
		tagList.add(TagFromName.EquipmentCoordinateSystemIdentification);
		tagList.add(TagFromName.StudyStatusID);
		tagList.add(TagFromName.StudyPriorityID);
		tagList.add(TagFromName.StudyIDIssuer);
		tagList.add(TagFromName.StudyVerifiedDate);
		tagList.add(TagFromName.StudyVerifiedTime);
		tagList.add(TagFromName.StudyReadDate);
		tagList.add(TagFromName.StudyReadTime);
		tagList.add(TagFromName.ScheduledStudyStartDate);
		tagList.add(TagFromName.ScheduledStudyStartTime);
		tagList.add(TagFromName.ScheduledStudyStopDate);
		tagList.add(TagFromName.ScheduledStudyStopTime);
		tagList.add(TagFromName.ScheduledStudyLocation);
		tagList.add(TagFromName.ScheduledStudyLocationAETitle);
		tagList.add(TagFromName.ReasonForStudy);
		tagList.add(TagFromName.RequestingPhysicianIdentificationSequence);
		tagList.add(TagFromName.RequestingPhysician);
		tagList.add(TagFromName.RequestingService);
		tagList.add(TagFromName.RequestingServiceCodeSequence);
		tagList.add(TagFromName.StudyArrivalDate);
		tagList.add(TagFromName.StudyArrivalTime);
		tagList.add(TagFromName.StudyCompletionDate);
		tagList.add(TagFromName.StudyCompletionTime);
		tagList.add(TagFromName.StudyComponentStatusID);
		tagList.add(TagFromName.RequestedProcedureDescription);
		tagList.add(TagFromName.RequestedProcedureCodeSequence);
		tagList.add(TagFromName.RequestedContrastAgent);
		tagList.add(TagFromName.StudyComments);
		tagList.add(TagFromName.ReferencedPatientAliasSequence);
		tagList.add(TagFromName.VisitStatusID);
		tagList.add(TagFromName.AdmissionID);
		tagList.add(TagFromName.IssuerOfAdmissionID);
		tagList.add(TagFromName.IssuerOfAdmissionIDSequence);
		tagList.add(TagFromName.RouteOfAdmissions);
		tagList.add(TagFromName.ScheduledAdmissionDate);
		tagList.add(TagFromName.ScheduledAdmissionTime);
		tagList.add(TagFromName.ScheduledDischargeDate);
		tagList.add(TagFromName.ScheduledDischargeTime);
		tagList.add(TagFromName.ScheduledPatientInstitutionResidence);
		tagList.add(TagFromName.AdmittingDate);
		tagList.add(TagFromName.AdmittingTime);
		tagList.add(TagFromName.DischargeDate);
		tagList.add(TagFromName.DischargeTime);
		tagList.add(TagFromName.DischargeDiagnosisDescription);
		tagList.add(TagFromName.DischargeDiagnosisCodeSequence);
		tagList.add(TagFromName.SpecialNeeds);
		tagList.add(TagFromName.ServiceEpisodeID);
		tagList.add(TagFromName.IssuerOfServiceEpisodeID);
		tagList.add(TagFromName.ServiceEpisodeDescription);
		tagList.add(TagFromName.IssuerOfServiceEpisodeIDSequence);
		tagList.add(TagFromName.PertinentDocumentsSequence);
		tagList.add(TagFromName.PertinentResourcesSequence);
		tagList.add(TagFromName.ResourceDescription);
		tagList.add(TagFromName.CurrentPatientLocation);
		tagList.add(TagFromName.PatientInstitutionResidence);
		tagList.add(TagFromName.PatientState);
		tagList.add(TagFromName.PatientClinicalTrialParticipationSequence);
		tagList.add(TagFromName.VisitComments);
		tagList.add(TagFromName.WaveformOriginality);
		tagList.add(TagFromName.NumberOfWaveformChannels);
		tagList.add(TagFromName.NumberOfWaveformSamples);
		tagList.add(TagFromName.SamplingFrequency);
		tagList.add(TagFromName.MultiplexGroupLabel);
		tagList.add(TagFromName.ChannelDefinitionSequence);
		tagList.add(TagFromName.WaveformChannelNumber);
		tagList.add(TagFromName.ChannelLabel);
		tagList.add(TagFromName.ChannelStatus);
		tagList.add(TagFromName.ChannelSourceSequence);
		tagList.add(TagFromName.ChannelSourceModifiersSequence);
		tagList.add(TagFromName.SourceWaveformSequence);
		tagList.add(TagFromName.ChannelDerivationDescription);
		tagList.add(TagFromName.ChannelSensitivity);
		tagList.add(TagFromName.ChannelSensitivityUnitsSequence);
		tagList.add(TagFromName.ChannelSensitivityCorrectionFactor);
		tagList.add(TagFromName.ChannelBaseline);
		tagList.add(TagFromName.ChannelTimeSkew);
		tagList.add(TagFromName.ChannelSampleSkew);
		tagList.add(TagFromName.ChannelOffset);
		tagList.add(TagFromName.WaveformBitsStored);
		tagList.add(TagFromName.FilterLowFrequency);
		tagList.add(TagFromName.FilterHighFrequency);
		tagList.add(TagFromName.NotchFilterFrequency);
		tagList.add(TagFromName.NotchFilterBandwidth);
		tagList.add(TagFromName.WaveformDataDisplayScale);
		tagList.add(TagFromName.WaveformDisplayBackgroundCIELabValue);
		tagList.add(TagFromName.WaveformPresentationGroupSequence);
		tagList.add(TagFromName.PresentationGroupNumber);
		tagList.add(TagFromName.ChannelDisplaySequence);
		tagList.add(TagFromName.ChannelRecommendedDisplayCIELabValue);
		tagList.add(TagFromName.ChannelPosition);
		tagList.add(TagFromName.DisplayShadingFlag);
		tagList.add(TagFromName.FractionalChannelDisplayScale);
		tagList.add(TagFromName.AbsoluteChannelDisplayScale);
		tagList.add(TagFromName.MultiplexedAudioChannelsDescriptionCodeSequence);
		tagList.add(TagFromName.ChannelIdentificationCode);
		tagList.add(TagFromName.ChannelMode);
		tagList.add(TagFromName.ScheduledStationAETitle);
		tagList.add(TagFromName.ScheduledProcedureStepStartDate);
		tagList.add(TagFromName.ScheduledProcedureStepStartTime);
		tagList.add(TagFromName.ScheduledProcedureStepEndDate);
		tagList.add(TagFromName.ScheduledProcedureStepEndTime);
		tagList.add(TagFromName.ScheduledPerformingPhysicianName);
		tagList.add(TagFromName.ScheduledProcedureStepDescription);
		tagList.add(TagFromName.ScheduledProtocolCodeSequence);
		tagList.add(TagFromName.ScheduledProcedureStepID);
		tagList.add(TagFromName.StageCodeSequence);
		tagList.add(TagFromName.ScheduledPerformingPhysicianIdentificationSequence);
		tagList.add(TagFromName.ScheduledStationName);
		tagList.add(TagFromName.ScheduledProcedureStepLocation);
		tagList.add(TagFromName.PreMedication);
		tagList.add(TagFromName.ScheduledProcedureStepStatus);
		tagList.add(TagFromName.OrderPlacerIdentifierSequence);
		tagList.add(TagFromName.OrderFillerIdentifierSequence);
		tagList.add(TagFromName.LocalNamespaceEntityID);
		tagList.add(TagFromName.UniversalEntityID);
		tagList.add(TagFromName.UniversalEntityIDType);
		tagList.add(TagFromName.IdentifierTypeCode);
		tagList.add(TagFromName.AssigningFacilitySequence);
		tagList.add(TagFromName.AssigningJurisdictionCodeSequence);
		tagList.add(TagFromName.AssigningAgencyOrDepartmentCodeSequence);
		tagList.add(TagFromName.ScheduledProcedureStepSequence);
		tagList.add(TagFromName.ReferencedNonImageCompositeSOPInstanceSequence);
		tagList.add(TagFromName.PerformedStationAETitle);
		tagList.add(TagFromName.PerformedStationName);
		tagList.add(TagFromName.PerformedLocation);
		tagList.add(TagFromName.PerformedProcedureStepStartDate);
		tagList.add(TagFromName.PerformedProcedureStepStartTime);
		tagList.add(TagFromName.PerformedProcedureStepEndDate);
		tagList.add(TagFromName.PerformedProcedureStepEndTime);
		tagList.add(TagFromName.PerformedProcedureStepStatus);
		tagList.add(TagFromName.PerformedProcedureStepID);
		tagList.add(TagFromName.PerformedProcedureStepDescription);
		tagList.add(TagFromName.PerformedProcedureTypeDescription);
		tagList.add(TagFromName.PerformedProtocolCodeSequence);
		tagList.add(TagFromName.PerformedProtocolType);
		tagList.add(TagFromName.ScheduledStepAttributesSequence);
		tagList.add(TagFromName.RequestAttributesSequence);
		tagList.add(TagFromName.CommentsOnThePerformedProcedureStep);
		tagList.add(TagFromName.PerformedProcedureStepDiscontinuationReasonCodeSequence);
		tagList.add(TagFromName.QuantitySequence);
		tagList.add(TagFromName.Quantity);
		tagList.add(TagFromName.MeasuringUnitsSequence);
		tagList.add(TagFromName.BillingItemSequence);
		tagList.add(TagFromName.TotalTimeOfFluoroscopy);
		tagList.add(TagFromName.TotalNumberOfExposures);
		tagList.add(TagFromName.EntranceDose);
		tagList.add(TagFromName.ExposedArea);
		tagList.add(TagFromName.DistanceSourceToEntrance);
		tagList.add(TagFromName.DistanceSourceToSupport);
		tagList.add(TagFromName.ExposureDoseSequence);
		tagList.add(TagFromName.CommentsOnRadiationDose);
		tagList.add(TagFromName.XRayOutput);
		tagList.add(TagFromName.HalfValueLayer);
		tagList.add(TagFromName.OrganDose);
		tagList.add(TagFromName.OrganExposed);
		tagList.add(TagFromName.BillingProcedureStepSequence);
		tagList.add(TagFromName.FilmConsumptionSequence);
		tagList.add(TagFromName.BillingSuppliesAndDevicesSequence);
		tagList.add(TagFromName.ReferencedProcedureStepSequence);
		tagList.add(TagFromName.PerformedSeriesSequence);
		tagList.add(TagFromName.CommentsOnTheScheduledProcedureStep);
		tagList.add(TagFromName.ProtocolContextSequence);
		tagList.add(TagFromName.ContentItemModifierSequence);
		tagList.add(TagFromName.ScheduledSpecimenSequence);
		tagList.add(TagFromName.SpecimenAccessionNumber);
		tagList.add(TagFromName.ContainerIdentifier);
		tagList.add(TagFromName.IssuerOfTheContainerIdentifierSequence);
		tagList.add(TagFromName.AlternateContainerIdentifierSequence);
		tagList.add(TagFromName.ContainerTypeCodeSequence);
		tagList.add(TagFromName.ContainerDescription);
		tagList.add(TagFromName.ContainerComponentSequence);
		tagList.add(TagFromName.SpecimenSequence);
		tagList.add(TagFromName.SpecimenIdentifier);
		tagList.add(TagFromName.SpecimenDescriptionSequenceTrial);
		tagList.add(TagFromName.SpecimenDescriptionTrial);
		tagList.add(TagFromName.SpecimenUID);
		tagList.add(TagFromName.AcquisitionContextSequence);
		tagList.add(TagFromName.AcquisitionContextDescription);
		tagList.add(TagFromName.SpecimenDescriptionSequence);
		tagList.add(TagFromName.IssuerOfTheSpecimenIdentifierSequence);
		tagList.add(TagFromName.SpecimenTypeCodeSequence);
		tagList.add(TagFromName.SpecimenShortDescription);
		tagList.add(TagFromName.SpecimenDetailedDescription);
		tagList.add(TagFromName.SpecimenPreparationSequence);
		tagList.add(TagFromName.SpecimenPreparationStepContentItemSequence);
		tagList.add(TagFromName.SpecimenLocalizationContentItemSequence);
		tagList.add(TagFromName.SlideIdentifier);
		tagList.add(TagFromName.ImageCenterPointCoordinatesSequence);
		tagList.add(TagFromName.XOffsetInSlideCoordinateSystem);
		tagList.add(TagFromName.YOffsetInSlideCoordinateSystem);
		tagList.add(TagFromName.ZOffsetInSlideCoordinateSystem);
		tagList.add(TagFromName.PixelSpacingSequence);
		tagList.add(TagFromName.CoordinateSystemAxisCodeSequence);
		tagList.add(TagFromName.MeasurementUnitsCodeSequence);
		tagList.add(TagFromName.VitalStainCodeSequenceTrial);
		tagList.add(TagFromName.RequestedProcedureID);
		tagList.add(TagFromName.ReasonForTheRequestedProcedure);
		tagList.add(TagFromName.RequestedProcedurePriority);
		tagList.add(TagFromName.PatientTransportArrangements);
		tagList.add(TagFromName.RequestedProcedureLocation);
		tagList.add(TagFromName.PlacerOrderNumberProcedure);
		tagList.add(TagFromName.FillerOrderNumberProcedure);
		tagList.add(TagFromName.ConfidentialityCode);
		tagList.add(TagFromName.ReportingPriority);
		tagList.add(TagFromName.ReasonForRequestedProcedureCodeSequence);
		tagList.add(TagFromName.NamesOfIntendedRecipientsOfResults);
		tagList.add(TagFromName.IntendedRecipientsOfResultsIdentificationSequence);
		tagList.add(TagFromName.ReasonForPerformedProcedureCodeSequence);
		tagList.add(TagFromName.RequestedProcedureDescriptionTrial);
		tagList.add(TagFromName.PersonIdentificationCodeSequence);
		tagList.add(TagFromName.PersonAddress);
		tagList.add(TagFromName.PersonTelephoneNumbers);
		tagList.add(TagFromName.PersonTelecomInformation);
		tagList.add(TagFromName.RequestedProcedureComments);
		tagList.add(TagFromName.ReasonForTheImagingServiceRequest);
		tagList.add(TagFromName.IssueDateOfImagingServiceRequest);
		tagList.add(TagFromName.IssueTimeOfImagingServiceRequest);
		tagList.add(TagFromName.PlacerOrderNumberImagingServiceRequestRetired);
		tagList.add(TagFromName.FillerOrderNumberImagingServiceRequestRetired);
		tagList.add(TagFromName.OrderEnteredBy);
		tagList.add(TagFromName.OrderEntererLocation);
		tagList.add(TagFromName.OrderCallbackPhoneNumber);
		tagList.add(TagFromName.OrderCallbackTelecomInformation);
		tagList.add(TagFromName.PlacerOrderNumberImagingServiceRequest);
		tagList.add(TagFromName.FillerOrderNumberImagingServiceRequest);
		tagList.add(TagFromName.ImagingServiceRequestComments);
		tagList.add(TagFromName.ConfidentialityConstraintOnPatientDataDescription);
		tagList.add(TagFromName.GeneralPurposeScheduledProcedureStepStatus);
		tagList.add(TagFromName.GeneralPurposePerformedProcedureStepStatus);
		tagList.add(TagFromName.GeneralPurposeScheduledProcedureStepPriority);
		tagList.add(TagFromName.ScheduledProcessingApplicationsCodeSequence);
		tagList.add(TagFromName.ScheduledProcedureStepStartDateTime);
		tagList.add(TagFromName.MultipleCopiesFlag);
		tagList.add(TagFromName.PerformedProcessingApplicationsCodeSequence);
		tagList.add(TagFromName.HumanPerformerCodeSequence);
		tagList.add(TagFromName.ScheduledProcedureStepModificationDateTime);
		tagList.add(TagFromName.ExpectedCompletionDateTime);
		tagList.add(TagFromName.ResultingGeneralPurposePerformedProcedureStepsSequence);
		tagList.add(TagFromName.ReferencedGeneralPurposeScheduledProcedureStepSequence);
		tagList.add(TagFromName.ScheduledWorkitemCodeSequence);
		tagList.add(TagFromName.PerformedWorkitemCodeSequence);
		tagList.add(TagFromName.InputAvailabilityFlag);
		tagList.add(TagFromName.InputInformationSequence);
		tagList.add(TagFromName.RelevantInformationSequence);
		tagList.add(TagFromName.ReferencedGeneralPurposeScheduledProcedureStepTransactionUID);
		tagList.add(TagFromName.ScheduledStationNameCodeSequence);
		tagList.add(TagFromName.ScheduledStationClassCodeSequence);
		tagList.add(TagFromName.ScheduledStationGeographicLocationCodeSequence);
		tagList.add(TagFromName.PerformedStationNameCodeSequence);
		tagList.add(TagFromName.PerformedStationClassCodeSequence);
		tagList.add(TagFromName.PerformedStationGeographicLocationCodeSequence);
		tagList.add(TagFromName.RequestedSubsequentWorkitemCodeSequence);
		tagList.add(TagFromName.NonDICOMOutputCodeSequence);
		tagList.add(TagFromName.OutputInformationSequence);
		tagList.add(TagFromName.ScheduledHumanPerformersSequence);
		tagList.add(TagFromName.ActualHumanPerformersSequence);
		tagList.add(TagFromName.HumanPerformerOrganization);
		tagList.add(TagFromName.HumanPerformerName);
		tagList.add(TagFromName.RawDataHandling);
		tagList.add(TagFromName.InputReadinessState);
		tagList.add(TagFromName.PerformedProcedureStepStartDateTime);
		tagList.add(TagFromName.PerformedProcedureStepEndDateTime);
		tagList.add(TagFromName.ProcedureStepCancellationDateTime);
		tagList.add(TagFromName.OutputDestinationSequence);
		tagList.add(TagFromName.DICOMStorageSequence);
		tagList.add(TagFromName.STOWRSStorageSequence);
		tagList.add(TagFromName.StorageURL);
		tagList.add(TagFromName.XDSStorageSequence);
		tagList.add(TagFromName.EntranceDoseInmGy);
		tagList.add(TagFromName.ParametricMapFrameTypeSequence);
		tagList.add(TagFromName.ReferencedImageRealWorldValueMappingSequence);
		tagList.add(TagFromName.RealWorldValueMappingSequence);
		tagList.add(TagFromName.PixelValueMappingCodeSequence);
		tagList.add(TagFromName.LUTLabel);
		tagList.add(TagFromName.RealWorldValueLastValueMapped);
		tagList.add(TagFromName.RealWorldValueLUTData);
		tagList.add(TagFromName.DoubleFloatRealWorldValueLastValueMapped);
		tagList.add(TagFromName.DoubleFloatRealWorldValueFirstValueMapped);
		tagList.add(TagFromName.RealWorldValueFirstValueMapped);
		tagList.add(TagFromName.QuantityDefinitionSequence);
		tagList.add(TagFromName.RealWorldValueIntercept);
		tagList.add(TagFromName.RealWorldValueSlope);
		tagList.add(TagFromName.FindingsFlagTrial);
		tagList.add(TagFromName.RelationshipType);
		tagList.add(TagFromName.FindingsSequenceTrial);
		tagList.add(TagFromName.FindingsGroupUIDTrial);
		tagList.add(TagFromName.ReferencedFindingsGroupUIDTrial);
		tagList.add(TagFromName.FindingsGroupRecordingDateTrial);
		tagList.add(TagFromName.FindingsGroupRecordingTimeTrial);
		tagList.add(TagFromName.FindingsSourceCategoryCodeSequenceTrial);
		tagList.add(TagFromName.VerifyingOrganization);
		tagList.add(TagFromName.DocumentingOrganizationIdentifierCodeSequenceTrial);
		tagList.add(TagFromName.VerificationDateTime);
		tagList.add(TagFromName.ObservationDateTime);
		tagList.add(TagFromName.ValueType);
		tagList.add(TagFromName.ConceptNameCodeSequence);
		tagList.add(TagFromName.MeasurementPrecisionDescriptionTrial);
		tagList.add(TagFromName.ContinuityOfContent);
		tagList.add(TagFromName.UrgencyOrPriorityAlertsTrial);
		tagList.add(TagFromName.SequencingIndicatorTrial);
		tagList.add(TagFromName.DocumentIdentifierCodeSequenceTrial);
		tagList.add(TagFromName.DocumentAuthorTrial);
		tagList.add(TagFromName.DocumentAuthorIdentifierCodeSequenceTrial);
		tagList.add(TagFromName.IdentifierCodeSequenceTrial);
		tagList.add(TagFromName.VerifyingObserverSequence);
		tagList.add(TagFromName.ObjectBinaryIdentifierTrial);
		tagList.add(TagFromName.VerifyingObserverName);
		tagList.add(TagFromName.DocumentingObserverIdentifierCodeSequenceTrial);
		tagList.add(TagFromName.AuthorObserverSequence);
		tagList.add(TagFromName.ParticipantSequence);
		tagList.add(TagFromName.CustodialOrganizationSequence);
		tagList.add(TagFromName.ParticipationType);
		tagList.add(TagFromName.ParticipationDateTime);
		tagList.add(TagFromName.ObserverType);
		tagList.add(TagFromName.ProcedureIdentifierCodeSequenceTrial);
		tagList.add(TagFromName.VerifyingObserverIdentificationCodeSequence);
		tagList.add(TagFromName.ObjectDirectoryBinaryIdentifierTrial);
		tagList.add(TagFromName.EquivalentCDADocumentSequence);
		tagList.add(TagFromName.ReferencedWaveformChannels);
		tagList.add(TagFromName.DateOfDocumentOrVerbalTransactionTrial);
		tagList.add(TagFromName.TimeOfDocumentCreationOrVerbalTransactionTrial);
		tagList.add(TagFromName.DateTime);
		tagList.add(TagFromName.Date);
		tagList.add(TagFromName.Time);
		tagList.add(TagFromName.PersonName);
		tagList.add(TagFromName.UID);
		tagList.add(TagFromName.ReportStatusIDTrial);
		tagList.add(TagFromName.TemporalRangeType);
		tagList.add(TagFromName.ReferencedSamplePositions);
		tagList.add(TagFromName.ReferencedFrameNumbers);
		tagList.add(TagFromName.ReferencedTimeOffsets);
		tagList.add(TagFromName.ReferencedDateTime);
		tagList.add(TagFromName.TextValue);
		tagList.add(TagFromName.FloatingPointValue);
		tagList.add(TagFromName.RationalNumeratorValue);
		tagList.add(TagFromName.RationalDenominatorValue);
		tagList.add(TagFromName.ObservationCategoryCodeSequenceTrial);
		tagList.add(TagFromName.ConceptCodeSequence);
		tagList.add(TagFromName.BibliographicCitationTrial);
		tagList.add(TagFromName.PurposeOfReferenceCodeSequence);
		tagList.add(TagFromName.ObservationUID);
		tagList.add(TagFromName.ReferencedObservationUIDTrial);
		tagList.add(TagFromName.ReferencedObservationClassTrial);
		tagList.add(TagFromName.ReferencedObjectObservationClassTrial);
		tagList.add(TagFromName.AnnotationGroupNumber);
		tagList.add(TagFromName.ObservationDateTrial);
		tagList.add(TagFromName.ObservationTimeTrial);
		tagList.add(TagFromName.MeasurementAutomationTrial);
		tagList.add(TagFromName.ModifierCodeSequence);
		tagList.add(TagFromName.IdentificationDescriptionTrial);
		tagList.add(TagFromName.CoordinatesSetGeometricTypeTrial);
		tagList.add(TagFromName.AlgorithmCodeSequenceTrial);
		tagList.add(TagFromName.AlgorithmDescriptionTrial);
		tagList.add(TagFromName.PixelCoordinatesSetTrial);
		tagList.add(TagFromName.MeasuredValueSequence);
		tagList.add(TagFromName.NumericValueQualifierCodeSequence);
		tagList.add(TagFromName.CurrentObserverTrial);
		tagList.add(TagFromName.NumericValue);
		tagList.add(TagFromName.ReferencedAccessionSequenceTrial);
		tagList.add(TagFromName.ReportStatusCommentTrial);
		tagList.add(TagFromName.ProcedureContextSequenceTrial);
		tagList.add(TagFromName.VerbalSourceTrial);
		tagList.add(TagFromName.AddressTrial);
		tagList.add(TagFromName.TelephoneNumberTrial);
		tagList.add(TagFromName.VerbalSourceIdentifierCodeSequenceTrial);
		tagList.add(TagFromName.PredecessorDocumentsSequence);
		tagList.add(TagFromName.ReferencedRequestSequence);
		tagList.add(TagFromName.PerformedProcedureCodeSequence);
		tagList.add(TagFromName.CurrentRequestedProcedureEvidenceSequence);
		tagList.add(TagFromName.ReportDetailSequenceTrial);
		tagList.add(TagFromName.PertinentOtherEvidenceSequence);
		tagList.add(TagFromName.HL7StructuredDocumentReferenceSequence);
		tagList.add(TagFromName.ObservationSubjectUIDTrial);
		tagList.add(TagFromName.ObservationSubjectClassTrial);
		tagList.add(TagFromName.ObservationSubjectTypeCodeSequenceTrial);
		tagList.add(TagFromName.CompletionFlag);
		tagList.add(TagFromName.CompletionFlagDescription);
		tagList.add(TagFromName.VerificationFlag);
		tagList.add(TagFromName.ArchiveRequested);
		tagList.add(TagFromName.PreliminaryFlag);
		tagList.add(TagFromName.ContentTemplateSequence);
		tagList.add(TagFromName.IdenticalDocumentsSequence);
		tagList.add(TagFromName.ObservationSubjectContextFlagTrial);
		tagList.add(TagFromName.ObserverContextFlagTrial);
		tagList.add(TagFromName.ProcedureContextFlagTrial);
		tagList.add(TagFromName.ContentSequence);
		tagList.add(TagFromName.RelationshipSequenceTrial);
		tagList.add(TagFromName.RelationshipTypeCodeSequenceTrial);
		tagList.add(TagFromName.LanguageCodeSequenceTrial);
		tagList.add(TagFromName.UniformResourceLocatorTrial);
		tagList.add(TagFromName.WaveformAnnotationSequence);
		tagList.add(TagFromName.TemplateIdentifier);
		tagList.add(TagFromName.TemplateVersion);
		tagList.add(TagFromName.TemplateLocalVersion);
		tagList.add(TagFromName.TemplateExtensionFlag);
		tagList.add(TagFromName.TemplateExtensionOrganizationUID);
		tagList.add(TagFromName.TemplateExtensionCreatorUID);
		tagList.add(TagFromName.ReferencedContentItemIdentifier);
		tagList.add(TagFromName.HL7InstanceIdentifier);
		tagList.add(TagFromName.HL7DocumentEffectiveTime);
		tagList.add(TagFromName.HL7DocumentTypeCodeSequence);
		tagList.add(TagFromName.DocumentClassCodeSequence);
		tagList.add(TagFromName.RetrieveURI);
		tagList.add(TagFromName.RetrieveLocationUID);
		tagList.add(TagFromName.TypeOfInstances);
		tagList.add(TagFromName.DICOMRetrievalSequence);
		tagList.add(TagFromName.DICOMMediaRetrievalSequence);
		tagList.add(TagFromName.WADORetrievalSequence);
		tagList.add(TagFromName.XDSRetrievalSequence);
		tagList.add(TagFromName.WADORSRetrievalSequence);
		tagList.add(TagFromName.RepositoryUniqueID);
		tagList.add(TagFromName.HomeCommunityID);
		tagList.add(TagFromName.DocumentTitle);
		tagList.add(TagFromName.EncapsulatedDocument);
		tagList.add(TagFromName.MIMETypeOfEncapsulatedDocument);
		tagList.add(TagFromName.SourceInstanceSequence);
		tagList.add(TagFromName.ListOfMIMETypes);
		tagList.add(TagFromName.ProductPackageIdentifier);
		tagList.add(TagFromName.SubstanceAdministrationApproval);
		tagList.add(TagFromName.ApprovalStatusFurtherDescription);
		tagList.add(TagFromName.ApprovalStatusDateTime);
		tagList.add(TagFromName.ProductTypeCodeSequence);
		tagList.add(TagFromName.ProductName);
		tagList.add(TagFromName.ProductDescription);
		tagList.add(TagFromName.ProductLotIdentifier);
		tagList.add(TagFromName.ProductExpirationDateTime);
		tagList.add(TagFromName.SubstanceAdministrationDateTime);
		tagList.add(TagFromName.SubstanceAdministrationNotes);
		tagList.add(TagFromName.SubstanceAdministrationDeviceID);
		tagList.add(TagFromName.ProductParameterSequence);
		tagList.add(TagFromName.SubstanceAdministrationParameterSequence);
		tagList.add(TagFromName.LensDescription);
		tagList.add(TagFromName.RightLensSequence);
		tagList.add(TagFromName.LeftLensSequence);
		tagList.add(TagFromName.UnspecifiedLateralityLensSequence);
		tagList.add(TagFromName.CylinderSequence);
		tagList.add(TagFromName.PrismSequence);
		tagList.add(TagFromName.HorizontalPrismPower);
		tagList.add(TagFromName.HorizontalPrismBase);
		tagList.add(TagFromName.VerticalPrismPower);
		tagList.add(TagFromName.VerticalPrismBase);
		tagList.add(TagFromName.LensSegmentType);
		tagList.add(TagFromName.OpticalTransmittance);
		tagList.add(TagFromName.ChannelWidth);
		tagList.add(TagFromName.PupilSize);
		tagList.add(TagFromName.CornealSize);
		tagList.add(TagFromName.AutorefractionRightEyeSequence);
		tagList.add(TagFromName.AutorefractionLeftEyeSequence);
		tagList.add(TagFromName.DistancePupillaryDistance);
		tagList.add(TagFromName.NearPupillaryDistance);
		tagList.add(TagFromName.IntermediatePupillaryDistance);
		tagList.add(TagFromName.OtherPupillaryDistance);
		tagList.add(TagFromName.KeratometryRightEyeSequence);
		tagList.add(TagFromName.KeratometryLeftEyeSequence);
		tagList.add(TagFromName.SteepKeratometricAxisSequence);
		tagList.add(TagFromName.RadiusOfCurvature);
		tagList.add(TagFromName.KeratometricPower);
		tagList.add(TagFromName.KeratometricAxis);
		tagList.add(TagFromName.FlatKeratometricAxisSequence);
		tagList.add(TagFromName.BackgroundColor);
		tagList.add(TagFromName.Optotype);
		tagList.add(TagFromName.OptotypePresentation);
		tagList.add(TagFromName.SubjectiveRefractionRightEyeSequence);
		tagList.add(TagFromName.SubjectiveRefractionLeftEyeSequence);
		tagList.add(TagFromName.AddNearSequence);
		tagList.add(TagFromName.AddIntermediateSequence);
		tagList.add(TagFromName.AddOtherSequence);
		tagList.add(TagFromName.AddPower);
		tagList.add(TagFromName.ViewingDistance);
		tagList.add(TagFromName.VisualAcuityTypeCodeSequence);
		tagList.add(TagFromName.VisualAcuityRightEyeSequence);
		tagList.add(TagFromName.VisualAcuityLeftEyeSequence);
		tagList.add(TagFromName.VisualAcuityBothEyesOpenSequence);
		tagList.add(TagFromName.ViewingDistanceType);
		tagList.add(TagFromName.VisualAcuityModifiers);
		tagList.add(TagFromName.DecimalVisualAcuity);
		tagList.add(TagFromName.OptotypeDetailedDefinition);
		tagList.add(TagFromName.ReferencedRefractiveMeasurementsSequence);
		tagList.add(TagFromName.SpherePower);
		tagList.add(TagFromName.CylinderPower);
		tagList.add(TagFromName.CornealTopographySurface);
		tagList.add(TagFromName.CornealVertexLocation);
		tagList.add(TagFromName.PupilCentroidXCoordinate);
		tagList.add(TagFromName.PupilCentroidYCoordinate);
		tagList.add(TagFromName.EquivalentPupilRadius);
		tagList.add(TagFromName.CornealTopographyMapTypeCodeSequence);
		tagList.add(TagFromName.VerticesOfTheOutlineOfPupil);
		tagList.add(TagFromName.CornealTopographyMappingNormalsSequence);
		tagList.add(TagFromName.MaximumCornealCurvatureSequence);
		tagList.add(TagFromName.MaximumCornealCurvature);
		tagList.add(TagFromName.MaximumCornealCurvatureLocation);
		tagList.add(TagFromName.MinimumKeratometricSequence);
		tagList.add(TagFromName.SimulatedKeratometricCylinderSequence);
		tagList.add(TagFromName.AverageCornealPower);
		tagList.add(TagFromName.CornealISValue);
		tagList.add(TagFromName.AnalyzedArea);
		tagList.add(TagFromName.SurfaceRegularityIndex);
		tagList.add(TagFromName.SurfaceAsymmetryIndex);
		tagList.add(TagFromName.CornealEccentricityIndex);
		tagList.add(TagFromName.KeratoconusPredictionIndex);
		tagList.add(TagFromName.DecimalPotentialVisualAcuity);
		tagList.add(TagFromName.CornealTopographyMapQualityEvaluation);
		tagList.add(TagFromName.SourceImageCornealProcessedDataSequence);
		tagList.add(TagFromName.CornealPointLocation);
		tagList.add(TagFromName.CornealPointEstimated);
		tagList.add(TagFromName.AxialPower);
		tagList.add(TagFromName.TangentialPower);
		tagList.add(TagFromName.RefractivePower);
		tagList.add(TagFromName.RelativeElevation);
		tagList.add(TagFromName.CornealWavefront);
		tagList.add(TagFromName.ImagedVolumeWidth);
		tagList.add(TagFromName.ImagedVolumeHeight);
		tagList.add(TagFromName.ImagedVolumeDepth);
		tagList.add(TagFromName.TotalPixelMatrixColumns);
		tagList.add(TagFromName.TotalPixelMatrixRows);
		tagList.add(TagFromName.TotalPixelMatrixOriginSequence);
		tagList.add(TagFromName.SpecimenLabelInImage);
		tagList.add(TagFromName.FocusMethod);
		tagList.add(TagFromName.ExtendedDepthOfField);
		tagList.add(TagFromName.NumberOfFocalPlanes);
		tagList.add(TagFromName.DistanceBetweenFocalPlanes);
		tagList.add(TagFromName.RecommendedAbsentPixelCIELabValue);
		tagList.add(TagFromName.IlluminatorTypeCodeSequence);
		tagList.add(TagFromName.ImageOrientationSlide);
		tagList.add(TagFromName.OpticalPathSequence);
		tagList.add(TagFromName.OpticalPathIdentifier);
		tagList.add(TagFromName.OpticalPathDescription);
		tagList.add(TagFromName.IlluminationColorCodeSequence);
		tagList.add(TagFromName.SpecimenReferenceSequence);
		tagList.add(TagFromName.CondenserLensPower);
		tagList.add(TagFromName.ObjectiveLensPower);
		tagList.add(TagFromName.ObjectiveLensNumericalAperture);
		tagList.add(TagFromName.PaletteColorLookupTableSequence);
		tagList.add(TagFromName.ReferencedImageNavigationSequence);
		tagList.add(TagFromName.TopLeftHandCornerOfLocalizerArea);
		tagList.add(TagFromName.BottomRightHandCornerOfLocalizerArea);
		tagList.add(TagFromName.OpticalPathIdentificationSequence);
		tagList.add(TagFromName.PlanePositionSlideSequence);
		tagList.add(TagFromName.ColumnPositionInTotalImagePixelMatrix);
		tagList.add(TagFromName.RowPositionInTotalImagePixelMatrix);
		tagList.add(TagFromName.PixelOriginInterpretation);
		tagList.add(TagFromName.CalibrationImage);
		tagList.add(TagFromName.DeviceSequence);
		tagList.add(TagFromName.ContainerComponentTypeCodeSequence);
		tagList.add(TagFromName.ContainerComponentThickness);
		tagList.add(TagFromName.DeviceLength);
		tagList.add(TagFromName.ContainerComponentWidth);
		tagList.add(TagFromName.DeviceDiameter);
		tagList.add(TagFromName.DeviceDiameterUnits);
		tagList.add(TagFromName.DeviceVolume);
		tagList.add(TagFromName.InterMarkerDistance);
		tagList.add(TagFromName.ContainerComponentMaterial);
		tagList.add(TagFromName.ContainerComponentID);
		tagList.add(TagFromName.ContainerComponentLength);
		tagList.add(TagFromName.ContainerComponentDiameter);
		tagList.add(TagFromName.ContainerComponentDescription);
		tagList.add(TagFromName.DeviceDescription);
		tagList.add(TagFromName.ContrastBolusIngredientPercentByVolume);
		tagList.add(TagFromName.OCTFocalDistance);
		tagList.add(TagFromName.BeamSpotSize);
		tagList.add(TagFromName.EffectiveRefractiveIndex);
		tagList.add(TagFromName.OCTAcquisitionDomain);
		tagList.add(TagFromName.OCTOpticalCenterWavelength);
		tagList.add(TagFromName.AxialResolution);
		tagList.add(TagFromName.RangingDepth);
		tagList.add(TagFromName.ALineRate);
		tagList.add(TagFromName.ALinesPerFrame);
		tagList.add(TagFromName.CatheterRotationalRate);
		tagList.add(TagFromName.ALinePixelSpacing);
		tagList.add(TagFromName.ModeOfPercutaneousAccessSequence);
		tagList.add(TagFromName.IntravascularOCTFrameTypeSequence);
		tagList.add(TagFromName.OCTZOffsetApplied);
		tagList.add(TagFromName.IntravascularFrameContentSequence);
		tagList.add(TagFromName.IntravascularLongitudinalDistance);
		tagList.add(TagFromName.IntravascularOCTFrameContentSequence);
		tagList.add(TagFromName.OCTZOffsetCorrection);
		tagList.add(TagFromName.CatheterDirectionOfRotation);
		tagList.add(TagFromName.SeamLineLocation);
		tagList.add(TagFromName.FirstALineLocation);
		tagList.add(TagFromName.SeamLineIndex);
		tagList.add(TagFromName.NumberOfPaddedALines);
		tagList.add(TagFromName.InterpolationType);
		tagList.add(TagFromName.RefractiveIndexApplied);
		tagList.add(TagFromName.EnergyWindowVector);
		tagList.add(TagFromName.NumberOfEnergyWindows);
		tagList.add(TagFromName.EnergyWindowInformationSequence);
		tagList.add(TagFromName.EnergyWindowRangeSequence);
		tagList.add(TagFromName.EnergyWindowLowerLimit);
		tagList.add(TagFromName.EnergyWindowUpperLimit);
		tagList.add(TagFromName.RadiopharmaceuticalInformationSequence);
		tagList.add(TagFromName.ResidualSyringeCounts);
		tagList.add(TagFromName.EnergyWindowName);
		tagList.add(TagFromName.DetectorVector);
		tagList.add(TagFromName.NumberOfDetectors);
		tagList.add(TagFromName.DetectorInformationSequence);
		tagList.add(TagFromName.PhaseVector);
		tagList.add(TagFromName.NumberOfPhases);
		tagList.add(TagFromName.PhaseInformationSequence);
		tagList.add(TagFromName.NumberOfFramesInPhase);
		tagList.add(TagFromName.PhaseDelay);
		tagList.add(TagFromName.PauseBetweenFrames);
		tagList.add(TagFromName.PhaseDescription);
		tagList.add(TagFromName.RotationVector);
		tagList.add(TagFromName.NumberOfRotations);
		tagList.add(TagFromName.RotationInformationSequence);
		tagList.add(TagFromName.NumberOfFramesInRotation);
		tagList.add(TagFromName.RRIntervalVector);
		tagList.add(TagFromName.NumberOfRRIntervals);
		tagList.add(TagFromName.GatedInformationSequence);
		tagList.add(TagFromName.DataInformationSequence);
		tagList.add(TagFromName.TimeSlotVector);
		tagList.add(TagFromName.NumberOfTimeSlots);
		tagList.add(TagFromName.TimeSlotInformationSequence);
		tagList.add(TagFromName.TimeSlotTime);
		tagList.add(TagFromName.SliceVector);
		tagList.add(TagFromName.NumberOfSlices);
		tagList.add(TagFromName.AngularViewVector);
		tagList.add(TagFromName.TimeSliceVector);
		tagList.add(TagFromName.NumberOfTimeSlices);
		tagList.add(TagFromName.StartAngle);
		tagList.add(TagFromName.TypeOfDetectorMotion);
		tagList.add(TagFromName.TriggerVector);
		tagList.add(TagFromName.NumberOfTriggersInPhase);
		tagList.add(TagFromName.ViewCodeSequence);
		tagList.add(TagFromName.ViewModifierCodeSequence);
		tagList.add(TagFromName.RadionuclideCodeSequence);
		tagList.add(TagFromName.AdministrationRouteCodeSequence);
		tagList.add(TagFromName.RadiopharmaceuticalCodeSequence);
		tagList.add(TagFromName.CalibrationDataSequence);
		tagList.add(TagFromName.EnergyWindowNumber);
		tagList.add(TagFromName.ImageID);
		tagList.add(TagFromName.PatientOrientationCodeSequence);
		tagList.add(TagFromName.PatientOrientationModifierCodeSequence);
		tagList.add(TagFromName.PatientGantryRelationshipCodeSequence);
		tagList.add(TagFromName.SliceProgressionDirection);
		tagList.add(TagFromName.ScanProgressionDirection);
		tagList.add(TagFromName.SeriesType);
		tagList.add(TagFromName.Units);
		tagList.add(TagFromName.CountsSource);
		tagList.add(TagFromName.ReprojectionMethod);
		tagList.add(TagFromName.SUVType);
		tagList.add(TagFromName.RandomsCorrectionMethod);
		tagList.add(TagFromName.AttenuationCorrectionMethod);
		tagList.add(TagFromName.DecayCorrection);
		tagList.add(TagFromName.ReconstructionMethod);
		tagList.add(TagFromName.DetectorLinesOfResponseUsed);
		tagList.add(TagFromName.ScatterCorrectionMethod);
		tagList.add(TagFromName.AxialAcceptance);
		tagList.add(TagFromName.AxialMash);
		tagList.add(TagFromName.TransverseMash);
		tagList.add(TagFromName.DetectorElementSize);
		tagList.add(TagFromName.CoincidenceWindowWidth);
		tagList.add(TagFromName.SecondaryCountsType);
		tagList.add(TagFromName.FrameReferenceTime);
		tagList.add(TagFromName.PrimaryPromptsCountsAccumulated);
		tagList.add(TagFromName.SecondaryCountsAccumulated);
		tagList.add(TagFromName.SliceSensitivityFactor);
		tagList.add(TagFromName.DecayFactor);
		tagList.add(TagFromName.DoseCalibrationFactor);
		tagList.add(TagFromName.ScatterFractionFactor);
		tagList.add(TagFromName.DeadTimeFactor);
		tagList.add(TagFromName.ImageIndex);
		tagList.add(TagFromName.CountsIncluded);
		tagList.add(TagFromName.DeadTimeCorrectionFlag);
		tagList.add(TagFromName.HistogramSequence);
		tagList.add(TagFromName.HistogramNumberOfBins);
		tagList.add(TagFromName.HistogramFirstBinValue);
		tagList.add(TagFromName.HistogramLastBinValue);
		tagList.add(TagFromName.HistogramBinWidth);
		tagList.add(TagFromName.HistogramExplanation);
		tagList.add(TagFromName.HistogramData);
		tagList.add(TagFromName.SegmentationType);
		tagList.add(TagFromName.SegmentSequence);
		tagList.add(TagFromName.SegmentedPropertyCategoryCodeSequence);
		tagList.add(TagFromName.SegmentNumber);
		tagList.add(TagFromName.SegmentLabel);
		tagList.add(TagFromName.SegmentDescription);
		tagList.add(TagFromName.SegmentAlgorithmType);
		tagList.add(TagFromName.SegmentAlgorithmName);
		tagList.add(TagFromName.SegmentIdentificationSequence);
		tagList.add(TagFromName.ReferencedSegmentNumber);
		tagList.add(TagFromName.RecommendedDisplayGrayscaleValue);
		tagList.add(TagFromName.RecommendedDisplayCIELabValue);
		tagList.add(TagFromName.MaximumFractionalValue);
		tagList.add(TagFromName.SegmentedPropertyTypeCodeSequence);
		tagList.add(TagFromName.SegmentationFractionalType);
		tagList.add(TagFromName.SegmentedPropertyTypeModifierCodeSequence);
		tagList.add(TagFromName.UsedSegmentsSequence);
		tagList.add(TagFromName.DeformableRegistrationSequence);
		tagList.add(TagFromName.SourceFrameOfReferenceUID);
		tagList.add(TagFromName.DeformableRegistrationGridSequence);
		tagList.add(TagFromName.GridDimensions);
		tagList.add(TagFromName.GridResolution);
		tagList.add(TagFromName.VectorGridData);
		tagList.add(TagFromName.PreDeformationMatrixRegistrationSequence);
		tagList.add(TagFromName.PostDeformationMatrixRegistrationSequence);
		tagList.add(TagFromName.NumberOfSurfaces);
		tagList.add(TagFromName.SurfaceSequence);
		tagList.add(TagFromName.SurfaceNumber);
		tagList.add(TagFromName.SurfaceComments);
		tagList.add(TagFromName.SurfaceProcessing);
		tagList.add(TagFromName.SurfaceProcessingRatio);
		tagList.add(TagFromName.SurfaceProcessingDescription);
		tagList.add(TagFromName.RecommendedPresentationOpacity);
		tagList.add(TagFromName.RecommendedPresentationType);
		tagList.add(TagFromName.FiniteVolume);
		tagList.add(TagFromName.Manifold);
		tagList.add(TagFromName.SurfacePointsSequence);
		tagList.add(TagFromName.SurfacePointsNormalsSequence);
		tagList.add(TagFromName.SurfaceMeshPrimitivesSequence);
		tagList.add(TagFromName.NumberOfSurfacePoints);
		tagList.add(TagFromName.PointCoordinatesData);
		tagList.add(TagFromName.PointPositionAccuracy);
		tagList.add(TagFromName.MeanPointDistance);
		tagList.add(TagFromName.MaximumPointDistance);
		tagList.add(TagFromName.PointsBoundingBoxCoordinates);
		tagList.add(TagFromName.AxisOfRotation);
		tagList.add(TagFromName.CenterOfRotation);
		tagList.add(TagFromName.NumberOfVectors);
		tagList.add(TagFromName.VectorDimensionality);
		tagList.add(TagFromName.VectorAccuracy);
		tagList.add(TagFromName.VectorCoordinateData);
		tagList.add(TagFromName.TrianglePointIndexList);
		tagList.add(TagFromName.EdgePointIndexList);
		tagList.add(TagFromName.VertexPointIndexList);
		tagList.add(TagFromName.TriangleStripSequence);
		tagList.add(TagFromName.TriangleFanSequence);
		tagList.add(TagFromName.LineSequence);
		tagList.add(TagFromName.PrimitivePointIndexList);
		tagList.add(TagFromName.SurfaceCount);
		tagList.add(TagFromName.ReferencedSurfaceSequence);
		tagList.add(TagFromName.ReferencedSurfaceNumber);
		tagList.add(TagFromName.SegmentSurfaceGenerationAlgorithmIdentificationSequence);
		tagList.add(TagFromName.SegmentSurfaceSourceInstanceSequence);
		tagList.add(TagFromName.AlgorithmFamilyCodeSequence);
		tagList.add(TagFromName.AlgorithmNameCodeSequence);
		tagList.add(TagFromName.AlgorithmVersion);
		tagList.add(TagFromName.AlgorithmParameters);
		tagList.add(TagFromName.FacetSequence);
		tagList.add(TagFromName.SurfaceProcessingAlgorithmIdentificationSequence);
		tagList.add(TagFromName.AlgorithmName);
		tagList.add(TagFromName.RecommendedPointRadius);
		tagList.add(TagFromName.RecommendedLineThickness);
		tagList.add(TagFromName.TrackSetSequence);
		tagList.add(TagFromName.TrackSequence);
		tagList.add(TagFromName.RecommendedDisplayCIELabValueList);
		tagList.add(TagFromName.TrackingAlgorithmIdentificationSequence);
		tagList.add(TagFromName.TrackSetNumber);
		tagList.add(TagFromName.TrackSetLabel);
		tagList.add(TagFromName.TrackSetDescription);
		tagList.add(TagFromName.TrackSetAnatomicalTypeCodeSequence);
		tagList.add(TagFromName.MeasurementsSequence);
		tagList.add(TagFromName.TrackSetStatisticsSequence);
		tagList.add(TagFromName.FloatingPointValues);
		tagList.add(TagFromName.TrackPointIndexList);
		tagList.add(TagFromName.TrackStatisticsSequence);
		tagList.add(TagFromName.MeasurementValuesSequence);
		tagList.add(TagFromName.DiffusionAcquisitionCodeSequence);
		tagList.add(TagFromName.ImplantSize);
		tagList.add(TagFromName.ImplantTemplateVersion);
		tagList.add(TagFromName.ReplacedImplantTemplateSequence);
		tagList.add(TagFromName.ImplantType);
		tagList.add(TagFromName.DerivationImplantTemplateSequence);
		tagList.add(TagFromName.OriginalImplantTemplateSequence);
		tagList.add(TagFromName.EffectiveDateTime);
		tagList.add(TagFromName.ImplantTargetAnatomySequence);
		tagList.add(TagFromName.InformationFromManufacturerSequence);
		tagList.add(TagFromName.NotificationFromManufacturerSequence);
		tagList.add(TagFromName.InformationIssueDateTime);
		tagList.add(TagFromName.InformationSummary);
		tagList.add(TagFromName.ImplantRegulatoryDisapprovalCodeSequence);
		tagList.add(TagFromName.OverallTemplateSpatialTolerance);
		tagList.add(TagFromName.HPGLDocumentSequence);
		tagList.add(TagFromName.HPGLDocumentID);
		tagList.add(TagFromName.HPGLDocumentLabel);
		tagList.add(TagFromName.ViewOrientationCodeSequence);
		tagList.add(TagFromName.ViewOrientationModifier);
		tagList.add(TagFromName.HPGLDocumentScaling);
		tagList.add(TagFromName.HPGLDocument);
		tagList.add(TagFromName.HPGLContourPenNumber);
		tagList.add(TagFromName.HPGLPenSequence);
		tagList.add(TagFromName.HPGLPenNumber);
		tagList.add(TagFromName.HPGLPenLabel);
		tagList.add(TagFromName.HPGLPenDescription);
		tagList.add(TagFromName.RecommendedRotationPoint);
		tagList.add(TagFromName.BoundingRectangle);
		tagList.add(TagFromName.ImplantTemplate3DModelSurfaceNumber);
		tagList.add(TagFromName.SurfaceModelDescriptionSequence);
		tagList.add(TagFromName.SurfaceModelLabel);
		tagList.add(TagFromName.SurfaceModelScalingFactor);
		tagList.add(TagFromName.MaterialsCodeSequence);
		tagList.add(TagFromName.CoatingMaterialsCodeSequence);
		tagList.add(TagFromName.ImplantTypeCodeSequence);
		tagList.add(TagFromName.FixationMethodCodeSequence);
		tagList.add(TagFromName.MatingFeatureSetsSequence);
		tagList.add(TagFromName.MatingFeatureSetID);
		tagList.add(TagFromName.MatingFeatureSetLabel);
		tagList.add(TagFromName.MatingFeatureSequence);
		tagList.add(TagFromName.MatingFeatureID);
		tagList.add(TagFromName.MatingFeatureDegreeOfFreedomSequence);
		tagList.add(TagFromName.DegreeOfFreedomID);
		tagList.add(TagFromName.DegreeOfFreedomType);
		tagList.add(TagFromName.TwoDMatingFeatureCoordinatesSequence);
		tagList.add(TagFromName.ReferencedHPGLDocumentID);
		tagList.add(TagFromName.TwoDMatingPoint);
		tagList.add(TagFromName.TwoDMatingAxes);
		tagList.add(TagFromName.TwoDDegreeOfFreedomSequence);
		tagList.add(TagFromName.ThreeDDegreeOfFreedomAxis);
		tagList.add(TagFromName.RangeOfFreedom);
		tagList.add(TagFromName.ThreeDMatingPoint);
		tagList.add(TagFromName.ThreeDMatingAxes);
		tagList.add(TagFromName.TwoDDegreeOfFreedomAxis);
		tagList.add(TagFromName.PlanningLandmarkPointSequence);
		tagList.add(TagFromName.PlanningLandmarkLineSequence);
		tagList.add(TagFromName.PlanningLandmarkPlaneSequence);
		tagList.add(TagFromName.PlanningLandmarkID);
		tagList.add(TagFromName.PlanningLandmarkDescription);
		tagList.add(TagFromName.PlanningLandmarkIdentificationCodeSequence);
		tagList.add(TagFromName.TwoDPointCoordinatesSequence);
		tagList.add(TagFromName.TwoDPointCoordinates);
		tagList.add(TagFromName.ThreeDPointCoordinates);
		tagList.add(TagFromName.TwoDLineCoordinatesSequence);
		tagList.add(TagFromName.TwoDLineCoordinates);
		tagList.add(TagFromName.ThreeDLineCoordinates);
		tagList.add(TagFromName.TwoDPlaneCoordinatesSequence);
		tagList.add(TagFromName.TwoDPlaneIntersection);
		tagList.add(TagFromName.ThreeDPlaneOrigin);
		tagList.add(TagFromName.ThreeDPlaneNormal);
		tagList.add(TagFromName.GraphicAnnotationSequence);
		tagList.add(TagFromName.GraphicLayer);
		tagList.add(TagFromName.BoundingBoxAnnotationUnits);
		tagList.add(TagFromName.AnchorPointAnnotationUnits);
		tagList.add(TagFromName.GraphicAnnotationUnits);
		tagList.add(TagFromName.UnformattedTextValue);
		tagList.add(TagFromName.TextObjectSequence);
		tagList.add(TagFromName.GraphicObjectSequence);
		tagList.add(TagFromName.BoundingBoxTopLeftHandCorner);
		tagList.add(TagFromName.BoundingBoxBottomRightHandCorner);
		tagList.add(TagFromName.BoundingBoxTextHorizontalJustification);
		tagList.add(TagFromName.AnchorPoint);
		tagList.add(TagFromName.AnchorPointVisibility);
		tagList.add(TagFromName.GraphicDimensions);
		tagList.add(TagFromName.NumberOfGraphicPoints);
		tagList.add(TagFromName.GraphicData);
		tagList.add(TagFromName.GraphicType);
		tagList.add(TagFromName.GraphicFilled);
		tagList.add(TagFromName.ImageRotationRetired);
		tagList.add(TagFromName.ImageHorizontalFlip);
		tagList.add(TagFromName.ImageRotation);
		tagList.add(TagFromName.DisplayedAreaTopLeftHandCornerTrial);
		tagList.add(TagFromName.DisplayedAreaBottomRightHandCornerTrial);
		tagList.add(TagFromName.DisplayedAreaTopLeftHandCorner);
		tagList.add(TagFromName.DisplayedAreaBottomRightHandCorner);
		tagList.add(TagFromName.DisplayedAreaSelectionSequence);
		tagList.add(TagFromName.GraphicLayerSequence);
		tagList.add(TagFromName.GraphicLayerOrder);
		tagList.add(TagFromName.GraphicLayerRecommendedDisplayGrayscaleValue);
		tagList.add(TagFromName.GraphicLayerRecommendedDisplayRGBValue);
		tagList.add(TagFromName.GraphicLayerDescription);
		tagList.add(TagFromName.ContentLabel);
		tagList.add(TagFromName.ContentDescription);
		tagList.add(TagFromName.PresentationCreationDate);
		tagList.add(TagFromName.PresentationCreationTime);
		tagList.add(TagFromName.ContentCreatorName);
		tagList.add(TagFromName.ContentCreatorIdentificationCodeSequence);
		tagList.add(TagFromName.AlternateContentDescriptionSequence);
		tagList.add(TagFromName.PresentationSizeMode);
		tagList.add(TagFromName.PresentationPixelSpacing);
		tagList.add(TagFromName.PresentationPixelAspectRatio);
		tagList.add(TagFromName.PresentationPixelMagnificationRatio);
		tagList.add(TagFromName.GraphicGroupLabel);
		tagList.add(TagFromName.GraphicGroupDescription);
		tagList.add(TagFromName.CompoundGraphicSequence);
		tagList.add(TagFromName.CompoundGraphicInstanceID);
		tagList.add(TagFromName.FontName);
		tagList.add(TagFromName.FontNameType);
		tagList.add(TagFromName.CSSFontName);
		tagList.add(TagFromName.RotationAngle);
		tagList.add(TagFromName.TextStyleSequence);
		tagList.add(TagFromName.LineStyleSequence);
		tagList.add(TagFromName.FillStyleSequence);
		tagList.add(TagFromName.GraphicGroupSequence);
		tagList.add(TagFromName.TextColorCIELabValue);
		tagList.add(TagFromName.HorizontalAlignment);
		tagList.add(TagFromName.VerticalAlignment);
		tagList.add(TagFromName.ShadowStyle);
		tagList.add(TagFromName.ShadowOffsetX);
		tagList.add(TagFromName.ShadowOffsetY);
		tagList.add(TagFromName.ShadowColorCIELabValue);
		tagList.add(TagFromName.Underlined);
		tagList.add(TagFromName.Bold);
		tagList.add(TagFromName.Italic);
		tagList.add(TagFromName.PatternOnColorCIELabValue);
		tagList.add(TagFromName.PatternOffColorCIELabValue);
		tagList.add(TagFromName.LineThickness);
		tagList.add(TagFromName.LineDashingStyle);
		tagList.add(TagFromName.LinePattern);
		tagList.add(TagFromName.FillPattern);
		tagList.add(TagFromName.FillMode);
		tagList.add(TagFromName.ShadowOpacity);
		tagList.add(TagFromName.GapLength);
		tagList.add(TagFromName.DiameterOfVisibility);
		tagList.add(TagFromName.RotationPoint);
		tagList.add(TagFromName.TickAlignment);
		tagList.add(TagFromName.ShowTickLabel);
		tagList.add(TagFromName.TickLabelAlignment);
		tagList.add(TagFromName.CompoundGraphicUnits);
		tagList.add(TagFromName.PatternOnOpacity);
		tagList.add(TagFromName.PatternOffOpacity);
		tagList.add(TagFromName.MajorTicksSequence);
		tagList.add(TagFromName.TickPosition);
		tagList.add(TagFromName.TickLabel);
		tagList.add(TagFromName.CompoundGraphicType);
		tagList.add(TagFromName.GraphicGroupID);
		tagList.add(TagFromName.ShapeType);
		tagList.add(TagFromName.RegistrationSequence);
		tagList.add(TagFromName.MatrixRegistrationSequence);
		tagList.add(TagFromName.MatrixSequence);
		tagList.add(TagFromName.FrameOfReferenceToDisplayedCoordinateSystemTransformationMatrix);
		tagList.add(TagFromName.FrameOfReferenceTransformationMatrixType);
		tagList.add(TagFromName.RegistrationTypeCodeSequence);
		tagList.add(TagFromName.FiducialDescription);
		tagList.add(TagFromName.FiducialIdentifier);
		tagList.add(TagFromName.FiducialIdentifierCodeSequence);
		tagList.add(TagFromName.ContourUncertaintyRadius);
		tagList.add(TagFromName.UsedFiducialsSequence);
		tagList.add(TagFromName.GraphicCoordinatesDataSequence);
		tagList.add(TagFromName.FiducialUID);
		tagList.add(TagFromName.FiducialSetSequence);
		tagList.add(TagFromName.FiducialSequence);
		tagList.add(TagFromName.GraphicLayerRecommendedDisplayCIELabValue);
		tagList.add(TagFromName.BlendingSequence);
		tagList.add(TagFromName.RelativeOpacity);
		tagList.add(TagFromName.ReferencedSpatialRegistrationSequence);
		tagList.add(TagFromName.BlendingPosition);
		tagList.add(TagFromName.PresentationDisplayCollectionUID);
		tagList.add(TagFromName.PresentationSequenceCollectionUID);
		tagList.add(TagFromName.PresentationSequencePositionIndex);
		tagList.add(TagFromName.RenderedImageReferenceSequence);
		tagList.add(TagFromName.VolumetricPresentationStateInputSequence);
		tagList.add(TagFromName.PresentationInputType);
		tagList.add(TagFromName.InputSequencePositionIndex);
		tagList.add(TagFromName.Crop);
		tagList.add(TagFromName.CroppingSpecificationIndex);
		tagList.add(TagFromName.CompositingMethod);
		tagList.add(TagFromName.VolumetricPresentationInputNumber);
		tagList.add(TagFromName.ImageVolumeGeometry);
		tagList.add(TagFromName.VolumeCroppingSequence);
		tagList.add(TagFromName.VolumeCroppingMethod);
		tagList.add(TagFromName.BoundingBoxCrop);
		tagList.add(TagFromName.ObliqueCroppingPlaneSequence);
		tagList.add(TagFromName.ObliqueCroppingPlane);
		tagList.add(TagFromName.ObliqueCroppingPlaneNormal);
		tagList.add(TagFromName.CroppingSpecificationNumber);
		tagList.add(TagFromName.MultiPlanarReconstructionStyle);
		tagList.add(TagFromName.MPRThicknessType);
		tagList.add(TagFromName.MPRSlabThickness);
		tagList.add(TagFromName.MPRTopLeftHandCorner);
		tagList.add(TagFromName.MPRViewWidthDirection);
		tagList.add(TagFromName.MPRViewWidth);
		tagList.add(TagFromName.NumberOfVolumetricCurvePoints);
		tagList.add(TagFromName.VolumetricCurvePoints);
		tagList.add(TagFromName.MPRViewHeightDirection);
		tagList.add(TagFromName.MPRViewHeight);
		tagList.add(TagFromName.PresentationStateClassificationComponentSequence);
		tagList.add(TagFromName.ComponentType);
		tagList.add(TagFromName.ComponentInputSequence);
		tagList.add(TagFromName.VolumetricPresentationInputIndex);
		tagList.add(TagFromName.PresentationStateCompositorComponentSequence);
		tagList.add(TagFromName.WeightingTransferFunctionSequence);
		tagList.add(TagFromName.WeightingLookupTableDescriptor);
		tagList.add(TagFromName.WeightingLookupTableData);
		tagList.add(TagFromName.VolumetricAnnotationSequence);
		tagList.add(TagFromName.ReferencedStructuredContextSequence);
		tagList.add(TagFromName.ReferencedContentItem);
		tagList.add(TagFromName.VolumetricPresentationInputAnnotationSequence);
		tagList.add(TagFromName.AnnotationClipping);
		tagList.add(TagFromName.PresentationAnimationStyle);
		tagList.add(TagFromName.RecommendedAnimationRate);
		tagList.add(TagFromName.AnimationCurveSequence);
		tagList.add(TagFromName.AnimationStepSize);
		tagList.add(TagFromName.HangingProtocolName);
		tagList.add(TagFromName.HangingProtocolDescription);
		tagList.add(TagFromName.HangingProtocolLevel);
		tagList.add(TagFromName.HangingProtocolCreator);
		tagList.add(TagFromName.HangingProtocolCreationDateTime);
		tagList.add(TagFromName.HangingProtocolDefinitionSequence);
		tagList.add(TagFromName.HangingProtocolUserIdentificationCodeSequence);
		tagList.add(TagFromName.HangingProtocolUserGroupName);
		tagList.add(TagFromName.SourceHangingProtocolSequence);
		tagList.add(TagFromName.NumberOfPriorsReferenced);
		tagList.add(TagFromName.ImageSetsSequence);
		tagList.add(TagFromName.ImageSetSelectorSequence);
		tagList.add(TagFromName.ImageSetSelectorUsageFlag);
		tagList.add(TagFromName.SelectorAttribute);
		tagList.add(TagFromName.SelectorValueNumber);
		tagList.add(TagFromName.TimeBasedImageSetsSequence);
		tagList.add(TagFromName.ImageSetNumber);
		tagList.add(TagFromName.ImageSetSelectorCategory);
		tagList.add(TagFromName.RelativeTime);
		tagList.add(TagFromName.RelativeTimeUnits);
		tagList.add(TagFromName.AbstractPriorValue);
		tagList.add(TagFromName.AbstractPriorCodeSequence);
		tagList.add(TagFromName.ImageSetLabel);
		tagList.add(TagFromName.SelectorAttributeVR);
		tagList.add(TagFromName.SelectorSequencePointer);
		tagList.add(TagFromName.SelectorSequencePointerPrivateCreator);
		tagList.add(TagFromName.SelectorAttributePrivateCreator);
		tagList.add(TagFromName.SelectorATValue);
		tagList.add(TagFromName.SelectorCSValue);
		tagList.add(TagFromName.SelectorISValue);
		tagList.add(TagFromName.SelectorLOValue);
		tagList.add(TagFromName.SelectorLTValue);
		tagList.add(TagFromName.SelectorPNValue);
		tagList.add(TagFromName.SelectorSHValue);
		tagList.add(TagFromName.SelectorSTValue);
		tagList.add(TagFromName.SelectorUTValue);
		tagList.add(TagFromName.SelectorDSValue);
		tagList.add(TagFromName.SelectorFDValue);
		tagList.add(TagFromName.SelectorFLValue);
		tagList.add(TagFromName.SelectorULValue);
		tagList.add(TagFromName.SelectorUSValue);
		tagList.add(TagFromName.SelectorSLValue);
		tagList.add(TagFromName.SelectorSSValue);
		tagList.add(TagFromName.SelectorUIValue);
		tagList.add(TagFromName.SelectorCodeSequenceValue);
		tagList.add(TagFromName.NumberOfScreens);
		tagList.add(TagFromName.NominalScreenDefinitionSequence);
		tagList.add(TagFromName.NumberOfVerticalPixels);
		tagList.add(TagFromName.NumberOfHorizontalPixels);
		tagList.add(TagFromName.DisplayEnvironmentSpatialPosition);
		tagList.add(TagFromName.ScreenMinimumGrayscaleBitDepth);
		tagList.add(TagFromName.ScreenMinimumColorBitDepth);
		tagList.add(TagFromName.ApplicationMaximumRepaintTime);
		tagList.add(TagFromName.DisplaySetsSequence);
		tagList.add(TagFromName.DisplaySetNumber);
		tagList.add(TagFromName.DisplaySetLabel);
		tagList.add(TagFromName.DisplaySetPresentationGroup);
		tagList.add(TagFromName.DisplaySetPresentationGroupDescription);
		tagList.add(TagFromName.PartialDataDisplayHandling);
		tagList.add(TagFromName.SynchronizedScrollingSequence);
		tagList.add(TagFromName.DisplaySetScrollingGroup);
		tagList.add(TagFromName.NavigationIndicatorSequence);
		tagList.add(TagFromName.NavigationDisplaySet);
		tagList.add(TagFromName.ReferenceDisplaySets);
		tagList.add(TagFromName.ImageBoxesSequence);
		tagList.add(TagFromName.ImageBoxNumber);
		tagList.add(TagFromName.ImageBoxLayoutType);
		tagList.add(TagFromName.ImageBoxTileHorizontalDimension);
		tagList.add(TagFromName.ImageBoxTileVerticalDimension);
		tagList.add(TagFromName.ImageBoxScrollDirection);
		tagList.add(TagFromName.ImageBoxSmallScrollType);
		tagList.add(TagFromName.ImageBoxSmallScrollAmount);
		tagList.add(TagFromName.ImageBoxLargeScrollType);
		tagList.add(TagFromName.ImageBoxLargeScrollAmount);
		tagList.add(TagFromName.ImageBoxOverlapPriority);
		tagList.add(TagFromName.CineRelativeToRealTime);
		tagList.add(TagFromName.FilterOperationsSequence);
		tagList.add(TagFromName.FilterByCategory);
		tagList.add(TagFromName.FilterByAttributePresence);
		tagList.add(TagFromName.FilterByOperator);
		tagList.add(TagFromName.StructuredDisplayBackgroundCIELabValue);
		tagList.add(TagFromName.EmptyImageBoxCIELabValue);
		tagList.add(TagFromName.StructuredDisplayImageBoxSequence);
		tagList.add(TagFromName.StructuredDisplayTextBoxSequence);
		tagList.add(TagFromName.ReferencedFirstFrameSequence);
		tagList.add(TagFromName.ImageBoxSynchronizationSequence);
		tagList.add(TagFromName.SynchronizedImageBoxList);
		tagList.add(TagFromName.TypeOfSynchronization);
		tagList.add(TagFromName.BlendingOperationType);
		tagList.add(TagFromName.ReformattingOperationType);
		tagList.add(TagFromName.ReformattingThickness);
		tagList.add(TagFromName.ReformattingInterval);
		tagList.add(TagFromName.ReformattingOperationInitialViewDirection);
		tagList.add(TagFromName.ThreeDRenderingType);
		tagList.add(TagFromName.SortingOperationsSequence);
		tagList.add(TagFromName.SortByCategory);
		tagList.add(TagFromName.SortingDirection);
		tagList.add(TagFromName.DisplaySetPatientOrientation);
		tagList.add(TagFromName.VOIType);
		tagList.add(TagFromName.PseudoColorType);
		tagList.add(TagFromName.PseudoColorPaletteInstanceReferenceSequence);
		tagList.add(TagFromName.ShowGrayscaleInverted);
		tagList.add(TagFromName.ShowImageTrueSizeFlag);
		tagList.add(TagFromName.ShowGraphicAnnotationFlag);
		tagList.add(TagFromName.ShowPatientDemographicsFlag);
		tagList.add(TagFromName.ShowAcquisitionTechniquesFlag);
		tagList.add(TagFromName.DisplaySetHorizontalJustification);
		tagList.add(TagFromName.DisplaySetVerticalJustification);
		tagList.add(TagFromName.ContinuationStartMeterset);
		tagList.add(TagFromName.ContinuationEndMeterset);
		tagList.add(TagFromName.ProcedureStepState);
		tagList.add(TagFromName.ProcedureStepProgressInformationSequence);
		tagList.add(TagFromName.ProcedureStepProgress);
		tagList.add(TagFromName.ProcedureStepProgressDescription);
		tagList.add(TagFromName.ProcedureStepCommunicationsURISequence);
		tagList.add(TagFromName.ContactURI);
		tagList.add(TagFromName.ContactDisplayName);
		tagList.add(TagFromName.ProcedureStepDiscontinuationReasonCodeSequence);
		tagList.add(TagFromName.BeamTaskSequence);
		tagList.add(TagFromName.BeamTaskType);
		tagList.add(TagFromName.BeamOrderIndexTrial);
		tagList.add(TagFromName.AutosequenceFlag);
		tagList.add(TagFromName.TableTopVerticalAdjustedPosition);
		tagList.add(TagFromName.TableTopLongitudinalAdjustedPosition);
		tagList.add(TagFromName.TableTopLateralAdjustedPosition);
		tagList.add(TagFromName.PatientSupportAdjustedAngle);
		tagList.add(TagFromName.TableTopEccentricAdjustedAngle);
		tagList.add(TagFromName.TableTopPitchAdjustedAngle);
		tagList.add(TagFromName.TableTopRollAdjustedAngle);
		tagList.add(TagFromName.DeliveryVerificationImageSequence);
		tagList.add(TagFromName.VerificationImageTiming);
		tagList.add(TagFromName.DoubleExposureFlag);
		tagList.add(TagFromName.DoubleExposureOrdering);
		tagList.add(TagFromName.DoubleExposureMetersetTrial);
		tagList.add(TagFromName.DoubleExposureFieldDeltaTrial);
		tagList.add(TagFromName.RelatedReferenceRTImageSequence);
		tagList.add(TagFromName.GeneralMachineVerificationSequence);
		tagList.add(TagFromName.ConventionalMachineVerificationSequence);
		tagList.add(TagFromName.IonMachineVerificationSequence);
		tagList.add(TagFromName.FailedAttributesSequence);
		tagList.add(TagFromName.OverriddenAttributesSequence);
		tagList.add(TagFromName.ConventionalControlPointVerificationSequence);
		tagList.add(TagFromName.IonControlPointVerificationSequence);
		tagList.add(TagFromName.AttributeOccurrenceSequence);
		tagList.add(TagFromName.AttributeOccurrencePointer);
		tagList.add(TagFromName.AttributeItemSelector);
		tagList.add(TagFromName.AttributeOccurrencePrivateCreator);
		tagList.add(TagFromName.SelectorSequencePointerItems);
		tagList.add(TagFromName.ScheduledProcedureStepPriority);
		tagList.add(TagFromName.WorklistLabel);
		tagList.add(TagFromName.ProcedureStepLabel);
		tagList.add(TagFromName.ScheduledProcessingParametersSequence);
		tagList.add(TagFromName.PerformedProcessingParametersSequence);
		tagList.add(TagFromName.UnifiedProcedureStepPerformedProcedureSequence);
		tagList.add(TagFromName.RelatedProcedureStepSequence);
		tagList.add(TagFromName.ProcedureStepRelationshipType);
		tagList.add(TagFromName.ReplacedProcedureStepSequence);
		tagList.add(TagFromName.DeletionLock);
		tagList.add(TagFromName.ReceivingAE);
		tagList.add(TagFromName.RequestingAE);
		tagList.add(TagFromName.ReasonForCancellation);
		tagList.add(TagFromName.SCPStatus);
		tagList.add(TagFromName.SubscriptionListStatus);
		tagList.add(TagFromName.UnifiedProcedureStepListStatus);
		tagList.add(TagFromName.BeamOrderIndex);
		tagList.add(TagFromName.DoubleExposureMeterset);
		tagList.add(TagFromName.DoubleExposureFieldDelta);
		tagList.add(TagFromName.BrachyTaskSequence);
		tagList.add(TagFromName.ContinuationStartTotalReferenceAirKerma);
		tagList.add(TagFromName.ContinuationEndTotalReferenceAirKerma);
		tagList.add(TagFromName.ContinuationPulseNumber);
		tagList.add(TagFromName.ChannelDeliveryOrderSequence);
		tagList.add(TagFromName.ReferencedChannelNumber);
		tagList.add(TagFromName.StartCumulativeTimeWeight);
		tagList.add(TagFromName.EndCumulativeTimeWeight);
		tagList.add(TagFromName.OmittedChannelSequence);
		tagList.add(TagFromName.ReasonForChannelOmission);
		tagList.add(TagFromName.ReasonForChannelOmissionDescription);
		tagList.add(TagFromName.ChannelDeliveryOrderIndex);
		tagList.add(TagFromName.ChannelDeliveryContinuationSequence);
		tagList.add(TagFromName.OmittedApplicationSetupSequence);
		tagList.add(TagFromName.ImplantAssemblyTemplateName);
		tagList.add(TagFromName.ImplantAssemblyTemplateIssuer);
		tagList.add(TagFromName.ImplantAssemblyTemplateVersion);
		tagList.add(TagFromName.ReplacedImplantAssemblyTemplateSequence);
		tagList.add(TagFromName.ImplantAssemblyTemplateType);
		tagList.add(TagFromName.OriginalImplantAssemblyTemplateSequence);
		tagList.add(TagFromName.DerivationImplantAssemblyTemplateSequence);
		tagList.add(TagFromName.ImplantAssemblyTemplateTargetAnatomySequence);
		tagList.add(TagFromName.ProcedureTypeCodeSequence);
		tagList.add(TagFromName.SurgicalTechnique);
		tagList.add(TagFromName.ComponentTypesSequence);
		tagList.add(TagFromName.ComponentTypeCodeSequence);
		tagList.add(TagFromName.ExclusiveComponentType);
		tagList.add(TagFromName.MandatoryComponentType);
		tagList.add(TagFromName.ComponentSequence);
		tagList.add(TagFromName.ComponentID);
		tagList.add(TagFromName.ComponentAssemblySequence);
		tagList.add(TagFromName.Component1ReferencedID);
		tagList.add(TagFromName.Component1ReferencedMatingFeatureSetID);
		tagList.add(TagFromName.Component1ReferencedMatingFeatureID);
		tagList.add(TagFromName.Component2ReferencedID);
		tagList.add(TagFromName.Component2ReferencedMatingFeatureSetID);
		tagList.add(TagFromName.Component2ReferencedMatingFeatureID);
		tagList.add(TagFromName.ImplantTemplateGroupName);
		tagList.add(TagFromName.ImplantTemplateGroupDescription);
		tagList.add(TagFromName.ImplantTemplateGroupIssuer);
		tagList.add(TagFromName.ImplantTemplateGroupVersion);
		tagList.add(TagFromName.ReplacedImplantTemplateGroupSequence);
		tagList.add(TagFromName.ImplantTemplateGroupTargetAnatomySequence);
		tagList.add(TagFromName.ImplantTemplateGroupMembersSequence);
		tagList.add(TagFromName.ImplantTemplateGroupMemberID);
		tagList.add(TagFromName.ThreeDImplantTemplateGroupMemberMatchingPoint);
		tagList.add(TagFromName.ThreeDImplantTemplateGroupMemberMatchingAxes);
		tagList.add(TagFromName.ImplantTemplateGroupMemberMatching2DCoordinatesSequence);
		tagList.add(TagFromName.TwoDImplantTemplateGroupMemberMatchingPoint);
		tagList.add(TagFromName.TwoDImplantTemplateGroupMemberMatchingAxes);
		tagList.add(TagFromName.ImplantTemplateGroupVariationDimensionSequence);
		tagList.add(TagFromName.ImplantTemplateGroupVariationDimensionName);
		tagList.add(TagFromName.ImplantTemplateGroupVariationDimensionRankSequence);
		tagList.add(TagFromName.ReferencedImplantTemplateGroupMemberID);
		tagList.add(TagFromName.ImplantTemplateGroupVariationDimensionRank);
		tagList.add(TagFromName.SurfaceScanAcquisitionTypeCodeSequence);
		tagList.add(TagFromName.SurfaceScanModeCodeSequence);
		tagList.add(TagFromName.RegistrationMethodCodeSequence);
		tagList.add(TagFromName.ShotDurationTime);
		tagList.add(TagFromName.ShotOffsetTime);
		tagList.add(TagFromName.SurfacePointPresentationValueData);
		tagList.add(TagFromName.SurfacePointColorCIELabValueData);
		tagList.add(TagFromName.UVMappingSequence);
		tagList.add(TagFromName.TextureLabel);
		tagList.add(TagFromName.UValueData);
		tagList.add(TagFromName.VValueData);
		tagList.add(TagFromName.ReferencedTextureSequence);
		tagList.add(TagFromName.ReferencedSurfaceDataSequence);
		tagList.add(TagFromName.StorageMediaFileSetID);
		tagList.add(TagFromName.StorageMediaFileSetUID);
		tagList.add(TagFromName.IconImageSequence);
		tagList.add(TagFromName.TopicTitle);
		tagList.add(TagFromName.TopicSubject);
		tagList.add(TagFromName.TopicAuthor);
		tagList.add(TagFromName.TopicKeywords);
		tagList.add(TagFromName.SOPInstanceStatus);
		tagList.add(TagFromName.SOPAuthorizationDateTime);
		tagList.add(TagFromName.SOPAuthorizationComment);
		tagList.add(TagFromName.AuthorizationEquipmentCertificationNumber);
		tagList.add(TagFromName.MACIDNumber);
		tagList.add(TagFromName.MACCalculationTransferSyntaxUID);
		tagList.add(TagFromName.MACAlgorithm);
		tagList.add(TagFromName.DataElementsSigned);
		tagList.add(TagFromName.DigitalSignatureUID);
		tagList.add(TagFromName.DigitalSignatureDateTime);
		tagList.add(TagFromName.CertificateType);
		tagList.add(TagFromName.CertificateOfSigner);
		tagList.add(TagFromName.Signature);
		tagList.add(TagFromName.CertifiedTimestampType);
		tagList.add(TagFromName.CertifiedTimestamp);
		tagList.add(TagFromName.DigitalSignaturePurposeCodeSequence);
		tagList.add(TagFromName.ReferencedDigitalSignatureSequence);
		tagList.add(TagFromName.ReferencedSOPInstanceMACSequence);
		tagList.add(TagFromName.MAC);
		tagList.add(TagFromName.EncryptedAttributesSequence);
		tagList.add(TagFromName.EncryptedContentTransferSyntaxUID);
		tagList.add(TagFromName.EncryptedContent);
		tagList.add(TagFromName.ModifiedAttributesSequence);
		tagList.add(TagFromName.OriginalAttributesSequence);
		tagList.add(TagFromName.AttributeModificationDateTime);
		tagList.add(TagFromName.ModifyingSystem);
		tagList.add(TagFromName.SourceOfPreviousValues);
		tagList.add(TagFromName.ReasonForTheAttributeModification);
		tagList.add(TagFromName.ZonalMap);
		tagList.add(TagFromName.NumberOfCopies);
		tagList.add(TagFromName.PrinterConfigurationSequence);
		tagList.add(TagFromName.PrintPriority);
		tagList.add(TagFromName.MediumType);
		tagList.add(TagFromName.FilmDestination);
		tagList.add(TagFromName.FilmSessionLabel);
		tagList.add(TagFromName.MemoryAllocation);
		tagList.add(TagFromName.MaximumMemoryAllocation);
		tagList.add(TagFromName.ColorImagePrintingFlag);
		tagList.add(TagFromName.CollationFlag);
		tagList.add(TagFromName.AnnotationFlag);
		tagList.add(TagFromName.ImageOverlayFlag);
		tagList.add(TagFromName.PresentationLUTFlag);
		tagList.add(TagFromName.ImageBoxPresentationLUTFlag);
		tagList.add(TagFromName.MemoryBitDepth);
		tagList.add(TagFromName.PrintingBitDepth);
		tagList.add(TagFromName.MediaInstalledSequence);
		tagList.add(TagFromName.OtherMediaAvailableSequence);
		tagList.add(TagFromName.SupportedImageDisplayFormatsSequence);
		tagList.add(TagFromName.ReferencedFilmBoxSequence);
		tagList.add(TagFromName.ReferencedStoredPrintSequence);
		tagList.add(TagFromName.ImageDisplayFormat);
		tagList.add(TagFromName.AnnotationDisplayFormatID);
		tagList.add(TagFromName.FilmOrientation);
		tagList.add(TagFromName.FilmSizeID);
		tagList.add(TagFromName.PrinterResolutionID);
		tagList.add(TagFromName.DefaultPrinterResolutionID);
		tagList.add(TagFromName.MagnificationType);
		tagList.add(TagFromName.SmoothingType);
		tagList.add(TagFromName.DefaultMagnificationType);
		tagList.add(TagFromName.OtherMagnificationTypesAvailable);
		tagList.add(TagFromName.DefaultSmoothingType);
		tagList.add(TagFromName.OtherSmoothingTypesAvailable);
		tagList.add(TagFromName.BorderDensity);
		tagList.add(TagFromName.EmptyImageDensity);
		tagList.add(TagFromName.MinDensity);
		tagList.add(TagFromName.MaxDensity);
		tagList.add(TagFromName.Trim);
		tagList.add(TagFromName.ConfigurationInformation);
		tagList.add(TagFromName.ConfigurationInformationDescription);
		tagList.add(TagFromName.MaximumCollatedFilms);
		tagList.add(TagFromName.Illumination);
		tagList.add(TagFromName.ReflectedAmbientLight);
		tagList.add(TagFromName.PrinterPixelSpacing);
		tagList.add(TagFromName.ReferencedFilmSessionSequence);
		tagList.add(TagFromName.ReferencedImageBoxSequence);
		tagList.add(TagFromName.ReferencedBasicAnnotationBoxSequence);
		tagList.add(TagFromName.ImageBoxPosition);
		tagList.add(TagFromName.Polarity);
		tagList.add(TagFromName.RequestedImageSize);
		tagList.add(TagFromName.RequestedDecimateCropBehavior);
		tagList.add(TagFromName.RequestedResolutionID);
		tagList.add(TagFromName.RequestedImageSizeFlag);
		tagList.add(TagFromName.DecimateCropResult);
		tagList.add(TagFromName.BasicGrayscaleImageSequence);
		tagList.add(TagFromName.BasicColorImageSequence);
		tagList.add(TagFromName.ReferencedImageOverlayBoxSequence);
		tagList.add(TagFromName.ReferencedVOILUTBoxSequence);
		tagList.add(TagFromName.AnnotationPosition);
		tagList.add(TagFromName.TextString);
		tagList.add(TagFromName.ReferencedOverlayPlaneSequence);
		tagList.add(TagFromName.ReferencedOverlayPlaneGroups);
		tagList.add(TagFromName.OverlayPixelDataSequence);
		tagList.add(TagFromName.OverlayMagnificationType);
		tagList.add(TagFromName.OverlaySmoothingType);
		tagList.add(TagFromName.OverlayOrImageMagnification);
		tagList.add(TagFromName.MagnifyToNumberOfColumns);
		tagList.add(TagFromName.OverlayForegroundDensity);
		tagList.add(TagFromName.OverlayBackgroundDensity);
		tagList.add(TagFromName.OverlayMode);
		tagList.add(TagFromName.ThresholdDensity);
		tagList.add(TagFromName.ReferencedImageBoxSequenceRetired);
		tagList.add(TagFromName.PresentationLUTSequence);
		tagList.add(TagFromName.PresentationLUTShape);
		tagList.add(TagFromName.ReferencedPresentationLUTSequence);
		tagList.add(TagFromName.PrintJobID);
		tagList.add(TagFromName.ExecutionStatus);
		tagList.add(TagFromName.ExecutionStatusInfo);
		tagList.add(TagFromName.CreationDate);
		tagList.add(TagFromName.CreationTime);
		tagList.add(TagFromName.Originator);
		tagList.add(TagFromName.DestinationAE);
		tagList.add(TagFromName.OwnerID);
		tagList.add(TagFromName.NumberOfFilms);
		tagList.add(TagFromName.ReferencedPrintJobSequencePullStoredPrint);
		tagList.add(TagFromName.PrinterStatus);
		tagList.add(TagFromName.PrinterStatusInfo);
		tagList.add(TagFromName.PrinterName);
		tagList.add(TagFromName.PrintQueueID);
		tagList.add(TagFromName.QueueStatus);
		tagList.add(TagFromName.PrintJobDescriptionSequence);
		tagList.add(TagFromName.ReferencedPrintJobSequence);
		tagList.add(TagFromName.PrintManagementCapabilitiesSequence);
		tagList.add(TagFromName.PrinterCharacteristicsSequence);
		tagList.add(TagFromName.FilmBoxContentSequence);
		tagList.add(TagFromName.ImageBoxContentSequence);
		tagList.add(TagFromName.AnnotationContentSequence);
		tagList.add(TagFromName.ImageOverlayBoxContentSequence);
		tagList.add(TagFromName.PresentationLUTContentSequence);
		tagList.add(TagFromName.ProposedStudySequence);
		tagList.add(TagFromName.OriginalImageSequence);
		tagList.add(TagFromName.LabelUsingInformationExtractedFromInstances);
		tagList.add(TagFromName.LabelText);
		tagList.add(TagFromName.LabelStyleSelection);
		tagList.add(TagFromName.MediaDisposition);
		tagList.add(TagFromName.BarcodeValue);
		tagList.add(TagFromName.BarcodeSymbology);
		tagList.add(TagFromName.AllowMediaSplitting);
		tagList.add(TagFromName.IncludeNonDICOMObjects);
		tagList.add(TagFromName.IncludeDisplayApplication);
		tagList.add(TagFromName.PreserveCompositeInstancesAfterMediaCreation);
		tagList.add(TagFromName.TotalNumberOfPiecesOfMediaCreated);
		tagList.add(TagFromName.RequestedMediaApplicationProfile);
		tagList.add(TagFromName.ReferencedStorageMediaSequence);
		tagList.add(TagFromName.FailureAttributes);
		tagList.add(TagFromName.AllowLossyCompression);
		tagList.add(TagFromName.RequestPriority);
		tagList.add(TagFromName.RTImageLabel);
		tagList.add(TagFromName.RTImageName);
		tagList.add(TagFromName.RTImageDescription);
		tagList.add(TagFromName.ReportedValuesOrigin);
		tagList.add(TagFromName.RTImagePlane);
		tagList.add(TagFromName.XRayImageReceptorTranslation);
		tagList.add(TagFromName.XRayImageReceptorAngle);
		tagList.add(TagFromName.RTImageOrientation);
		tagList.add(TagFromName.ImagePlanePixelSpacing);
		tagList.add(TagFromName.RTImagePosition);
		tagList.add(TagFromName.RadiationMachineName);
		tagList.add(TagFromName.RadiationMachineSAD);
		tagList.add(TagFromName.RadiationMachineSSD);
		tagList.add(TagFromName.RTImageSID);
		tagList.add(TagFromName.SourceToReferenceObjectDistance);
		tagList.add(TagFromName.FractionNumber);
		tagList.add(TagFromName.ExposureSequence);
		tagList.add(TagFromName.MetersetExposure);
		tagList.add(TagFromName.DiaphragmPosition);
		tagList.add(TagFromName.FluenceMapSequence);
		tagList.add(TagFromName.FluenceDataSource);
		tagList.add(TagFromName.FluenceDataScale);
		tagList.add(TagFromName.PrimaryFluenceModeSequence);
		tagList.add(TagFromName.FluenceMode);
		tagList.add(TagFromName.FluenceModeID);
		tagList.add(TagFromName.DVHType);
		tagList.add(TagFromName.DoseUnits);
		tagList.add(TagFromName.DoseType);
		tagList.add(TagFromName.SpatialTransformOfDose);
		tagList.add(TagFromName.DoseComment);
		tagList.add(TagFromName.NormalizationPoint);
		tagList.add(TagFromName.DoseSummationType);
		tagList.add(TagFromName.GridFrameOffsetVector);
		tagList.add(TagFromName.DoseGridScaling);
		tagList.add(TagFromName.RTDoseROISequence);
		tagList.add(TagFromName.DoseValue);
		tagList.add(TagFromName.TissueHeterogeneityCorrection);
		tagList.add(TagFromName.DVHNormalizationPoint);
		tagList.add(TagFromName.DVHNormalizationDoseValue);
		tagList.add(TagFromName.DVHSequence);
		tagList.add(TagFromName.DVHDoseScaling);
		tagList.add(TagFromName.DVHVolumeUnits);
		tagList.add(TagFromName.DVHNumberOfBins);
		tagList.add(TagFromName.DVHData);
		tagList.add(TagFromName.DVHReferencedROISequence);
		tagList.add(TagFromName.DVHROIContributionType);
		tagList.add(TagFromName.DVHMinimumDose);
		tagList.add(TagFromName.DVHMaximumDose);
		tagList.add(TagFromName.DVHMeanDose);
		tagList.add(TagFromName.StructureSetLabel);
		tagList.add(TagFromName.StructureSetName);
		tagList.add(TagFromName.StructureSetDescription);
		tagList.add(TagFromName.StructureSetDate);
		tagList.add(TagFromName.StructureSetTime);
		tagList.add(TagFromName.ReferencedFrameOfReferenceSequence);
		tagList.add(TagFromName.RTReferencedStudySequence);
		tagList.add(TagFromName.RTReferencedSeriesSequence);
		tagList.add(TagFromName.ContourImageSequence);
		tagList.add(TagFromName.PredecessorStructureSetSequence);
		tagList.add(TagFromName.StructureSetROISequence);
		tagList.add(TagFromName.ROINumber);
		tagList.add(TagFromName.ReferencedFrameOfReferenceUID);
		tagList.add(TagFromName.ROIName);
		tagList.add(TagFromName.ROIDescription);
		tagList.add(TagFromName.ROIDisplayColor);
		tagList.add(TagFromName.ROIVolume);
		tagList.add(TagFromName.RTRelatedROISequence);
		tagList.add(TagFromName.RTROIRelationship);
		tagList.add(TagFromName.ROIGenerationAlgorithm);
		tagList.add(TagFromName.ROIGenerationDescription);
		tagList.add(TagFromName.ROIContourSequence);
		tagList.add(TagFromName.ContourSequence);
		tagList.add(TagFromName.ContourGeometricType);
		tagList.add(TagFromName.ContourSlabThickness);
		tagList.add(TagFromName.ContourOffsetVector);
		tagList.add(TagFromName.NumberOfContourPoints);
		tagList.add(TagFromName.ContourNumber);
		tagList.add(TagFromName.AttachedContours);
		tagList.add(TagFromName.ContourData);
		tagList.add(TagFromName.RTROIObservationsSequence);
		tagList.add(TagFromName.ObservationNumber);
		tagList.add(TagFromName.ReferencedROINumber);
		tagList.add(TagFromName.ROIObservationLabel);
		tagList.add(TagFromName.RTROIIdentificationCodeSequence);
		tagList.add(TagFromName.ROIObservationDescription);
		tagList.add(TagFromName.RelatedRTROIObservationsSequence);
		tagList.add(TagFromName.RTROIInterpretedType);
		tagList.add(TagFromName.ROIInterpreter);
		tagList.add(TagFromName.ROIPhysicalPropertiesSequence);
		tagList.add(TagFromName.ROIPhysicalProperty);
		tagList.add(TagFromName.ROIPhysicalPropertyValue);
		tagList.add(TagFromName.ROIElementalCompositionSequence);
		tagList.add(TagFromName.ROIElementalCompositionAtomicNumber);
		tagList.add(TagFromName.ROIElementalCompositionAtomicMassFraction);
		tagList.add(TagFromName.AdditionalRTROIClassificationCodeSequence);
		tagList.add(TagFromName.FrameOfReferenceRelationshipSequence);
		tagList.add(TagFromName.RelatedFrameOfReferenceUID);
		tagList.add(TagFromName.FrameOfReferenceTransformationType);
		tagList.add(TagFromName.FrameOfReferenceTransformationMatrix);
		tagList.add(TagFromName.FrameOfReferenceTransformationComment);
		tagList.add(TagFromName.MeasuredDoseReferenceSequence);
		tagList.add(TagFromName.MeasuredDoseDescription);
		tagList.add(TagFromName.MeasuredDoseType);
		tagList.add(TagFromName.MeasuredDoseValue);
		tagList.add(TagFromName.TreatmentSessionBeamSequence);
		tagList.add(TagFromName.TreatmentSessionIonBeamSequence);
		tagList.add(TagFromName.CurrentFractionNumber);
		tagList.add(TagFromName.TreatmentControlPointDate);
		tagList.add(TagFromName.TreatmentControlPointTime);
		tagList.add(TagFromName.TreatmentTerminationStatus);
		tagList.add(TagFromName.TreatmentTerminationCode);
		tagList.add(TagFromName.TreatmentVerificationStatus);
		tagList.add(TagFromName.ReferencedTreatmentRecordSequence);
		tagList.add(TagFromName.SpecifiedPrimaryMeterset);
		tagList.add(TagFromName.SpecifiedSecondaryMeterset);
		tagList.add(TagFromName.DeliveredPrimaryMeterset);
		tagList.add(TagFromName.DeliveredSecondaryMeterset);
		tagList.add(TagFromName.SpecifiedTreatmentTime);
		tagList.add(TagFromName.DeliveredTreatmentTime);
		tagList.add(TagFromName.ControlPointDeliverySequence);
		tagList.add(TagFromName.IonControlPointDeliverySequence);
		tagList.add(TagFromName.SpecifiedMeterset);
		tagList.add(TagFromName.DeliveredMeterset);
		tagList.add(TagFromName.MetersetRateSet);
		tagList.add(TagFromName.MetersetRateDelivered);
		tagList.add(TagFromName.ScanSpotMetersetsDelivered);
		tagList.add(TagFromName.DoseRateDelivered);
		tagList.add(TagFromName.TreatmentSummaryCalculatedDoseReferenceSequence);
		tagList.add(TagFromName.CumulativeDoseToDoseReference);
		tagList.add(TagFromName.FirstTreatmentDate);
		tagList.add(TagFromName.MostRecentTreatmentDate);
		tagList.add(TagFromName.NumberOfFractionsDelivered);
		tagList.add(TagFromName.OverrideSequence);
		tagList.add(TagFromName.ParameterSequencePointer);
		tagList.add(TagFromName.OverrideParameterPointer);
		tagList.add(TagFromName.ParameterItemIndex);
		tagList.add(TagFromName.MeasuredDoseReferenceNumber);
		tagList.add(TagFromName.ParameterPointer);
		tagList.add(TagFromName.OverrideReason);
		tagList.add(TagFromName.CorrectedParameterSequence);
		tagList.add(TagFromName.CorrectionValue);
		tagList.add(TagFromName.CalculatedDoseReferenceSequence);
		tagList.add(TagFromName.CalculatedDoseReferenceNumber);
		tagList.add(TagFromName.CalculatedDoseReferenceDescription);
		tagList.add(TagFromName.CalculatedDoseReferenceDoseValue);
		tagList.add(TagFromName.StartMeterset);
		tagList.add(TagFromName.EndMeterset);
		tagList.add(TagFromName.ReferencedMeasuredDoseReferenceSequence);
		tagList.add(TagFromName.ReferencedMeasuredDoseReferenceNumber);
		tagList.add(TagFromName.ReferencedCalculatedDoseReferenceSequence);
		tagList.add(TagFromName.ReferencedCalculatedDoseReferenceNumber);
		tagList.add(TagFromName.BeamLimitingDeviceLeafPairsSequence);
		tagList.add(TagFromName.RecordedWedgeSequence);
		tagList.add(TagFromName.RecordedCompensatorSequence);
		tagList.add(TagFromName.RecordedBlockSequence);
		tagList.add(TagFromName.TreatmentSummaryMeasuredDoseReferenceSequence);
		tagList.add(TagFromName.RecordedSnoutSequence);
		tagList.add(TagFromName.RecordedRangeShifterSequence);
		tagList.add(TagFromName.RecordedLateralSpreadingDeviceSequence);
		tagList.add(TagFromName.RecordedRangeModulatorSequence);
		tagList.add(TagFromName.RecordedSourceSequence);
		tagList.add(TagFromName.SourceSerialNumber);
		tagList.add(TagFromName.TreatmentSessionApplicationSetupSequence);
		tagList.add(TagFromName.ApplicationSetupCheck);
		tagList.add(TagFromName.RecordedBrachyAccessoryDeviceSequence);
		tagList.add(TagFromName.ReferencedBrachyAccessoryDeviceNumber);
		tagList.add(TagFromName.RecordedChannelSequence);
		tagList.add(TagFromName.SpecifiedChannelTotalTime);
		tagList.add(TagFromName.DeliveredChannelTotalTime);
		tagList.add(TagFromName.SpecifiedNumberOfPulses);
		tagList.add(TagFromName.DeliveredNumberOfPulses);
		tagList.add(TagFromName.SpecifiedPulseRepetitionInterval);
		tagList.add(TagFromName.DeliveredPulseRepetitionInterval);
		tagList.add(TagFromName.RecordedSourceApplicatorSequence);
		tagList.add(TagFromName.ReferencedSourceApplicatorNumber);
		tagList.add(TagFromName.RecordedChannelShieldSequence);
		tagList.add(TagFromName.ReferencedChannelShieldNumber);
		tagList.add(TagFromName.BrachyControlPointDeliveredSequence);
		tagList.add(TagFromName.SafePositionExitDate);
		tagList.add(TagFromName.SafePositionExitTime);
		tagList.add(TagFromName.SafePositionReturnDate);
		tagList.add(TagFromName.SafePositionReturnTime);
		tagList.add(TagFromName.PulseSpecificBrachyControlPointDeliveredSequence);
		tagList.add(TagFromName.PulseNumber);
		tagList.add(TagFromName.BrachyPulseControlPointDeliveredSequence);
		tagList.add(TagFromName.CurrentTreatmentStatus);
		tagList.add(TagFromName.TreatmentStatusComment);
		tagList.add(TagFromName.FractionGroupSummarySequence);
		tagList.add(TagFromName.ReferencedFractionNumber);
		tagList.add(TagFromName.FractionGroupType);
		tagList.add(TagFromName.BeamStopperPosition);
		tagList.add(TagFromName.FractionStatusSummarySequence);
		tagList.add(TagFromName.TreatmentDate);
		tagList.add(TagFromName.TreatmentTime);
		tagList.add(TagFromName.RTPlanLabel);
		tagList.add(TagFromName.RTPlanName);
		tagList.add(TagFromName.RTPlanDescription);
		tagList.add(TagFromName.RTPlanDate);
		tagList.add(TagFromName.RTPlanTime);
		tagList.add(TagFromName.TreatmentProtocols);
		tagList.add(TagFromName.PlanIntent);
		tagList.add(TagFromName.TreatmentSites);
		tagList.add(TagFromName.RTPlanGeometry);
		tagList.add(TagFromName.PrescriptionDescription);
		tagList.add(TagFromName.DoseReferenceSequence);
		tagList.add(TagFromName.DoseReferenceNumber);
		tagList.add(TagFromName.DoseReferenceUID);
		tagList.add(TagFromName.DoseReferenceStructureType);
		tagList.add(TagFromName.NominalBeamEnergyUnit);
		tagList.add(TagFromName.DoseReferenceDescription);
		tagList.add(TagFromName.DoseReferencePointCoordinates);
		tagList.add(TagFromName.NominalPriorDose);
		tagList.add(TagFromName.DoseReferenceType);
		tagList.add(TagFromName.ConstraintWeight);
		tagList.add(TagFromName.DeliveryWarningDose);
		tagList.add(TagFromName.DeliveryMaximumDose);
		tagList.add(TagFromName.TargetMinimumDose);
		tagList.add(TagFromName.TargetPrescriptionDose);
		tagList.add(TagFromName.TargetMaximumDose);
		tagList.add(TagFromName.TargetUnderdoseVolumeFraction);
		tagList.add(TagFromName.OrganAtRiskFullVolumeDose);
		tagList.add(TagFromName.OrganAtRiskLimitDose);
		tagList.add(TagFromName.OrganAtRiskMaximumDose);
		tagList.add(TagFromName.OrganAtRiskOverdoseVolumeFraction);
		tagList.add(TagFromName.ToleranceTableSequence);
		tagList.add(TagFromName.ToleranceTableNumber);
		tagList.add(TagFromName.ToleranceTableLabel);
		tagList.add(TagFromName.GantryAngleTolerance);
		tagList.add(TagFromName.BeamLimitingDeviceAngleTolerance);
		tagList.add(TagFromName.BeamLimitingDeviceToleranceSequence);
		tagList.add(TagFromName.BeamLimitingDevicePositionTolerance);
		tagList.add(TagFromName.SnoutPositionTolerance);
		tagList.add(TagFromName.PatientSupportAngleTolerance);
		tagList.add(TagFromName.TableTopEccentricAngleTolerance);
		tagList.add(TagFromName.TableTopPitchAngleTolerance);
		tagList.add(TagFromName.TableTopRollAngleTolerance);
		tagList.add(TagFromName.TableTopVerticalPositionTolerance);
		tagList.add(TagFromName.TableTopLongitudinalPositionTolerance);
		tagList.add(TagFromName.TableTopLateralPositionTolerance);
		tagList.add(TagFromName.RTPlanRelationship);
		tagList.add(TagFromName.FractionGroupSequence);
		tagList.add(TagFromName.FractionGroupNumber);
		tagList.add(TagFromName.FractionGroupDescription);
		tagList.add(TagFromName.NumberOfFractionsPlanned);
		tagList.add(TagFromName.NumberOfFractionPatternDigitsPerDay);
		tagList.add(TagFromName.RepeatFractionCycleLength);
		tagList.add(TagFromName.FractionPattern);
		tagList.add(TagFromName.NumberOfBeams);
		tagList.add(TagFromName.BeamDoseSpecificationPoint);
		tagList.add(TagFromName.BeamDose);
		tagList.add(TagFromName.BeamMeterset);
		tagList.add(TagFromName.BeamDosePointDepth);
		tagList.add(TagFromName.BeamDosePointEquivalentDepth);
		tagList.add(TagFromName.BeamDosePointSSD);
		tagList.add(TagFromName.BeamDoseMeaning);
		tagList.add(TagFromName.BeamDoseVerificationControlPointSequence);
		tagList.add(TagFromName.AverageBeamDosePointDepth);
		tagList.add(TagFromName.AverageBeamDosePointEquivalentDepth);
		tagList.add(TagFromName.AverageBeamDosePointSSD);
		tagList.add(TagFromName.BeamDoseType);
		tagList.add(TagFromName.AlternateBeamDose);
		tagList.add(TagFromName.AlternateBeamDoseType);
		tagList.add(TagFromName.NumberOfBrachyApplicationSetups);
		tagList.add(TagFromName.BrachyApplicationSetupDoseSpecificationPoint);
		tagList.add(TagFromName.BrachyApplicationSetupDose);
		tagList.add(TagFromName.BeamSequence);
		tagList.add(TagFromName.TreatmentMachineName);
		tagList.add(TagFromName.PrimaryDosimeterUnit);
		tagList.add(TagFromName.SourceAxisDistance);
		tagList.add(TagFromName.BeamLimitingDeviceSequence);
		tagList.add(TagFromName.RTBeamLimitingDeviceType);
		tagList.add(TagFromName.SourceToBeamLimitingDeviceDistance);
		tagList.add(TagFromName.IsocenterToBeamLimitingDeviceDistance);
		tagList.add(TagFromName.NumberOfLeafJawPairs);
		tagList.add(TagFromName.LeafPositionBoundaries);
		tagList.add(TagFromName.BeamNumber);
		tagList.add(TagFromName.BeamName);
		tagList.add(TagFromName.BeamDescription);
		tagList.add(TagFromName.BeamType);
		tagList.add(TagFromName.BeamDeliveryDurationLimit);
		tagList.add(TagFromName.RadiationType);
		tagList.add(TagFromName.HighDoseTechniqueType);
		tagList.add(TagFromName.ReferenceImageNumber);
		tagList.add(TagFromName.PlannedVerificationImageSequence);
		tagList.add(TagFromName.ImagingDeviceSpecificAcquisitionParameters);
		tagList.add(TagFromName.TreatmentDeliveryType);
		tagList.add(TagFromName.NumberOfWedges);
		tagList.add(TagFromName.WedgeSequence);
		tagList.add(TagFromName.WedgeNumber);
		tagList.add(TagFromName.WedgeType);
		tagList.add(TagFromName.WedgeID);
		tagList.add(TagFromName.WedgeAngle);
		tagList.add(TagFromName.WedgeFactor);
		tagList.add(TagFromName.TotalWedgeTrayWaterEquivalentThickness);
		tagList.add(TagFromName.WedgeOrientation);
		tagList.add(TagFromName.IsocenterToWedgeTrayDistance);
		tagList.add(TagFromName.SourceToWedgeTrayDistance);
		tagList.add(TagFromName.WedgeThinEdgePosition);
		tagList.add(TagFromName.BolusID);
		tagList.add(TagFromName.BolusDescription);
		tagList.add(TagFromName.EffectiveWedgeAngle);
		tagList.add(TagFromName.NumberOfCompensators);
		tagList.add(TagFromName.MaterialID);
		tagList.add(TagFromName.TotalCompensatorTrayFactor);
		tagList.add(TagFromName.CompensatorSequence);
		tagList.add(TagFromName.CompensatorNumber);
		tagList.add(TagFromName.CompensatorID);
		tagList.add(TagFromName.SourceToCompensatorTrayDistance);
		tagList.add(TagFromName.CompensatorRows);
		tagList.add(TagFromName.CompensatorColumns);
		tagList.add(TagFromName.CompensatorPixelSpacing);
		tagList.add(TagFromName.CompensatorPosition);
		tagList.add(TagFromName.CompensatorTransmissionData);
		tagList.add(TagFromName.CompensatorThicknessData);
		tagList.add(TagFromName.NumberOfBoli);
		tagList.add(TagFromName.CompensatorType);
		tagList.add(TagFromName.CompensatorTrayID);
		tagList.add(TagFromName.NumberOfBlocks);
		tagList.add(TagFromName.TotalBlockTrayFactor);
		tagList.add(TagFromName.TotalBlockTrayWaterEquivalentThickness);
		tagList.add(TagFromName.BlockSequence);
		tagList.add(TagFromName.BlockTrayID);
		tagList.add(TagFromName.SourceToBlockTrayDistance);
		tagList.add(TagFromName.IsocenterToBlockTrayDistance);
		tagList.add(TagFromName.BlockType);
		tagList.add(TagFromName.AccessoryCode);
		tagList.add(TagFromName.BlockDivergence);
		tagList.add(TagFromName.BlockMountingPosition);
		tagList.add(TagFromName.BlockNumber);
		tagList.add(TagFromName.BlockName);
		tagList.add(TagFromName.BlockThickness);
		tagList.add(TagFromName.BlockTransmission);
		tagList.add(TagFromName.BlockNumberOfPoints);
		tagList.add(TagFromName.BlockData);
		tagList.add(TagFromName.ApplicatorSequence);
		tagList.add(TagFromName.ApplicatorID);
		tagList.add(TagFromName.ApplicatorType);
		tagList.add(TagFromName.ApplicatorDescription);
		tagList.add(TagFromName.CumulativeDoseReferenceCoefficient);
		tagList.add(TagFromName.FinalCumulativeMetersetWeight);
		tagList.add(TagFromName.NumberOfControlPoints);
		tagList.add(TagFromName.ControlPointSequence);
		tagList.add(TagFromName.ControlPointIndex);
		tagList.add(TagFromName.NominalBeamEnergy);
		tagList.add(TagFromName.DoseRateSet);
		tagList.add(TagFromName.WedgePositionSequence);
		tagList.add(TagFromName.WedgePosition);
		tagList.add(TagFromName.BeamLimitingDevicePositionSequence);
		tagList.add(TagFromName.LeafJawPositions);
		tagList.add(TagFromName.GantryAngle);
		tagList.add(TagFromName.GantryRotationDirection);
		tagList.add(TagFromName.BeamLimitingDeviceAngle);
		tagList.add(TagFromName.BeamLimitingDeviceRotationDirection);
		tagList.add(TagFromName.PatientSupportAngle);
		tagList.add(TagFromName.PatientSupportRotationDirection);
		tagList.add(TagFromName.TableTopEccentricAxisDistance);
		tagList.add(TagFromName.TableTopEccentricAngle);
		tagList.add(TagFromName.TableTopEccentricRotationDirection);
		tagList.add(TagFromName.TableTopVerticalPosition);
		tagList.add(TagFromName.TableTopLongitudinalPosition);
		tagList.add(TagFromName.TableTopLateralPosition);
		tagList.add(TagFromName.IsocenterPosition);
		tagList.add(TagFromName.SurfaceEntryPoint);
		tagList.add(TagFromName.SourceToSurfaceDistance);
		tagList.add(TagFromName.AverageBeamDosePointSourceToExternalContourSurfaceDistance);
		tagList.add(TagFromName.SourceToExternalContourDistance);
		tagList.add(TagFromName.ExternalContourEntryPoint);
		tagList.add(TagFromName.CumulativeMetersetWeight);
		tagList.add(TagFromName.TableTopPitchAngle);
		tagList.add(TagFromName.TableTopPitchRotationDirection);
		tagList.add(TagFromName.TableTopRollAngle);
		tagList.add(TagFromName.TableTopRollRotationDirection);
		tagList.add(TagFromName.HeadFixationAngle);
		tagList.add(TagFromName.GantryPitchAngle);
		tagList.add(TagFromName.GantryPitchRotationDirection);
		tagList.add(TagFromName.GantryPitchAngleTolerance);
		tagList.add(TagFromName.PatientSetupSequence);
		tagList.add(TagFromName.PatientSetupNumber);
		tagList.add(TagFromName.PatientSetupLabel);
		tagList.add(TagFromName.PatientAdditionalPosition);
		tagList.add(TagFromName.FixationDeviceSequence);
		tagList.add(TagFromName.FixationDeviceType);
		tagList.add(TagFromName.FixationDeviceLabel);
		tagList.add(TagFromName.FixationDeviceDescription);
		tagList.add(TagFromName.FixationDevicePosition);
		tagList.add(TagFromName.FixationDevicePitchAngle);
		tagList.add(TagFromName.FixationDeviceRollAngle);
		tagList.add(TagFromName.ShieldingDeviceSequence);
		tagList.add(TagFromName.ShieldingDeviceType);
		tagList.add(TagFromName.ShieldingDeviceLabel);
		tagList.add(TagFromName.ShieldingDeviceDescription);
		tagList.add(TagFromName.ShieldingDevicePosition);
		tagList.add(TagFromName.SetupTechnique);
		tagList.add(TagFromName.SetupTechniqueDescription);
		tagList.add(TagFromName.SetupDeviceSequence);
		tagList.add(TagFromName.SetupDeviceType);
		tagList.add(TagFromName.SetupDeviceLabel);
		tagList.add(TagFromName.SetupDeviceDescription);
		tagList.add(TagFromName.SetupDeviceParameter);
		tagList.add(TagFromName.SetupReferenceDescription);
		tagList.add(TagFromName.TableTopVerticalSetupDisplacement);
		tagList.add(TagFromName.TableTopLongitudinalSetupDisplacement);
		tagList.add(TagFromName.TableTopLateralSetupDisplacement);
		tagList.add(TagFromName.BrachyTreatmentTechnique);
		tagList.add(TagFromName.BrachyTreatmentType);
		tagList.add(TagFromName.TreatmentMachineSequence);
		tagList.add(TagFromName.SourceSequence);
		tagList.add(TagFromName.SourceNumber);
		tagList.add(TagFromName.SourceType);
		tagList.add(TagFromName.SourceManufacturer);
		tagList.add(TagFromName.ActiveSourceDiameter);
		tagList.add(TagFromName.ActiveSourceLength);
		tagList.add(TagFromName.SourceModelID);
		tagList.add(TagFromName.SourceDescription);
		tagList.add(TagFromName.SourceEncapsulationNominalThickness);
		tagList.add(TagFromName.SourceEncapsulationNominalTransmission);
		tagList.add(TagFromName.SourceIsotopeName);
		tagList.add(TagFromName.SourceIsotopeHalfLife);
		tagList.add(TagFromName.SourceStrengthUnits);
		tagList.add(TagFromName.ReferenceAirKermaRate);
		tagList.add(TagFromName.SourceStrength);
		tagList.add(TagFromName.SourceStrengthReferenceDate);
		tagList.add(TagFromName.SourceStrengthReferenceTime);
		tagList.add(TagFromName.ApplicationSetupSequence);
		tagList.add(TagFromName.ApplicationSetupType);
		tagList.add(TagFromName.ApplicationSetupNumber);
		tagList.add(TagFromName.ApplicationSetupName);
		tagList.add(TagFromName.ApplicationSetupManufacturer);
		tagList.add(TagFromName.TemplateNumber);
		tagList.add(TagFromName.TemplateType);
		tagList.add(TagFromName.TemplateName);
		tagList.add(TagFromName.TotalReferenceAirKerma);
		tagList.add(TagFromName.BrachyAccessoryDeviceSequence);
		tagList.add(TagFromName.BrachyAccessoryDeviceNumber);
		tagList.add(TagFromName.BrachyAccessoryDeviceID);
		tagList.add(TagFromName.BrachyAccessoryDeviceType);
		tagList.add(TagFromName.BrachyAccessoryDeviceName);
		tagList.add(TagFromName.BrachyAccessoryDeviceNominalThickness);
		tagList.add(TagFromName.BrachyAccessoryDeviceNominalTransmission);
		tagList.add(TagFromName.ChannelSequence);
		tagList.add(TagFromName.ChannelNumber);
		tagList.add(TagFromName.ChannelLength);
		tagList.add(TagFromName.ChannelTotalTime);
		tagList.add(TagFromName.SourceMovementType);
		tagList.add(TagFromName.NumberOfPulses);
		tagList.add(TagFromName.PulseRepetitionInterval);
		tagList.add(TagFromName.SourceApplicatorNumber);
		tagList.add(TagFromName.SourceApplicatorID);
		tagList.add(TagFromName.SourceApplicatorType);
		tagList.add(TagFromName.SourceApplicatorName);
		tagList.add(TagFromName.SourceApplicatorLength);
		tagList.add(TagFromName.SourceApplicatorManufacturer);
		tagList.add(TagFromName.SourceApplicatorWallNominalThickness);
		tagList.add(TagFromName.SourceApplicatorWallNominalTransmission);
		tagList.add(TagFromName.SourceApplicatorStepSize);
		tagList.add(TagFromName.TransferTubeNumber);
		tagList.add(TagFromName.TransferTubeLength);
		tagList.add(TagFromName.ChannelShieldSequence);
		tagList.add(TagFromName.ChannelShieldNumber);
		tagList.add(TagFromName.ChannelShieldID);
		tagList.add(TagFromName.ChannelShieldName);
		tagList.add(TagFromName.ChannelShieldNominalThickness);
		tagList.add(TagFromName.ChannelShieldNominalTransmission);
		tagList.add(TagFromName.FinalCumulativeTimeWeight);
		tagList.add(TagFromName.BrachyControlPointSequence);
		tagList.add(TagFromName.ControlPointRelativePosition);
		tagList.add(TagFromName.ControlPoint3DPosition);
		tagList.add(TagFromName.CumulativeTimeWeight);
		tagList.add(TagFromName.CompensatorDivergence);
		tagList.add(TagFromName.CompensatorMountingPosition);
		tagList.add(TagFromName.SourceToCompensatorDistance);
		tagList.add(TagFromName.TotalCompensatorTrayWaterEquivalentThickness);
		tagList.add(TagFromName.IsocenterToCompensatorTrayDistance);
		tagList.add(TagFromName.CompensatorColumnOffset);
		tagList.add(TagFromName.IsocenterToCompensatorDistances);
		tagList.add(TagFromName.CompensatorRelativeStoppingPowerRatio);
		tagList.add(TagFromName.CompensatorMillingToolDiameter);
		tagList.add(TagFromName.IonRangeCompensatorSequence);
		tagList.add(TagFromName.CompensatorDescription);
		tagList.add(TagFromName.RadiationMassNumber);
		tagList.add(TagFromName.RadiationAtomicNumber);
		tagList.add(TagFromName.RadiationChargeState);
		tagList.add(TagFromName.ScanMode);
		tagList.add(TagFromName.ModulatedScanModeType);
		tagList.add(TagFromName.VirtualSourceAxisDistances);
		tagList.add(TagFromName.SnoutSequence);
		tagList.add(TagFromName.SnoutPosition);
		tagList.add(TagFromName.SnoutID);
		tagList.add(TagFromName.NumberOfRangeShifters);
		tagList.add(TagFromName.RangeShifterSequence);
		tagList.add(TagFromName.RangeShifterNumber);
		tagList.add(TagFromName.RangeShifterID);
		tagList.add(TagFromName.RangeShifterType);
		tagList.add(TagFromName.RangeShifterDescription);
		tagList.add(TagFromName.NumberOfLateralSpreadingDevices);
		tagList.add(TagFromName.LateralSpreadingDeviceSequence);
		tagList.add(TagFromName.LateralSpreadingDeviceNumber);
		tagList.add(TagFromName.LateralSpreadingDeviceID);
		tagList.add(TagFromName.LateralSpreadingDeviceType);
		tagList.add(TagFromName.LateralSpreadingDeviceDescription);
		tagList.add(TagFromName.LateralSpreadingDeviceWaterEquivalentThickness);
		tagList.add(TagFromName.NumberOfRangeModulators);
		tagList.add(TagFromName.RangeModulatorSequence);
		tagList.add(TagFromName.RangeModulatorNumber);
		tagList.add(TagFromName.RangeModulatorID);
		tagList.add(TagFromName.RangeModulatorType);
		tagList.add(TagFromName.RangeModulatorDescription);
		tagList.add(TagFromName.BeamCurrentModulationID);
		tagList.add(TagFromName.PatientSupportType);
		tagList.add(TagFromName.PatientSupportID);
		tagList.add(TagFromName.PatientSupportAccessoryCode);
		tagList.add(TagFromName.FixationLightAzimuthalAngle);
		tagList.add(TagFromName.FixationLightPolarAngle);
		tagList.add(TagFromName.MetersetRate);
		tagList.add(TagFromName.RangeShifterSettingsSequence);
		tagList.add(TagFromName.RangeShifterSetting);
		tagList.add(TagFromName.IsocenterToRangeShifterDistance);
		tagList.add(TagFromName.RangeShifterWaterEquivalentThickness);
		tagList.add(TagFromName.LateralSpreadingDeviceSettingsSequence);
		tagList.add(TagFromName.LateralSpreadingDeviceSetting);
		tagList.add(TagFromName.IsocenterToLateralSpreadingDeviceDistance);
		tagList.add(TagFromName.RangeModulatorSettingsSequence);
		tagList.add(TagFromName.RangeModulatorGatingStartValue);
		tagList.add(TagFromName.RangeModulatorGatingStopValue);
		tagList.add(TagFromName.RangeModulatorGatingStartWaterEquivalentThickness);
		tagList.add(TagFromName.RangeModulatorGatingStopWaterEquivalentThickness);
		tagList.add(TagFromName.IsocenterToRangeModulatorDistance);
		tagList.add(TagFromName.ScanSpotTuneID);
		tagList.add(TagFromName.NumberOfScanSpotPositions);
		tagList.add(TagFromName.ScanSpotPositionMap);
		tagList.add(TagFromName.ScanSpotMetersetWeights);
		tagList.add(TagFromName.ScanningSpotSize);
		tagList.add(TagFromName.NumberOfPaintings);
		tagList.add(TagFromName.IonToleranceTableSequence);
		tagList.add(TagFromName.IonBeamSequence);
		tagList.add(TagFromName.IonBeamLimitingDeviceSequence);
		tagList.add(TagFromName.IonBlockSequence);
		tagList.add(TagFromName.IonControlPointSequence);
		tagList.add(TagFromName.IonWedgeSequence);
		tagList.add(TagFromName.IonWedgePositionSequence);
		tagList.add(TagFromName.ReferencedSetupImageSequence);
		tagList.add(TagFromName.SetupImageComment);
		tagList.add(TagFromName.MotionSynchronizationSequence);
		tagList.add(TagFromName.ControlPointOrientation);
		tagList.add(TagFromName.GeneralAccessorySequence);
		tagList.add(TagFromName.GeneralAccessoryID);
		tagList.add(TagFromName.GeneralAccessoryDescription);
		tagList.add(TagFromName.GeneralAccessoryType);
		tagList.add(TagFromName.GeneralAccessoryNumber);
		tagList.add(TagFromName.SourceToGeneralAccessoryDistance);
		tagList.add(TagFromName.ApplicatorGeometrySequence);
		tagList.add(TagFromName.ApplicatorApertureShape);
		tagList.add(TagFromName.ApplicatorOpening);
		tagList.add(TagFromName.ApplicatorOpeningX);
		tagList.add(TagFromName.ApplicatorOpeningY);
		tagList.add(TagFromName.SourceToApplicatorMountingPositionDistance);
		tagList.add(TagFromName.NumberOfBlockSlabItems);
		tagList.add(TagFromName.BlockSlabSequence);
		tagList.add(TagFromName.BlockSlabThickness);
		tagList.add(TagFromName.BlockSlabNumber);
		tagList.add(TagFromName.DeviceMotionControlSequence);
		tagList.add(TagFromName.DeviceMotionExecutionMode);
		tagList.add(TagFromName.DeviceMotionObservationMode);
		tagList.add(TagFromName.DeviceMotionParameterCodeSequence);
		tagList.add(TagFromName.ReferencedRTPlanSequence);
		tagList.add(TagFromName.ReferencedBeamSequence);
		tagList.add(TagFromName.ReferencedBeamNumber);
		tagList.add(TagFromName.ReferencedReferenceImageNumber);
		tagList.add(TagFromName.StartCumulativeMetersetWeight);
		tagList.add(TagFromName.EndCumulativeMetersetWeight);
		tagList.add(TagFromName.ReferencedBrachyApplicationSetupSequence);
		tagList.add(TagFromName.ReferencedBrachyApplicationSetupNumber);
		tagList.add(TagFromName.ReferencedSourceNumber);
		tagList.add(TagFromName.ReferencedFractionGroupSequence);
		tagList.add(TagFromName.ReferencedFractionGroupNumber);
		tagList.add(TagFromName.ReferencedVerificationImageSequence);
		tagList.add(TagFromName.ReferencedReferenceImageSequence);
		tagList.add(TagFromName.ReferencedDoseReferenceSequence);
		tagList.add(TagFromName.ReferencedDoseReferenceNumber);
		tagList.add(TagFromName.BrachyReferencedDoseReferenceSequence);
		tagList.add(TagFromName.ReferencedStructureSetSequence);
		tagList.add(TagFromName.ReferencedPatientSetupNumber);
		tagList.add(TagFromName.ReferencedDoseSequence);
		tagList.add(TagFromName.ReferencedToleranceTableNumber);
		tagList.add(TagFromName.ReferencedBolusSequence);
		tagList.add(TagFromName.ReferencedWedgeNumber);
		tagList.add(TagFromName.ReferencedCompensatorNumber);
		tagList.add(TagFromName.ReferencedBlockNumber);
		tagList.add(TagFromName.ReferencedControlPointIndex);
		tagList.add(TagFromName.ReferencedControlPointSequence);
		tagList.add(TagFromName.ReferencedStartControlPointIndex);
		tagList.add(TagFromName.ReferencedStopControlPointIndex);
		tagList.add(TagFromName.ReferencedRangeShifterNumber);
		tagList.add(TagFromName.ReferencedLateralSpreadingDeviceNumber);
		tagList.add(TagFromName.ReferencedRangeModulatorNumber);
		tagList.add(TagFromName.OmittedBeamTaskSequence);
		tagList.add(TagFromName.ReasonForOmission);
		tagList.add(TagFromName.ReasonForOmissionDescription);
		tagList.add(TagFromName.ApprovalStatus);
		tagList.add(TagFromName.ReviewDate);
		tagList.add(TagFromName.ReviewTime);
		tagList.add(TagFromName.ReviewerName);
		tagList.add(TagFromName.Arbitrary);
		tagList.add(TagFromName.TextComments);
		tagList.add(TagFromName.ResultsID);
		tagList.add(TagFromName.ResultsIDIssuer);
		tagList.add(TagFromName.ReferencedInterpretationSequence);
		tagList.add(TagFromName.ReportProductionStatusTrial);
		tagList.add(TagFromName.InterpretationRecordedDate);
		tagList.add(TagFromName.InterpretationRecordedTime);
		tagList.add(TagFromName.InterpretationRecorder);
		tagList.add(TagFromName.ReferenceToRecordedSound);
		tagList.add(TagFromName.InterpretationTranscriptionDate);
		tagList.add(TagFromName.InterpretationTranscriptionTime);
		tagList.add(TagFromName.InterpretationTranscriber);
		tagList.add(TagFromName.InterpretationText);
		tagList.add(TagFromName.InterpretationAuthor);
		tagList.add(TagFromName.InterpretationApproverSequence);
		tagList.add(TagFromName.InterpretationApprovalDate);
		tagList.add(TagFromName.InterpretationApprovalTime);
		tagList.add(TagFromName.PhysicianApprovingInterpretation);
		tagList.add(TagFromName.InterpretationDiagnosisDescription);
		tagList.add(TagFromName.InterpretationDiagnosisCodeSequence);
		tagList.add(TagFromName.ResultsDistributionListSequence);
		tagList.add(TagFromName.DistributionName);
		tagList.add(TagFromName.DistributionAddress);
		tagList.add(TagFromName.InterpretationID);
		tagList.add(TagFromName.InterpretationIDIssuer);
		tagList.add(TagFromName.InterpretationTypeID);
		tagList.add(TagFromName.InterpretationStatusID);
		tagList.add(TagFromName.Impressions);
		tagList.add(TagFromName.ResultsComments);
		tagList.add(TagFromName.LowEnergyDetectors);
		tagList.add(TagFromName.HighEnergyDetectors);
		tagList.add(TagFromName.DetectorGeometrySequence);
		tagList.add(TagFromName.ThreatROIVoxelSequence);
		tagList.add(TagFromName.ThreatROIBase);
		tagList.add(TagFromName.ThreatROIExtents);
		tagList.add(TagFromName.ThreatROIBitmap);
		tagList.add(TagFromName.RouteSegmentID);
		tagList.add(TagFromName.GantryType);
		tagList.add(TagFromName.OOIOwnerType);
		tagList.add(TagFromName.RouteSegmentSequence);
		tagList.add(TagFromName.PotentialThreatObjectID);
		tagList.add(TagFromName.ThreatSequence);
		tagList.add(TagFromName.ThreatCategory);
		tagList.add(TagFromName.ThreatCategoryDescription);
		tagList.add(TagFromName.ATDAbilityAssessment);
		tagList.add(TagFromName.ATDAssessmentFlag);
		tagList.add(TagFromName.ATDAssessmentProbability);
		tagList.add(TagFromName.Mass);
		tagList.add(TagFromName.Density);
		tagList.add(TagFromName.ZEffective);
		tagList.add(TagFromName.BoardingPassID);
		tagList.add(TagFromName.CenterOfMass);
		tagList.add(TagFromName.CenterOfPTO);
		tagList.add(TagFromName.BoundingPolygon);
		tagList.add(TagFromName.RouteSegmentStartLocationID);
		tagList.add(TagFromName.RouteSegmentEndLocationID);
		tagList.add(TagFromName.RouteSegmentLocationIDType);
		tagList.add(TagFromName.AbortReason);
		tagList.add(TagFromName.VolumeOfPTO);
		tagList.add(TagFromName.AbortFlag);
		tagList.add(TagFromName.RouteSegmentStartTime);
		tagList.add(TagFromName.RouteSegmentEndTime);
		tagList.add(TagFromName.TDRType);
		tagList.add(TagFromName.InternationalRouteSegment);
		tagList.add(TagFromName.ThreatDetectionAlgorithmAndVersion);
		tagList.add(TagFromName.AssignedLocation);
		tagList.add(TagFromName.AlarmDecisionTime);
		tagList.add(TagFromName.AlarmDecision);
		tagList.add(TagFromName.NumberOfTotalObjects);
		tagList.add(TagFromName.NumberOfAlarmObjects);
		tagList.add(TagFromName.PTORepresentationSequence);
		tagList.add(TagFromName.ATDAssessmentSequence);
		tagList.add(TagFromName.TIPType);
		tagList.add(TagFromName.DICOSVersion);
		tagList.add(TagFromName.OOIOwnerCreationTime);
		tagList.add(TagFromName.OOIType);
		tagList.add(TagFromName.OOISize);
		tagList.add(TagFromName.AcquisitionStatus);
		tagList.add(TagFromName.BasisMaterialsCodeSequence);
		tagList.add(TagFromName.PhantomType);
		tagList.add(TagFromName.OOIOwnerSequence);
		tagList.add(TagFromName.ScanType);
		tagList.add(TagFromName.ItineraryID);
		tagList.add(TagFromName.ItineraryIDType);
		tagList.add(TagFromName.ItineraryIDAssigningAuthority);
		tagList.add(TagFromName.RouteID);
		tagList.add(TagFromName.RouteIDAssigningAuthority);
		tagList.add(TagFromName.InboundArrivalType);
		tagList.add(TagFromName.CarrierID);
		tagList.add(TagFromName.CarrierIDAssigningAuthority);
		tagList.add(TagFromName.SourceOrientation);
		tagList.add(TagFromName.SourcePosition);
		tagList.add(TagFromName.BeltHeight);
		tagList.add(TagFromName.AlgorithmRoutingCodeSequence);
		tagList.add(TagFromName.TransportClassification);
		tagList.add(TagFromName.OOITypeDescriptor);
		tagList.add(TagFromName.TotalProcessingTime);
		tagList.add(TagFromName.DetectorCalibrationData);
		tagList.add(TagFromName.AdditionalScreeningPerformed);
		tagList.add(TagFromName.AdditionalInspectionSelectionCriteria);
		tagList.add(TagFromName.AdditionalInspectionMethodSequence);
		tagList.add(TagFromName.AITDeviceType);
		tagList.add(TagFromName.QRMeasurementsSequence);
		tagList.add(TagFromName.TargetMaterialSequence);
		tagList.add(TagFromName.SNRThreshold);
		tagList.add(TagFromName.ImageScaleRepresentation);
		tagList.add(TagFromName.ReferencedPTOSequence);
		tagList.add(TagFromName.ReferencedTDRInstanceSequence);
		tagList.add(TagFromName.PTOLocationDescription);
		tagList.add(TagFromName.AnomalyLocatorIndicatorSequence);
		tagList.add(TagFromName.AnomalyLocatorIndicator);
		tagList.add(TagFromName.PTORegionSequence);
		tagList.add(TagFromName.InspectionSelectionCriteria);
		tagList.add(TagFromName.SecondaryInspectionMethodSequence);
		tagList.add(TagFromName.PRCSToRCSOrientation);
		tagList.add(TagFromName.MACParametersSequence);
		tagList.add(TagFromName.CurveDimensions);
		tagList.add(TagFromName.NumberOfPoints);
		tagList.add(TagFromName.TypeOfData);
		tagList.add(TagFromName.CurveDescription);
		tagList.add(TagFromName.AxisUnits);
		tagList.add(TagFromName.AxisLabels);
		tagList.add(TagFromName.DataValueRepresentation);
		tagList.add(TagFromName.MinimumCoordinateValue);
		tagList.add(TagFromName.MaximumCoordinateValue);
		tagList.add(TagFromName.CurveRange);
		tagList.add(TagFromName.CurveDataDescriptor);
		tagList.add(TagFromName.CoordinateStartValue);
		tagList.add(TagFromName.CoordinateStepValue);
		tagList.add(TagFromName.CurveActivationLayer);
		tagList.add(TagFromName.AudioType);
		tagList.add(TagFromName.AudioSampleFormat);
		tagList.add(TagFromName.NumberOfChannels);
		tagList.add(TagFromName.NumberOfSamples);
		tagList.add(TagFromName.SampleRate);
		tagList.add(TagFromName.TotalTime);
		tagList.add(TagFromName.AudioSampleData);
		tagList.add(TagFromName.AudioComments);
		tagList.add(TagFromName.CurveLabel);
		tagList.add(TagFromName.CurveReferencedOverlaySequence);
		tagList.add(TagFromName.CurveReferencedOverlayGroup);
		tagList.add(TagFromName.CurveData);
		tagList.add(TagFromName.SharedFunctionalGroupsSequence);
		tagList.add(TagFromName.PerFrameFunctionalGroupsSequence);
		tagList.add(TagFromName.WaveformSequence);
		tagList.add(TagFromName.ChannelMinimumValue);
		tagList.add(TagFromName.ChannelMaximumValue);
		tagList.add(TagFromName.WaveformBitsAllocated);
		tagList.add(TagFromName.WaveformSampleInterpretation);
		tagList.add(TagFromName.WaveformPaddingValue);
		tagList.add(TagFromName.WaveformData);
		tagList.add(TagFromName.FirstOrderPhaseCorrectionAngle);
		tagList.add(TagFromName.SpectroscopyData);
		tagList.add(TagFromName.OverlayRows);
		tagList.add(TagFromName.OverlayColumns);
		tagList.add(TagFromName.OverlayPlanes);
		tagList.add(TagFromName.NumberOfFramesInOverlay);
		tagList.add(TagFromName.OverlayDescription);
		tagList.add(TagFromName.OverlayType);
		tagList.add(TagFromName.OverlaySubtype);
		tagList.add(TagFromName.OverlayOrigin);
		tagList.add(TagFromName.ImageFrameOrigin);
		tagList.add(TagFromName.OverlayPlaneOrigin);
		tagList.add(TagFromName.OverlayCompressionCode);
		tagList.add(TagFromName.OverlayCompressionOriginator);
		tagList.add(TagFromName.OverlayCompressionLabel);
		tagList.add(TagFromName.OverlayCompressionDescription);
		tagList.add(TagFromName.OverlayCompressionStepPointers);
		tagList.add(TagFromName.OverlayRepeatInterval);
		tagList.add(TagFromName.OverlayBitsGrouped);
		tagList.add(TagFromName.OverlayBitsAllocated);
		tagList.add(TagFromName.OverlayBitPosition);
		tagList.add(TagFromName.OverlayFormat);
		tagList.add(TagFromName.OverlayLocation);
		tagList.add(TagFromName.OverlayCodeLabel);
		tagList.add(TagFromName.OverlayNumberOfTables);
		tagList.add(TagFromName.OverlayCodeTableLocation);
		tagList.add(TagFromName.OverlayBitsForCodeWord);
		tagList.add(TagFromName.OverlayActivationLayer);
		tagList.add(TagFromName.OverlayDescriptorGray);
		tagList.add(TagFromName.OverlayDescriptorRed);
		tagList.add(TagFromName.OverlayDescriptorGreen);
		tagList.add(TagFromName.OverlayDescriptorBlue);
		tagList.add(TagFromName.OverlayGray);
		tagList.add(TagFromName.OverlayRed);
		tagList.add(TagFromName.OverlayGreen);
		tagList.add(TagFromName.OverlayBlue);
		tagList.add(TagFromName.ROIArea);
		tagList.add(TagFromName.ROIMean);
		tagList.add(TagFromName.ROIStandardDeviation);
		tagList.add(TagFromName.OverlayLabel);
		tagList.add(TagFromName.OverlayData);
		tagList.add(TagFromName.OverlayComments);
		tagList.add(TagFromName.FloatPixelData);
		tagList.add(TagFromName.DoubleFloatPixelData);
		tagList.add(TagFromName.PixelData);
		tagList.add(TagFromName.CoefficientsSDVN);
		tagList.add(TagFromName.CoefficientsSDHN);
		tagList.add(TagFromName.CoefficientsSDDN);
		tagList.add(TagFromName.VariablePixelData);
		tagList.add(TagFromName.VariableNextDataGroup);
		tagList.add(TagFromName.VariableCoefficientsSDVN);
		tagList.add(TagFromName.VariableCoefficientsSDHN);
		tagList.add(TagFromName.VariableCoefficientsSDDN);
		tagList.add(TagFromName.DigitalSignaturesSequence);
		tagList.add(TagFromName.DataSetTrailingPadding);
	}

	protected void createValueRepresentationsByTag() {

		valueRepresentationsByTag = new HashMap(100);

		valueRepresentationsByTag.put(TagFromName.CommandGroupLength,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.CommandLengthToEnd,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.AffectedSOPClassUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.RequestedSOPClassUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.CommandRecognitionCode,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CommandField,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MessageID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MessageIDBeingRespondedTo,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Initiator,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.Receiver,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.FindLocation,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.MoveDestination,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.Priority,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CommandDataSetType,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfMatches,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ResponseSequenceNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Status,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OffendingElement,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.ErrorComment,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ErrorID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.AffectedSOPInstanceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.RequestedSOPInstanceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.EventTypeID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.AttributeIdentifierList,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.ActionTypeID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfRemainingSuboperations,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfCompletedSuboperations,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfFailedSuboperations,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfWarningSuboperations,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MoveOriginatorApplicationEntityTitle,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.MoveOriginatorMessageID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DialogReceiver,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.TerminalType,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.MessageSetID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.EndMessageID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.DisplayFormat,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.PagePositionID,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.TextFormatID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NormalReverse,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AddGrayScale,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Borders,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Copies,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CommandMagnificationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Erase,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Print,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Overlays,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.FileMetaInformationGroupLength,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.FileMetaInformationVersion,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.MediaStorageSOPClassUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.MediaStorageSOPInstanceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.TransferSyntaxUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ImplementationClassUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ImplementationVersionName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SourceApplicationEntityTitle,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.SendingApplicationEntityTitle,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.ReceivingApplicationEntityTitle,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.PrivateInformationCreatorUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.PrivateInformation,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.FileSetID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FileSetDescriptorFileID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpecificCharacterSetOfFileSetDescriptorFile,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.FileSetConsistencyFlag,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DirectoryRecordSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OffsetOfTheNextDirectoryRecord,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.RecordInUseFlag,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OffsetOfReferencedLowerLevelDirectoryEntity,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.DirectoryRecordType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PrivateRecordUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedFileID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MRDRDirectoryRecordOffset,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.ReferencedSOPClassUIDInFile,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedSOPInstanceUIDInFile,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedTransferSyntaxUIDInFile,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedRelatedGeneralSOPClassUIDInFile,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.NumberOfReferences,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.LengthToEnd,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SpecificCharacterSet,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LanguageCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RecognitionCode,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.InstanceCreationDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.InstanceCreationTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.InstanceCreatorUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.InstanceCoercionDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.SOPClassUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.SOPInstanceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.RelatedGeneralSOPClassUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.OriginalSpecializedSOPClassUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.StudyDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.SeriesDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.AcquisitionDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ContentDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.OverlayDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.CurveDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.AcquisitionDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.StudyTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.SeriesTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.AcquisitionTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ContentTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.OverlayTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.CurveTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.DataSetType,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DataSetSubtype,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.NuclearMedicineSeriesType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AccessionNumber,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.IssuerOfAccessionNumberSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.QueryRetrieveLevel,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.QueryRetrieveView,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RetrieveAETitle,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.InstanceAvailability,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FailedSOPInstanceUIDList,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.Modality,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ModalitiesInStudy,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SOPClassesInStudy,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ConversionType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PresentationIntentType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Manufacturer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.InstitutionName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.InstitutionAddress,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.InstitutionCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferringPhysicianName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.ReferringPhysicianAddress,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ReferringPhysicianTelephoneNumbers,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ReferringPhysicianIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ConsultingPhysicianName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.ConsultingPhysicianIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CodeValue,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ExtendedCodeValue,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CodingSchemeDesignator,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CodingSchemeVersion,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CodeMeaning,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MappingResource,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContextGroupVersion,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ContextGroupLocalVersion,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ExtendedCodeMeaning,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ContextGroupExtensionFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CodingSchemeUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ContextGroupExtensionCreatorUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ContextIdentifier,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CodingSchemeIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CodingSchemeRegistry,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CodingSchemeExternalID,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.CodingSchemeName,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.CodingSchemeResponsibleOrganization,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ContextUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.MappingResourceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.LongCodeValue,ValueRepresentation.UC);
		valueRepresentationsByTag.put(TagFromName.URNCodeValue,ValueRepresentation.UR);
		valueRepresentationsByTag.put(TagFromName.EquivalentCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TimezoneOffsetFromUTC,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PrivateDataElementCharacteristicsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrivateGroupReference,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PrivateCreatorReference,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.BlockIdentifyingInformationStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NonidentifyingPrivateElements,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DeidentificationActionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IdentifyingPrivateElements,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DeidentificationAction,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NetworkID,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.StationName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.StudyDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ProcedureCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SeriesDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SeriesDescriptionCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.InstitutionalDepartmentName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PhysiciansOfRecord,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.PhysiciansOfRecordIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformingPhysicianName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.PerformingPhysicianIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NameOfPhysiciansReadingStudy,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.PhysiciansReadingStudyIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OperatorsName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.OperatorIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AdmittingDiagnosesDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AdmittingDiagnosesCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ManufacturerModelName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReferencedResultsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedStudySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedPerformedProcedureStepSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedSeriesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedPatientSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedVisitSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedOverlaySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedStereometricInstanceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedWaveformSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedCurveSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedInstanceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedRealWorldValueMappingInstanceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedSOPClassUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedSOPInstanceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.SOPClassesSupported,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedFrameNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.SimpleFrameList,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.CalculatedFrameList,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TimeRange,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.FrameExtractionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MultiFrameSourceSOPInstanceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.RetrieveURL,ValueRepresentation.UR);
		valueRepresentationsByTag.put(TagFromName.TransactionUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.WarningReason,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.FailureReason,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.FailedSOPSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedSOPSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OtherFailuresSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StudiesContainingOtherReferencedInstancesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RelatedSeriesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LossyImageCompressionRetired,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DerivationDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.SourceImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StageName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.StageNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfStages,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ViewName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ViewNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfEventTimers,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfViewsInStage,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.EventElapsedTimes,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EventTimerNames,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.EventTimerSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.EventTimeOffset,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.EventCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StartTrim,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.StopTrim,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RecommendedDisplayFrameRate,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TransducerPosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TransducerOrientation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AnatomicStructure,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AnatomicRegionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnatomicRegionModifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrimaryAnatomicStructureSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnatomicStructureSpaceOrRegionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrimaryAnatomicStructureModifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransducerPositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransducerPositionModifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransducerOrientationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransducerOrientationModifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnatomicStructureSpaceOrRegionCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnatomicPortalOfEntranceCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnatomicApproachDirectionCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnatomicPerspectiveDescriptionTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.AnatomicPerspectiveCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnatomicLocationOfExaminingInstrumentDescriptionTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.AnatomicLocationOfExaminingInstrumentCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OnAxisBackgroundAnatomicStructureCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AlternateRepresentationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IrradiationEventUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.SourceIrradiationEventSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalAdministrationEventUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.IdentifyingComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.FrameType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReferencedImageEvidenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedRawDataSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CreatorVersionUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.DerivationImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SourceImageEvidenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PixelPresentation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VolumetricProperties,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VolumeBasedCalculationTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ComplexImageComponent,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionContrast,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DerivationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedPresentationStateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedOtherPlaneSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FrameDisplaySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecommendedDisplayFrameRateInFloat,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SkipFrameRangeFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatientName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.PatientID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IssuerOfPatientID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TypeOfPatientID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IssuerOfPatientIDQualifiersSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SourcePatientGroupIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GroupOfPatientsIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SubjectRelativePositionInImage,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PatientBirthDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.PatientBirthTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.PatientSex,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatientInsurancePlanCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientPrimaryLanguageCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientPrimaryLanguageModifierCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.QualityControlSubject,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.QualityControlSubjectTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StrainDescription,ValueRepresentation.UC);
		valueRepresentationsByTag.put(TagFromName.StrainNomenclature,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.StrainStockNumber,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.StrainSourceRegistryCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StrainStockSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StrainSource,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.StrainAdditionalInformation,ValueRepresentation.UT);
		valueRepresentationsByTag.put(TagFromName.StrainCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OtherPatientIDs,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.OtherPatientNames,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.OtherPatientIDsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientBirthName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.PatientAge,ValueRepresentation.AS);
		valueRepresentationsByTag.put(TagFromName.PatientSize,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PatientSizeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PatientAddress,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.InsurancePlanIdentification,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientMotherBirthName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.MilitaryRank,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.BranchOfService,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MedicalRecordLocator,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReferencedPatientPhotoSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MedicalAlerts,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.Allergies,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CountryOfResidence,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RegionOfResidence,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientTelephoneNumbers,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PatientTelecomInformation,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.EthnicGroup,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.Occupation,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SmokingStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AdditionalPatientHistory,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.PregnancyStatus,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.LastMenstrualDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.PatientReligiousPreference,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientSpeciesDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientSpeciesCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientSexNeutered,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AnatomicalOrientationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatientBreedDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientBreedCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BreedRegistrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BreedRegistrationNumber,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.BreedRegistryCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ResponsiblePerson,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.ResponsiblePersonRole,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ResponsibleOrganization,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ExaminedBodyThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialSponsorName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialProtocolID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialProtocolName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialSiteID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialSiteName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialSubjectID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialSubjectReadingID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialTimePointID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialTimePointDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialCoordinatingCenterName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientIdentityRemoved,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DeidentificationMethod,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DeidentificationMethodCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialSeriesID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialSeriesDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialProtocolEthicsCommitteeName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ClinicalTrialProtocolEthicsCommitteeApprovalNumber,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ConsentForClinicalTrialUseSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DistributionType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ConsentForDistributionFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CADFileFormatRetired,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ComponentReferenceSystemRetired,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ComponentManufacturingProcedure,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ComponentManufacturer,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.MaterialThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MaterialPipeDiameter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MaterialIsolationDiameter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MaterialGrade,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.MaterialPropertiesDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.MaterialPropertiesFileFormatRetired,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.MaterialNotes,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ComponentShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CurvatureType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OuterDiameter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.InnerDiameter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ComponentWelderIDs,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SecondaryApprovalStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SecondaryReviewDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.SecondaryReviewTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.SecondaryReviewerName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.RepairID,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.MultipleComponentApprovalSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OtherApprovalStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OtherSecondaryApprovalStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ActualEnvironmentalConditions,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ExpiryDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.EnvironmentalConditions,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.EvaluatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.EvaluatorNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.EvaluatorName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.EvaluationAttempt,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.IndicationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IndicationNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.IndicationLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.IndicationDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.IndicationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IndicationDisposition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IndicationROISequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IndicationPhysicalPropertySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PropertyLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CoordinateSystemNumberOfAxes,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CoordinateSystemAxesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CoordinateSystemAxisDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.CoordinateSystemDataSetMapping,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CoordinateSystemAxisNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CoordinateSystemAxisType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CoordinateSystemAxisUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CoordinateSystemAxisValues,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.CoordinateSystemTransformSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransformDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.TransformNumberOfAxes,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TransformOrderOfAxes,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TransformedAxisUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CoordinateSystemTransformRotationAndScaleMatrix,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CoordinateSystemTransformTranslationMatrix,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.InternalDetectorFrameTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NumberOfFramesIntegrated,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorTemperatureSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SensorName,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.HorizontalOffsetOfSensor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.VerticalOffsetOfSensor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SensorTemperature,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DarkCurrentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DarkCurrentCounts,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.GainCorrectionReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AirCounts,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.KVUsedInGainCalibration,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MAUsedInGainCalibration,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NumberOfFramesUsedForIntegration,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FilterMaterialUsedInGainCalibration,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.FilterThicknessUsedInGainCalibration,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DateOfGainCalibration,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.TimeOfGainCalibration,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.BadPixelImage,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.CalibrationNotes,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.PulserEquipmentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PulserType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PulserNotes,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ReceiverEquipmentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AmplifierType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReceiverNotes,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.PreAmplifierEquipmentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PreAmplifierNotes,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.TransmitTransducerSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReceiveTransducerSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumberOfElements,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ElementShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ElementDimensionA,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ElementDimensionB,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ElementPitchA,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MeasuredBeamDimensionA,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MeasuredBeamDimensionB,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.LocationOfMeasuredBeamDiameter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NominalFrequency,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MeasuredCenterFrequency,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MeasuredBandwidth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ElementPitchB,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PulserSettingsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PulseWidth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ExcitationFrequency,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ModulationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Damping,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ReceiverSettingsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AcquiredSoundpathLength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionCompressionType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionSampleSize,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RectifierSmoothing,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DACSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DACType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DACGainPoints,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DACTimePoints,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DACAmplitude,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PreAmplifierSettingsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransmitTransducerSettingsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReceiveTransducerSettingsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IncidentAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CouplingTechnique,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.CouplingMedium,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.CouplingVelocity,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ProbeCenterLocationX,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ProbeCenterLocationZ,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SoundPathLength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DelayLawIdentifier,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.GateSettingsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GateThreshold,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.VelocityOfSound,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CalibrationSettingsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CalibrationProcedure,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ProcedureVersion,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ProcedureCreationDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ProcedureExpirationDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ProcedureLastModifiedDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.CalibrationTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.CalibrationDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ProbeDriveEquipmentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DriveType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ProbeDriveNotes,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.DriveProbeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ProbeInductance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ProbeResistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ReceiveProbeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ProbeDriveSettingsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BridgeResistors,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ProbeOrientationAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.UserSelectedGainY,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.UserSelectedPhase,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.UserSelectedOffsetX,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.UserSelectedOffsetY,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelSettingsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelThreshold,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ScannerSettingsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScanProcedure,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.TranslationRateX,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TranslationRateY,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelOverlap,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImageQualityIndicatorType,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ImageQualityIndicatorMaterial,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ImageQualityIndicatorSize,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.LINACEnergy,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.LINACOutput,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ActiveAperture,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TotalAperture,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ApertureElevation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MainLobeAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MainRoofAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ConnectorType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.WedgeModelNumber,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.WedgeAngleFloat,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeRoofAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeElement1Position,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.WedgeMaterialVelocity,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeMaterial,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.WedgeOffsetZ,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeOriginOffsetX,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeTimeDelay,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.WedgeManufacturerName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.WedgeDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.NominalBeamAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeOffsetX,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeOffsetY,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeTotalLength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeInContactLength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeFrontGap,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeTotalHeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeFrontHeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeRearHeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeTotalWidth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeInContactWidth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeChamferHeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeCurve,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RadiusAlongWedge,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusAgent,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusAgentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusT1Relaxivity,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusAdministrationRouteSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BodyPartExamined,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScanningSequence,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SequenceVariant,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScanOptions,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MRAcquisitionType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SequenceName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.AngioFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InterventionDrugInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.InterventionDrugStopTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.InterventionDrugDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.InterventionDrugCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AdditionalDrugSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.Radionuclide,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.Radiopharmaceutical,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowCenterline,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowTotalWidth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.InterventionDrugName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.InterventionDrugStartTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.InterventionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TherapyType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InterventionStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TherapyDescription,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InterventionDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.CineRate,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.InitialCineRunState,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SliceThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.KVP,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CountsAccumulated,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionTerminationCondition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.EffectiveDuration,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionStartCondition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionStartConditionData,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionTerminationConditionData,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RepetitionTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EchoTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.InversionTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NumberOfAverages,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImagingFrequency,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImagedNucleus,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.EchoNumbers,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.MagneticFieldStrength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SpacingBetweenSlices,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NumberOfPhaseEncodingSteps,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.DataCollectionDiameter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EchoTrainLength,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PercentSampling,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PercentPhaseFieldOfView,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PixelBandwidth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeviceSerialNumber,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DeviceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.DeviceID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PlateID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.GeneratorID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.GridID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CassetteID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.GantryID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SecondaryCaptureDeviceID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.HardcopyCreationDeviceID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DateOfSecondaryCapture,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.TimeOfSecondaryCapture,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.SecondaryCaptureDeviceManufacturer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.HardcopyDeviceManufacturer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SecondaryCaptureDeviceManufacturerModelName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SecondaryCaptureDeviceSoftwareVersions,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.HardcopyDeviceSoftwareVersion,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.HardcopyDeviceManufacturerModelName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SoftwareVersions,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.VideoImageFormatAcquired,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.DigitalImageFormatAcquired,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ProtocolName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusRoute,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusVolume,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusStartTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusStopTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusTotalDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SyringeCounts,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ContrastFlowRate,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ContrastFlowDuration,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusIngredient,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusIngredientConcentration,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SpatialResolution,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TriggerTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TriggerSourceOrType,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.NominalInterval,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.FrameTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CardiacFramingType,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.FrameTimeVector,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FrameDelay,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImageTriggerDelay,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MultiplexGroupTimeOffset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TriggerTimeOffset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SynchronizationTrigger,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SynchronizationChannel,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TriggerSamplePosition,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalRoute,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalVolume,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalStartTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalStopTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.RadionuclideTotalDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadionuclideHalfLife,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadionuclidePositronFraction,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalSpecificActivity,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalStartDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalStopDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.BeatRejectionFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LowRRValue,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.HighRRValue,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.IntervalsAcquired,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.IntervalsRejected,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PVCRejection,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SkipBeats,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.HeartRate,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CardiacNumberOfImages,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TriggerWindow,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReconstructionDiameter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DistanceSourceToDetector,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DistanceSourceToPatient,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EstimatedRadiographicMagnificationFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.GantryDetectorTilt,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.GantryDetectorSlew,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableHeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTraverse,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableMotion,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TableVerticalIncrement,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableLateralIncrement,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableLongitudinalIncrement,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RotationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AngularPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadialPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ScanArc,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.AngularStep,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CenterOfRotationOffset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RotationOffset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FieldOfViewShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FieldOfViewDimensions,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ExposureTime,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.XRayTubeCurrent,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.Exposure,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ExposureInuAs,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AveragePulseWidth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadiationSetting,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RectificationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RadiationMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageAndFluoroscopyAreaDoseProduct,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FilterType,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.TypeOfFilters,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IntensifierSize,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImagerPixelSpacing,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.Grid,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GeneratorPower,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CollimatorGridName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CollimatorType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FocalDistance,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.XFocusCenter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.YFocusCenter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FocalSpots,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.AnodeTargetMaterial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BodyPartThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CompressionForce,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PaddleDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DateOfLastCalibration,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.TimeOfLastCalibration,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.DateTimeOfLastCalibration,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ConvolutionKernel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.UpperLowerPixelValues,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ActualFrameDuration,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CountRate,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PreferredPlaybackSequencing,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ReceiveCoilName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.TransmitCoilName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PlateType,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PhosphorType,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ScanVelocity,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WholeBodyTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScanLength,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionMatrix,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.InPlanePhaseEncodingDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FlipAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.VariableFlipAngleFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SAR,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.dBdt,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.B1rms,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AcquisitionDeviceProcessingDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AcquisitionDeviceProcessingCode,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CassetteOrientation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CassetteSize,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ExposuresOnPlate,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RelativeXRayExposure,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ExposureIndex,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TargetExposureIndex,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeviationIndex,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ColumnAngulation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TomoLayerHeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TomoAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TomoTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TomoType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TomoClass,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NumberOfTomosynthesisSourceImages,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PositionerMotion,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PositionerType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PositionerPrimaryAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PositionerSecondaryAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PositionerPrimaryAngleIncrement,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PositionerSecondaryAngleIncrement,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorPrimaryAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorSecondaryAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ShutterShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShutterLeftVerticalEdge,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ShutterRightVerticalEdge,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ShutterUpperHorizontalEdge,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ShutterLowerHorizontalEdge,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CenterOfCircularShutter,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RadiusOfCircularShutter,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.VerticesOfThePolygonalShutter,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ShutterPresentationValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ShutterOverlayGroup,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ShutterPresentationColorCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CollimatorShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CollimatorLeftVerticalEdge,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CollimatorRightVerticalEdge,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CollimatorUpperHorizontalEdge,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CollimatorLowerHorizontalEdge,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CenterOfCircularCollimator,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RadiusOfCircularCollimator,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.VerticesOfThePolygonalCollimator,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionTimeSynchronized,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TimeSource,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.TimeDistributionProtocol,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NTPSourceAddress,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PageNumberVector,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.FrameLabelVector,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.FramePrimaryAngleVector,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FrameSecondaryAngleVector,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SliceLocationVector,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DisplayWindowLabelVector,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.NominalScannedPixelSpacing,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DigitizingDeviceTransportDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RotationOfScannedFilm,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BiopsyTargetSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TargetUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.LocalizingCursorPosition,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CalculatedTargetPosition,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TargetLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.DisplayedZValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IVUSAcquisition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IVUSPullbackRate,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.IVUSGatedRate,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.IVUSPullbackStartFrameNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.IVUSPullbackStopFrameNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.LesionNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.OutputPower,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.TransducerData,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.FocusDepth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ProcessingFunction,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PostprocessingFunction,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MechanicalIndex,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BoneThermalIndex,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CranialThermalIndex,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SoftTissueThermalIndex,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SoftTissueFocusThermalIndex,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SoftTissueSurfaceThermalIndex,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DynamicRange,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TotalGain,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DepthOfScanField,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PatientPosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ViewPosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ProjectionEponymousNameCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageTransformationMatrix,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImageTranslationVector,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.Sensitivity,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SequenceOfUltrasoundRegions,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RegionSpatialFormat,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RegionDataType,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RegionFlags,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.RegionLocationMinX0,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.RegionLocationMinY0,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.RegionLocationMaxX1,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.RegionLocationMaxY1,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.ReferencePixelX0,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.ReferencePixelY0,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.PhysicalUnitsXDirection,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PhysicalUnitsYDirection,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ReferencePixelPhysicalValueX,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ReferencePixelPhysicalValueY,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.PhysicalDeltaX,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.PhysicalDeltaY,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TransducerFrequency,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TransducerType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PulseRepetitionFrequency,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.DopplerCorrectionAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.SteeringAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DopplerSampleVolumeXPositionRetired,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.DopplerSampleVolumeXPosition,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.DopplerSampleVolumeYPositionRetired,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.DopplerSampleVolumeYPosition,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.TMLinePositionX0Retired,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TMLinePositionX0,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.TMLinePositionY0Retired,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TMLinePositionY0,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.TMLinePositionX1Retired,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TMLinePositionX1,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.TMLinePositionY1Retired,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TMLinePositionY1,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.PixelComponentOrganization,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PixelComponentMask,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.PixelComponentRangeStart,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.PixelComponentRangeStop,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.PixelComponentPhysicalUnits,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PixelComponentDataType,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfTableBreakPoints,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TableOfXBreakPoints,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TableOfYBreakPoints,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.NumberOfTableEntries,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TableOfPixelValues,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TableOfParameterValues,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RWaveTimeVector,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.DetectorConditionsNominalFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DetectorTemperature,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DetectorConfiguration,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DetectorDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.DetectorMode,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.DetectorID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.DateOfLastDetectorCalibration,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.TimeOfLastDetectorCalibration,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ExposuresOnDetectorSinceLastCalibration,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ExposuresOnDetectorSinceManufactured,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.DetectorTimeSinceLastExposure,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorActiveTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorActivationOffsetFromExposure,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorBinning,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorElementPhysicalSize,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorElementSpacing,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorActiveShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DetectorActiveDimensions,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorActiveOrigin,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DetectorManufacturerName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DetectorManufacturerModelName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.FieldOfViewOrigin,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FieldOfViewRotation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FieldOfViewHorizontalFlip,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PixelDataAreaOriginRelativeToFOV,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PixelDataAreaRotationAngleRelativeToFOV,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.GridAbsorbingMaterial,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.GridSpacingMaterial,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.GridThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.GridPitch,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.GridAspectRatio,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.GridPeriod,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.GridFocalDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FilterMaterial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FilterThicknessMinimum,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FilterThicknessMaximum,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FilterBeamPathLengthMinimum,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.FilterBeamPathLengthMaximum,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ExposureControlMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ExposureControlModeDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ExposureStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PhototimerSetting,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ExposureTimeInuS,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.XRayTubeCurrentInuA,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ContentQualification,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PulseSequenceName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.MRImagingModifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.EchoPulseSequence,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InversionRecovery,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FlowCompensation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MultipleSpinEcho,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MultiPlanarExcitation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PhaseContrast,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TimeOfFlightContrast,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Spoiling,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SteadyStatePulseSequence,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.EchoPlanarPulseSequence,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TagAngleFirstAxis,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MagnetizationTransfer,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.T2Preparation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BloodSignalNulling,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SaturationRecovery,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpectrallySelectedSuppression,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpectrallySelectedExcitation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpatialPresaturation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Tagging,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OversamplingPhase,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TagSpacingFirstDimension,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.GeometryOfKSpaceTraversal,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SegmentedKSpaceTraversal,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RectilinearPhaseEncodeReordering,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TagThickness,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.PartialFourierDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CardiacSynchronizationTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReceiveCoilManufacturerName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MRReceiveCoilSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReceiveCoilType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.QuadratureReceiveCoil,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MultiCoilDefinitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MultiCoilConfiguration,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MultiCoilElementName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.MultiCoilElementUsed,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MRTransmitCoilSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransmitCoilManufacturerName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TransmitCoilType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpectralWidth,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ChemicalShiftReference,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VolumeLocalizationTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MRAcquisitionFrequencyEncodingSteps,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Decoupling,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DecoupledNucleus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DecouplingFrequency,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DecouplingMethod,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DecouplingChemicalShiftReference,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.KSpaceFiltering,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TimeDomainFiltering,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NumberOfZeroFills,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BaselineCorrection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ParallelReductionFactorInPlane,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CardiacRRIntervalSpecified,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.AcquisitionDuration,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.FrameAcquisitionDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.DiffusionDirectionality,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DiffusionGradientDirectionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ParallelAcquisition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ParallelAcquisitionTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InversionTimes,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MetaboliteMapDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.PartialFourier,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.EffectiveEchoTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MetaboliteMapCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChemicalShiftSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CardiacSignalSource,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DiffusionBValue,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DiffusionGradientOrientation,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VelocityEncodingDirection,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VelocityEncodingMinimumValue,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VelocityEncodingAcquisitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumberOfKSpaceTrajectories,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CoverageOfKSpace,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpectroscopyAcquisitionPhaseRows,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.ParallelReductionFactorInPlaneRetired,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TransmitterFrequency,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ResonantNucleus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FrequencyCorrection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MRSpectroscopyFOVGeometrySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SlabThickness,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.SlabOrientation,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MidSlabPosition,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MRSpatialSaturationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MRTimingAndRelatedParametersSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MREchoSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MRModifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MRDiffusionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CardiacSynchronizationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MRAveragesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MRFOVGeometrySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VolumeLocalizationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpectroscopyAcquisitionDataColumns,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.DiffusionAnisotropyType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FrameReferenceDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.MRMetaboliteMapSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ParallelReductionFactorOutOfPlane,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.SpectroscopyAcquisitionOutOfPlanePhaseSteps,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.BulkMotionStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ParallelReductionFactorSecondInPlane,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CardiacBeatRejectionTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RespiratoryMotionCompensationTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RespiratorySignalSource,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BulkMotionCompensationTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BulkMotionSignalSource,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ApplicableSafetyStandardAgency,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ApplicableSafetyStandardDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.OperatingModeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OperatingModeType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OperatingMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpecificAbsorptionRateDefinition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GradientOutputType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpecificAbsorptionRateValue,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.GradientOutput,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.FlowCompensationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TaggingDelay,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.RespiratoryMotionCompensationTechniqueDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.RespiratorySignalSourceID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ChemicalShiftMinimumIntegrationLimitInHz,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ChemicalShiftMaximumIntegrationLimitInHz,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MRVelocityEncodingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FirstOrderPhaseCorrection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.WaterReferencedPhaseCorrection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MRSpectroscopyAcquisitionType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RespiratoryCyclePosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VelocityEncodingMaximumValue,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TagSpacingSecondDimension,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TagAngleSecondAxis,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.FrameAcquisitionDuration,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MRImageFrameTypeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MRSpectroscopyFrameTypeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MRAcquisitionPhaseEncodingStepsInPlane,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MRAcquisitionPhaseEncodingStepsOutOfPlane,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.SpectroscopyAcquisitionPhaseColumns,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.CardiacCyclePosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpecificAbsorptionRateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RFEchoTrainLength,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.GradientEchoTrainLength,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ArterialSpinLabelingContrast,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MRArterialSpinLabelingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ASLTechniqueDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ASLSlabNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ASLSlabThickness,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ASLSlabOrientation,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ASLMidSlabPosition,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ASLContext,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ASLPulseTrainDuration,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.ASLCrusherFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ASLCrusherFlowLimit,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ASLCrusherDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ASLBolusCutoffFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ASLBolusCutoffTimingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ASLBolusCutoffTechnique,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ASLBolusCutoffDelayTime,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.ASLSlabSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChemicalShiftMinimumIntegrationLimitInppm,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ChemicalShiftMaximumIntegrationLimitInppm,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.WaterReferenceAcquisition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.EchoPeakPosition,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CTAcquisitionTypeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AcquisitionType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TubeAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CTAcquisitionDetailsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RevolutionTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.SingleCollimationWidth,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TotalCollimationWidth,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CTTableDynamicsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TableSpeed,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TableFeedPerRotation,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.SpiralPitchFactor,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CTGeometrySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DataCollectionCenterPatient,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CTReconstructionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReconstructionAlgorithm,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ConvolutionKernelGroup,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReconstructionFieldOfView,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ReconstructionTargetCenterPatient,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ReconstructionAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ImageFilter,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CTExposureSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReconstructionPixelSpacing,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ExposureModulationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.EstimatedDoseSaving,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CTXRayDetailsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CTPositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TablePosition,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ExposureTimeInms,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CTImageFrameTypeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.XRayTubeCurrentInmA,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ExposureInmAs,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ConstantVolumeFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FluoroscopyFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DistanceSourceToDataCollectionCenter,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusAgentNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusIngredientCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContrastAdministrationProfileSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusUsageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusAgentAdministered,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusAgentDetected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusAgentPhase,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CTDIvol,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CTDIPhantomTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CalciumScoringMassFactorPatient,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CalciumScoringMassFactorDevice,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.EnergyWeightingFactor,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CTAdditionalXRaySourceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ProjectionPixelCalibrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DistanceSourceToIsocenter,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.DistanceObjectToTableTop,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ObjectPixelSpacingInCenterOfBeam,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PositionerPositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TablePositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CollimatorShapeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PlanesInAcquisition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.XAXRFFrameCharacteristicsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FrameAcquisitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.XRayReceptorType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionProtocolName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AcquisitionProtocolDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusIngredientOpaque,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DistanceReceptorPlaneToDetectorHousing,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IntensifierActiveShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IntensifierActiveDimensions,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PhysicalDetectorSize,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PositionOfIsocenterProjection,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.FieldOfViewSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FieldOfViewDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ExposureControlSensingRegionsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ExposureControlSensingRegionShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ExposureControlSensingRegionLeftVerticalEdge,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.ExposureControlSensingRegionRightVerticalEdge,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.ExposureControlSensingRegionUpperHorizontalEdge,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.ExposureControlSensingRegionLowerHorizontalEdge,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.CenterOfCircularExposureControlSensingRegion,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.RadiusOfCircularExposureControlSensingRegion,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.VerticesOfThePolygonalExposureControlSensingRegion,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.ColumnAngulationPatient,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BeamAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.FrameDetectorParametersSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CalculatedAnatomyThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CalibrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ObjectThicknessSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PlaneIdentification,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FieldOfViewDimensionsInFloat,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IsocenterReferenceSystemSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PositionerIsocenterPrimaryAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PositionerIsocenterSecondaryAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PositionerIsocenterDetectorRotationAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableXPositionToIsocenter,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableYPositionToIsocenter,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableZPositionToIsocenter,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableHorizontalRotationAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableHeadTiltAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableCradleTiltAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.FrameDisplayShutterSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AcquiredImageAreaDoseProduct,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CArmPositionerTabletopRelationship,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.XRayGeometrySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IrradiationEventIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.XRay3DFrameTypeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContributingSourcesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.XRay3DAcquisitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrimaryPositionerScanArc,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SecondaryPositionerScanArc,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PrimaryPositionerScanStartAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SecondaryPositionerScanStartAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PrimaryPositionerIncrement,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SecondaryPositionerIncrement,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StartAcquisitionDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.EndAcquisitionDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.PrimaryPositionerIncrementSign,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.SecondaryPositionerIncrementSign,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.ApplicationName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ApplicationVersion,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ApplicationManufacturer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AlgorithmType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AlgorithmDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.XRay3DReconstructionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReconstructionDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PerProjectionAcquisitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DetectorPositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.XRayAcquisitionDoseSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.XRaySourceIsocenterPrimaryAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.XRaySourceIsocenterSecondaryAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.BreastSupportIsocenterPrimaryAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.BreastSupportIsocenterSecondaryAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.BreastSupportXPositionToIsocenter,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.BreastSupportYPositionToIsocenter,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.BreastSupportZPositionToIsocenter,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DetectorIsocenterPrimaryAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DetectorIsocenterSecondaryAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DetectorXPositionToIsocenter,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DetectorYPositionToIsocenter,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DetectorZPositionToIsocenter,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.XRayGridSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.XRayFilterSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DetectorActiveAreaTLHCPosition,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DetectorActiveAreaOrientation,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.PositionerPrimaryAngleDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DiffusionBMatrixSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DiffusionBValueXX,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DiffusionBValueXY,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DiffusionBValueXZ,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DiffusionBValueYY,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DiffusionBValueYZ,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DiffusionBValueZZ,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DecayCorrectionDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.StartDensityThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.StartRelativeDensityDifferenceThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.StartCardiacTriggerCountThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.StartRespiratoryTriggerCountThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TerminationCountsThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TerminationDensityThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TerminationRelativeDensityThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TerminationTimeThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TerminationCardiacTriggerCountThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TerminationRespiratoryTriggerCountThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DetectorGeometry,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TransverseDetectorSeparation,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.AxialDetectorDimension,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalAgentNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PETFrameAcquisitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PETDetectorMotionDetailsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PETTableDynamicsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PETPositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PETFrameCorrectionFactorsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalUsageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AttenuationCorrectionSource,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NumberOfIterations,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfSubsets,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PETReconstructionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PETFrameTypeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TimeOfFlightInformationUsed,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReconstructionType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DecayCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AttenuationCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScatterCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DeadTimeCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GantryMotionCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatientMotionCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CountLossNormalizationCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RandomsCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NonUniformRadialSamplingCorrected,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SensitivityCalibrated,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DetectorNormalizationCorrection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IterativeReconstructionMethod,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AttenuationCorrectionTemporalRelationship,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatientPhysiologicalStateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientPhysiologicalStateCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DepthsOfFocus,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ExcludedIntervalsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ExclusionStartDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ExclusionDuration,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.USImageDescriptionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageDataTypeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DataType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TransducerScanPatternCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AliasedDataType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PositionMeasuringDeviceUsed,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TransducerGeometryCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransducerBeamSteeringCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransducerApplicationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ZeroVelocityPixelValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.ContributingEquipmentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContributionDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ContributionDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.StudyInstanceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.SeriesInstanceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.StudyID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SeriesNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.InstanceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.IsotopeNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PhaseNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.IntervalNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TimeSlotNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AngleNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ItemNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PatientOrientation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlayNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CurveNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.LUTNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ImagePosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImagePositionPatient,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImageOrientation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImageOrientationPatient,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.Location,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FrameOfReferenceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.Laterality,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageLaterality,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageGeometryType,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MaskingImage,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReportNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TemporalPositionIdentifier,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfTemporalPositions,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TemporalResolution,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SynchronizationFrameOfReferenceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.SOPInstanceUIDOfConcatenationSource,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.SeriesInStudy,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionsInSeries,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ImagesInAcquisition,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ImagesInSeries,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionsInStudy,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ImagesInStudy,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.Reference,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PositionReferenceIndicator,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SliceLocation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OtherStudyNumbers,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfPatientRelatedStudies,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfPatientRelatedSeries,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfPatientRelatedInstances,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfStudyRelatedSeries,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfStudyRelatedInstances,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfSeriesRelatedInstances,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.SourceImageID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ModifyingDeviceID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ModifiedImageID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ModifiedImageDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ModifyingDeviceManufacturer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ModifiedImageTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ModifiedImageDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ImageComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.OriginalImageIdentification,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.OriginalImageIdentificationNomenclature,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.StackID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.InStackPositionNumber,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.FrameAnatomySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FrameLaterality,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FrameContentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PlanePositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PlaneOrientationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TemporalPositionIndex,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.NominalCardiacTriggerDelayTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.NominalCardiacTriggerTimePriorToRPeak,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ActualCardiacTriggerTimePriorToRPeak,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.FrameAcquisitionNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DimensionIndexValues,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.FrameComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ConcatenationUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.InConcatenationNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.InConcatenationTotalNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DimensionOrganizationUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.DimensionIndexPointer,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.FunctionalGroupPointer,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.UnassignedSharedConvertedAttributesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.UnassignedPerFrameConvertedAttributesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ConversionSourceAttributesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DimensionIndexPrivateCreator,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DimensionOrganizationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DimensionIndexSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ConcatenationFrameOffsetNumber,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.FunctionalGroupPrivateCreator,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.NominalPercentageOfCardiacPhase,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.NominalPercentageOfRespiratoryPhase,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StartingRespiratoryAmplitude,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StartingRespiratoryPhase,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.EndingRespiratoryAmplitude,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.EndingRespiratoryPhase,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RespiratoryTriggerType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RRIntervalTimeNominal,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ActualCardiacTriggerDelayTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.RespiratorySynchronizationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RespiratoryIntervalTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.NominalRespiratoryTriggerDelayTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.RespiratoryTriggerDelayThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ActualRespiratoryTriggerDelayTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ImagePositionVolume,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ImageOrientationVolume,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.UltrasoundAcquisitionGeometry,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ApexPosition,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VolumeToTransducerMappingMatrix,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VolumeToTableMappingMatrix,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VolumeToTransducerRelationship,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatientFrameOfReferenceSource,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TemporalPositionTimeOffset,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.PlanePositionVolumeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PlaneOrientationVolumeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TemporalPositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DimensionOrganizationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VolumeFrameOfReferenceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.TableFrameOfReferenceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.DimensionDescriptionLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientOrientationInFrameSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FrameLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AcquisitionIndex,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ContributingSOPInstancesReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReconstructionIndex,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.LightPathFilterPassThroughWavelength,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.LightPathFilterPassBand,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImagePathFilterPassThroughWavelength,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImagePathFilterPassBand,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PatientEyeMovementCommanded,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatientEyeMovementCommandCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SphericalLensPower,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CylinderLensPower,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CylinderAxis,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.EmmetropicMagnification,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IntraOcularPressure,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.HorizontalFieldOfView,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PupilDilated,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DegreeOfDilation,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StereoBaselineAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StereoBaselineDisplacement,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StereoHorizontalPixelOffset,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StereoVerticalPixelOffset,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StereoRotation,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AcquisitionDeviceTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IlluminationTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LightPathFilterTypeStackCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImagePathFilterTypeStackCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LensesCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelDescriptionCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RefractiveStateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MydriaticAgentCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RelativeImagePositionCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CameraAngleOfView,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StereoPairsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LeftImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RightImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StereoPairsPresent,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AxialLengthOfTheEye,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.OphthalmicFrameLocationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferenceCoordinates,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.DepthSpatialResolution,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MaximumDepthDistortion,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AlongScanSpatialResolution,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MaximumAlongScanDistortion,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.OphthalmicImageOrientation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DepthOfTransverseImage,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MydriaticAgentConcentrationUnitsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AcrossScanSpatialResolution,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MaximumAcrossScanDistortion,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MydriaticAgentConcentration,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.IlluminationWaveLength,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IlluminationPower,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IlluminationBandwidth,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MydriaticAgentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialMeasurementsRightEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialMeasurementsLeftEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialMeasurementsDeviceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLengthMeasurementsType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLengthSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLength,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.LensStatusCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VitreousStatusCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IOLFormulaCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IOLFormulaDetail,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.KeratometerIndex,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SourceOfOphthalmicAxialLengthCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TargetRefraction,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RefractiveProcedureOccurred,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RefractiveSurgeryTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicUltrasoundMethodCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLengthMeasurementsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IOLPower,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PredictedRefractiveError,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLengthVelocity,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.LensStatusDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.VitreousStatusDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IOLPowerSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LensConstantSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IOLManufacturer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.LensConstantDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ImplantName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.KeratometryMeasurementTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImplantPartNumber,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReferencedOphthalmicAxialMeasurementsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RefractiveErrorBeforeRefractiveSurgeryCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IOLPowerForExactEmmetropia,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IOLPowerForExactTargetRefraction,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AnteriorChamberDepthDefinitionCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LensThicknessSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnteriorChamberDepthSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LensThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AnteriorChamberDepth,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SourceOfLensThicknessDataCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SourceOfAnteriorChamberDepthDataCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SourceOfRefractiveMeasurementsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SourceOfRefractiveMeasurementsCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLengthMeasurementModified,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLengthDataSourceCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLengthAcquisitionMethodCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SignalToNoiseRatio,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLengthDataSourceDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLengthMeasurementsTotalLengthSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLengthMeasurementsSegmentalLengthSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLengthMeasurementsLengthSummationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.UltrasoundOphthalmicAxialLengthMeasurementsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OpticalOphthalmicAxialLengthMeasurementsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.UltrasoundSelectedOphthalmicAxialLengthSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLengthSelectionMethodCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OpticalSelectedOphthalmicAxialLengthSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SelectedSegmentalOphthalmicAxialLengthSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SelectedTotalOphthalmicAxialLengthSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLengthQualityMetricSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLengthQualityMetricTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLengthQualityMetricTypeDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IntraocularLensCalculationsRightEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IntraocularLensCalculationsLeftEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedOphthalmicAxialLengthMeasurementQCImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicMappingDeviceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AcquisitionMethodCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AcquisitionMethodAlgorithmSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicThicknessMapTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicThicknessMappingNormalsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RetinalThicknessDefinitionCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PixelValueMappingToCodedConceptSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MappedPixelValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.PixelValueMappingExplanation,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.OphthalmicThicknessMapQualityThresholdSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicThicknessMapThresholdQualityRating,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AnatomicStructureReferencePoint,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RegistrationToLocalizerSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RegisteredLocalizerUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RegisteredLocalizerTopLeftHandCorner,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RegisteredLocalizerBottomRightHandCorner,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.OphthalmicThicknessMapQualityRatingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RelevantOPTAttributesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransformationMethodCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransformationAlgorithmSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicAxialLengthMethod,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OphthalmicFOV,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TwoDimensionalToThreeDimensionalMapSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.WideFieldOphthalmicPhotographyQualityRatingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.WideFieldOphthalmicPhotographyQualityThresholdSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.WideFieldOphthalmicPhotographyThresholdQualityRating,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.XCoordinatesCenterPixelViewAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.YCoordinatesCenterPixelViewAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.NumberOfMapPoints,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TwoDimensionalToThreeDimensionalMapData,ValueRepresentation.OF);
		valueRepresentationsByTag.put(TagFromName.VisualFieldHorizontalExtent,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.VisualFieldVerticalExtent,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.VisualFieldShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScreeningTestModeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MaximumStimulusLuminance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BackgroundLuminance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StimulusColorCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BackgroundIlluminationColorCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StimulusArea,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StimulusPresentationTime,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.FixationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FixationMonitoringCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VisualFieldCatchTrialSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FixationCheckedQuantity,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PatientNotProperlyFixatedQuantity,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PresentedVisualStimuliDataFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NumberOfVisualStimuli,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ExcessiveFixationLossesDataFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ExcessiveFixationLosses,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.StimuliRetestingQuantity,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CommentsOnPatientPerformanceOfVisualField,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.FalseNegativesEstimateFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FalseNegativesEstimate,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.NegativeCatchTrialsQuantity,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.FalseNegativesQuantity,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ExcessiveFalseNegativesDataFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ExcessiveFalseNegatives,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FalsePositivesEstimateFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FalsePositivesEstimate,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CatchTrialsDataFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PositiveCatchTrialsQuantity,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TestPointNormalsDataFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TestPointNormalsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GlobalDeviationProbabilityNormalsFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FalsePositivesQuantity,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ExcessiveFalsePositivesDataFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ExcessiveFalsePositives,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VisualFieldTestNormalsFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ResultsNormalsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AgeCorrectedSensitivityDeviationAlgorithmSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GlobalDeviationFromNormal,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.GeneralizedDefectSensitivityDeviationAlgorithmSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LocalizedDeviationFromNormal,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PatientReliabilityIndicator,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.VisualFieldMeanSensitivity,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.GlobalDeviationProbability,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.LocalDeviationProbabilityNormalsFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LocalizedDeviationProbability,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ShortTermFluctuationCalculated,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShortTermFluctuation,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ShortTermFluctuationProbabilityCalculated,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShortTermFluctuationProbability,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CorrectedLocalizedDeviationFromNormalCalculated,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CorrectedLocalizedDeviationFromNormal,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CorrectedLocalizedDeviationFromNormalProbabilityCalculated,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CorrectedLocalizedDeviationFromNormalProbability,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.GlobalDeviationProbabilitySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LocalizedDeviationProbabilitySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FovealSensitivityMeasured,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FovealSensitivity,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.VisualFieldTestDuration,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.VisualFieldTestPointSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VisualFieldTestPointXCoordinate,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.VisualFieldTestPointYCoordinate,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AgeCorrectedSensitivityDeviationValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.StimulusResults,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SensitivityValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RetestStimulusSeen,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RetestSensitivityValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.VisualFieldTestPointNormalsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.QuantifiedDefect,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AgeCorrectedSensitivityDeviationProbabilityValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.GeneralizedDefectCorrectedSensitivityDeviationFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GeneralizedDefectCorrectedSensitivityDeviationValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.GeneralizedDefectCorrectedSensitivityDeviationProbabilityValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MinimumSensitivityValue,ValueRepresentation.FL );
		valueRepresentationsByTag.put(TagFromName.BlindSpotLocalized,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BlindSpotXCoordinate,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BlindSpotYCoordinate,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.VisualAcuityMeasurementSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RefractiveParametersUsedOnPatientSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MeasurementLaterality,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OphthalmicPatientClinicalInformationLeftEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OphthalmicPatientClinicalInformationRightEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FovealPointNormativeDataFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FovealPointProbabilityValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ScreeningBaselineMeasured,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScreeningBaselineMeasuredSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScreeningBaselineType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScreeningBaselineValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AlgorithmSource,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DataSetName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DataSetVersion,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DataSetSource,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DataSetDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.VisualFieldTestReliabilityGlobalIndexSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VisualFieldGlobalResultsIndexSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DataObservationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IndexNormalsFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IndexProbability,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IndexProbabilitySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SamplesPerPixel,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.SamplesPerPixelUsed,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PhotometricInterpretation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageDimensions,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PlanarConfiguration,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfFrames,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.FrameIncrementPointer,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.FrameDimensionPointer,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.Rows,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Columns,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Planes,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.UltrasoundColorDataPresent,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PixelSpacing,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ZoomFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ZoomCenter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PixelAspectRatio,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ImageFormat,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ManipulatedImage,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CorrectedImage,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CompressionRecognitionCode,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CompressionCode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CompressionOriginator,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CompressionLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CompressionDescription,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CompressionSequence,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CompressionStepPointers,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.RepeatInterval,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BitsGrouped,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PerimeterTable,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PerimeterValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.PredictorRows,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PredictorColumns,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PredictorConstants,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BlockedPixels,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BlockRows,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BlockColumns,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RowOverlap,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ColumnOverlap,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BitsAllocated,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BitsStored,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.HighBit,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PixelRepresentation,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.SmallestValidPixelValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.LargestValidPixelValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.SmallestImagePixelValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.LargestImagePixelValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.SmallestPixelValueInSeries,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.LargestPixelValueInSeries,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.SmallestImagePixelValueInPlane,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.LargestImagePixelValueInPlane,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.PixelPaddingValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.PixelPaddingRangeLimit,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.FloatPixelPaddingValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.DoubleFloatPixelPaddingValue,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.FloatPixelPaddingRangeLimit,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.DoubleFloatPixelPaddingRangeLimit,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ImageLocation,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.QualityControlImage,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BurnedInAnnotation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RecognizableVisualFeatures,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LongitudinalTemporalInformationModified,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReferencedColorPaletteInstanceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.TransformLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TransformVersionNumber,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.NumberOfTransformSteps,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.SequenceOfCompressedData,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DetailsOfCoefficients,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.DCTLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DataBlockDescription,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DataBlock,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.NormalizationFactorFormat,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ZonalMapNumberFormat,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ZonalMapLocation,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.ZonalMapFormat,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.AdaptiveMapFormat,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CodeNumberFormat,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PixelSpacingCalibrationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PixelSpacingCalibrationDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PixelIntensityRelationship,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PixelIntensityRelationshipSign,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.WindowCenter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WindowWidth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RescaleIntercept,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RescaleSlope,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RescaleType,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.WindowCenterWidthExplanation,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.VOILUTFunction,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GrayScale,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RecommendedViewingMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GrayLookupTableDescriptor,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.RedPaletteColorLookupTableDescriptor,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.GreenPaletteColorLookupTableDescriptor,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.BluePaletteColorLookupTableDescriptor,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.AlphaPaletteColorLookupTableDescriptor,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.LargeRedPaletteColorLookupTableDescriptor,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.LargeGreenPaletteColorLookupTableDescriptor,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.LargeBluePaletteColorLookupTableDescriptor,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.PaletteColorLookupTableUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.GrayLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.RedPaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.GreenPaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.BluePaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.AlphaPaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.LargeRedPaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.LargeGreenPaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.LargeBluePaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.LargePaletteColorLookupTableUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.SegmentedRedPaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.SegmentedGreenPaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.SegmentedBluePaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.SegmentedAlphaPaletteColorLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.BreastImplantPresent,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PartialView,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PartialViewDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.PartialViewCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpatialLocationsPreserved,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DataFrameAssignmentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DataPathAssignment,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BitsMappedToColorLookupTable,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BlendingLUT1Sequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BlendingLUT1TransferFunction,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BlendingWeightConstant,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.BlendingLookupTableDescriptor,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BlendingLookupTableData,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.EnhancedPaletteColorLookupTableSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BlendingLUT2Sequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BlendingLUT2TransferFunction,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DataPathID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RGBLUTTransferFunction,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AlphaLUTTransferFunction,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ICCProfile,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.ColorSpace,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LossyImageCompression,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LossyImageCompressionRatio,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.LossyImageCompressionMethod,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ModalityLUTSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LUTDescriptor,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.LUTExplanation,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ModalityLUTType,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.LUTData,ValueRepresentation.XO);
		valueRepresentationsByTag.put(TagFromName.VOILUTSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SoftcopyVOILUTSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImagePresentationComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.BiPlaneAcquisitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RepresentativeFrameNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.FrameNumbersOfInterest,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.FrameOfInterestDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.FrameOfInterestType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MaskPointers,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RWavePointer,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MaskSubtractionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MaskOperation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ApplicableFrameRange,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MaskFrameNumbers,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ContrastFrameAveraging,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MaskSubPixelShift,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TIDOffset,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.MaskOperationExplanation,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.EquipmentAdministratorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumberOfDisplaySubsystems,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CurrentConfigurationID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DisplaySystemID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DisplaySubsystemName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.DisplaySubsystemDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SystemStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SystemStatusComment,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TargetLuminanceCharacteristicsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LuminanceCharacteristicsID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DisplaySubsystemConfigurationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ConfigurationID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ConfigurationName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ConfigurationDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReferencedTargetLuminanceCharacteristicsID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.QAResultsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DisplaySubsystemQAResultsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ConfigurationQAResultsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MeasurementEquipmentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MeasurementFunctions,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MeasurementEquipmentType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VisualEvaluationResultSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DisplayCalibrationResultSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DDLValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CIExyWhitePoint,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.DisplayFunctionType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GammaValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.NumberOfLuminancePoints,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.LuminanceResponseSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TargetMinimumLuminance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TargetMaximumLuminance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.LuminanceValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.LuminanceResponseDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.WhitePointFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DisplayDeviceTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DisplaySubsystemSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LuminanceResultSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AmbientLightValueSource,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MeasuredCharacteristics,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LuminanceUniformityResultSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VisualEvaluationTestSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TestResult,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TestResultComment,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TestImageValidation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TestPatternCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MeasurementPatternCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VisualEvaluationMethodCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PixelDataProviderURL,ValueRepresentation.UR);
		valueRepresentationsByTag.put(TagFromName.DataPointRows,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.DataPointColumns,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SignalDomainColumns,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LargestMonochromePixelValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DataRepresentation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PixelMeasuresSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FrameVOILUTSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PixelValueTransformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SignalDomainRows,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DisplayFilterPercentage,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.FramePixelShiftSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SubtractionItemID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PixelIntensityRelationshipLUTSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FramePixelDataPropertiesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GeometricalProperties,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GeometricMaximumDistortion,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ImageProcessingApplied,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MaskSelectionMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LUTFunction,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MaskVisibilityPercentage,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PixelShiftSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RegionPixelShiftSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VerticesOfTheRegion,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.MultiFramePresentationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PixelShiftFrameRange,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.LUTFrameRange,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageToEquipmentMappingMatrix,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EquipmentCoordinateSystemIdentification,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.StudyStatusID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.StudyPriorityID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.StudyIDIssuer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.StudyVerifiedDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.StudyVerifiedTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.StudyReadDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.StudyReadTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ScheduledStudyStartDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ScheduledStudyStartTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ScheduledStudyStopDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ScheduledStudyStopTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ScheduledStudyLocation,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ScheduledStudyLocationAETitle,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.ReasonForStudy,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RequestingPhysicianIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RequestingPhysician,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.RequestingService,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RequestingServiceCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StudyArrivalDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.StudyArrivalTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.StudyCompletionDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.StudyCompletionTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.StudyComponentStatusID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RequestedProcedureDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RequestedProcedureCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RequestedContrastAgent,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.StudyComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ReferencedPatientAliasSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VisitStatusID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AdmissionID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IssuerOfAdmissionID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IssuerOfAdmissionIDSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RouteOfAdmissions,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ScheduledAdmissionDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ScheduledAdmissionTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ScheduledDischargeDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ScheduledDischargeTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ScheduledPatientInstitutionResidence,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AdmittingDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.AdmittingTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.DischargeDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.DischargeTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.DischargeDiagnosisDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DischargeDiagnosisCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecialNeeds,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ServiceEpisodeID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IssuerOfServiceEpisodeID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ServiceEpisodeDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IssuerOfServiceEpisodeIDSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PertinentDocumentsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PertinentResourcesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ResourceDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CurrentPatientLocation,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientInstitutionResidence,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientState,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientClinicalTrialParticipationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VisitComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.WaveformOriginality,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NumberOfWaveformChannels,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfWaveformSamples,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SamplingFrequency,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MultiplexGroupLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ChannelDefinitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.WaveformChannelNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ChannelLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ChannelStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ChannelSourceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelSourceModifiersSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SourceWaveformSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelDerivationDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ChannelSensitivity,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelSensitivityUnitsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelSensitivityCorrectionFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelBaseline,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelTimeSkew,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelSampleSkew,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelOffset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WaveformBitsStored,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.FilterLowFrequency,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FilterHighFrequency,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NotchFilterFrequency,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NotchFilterBandwidth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WaveformDataDisplayScale,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.WaveformDisplayBackgroundCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.WaveformPresentationGroupSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PresentationGroupNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ChannelDisplaySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelRecommendedDisplayCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ChannelPosition,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.DisplayShadingFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FractionalChannelDisplayScale,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AbsoluteChannelDisplayScale,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MultiplexedAudioChannelsDescriptionCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelIdentificationCode,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ChannelMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScheduledStationAETitle,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepStartDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepStartTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepEndDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepEndTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ScheduledPerformingPhysicianName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ScheduledProtocolCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.StageCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledPerformingPhysicianIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledStationName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepLocation,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PreMedication,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OrderPlacerIdentifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OrderFillerIdentifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LocalNamespaceEntityID,ValueRepresentation.UT);
		valueRepresentationsByTag.put(TagFromName.UniversalEntityID,ValueRepresentation.UT);
		valueRepresentationsByTag.put(TagFromName.UniversalEntityIDType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IdentifierTypeCode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AssigningFacilitySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AssigningJurisdictionCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AssigningAgencyOrDepartmentCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedNonImageCompositeSOPInstanceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformedStationAETitle,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.PerformedStationName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PerformedLocation,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepStartDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepStartTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepEndDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepEndTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureTypeDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PerformedProtocolCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformedProtocolType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScheduledStepAttributesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RequestAttributesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CommentsOnThePerformedProcedureStep,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepDiscontinuationReasonCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.QuantitySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.Quantity,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MeasuringUnitsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BillingItemSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TotalTimeOfFluoroscopy,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TotalNumberOfExposures,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.EntranceDose,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ExposedArea,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DistanceSourceToEntrance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DistanceSourceToSupport,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ExposureDoseSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CommentsOnRadiationDose,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.XRayOutput,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.HalfValueLayer,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OrganDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OrganExposed,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BillingProcedureStepSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FilmConsumptionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BillingSuppliesAndDevicesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedProcedureStepSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformedSeriesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CommentsOnTheScheduledProcedureStep,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ProtocolContextSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContentItemModifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledSpecimenSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenAccessionNumber,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ContainerIdentifier,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IssuerOfTheContainerIdentifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AlternateContainerIdentifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContainerTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContainerDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenIdentifier,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SpecimenDescriptionSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenDescriptionTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.SpecimenUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.AcquisitionContextSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AcquisitionContextDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.SpecimenDescriptionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IssuerOfTheSpecimenIdentifierSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenShortDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SpecimenDetailedDescription,ValueRepresentation.UT);
		valueRepresentationsByTag.put(TagFromName.SpecimenPreparationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenPreparationStepContentItemSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenLocalizationContentItemSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SlideIdentifier,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ImageCenterPointCoordinatesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.XOffsetInSlideCoordinateSystem,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.YOffsetInSlideCoordinateSystem,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ZOffsetInSlideCoordinateSystem,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PixelSpacingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CoordinateSystemAxisCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MeasurementUnitsCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VitalStainCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RequestedProcedureID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ReasonForTheRequestedProcedure,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RequestedProcedurePriority,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PatientTransportArrangements,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RequestedProcedureLocation,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PlacerOrderNumberProcedure,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.FillerOrderNumberProcedure,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ConfidentialityCode,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReportingPriority,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ReasonForRequestedProcedureCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NamesOfIntendedRecipientsOfResults,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.IntendedRecipientsOfResultsIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReasonForPerformedProcedureCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RequestedProcedureDescriptionTrial,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PersonIdentificationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PersonAddress,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.PersonTelephoneNumbers,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PersonTelecomInformation,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.RequestedProcedureComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ReasonForTheImagingServiceRequest,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IssueDateOfImagingServiceRequest,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.IssueTimeOfImagingServiceRequest,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.PlacerOrderNumberImagingServiceRequestRetired,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.FillerOrderNumberImagingServiceRequestRetired,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.OrderEnteredBy,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.OrderEntererLocation,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.OrderCallbackPhoneNumber,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.OrderCallbackTelecomInformation,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.PlacerOrderNumberImagingServiceRequest,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.FillerOrderNumberImagingServiceRequest,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ImagingServiceRequestComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ConfidentialityConstraintOnPatientDataDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.GeneralPurposeScheduledProcedureStepStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GeneralPurposePerformedProcedureStepStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GeneralPurposeScheduledProcedureStepPriority,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcessingApplicationsCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepStartDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.MultipleCopiesFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PerformedProcessingApplicationsCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.HumanPerformerCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepModificationDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ExpectedCompletionDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ResultingGeneralPurposePerformedProcedureStepsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedGeneralPurposeScheduledProcedureStepSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledWorkitemCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformedWorkitemCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.InputAvailabilityFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InputInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RelevantInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedGeneralPurposeScheduledProcedureStepTransactionUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ScheduledStationNameCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledStationClassCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledStationGeographicLocationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformedStationNameCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformedStationClassCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformedStationGeographicLocationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RequestedSubsequentWorkitemCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NonDICOMOutputCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OutputInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScheduledHumanPerformersSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ActualHumanPerformersSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.HumanPerformerOrganization,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.HumanPerformerName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.RawDataHandling,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InputReadinessState,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepStartDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureStepEndDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ProcedureStepCancellationDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.OutputDestinationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DICOMStorageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.STOWRSStorageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StorageURL,ValueRepresentation.UR);
		valueRepresentationsByTag.put(TagFromName.XDSStorageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.EntranceDoseInmGy,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ParametricMapFrameTypeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedImageRealWorldValueMappingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RealWorldValueMappingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PixelValueMappingCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LUTLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.RealWorldValueLastValueMapped,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.RealWorldValueLUTData,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DoubleFloatRealWorldValueLastValueMapped,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DoubleFloatRealWorldValueFirstValueMapped,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.RealWorldValueFirstValueMapped,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.QuantityDefinitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RealWorldValueIntercept,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.RealWorldValueSlope,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.FindingsFlagTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RelationshipType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FindingsSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FindingsGroupUIDTrial,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedFindingsGroupUIDTrial,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.FindingsGroupRecordingDateTrial,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.FindingsGroupRecordingTimeTrial,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.FindingsSourceCategoryCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VerifyingOrganization,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DocumentingOrganizationIdentifierCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VerificationDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ObservationDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ValueType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ConceptNameCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MeasurementPrecisionDescriptionTrial,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ContinuityOfContent,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.UrgencyOrPriorityAlertsTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SequencingIndicatorTrial,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DocumentIdentifierCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DocumentAuthorTrial,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.DocumentAuthorIdentifierCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IdentifierCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VerifyingObserverSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ObjectBinaryIdentifierTrial,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.VerifyingObserverName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.DocumentingObserverIdentifierCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AuthorObserverSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ParticipantSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CustodialOrganizationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ParticipationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ParticipationDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ObserverType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ProcedureIdentifierCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VerifyingObserverIdentificationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ObjectDirectoryBinaryIdentifierTrial,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.EquivalentCDADocumentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedWaveformChannels,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DateOfDocumentOrVerbalTransactionTrial,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.TimeOfDocumentCreationOrVerbalTransactionTrial,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.DateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.Date,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.Time,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.PersonName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.UID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReportStatusIDTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TemporalRangeType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReferencedSamplePositions,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.ReferencedFrameNumbers,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ReferencedTimeOffsets,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ReferencedDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.TextValue,ValueRepresentation.UT);
		valueRepresentationsByTag.put(TagFromName.FloatingPointValue,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.RationalNumeratorValue,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.RationalDenominatorValue,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.ObservationCategoryCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ConceptCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BibliographicCitationTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.PurposeOfReferenceCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ObservationUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedObservationUIDTrial,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedObservationClassTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReferencedObjectObservationClassTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AnnotationGroupNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ObservationDateTrial,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ObservationTimeTrial,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.MeasurementAutomationTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ModifierCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IdentificationDescriptionTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.CoordinatesSetGeometricTypeTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AlgorithmCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AlgorithmDescriptionTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.PixelCoordinatesSetTrial,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.MeasuredValueSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumericValueQualifierCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CurrentObserverTrial,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.NumericValue,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ReferencedAccessionSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReportStatusCommentTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ProcedureContextSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VerbalSourceTrial,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.AddressTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.TelephoneNumberTrial,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.VerbalSourceIdentifierCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PredecessorDocumentsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedRequestSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformedProcedureCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CurrentRequestedProcedureEvidenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReportDetailSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PertinentOtherEvidenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.HL7StructuredDocumentReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ObservationSubjectUIDTrial,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ObservationSubjectClassTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ObservationSubjectTypeCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CompletionFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CompletionFlagDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.VerificationFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ArchiveRequested,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PreliminaryFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContentTemplateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IdenticalDocumentsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ObservationSubjectContextFlagTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ObserverContextFlagTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ProcedureContextFlagTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RelationshipSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RelationshipTypeCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LanguageCodeSequenceTrial,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.UniformResourceLocatorTrial,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.WaveformAnnotationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TemplateIdentifier,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TemplateVersion,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.TemplateLocalVersion,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.TemplateExtensionFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TemplateExtensionOrganizationUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.TemplateExtensionCreatorUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ReferencedContentItemIdentifier,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.HL7InstanceIdentifier,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.HL7DocumentEffectiveTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.HL7DocumentTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DocumentClassCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RetrieveURI,ValueRepresentation.UR);
		valueRepresentationsByTag.put(TagFromName.RetrieveLocationUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.TypeOfInstances,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DICOMRetrievalSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DICOMMediaRetrievalSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.WADORetrievalSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.XDSRetrievalSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.WADORSRetrievalSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RepositoryUniqueID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.HomeCommunityID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.DocumentTitle,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.EncapsulatedDocument,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.MIMETypeOfEncapsulatedDocument,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SourceInstanceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ListOfMIMETypes,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ProductPackageIdentifier,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.SubstanceAdministrationApproval,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ApprovalStatusFurtherDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ApprovalStatusDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ProductTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ProductName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ProductDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ProductLotIdentifier,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ProductExpirationDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.SubstanceAdministrationDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.SubstanceAdministrationNotes,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SubstanceAdministrationDeviceID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ProductParameterSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SubstanceAdministrationParameterSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LensDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RightLensSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LeftLensSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.UnspecifiedLateralityLensSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CylinderSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrismSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.HorizontalPrismPower,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.HorizontalPrismBase,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VerticalPrismPower,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VerticalPrismBase,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LensSegmentType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OpticalTransmittance,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ChannelWidth,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.PupilSize,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CornealSize,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.AutorefractionRightEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AutorefractionLeftEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DistancePupillaryDistance,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.NearPupillaryDistance,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.IntermediatePupillaryDistance,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.OtherPupillaryDistance,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.KeratometryRightEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.KeratometryLeftEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SteepKeratometricAxisSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RadiusOfCurvature,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.KeratometricPower,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.KeratometricAxis,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.FlatKeratometricAxisSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BackgroundColor,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Optotype,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OptotypePresentation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SubjectiveRefractionRightEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SubjectiveRefractionLeftEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AddNearSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AddIntermediateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AddOtherSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AddPower,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ViewingDistance,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VisualAcuityTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VisualAcuityRightEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VisualAcuityLeftEyeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VisualAcuityBothEyesOpenSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ViewingDistanceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VisualAcuityModifiers,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.DecimalVisualAcuity,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.OptotypeDetailedDefinition,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReferencedRefractiveMeasurementsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpherePower,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CylinderPower,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CornealTopographySurface,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CornealVertexLocation,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PupilCentroidXCoordinate,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PupilCentroidYCoordinate,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.EquivalentPupilRadius,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CornealTopographyMapTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VerticesOfTheOutlineOfPupil,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CornealTopographyMappingNormalsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MaximumCornealCurvatureSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MaximumCornealCurvature,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MaximumCornealCurvatureLocation,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MinimumKeratometricSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SimulatedKeratometricCylinderSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AverageCornealPower,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CornealISValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AnalyzedArea,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SurfaceRegularityIndex,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SurfaceAsymmetryIndex,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CornealEccentricityIndex,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.KeratoconusPredictionIndex,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.DecimalPotentialVisualAcuity,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CornealTopographyMapQualityEvaluation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SourceImageCornealProcessedDataSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CornealPointLocation,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CornealPointEstimated,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AxialPower,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TangentialPower,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RefractivePower,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RelativeElevation,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CornealWavefront,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ImagedVolumeWidth,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ImagedVolumeHeight,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ImagedVolumeDepth,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TotalPixelMatrixColumns,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TotalPixelMatrixRows,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TotalPixelMatrixOriginSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenLabelInImage,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FocusMethod,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ExtendedDepthOfField,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NumberOfFocalPlanes,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DistanceBetweenFocalPlanes,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RecommendedAbsentPixelCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.IlluminatorTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageOrientationSlide,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OpticalPathSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OpticalPathIdentifier,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.OpticalPathDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.IlluminationColorCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecimenReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CondenserLensPower,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ObjectiveLensPower,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ObjectiveLensNumericalAperture,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PaletteColorLookupTableSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedImageNavigationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TopLeftHandCornerOfLocalizerArea,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BottomRightHandCornerOfLocalizerArea,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OpticalPathIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PlanePositionSlideSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ColumnPositionInTotalImagePixelMatrix,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.RowPositionInTotalImagePixelMatrix,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.PixelOriginInterpretation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CalibrationImage,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentThickness,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DeviceLength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentWidth,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DeviceDiameter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeviceDiameterUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DeviceVolume,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.InterMarkerDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentMaterial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentLength,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentDiameter,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ContainerComponentDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DeviceDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ContrastBolusIngredientPercentByVolume,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.OCTFocalDistance,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.BeamSpotSize,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.EffectiveRefractiveIndex,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.OCTAcquisitionDomain,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OCTOpticalCenterWavelength,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.AxialResolution,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.RangingDepth,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ALineRate,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ALinesPerFrame,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CatheterRotationalRate,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ALinePixelSpacing,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ModeOfPercutaneousAccessSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IntravascularOCTFrameTypeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OCTZOffsetApplied,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IntravascularFrameContentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IntravascularLongitudinalDistance,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.IntravascularOCTFrameContentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OCTZOffsetCorrection,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.CatheterDirectionOfRotation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SeamLineLocation,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.FirstALineLocation,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.SeamLineIndex,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfPaddedALines,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.InterpolationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RefractiveIndexApplied,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfEnergyWindows,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowRangeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowLowerLimit,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowUpperLimit,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ResidualSyringeCounts,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.DetectorVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfDetectors,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DetectorInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PhaseVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfPhases,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PhaseInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumberOfFramesInPhase,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PhaseDelay,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PauseBetweenFrames,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PhaseDescription,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RotationVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfRotations,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RotationInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumberOfFramesInRotation,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RRIntervalVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfRRIntervals,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.GatedInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DataInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TimeSlotVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfTimeSlots,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TimeSlotInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TimeSlotTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SliceVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfSlices,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.AngularViewVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TimeSliceVector,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfTimeSlices,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.StartAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TypeOfDetectorMotion,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TriggerVector,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfTriggersInPhase,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ViewCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ViewModifierCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RadionuclideCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AdministrationRouteCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RadiopharmaceuticalCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CalibrationDataSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.EnergyWindowNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PatientOrientationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientOrientationModifierCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientGantryRelationshipCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SliceProgressionDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ScanProgressionDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SeriesType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Units,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CountsSource,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReprojectionMethod,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SUVType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RandomsCorrectionMethod,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AttenuationCorrectionMethod,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DecayCorrection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReconstructionMethod,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DetectorLinesOfResponseUsed,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ScatterCorrectionMethod,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AxialAcceptance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.AxialMash,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TransverseMash,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.DetectorElementSize,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CoincidenceWindowWidth,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SecondaryCountsType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FrameReferenceTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PrimaryPromptsCountsAccumulated,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.SecondaryCountsAccumulated,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.SliceSensitivityFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DecayFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DoseCalibrationFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ScatterFractionFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeadTimeFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImageIndex,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CountsIncluded,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DeadTimeCorrectionFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.HistogramSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.HistogramNumberOfBins,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.HistogramFirstBinValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.HistogramLastBinValue,ValueRepresentation.XS);
		valueRepresentationsByTag.put(TagFromName.HistogramBinWidth,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.HistogramExplanation,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.HistogramData,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SegmentationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SegmentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SegmentedPropertyCategoryCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SegmentNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.SegmentLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SegmentDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.SegmentAlgorithmType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SegmentAlgorithmName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SegmentIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedSegmentNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RecommendedDisplayGrayscaleValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RecommendedDisplayCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MaximumFractionalValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.SegmentedPropertyTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SegmentationFractionalType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SegmentedPropertyTypeModifierCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.UsedSegmentsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DeformableRegistrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SourceFrameOfReferenceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.DeformableRegistrationGridSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GridDimensions,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.GridResolution,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.VectorGridData,ValueRepresentation.OF);
		valueRepresentationsByTag.put(TagFromName.PreDeformationMatrixRegistrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PostDeformationMatrixRegistrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumberOfSurfaces,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SurfaceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SurfaceNumber,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SurfaceComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.SurfaceProcessing,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SurfaceProcessingRatio,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SurfaceProcessingDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RecommendedPresentationOpacity,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RecommendedPresentationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FiniteVolume,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Manifold,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SurfacePointsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SurfacePointsNormalsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SurfaceMeshPrimitivesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumberOfSurfacePoints,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.PointCoordinatesData,ValueRepresentation.OF);
		valueRepresentationsByTag.put(TagFromName.PointPositionAccuracy,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MeanPointDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MaximumPointDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PointsBoundingBoxCoordinates,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AxisOfRotation,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CenterOfRotation,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.NumberOfVectors,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.VectorDimensionality,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.VectorAccuracy,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.VectorCoordinateData,ValueRepresentation.OF);
		valueRepresentationsByTag.put(TagFromName.TrianglePointIndexList,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.EdgePointIndexList,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.VertexPointIndexList,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.TriangleStripSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TriangleFanSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LineSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrimitivePointIndexList,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.SurfaceCount,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.ReferencedSurfaceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedSurfaceNumber,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SegmentSurfaceGenerationAlgorithmIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SegmentSurfaceSourceInstanceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AlgorithmFamilyCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AlgorithmNameCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AlgorithmVersion,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AlgorithmParameters,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.FacetSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SurfaceProcessingAlgorithmIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AlgorithmName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RecommendedPointRadius,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RecommendedLineThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TrackSetSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TrackSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecommendedDisplayCIELabValueList,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.TrackingAlgorithmIdentificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TrackSetNumber,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TrackSetLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TrackSetDescription,ValueRepresentation.UT);
		valueRepresentationsByTag.put(TagFromName.TrackSetAnatomicalTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MeasurementsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TrackSetStatisticsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FloatingPointValues,ValueRepresentation.OF);
		valueRepresentationsByTag.put(TagFromName.TrackPointIndexList,ValueRepresentation.OL);
		valueRepresentationsByTag.put(TagFromName.TrackStatisticsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MeasurementValuesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DiffusionAcquisitionCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImplantSize,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ImplantTemplateVersion,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReplacedImplantTemplateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImplantType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DerivationImplantTemplateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OriginalImplantTemplateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.EffectiveDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ImplantTargetAnatomySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.InformationFromManufacturerSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NotificationFromManufacturerSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.InformationIssueDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.InformationSummary,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ImplantRegulatoryDisapprovalCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OverallTemplateSpatialTolerance,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.HPGLDocumentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.HPGLDocumentID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.HPGLDocumentLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ViewOrientationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ViewOrientationModifier,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.HPGLDocumentScaling,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.HPGLDocument,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.HPGLContourPenNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.HPGLPenSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.HPGLPenNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.HPGLPenLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.HPGLPenDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.RecommendedRotationPoint,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.BoundingRectangle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ImplantTemplate3DModelSurfaceNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.SurfaceModelDescriptionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SurfaceModelLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SurfaceModelScalingFactor,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MaterialsCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CoatingMaterialsCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImplantTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FixationMethodCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MatingFeatureSetsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MatingFeatureSetID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MatingFeatureSetLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MatingFeatureSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MatingFeatureID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MatingFeatureDegreeOfFreedomSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DegreeOfFreedomID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DegreeOfFreedomType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TwoDMatingFeatureCoordinatesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedHPGLDocumentID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TwoDMatingPoint,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TwoDMatingAxes,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TwoDDegreeOfFreedomSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ThreeDDegreeOfFreedomAxis,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.RangeOfFreedom,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ThreeDMatingPoint,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ThreeDMatingAxes,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TwoDDegreeOfFreedomAxis,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.PlanningLandmarkPointSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PlanningLandmarkLineSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PlanningLandmarkPlaneSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PlanningLandmarkID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PlanningLandmarkDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PlanningLandmarkIdentificationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TwoDPointCoordinatesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TwoDPointCoordinates,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ThreeDPointCoordinates,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TwoDLineCoordinatesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TwoDLineCoordinates,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ThreeDLineCoordinates,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TwoDPlaneCoordinatesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TwoDPlaneIntersection,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ThreeDPlaneOrigin,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ThreeDPlaneNormal,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.GraphicAnnotationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GraphicLayer,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BoundingBoxAnnotationUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AnchorPointAnnotationUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GraphicAnnotationUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.UnformattedTextValue,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.TextObjectSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GraphicObjectSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BoundingBoxTopLeftHandCorner,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BoundingBoxBottomRightHandCorner,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BoundingBoxTextHorizontalJustification,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AnchorPoint,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AnchorPointVisibility,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GraphicDimensions,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfGraphicPoints,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.GraphicData,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.GraphicType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GraphicFilled,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageRotationRetired,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ImageHorizontalFlip,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageRotation,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DisplayedAreaTopLeftHandCornerTrial,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DisplayedAreaBottomRightHandCornerTrial,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DisplayedAreaTopLeftHandCorner,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.DisplayedAreaBottomRightHandCorner,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.DisplayedAreaSelectionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GraphicLayerSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GraphicLayerOrder,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.GraphicLayerRecommendedDisplayGrayscaleValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.GraphicLayerRecommendedDisplayRGBValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.GraphicLayerDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ContentLabel,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContentDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PresentationCreationDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.PresentationCreationTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ContentCreatorName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.ContentCreatorIdentificationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AlternateContentDescriptionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PresentationSizeMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PresentationPixelSpacing,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PresentationPixelAspectRatio,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PresentationPixelMagnificationRatio,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.GraphicGroupLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.GraphicGroupDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.CompoundGraphicSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CompoundGraphicInstanceID,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.FontName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.FontNameType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CSSFontName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RotationAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TextStyleSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LineStyleSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FillStyleSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GraphicGroupSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TextColorCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.HorizontalAlignment,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VerticalAlignment,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShadowStyle,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShadowOffsetX,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ShadowOffsetY,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ShadowColorCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Underlined,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Bold,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Italic,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatternOnColorCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PatternOffColorCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.LineThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.LineDashingStyle,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LinePattern,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.FillPattern,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.FillMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShadowOpacity,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.GapLength,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.DiameterOfVisibility,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RotationPoint,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TickAlignment,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShowTickLabel,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TickLabelAlignment,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CompoundGraphicUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatternOnOpacity,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PatternOffOpacity,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MajorTicksSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TickPosition,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TickLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CompoundGraphicType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GraphicGroupID,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.ShapeType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RegistrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MatrixRegistrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MatrixSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FrameOfReferenceToDisplayedCoordinateSystemTransformationMatrix,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.FrameOfReferenceTransformationMatrixType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RegistrationTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FiducialDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.FiducialIdentifier,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.FiducialIdentifierCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContourUncertaintyRadius,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.UsedFiducialsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GraphicCoordinatesDataSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FiducialUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.FiducialSetSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FiducialSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GraphicLayerRecommendedDisplayCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BlendingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RelativeOpacity,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ReferencedSpatialRegistrationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BlendingPosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PresentationDisplayCollectionUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.PresentationSequenceCollectionUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.PresentationSequencePositionIndex,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RenderedImageReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VolumetricPresentationStateInputSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PresentationInputType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InputSequencePositionIndex,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Crop,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CroppingSpecificationIndex,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CompositingMethod,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VolumetricPresentationInputNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageVolumeGeometry,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VolumeCroppingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VolumeCroppingMethod,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BoundingBoxCrop,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ObliqueCroppingPlaneSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ObliqueCroppingPlane,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ObliqueCroppingPlaneNormal,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.CroppingSpecificationNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MultiPlanarReconstructionStyle,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MPRThicknessType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MPRSlabThickness,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MPRTopLeftHandCorner,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MPRViewWidthDirection,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MPRViewWidth,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.NumberOfVolumetricCurvePoints,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.VolumetricCurvePoints,ValueRepresentation.OD);
		valueRepresentationsByTag.put(TagFromName.MPRViewHeightDirection,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.MPRViewHeight,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.PresentationStateClassificationComponentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ComponentType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ComponentInputSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VolumetricPresentationInputIndex,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PresentationStateCompositorComponentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.WeightingTransferFunctionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.WeightingLookupTableDescriptor,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.WeightingLookupTableData,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.VolumetricAnnotationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedStructuredContextSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedContentItem,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.VolumetricPresentationInputAnnotationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnnotationClipping,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PresentationAnimationStyle,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RecommendedAnimationRate,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.AnimationCurveSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnimationStepSize,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.HangingProtocolName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.HangingProtocolDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.HangingProtocolLevel,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.HangingProtocolCreator,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.HangingProtocolCreationDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.HangingProtocolDefinitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.HangingProtocolUserIdentificationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.HangingProtocolUserGroupName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SourceHangingProtocolSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumberOfPriorsReferenced,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageSetsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageSetSelectorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageSetSelectorUsageFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SelectorAttribute,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.SelectorValueNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TimeBasedImageSetsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageSetNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageSetSelectorCategory,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RelativeTime,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RelativeTimeUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AbstractPriorValue,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.AbstractPriorCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageSetLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SelectorAttributeVR,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SelectorSequencePointer,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.SelectorSequencePointerPrivateCreator,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SelectorAttributePrivateCreator,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SelectorATValue,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.SelectorCSValue,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SelectorISValue,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.SelectorLOValue,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SelectorLTValue,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.SelectorPNValue,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.SelectorSHValue,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SelectorSTValue,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.SelectorUTValue,ValueRepresentation.UT);
		valueRepresentationsByTag.put(TagFromName.SelectorDSValue,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SelectorFDValue,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.SelectorFLValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SelectorULValue,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SelectorUSValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.SelectorSLValue,ValueRepresentation.SL);
		valueRepresentationsByTag.put(TagFromName.SelectorSSValue,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.SelectorUIValue,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.SelectorCodeSequenceValue,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumberOfScreens,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NominalScreenDefinitionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NumberOfVerticalPixels,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfHorizontalPixels,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DisplayEnvironmentSpatialPosition,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ScreenMinimumGrayscaleBitDepth,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ScreenMinimumColorBitDepth,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ApplicationMaximumRepaintTime,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DisplaySetsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DisplaySetNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DisplaySetLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DisplaySetPresentationGroup,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DisplaySetPresentationGroupDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PartialDataDisplayHandling,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SynchronizedScrollingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DisplaySetScrollingGroup,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NavigationIndicatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.NavigationDisplaySet,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ReferenceDisplaySets,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageBoxesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageBoxNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageBoxLayoutType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageBoxTileHorizontalDimension,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageBoxTileVerticalDimension,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageBoxScrollDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageBoxSmallScrollType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageBoxSmallScrollAmount,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageBoxLargeScrollType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageBoxLargeScrollAmount,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImageBoxOverlapPriority,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CineRelativeToRealTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.FilterOperationsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FilterByCategory,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FilterByAttributePresence,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FilterByOperator,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.StructuredDisplayBackgroundCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.EmptyImageBoxCIELabValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.StructuredDisplayImageBoxSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StructuredDisplayTextBoxSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedFirstFrameSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageBoxSynchronizationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SynchronizedImageBoxList,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TypeOfSynchronization,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BlendingOperationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReformattingOperationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReformattingThickness,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ReformattingInterval,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ReformattingOperationInitialViewDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ThreeDRenderingType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SortingOperationsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SortByCategory,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SortingDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DisplaySetPatientOrientation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VOIType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PseudoColorType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PseudoColorPaletteInstanceReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ShowGrayscaleInverted,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShowImageTrueSizeFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShowGraphicAnnotationFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShowPatientDemographicsFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShowAcquisitionTechniquesFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DisplaySetHorizontalJustification,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DisplaySetVerticalJustification,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContinuationStartMeterset,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ContinuationEndMeterset,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ProcedureStepState,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ProcedureStepProgressInformationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ProcedureStepProgress,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ProcedureStepProgressDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ProcedureStepCommunicationsURISequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContactURI,ValueRepresentation.UR);
		valueRepresentationsByTag.put(TagFromName.ContactDisplayName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ProcedureStepDiscontinuationReasonCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BeamTaskSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BeamTaskType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BeamOrderIndexTrial,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AutosequenceFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TableTopVerticalAdjustedPosition,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TableTopLongitudinalAdjustedPosition,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TableTopLateralAdjustedPosition,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.PatientSupportAdjustedAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TableTopEccentricAdjustedAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TableTopPitchAdjustedAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TableTopRollAdjustedAngle,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DeliveryVerificationImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.VerificationImageTiming,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DoubleExposureFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DoubleExposureOrdering,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DoubleExposureMetersetTrial,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DoubleExposureFieldDeltaTrial,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RelatedReferenceRTImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GeneralMachineVerificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ConventionalMachineVerificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IonMachineVerificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FailedAttributesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OverriddenAttributesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ConventionalControlPointVerificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IonControlPointVerificationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AttributeOccurrenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AttributeOccurrencePointer,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.AttributeItemSelector,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.AttributeOccurrencePrivateCreator,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SelectorSequencePointerItems,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcedureStepPriority,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.WorklistLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ProcedureStepLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ScheduledProcessingParametersSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerformedProcessingParametersSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.UnifiedProcedureStepPerformedProcedureSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RelatedProcedureStepSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ProcedureStepRelationshipType,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReplacedProcedureStepSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DeletionLock,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReceivingAE,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.RequestingAE,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.ReasonForCancellation,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.SCPStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SubscriptionListStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.UnifiedProcedureStepListStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BeamOrderIndex,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.DoubleExposureMeterset,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.DoubleExposureFieldDelta,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.BrachyTaskSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContinuationStartTotalReferenceAirKerma,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ContinuationEndTotalReferenceAirKerma,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ContinuationPulseNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ChannelDeliveryOrderSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedChannelNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.StartCumulativeTimeWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EndCumulativeTimeWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OmittedChannelSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReasonForChannelOmission,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReasonForChannelOmissionDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ChannelDeliveryOrderIndex,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ChannelDeliveryContinuationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OmittedApplicationSetupSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImplantAssemblyTemplateName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ImplantAssemblyTemplateIssuer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ImplantAssemblyTemplateVersion,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReplacedImplantAssemblyTemplateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImplantAssemblyTemplateType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OriginalImplantAssemblyTemplateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DerivationImplantAssemblyTemplateSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImplantAssemblyTemplateTargetAnatomySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ProcedureTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SurgicalTechnique,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ComponentTypesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ComponentTypeCodeSequence,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ExclusiveComponentType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MandatoryComponentType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ComponentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ComponentID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ComponentAssemblySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.Component1ReferencedID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Component1ReferencedMatingFeatureSetID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Component1ReferencedMatingFeatureID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Component2ReferencedID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Component2ReferencedMatingFeatureSetID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Component2ReferencedMatingFeatureID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImplantTemplateGroupName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ImplantTemplateGroupDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ImplantTemplateGroupIssuer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ImplantTemplateGroupVersion,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReplacedImplantTemplateGroupSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImplantTemplateGroupTargetAnatomySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImplantTemplateGroupMembersSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImplantTemplateGroupMemberID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ThreeDImplantTemplateGroupMemberMatchingPoint,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ThreeDImplantTemplateGroupMemberMatchingAxes,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ImplantTemplateGroupMemberMatching2DCoordinatesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TwoDImplantTemplateGroupMemberMatchingPoint,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.TwoDImplantTemplateGroupMemberMatchingAxes,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ImplantTemplateGroupVariationDimensionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImplantTemplateGroupVariationDimensionName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ImplantTemplateGroupVariationDimensionRankSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedImplantTemplateGroupMemberID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ImplantTemplateGroupVariationDimensionRank,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.SurfaceScanAcquisitionTypeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SurfaceScanModeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RegistrationMethodCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ShotDurationTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ShotOffsetTime,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.SurfacePointPresentationValueData,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.SurfacePointColorCIELabValueData,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.UVMappingSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TextureLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.UValueData,ValueRepresentation.OF);
		valueRepresentationsByTag.put(TagFromName.VValueData,ValueRepresentation.OF);
		valueRepresentationsByTag.put(TagFromName.ReferencedTextureSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedSurfaceDataSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StorageMediaFileSetID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.StorageMediaFileSetUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.IconImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TopicTitle,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TopicSubject,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.TopicAuthor,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TopicKeywords,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SOPInstanceStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SOPAuthorizationDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.SOPAuthorizationComment,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.AuthorizationEquipmentCertificationNumber,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MACIDNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MACCalculationTransferSyntaxUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.MACAlgorithm,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DataElementsSigned,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.DigitalSignatureUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.DigitalSignatureDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.CertificateType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CertificateOfSigner,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.Signature,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.CertifiedTimestampType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CertifiedTimestamp,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.DigitalSignaturePurposeCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedDigitalSignatureSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedSOPInstanceMACSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MAC,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.EncryptedAttributesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.EncryptedContentTransferSyntaxUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.EncryptedContent,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.ModifiedAttributesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OriginalAttributesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AttributeModificationDateTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.ModifyingSystem,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SourceOfPreviousValues,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReasonForTheAttributeModification,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ZonalMap,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfCopies,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PrinterConfigurationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrintPriority,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MediumType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FilmDestination,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FilmSessionLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MemoryAllocation,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.MaximumMemoryAllocation,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ColorImagePrintingFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CollationFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AnnotationFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageOverlayFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PresentationLUTFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ImageBoxPresentationLUTFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MemoryBitDepth,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PrintingBitDepth,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MediaInstalledSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OtherMediaAvailableSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SupportedImageDisplayFormatsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedFilmBoxSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedStoredPrintSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageDisplayFormat,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.AnnotationDisplayFormatID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FilmOrientation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FilmSizeID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PrinterResolutionID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DefaultPrinterResolutionID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MagnificationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SmoothingType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DefaultMagnificationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OtherMagnificationTypesAvailable,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DefaultSmoothingType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OtherSmoothingTypesAvailable,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BorderDensity,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.EmptyImageDensity,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MinDensity,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MaxDensity,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Trim,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ConfigurationInformation,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ConfigurationInformationDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.MaximumCollatedFilms,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.Illumination,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ReflectedAmbientLight,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PrinterPixelSpacing,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ReferencedFilmSessionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedImageBoxSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedBasicAnnotationBoxSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageBoxPosition,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.Polarity,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RequestedImageSize,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RequestedDecimateCropBehavior,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RequestedResolutionID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RequestedImageSizeFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DecimateCropResult,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BasicGrayscaleImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BasicColorImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedImageOverlayBoxSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedVOILUTBoxSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnnotationPosition,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TextString,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReferencedOverlayPlaneSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedOverlayPlaneGroups,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayPixelDataSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OverlayMagnificationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlaySmoothingType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlayOrImageMagnification,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MagnifyToNumberOfColumns,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayForegroundDensity,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlayBackgroundDensity,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlayMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ThresholdDensity,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReferencedImageBoxSequenceRetired,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PresentationLUTSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PresentationLUTShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReferencedPresentationLUTSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrintJobID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ExecutionStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ExecutionStatusInfo,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CreationDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.CreationTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.Originator,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.DestinationAE,ValueRepresentation.AE);
		valueRepresentationsByTag.put(TagFromName.OwnerID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.NumberOfFilms,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedPrintJobSequencePullStoredPrint,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrinterStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PrinterStatusInfo,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PrinterName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PrintQueueID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.QueueStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PrintJobDescriptionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedPrintJobSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrintManagementCapabilitiesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PrinterCharacteristicsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FilmBoxContentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageBoxContentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnnotationContentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImageOverlayBoxContentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PresentationLUTContentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ProposedStudySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.OriginalImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LabelUsingInformationExtractedFromInstances,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LabelText,ValueRepresentation.UT);
		valueRepresentationsByTag.put(TagFromName.LabelStyleSelection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MediaDisposition,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.BarcodeValue,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.BarcodeSymbology,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AllowMediaSplitting,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IncludeNonDICOMObjects,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.IncludeDisplayApplication,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PreserveCompositeInstancesAfterMediaCreation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TotalNumberOfPiecesOfMediaCreated,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.RequestedMediaApplicationProfile,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReferencedStorageMediaSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FailureAttributes,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.AllowLossyCompression,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RequestPriority,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RTImageLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.RTImageName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RTImageDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ReportedValuesOrigin,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RTImagePlane,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.XRayImageReceptorTranslation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.XRayImageReceptorAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RTImageOrientation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ImagePlanePixelSpacing,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RTImagePosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadiationMachineName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.RadiationMachineSAD,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RadiationMachineSSD,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RTImageSID,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceToReferenceObjectDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FractionNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ExposureSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MetersetExposure,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DiaphragmPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FluenceMapSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FluenceDataSource,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FluenceDataScale,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PrimaryFluenceModeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FluenceMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FluenceModeID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.DVHType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DoseUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DoseType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SpatialTransformOfDose,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DoseComment,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.NormalizationPoint,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DoseSummationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GridFrameOffsetVector,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DoseGridScaling,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RTDoseROISequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DoseValue,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TissueHeterogeneityCorrection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DVHNormalizationPoint,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DVHNormalizationDoseValue,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DVHSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DVHDoseScaling,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DVHVolumeUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DVHNumberOfBins,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.DVHData,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DVHReferencedROISequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DVHROIContributionType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DVHMinimumDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DVHMaximumDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DVHMeanDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.StructureSetLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.StructureSetName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.StructureSetDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.StructureSetDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.StructureSetTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ReferencedFrameOfReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RTReferencedStudySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RTReferencedSeriesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContourImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PredecessorStructureSetSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.StructureSetROISequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ROINumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedFrameOfReferenceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.ROIName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ROIDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ROIDisplayColor,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ROIVolume,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RTRelatedROISequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RTROIRelationship,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ROIGenerationAlgorithm,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ROIGenerationDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ROIContourSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContourSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ContourGeometricType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ContourSlabThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ContourOffsetVector,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NumberOfContourPoints,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ContourNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.AttachedContours,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ContourData,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RTROIObservationsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ObservationNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedROINumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ROIObservationLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.RTROIIdentificationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ROIObservationDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.RelatedRTROIObservationsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RTROIInterpretedType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ROIInterpreter,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.ROIPhysicalPropertiesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ROIPhysicalProperty,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ROIPhysicalPropertyValue,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ROIElementalCompositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ROIElementalCompositionAtomicNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ROIElementalCompositionAtomicMassFraction,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AdditionalRTROIClassificationCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FrameOfReferenceRelationshipSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RelatedFrameOfReferenceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.FrameOfReferenceTransformationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FrameOfReferenceTransformationMatrix,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FrameOfReferenceTransformationComment,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.MeasuredDoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.MeasuredDoseDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.MeasuredDoseType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.MeasuredDoseValue,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TreatmentSessionBeamSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TreatmentSessionIonBeamSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CurrentFractionNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TreatmentControlPointDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.TreatmentControlPointTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.TreatmentTerminationStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TreatmentTerminationCode,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.TreatmentVerificationStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReferencedTreatmentRecordSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecifiedPrimaryMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SpecifiedSecondaryMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeliveredPrimaryMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeliveredSecondaryMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SpecifiedTreatmentTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeliveredTreatmentTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ControlPointDeliverySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IonControlPointDeliverySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecifiedMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeliveredMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MetersetRateSet,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MetersetRateDelivered,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ScanSpotMetersetsDelivered,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.DoseRateDelivered,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TreatmentSummaryCalculatedDoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CumulativeDoseToDoseReference,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FirstTreatmentDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.MostRecentTreatmentDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.NumberOfFractionsDelivered,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.OverrideSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ParameterSequencePointer,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.OverrideParameterPointer,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.ParameterItemIndex,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.MeasuredDoseReferenceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ParameterPointer,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.OverrideReason,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.CorrectedParameterSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CorrectionValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CalculatedDoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CalculatedDoseReferenceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CalculatedDoseReferenceDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.CalculatedDoseReferenceDoseValue,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.StartMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EndMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ReferencedMeasuredDoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedMeasuredDoseReferenceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedCalculatedDoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedCalculatedDoseReferenceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BeamLimitingDeviceLeafPairsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecordedWedgeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecordedCompensatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecordedBlockSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TreatmentSummaryMeasuredDoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecordedSnoutSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecordedRangeShifterSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecordedLateralSpreadingDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecordedRangeModulatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RecordedSourceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SourceSerialNumber,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TreatmentSessionApplicationSetupSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ApplicationSetupCheck,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RecordedBrachyAccessoryDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedBrachyAccessoryDeviceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RecordedChannelSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SpecifiedChannelTotalTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeliveredChannelTotalTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SpecifiedNumberOfPulses,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.DeliveredNumberOfPulses,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.SpecifiedPulseRepetitionInterval,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeliveredPulseRepetitionInterval,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RecordedSourceApplicatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedSourceApplicatorNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RecordedChannelShieldSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedChannelShieldNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BrachyControlPointDeliveredSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SafePositionExitDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.SafePositionExitTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.SafePositionReturnDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.SafePositionReturnTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.PulseSpecificBrachyControlPointDeliveredSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PulseNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.BrachyPulseControlPointDeliveredSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CurrentTreatmentStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TreatmentStatusComment,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.FractionGroupSummarySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedFractionNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.FractionGroupType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BeamStopperPosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FractionStatusSummarySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TreatmentDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.TreatmentTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.RTPlanLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.RTPlanName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RTPlanDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.RTPlanDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.RTPlanTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.TreatmentProtocols,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PlanIntent,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TreatmentSites,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RTPlanGeometry,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PrescriptionDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.DoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DoseReferenceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.DoseReferenceUID,ValueRepresentation.UI);
		valueRepresentationsByTag.put(TagFromName.DoseReferenceStructureType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NominalBeamEnergyUnit,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DoseReferenceDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.DoseReferencePointCoordinates,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NominalPriorDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DoseReferenceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ConstraintWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeliveryWarningDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DeliveryMaximumDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TargetMinimumDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TargetPrescriptionDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TargetMaximumDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TargetUnderdoseVolumeFraction,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OrganAtRiskFullVolumeDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OrganAtRiskLimitDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OrganAtRiskMaximumDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OrganAtRiskOverdoseVolumeFraction,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ToleranceTableSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ToleranceTableNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ToleranceTableLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.GantryAngleTolerance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamLimitingDeviceAngleTolerance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamLimitingDeviceToleranceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BeamLimitingDevicePositionTolerance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SnoutPositionTolerance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PatientSupportAngleTolerance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopEccentricAngleTolerance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopPitchAngleTolerance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableTopRollAngleTolerance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableTopVerticalPositionTolerance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopLongitudinalPositionTolerance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopLateralPositionTolerance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.RTPlanRelationship,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FractionGroupSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FractionGroupNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.FractionGroupDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.NumberOfFractionsPlanned,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NumberOfFractionPatternDigitsPerDay,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RepeatFractionCycleLength,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.FractionPattern,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.NumberOfBeams,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BeamDoseSpecificationPoint,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamMeterset,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamDosePointDepth,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BeamDosePointEquivalentDepth,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BeamDosePointSSD,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BeamDoseMeaning,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BeamDoseVerificationControlPointSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AverageBeamDosePointDepth,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AverageBeamDosePointEquivalentDepth,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AverageBeamDosePointSSD,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BeamDoseType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AlternateBeamDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.AlternateBeamDoseType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NumberOfBrachyApplicationSetups,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BrachyApplicationSetupDoseSpecificationPoint,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BrachyApplicationSetupDose,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TreatmentMachineName,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PrimaryDosimeterUnit,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SourceAxisDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamLimitingDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RTBeamLimitingDeviceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SourceToBeamLimitingDeviceDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.IsocenterToBeamLimitingDeviceDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.NumberOfLeafJawPairs,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.LeafPositionBoundaries,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BeamName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.BeamDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.BeamType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BeamDeliveryDurationLimit,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.RadiationType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.HighDoseTechniqueType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReferenceImageNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PlannedVerificationImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ImagingDeviceSpecificAcquisitionParameters,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TreatmentDeliveryType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NumberOfWedges,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.WedgeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.WedgeNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.WedgeType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.WedgeID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.WedgeAngle,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.WedgeFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TotalWedgeTrayWaterEquivalentThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.WedgeOrientation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.IsocenterToWedgeTrayDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SourceToWedgeTrayDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgeThinEdgePosition,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BolusID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.BolusDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.EffectiveWedgeAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NumberOfCompensators,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.MaterialID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.TotalCompensatorTrayFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CompensatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CompensatorNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CompensatorID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SourceToCompensatorTrayDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CompensatorRows,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CompensatorColumns,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CompensatorPixelSpacing,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CompensatorPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CompensatorTransmissionData,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CompensatorThicknessData,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NumberOfBoli,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.CompensatorType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CompensatorTrayID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.NumberOfBlocks,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TotalBlockTrayFactor,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TotalBlockTrayWaterEquivalentThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BlockSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BlockTrayID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SourceToBlockTrayDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.IsocenterToBlockTrayDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BlockType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AccessoryCode,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.BlockDivergence,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BlockMountingPosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BlockNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BlockName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.BlockThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BlockTransmission,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BlockNumberOfPoints,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BlockData,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ApplicatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ApplicatorID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ApplicatorType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ApplicatorDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CumulativeDoseReferenceCoefficient,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FinalCumulativeMetersetWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.NumberOfControlPoints,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ControlPointSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ControlPointIndex,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.NominalBeamEnergy,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.DoseRateSet,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.WedgePositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.WedgePosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BeamLimitingDevicePositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LeafJawPositions,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.GantryAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.GantryRotationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BeamLimitingDeviceAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BeamLimitingDeviceRotationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatientSupportAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.PatientSupportRotationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TableTopEccentricAxisDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopEccentricAngle,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopEccentricRotationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TableTopVerticalPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopLongitudinalPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopLateralPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.IsocenterPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SurfaceEntryPoint,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceToSurfaceDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.AverageBeamDosePointSourceToExternalContourSurfaceDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SourceToExternalContourDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ExternalContourEntryPoint,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CumulativeMetersetWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopPitchAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableTopPitchRotationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TableTopRollAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.TableTopRollRotationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.HeadFixationAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.GantryPitchAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.GantryPitchRotationDirection,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GantryPitchAngleTolerance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PatientSetupSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PatientSetupNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PatientSetupLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.PatientAdditionalPosition,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.FixationDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.FixationDeviceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.FixationDeviceLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.FixationDeviceDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.FixationDevicePosition,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.FixationDevicePitchAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.FixationDeviceRollAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ShieldingDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ShieldingDeviceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ShieldingDeviceLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ShieldingDeviceDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ShieldingDevicePosition,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SetupTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SetupTechniqueDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.SetupDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SetupDeviceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SetupDeviceLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SetupDeviceDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.SetupDeviceParameter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SetupReferenceDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.TableTopVerticalSetupDisplacement,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopLongitudinalSetupDisplacement,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TableTopLateralSetupDisplacement,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BrachyTreatmentTechnique,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BrachyTreatmentType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.TreatmentMachineSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SourceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SourceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.SourceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SourceManufacturer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ActiveSourceDiameter,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ActiveSourceLength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceModelID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SourceDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SourceEncapsulationNominalThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceEncapsulationNominalTransmission,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceIsotopeName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SourceIsotopeHalfLife,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceStrengthUnits,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReferenceAirKermaRate,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceStrength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceStrengthReferenceDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.SourceStrengthReferenceTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ApplicationSetupSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ApplicationSetupType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ApplicationSetupNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ApplicationSetupName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ApplicationSetupManufacturer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TemplateNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TemplateType,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.TemplateName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.TotalReferenceAirKerma,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BrachyAccessoryDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BrachyAccessoryDeviceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BrachyAccessoryDeviceID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.BrachyAccessoryDeviceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BrachyAccessoryDeviceName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.BrachyAccessoryDeviceNominalThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BrachyAccessoryDeviceNominalTransmission,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ChannelLength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelTotalTime,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceMovementType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NumberOfPulses,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.PulseRepetitionInterval,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorLength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorManufacturer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorWallNominalThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorWallNominalTransmission,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.SourceApplicatorStepSize,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TransferTubeNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.TransferTubeLength,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelShieldSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelShieldNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ChannelShieldID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ChannelShieldName,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ChannelShieldNominalThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ChannelShieldNominalTransmission,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.FinalCumulativeTimeWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BrachyControlPointSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ControlPointRelativePosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ControlPoint3DPosition,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CumulativeTimeWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.CompensatorDivergence,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CompensatorMountingPosition,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SourceToCompensatorDistance,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.TotalCompensatorTrayWaterEquivalentThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IsocenterToCompensatorTrayDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CompensatorColumnOffset,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IsocenterToCompensatorDistances,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CompensatorRelativeStoppingPowerRatio,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CompensatorMillingToolDiameter,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IonRangeCompensatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CompensatorDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.RadiationMassNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RadiationAtomicNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RadiationChargeState,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.ScanMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ModulatedScanModeType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VirtualSourceAxisDistances,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SnoutSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SnoutPosition,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SnoutID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.NumberOfRangeShifters,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RangeShifterSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RangeShifterNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RangeShifterID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.RangeShifterType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RangeShifterDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.NumberOfLateralSpreadingDevices,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.LateralSpreadingDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LateralSpreadingDeviceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.LateralSpreadingDeviceID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.LateralSpreadingDeviceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.LateralSpreadingDeviceDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.LateralSpreadingDeviceWaterEquivalentThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.NumberOfRangeModulators,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.BeamCurrentModulationID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PatientSupportType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.PatientSupportID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.PatientSupportAccessoryCode,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.FixationLightAzimuthalAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.FixationLightPolarAngle,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.MetersetRate,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RangeShifterSettingsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RangeShifterSetting,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IsocenterToRangeShifterDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RangeShifterWaterEquivalentThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.LateralSpreadingDeviceSettingsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.LateralSpreadingDeviceSetting,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.IsocenterToLateralSpreadingDeviceDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorSettingsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorGatingStartValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorGatingStopValue,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorGatingStartWaterEquivalentThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RangeModulatorGatingStopWaterEquivalentThickness,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.IsocenterToRangeModulatorDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ScanSpotTuneID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.NumberOfScanSpotPositions,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ScanSpotPositionMap,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ScanSpotMetersetWeights,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ScanningSpotSize,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.NumberOfPaintings,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.IonToleranceTableSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IonBeamSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IonBeamLimitingDeviceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IonBlockSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IonControlPointSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IonWedgeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.IonWedgePositionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedSetupImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SetupImageComment,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.MotionSynchronizationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ControlPointOrientation,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.GeneralAccessorySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.GeneralAccessoryID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.GeneralAccessoryDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.GeneralAccessoryType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.GeneralAccessoryNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.SourceToGeneralAccessoryDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ApplicatorGeometrySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ApplicatorApertureShape,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ApplicatorOpening,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ApplicatorOpeningX,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ApplicatorOpeningY,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SourceToApplicatorMountingPositionDistance,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.NumberOfBlockSlabItems,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BlockSlabSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.BlockSlabThickness,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.BlockSlabNumber,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.DeviceMotionControlSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DeviceMotionExecutionMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DeviceMotionObservationMode,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DeviceMotionParameterCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedRTPlanSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedBeamSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedBeamNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedReferenceImageNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.StartCumulativeMetersetWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.EndCumulativeMetersetWeight,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ReferencedBrachyApplicationSetupSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedBrachyApplicationSetupNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedSourceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedFractionGroupSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedFractionGroupNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedVerificationImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedReferenceImageSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedDoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedDoseReferenceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.BrachyReferencedDoseReferenceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedStructureSetSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedPatientSetupNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedDoseSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedToleranceTableNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedBolusSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedWedgeNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedCompensatorNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedBlockNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedControlPointIndex,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedControlPointSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedStartControlPointIndex,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedStopControlPointIndex,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedRangeShifterNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedLateralSpreadingDeviceNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ReferencedRangeModulatorNumber,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.OmittedBeamTaskSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReasonForOmission,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReasonForOmissionDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ApprovalStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ReviewDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.ReviewTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.ReviewerName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.Arbitrary,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.TextComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ResultsID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ResultsIDIssuer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ReferencedInterpretationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReportProductionStatusTrial,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InterpretationRecordedDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.InterpretationRecordedTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.InterpretationRecorder,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.ReferenceToRecordedSound,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.InterpretationTranscriptionDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.InterpretationTranscriptionTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.InterpretationTranscriber,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.InterpretationText,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.InterpretationAuthor,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.InterpretationApproverSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.InterpretationApprovalDate,ValueRepresentation.DA);
		valueRepresentationsByTag.put(TagFromName.InterpretationApprovalTime,ValueRepresentation.TM);
		valueRepresentationsByTag.put(TagFromName.PhysicianApprovingInterpretation,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.InterpretationDiagnosisDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.InterpretationDiagnosisCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ResultsDistributionListSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DistributionName,ValueRepresentation.PN);
		valueRepresentationsByTag.put(TagFromName.DistributionAddress,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.InterpretationID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.InterpretationIDIssuer,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.InterpretationTypeID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InterpretationStatusID,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.Impressions,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.ResultsComments,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.LowEnergyDetectors,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.HighEnergyDetectors,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DetectorGeometrySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ThreatROIVoxelSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ThreatROIBase,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ThreatROIExtents,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ThreatROIBitmap,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.RouteSegmentID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.GantryType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OOIOwnerType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RouteSegmentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PotentialThreatObjectID,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ThreatSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ThreatCategory,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ThreatCategoryDescription,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.ATDAbilityAssessment,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ATDAssessmentFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ATDAssessmentProbability,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.Mass,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.Density,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.ZEffective,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BoardingPassID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CenterOfMass,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.CenterOfPTO,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BoundingPolygon,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.RouteSegmentStartLocationID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.RouteSegmentEndLocationID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.RouteSegmentLocationIDType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AbortReason,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.VolumeOfPTO,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AbortFlag,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.RouteSegmentStartTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.RouteSegmentEndTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.TDRType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.InternationalRouteSegment,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ThreatDetectionAlgorithmAndVersion,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AssignedLocation,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.AlarmDecisionTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.AlarmDecision,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.NumberOfTotalObjects,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfAlarmObjects,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.PTORepresentationSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ATDAssessmentSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TIPType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.DICOSVersion,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OOIOwnerCreationTime,ValueRepresentation.DT);
		valueRepresentationsByTag.put(TagFromName.OOIType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OOISize,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AcquisitionStatus,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.BasisMaterialsCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PhantomType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OOIOwnerSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ScanType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.ItineraryID,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.ItineraryIDType,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.ItineraryIDAssigningAuthority,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.RouteID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.RouteIDAssigningAuthority,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.InboundArrivalType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CarrierID,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CarrierIDAssigningAuthority,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SourceOrientation,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.SourcePosition,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.BeltHeight,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.AlgorithmRoutingCodeSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TransportClassification,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OOITypeDescriptor,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.TotalProcessingTime,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.DetectorCalibrationData,ValueRepresentation.OB);
		valueRepresentationsByTag.put(TagFromName.AdditionalScreeningPerformed,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AdditionalInspectionSelectionCriteria,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AdditionalInspectionMethodSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AITDeviceType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.QRMeasurementsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.TargetMaterialSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.SNRThreshold,ValueRepresentation.FD);
		valueRepresentationsByTag.put(TagFromName.ImageScaleRepresentation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ReferencedPTOSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ReferencedTDRInstanceSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PTOLocationDescription,ValueRepresentation.ST);
		valueRepresentationsByTag.put(TagFromName.AnomalyLocatorIndicatorSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.AnomalyLocatorIndicator,ValueRepresentation.FL);
		valueRepresentationsByTag.put(TagFromName.PTORegionSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.InspectionSelectionCriteria,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.SecondaryInspectionMethodSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PRCSToRCSOrientation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.MACParametersSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CurveDimensions,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfPoints,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.TypeOfData,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.CurveDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.AxisUnits,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.AxisLabels,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.DataValueRepresentation,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MinimumCoordinateValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.MaximumCoordinateValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CurveRange,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.CurveDataDescriptor,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CoordinateStartValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CoordinateStepValue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CurveActivationLayer,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.AudioType,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.AudioSampleFormat,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfChannels,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfSamples,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.SampleRate,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.TotalTime,ValueRepresentation.UL);
		valueRepresentationsByTag.put(TagFromName.AudioSampleData,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.AudioComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.CurveLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.CurveReferencedOverlaySequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.CurveReferencedOverlayGroup,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.CurveData,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.SharedFunctionalGroupsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.PerFrameFunctionalGroupsSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.WaveformSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.ChannelMinimumValue,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.ChannelMaximumValue,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.WaveformBitsAllocated,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.WaveformSampleInterpretation,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.WaveformPaddingValue,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.WaveformData,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.FirstOrderPhaseCorrectionAngle,ValueRepresentation.OF);
		valueRepresentationsByTag.put(TagFromName.SpectroscopyData,ValueRepresentation.OF);
		valueRepresentationsByTag.put(TagFromName.OverlayRows,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayColumns,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayPlanes,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.NumberOfFramesInOverlay,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.OverlayDescription,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.OverlayType,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlaySubtype,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.OverlayOrigin,ValueRepresentation.SS);
		valueRepresentationsByTag.put(TagFromName.ImageFrameOrigin,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayPlaneOrigin,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayCompressionCode,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.OverlayCompressionOriginator,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.OverlayCompressionLabel,ValueRepresentation.SH);
		valueRepresentationsByTag.put(TagFromName.OverlayCompressionDescription,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlayCompressionStepPointers,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.OverlayRepeatInterval,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayBitsGrouped,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayBitsAllocated,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayBitPosition,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayFormat,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.OverlayLocation,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayCodeLabel,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlayNumberOfTables,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayCodeTableLocation,ValueRepresentation.AT);
		valueRepresentationsByTag.put(TagFromName.OverlayBitsForCodeWord,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayActivationLayer,ValueRepresentation.CS);
		valueRepresentationsByTag.put(TagFromName.OverlayDescriptorGray,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayDescriptorRed,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayDescriptorGreen,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayDescriptorBlue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayGray,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayRed,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayGreen,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.OverlayBlue,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.ROIArea,ValueRepresentation.IS);
		valueRepresentationsByTag.put(TagFromName.ROIMean,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.ROIStandardDeviation,ValueRepresentation.DS);
		valueRepresentationsByTag.put(TagFromName.OverlayLabel,ValueRepresentation.LO);
		valueRepresentationsByTag.put(TagFromName.OverlayData,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.OverlayComments,ValueRepresentation.LT);
		valueRepresentationsByTag.put(TagFromName.FloatPixelData,ValueRepresentation.OF);
		valueRepresentationsByTag.put(TagFromName.DoubleFloatPixelData,ValueRepresentation.OD);
		valueRepresentationsByTag.put(TagFromName.PixelData,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.CoefficientsSDVN,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.CoefficientsSDHN,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.CoefficientsSDDN,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.VariablePixelData,ValueRepresentation.OX);
		valueRepresentationsByTag.put(TagFromName.VariableNextDataGroup,ValueRepresentation.US);
		valueRepresentationsByTag.put(TagFromName.VariableCoefficientsSDVN,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.VariableCoefficientsSDHN,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.VariableCoefficientsSDDN,ValueRepresentation.OW);
		valueRepresentationsByTag.put(TagFromName.DigitalSignaturesSequence,ValueRepresentation.SQ);
		valueRepresentationsByTag.put(TagFromName.DataSetTrailingPadding,ValueRepresentation.OB);
	}

	protected void createInformationEntityByTag() {

		informationEntityByTag = new HashMap(100);

		informationEntityByTag.put(TagFromName.ReferencedFrameNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedSegmentNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedSeriesSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PrimaryAnatomicStructureSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AnatomicRegionSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AnatomicRegionModifierSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PrimaryAnatomicStructureModifierSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RequestedProcedureID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.RequestedProcedureDescription,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.RequestedProcedureCodeSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ReasonForTheRequestedProcedure,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ReasonForRequestedProcedureCodeSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ScheduledProcedureStepID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ScheduledProcedureStepDescription,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ScheduledProtocolCodeSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PixelSpacing,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelSpacingCalibrationType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelSpacingCalibrationDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ShutterShape,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ShutterLeftVerticalEdge,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ShutterRightVerticalEdge,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ShutterUpperHorizontalEdge,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ShutterLowerHorizontalEdge,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CenterOfCircularShutter,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RadiusOfCircularShutter,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VerticesOfThePolygonalShutter,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ShutterPresentationValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ShutterPresentationColorCIELabValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContentLabel,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContentDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AlternateContentDescriptionSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContentCreatorName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContentCreatorIdentificationCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.Rows,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.Columns,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BitsStored,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LossyImageCompression,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LossyImageCompressionRatio,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LossyImageCompressionMethod,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PerformedProcedureStepID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PerformedProcedureStepStartDate,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PerformedProcedureStepStartTime,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PerformedProcedureStepDescription,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PerformedProtocolCodeSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.CommentsOnThePerformedProcedureStep,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ExposureIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TargetExposureIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DeviationIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ViewCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SliceProgressionDirection,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PatientSupportAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableTopPitchAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableTopRollAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableTopLongitudinalPosition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableTopLateralPosition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PatientName,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientID,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientBirthDate,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientSex,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.QualityControlSubject,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ReferencedPatientSequence,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientBirthTime,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.OtherPatientIDs,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.OtherPatientIDsSequence,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.OtherPatientNames,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.EthnicGroup,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientComments,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientSpeciesDescription,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientSpeciesCodeSequence,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientBreedDescription,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientBreedCodeSequence,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.BreedRegistrationSequence,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ResponsiblePerson,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ResponsiblePersonRole,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ResponsibleOrganization,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.PatientIdentityRemoved,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.DeidentificationMethod,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.DeidentificationMethodCodeSequence,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ClinicalTrialSponsorName,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ClinicalTrialProtocolID,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ClinicalTrialProtocolName,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ClinicalTrialSiteID,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ClinicalTrialSiteName,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ClinicalTrialSubjectID,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ClinicalTrialSubjectReadingID,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ClinicalTrialProtocolEthicsCommitteeName,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ClinicalTrialProtocolEthicsCommitteeApprovalNumber,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.StudyDate,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.StudyTime,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ReferringPhysicianName,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ReferringPhysicianIdentificationSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.StudyID,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.StudyDescription,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.PhysiciansOfRecord,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.PhysiciansOfRecordIdentificationSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.NameOfPhysiciansReadingStudy,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.PhysiciansReadingStudyIdentificationSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.RequestingServiceCodeSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ProcedureCodeSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ReasonForPerformedProcedureCodeSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.AdmittingDiagnosesDescription,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.AdmittingDiagnosesCodeSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.PatientAge,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.PatientSize,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.PatientWeight,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.PatientSizeCodeSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.Occupation,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.AdditionalPatientHistory,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.AdmissionID,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.IssuerOfAdmissionID,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.IssuerOfAdmissionIDSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ServiceEpisodeID,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.IssuerOfServiceEpisodeIDSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ServiceEpisodeDescription,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.PatientSexNeutered,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ClinicalTrialTimePointID,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ClinicalTrialTimePointDescription,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ConsentForClinicalTrialUseSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.Modality,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SeriesNumber,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.Laterality,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SeriesDate,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SeriesTime,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PerformingPhysicianName,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PerformingPhysicianIdentificationSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ProtocolName,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SeriesDescription,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SeriesDescriptionCodeSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.OperatorsName,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.OperatorIdentificationSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ReferencedPerformedProcedureStepSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.RelatedSeriesSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.BodyPartExamined,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SmallestPixelValueInSeries,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.LargestPixelValueInSeries,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.RequestAttributesSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.AnatomicalOrientationType,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ClinicalTrialCoordinatingCenterName,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ClinicalTrialSeriesID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ClinicalTrialSeriesDescription,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.FrameOfReferenceUID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PositionReferenceIndicator,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.Manufacturer,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.StationName,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.InstitutionalDepartmentName,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ManufacturerModelName,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.DeviceSerialNumber,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SoftwareVersions,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.GantryID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SpatialResolution,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.DateOfLastCalibration,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.TimeOfLastCalibration,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PixelPaddingValue,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PatientOrientation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContentDate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContentTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionDate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionDateTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DerivationDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DerivationCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SourceImageSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedInstanceSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagesInAcquisition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageComments,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.QualityControlImage,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BurnedInAnnotation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RecognizableVisualFeatures,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IconImageSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PresentationLUTShape,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IrradiationEventUID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RealWorldValueMappingSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageOrientationPatient,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagePositionPatient,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SliceThickness,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SliceLocation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SamplesPerPixel,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PhotometricInterpretation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BitsAllocated,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.HighBit,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelRepresentation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PlanarConfiguration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelAspectRatio,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SmallestImagePixelValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LargestImagePixelValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RedPaletteColorLookupTableDescriptor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GreenPaletteColorLookupTableDescriptor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BluePaletteColorLookupTableDescriptor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RedPaletteColorLookupTableData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GreenPaletteColorLookupTableData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BluePaletteColorLookupTableData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ICCProfile,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FloatPixelData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FloatPixelPaddingValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FloatPixelPaddingRangeLimit,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DoubleFloatPixelData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DoubleFloatPixelPaddingValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DoubleFloatPixelPaddingRangeLimit,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelDataProviderURL,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelPaddingRangeLimit,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusAgent,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusAgentSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusRoute,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusAdministrationRouteSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusVolume,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusStartTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusStopTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusTotalDose,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastFlowRate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastFlowDuration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusIngredient,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContrastBolusIngredientConcentration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PreferredPlaybackSequencing,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameTimeVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StartTrim,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StopTrim,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RecommendedDisplayFrameRate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CineRate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameDelay,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageTriggerDelay,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EffectiveDuration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ActualFrameDuration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MultiplexedAudioChannelsDescriptionCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfFrames,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameIncrementPointer,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StereoPairsPresent,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ConcatenationFrameOffsetNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RepresentativeFrameNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SOPInstanceUIDOfConcatenationSource,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InConcatenationNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DimensionOrganizationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DimensionOrganizationType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DimensionIndexSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CardiacSynchronizationTechnique,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CardiacSignalSource,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CardiacRRIntervalSpecified,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CardiacBeatRejectionTechnique,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LowRRValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.HighRRValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IntervalsAcquired,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IntervalsRejected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RespiratoryMotionCompensationTechnique,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RespiratorySignalSource,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RespiratoryTriggerDelayThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RespiratoryTriggerType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BulkMotionCompensationTechnique,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BulkMotionSignalSource,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageToEquipmentMappingMatrix,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EquipmentCoordinateSystemIdentification,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CollimatorGridName,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PlateType,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PhosphorType,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.KVP,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PlateID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DistanceSourceToDetector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DistanceSourceToPatient,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.XRayTubeCurrent,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.Exposure,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureInuAs,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagerPixelSpacing,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GeneratorPower,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionDeviceProcessingDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionDeviceProcessingCode,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CassetteOrientation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CassetteSize,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposuresOnPlate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RelativeXRayExposure,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.Sensitivity,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RescaleIntercept,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RescaleSlope,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RescaleType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ScanOptions,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DataCollectionDiameter,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DataCollectionCenterPatient,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReconstructionTargetCenterPatient,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableHeight,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RotationDirection,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RevolutionTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SingleCollimationWidth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TotalCollimationWidth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableSpeed,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableFeedPerRotation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SpiralPitchFactor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureModulationType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EstimatedDoseSaving,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CTDIvol,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CTDIPhantomTypeCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CalciumScoringMassFactorPatient,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CalciumScoringMassFactorDevice,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EnergyWeightingFactor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CTAdditionalXRaySourceSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IsocenterPosition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ScanningSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SequenceVariant,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MRAcquisitionType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RepetitionTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EchoTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EchoTrainLength,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InversionTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TriggerTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SequenceName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AngioFlag,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfAverages,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagingFrequency,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagedNucleus,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EchoNumbers,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MagneticFieldStrength,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SpacingBetweenSlices,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfPhaseEncodingSteps,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PercentSampling,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PercentPhaseFieldOfView,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelBandwidth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NominalInterval,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CardiacNumberOfImages,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TriggerWindow,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReceiveCoilName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TransmitCoilName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionMatrix,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InPlanePhaseEncodingDirection,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FlipAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SAR,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VariableFlipAngleFlag,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.dBdt,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TemporalPositionIdentifier,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfTemporalPositions,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TemporalResolution,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EnergyWindowVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfEnergyWindows,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfDetectors,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PhaseVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfPhases,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RotationVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfRotations,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RRIntervalVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TimeSlotVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SliceVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AngularViewVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TimeSliceVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CountsAccumulated,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableTraverse,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CountRate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ProcessingFunction,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.WholeBodyTechnique,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ScanVelocity,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ScanLength,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EnergyWindowInformationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorInformationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RotationInformationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GatedInformationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PhaseInformationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SequenceOfUltrasoundRegions,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfStages,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfViewsInStage,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RWaveTimeVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.UltrasoundColorDataPresent,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StageName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StageCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StageNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ViewName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ViewNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfEventTimers,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EventElapsedTimes,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EventTimerNames,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IVUSAcquisition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IVUSPullbackRate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IVUSGatedRate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IVUSPullbackStartFrameNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IVUSPullbackStopFrameNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LesionNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OutputPower,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TransducerData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TransducerType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FocusDepth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MechanicalIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BoneThermalIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CranialThermalIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SoftTissueThermalIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SoftTissueFocusThermalIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SoftTissueSurfaceThermalIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DepthOfScanField,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlaySubtype,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SecondaryCaptureDeviceID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SecondaryCaptureDeviceManufacturer,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SecondaryCaptureDeviceManufacturerModelName,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SecondaryCaptureDeviceSoftwareVersions,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.VideoImageFormatAcquired,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.DigitalImageFormatAcquired,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.DateOfSecondaryCapture,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TimeOfSecondaryCapture,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NominalScannedPixelSpacing,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.Illumination,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReflectedAmbientLight,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DigitizingDeviceTransportDirection,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RotationOfScannedFilm,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PageNumberVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameLabelVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FramePrimaryAngleVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameSecondaryAngleVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SliceLocationVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DisplayWindowLabelVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SharedFunctionalGroupsSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PerFrameFunctionalGroupsSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayRows,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayColumns,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayOrigin,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayBitsAllocated,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayBitPosition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayLabel,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ROIArea,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ROIMean,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ROIStandardDeviation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfFramesInOverlay,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageFrameOrigin,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ModalityLUTSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VOILUTSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.WindowCenter,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.WindowWidth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.WindowCenterWidthExplanation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VOILUTFunction,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LUTNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MACParametersSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DigitalSignaturesSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SpecificCharacterSet,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InstanceCreationDate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InstanceCreationTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InstanceCoercionDateTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InstanceCreatorUID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RelatedGeneralSOPClassUID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OriginalSpecializedSOPClassUID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CodingSchemeIdentificationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TimezoneOffsetFromUTC,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContributingEquipmentSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SOPInstanceStatus,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SOPAuthorizationDateTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SOPAuthorizationComment,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AuthorizationEquipmentCertificationNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EncryptedAttributesSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OriginalAttributesSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.HL7StructuredDocumentReferenceSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LongitudinalTemporalInformationModified,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameExtractionSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StudiesContainingOtherReferencedInstancesSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SegmentationType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SegmentationFractionalType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MaximumFractionalValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SegmentSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SegmentNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SegmentLabel,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SegmentDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SegmentAlgorithmType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SegmentedPropertyCategoryCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SegmentedPropertyTypeCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfSurfacePoints,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PointCoordinatesData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PointPositionAccuracy,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MeanPointDistance,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MaximumPointDistance,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PointsBoundingBoxCoordinates,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AxisOfRotation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CenterOfRotation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfVectors,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VectorDimensionality,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VectorAccuracy,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VectorCoordinateData,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VertexPointIndexList,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EdgePointIndexList,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TrianglePointIndexList,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TriangleStripSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TriangleFanSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LineSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FacetSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfSurfaces,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SurfaceSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PresentationIntentType,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.VolumetricProperties,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelPresentation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionDuration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InterpolationType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedColorPaletteInstanceUID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OCTFocalDistance,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BeamSpotSize,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EffectiveRefractiveIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OCTAcquisitionDomain,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OCTOpticalCenterWavelength,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AxialResolution,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RangingDepth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ALineRate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ALinesPerFrame,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CatheterDirectionOfRotation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CatheterRotationalRate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ModeOfPercutaneousAccessSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OCTZOffsetApplied,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RefractiveIndexApplied,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ALinePixelSpacing,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelIntensityRelationship,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FirstALineLocation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContentQualification,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.Units,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SUVType,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SeriesType,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ReprojectionMethod,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.NumberOfTimeSlices,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.AttenuationCorrectionMethod,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.DecayCorrection,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ReconstructionMethod,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.DetectorLinesOfResponseUsed,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.AcquisitionStartConditionData,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.AcquisitionTerminationConditionData,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.GantryDetectorSlew,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.AxialAcceptance,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.AxialMash,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.TransverseMash,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.DetectorElementSize,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SecondaryCountsType,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.FrameReferenceTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageIndex,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PrimaryPromptsCountsAccumulated,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SecondaryCountsAccumulated,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SliceSensitivityFactor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DecayFactor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DoseCalibrationFactor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ScatterFractionFactor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DeadTimeFactor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StartDensityThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StartRelativeDensityDifferenceThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StartCardiacTriggerCountThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StartRespiratoryTriggerCountThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TerminationCountsThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TerminationDensityThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TerminationRelativeDensityThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TerminationTimeThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TerminationCardiacTriggerCountThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TerminationRespiratoryTriggerCountThreshold,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorGeometry,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TransverseDetectorSeparation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AxialDetectorDimension,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableMotion,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TimeOfFlightInformationUsed,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedRawDataSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedWaveformSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedImageEvidenceSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SourceImageEvidenceSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DecayCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AttenuationCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ScatterCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DeadTimeCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GantryMotionCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PatientMotionCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CountLossNormalizationCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RandomsCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NonUniformRadialSamplingCorrected,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SensitivityCalibrated,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorNormalizationCorrection,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AttenuationCorrectionSource,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AttenuationCorrectionTemporalRelationship,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DecayCorrectionDateTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PixelIntensityRelationshipSign,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RTImageLabel,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RTImageName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RTImageDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReportedValuesOrigin,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RTImagePlane,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.XRayImageReceptorAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RTImageOrientation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagePlanePixelSpacing,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RTImagePosition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RadiationMachineName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PrimaryDosimeterUnit,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RadiationMachineSAD,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RadiationMachineSSD,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RTImageSID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SourceToReferenceObjectDistance,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedRTPlanSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedBeamNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedFractionGroupNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FractionNumber,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StartCumulativeMetersetWeight,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EndCumulativeMetersetWeight,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FluenceMapSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GantryAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GantryPitchAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BeamLimitingDeviceAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableTopEccentricAxisDistance,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableTopEccentricAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableTopVerticalPosition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DoseUnits,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DoseType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SpatialTransformOfDose,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedSpatialRegistrationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DoseComment,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NormalizationPoint,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DoseSummationType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridFrameOffsetVector,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DoseGridScaling,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TissueHeterogeneityCorrection,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedStructureSetSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DVHNormalizationPoint,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DVHNormalizationDoseValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DVHSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RTDoseROISequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionContextSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionContextDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.XRayTubeCurrentInuA,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureTimeInuS,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageAndFluoroscopyAreaDoseProduct,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BodyPartThickness,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EntranceDose,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EntranceDoseInmGy,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposedArea,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DistanceSourceToEntrance,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CommentsOnRadiationDose,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.XRayOutput,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.HalfValueLayer,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OrganDose,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OrganExposed,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AnodeTargetMaterial,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RectificationType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureControlMode,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureControlModeDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureStatus,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PhototimerSetting,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GeneratorID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridAbsorbingMaterial,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridSpacingMaterial,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridThickness,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridPitch,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridAspectRatio,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridPeriod,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridFocalDistance,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GridID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.Grid,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageLaterality,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CalibrationImage,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorConfiguration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorMode,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DateOfLastDetectorCalibration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TimeOfLastDetectorCalibration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposuresOnDetectorSinceLastCalibration,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposuresOnDetectorSinceManufactured,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorTimeSinceLastExposure,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorBinning,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorManufacturerName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorManufacturerModelName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorConditionsNominalFlag,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorTemperature,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorElementPhysicalSize,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorElementSpacing,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorActiveShape,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorActiveDimensions,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorActiveOrigin,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorActiveTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorActivationOffsetFromExposure,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FieldOfViewOrigin,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FieldOfViewRotation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FieldOfViewHorizontalFlip,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CassetteID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ProjectionEponymousNameCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ViewModifierCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PatientOrientationModifierCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EstimatedRadiographicMagnificationFactor,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PositionerType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PositionerPrimaryAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PositionerSecondaryAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorPrimaryAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DetectorSecondaryAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ColumnAngulation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CompressionForce,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PaddleDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PositionerPrimaryAngleDirection,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BreastImplantPresent,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PartialView,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PartialViewDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PartialViewCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BiopsyTargetSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.HistogramSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ContributingSourcesSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.XRay3DAcquisitionSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageCenterPointCoordinatesSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SamplesPerPixelUsed,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionDeviceTypeCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IlluminationTypeCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LightPathFilterTypeStackCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LightPathFilterPassThroughWavelength,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LightPathFilterPassBand,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagePathFilterTypeStackCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagePathFilterPassThroughWavelength,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagePathFilterPassBand,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LensesCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ChannelDescriptionCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CameraAngleOfView,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RefractiveStateSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EmmetropicMagnification,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IntraOcularPressure,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.HorizontalFieldOfView,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PupilDilated,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MydriaticAgentSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DegreeOfDilation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PatientEyeMovementCommanded,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PatientEyeMovementCommandCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RelativeImagePositionCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StereoPairsSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AxialLengthOfTheEye,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IlluminationWaveLength,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IlluminationPower,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IlluminationBandwidth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DepthSpatialResolution,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MaximumDepthDistortion,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AlongScanSpatialResolution,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MaximumAlongScanDistortion,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcrossScanSpatialResolution,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MaximumAcrossScanDistortion,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OphthalmicFrameLocationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagedVolumeWidth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagedVolumeHeight,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImagedVolumeDepth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TotalPixelMatrixColumns,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TotalPixelMatrixRows,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TotalPixelMatrixOriginSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageOrientationSlide,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SpecimenLabelInImage,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FocusMethod,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExtendedDepthOfField,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfFocalPlanes,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DistanceBetweenFocalPlanes,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RecommendedAbsentPixelCIELabValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OpticalPathSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedImageNavigationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BarcodeValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.LabelText,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SynchronizationFrameOfReferenceUID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SynchronizationTrigger,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SynchronizationChannel,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.AcquisitionTimeSynchronized,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.TimeSource,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.TimeDistributionProtocol,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.NTPSourceAddress,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.WaveformSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.WaveformAnnotationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PreliminaryFlag,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CompletionFlag,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CompletionFlagDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VerificationFlag,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VerifyingObserverSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AuthorObserverSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ParticipantSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CustodialOrganizationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PredecessorDocumentsSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IdenticalDocumentsSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedRequestSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PerformedProcedureCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CurrentRequestedProcedureEvidenceSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PertinentOtherEvidenceSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ShutterOverlayGroup,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DisplayedAreaSelectionSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GraphicAnnotationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageRotation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageHorizontalFlip,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GraphicLayerSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PresentationLUTSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OverlayActivationLayer,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SoftcopyVOILUTSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PresentationCreationDate,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PresentationCreationTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MaskSubtractionSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RecommendedViewingMode,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BlendingSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RelativeOpacity,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfScreens,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NominalScreenDefinitionSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StructuredDisplayBackgroundCIELabValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EmptyImageBoxCIELabValue,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StructuredDisplayImageBoxSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ImageBoxSynchronizationSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.StructuredDisplayTextBoxSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VolumeBasedCalculationTechnique,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ComplexImageComponent,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionContrast,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedPresentationStateSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ResonantNucleus,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.KSpaceFiltering,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ApplicableSafetyStandardAgency,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ApplicableSafetyStandardDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PulseSequenceName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EchoPulseSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MultipleSpinEcho,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.MultiPlanarExcitation,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PhaseContrast,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VelocityEncodingAcquisitionSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TimeOfFlightContrast,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ArterialSpinLabelingContrast,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SteadyStatePulseSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EchoPlanarPulseSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SaturationRecovery,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SpectrallySelectedSuppression,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.OversamplingPhase,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.GeometryOfKSpaceTraversal,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RectilinearPhaseEncodeReordering,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SegmentedKSpaceTraversal,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CoverageOfKSpace,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfKSpaceTrajectories,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameNumbersOfInterest,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameOfInterestDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameOfInterestType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DeviceSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InterventionSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RWavePointer,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameDimensionPointer,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RadiationSetting,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AveragePulseWidth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RadiationMode,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TypeOfFilters,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IntensifierSize,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CollimatorLeftVerticalEdge,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CollimatorRightVerticalEdge,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CollimatorUpperHorizontalEdge,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CollimatorLowerHorizontalEdge,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CenterOfCircularCollimator,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RadiusOfCircularCollimator,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.VerticesOfThePolygonalCollimator,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CollimatorShape,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableVerticalIncrement,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableLongitudinalIncrement,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TableLateralIncrement,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PositionerMotion,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PositionerPrimaryAngleIncrement,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PositionerSecondaryAngleIncrement,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TomoLayerHeight,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TomoAngle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TomoTime,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TomoType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TomoClass,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.NumberOfTomosynthesisSourceImages,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PlanesInAcquisition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PlaneIdentification,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionProtocolName,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionProtocolDescription,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExaminedBodyThickness,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ReferencedOtherPlaneSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.XRayTubeCurrentInmA,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureTimeInms,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExposureInmAs,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.XRayReceptorType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DistanceReceptorPlaneToDetectorHousing,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CArmPositionerTabletopRelationship,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquiredImageAreaDoseProduct,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IntensifierActiveShape,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.IntensifierActiveDimensions,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PhysicalDetectorSize,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PositionOfIsocenterProjection,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.FrameDisplaySequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SourceIrradiationEventSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.XRay3DReconstructionSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DataFrameAssignmentSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BlendingLUT1Sequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.BlendingLUT2Sequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EnhancedPaletteColorLookupTableSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.PerformedProtocolType,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.VolumeFrameOfReferenceUID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.UltrasoundAcquisitionGeometry,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.ApexPosition,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.VolumeToTransducerRelationship,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.VolumeToTransducerMappingMatrix,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PatientFrameOfReferenceSource,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.TableFrameOfReferenceUID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.VolumeToTableMappingMatrix,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.PositionMeasuringDeviceUsed,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.EventTimerSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TransducerScanPatternCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TransducerGeometryCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TransducerBeamSteeringCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TransducerApplicationCodeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.DepthsOfFocus,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ExcludedIntervalsSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionStartCondition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.RandomsCorrectionMethod,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InterpretationAuthor,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.OtherStudyNumbers,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.NumberOfStudyRelatedSeries,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.NumberOfStudyRelatedInstances,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.NumberOfPatientRelatedSeries,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.NumberOfPatientRelatedInstances,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.InstitutionCodeSequence,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.InConcatenationTotalNumber,InformationEntity.CONCATENATION);
		informationEntityByTag.put(TagFromName.CollimatorType,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AccessionNumber,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.IssuerOfAccessionNumberSequence,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.CountsSource,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SOPClassesInStudy,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.NumberOfSeriesRelatedInstances,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.NumberOfPatientRelatedStudies,InformationEntity.PATIENT);
		informationEntityByTag.put(TagFromName.ConcatenationUID,InformationEntity.CONCATENATION);
		informationEntityByTag.put(TagFromName.FocalSpots,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ScatterCorrectionMethod,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.AcquisitionTerminationCondition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SeriesInstanceUID,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.EnergyWindowRangeSequence,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.CoincidenceWindowWidth,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.TransferSyntaxUID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InstanceNumber,InformationEntity.CONCATENATION);
		informationEntityByTag.put(TagFromName.StudyInstanceUID,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.InstitutionAddress,InformationEntity.SERIES);
		informationEntityByTag.put(TagFromName.SOPClassUID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SourceApplicationEntityTitle,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.SOPInstanceUID,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.ModalitiesInStudy,InformationEntity.STUDY);
		informationEntityByTag.put(TagFromName.ViewPosition,InformationEntity.INSTANCE);
		informationEntityByTag.put(TagFromName.InstitutionName,InformationEntity.SERIES);
	}

	protected void createTagByName() {

		tagByName = new HashMap(100);

		tagByName.put("CommandGroupLength",TagFromName.CommandGroupLength);
		tagByName.put("CommandLengthToEnd",TagFromName.CommandLengthToEnd);
		tagByName.put("AffectedSOPClassUID",TagFromName.AffectedSOPClassUID);
		tagByName.put("RequestedSOPClassUID",TagFromName.RequestedSOPClassUID);
		tagByName.put("CommandRecognitionCode",TagFromName.CommandRecognitionCode);
		tagByName.put("CommandField",TagFromName.CommandField);
		tagByName.put("MessageID",TagFromName.MessageID);
		tagByName.put("MessageIDBeingRespondedTo",TagFromName.MessageIDBeingRespondedTo);
		tagByName.put("Initiator",TagFromName.Initiator);
		tagByName.put("Receiver",TagFromName.Receiver);
		tagByName.put("FindLocation",TagFromName.FindLocation);
		tagByName.put("MoveDestination",TagFromName.MoveDestination);
		tagByName.put("Priority",TagFromName.Priority);
		tagByName.put("CommandDataSetType",TagFromName.CommandDataSetType);
		tagByName.put("NumberOfMatches",TagFromName.NumberOfMatches);
		tagByName.put("ResponseSequenceNumber",TagFromName.ResponseSequenceNumber);
		tagByName.put("Status",TagFromName.Status);
		tagByName.put("OffendingElement",TagFromName.OffendingElement);
		tagByName.put("ErrorComment",TagFromName.ErrorComment);
		tagByName.put("ErrorID",TagFromName.ErrorID);
		tagByName.put("AffectedSOPInstanceUID",TagFromName.AffectedSOPInstanceUID);
		tagByName.put("RequestedSOPInstanceUID",TagFromName.RequestedSOPInstanceUID);
		tagByName.put("EventTypeID",TagFromName.EventTypeID);
		tagByName.put("AttributeIdentifierList",TagFromName.AttributeIdentifierList);
		tagByName.put("ActionTypeID",TagFromName.ActionTypeID);
		tagByName.put("NumberOfRemainingSuboperations",TagFromName.NumberOfRemainingSuboperations);
		tagByName.put("NumberOfCompletedSuboperations",TagFromName.NumberOfCompletedSuboperations);
		tagByName.put("NumberOfFailedSuboperations",TagFromName.NumberOfFailedSuboperations);
		tagByName.put("NumberOfWarningSuboperations",TagFromName.NumberOfWarningSuboperations);
		tagByName.put("MoveOriginatorApplicationEntityTitle",TagFromName.MoveOriginatorApplicationEntityTitle);
		tagByName.put("MoveOriginatorMessageID",TagFromName.MoveOriginatorMessageID);
		tagByName.put("DialogReceiver",TagFromName.DialogReceiver);
		tagByName.put("TerminalType",TagFromName.TerminalType);
		tagByName.put("MessageSetID",TagFromName.MessageSetID);
		tagByName.put("EndMessageID",TagFromName.EndMessageID);
		tagByName.put("DisplayFormat",TagFromName.DisplayFormat);
		tagByName.put("PagePositionID",TagFromName.PagePositionID);
		tagByName.put("TextFormatID",TagFromName.TextFormatID);
		tagByName.put("NormalReverse",TagFromName.NormalReverse);
		tagByName.put("AddGrayScale",TagFromName.AddGrayScale);
		tagByName.put("Borders",TagFromName.Borders);
		tagByName.put("Copies",TagFromName.Copies);
		tagByName.put("CommandMagnificationType",TagFromName.CommandMagnificationType);
		tagByName.put("Erase",TagFromName.Erase);
		tagByName.put("Print",TagFromName.Print);
		tagByName.put("Overlays",TagFromName.Overlays);
		tagByName.put("FileMetaInformationGroupLength",TagFromName.FileMetaInformationGroupLength);
		tagByName.put("FileMetaInformationVersion",TagFromName.FileMetaInformationVersion);
		tagByName.put("MediaStorageSOPClassUID",TagFromName.MediaStorageSOPClassUID);
		tagByName.put("MediaStorageSOPInstanceUID",TagFromName.MediaStorageSOPInstanceUID);
		tagByName.put("TransferSyntaxUID",TagFromName.TransferSyntaxUID);
		tagByName.put("ImplementationClassUID",TagFromName.ImplementationClassUID);
		tagByName.put("ImplementationVersionName",TagFromName.ImplementationVersionName);
		tagByName.put("SourceApplicationEntityTitle",TagFromName.SourceApplicationEntityTitle);
		tagByName.put("SendingApplicationEntityTitle",TagFromName.SendingApplicationEntityTitle);
		tagByName.put("ReceivingApplicationEntityTitle",TagFromName.ReceivingApplicationEntityTitle);
		tagByName.put("PrivateInformationCreatorUID",TagFromName.PrivateInformationCreatorUID);
		tagByName.put("PrivateInformation",TagFromName.PrivateInformation);
		tagByName.put("FileSetID",TagFromName.FileSetID);
		tagByName.put("FileSetDescriptorFileID",TagFromName.FileSetDescriptorFileID);
		tagByName.put("SpecificCharacterSetOfFileSetDescriptorFile",TagFromName.SpecificCharacterSetOfFileSetDescriptorFile);
		tagByName.put("OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity",TagFromName.OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity);
		tagByName.put("OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity",TagFromName.OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity);
		tagByName.put("FileSetConsistencyFlag",TagFromName.FileSetConsistencyFlag);
		tagByName.put("DirectoryRecordSequence",TagFromName.DirectoryRecordSequence);
		tagByName.put("OffsetOfTheNextDirectoryRecord",TagFromName.OffsetOfTheNextDirectoryRecord);
		tagByName.put("RecordInUseFlag",TagFromName.RecordInUseFlag);
		tagByName.put("OffsetOfReferencedLowerLevelDirectoryEntity",TagFromName.OffsetOfReferencedLowerLevelDirectoryEntity);
		tagByName.put("DirectoryRecordType",TagFromName.DirectoryRecordType);
		tagByName.put("PrivateRecordUID",TagFromName.PrivateRecordUID);
		tagByName.put("ReferencedFileID",TagFromName.ReferencedFileID);
		tagByName.put("MRDRDirectoryRecordOffset",TagFromName.MRDRDirectoryRecordOffset);
		tagByName.put("ReferencedSOPClassUIDInFile",TagFromName.ReferencedSOPClassUIDInFile);
		tagByName.put("ReferencedSOPInstanceUIDInFile",TagFromName.ReferencedSOPInstanceUIDInFile);
		tagByName.put("ReferencedTransferSyntaxUIDInFile",TagFromName.ReferencedTransferSyntaxUIDInFile);
		tagByName.put("ReferencedRelatedGeneralSOPClassUIDInFile",TagFromName.ReferencedRelatedGeneralSOPClassUIDInFile);
		tagByName.put("NumberOfReferences",TagFromName.NumberOfReferences);
		tagByName.put("LengthToEnd",TagFromName.LengthToEnd);
		tagByName.put("SpecificCharacterSet",TagFromName.SpecificCharacterSet);
		tagByName.put("LanguageCodeSequence",TagFromName.LanguageCodeSequence);
		tagByName.put("ImageType",TagFromName.ImageType);
		tagByName.put("RecognitionCode",TagFromName.RecognitionCode);
		tagByName.put("InstanceCreationDate",TagFromName.InstanceCreationDate);
		tagByName.put("InstanceCreationTime",TagFromName.InstanceCreationTime);
		tagByName.put("InstanceCreatorUID",TagFromName.InstanceCreatorUID);
		tagByName.put("InstanceCoercionDateTime",TagFromName.InstanceCoercionDateTime);
		tagByName.put("SOPClassUID",TagFromName.SOPClassUID);
		tagByName.put("SOPInstanceUID",TagFromName.SOPInstanceUID);
		tagByName.put("RelatedGeneralSOPClassUID",TagFromName.RelatedGeneralSOPClassUID);
		tagByName.put("OriginalSpecializedSOPClassUID",TagFromName.OriginalSpecializedSOPClassUID);
		tagByName.put("StudyDate",TagFromName.StudyDate);
		tagByName.put("SeriesDate",TagFromName.SeriesDate);
		tagByName.put("AcquisitionDate",TagFromName.AcquisitionDate);
		tagByName.put("ContentDate",TagFromName.ContentDate);
		tagByName.put("OverlayDate",TagFromName.OverlayDate);
		tagByName.put("CurveDate",TagFromName.CurveDate);
		tagByName.put("AcquisitionDateTime",TagFromName.AcquisitionDateTime);
		tagByName.put("StudyTime",TagFromName.StudyTime);
		tagByName.put("SeriesTime",TagFromName.SeriesTime);
		tagByName.put("AcquisitionTime",TagFromName.AcquisitionTime);
		tagByName.put("ContentTime",TagFromName.ContentTime);
		tagByName.put("OverlayTime",TagFromName.OverlayTime);
		tagByName.put("CurveTime",TagFromName.CurveTime);
		tagByName.put("DataSetType",TagFromName.DataSetType);
		tagByName.put("DataSetSubtype",TagFromName.DataSetSubtype);
		tagByName.put("NuclearMedicineSeriesType",TagFromName.NuclearMedicineSeriesType);
		tagByName.put("AccessionNumber",TagFromName.AccessionNumber);
		tagByName.put("IssuerOfAccessionNumberSequence",TagFromName.IssuerOfAccessionNumberSequence);
		tagByName.put("QueryRetrieveLevel",TagFromName.QueryRetrieveLevel);
		tagByName.put("QueryRetrieveView",TagFromName.QueryRetrieveView);
		tagByName.put("RetrieveAETitle",TagFromName.RetrieveAETitle);
		tagByName.put("InstanceAvailability",TagFromName.InstanceAvailability);
		tagByName.put("FailedSOPInstanceUIDList",TagFromName.FailedSOPInstanceUIDList);
		tagByName.put("Modality",TagFromName.Modality);
		tagByName.put("ModalitiesInStudy",TagFromName.ModalitiesInStudy);
		tagByName.put("SOPClassesInStudy",TagFromName.SOPClassesInStudy);
		tagByName.put("ConversionType",TagFromName.ConversionType);
		tagByName.put("PresentationIntentType",TagFromName.PresentationIntentType);
		tagByName.put("Manufacturer",TagFromName.Manufacturer);
		tagByName.put("InstitutionName",TagFromName.InstitutionName);
		tagByName.put("InstitutionAddress",TagFromName.InstitutionAddress);
		tagByName.put("InstitutionCodeSequence",TagFromName.InstitutionCodeSequence);
		tagByName.put("ReferringPhysicianName",TagFromName.ReferringPhysicianName);
		tagByName.put("ReferringPhysicianAddress",TagFromName.ReferringPhysicianAddress);
		tagByName.put("ReferringPhysicianTelephoneNumbers",TagFromName.ReferringPhysicianTelephoneNumbers);
		tagByName.put("ReferringPhysicianIdentificationSequence",TagFromName.ReferringPhysicianIdentificationSequence);
		tagByName.put("ConsultingPhysicianName",TagFromName.ConsultingPhysicianName);
		tagByName.put("ConsultingPhysicianIdentificationSequence",TagFromName.ConsultingPhysicianIdentificationSequence);
		tagByName.put("CodeValue",TagFromName.CodeValue);
		tagByName.put("ExtendedCodeValue",TagFromName.ExtendedCodeValue);
		tagByName.put("CodingSchemeDesignator",TagFromName.CodingSchemeDesignator);
		tagByName.put("CodingSchemeVersion",TagFromName.CodingSchemeVersion);
		tagByName.put("CodeMeaning",TagFromName.CodeMeaning);
		tagByName.put("MappingResource",TagFromName.MappingResource);
		tagByName.put("ContextGroupVersion",TagFromName.ContextGroupVersion);
		tagByName.put("ContextGroupLocalVersion",TagFromName.ContextGroupLocalVersion);
		tagByName.put("ExtendedCodeMeaning",TagFromName.ExtendedCodeMeaning);
		tagByName.put("ContextGroupExtensionFlag",TagFromName.ContextGroupExtensionFlag);
		tagByName.put("CodingSchemeUID",TagFromName.CodingSchemeUID);
		tagByName.put("ContextGroupExtensionCreatorUID",TagFromName.ContextGroupExtensionCreatorUID);
		tagByName.put("ContextIdentifier",TagFromName.ContextIdentifier);
		tagByName.put("CodingSchemeIdentificationSequence",TagFromName.CodingSchemeIdentificationSequence);
		tagByName.put("CodingSchemeRegistry",TagFromName.CodingSchemeRegistry);
		tagByName.put("CodingSchemeExternalID",TagFromName.CodingSchemeExternalID);
		tagByName.put("CodingSchemeName",TagFromName.CodingSchemeName);
		tagByName.put("CodingSchemeResponsibleOrganization",TagFromName.CodingSchemeResponsibleOrganization);
		tagByName.put("ContextUID",TagFromName.ContextUID);
		tagByName.put("MappingResourceUID",TagFromName.MappingResourceUID);
		tagByName.put("LongCodeValue",TagFromName.LongCodeValue);
		tagByName.put("URNCodeValue",TagFromName.URNCodeValue);
		tagByName.put("EquivalentCodeSequence",TagFromName.EquivalentCodeSequence);
		tagByName.put("TimezoneOffsetFromUTC",TagFromName.TimezoneOffsetFromUTC);
		tagByName.put("PrivateDataElementCharacteristicsSequence",TagFromName.PrivateDataElementCharacteristicsSequence);
		tagByName.put("PrivateGroupReference",TagFromName.PrivateGroupReference);
		tagByName.put("PrivateCreatorReference",TagFromName.PrivateCreatorReference);
		tagByName.put("BlockIdentifyingInformationStatus",TagFromName.BlockIdentifyingInformationStatus);
		tagByName.put("NonidentifyingPrivateElements",TagFromName.NonidentifyingPrivateElements);
		tagByName.put("DeidentificationActionSequence",TagFromName.DeidentificationActionSequence);
		tagByName.put("IdentifyingPrivateElements",TagFromName.IdentifyingPrivateElements);
		tagByName.put("DeidentificationAction",TagFromName.DeidentificationAction);
		tagByName.put("NetworkID",TagFromName.NetworkID);
		tagByName.put("StationName",TagFromName.StationName);
		tagByName.put("StudyDescription",TagFromName.StudyDescription);
		tagByName.put("ProcedureCodeSequence",TagFromName.ProcedureCodeSequence);
		tagByName.put("SeriesDescription",TagFromName.SeriesDescription);
		tagByName.put("SeriesDescriptionCodeSequence",TagFromName.SeriesDescriptionCodeSequence);
		tagByName.put("InstitutionalDepartmentName",TagFromName.InstitutionalDepartmentName);
		tagByName.put("PhysiciansOfRecord",TagFromName.PhysiciansOfRecord);
		tagByName.put("PhysiciansOfRecordIdentificationSequence",TagFromName.PhysiciansOfRecordIdentificationSequence);
		tagByName.put("PerformingPhysicianName",TagFromName.PerformingPhysicianName);
		tagByName.put("PerformingPhysicianIdentificationSequence",TagFromName.PerformingPhysicianIdentificationSequence);
		tagByName.put("NameOfPhysiciansReadingStudy",TagFromName.NameOfPhysiciansReadingStudy);
		tagByName.put("PhysiciansReadingStudyIdentificationSequence",TagFromName.PhysiciansReadingStudyIdentificationSequence);
		tagByName.put("OperatorsName",TagFromName.OperatorsName);
		tagByName.put("OperatorIdentificationSequence",TagFromName.OperatorIdentificationSequence);
		tagByName.put("AdmittingDiagnosesDescription",TagFromName.AdmittingDiagnosesDescription);
		tagByName.put("AdmittingDiagnosesCodeSequence",TagFromName.AdmittingDiagnosesCodeSequence);
		tagByName.put("ManufacturerModelName",TagFromName.ManufacturerModelName);
		tagByName.put("ReferencedResultsSequence",TagFromName.ReferencedResultsSequence);
		tagByName.put("ReferencedStudySequence",TagFromName.ReferencedStudySequence);
		tagByName.put("ReferencedPerformedProcedureStepSequence",TagFromName.ReferencedPerformedProcedureStepSequence);
		tagByName.put("ReferencedSeriesSequence",TagFromName.ReferencedSeriesSequence);
		tagByName.put("ReferencedPatientSequence",TagFromName.ReferencedPatientSequence);
		tagByName.put("ReferencedVisitSequence",TagFromName.ReferencedVisitSequence);
		tagByName.put("ReferencedOverlaySequence",TagFromName.ReferencedOverlaySequence);
		tagByName.put("ReferencedStereometricInstanceSequence",TagFromName.ReferencedStereometricInstanceSequence);
		tagByName.put("ReferencedWaveformSequence",TagFromName.ReferencedWaveformSequence);
		tagByName.put("ReferencedImageSequence",TagFromName.ReferencedImageSequence);
		tagByName.put("ReferencedCurveSequence",TagFromName.ReferencedCurveSequence);
		tagByName.put("ReferencedInstanceSequence",TagFromName.ReferencedInstanceSequence);
		tagByName.put("ReferencedRealWorldValueMappingInstanceSequence",TagFromName.ReferencedRealWorldValueMappingInstanceSequence);
		tagByName.put("ReferencedSOPClassUID",TagFromName.ReferencedSOPClassUID);
		tagByName.put("ReferencedSOPInstanceUID",TagFromName.ReferencedSOPInstanceUID);
		tagByName.put("SOPClassesSupported",TagFromName.SOPClassesSupported);
		tagByName.put("ReferencedFrameNumber",TagFromName.ReferencedFrameNumber);
		tagByName.put("SimpleFrameList",TagFromName.SimpleFrameList);
		tagByName.put("CalculatedFrameList",TagFromName.CalculatedFrameList);
		tagByName.put("TimeRange",TagFromName.TimeRange);
		tagByName.put("FrameExtractionSequence",TagFromName.FrameExtractionSequence);
		tagByName.put("MultiFrameSourceSOPInstanceUID",TagFromName.MultiFrameSourceSOPInstanceUID);
		tagByName.put("RetrieveURL",TagFromName.RetrieveURL);
		tagByName.put("TransactionUID",TagFromName.TransactionUID);
		tagByName.put("WarningReason",TagFromName.WarningReason);
		tagByName.put("FailureReason",TagFromName.FailureReason);
		tagByName.put("FailedSOPSequence",TagFromName.FailedSOPSequence);
		tagByName.put("ReferencedSOPSequence",TagFromName.ReferencedSOPSequence);
		tagByName.put("OtherFailuresSequence",TagFromName.OtherFailuresSequence);
		tagByName.put("StudiesContainingOtherReferencedInstancesSequence",TagFromName.StudiesContainingOtherReferencedInstancesSequence);
		tagByName.put("RelatedSeriesSequence",TagFromName.RelatedSeriesSequence);
		tagByName.put("LossyImageCompressionRetired",TagFromName.LossyImageCompressionRetired);
		tagByName.put("DerivationDescription",TagFromName.DerivationDescription);
		tagByName.put("SourceImageSequence",TagFromName.SourceImageSequence);
		tagByName.put("StageName",TagFromName.StageName);
		tagByName.put("StageNumber",TagFromName.StageNumber);
		tagByName.put("NumberOfStages",TagFromName.NumberOfStages);
		tagByName.put("ViewName",TagFromName.ViewName);
		tagByName.put("ViewNumber",TagFromName.ViewNumber);
		tagByName.put("NumberOfEventTimers",TagFromName.NumberOfEventTimers);
		tagByName.put("NumberOfViewsInStage",TagFromName.NumberOfViewsInStage);
		tagByName.put("EventElapsedTimes",TagFromName.EventElapsedTimes);
		tagByName.put("EventTimerNames",TagFromName.EventTimerNames);
		tagByName.put("EventTimerSequence",TagFromName.EventTimerSequence);
		tagByName.put("EventTimeOffset",TagFromName.EventTimeOffset);
		tagByName.put("EventCodeSequence",TagFromName.EventCodeSequence);
		tagByName.put("StartTrim",TagFromName.StartTrim);
		tagByName.put("StopTrim",TagFromName.StopTrim);
		tagByName.put("RecommendedDisplayFrameRate",TagFromName.RecommendedDisplayFrameRate);
		tagByName.put("TransducerPosition",TagFromName.TransducerPosition);
		tagByName.put("TransducerOrientation",TagFromName.TransducerOrientation);
		tagByName.put("AnatomicStructure",TagFromName.AnatomicStructure);
		tagByName.put("AnatomicRegionSequence",TagFromName.AnatomicRegionSequence);
		tagByName.put("AnatomicRegionModifierSequence",TagFromName.AnatomicRegionModifierSequence);
		tagByName.put("PrimaryAnatomicStructureSequence",TagFromName.PrimaryAnatomicStructureSequence);
		tagByName.put("AnatomicStructureSpaceOrRegionSequence",TagFromName.AnatomicStructureSpaceOrRegionSequence);
		tagByName.put("PrimaryAnatomicStructureModifierSequence",TagFromName.PrimaryAnatomicStructureModifierSequence);
		tagByName.put("TransducerPositionSequence",TagFromName.TransducerPositionSequence);
		tagByName.put("TransducerPositionModifierSequence",TagFromName.TransducerPositionModifierSequence);
		tagByName.put("TransducerOrientationSequence",TagFromName.TransducerOrientationSequence);
		tagByName.put("TransducerOrientationModifierSequence",TagFromName.TransducerOrientationModifierSequence);
		tagByName.put("AnatomicStructureSpaceOrRegionCodeSequenceTrial",TagFromName.AnatomicStructureSpaceOrRegionCodeSequenceTrial);
		tagByName.put("AnatomicPortalOfEntranceCodeSequenceTrial",TagFromName.AnatomicPortalOfEntranceCodeSequenceTrial);
		tagByName.put("AnatomicApproachDirectionCodeSequenceTrial",TagFromName.AnatomicApproachDirectionCodeSequenceTrial);
		tagByName.put("AnatomicPerspectiveDescriptionTrial",TagFromName.AnatomicPerspectiveDescriptionTrial);
		tagByName.put("AnatomicPerspectiveCodeSequenceTrial",TagFromName.AnatomicPerspectiveCodeSequenceTrial);
		tagByName.put("AnatomicLocationOfExaminingInstrumentDescriptionTrial",TagFromName.AnatomicLocationOfExaminingInstrumentDescriptionTrial);
		tagByName.put("AnatomicLocationOfExaminingInstrumentCodeSequenceTrial",TagFromName.AnatomicLocationOfExaminingInstrumentCodeSequenceTrial);
		tagByName.put("AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial",TagFromName.AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial);
		tagByName.put("OnAxisBackgroundAnatomicStructureCodeSequenceTrial",TagFromName.OnAxisBackgroundAnatomicStructureCodeSequenceTrial);
		tagByName.put("AlternateRepresentationSequence",TagFromName.AlternateRepresentationSequence);
		tagByName.put("IrradiationEventUID",TagFromName.IrradiationEventUID);
		tagByName.put("SourceIrradiationEventSequence",TagFromName.SourceIrradiationEventSequence);
		tagByName.put("RadiopharmaceuticalAdministrationEventUID",TagFromName.RadiopharmaceuticalAdministrationEventUID);
		tagByName.put("IdentifyingComments",TagFromName.IdentifyingComments);
		tagByName.put("FrameType",TagFromName.FrameType);
		tagByName.put("ReferencedImageEvidenceSequence",TagFromName.ReferencedImageEvidenceSequence);
		tagByName.put("ReferencedRawDataSequence",TagFromName.ReferencedRawDataSequence);
		tagByName.put("CreatorVersionUID",TagFromName.CreatorVersionUID);
		tagByName.put("DerivationImageSequence",TagFromName.DerivationImageSequence);
		tagByName.put("SourceImageEvidenceSequence",TagFromName.SourceImageEvidenceSequence);
		tagByName.put("PixelPresentation",TagFromName.PixelPresentation);
		tagByName.put("VolumetricProperties",TagFromName.VolumetricProperties);
		tagByName.put("VolumeBasedCalculationTechnique",TagFromName.VolumeBasedCalculationTechnique);
		tagByName.put("ComplexImageComponent",TagFromName.ComplexImageComponent);
		tagByName.put("AcquisitionContrast",TagFromName.AcquisitionContrast);
		tagByName.put("DerivationCodeSequence",TagFromName.DerivationCodeSequence);
		tagByName.put("ReferencedPresentationStateSequence",TagFromName.ReferencedPresentationStateSequence);
		tagByName.put("ReferencedOtherPlaneSequence",TagFromName.ReferencedOtherPlaneSequence);
		tagByName.put("FrameDisplaySequence",TagFromName.FrameDisplaySequence);
		tagByName.put("RecommendedDisplayFrameRateInFloat",TagFromName.RecommendedDisplayFrameRateInFloat);
		tagByName.put("SkipFrameRangeFlag",TagFromName.SkipFrameRangeFlag);
		tagByName.put("PatientName",TagFromName.PatientName);
		tagByName.put("PatientID",TagFromName.PatientID);
		tagByName.put("IssuerOfPatientID",TagFromName.IssuerOfPatientID);
		tagByName.put("TypeOfPatientID",TagFromName.TypeOfPatientID);
		tagByName.put("IssuerOfPatientIDQualifiersSequence",TagFromName.IssuerOfPatientIDQualifiersSequence);
		tagByName.put("SourcePatientGroupIdentificationSequence",TagFromName.SourcePatientGroupIdentificationSequence);
		tagByName.put("GroupOfPatientsIdentificationSequence",TagFromName.GroupOfPatientsIdentificationSequence);
		tagByName.put("SubjectRelativePositionInImage",TagFromName.SubjectRelativePositionInImage);
		tagByName.put("PatientBirthDate",TagFromName.PatientBirthDate);
		tagByName.put("PatientBirthTime",TagFromName.PatientBirthTime);
		tagByName.put("PatientSex",TagFromName.PatientSex);
		tagByName.put("PatientInsurancePlanCodeSequence",TagFromName.PatientInsurancePlanCodeSequence);
		tagByName.put("PatientPrimaryLanguageCodeSequence",TagFromName.PatientPrimaryLanguageCodeSequence);
		tagByName.put("PatientPrimaryLanguageModifierCodeSequence",TagFromName.PatientPrimaryLanguageModifierCodeSequence);
		tagByName.put("QualityControlSubject",TagFromName.QualityControlSubject);
		tagByName.put("QualityControlSubjectTypeCodeSequence",TagFromName.QualityControlSubjectTypeCodeSequence);
		tagByName.put("StrainDescription",TagFromName.StrainDescription);
		tagByName.put("StrainNomenclature",TagFromName.StrainNomenclature);
		tagByName.put("StrainStockNumber",TagFromName.StrainStockNumber);
		tagByName.put("StrainSourceRegistryCodeSequence",TagFromName.StrainSourceRegistryCodeSequence);
		tagByName.put("StrainStockSequence",TagFromName.StrainStockSequence);
		tagByName.put("StrainSource",TagFromName.StrainSource);
		tagByName.put("StrainAdditionalInformation",TagFromName.StrainAdditionalInformation);
		tagByName.put("StrainCodeSequence",TagFromName.StrainCodeSequence);
		tagByName.put("OtherPatientIDs",TagFromName.OtherPatientIDs);
		tagByName.put("OtherPatientNames",TagFromName.OtherPatientNames);
		tagByName.put("OtherPatientIDsSequence",TagFromName.OtherPatientIDsSequence);
		tagByName.put("PatientBirthName",TagFromName.PatientBirthName);
		tagByName.put("PatientAge",TagFromName.PatientAge);
		tagByName.put("PatientSize",TagFromName.PatientSize);
		tagByName.put("PatientSizeCodeSequence",TagFromName.PatientSizeCodeSequence);
		tagByName.put("PatientWeight",TagFromName.PatientWeight);
		tagByName.put("PatientAddress",TagFromName.PatientAddress);
		tagByName.put("InsurancePlanIdentification",TagFromName.InsurancePlanIdentification);
		tagByName.put("PatientMotherBirthName",TagFromName.PatientMotherBirthName);
		tagByName.put("MilitaryRank",TagFromName.MilitaryRank);
		tagByName.put("BranchOfService",TagFromName.BranchOfService);
		tagByName.put("MedicalRecordLocator",TagFromName.MedicalRecordLocator);
		tagByName.put("ReferencedPatientPhotoSequence",TagFromName.ReferencedPatientPhotoSequence);
		tagByName.put("MedicalAlerts",TagFromName.MedicalAlerts);
		tagByName.put("Allergies",TagFromName.Allergies);
		tagByName.put("CountryOfResidence",TagFromName.CountryOfResidence);
		tagByName.put("RegionOfResidence",TagFromName.RegionOfResidence);
		tagByName.put("PatientTelephoneNumbers",TagFromName.PatientTelephoneNumbers);
		tagByName.put("PatientTelecomInformation",TagFromName.PatientTelecomInformation);
		tagByName.put("EthnicGroup",TagFromName.EthnicGroup);
		tagByName.put("Occupation",TagFromName.Occupation);
		tagByName.put("SmokingStatus",TagFromName.SmokingStatus);
		tagByName.put("AdditionalPatientHistory",TagFromName.AdditionalPatientHistory);
		tagByName.put("PregnancyStatus",TagFromName.PregnancyStatus);
		tagByName.put("LastMenstrualDate",TagFromName.LastMenstrualDate);
		tagByName.put("PatientReligiousPreference",TagFromName.PatientReligiousPreference);
		tagByName.put("PatientSpeciesDescription",TagFromName.PatientSpeciesDescription);
		tagByName.put("PatientSpeciesCodeSequence",TagFromName.PatientSpeciesCodeSequence);
		tagByName.put("PatientSexNeutered",TagFromName.PatientSexNeutered);
		tagByName.put("AnatomicalOrientationType",TagFromName.AnatomicalOrientationType);
		tagByName.put("PatientBreedDescription",TagFromName.PatientBreedDescription);
		tagByName.put("PatientBreedCodeSequence",TagFromName.PatientBreedCodeSequence);
		tagByName.put("BreedRegistrationSequence",TagFromName.BreedRegistrationSequence);
		tagByName.put("BreedRegistrationNumber",TagFromName.BreedRegistrationNumber);
		tagByName.put("BreedRegistryCodeSequence",TagFromName.BreedRegistryCodeSequence);
		tagByName.put("ResponsiblePerson",TagFromName.ResponsiblePerson);
		tagByName.put("ResponsiblePersonRole",TagFromName.ResponsiblePersonRole);
		tagByName.put("ResponsibleOrganization",TagFromName.ResponsibleOrganization);
		tagByName.put("PatientComments",TagFromName.PatientComments);
		tagByName.put("ExaminedBodyThickness",TagFromName.ExaminedBodyThickness);
		tagByName.put("ClinicalTrialSponsorName",TagFromName.ClinicalTrialSponsorName);
		tagByName.put("ClinicalTrialProtocolID",TagFromName.ClinicalTrialProtocolID);
		tagByName.put("ClinicalTrialProtocolName",TagFromName.ClinicalTrialProtocolName);
		tagByName.put("ClinicalTrialSiteID",TagFromName.ClinicalTrialSiteID);
		tagByName.put("ClinicalTrialSiteName",TagFromName.ClinicalTrialSiteName);
		tagByName.put("ClinicalTrialSubjectID",TagFromName.ClinicalTrialSubjectID);
		tagByName.put("ClinicalTrialSubjectReadingID",TagFromName.ClinicalTrialSubjectReadingID);
		tagByName.put("ClinicalTrialTimePointID",TagFromName.ClinicalTrialTimePointID);
		tagByName.put("ClinicalTrialTimePointDescription",TagFromName.ClinicalTrialTimePointDescription);
		tagByName.put("ClinicalTrialCoordinatingCenterName",TagFromName.ClinicalTrialCoordinatingCenterName);
		tagByName.put("PatientIdentityRemoved",TagFromName.PatientIdentityRemoved);
		tagByName.put("DeidentificationMethod",TagFromName.DeidentificationMethod);
		tagByName.put("DeidentificationMethodCodeSequence",TagFromName.DeidentificationMethodCodeSequence);
		tagByName.put("ClinicalTrialSeriesID",TagFromName.ClinicalTrialSeriesID);
		tagByName.put("ClinicalTrialSeriesDescription",TagFromName.ClinicalTrialSeriesDescription);
		tagByName.put("ClinicalTrialProtocolEthicsCommitteeName",TagFromName.ClinicalTrialProtocolEthicsCommitteeName);
		tagByName.put("ClinicalTrialProtocolEthicsCommitteeApprovalNumber",TagFromName.ClinicalTrialProtocolEthicsCommitteeApprovalNumber);
		tagByName.put("ConsentForClinicalTrialUseSequence",TagFromName.ConsentForClinicalTrialUseSequence);
		tagByName.put("DistributionType",TagFromName.DistributionType);
		tagByName.put("ConsentForDistributionFlag",TagFromName.ConsentForDistributionFlag);
		tagByName.put("CADFileFormatRetired",TagFromName.CADFileFormatRetired);
		tagByName.put("ComponentReferenceSystemRetired",TagFromName.ComponentReferenceSystemRetired);
		tagByName.put("ComponentManufacturingProcedure",TagFromName.ComponentManufacturingProcedure);
		tagByName.put("ComponentManufacturer",TagFromName.ComponentManufacturer);
		tagByName.put("MaterialThickness",TagFromName.MaterialThickness);
		tagByName.put("MaterialPipeDiameter",TagFromName.MaterialPipeDiameter);
		tagByName.put("MaterialIsolationDiameter",TagFromName.MaterialIsolationDiameter);
		tagByName.put("MaterialGrade",TagFromName.MaterialGrade);
		tagByName.put("MaterialPropertiesDescription",TagFromName.MaterialPropertiesDescription);
		tagByName.put("MaterialPropertiesFileFormatRetired",TagFromName.MaterialPropertiesFileFormatRetired);
		tagByName.put("MaterialNotes",TagFromName.MaterialNotes);
		tagByName.put("ComponentShape",TagFromName.ComponentShape);
		tagByName.put("CurvatureType",TagFromName.CurvatureType);
		tagByName.put("OuterDiameter",TagFromName.OuterDiameter);
		tagByName.put("InnerDiameter",TagFromName.InnerDiameter);
		tagByName.put("ComponentWelderIDs",TagFromName.ComponentWelderIDs);
		tagByName.put("SecondaryApprovalStatus",TagFromName.SecondaryApprovalStatus);
		tagByName.put("SecondaryReviewDate",TagFromName.SecondaryReviewDate);
		tagByName.put("SecondaryReviewTime",TagFromName.SecondaryReviewTime);
		tagByName.put("SecondaryReviewerName",TagFromName.SecondaryReviewerName);
		tagByName.put("RepairID",TagFromName.RepairID);
		tagByName.put("MultipleComponentApprovalSequence",TagFromName.MultipleComponentApprovalSequence);
		tagByName.put("OtherApprovalStatus",TagFromName.OtherApprovalStatus);
		tagByName.put("OtherSecondaryApprovalStatus",TagFromName.OtherSecondaryApprovalStatus);
		tagByName.put("ActualEnvironmentalConditions",TagFromName.ActualEnvironmentalConditions);
		tagByName.put("ExpiryDate",TagFromName.ExpiryDate);
		tagByName.put("EnvironmentalConditions",TagFromName.EnvironmentalConditions);
		tagByName.put("EvaluatorSequence",TagFromName.EvaluatorSequence);
		tagByName.put("EvaluatorNumber",TagFromName.EvaluatorNumber);
		tagByName.put("EvaluatorName",TagFromName.EvaluatorName);
		tagByName.put("EvaluationAttempt",TagFromName.EvaluationAttempt);
		tagByName.put("IndicationSequence",TagFromName.IndicationSequence);
		tagByName.put("IndicationNumber",TagFromName.IndicationNumber);
		tagByName.put("IndicationLabel",TagFromName.IndicationLabel);
		tagByName.put("IndicationDescription",TagFromName.IndicationDescription);
		tagByName.put("IndicationType",TagFromName.IndicationType);
		tagByName.put("IndicationDisposition",TagFromName.IndicationDisposition);
		tagByName.put("IndicationROISequence",TagFromName.IndicationROISequence);
		tagByName.put("IndicationPhysicalPropertySequence",TagFromName.IndicationPhysicalPropertySequence);
		tagByName.put("PropertyLabel",TagFromName.PropertyLabel);
		tagByName.put("CoordinateSystemNumberOfAxes",TagFromName.CoordinateSystemNumberOfAxes);
		tagByName.put("CoordinateSystemAxesSequence",TagFromName.CoordinateSystemAxesSequence);
		tagByName.put("CoordinateSystemAxisDescription",TagFromName.CoordinateSystemAxisDescription);
		tagByName.put("CoordinateSystemDataSetMapping",TagFromName.CoordinateSystemDataSetMapping);
		tagByName.put("CoordinateSystemAxisNumber",TagFromName.CoordinateSystemAxisNumber);
		tagByName.put("CoordinateSystemAxisType",TagFromName.CoordinateSystemAxisType);
		tagByName.put("CoordinateSystemAxisUnits",TagFromName.CoordinateSystemAxisUnits);
		tagByName.put("CoordinateSystemAxisValues",TagFromName.CoordinateSystemAxisValues);
		tagByName.put("CoordinateSystemTransformSequence",TagFromName.CoordinateSystemTransformSequence);
		tagByName.put("TransformDescription",TagFromName.TransformDescription);
		tagByName.put("TransformNumberOfAxes",TagFromName.TransformNumberOfAxes);
		tagByName.put("TransformOrderOfAxes",TagFromName.TransformOrderOfAxes);
		tagByName.put("TransformedAxisUnits",TagFromName.TransformedAxisUnits);
		tagByName.put("CoordinateSystemTransformRotationAndScaleMatrix",TagFromName.CoordinateSystemTransformRotationAndScaleMatrix);
		tagByName.put("CoordinateSystemTransformTranslationMatrix",TagFromName.CoordinateSystemTransformTranslationMatrix);
		tagByName.put("InternalDetectorFrameTime",TagFromName.InternalDetectorFrameTime);
		tagByName.put("NumberOfFramesIntegrated",TagFromName.NumberOfFramesIntegrated);
		tagByName.put("DetectorTemperatureSequence",TagFromName.DetectorTemperatureSequence);
		tagByName.put("SensorName",TagFromName.SensorName);
		tagByName.put("HorizontalOffsetOfSensor",TagFromName.HorizontalOffsetOfSensor);
		tagByName.put("VerticalOffsetOfSensor",TagFromName.VerticalOffsetOfSensor);
		tagByName.put("SensorTemperature",TagFromName.SensorTemperature);
		tagByName.put("DarkCurrentSequence",TagFromName.DarkCurrentSequence);
		tagByName.put("DarkCurrentCounts",TagFromName.DarkCurrentCounts);
		tagByName.put("GainCorrectionReferenceSequence",TagFromName.GainCorrectionReferenceSequence);
		tagByName.put("AirCounts",TagFromName.AirCounts);
		tagByName.put("KVUsedInGainCalibration",TagFromName.KVUsedInGainCalibration);
		tagByName.put("MAUsedInGainCalibration",TagFromName.MAUsedInGainCalibration);
		tagByName.put("NumberOfFramesUsedForIntegration",TagFromName.NumberOfFramesUsedForIntegration);
		tagByName.put("FilterMaterialUsedInGainCalibration",TagFromName.FilterMaterialUsedInGainCalibration);
		tagByName.put("FilterThicknessUsedInGainCalibration",TagFromName.FilterThicknessUsedInGainCalibration);
		tagByName.put("DateOfGainCalibration",TagFromName.DateOfGainCalibration);
		tagByName.put("TimeOfGainCalibration",TagFromName.TimeOfGainCalibration);
		tagByName.put("BadPixelImage",TagFromName.BadPixelImage);
		tagByName.put("CalibrationNotes",TagFromName.CalibrationNotes);
		tagByName.put("PulserEquipmentSequence",TagFromName.PulserEquipmentSequence);
		tagByName.put("PulserType",TagFromName.PulserType);
		tagByName.put("PulserNotes",TagFromName.PulserNotes);
		tagByName.put("ReceiverEquipmentSequence",TagFromName.ReceiverEquipmentSequence);
		tagByName.put("AmplifierType",TagFromName.AmplifierType);
		tagByName.put("ReceiverNotes",TagFromName.ReceiverNotes);
		tagByName.put("PreAmplifierEquipmentSequence",TagFromName.PreAmplifierEquipmentSequence);
		tagByName.put("PreAmplifierNotes",TagFromName.PreAmplifierNotes);
		tagByName.put("TransmitTransducerSequence",TagFromName.TransmitTransducerSequence);
		tagByName.put("ReceiveTransducerSequence",TagFromName.ReceiveTransducerSequence);
		tagByName.put("NumberOfElements",TagFromName.NumberOfElements);
		tagByName.put("ElementShape",TagFromName.ElementShape);
		tagByName.put("ElementDimensionA",TagFromName.ElementDimensionA);
		tagByName.put("ElementDimensionB",TagFromName.ElementDimensionB);
		tagByName.put("ElementPitchA",TagFromName.ElementPitchA);
		tagByName.put("MeasuredBeamDimensionA",TagFromName.MeasuredBeamDimensionA);
		tagByName.put("MeasuredBeamDimensionB",TagFromName.MeasuredBeamDimensionB);
		tagByName.put("LocationOfMeasuredBeamDiameter",TagFromName.LocationOfMeasuredBeamDiameter);
		tagByName.put("NominalFrequency",TagFromName.NominalFrequency);
		tagByName.put("MeasuredCenterFrequency",TagFromName.MeasuredCenterFrequency);
		tagByName.put("MeasuredBandwidth",TagFromName.MeasuredBandwidth);
		tagByName.put("ElementPitchB",TagFromName.ElementPitchB);
		tagByName.put("PulserSettingsSequence",TagFromName.PulserSettingsSequence);
		tagByName.put("PulseWidth",TagFromName.PulseWidth);
		tagByName.put("ExcitationFrequency",TagFromName.ExcitationFrequency);
		tagByName.put("ModulationType",TagFromName.ModulationType);
		tagByName.put("Damping",TagFromName.Damping);
		tagByName.put("ReceiverSettingsSequence",TagFromName.ReceiverSettingsSequence);
		tagByName.put("AcquiredSoundpathLength",TagFromName.AcquiredSoundpathLength);
		tagByName.put("AcquisitionCompressionType",TagFromName.AcquisitionCompressionType);
		tagByName.put("AcquisitionSampleSize",TagFromName.AcquisitionSampleSize);
		tagByName.put("RectifierSmoothing",TagFromName.RectifierSmoothing);
		tagByName.put("DACSequence",TagFromName.DACSequence);
		tagByName.put("DACType",TagFromName.DACType);
		tagByName.put("DACGainPoints",TagFromName.DACGainPoints);
		tagByName.put("DACTimePoints",TagFromName.DACTimePoints);
		tagByName.put("DACAmplitude",TagFromName.DACAmplitude);
		tagByName.put("PreAmplifierSettingsSequence",TagFromName.PreAmplifierSettingsSequence);
		tagByName.put("TransmitTransducerSettingsSequence",TagFromName.TransmitTransducerSettingsSequence);
		tagByName.put("ReceiveTransducerSettingsSequence",TagFromName.ReceiveTransducerSettingsSequence);
		tagByName.put("IncidentAngle",TagFromName.IncidentAngle);
		tagByName.put("CouplingTechnique",TagFromName.CouplingTechnique);
		tagByName.put("CouplingMedium",TagFromName.CouplingMedium);
		tagByName.put("CouplingVelocity",TagFromName.CouplingVelocity);
		tagByName.put("ProbeCenterLocationX",TagFromName.ProbeCenterLocationX);
		tagByName.put("ProbeCenterLocationZ",TagFromName.ProbeCenterLocationZ);
		tagByName.put("SoundPathLength",TagFromName.SoundPathLength);
		tagByName.put("DelayLawIdentifier",TagFromName.DelayLawIdentifier);
		tagByName.put("GateSettingsSequence",TagFromName.GateSettingsSequence);
		tagByName.put("GateThreshold",TagFromName.GateThreshold);
		tagByName.put("VelocityOfSound",TagFromName.VelocityOfSound);
		tagByName.put("CalibrationSettingsSequence",TagFromName.CalibrationSettingsSequence);
		tagByName.put("CalibrationProcedure",TagFromName.CalibrationProcedure);
		tagByName.put("ProcedureVersion",TagFromName.ProcedureVersion);
		tagByName.put("ProcedureCreationDate",TagFromName.ProcedureCreationDate);
		tagByName.put("ProcedureExpirationDate",TagFromName.ProcedureExpirationDate);
		tagByName.put("ProcedureLastModifiedDate",TagFromName.ProcedureLastModifiedDate);
		tagByName.put("CalibrationTime",TagFromName.CalibrationTime);
		tagByName.put("CalibrationDate",TagFromName.CalibrationDate);
		tagByName.put("ProbeDriveEquipmentSequence",TagFromName.ProbeDriveEquipmentSequence);
		tagByName.put("DriveType",TagFromName.DriveType);
		tagByName.put("ProbeDriveNotes",TagFromName.ProbeDriveNotes);
		tagByName.put("DriveProbeSequence",TagFromName.DriveProbeSequence);
		tagByName.put("ProbeInductance",TagFromName.ProbeInductance);
		tagByName.put("ProbeResistance",TagFromName.ProbeResistance);
		tagByName.put("ReceiveProbeSequence",TagFromName.ReceiveProbeSequence);
		tagByName.put("ProbeDriveSettingsSequence",TagFromName.ProbeDriveSettingsSequence);
		tagByName.put("BridgeResistors",TagFromName.BridgeResistors);
		tagByName.put("ProbeOrientationAngle",TagFromName.ProbeOrientationAngle);
		tagByName.put("UserSelectedGainY",TagFromName.UserSelectedGainY);
		tagByName.put("UserSelectedPhase",TagFromName.UserSelectedPhase);
		tagByName.put("UserSelectedOffsetX",TagFromName.UserSelectedOffsetX);
		tagByName.put("UserSelectedOffsetY",TagFromName.UserSelectedOffsetY);
		tagByName.put("ChannelSettingsSequence",TagFromName.ChannelSettingsSequence);
		tagByName.put("ChannelThreshold",TagFromName.ChannelThreshold);
		tagByName.put("ScannerSettingsSequence",TagFromName.ScannerSettingsSequence);
		tagByName.put("ScanProcedure",TagFromName.ScanProcedure);
		tagByName.put("TranslationRateX",TagFromName.TranslationRateX);
		tagByName.put("TranslationRateY",TagFromName.TranslationRateY);
		tagByName.put("ChannelOverlap",TagFromName.ChannelOverlap);
		tagByName.put("ImageQualityIndicatorType",TagFromName.ImageQualityIndicatorType);
		tagByName.put("ImageQualityIndicatorMaterial",TagFromName.ImageQualityIndicatorMaterial);
		tagByName.put("ImageQualityIndicatorSize",TagFromName.ImageQualityIndicatorSize);
		tagByName.put("LINACEnergy",TagFromName.LINACEnergy);
		tagByName.put("LINACOutput",TagFromName.LINACOutput);
		tagByName.put("ActiveAperture",TagFromName.ActiveAperture);
		tagByName.put("TotalAperture",TagFromName.TotalAperture);
		tagByName.put("ApertureElevation",TagFromName.ApertureElevation);
		tagByName.put("MainLobeAngle",TagFromName.MainLobeAngle);
		tagByName.put("MainRoofAngle",TagFromName.MainRoofAngle);
		tagByName.put("ConnectorType",TagFromName.ConnectorType);
		tagByName.put("WedgeModelNumber",TagFromName.WedgeModelNumber);
		tagByName.put("WedgeAngleFloat",TagFromName.WedgeAngleFloat);
		tagByName.put("WedgeRoofAngle",TagFromName.WedgeRoofAngle);
		tagByName.put("WedgeElement1Position",TagFromName.WedgeElement1Position);
		tagByName.put("WedgeMaterialVelocity",TagFromName.WedgeMaterialVelocity);
		tagByName.put("WedgeMaterial",TagFromName.WedgeMaterial);
		tagByName.put("WedgeOffsetZ",TagFromName.WedgeOffsetZ);
		tagByName.put("WedgeOriginOffsetX",TagFromName.WedgeOriginOffsetX);
		tagByName.put("WedgeTimeDelay",TagFromName.WedgeTimeDelay);
		tagByName.put("WedgeName",TagFromName.WedgeName);
		tagByName.put("WedgeManufacturerName",TagFromName.WedgeManufacturerName);
		tagByName.put("WedgeDescription",TagFromName.WedgeDescription);
		tagByName.put("NominalBeamAngle",TagFromName.NominalBeamAngle);
		tagByName.put("WedgeOffsetX",TagFromName.WedgeOffsetX);
		tagByName.put("WedgeOffsetY",TagFromName.WedgeOffsetY);
		tagByName.put("WedgeTotalLength",TagFromName.WedgeTotalLength);
		tagByName.put("WedgeInContactLength",TagFromName.WedgeInContactLength);
		tagByName.put("WedgeFrontGap",TagFromName.WedgeFrontGap);
		tagByName.put("WedgeTotalHeight",TagFromName.WedgeTotalHeight);
		tagByName.put("WedgeFrontHeight",TagFromName.WedgeFrontHeight);
		tagByName.put("WedgeRearHeight",TagFromName.WedgeRearHeight);
		tagByName.put("WedgeTotalWidth",TagFromName.WedgeTotalWidth);
		tagByName.put("WedgeInContactWidth",TagFromName.WedgeInContactWidth);
		tagByName.put("WedgeChamferHeight",TagFromName.WedgeChamferHeight);
		tagByName.put("WedgeCurve",TagFromName.WedgeCurve);
		tagByName.put("RadiusAlongWedge",TagFromName.RadiusAlongWedge);
		tagByName.put("ContrastBolusAgent",TagFromName.ContrastBolusAgent);
		tagByName.put("ContrastBolusAgentSequence",TagFromName.ContrastBolusAgentSequence);
		tagByName.put("ContrastBolusT1Relaxivity",TagFromName.ContrastBolusT1Relaxivity);
		tagByName.put("ContrastBolusAdministrationRouteSequence",TagFromName.ContrastBolusAdministrationRouteSequence);
		tagByName.put("BodyPartExamined",TagFromName.BodyPartExamined);
		tagByName.put("ScanningSequence",TagFromName.ScanningSequence);
		tagByName.put("SequenceVariant",TagFromName.SequenceVariant);
		tagByName.put("ScanOptions",TagFromName.ScanOptions);
		tagByName.put("MRAcquisitionType",TagFromName.MRAcquisitionType);
		tagByName.put("SequenceName",TagFromName.SequenceName);
		tagByName.put("AngioFlag",TagFromName.AngioFlag);
		tagByName.put("InterventionDrugInformationSequence",TagFromName.InterventionDrugInformationSequence);
		tagByName.put("InterventionDrugStopTime",TagFromName.InterventionDrugStopTime);
		tagByName.put("InterventionDrugDose",TagFromName.InterventionDrugDose);
		tagByName.put("InterventionDrugCodeSequence",TagFromName.InterventionDrugCodeSequence);
		tagByName.put("AdditionalDrugSequence",TagFromName.AdditionalDrugSequence);
		tagByName.put("Radionuclide",TagFromName.Radionuclide);
		tagByName.put("Radiopharmaceutical",TagFromName.Radiopharmaceutical);
		tagByName.put("EnergyWindowCenterline",TagFromName.EnergyWindowCenterline);
		tagByName.put("EnergyWindowTotalWidth",TagFromName.EnergyWindowTotalWidth);
		tagByName.put("InterventionDrugName",TagFromName.InterventionDrugName);
		tagByName.put("InterventionDrugStartTime",TagFromName.InterventionDrugStartTime);
		tagByName.put("InterventionSequence",TagFromName.InterventionSequence);
		tagByName.put("TherapyType",TagFromName.TherapyType);
		tagByName.put("InterventionStatus",TagFromName.InterventionStatus);
		tagByName.put("TherapyDescription",TagFromName.TherapyDescription);
		tagByName.put("InterventionDescription",TagFromName.InterventionDescription);
		tagByName.put("CineRate",TagFromName.CineRate);
		tagByName.put("InitialCineRunState",TagFromName.InitialCineRunState);
		tagByName.put("SliceThickness",TagFromName.SliceThickness);
		tagByName.put("KVP",TagFromName.KVP);
		tagByName.put("CountsAccumulated",TagFromName.CountsAccumulated);
		tagByName.put("AcquisitionTerminationCondition",TagFromName.AcquisitionTerminationCondition);
		tagByName.put("EffectiveDuration",TagFromName.EffectiveDuration);
		tagByName.put("AcquisitionStartCondition",TagFromName.AcquisitionStartCondition);
		tagByName.put("AcquisitionStartConditionData",TagFromName.AcquisitionStartConditionData);
		tagByName.put("AcquisitionTerminationConditionData",TagFromName.AcquisitionTerminationConditionData);
		tagByName.put("RepetitionTime",TagFromName.RepetitionTime);
		tagByName.put("EchoTime",TagFromName.EchoTime);
		tagByName.put("InversionTime",TagFromName.InversionTime);
		tagByName.put("NumberOfAverages",TagFromName.NumberOfAverages);
		tagByName.put("ImagingFrequency",TagFromName.ImagingFrequency);
		tagByName.put("ImagedNucleus",TagFromName.ImagedNucleus);
		tagByName.put("EchoNumbers",TagFromName.EchoNumbers);
		tagByName.put("MagneticFieldStrength",TagFromName.MagneticFieldStrength);
		tagByName.put("SpacingBetweenSlices",TagFromName.SpacingBetweenSlices);
		tagByName.put("NumberOfPhaseEncodingSteps",TagFromName.NumberOfPhaseEncodingSteps);
		tagByName.put("DataCollectionDiameter",TagFromName.DataCollectionDiameter);
		tagByName.put("EchoTrainLength",TagFromName.EchoTrainLength);
		tagByName.put("PercentSampling",TagFromName.PercentSampling);
		tagByName.put("PercentPhaseFieldOfView",TagFromName.PercentPhaseFieldOfView);
		tagByName.put("PixelBandwidth",TagFromName.PixelBandwidth);
		tagByName.put("DeviceSerialNumber",TagFromName.DeviceSerialNumber);
		tagByName.put("DeviceUID",TagFromName.DeviceUID);
		tagByName.put("DeviceID",TagFromName.DeviceID);
		tagByName.put("PlateID",TagFromName.PlateID);
		tagByName.put("GeneratorID",TagFromName.GeneratorID);
		tagByName.put("GridID",TagFromName.GridID);
		tagByName.put("CassetteID",TagFromName.CassetteID);
		tagByName.put("GantryID",TagFromName.GantryID);
		tagByName.put("SecondaryCaptureDeviceID",TagFromName.SecondaryCaptureDeviceID);
		tagByName.put("HardcopyCreationDeviceID",TagFromName.HardcopyCreationDeviceID);
		tagByName.put("DateOfSecondaryCapture",TagFromName.DateOfSecondaryCapture);
		tagByName.put("TimeOfSecondaryCapture",TagFromName.TimeOfSecondaryCapture);
		tagByName.put("SecondaryCaptureDeviceManufacturer",TagFromName.SecondaryCaptureDeviceManufacturer);
		tagByName.put("HardcopyDeviceManufacturer",TagFromName.HardcopyDeviceManufacturer);
		tagByName.put("SecondaryCaptureDeviceManufacturerModelName",TagFromName.SecondaryCaptureDeviceManufacturerModelName);
		tagByName.put("SecondaryCaptureDeviceSoftwareVersions",TagFromName.SecondaryCaptureDeviceSoftwareVersions);
		tagByName.put("HardcopyDeviceSoftwareVersion",TagFromName.HardcopyDeviceSoftwareVersion);
		tagByName.put("HardcopyDeviceManufacturerModelName",TagFromName.HardcopyDeviceManufacturerModelName);
		tagByName.put("SoftwareVersions",TagFromName.SoftwareVersions);
		tagByName.put("VideoImageFormatAcquired",TagFromName.VideoImageFormatAcquired);
		tagByName.put("DigitalImageFormatAcquired",TagFromName.DigitalImageFormatAcquired);
		tagByName.put("ProtocolName",TagFromName.ProtocolName);
		tagByName.put("ContrastBolusRoute",TagFromName.ContrastBolusRoute);
		tagByName.put("ContrastBolusVolume",TagFromName.ContrastBolusVolume);
		tagByName.put("ContrastBolusStartTime",TagFromName.ContrastBolusStartTime);
		tagByName.put("ContrastBolusStopTime",TagFromName.ContrastBolusStopTime);
		tagByName.put("ContrastBolusTotalDose",TagFromName.ContrastBolusTotalDose);
		tagByName.put("SyringeCounts",TagFromName.SyringeCounts);
		tagByName.put("ContrastFlowRate",TagFromName.ContrastFlowRate);
		tagByName.put("ContrastFlowDuration",TagFromName.ContrastFlowDuration);
		tagByName.put("ContrastBolusIngredient",TagFromName.ContrastBolusIngredient);
		tagByName.put("ContrastBolusIngredientConcentration",TagFromName.ContrastBolusIngredientConcentration);
		tagByName.put("SpatialResolution",TagFromName.SpatialResolution);
		tagByName.put("TriggerTime",TagFromName.TriggerTime);
		tagByName.put("TriggerSourceOrType",TagFromName.TriggerSourceOrType);
		tagByName.put("NominalInterval",TagFromName.NominalInterval);
		tagByName.put("FrameTime",TagFromName.FrameTime);
		tagByName.put("CardiacFramingType",TagFromName.CardiacFramingType);
		tagByName.put("FrameTimeVector",TagFromName.FrameTimeVector);
		tagByName.put("FrameDelay",TagFromName.FrameDelay);
		tagByName.put("ImageTriggerDelay",TagFromName.ImageTriggerDelay);
		tagByName.put("MultiplexGroupTimeOffset",TagFromName.MultiplexGroupTimeOffset);
		tagByName.put("TriggerTimeOffset",TagFromName.TriggerTimeOffset);
		tagByName.put("SynchronizationTrigger",TagFromName.SynchronizationTrigger);
		tagByName.put("SynchronizationChannel",TagFromName.SynchronizationChannel);
		tagByName.put("TriggerSamplePosition",TagFromName.TriggerSamplePosition);
		tagByName.put("RadiopharmaceuticalRoute",TagFromName.RadiopharmaceuticalRoute);
		tagByName.put("RadiopharmaceuticalVolume",TagFromName.RadiopharmaceuticalVolume);
		tagByName.put("RadiopharmaceuticalStartTime",TagFromName.RadiopharmaceuticalStartTime);
		tagByName.put("RadiopharmaceuticalStopTime",TagFromName.RadiopharmaceuticalStopTime);
		tagByName.put("RadionuclideTotalDose",TagFromName.RadionuclideTotalDose);
		tagByName.put("RadionuclideHalfLife",TagFromName.RadionuclideHalfLife);
		tagByName.put("RadionuclidePositronFraction",TagFromName.RadionuclidePositronFraction);
		tagByName.put("RadiopharmaceuticalSpecificActivity",TagFromName.RadiopharmaceuticalSpecificActivity);
		tagByName.put("RadiopharmaceuticalStartDateTime",TagFromName.RadiopharmaceuticalStartDateTime);
		tagByName.put("RadiopharmaceuticalStopDateTime",TagFromName.RadiopharmaceuticalStopDateTime);
		tagByName.put("BeatRejectionFlag",TagFromName.BeatRejectionFlag);
		tagByName.put("LowRRValue",TagFromName.LowRRValue);
		tagByName.put("HighRRValue",TagFromName.HighRRValue);
		tagByName.put("IntervalsAcquired",TagFromName.IntervalsAcquired);
		tagByName.put("IntervalsRejected",TagFromName.IntervalsRejected);
		tagByName.put("PVCRejection",TagFromName.PVCRejection);
		tagByName.put("SkipBeats",TagFromName.SkipBeats);
		tagByName.put("HeartRate",TagFromName.HeartRate);
		tagByName.put("CardiacNumberOfImages",TagFromName.CardiacNumberOfImages);
		tagByName.put("TriggerWindow",TagFromName.TriggerWindow);
		tagByName.put("ReconstructionDiameter",TagFromName.ReconstructionDiameter);
		tagByName.put("DistanceSourceToDetector",TagFromName.DistanceSourceToDetector);
		tagByName.put("DistanceSourceToPatient",TagFromName.DistanceSourceToPatient);
		tagByName.put("EstimatedRadiographicMagnificationFactor",TagFromName.EstimatedRadiographicMagnificationFactor);
		tagByName.put("GantryDetectorTilt",TagFromName.GantryDetectorTilt);
		tagByName.put("GantryDetectorSlew",TagFromName.GantryDetectorSlew);
		tagByName.put("TableHeight",TagFromName.TableHeight);
		tagByName.put("TableTraverse",TagFromName.TableTraverse);
		tagByName.put("TableMotion",TagFromName.TableMotion);
		tagByName.put("TableVerticalIncrement",TagFromName.TableVerticalIncrement);
		tagByName.put("TableLateralIncrement",TagFromName.TableLateralIncrement);
		tagByName.put("TableLongitudinalIncrement",TagFromName.TableLongitudinalIncrement);
		tagByName.put("TableAngle",TagFromName.TableAngle);
		tagByName.put("TableType",TagFromName.TableType);
		tagByName.put("RotationDirection",TagFromName.RotationDirection);
		tagByName.put("AngularPosition",TagFromName.AngularPosition);
		tagByName.put("RadialPosition",TagFromName.RadialPosition);
		tagByName.put("ScanArc",TagFromName.ScanArc);
		tagByName.put("AngularStep",TagFromName.AngularStep);
		tagByName.put("CenterOfRotationOffset",TagFromName.CenterOfRotationOffset);
		tagByName.put("RotationOffset",TagFromName.RotationOffset);
		tagByName.put("FieldOfViewShape",TagFromName.FieldOfViewShape);
		tagByName.put("FieldOfViewDimensions",TagFromName.FieldOfViewDimensions);
		tagByName.put("ExposureTime",TagFromName.ExposureTime);
		tagByName.put("XRayTubeCurrent",TagFromName.XRayTubeCurrent);
		tagByName.put("Exposure",TagFromName.Exposure);
		tagByName.put("ExposureInuAs",TagFromName.ExposureInuAs);
		tagByName.put("AveragePulseWidth",TagFromName.AveragePulseWidth);
		tagByName.put("RadiationSetting",TagFromName.RadiationSetting);
		tagByName.put("RectificationType",TagFromName.RectificationType);
		tagByName.put("RadiationMode",TagFromName.RadiationMode);
		tagByName.put("ImageAndFluoroscopyAreaDoseProduct",TagFromName.ImageAndFluoroscopyAreaDoseProduct);
		tagByName.put("FilterType",TagFromName.FilterType);
		tagByName.put("TypeOfFilters",TagFromName.TypeOfFilters);
		tagByName.put("IntensifierSize",TagFromName.IntensifierSize);
		tagByName.put("ImagerPixelSpacing",TagFromName.ImagerPixelSpacing);
		tagByName.put("Grid",TagFromName.Grid);
		tagByName.put("GeneratorPower",TagFromName.GeneratorPower);
		tagByName.put("CollimatorGridName",TagFromName.CollimatorGridName);
		tagByName.put("CollimatorType",TagFromName.CollimatorType);
		tagByName.put("FocalDistance",TagFromName.FocalDistance);
		tagByName.put("XFocusCenter",TagFromName.XFocusCenter);
		tagByName.put("YFocusCenter",TagFromName.YFocusCenter);
		tagByName.put("FocalSpots",TagFromName.FocalSpots);
		tagByName.put("AnodeTargetMaterial",TagFromName.AnodeTargetMaterial);
		tagByName.put("BodyPartThickness",TagFromName.BodyPartThickness);
		tagByName.put("CompressionForce",TagFromName.CompressionForce);
		tagByName.put("PaddleDescription",TagFromName.PaddleDescription);
		tagByName.put("DateOfLastCalibration",TagFromName.DateOfLastCalibration);
		tagByName.put("TimeOfLastCalibration",TagFromName.TimeOfLastCalibration);
		tagByName.put("DateTimeOfLastCalibration",TagFromName.DateTimeOfLastCalibration);
		tagByName.put("ConvolutionKernel",TagFromName.ConvolutionKernel);
		tagByName.put("UpperLowerPixelValues",TagFromName.UpperLowerPixelValues);
		tagByName.put("ActualFrameDuration",TagFromName.ActualFrameDuration);
		tagByName.put("CountRate",TagFromName.CountRate);
		tagByName.put("PreferredPlaybackSequencing",TagFromName.PreferredPlaybackSequencing);
		tagByName.put("ReceiveCoilName",TagFromName.ReceiveCoilName);
		tagByName.put("TransmitCoilName",TagFromName.TransmitCoilName);
		tagByName.put("PlateType",TagFromName.PlateType);
		tagByName.put("PhosphorType",TagFromName.PhosphorType);
		tagByName.put("ScanVelocity",TagFromName.ScanVelocity);
		tagByName.put("WholeBodyTechnique",TagFromName.WholeBodyTechnique);
		tagByName.put("ScanLength",TagFromName.ScanLength);
		tagByName.put("AcquisitionMatrix",TagFromName.AcquisitionMatrix);
		tagByName.put("InPlanePhaseEncodingDirection",TagFromName.InPlanePhaseEncodingDirection);
		tagByName.put("FlipAngle",TagFromName.FlipAngle);
		tagByName.put("VariableFlipAngleFlag",TagFromName.VariableFlipAngleFlag);
		tagByName.put("SAR",TagFromName.SAR);
		tagByName.put("dBdt",TagFromName.dBdt);
		tagByName.put("B1rms",TagFromName.B1rms);
		tagByName.put("AcquisitionDeviceProcessingDescription",TagFromName.AcquisitionDeviceProcessingDescription);
		tagByName.put("AcquisitionDeviceProcessingCode",TagFromName.AcquisitionDeviceProcessingCode);
		tagByName.put("CassetteOrientation",TagFromName.CassetteOrientation);
		tagByName.put("CassetteSize",TagFromName.CassetteSize);
		tagByName.put("ExposuresOnPlate",TagFromName.ExposuresOnPlate);
		tagByName.put("RelativeXRayExposure",TagFromName.RelativeXRayExposure);
		tagByName.put("ExposureIndex",TagFromName.ExposureIndex);
		tagByName.put("TargetExposureIndex",TagFromName.TargetExposureIndex);
		tagByName.put("DeviationIndex",TagFromName.DeviationIndex);
		tagByName.put("ColumnAngulation",TagFromName.ColumnAngulation);
		tagByName.put("TomoLayerHeight",TagFromName.TomoLayerHeight);
		tagByName.put("TomoAngle",TagFromName.TomoAngle);
		tagByName.put("TomoTime",TagFromName.TomoTime);
		tagByName.put("TomoType",TagFromName.TomoType);
		tagByName.put("TomoClass",TagFromName.TomoClass);
		tagByName.put("NumberOfTomosynthesisSourceImages",TagFromName.NumberOfTomosynthesisSourceImages);
		tagByName.put("PositionerMotion",TagFromName.PositionerMotion);
		tagByName.put("PositionerType",TagFromName.PositionerType);
		tagByName.put("PositionerPrimaryAngle",TagFromName.PositionerPrimaryAngle);
		tagByName.put("PositionerSecondaryAngle",TagFromName.PositionerSecondaryAngle);
		tagByName.put("PositionerPrimaryAngleIncrement",TagFromName.PositionerPrimaryAngleIncrement);
		tagByName.put("PositionerSecondaryAngleIncrement",TagFromName.PositionerSecondaryAngleIncrement);
		tagByName.put("DetectorPrimaryAngle",TagFromName.DetectorPrimaryAngle);
		tagByName.put("DetectorSecondaryAngle",TagFromName.DetectorSecondaryAngle);
		tagByName.put("ShutterShape",TagFromName.ShutterShape);
		tagByName.put("ShutterLeftVerticalEdge",TagFromName.ShutterLeftVerticalEdge);
		tagByName.put("ShutterRightVerticalEdge",TagFromName.ShutterRightVerticalEdge);
		tagByName.put("ShutterUpperHorizontalEdge",TagFromName.ShutterUpperHorizontalEdge);
		tagByName.put("ShutterLowerHorizontalEdge",TagFromName.ShutterLowerHorizontalEdge);
		tagByName.put("CenterOfCircularShutter",TagFromName.CenterOfCircularShutter);
		tagByName.put("RadiusOfCircularShutter",TagFromName.RadiusOfCircularShutter);
		tagByName.put("VerticesOfThePolygonalShutter",TagFromName.VerticesOfThePolygonalShutter);
		tagByName.put("ShutterPresentationValue",TagFromName.ShutterPresentationValue);
		tagByName.put("ShutterOverlayGroup",TagFromName.ShutterOverlayGroup);
		tagByName.put("ShutterPresentationColorCIELabValue",TagFromName.ShutterPresentationColorCIELabValue);
		tagByName.put("CollimatorShape",TagFromName.CollimatorShape);
		tagByName.put("CollimatorLeftVerticalEdge",TagFromName.CollimatorLeftVerticalEdge);
		tagByName.put("CollimatorRightVerticalEdge",TagFromName.CollimatorRightVerticalEdge);
		tagByName.put("CollimatorUpperHorizontalEdge",TagFromName.CollimatorUpperHorizontalEdge);
		tagByName.put("CollimatorLowerHorizontalEdge",TagFromName.CollimatorLowerHorizontalEdge);
		tagByName.put("CenterOfCircularCollimator",TagFromName.CenterOfCircularCollimator);
		tagByName.put("RadiusOfCircularCollimator",TagFromName.RadiusOfCircularCollimator);
		tagByName.put("VerticesOfThePolygonalCollimator",TagFromName.VerticesOfThePolygonalCollimator);
		tagByName.put("AcquisitionTimeSynchronized",TagFromName.AcquisitionTimeSynchronized);
		tagByName.put("TimeSource",TagFromName.TimeSource);
		tagByName.put("TimeDistributionProtocol",TagFromName.TimeDistributionProtocol);
		tagByName.put("NTPSourceAddress",TagFromName.NTPSourceAddress);
		tagByName.put("PageNumberVector",TagFromName.PageNumberVector);
		tagByName.put("FrameLabelVector",TagFromName.FrameLabelVector);
		tagByName.put("FramePrimaryAngleVector",TagFromName.FramePrimaryAngleVector);
		tagByName.put("FrameSecondaryAngleVector",TagFromName.FrameSecondaryAngleVector);
		tagByName.put("SliceLocationVector",TagFromName.SliceLocationVector);
		tagByName.put("DisplayWindowLabelVector",TagFromName.DisplayWindowLabelVector);
		tagByName.put("NominalScannedPixelSpacing",TagFromName.NominalScannedPixelSpacing);
		tagByName.put("DigitizingDeviceTransportDirection",TagFromName.DigitizingDeviceTransportDirection);
		tagByName.put("RotationOfScannedFilm",TagFromName.RotationOfScannedFilm);
		tagByName.put("BiopsyTargetSequence",TagFromName.BiopsyTargetSequence);
		tagByName.put("TargetUID",TagFromName.TargetUID);
		tagByName.put("LocalizingCursorPosition",TagFromName.LocalizingCursorPosition);
		tagByName.put("CalculatedTargetPosition",TagFromName.CalculatedTargetPosition);
		tagByName.put("TargetLabel",TagFromName.TargetLabel);
		tagByName.put("DisplayedZValue",TagFromName.DisplayedZValue);
		tagByName.put("IVUSAcquisition",TagFromName.IVUSAcquisition);
		tagByName.put("IVUSPullbackRate",TagFromName.IVUSPullbackRate);
		tagByName.put("IVUSGatedRate",TagFromName.IVUSGatedRate);
		tagByName.put("IVUSPullbackStartFrameNumber",TagFromName.IVUSPullbackStartFrameNumber);
		tagByName.put("IVUSPullbackStopFrameNumber",TagFromName.IVUSPullbackStopFrameNumber);
		tagByName.put("LesionNumber",TagFromName.LesionNumber);
		tagByName.put("AcquisitionComments",TagFromName.AcquisitionComments);
		tagByName.put("OutputPower",TagFromName.OutputPower);
		tagByName.put("TransducerData",TagFromName.TransducerData);
		tagByName.put("FocusDepth",TagFromName.FocusDepth);
		tagByName.put("ProcessingFunction",TagFromName.ProcessingFunction);
		tagByName.put("PostprocessingFunction",TagFromName.PostprocessingFunction);
		tagByName.put("MechanicalIndex",TagFromName.MechanicalIndex);
		tagByName.put("BoneThermalIndex",TagFromName.BoneThermalIndex);
		tagByName.put("CranialThermalIndex",TagFromName.CranialThermalIndex);
		tagByName.put("SoftTissueThermalIndex",TagFromName.SoftTissueThermalIndex);
		tagByName.put("SoftTissueFocusThermalIndex",TagFromName.SoftTissueFocusThermalIndex);
		tagByName.put("SoftTissueSurfaceThermalIndex",TagFromName.SoftTissueSurfaceThermalIndex);
		tagByName.put("DynamicRange",TagFromName.DynamicRange);
		tagByName.put("TotalGain",TagFromName.TotalGain);
		tagByName.put("DepthOfScanField",TagFromName.DepthOfScanField);
		tagByName.put("PatientPosition",TagFromName.PatientPosition);
		tagByName.put("ViewPosition",TagFromName.ViewPosition);
		tagByName.put("ProjectionEponymousNameCodeSequence",TagFromName.ProjectionEponymousNameCodeSequence);
		tagByName.put("ImageTransformationMatrix",TagFromName.ImageTransformationMatrix);
		tagByName.put("ImageTranslationVector",TagFromName.ImageTranslationVector);
		tagByName.put("Sensitivity",TagFromName.Sensitivity);
		tagByName.put("SequenceOfUltrasoundRegions",TagFromName.SequenceOfUltrasoundRegions);
		tagByName.put("RegionSpatialFormat",TagFromName.RegionSpatialFormat);
		tagByName.put("RegionDataType",TagFromName.RegionDataType);
		tagByName.put("RegionFlags",TagFromName.RegionFlags);
		tagByName.put("RegionLocationMinX0",TagFromName.RegionLocationMinX0);
		tagByName.put("RegionLocationMinY0",TagFromName.RegionLocationMinY0);
		tagByName.put("RegionLocationMaxX1",TagFromName.RegionLocationMaxX1);
		tagByName.put("RegionLocationMaxY1",TagFromName.RegionLocationMaxY1);
		tagByName.put("ReferencePixelX0",TagFromName.ReferencePixelX0);
		tagByName.put("ReferencePixelY0",TagFromName.ReferencePixelY0);
		tagByName.put("PhysicalUnitsXDirection",TagFromName.PhysicalUnitsXDirection);
		tagByName.put("PhysicalUnitsYDirection",TagFromName.PhysicalUnitsYDirection);
		tagByName.put("ReferencePixelPhysicalValueX",TagFromName.ReferencePixelPhysicalValueX);
		tagByName.put("ReferencePixelPhysicalValueY",TagFromName.ReferencePixelPhysicalValueY);
		tagByName.put("PhysicalDeltaX",TagFromName.PhysicalDeltaX);
		tagByName.put("PhysicalDeltaY",TagFromName.PhysicalDeltaY);
		tagByName.put("TransducerFrequency",TagFromName.TransducerFrequency);
		tagByName.put("TransducerType",TagFromName.TransducerType);
		tagByName.put("PulseRepetitionFrequency",TagFromName.PulseRepetitionFrequency);
		tagByName.put("DopplerCorrectionAngle",TagFromName.DopplerCorrectionAngle);
		tagByName.put("SteeringAngle",TagFromName.SteeringAngle);
		tagByName.put("DopplerSampleVolumeXPositionRetired",TagFromName.DopplerSampleVolumeXPositionRetired);
		tagByName.put("DopplerSampleVolumeXPosition",TagFromName.DopplerSampleVolumeXPosition);
		tagByName.put("DopplerSampleVolumeYPositionRetired",TagFromName.DopplerSampleVolumeYPositionRetired);
		tagByName.put("DopplerSampleVolumeYPosition",TagFromName.DopplerSampleVolumeYPosition);
		tagByName.put("TMLinePositionX0Retired",TagFromName.TMLinePositionX0Retired);
		tagByName.put("TMLinePositionX0",TagFromName.TMLinePositionX0);
		tagByName.put("TMLinePositionY0Retired",TagFromName.TMLinePositionY0Retired);
		tagByName.put("TMLinePositionY0",TagFromName.TMLinePositionY0);
		tagByName.put("TMLinePositionX1Retired",TagFromName.TMLinePositionX1Retired);
		tagByName.put("TMLinePositionX1",TagFromName.TMLinePositionX1);
		tagByName.put("TMLinePositionY1Retired",TagFromName.TMLinePositionY1Retired);
		tagByName.put("TMLinePositionY1",TagFromName.TMLinePositionY1);
		tagByName.put("PixelComponentOrganization",TagFromName.PixelComponentOrganization);
		tagByName.put("PixelComponentMask",TagFromName.PixelComponentMask);
		tagByName.put("PixelComponentRangeStart",TagFromName.PixelComponentRangeStart);
		tagByName.put("PixelComponentRangeStop",TagFromName.PixelComponentRangeStop);
		tagByName.put("PixelComponentPhysicalUnits",TagFromName.PixelComponentPhysicalUnits);
		tagByName.put("PixelComponentDataType",TagFromName.PixelComponentDataType);
		tagByName.put("NumberOfTableBreakPoints",TagFromName.NumberOfTableBreakPoints);
		tagByName.put("TableOfXBreakPoints",TagFromName.TableOfXBreakPoints);
		tagByName.put("TableOfYBreakPoints",TagFromName.TableOfYBreakPoints);
		tagByName.put("NumberOfTableEntries",TagFromName.NumberOfTableEntries);
		tagByName.put("TableOfPixelValues",TagFromName.TableOfPixelValues);
		tagByName.put("TableOfParameterValues",TagFromName.TableOfParameterValues);
		tagByName.put("RWaveTimeVector",TagFromName.RWaveTimeVector);
		tagByName.put("DetectorConditionsNominalFlag",TagFromName.DetectorConditionsNominalFlag);
		tagByName.put("DetectorTemperature",TagFromName.DetectorTemperature);
		tagByName.put("DetectorType",TagFromName.DetectorType);
		tagByName.put("DetectorConfiguration",TagFromName.DetectorConfiguration);
		tagByName.put("DetectorDescription",TagFromName.DetectorDescription);
		tagByName.put("DetectorMode",TagFromName.DetectorMode);
		tagByName.put("DetectorID",TagFromName.DetectorID);
		tagByName.put("DateOfLastDetectorCalibration",TagFromName.DateOfLastDetectorCalibration);
		tagByName.put("TimeOfLastDetectorCalibration",TagFromName.TimeOfLastDetectorCalibration);
		tagByName.put("ExposuresOnDetectorSinceLastCalibration",TagFromName.ExposuresOnDetectorSinceLastCalibration);
		tagByName.put("ExposuresOnDetectorSinceManufactured",TagFromName.ExposuresOnDetectorSinceManufactured);
		tagByName.put("DetectorTimeSinceLastExposure",TagFromName.DetectorTimeSinceLastExposure);
		tagByName.put("DetectorActiveTime",TagFromName.DetectorActiveTime);
		tagByName.put("DetectorActivationOffsetFromExposure",TagFromName.DetectorActivationOffsetFromExposure);
		tagByName.put("DetectorBinning",TagFromName.DetectorBinning);
		tagByName.put("DetectorElementPhysicalSize",TagFromName.DetectorElementPhysicalSize);
		tagByName.put("DetectorElementSpacing",TagFromName.DetectorElementSpacing);
		tagByName.put("DetectorActiveShape",TagFromName.DetectorActiveShape);
		tagByName.put("DetectorActiveDimensions",TagFromName.DetectorActiveDimensions);
		tagByName.put("DetectorActiveOrigin",TagFromName.DetectorActiveOrigin);
		tagByName.put("DetectorManufacturerName",TagFromName.DetectorManufacturerName);
		tagByName.put("DetectorManufacturerModelName",TagFromName.DetectorManufacturerModelName);
		tagByName.put("FieldOfViewOrigin",TagFromName.FieldOfViewOrigin);
		tagByName.put("FieldOfViewRotation",TagFromName.FieldOfViewRotation);
		tagByName.put("FieldOfViewHorizontalFlip",TagFromName.FieldOfViewHorizontalFlip);
		tagByName.put("PixelDataAreaOriginRelativeToFOV",TagFromName.PixelDataAreaOriginRelativeToFOV);
		tagByName.put("PixelDataAreaRotationAngleRelativeToFOV",TagFromName.PixelDataAreaRotationAngleRelativeToFOV);
		tagByName.put("GridAbsorbingMaterial",TagFromName.GridAbsorbingMaterial);
		tagByName.put("GridSpacingMaterial",TagFromName.GridSpacingMaterial);
		tagByName.put("GridThickness",TagFromName.GridThickness);
		tagByName.put("GridPitch",TagFromName.GridPitch);
		tagByName.put("GridAspectRatio",TagFromName.GridAspectRatio);
		tagByName.put("GridPeriod",TagFromName.GridPeriod);
		tagByName.put("GridFocalDistance",TagFromName.GridFocalDistance);
		tagByName.put("FilterMaterial",TagFromName.FilterMaterial);
		tagByName.put("FilterThicknessMinimum",TagFromName.FilterThicknessMinimum);
		tagByName.put("FilterThicknessMaximum",TagFromName.FilterThicknessMaximum);
		tagByName.put("FilterBeamPathLengthMinimum",TagFromName.FilterBeamPathLengthMinimum);
		tagByName.put("FilterBeamPathLengthMaximum",TagFromName.FilterBeamPathLengthMaximum);
		tagByName.put("ExposureControlMode",TagFromName.ExposureControlMode);
		tagByName.put("ExposureControlModeDescription",TagFromName.ExposureControlModeDescription);
		tagByName.put("ExposureStatus",TagFromName.ExposureStatus);
		tagByName.put("PhototimerSetting",TagFromName.PhototimerSetting);
		tagByName.put("ExposureTimeInuS",TagFromName.ExposureTimeInuS);
		tagByName.put("XRayTubeCurrentInuA",TagFromName.XRayTubeCurrentInuA);
		tagByName.put("ContentQualification",TagFromName.ContentQualification);
		tagByName.put("PulseSequenceName",TagFromName.PulseSequenceName);
		tagByName.put("MRImagingModifierSequence",TagFromName.MRImagingModifierSequence);
		tagByName.put("EchoPulseSequence",TagFromName.EchoPulseSequence);
		tagByName.put("InversionRecovery",TagFromName.InversionRecovery);
		tagByName.put("FlowCompensation",TagFromName.FlowCompensation);
		tagByName.put("MultipleSpinEcho",TagFromName.MultipleSpinEcho);
		tagByName.put("MultiPlanarExcitation",TagFromName.MultiPlanarExcitation);
		tagByName.put("PhaseContrast",TagFromName.PhaseContrast);
		tagByName.put("TimeOfFlightContrast",TagFromName.TimeOfFlightContrast);
		tagByName.put("Spoiling",TagFromName.Spoiling);
		tagByName.put("SteadyStatePulseSequence",TagFromName.SteadyStatePulseSequence);
		tagByName.put("EchoPlanarPulseSequence",TagFromName.EchoPlanarPulseSequence);
		tagByName.put("TagAngleFirstAxis",TagFromName.TagAngleFirstAxis);
		tagByName.put("MagnetizationTransfer",TagFromName.MagnetizationTransfer);
		tagByName.put("T2Preparation",TagFromName.T2Preparation);
		tagByName.put("BloodSignalNulling",TagFromName.BloodSignalNulling);
		tagByName.put("SaturationRecovery",TagFromName.SaturationRecovery);
		tagByName.put("SpectrallySelectedSuppression",TagFromName.SpectrallySelectedSuppression);
		tagByName.put("SpectrallySelectedExcitation",TagFromName.SpectrallySelectedExcitation);
		tagByName.put("SpatialPresaturation",TagFromName.SpatialPresaturation);
		tagByName.put("Tagging",TagFromName.Tagging);
		tagByName.put("OversamplingPhase",TagFromName.OversamplingPhase);
		tagByName.put("TagSpacingFirstDimension",TagFromName.TagSpacingFirstDimension);
		tagByName.put("GeometryOfKSpaceTraversal",TagFromName.GeometryOfKSpaceTraversal);
		tagByName.put("SegmentedKSpaceTraversal",TagFromName.SegmentedKSpaceTraversal);
		tagByName.put("RectilinearPhaseEncodeReordering",TagFromName.RectilinearPhaseEncodeReordering);
		tagByName.put("TagThickness",TagFromName.TagThickness);
		tagByName.put("PartialFourierDirection",TagFromName.PartialFourierDirection);
		tagByName.put("CardiacSynchronizationTechnique",TagFromName.CardiacSynchronizationTechnique);
		tagByName.put("ReceiveCoilManufacturerName",TagFromName.ReceiveCoilManufacturerName);
		tagByName.put("MRReceiveCoilSequence",TagFromName.MRReceiveCoilSequence);
		tagByName.put("ReceiveCoilType",TagFromName.ReceiveCoilType);
		tagByName.put("QuadratureReceiveCoil",TagFromName.QuadratureReceiveCoil);
		tagByName.put("MultiCoilDefinitionSequence",TagFromName.MultiCoilDefinitionSequence);
		tagByName.put("MultiCoilConfiguration",TagFromName.MultiCoilConfiguration);
		tagByName.put("MultiCoilElementName",TagFromName.MultiCoilElementName);
		tagByName.put("MultiCoilElementUsed",TagFromName.MultiCoilElementUsed);
		tagByName.put("MRTransmitCoilSequence",TagFromName.MRTransmitCoilSequence);
		tagByName.put("TransmitCoilManufacturerName",TagFromName.TransmitCoilManufacturerName);
		tagByName.put("TransmitCoilType",TagFromName.TransmitCoilType);
		tagByName.put("SpectralWidth",TagFromName.SpectralWidth);
		tagByName.put("ChemicalShiftReference",TagFromName.ChemicalShiftReference);
		tagByName.put("VolumeLocalizationTechnique",TagFromName.VolumeLocalizationTechnique);
		tagByName.put("MRAcquisitionFrequencyEncodingSteps",TagFromName.MRAcquisitionFrequencyEncodingSteps);
		tagByName.put("Decoupling",TagFromName.Decoupling);
		tagByName.put("DecoupledNucleus",TagFromName.DecoupledNucleus);
		tagByName.put("DecouplingFrequency",TagFromName.DecouplingFrequency);
		tagByName.put("DecouplingMethod",TagFromName.DecouplingMethod);
		tagByName.put("DecouplingChemicalShiftReference",TagFromName.DecouplingChemicalShiftReference);
		tagByName.put("KSpaceFiltering",TagFromName.KSpaceFiltering);
		tagByName.put("TimeDomainFiltering",TagFromName.TimeDomainFiltering);
		tagByName.put("NumberOfZeroFills",TagFromName.NumberOfZeroFills);
		tagByName.put("BaselineCorrection",TagFromName.BaselineCorrection);
		tagByName.put("ParallelReductionFactorInPlane",TagFromName.ParallelReductionFactorInPlane);
		tagByName.put("CardiacRRIntervalSpecified",TagFromName.CardiacRRIntervalSpecified);
		tagByName.put("AcquisitionDuration",TagFromName.AcquisitionDuration);
		tagByName.put("FrameAcquisitionDateTime",TagFromName.FrameAcquisitionDateTime);
		tagByName.put("DiffusionDirectionality",TagFromName.DiffusionDirectionality);
		tagByName.put("DiffusionGradientDirectionSequence",TagFromName.DiffusionGradientDirectionSequence);
		tagByName.put("ParallelAcquisition",TagFromName.ParallelAcquisition);
		tagByName.put("ParallelAcquisitionTechnique",TagFromName.ParallelAcquisitionTechnique);
		tagByName.put("InversionTimes",TagFromName.InversionTimes);
		tagByName.put("MetaboliteMapDescription",TagFromName.MetaboliteMapDescription);
		tagByName.put("PartialFourier",TagFromName.PartialFourier);
		tagByName.put("EffectiveEchoTime",TagFromName.EffectiveEchoTime);
		tagByName.put("MetaboliteMapCodeSequence",TagFromName.MetaboliteMapCodeSequence);
		tagByName.put("ChemicalShiftSequence",TagFromName.ChemicalShiftSequence);
		tagByName.put("CardiacSignalSource",TagFromName.CardiacSignalSource);
		tagByName.put("DiffusionBValue",TagFromName.DiffusionBValue);
		tagByName.put("DiffusionGradientOrientation",TagFromName.DiffusionGradientOrientation);
		tagByName.put("VelocityEncodingDirection",TagFromName.VelocityEncodingDirection);
		tagByName.put("VelocityEncodingMinimumValue",TagFromName.VelocityEncodingMinimumValue);
		tagByName.put("VelocityEncodingAcquisitionSequence",TagFromName.VelocityEncodingAcquisitionSequence);
		tagByName.put("NumberOfKSpaceTrajectories",TagFromName.NumberOfKSpaceTrajectories);
		tagByName.put("CoverageOfKSpace",TagFromName.CoverageOfKSpace);
		tagByName.put("SpectroscopyAcquisitionPhaseRows",TagFromName.SpectroscopyAcquisitionPhaseRows);
		tagByName.put("ParallelReductionFactorInPlaneRetired",TagFromName.ParallelReductionFactorInPlaneRetired);
		tagByName.put("TransmitterFrequency",TagFromName.TransmitterFrequency);
		tagByName.put("ResonantNucleus",TagFromName.ResonantNucleus);
		tagByName.put("FrequencyCorrection",TagFromName.FrequencyCorrection);
		tagByName.put("MRSpectroscopyFOVGeometrySequence",TagFromName.MRSpectroscopyFOVGeometrySequence);
		tagByName.put("SlabThickness",TagFromName.SlabThickness);
		tagByName.put("SlabOrientation",TagFromName.SlabOrientation);
		tagByName.put("MidSlabPosition",TagFromName.MidSlabPosition);
		tagByName.put("MRSpatialSaturationSequence",TagFromName.MRSpatialSaturationSequence);
		tagByName.put("MRTimingAndRelatedParametersSequence",TagFromName.MRTimingAndRelatedParametersSequence);
		tagByName.put("MREchoSequence",TagFromName.MREchoSequence);
		tagByName.put("MRModifierSequence",TagFromName.MRModifierSequence);
		tagByName.put("MRDiffusionSequence",TagFromName.MRDiffusionSequence);
		tagByName.put("CardiacSynchronizationSequence",TagFromName.CardiacSynchronizationSequence);
		tagByName.put("MRAveragesSequence",TagFromName.MRAveragesSequence);
		tagByName.put("MRFOVGeometrySequence",TagFromName.MRFOVGeometrySequence);
		tagByName.put("VolumeLocalizationSequence",TagFromName.VolumeLocalizationSequence);
		tagByName.put("SpectroscopyAcquisitionDataColumns",TagFromName.SpectroscopyAcquisitionDataColumns);
		tagByName.put("DiffusionAnisotropyType",TagFromName.DiffusionAnisotropyType);
		tagByName.put("FrameReferenceDateTime",TagFromName.FrameReferenceDateTime);
		tagByName.put("MRMetaboliteMapSequence",TagFromName.MRMetaboliteMapSequence);
		tagByName.put("ParallelReductionFactorOutOfPlane",TagFromName.ParallelReductionFactorOutOfPlane);
		tagByName.put("SpectroscopyAcquisitionOutOfPlanePhaseSteps",TagFromName.SpectroscopyAcquisitionOutOfPlanePhaseSteps);
		tagByName.put("BulkMotionStatus",TagFromName.BulkMotionStatus);
		tagByName.put("ParallelReductionFactorSecondInPlane",TagFromName.ParallelReductionFactorSecondInPlane);
		tagByName.put("CardiacBeatRejectionTechnique",TagFromName.CardiacBeatRejectionTechnique);
		tagByName.put("RespiratoryMotionCompensationTechnique",TagFromName.RespiratoryMotionCompensationTechnique);
		tagByName.put("RespiratorySignalSource",TagFromName.RespiratorySignalSource);
		tagByName.put("BulkMotionCompensationTechnique",TagFromName.BulkMotionCompensationTechnique);
		tagByName.put("BulkMotionSignalSource",TagFromName.BulkMotionSignalSource);
		tagByName.put("ApplicableSafetyStandardAgency",TagFromName.ApplicableSafetyStandardAgency);
		tagByName.put("ApplicableSafetyStandardDescription",TagFromName.ApplicableSafetyStandardDescription);
		tagByName.put("OperatingModeSequence",TagFromName.OperatingModeSequence);
		tagByName.put("OperatingModeType",TagFromName.OperatingModeType);
		tagByName.put("OperatingMode",TagFromName.OperatingMode);
		tagByName.put("SpecificAbsorptionRateDefinition",TagFromName.SpecificAbsorptionRateDefinition);
		tagByName.put("GradientOutputType",TagFromName.GradientOutputType);
		tagByName.put("SpecificAbsorptionRateValue",TagFromName.SpecificAbsorptionRateValue);
		tagByName.put("GradientOutput",TagFromName.GradientOutput);
		tagByName.put("FlowCompensationDirection",TagFromName.FlowCompensationDirection);
		tagByName.put("TaggingDelay",TagFromName.TaggingDelay);
		tagByName.put("RespiratoryMotionCompensationTechniqueDescription",TagFromName.RespiratoryMotionCompensationTechniqueDescription);
		tagByName.put("RespiratorySignalSourceID",TagFromName.RespiratorySignalSourceID);
		tagByName.put("ChemicalShiftMinimumIntegrationLimitInHz",TagFromName.ChemicalShiftMinimumIntegrationLimitInHz);
		tagByName.put("ChemicalShiftMaximumIntegrationLimitInHz",TagFromName.ChemicalShiftMaximumIntegrationLimitInHz);
		tagByName.put("MRVelocityEncodingSequence",TagFromName.MRVelocityEncodingSequence);
		tagByName.put("FirstOrderPhaseCorrection",TagFromName.FirstOrderPhaseCorrection);
		tagByName.put("WaterReferencedPhaseCorrection",TagFromName.WaterReferencedPhaseCorrection);
		tagByName.put("MRSpectroscopyAcquisitionType",TagFromName.MRSpectroscopyAcquisitionType);
		tagByName.put("RespiratoryCyclePosition",TagFromName.RespiratoryCyclePosition);
		tagByName.put("VelocityEncodingMaximumValue",TagFromName.VelocityEncodingMaximumValue);
		tagByName.put("TagSpacingSecondDimension",TagFromName.TagSpacingSecondDimension);
		tagByName.put("TagAngleSecondAxis",TagFromName.TagAngleSecondAxis);
		tagByName.put("FrameAcquisitionDuration",TagFromName.FrameAcquisitionDuration);
		tagByName.put("MRImageFrameTypeSequence",TagFromName.MRImageFrameTypeSequence);
		tagByName.put("MRSpectroscopyFrameTypeSequence",TagFromName.MRSpectroscopyFrameTypeSequence);
		tagByName.put("MRAcquisitionPhaseEncodingStepsInPlane",TagFromName.MRAcquisitionPhaseEncodingStepsInPlane);
		tagByName.put("MRAcquisitionPhaseEncodingStepsOutOfPlane",TagFromName.MRAcquisitionPhaseEncodingStepsOutOfPlane);
		tagByName.put("SpectroscopyAcquisitionPhaseColumns",TagFromName.SpectroscopyAcquisitionPhaseColumns);
		tagByName.put("CardiacCyclePosition",TagFromName.CardiacCyclePosition);
		tagByName.put("SpecificAbsorptionRateSequence",TagFromName.SpecificAbsorptionRateSequence);
		tagByName.put("RFEchoTrainLength",TagFromName.RFEchoTrainLength);
		tagByName.put("GradientEchoTrainLength",TagFromName.GradientEchoTrainLength);
		tagByName.put("ArterialSpinLabelingContrast",TagFromName.ArterialSpinLabelingContrast);
		tagByName.put("MRArterialSpinLabelingSequence",TagFromName.MRArterialSpinLabelingSequence);
		tagByName.put("ASLTechniqueDescription",TagFromName.ASLTechniqueDescription);
		tagByName.put("ASLSlabNumber",TagFromName.ASLSlabNumber);
		tagByName.put("ASLSlabThickness",TagFromName.ASLSlabThickness);
		tagByName.put("ASLSlabOrientation",TagFromName.ASLSlabOrientation);
		tagByName.put("ASLMidSlabPosition",TagFromName.ASLMidSlabPosition);
		tagByName.put("ASLContext",TagFromName.ASLContext);
		tagByName.put("ASLPulseTrainDuration",TagFromName.ASLPulseTrainDuration);
		tagByName.put("ASLCrusherFlag",TagFromName.ASLCrusherFlag);
		tagByName.put("ASLCrusherFlowLimit",TagFromName.ASLCrusherFlowLimit);
		tagByName.put("ASLCrusherDescription",TagFromName.ASLCrusherDescription);
		tagByName.put("ASLBolusCutoffFlag",TagFromName.ASLBolusCutoffFlag);
		tagByName.put("ASLBolusCutoffTimingSequence",TagFromName.ASLBolusCutoffTimingSequence);
		tagByName.put("ASLBolusCutoffTechnique",TagFromName.ASLBolusCutoffTechnique);
		tagByName.put("ASLBolusCutoffDelayTime",TagFromName.ASLBolusCutoffDelayTime);
		tagByName.put("ASLSlabSequence",TagFromName.ASLSlabSequence);
		tagByName.put("ChemicalShiftMinimumIntegrationLimitInppm",TagFromName.ChemicalShiftMinimumIntegrationLimitInppm);
		tagByName.put("ChemicalShiftMaximumIntegrationLimitInppm",TagFromName.ChemicalShiftMaximumIntegrationLimitInppm);
		tagByName.put("WaterReferenceAcquisition",TagFromName.WaterReferenceAcquisition);
		tagByName.put("EchoPeakPosition",TagFromName.EchoPeakPosition);
		tagByName.put("CTAcquisitionTypeSequence",TagFromName.CTAcquisitionTypeSequence);
		tagByName.put("AcquisitionType",TagFromName.AcquisitionType);
		tagByName.put("TubeAngle",TagFromName.TubeAngle);
		tagByName.put("CTAcquisitionDetailsSequence",TagFromName.CTAcquisitionDetailsSequence);
		tagByName.put("RevolutionTime",TagFromName.RevolutionTime);
		tagByName.put("SingleCollimationWidth",TagFromName.SingleCollimationWidth);
		tagByName.put("TotalCollimationWidth",TagFromName.TotalCollimationWidth);
		tagByName.put("CTTableDynamicsSequence",TagFromName.CTTableDynamicsSequence);
		tagByName.put("TableSpeed",TagFromName.TableSpeed);
		tagByName.put("TableFeedPerRotation",TagFromName.TableFeedPerRotation);
		tagByName.put("SpiralPitchFactor",TagFromName.SpiralPitchFactor);
		tagByName.put("CTGeometrySequence",TagFromName.CTGeometrySequence);
		tagByName.put("DataCollectionCenterPatient",TagFromName.DataCollectionCenterPatient);
		tagByName.put("CTReconstructionSequence",TagFromName.CTReconstructionSequence);
		tagByName.put("ReconstructionAlgorithm",TagFromName.ReconstructionAlgorithm);
		tagByName.put("ConvolutionKernelGroup",TagFromName.ConvolutionKernelGroup);
		tagByName.put("ReconstructionFieldOfView",TagFromName.ReconstructionFieldOfView);
		tagByName.put("ReconstructionTargetCenterPatient",TagFromName.ReconstructionTargetCenterPatient);
		tagByName.put("ReconstructionAngle",TagFromName.ReconstructionAngle);
		tagByName.put("ImageFilter",TagFromName.ImageFilter);
		tagByName.put("CTExposureSequence",TagFromName.CTExposureSequence);
		tagByName.put("ReconstructionPixelSpacing",TagFromName.ReconstructionPixelSpacing);
		tagByName.put("ExposureModulationType",TagFromName.ExposureModulationType);
		tagByName.put("EstimatedDoseSaving",TagFromName.EstimatedDoseSaving);
		tagByName.put("CTXRayDetailsSequence",TagFromName.CTXRayDetailsSequence);
		tagByName.put("CTPositionSequence",TagFromName.CTPositionSequence);
		tagByName.put("TablePosition",TagFromName.TablePosition);
		tagByName.put("ExposureTimeInms",TagFromName.ExposureTimeInms);
		tagByName.put("CTImageFrameTypeSequence",TagFromName.CTImageFrameTypeSequence);
		tagByName.put("XRayTubeCurrentInmA",TagFromName.XRayTubeCurrentInmA);
		tagByName.put("ExposureInmAs",TagFromName.ExposureInmAs);
		tagByName.put("ConstantVolumeFlag",TagFromName.ConstantVolumeFlag);
		tagByName.put("FluoroscopyFlag",TagFromName.FluoroscopyFlag);
		tagByName.put("DistanceSourceToDataCollectionCenter",TagFromName.DistanceSourceToDataCollectionCenter);
		tagByName.put("ContrastBolusAgentNumber",TagFromName.ContrastBolusAgentNumber);
		tagByName.put("ContrastBolusIngredientCodeSequence",TagFromName.ContrastBolusIngredientCodeSequence);
		tagByName.put("ContrastAdministrationProfileSequence",TagFromName.ContrastAdministrationProfileSequence);
		tagByName.put("ContrastBolusUsageSequence",TagFromName.ContrastBolusUsageSequence);
		tagByName.put("ContrastBolusAgentAdministered",TagFromName.ContrastBolusAgentAdministered);
		tagByName.put("ContrastBolusAgentDetected",TagFromName.ContrastBolusAgentDetected);
		tagByName.put("ContrastBolusAgentPhase",TagFromName.ContrastBolusAgentPhase);
		tagByName.put("CTDIvol",TagFromName.CTDIvol);
		tagByName.put("CTDIPhantomTypeCodeSequence",TagFromName.CTDIPhantomTypeCodeSequence);
		tagByName.put("CalciumScoringMassFactorPatient",TagFromName.CalciumScoringMassFactorPatient);
		tagByName.put("CalciumScoringMassFactorDevice",TagFromName.CalciumScoringMassFactorDevice);
		tagByName.put("EnergyWeightingFactor",TagFromName.EnergyWeightingFactor);
		tagByName.put("CTAdditionalXRaySourceSequence",TagFromName.CTAdditionalXRaySourceSequence);
		tagByName.put("ProjectionPixelCalibrationSequence",TagFromName.ProjectionPixelCalibrationSequence);
		tagByName.put("DistanceSourceToIsocenter",TagFromName.DistanceSourceToIsocenter);
		tagByName.put("DistanceObjectToTableTop",TagFromName.DistanceObjectToTableTop);
		tagByName.put("ObjectPixelSpacingInCenterOfBeam",TagFromName.ObjectPixelSpacingInCenterOfBeam);
		tagByName.put("PositionerPositionSequence",TagFromName.PositionerPositionSequence);
		tagByName.put("TablePositionSequence",TagFromName.TablePositionSequence);
		tagByName.put("CollimatorShapeSequence",TagFromName.CollimatorShapeSequence);
		tagByName.put("PlanesInAcquisition",TagFromName.PlanesInAcquisition);
		tagByName.put("XAXRFFrameCharacteristicsSequence",TagFromName.XAXRFFrameCharacteristicsSequence);
		tagByName.put("FrameAcquisitionSequence",TagFromName.FrameAcquisitionSequence);
		tagByName.put("XRayReceptorType",TagFromName.XRayReceptorType);
		tagByName.put("AcquisitionProtocolName",TagFromName.AcquisitionProtocolName);
		tagByName.put("AcquisitionProtocolDescription",TagFromName.AcquisitionProtocolDescription);
		tagByName.put("ContrastBolusIngredientOpaque",TagFromName.ContrastBolusIngredientOpaque);
		tagByName.put("DistanceReceptorPlaneToDetectorHousing",TagFromName.DistanceReceptorPlaneToDetectorHousing);
		tagByName.put("IntensifierActiveShape",TagFromName.IntensifierActiveShape);
		tagByName.put("IntensifierActiveDimensions",TagFromName.IntensifierActiveDimensions);
		tagByName.put("PhysicalDetectorSize",TagFromName.PhysicalDetectorSize);
		tagByName.put("PositionOfIsocenterProjection",TagFromName.PositionOfIsocenterProjection);
		tagByName.put("FieldOfViewSequence",TagFromName.FieldOfViewSequence);
		tagByName.put("FieldOfViewDescription",TagFromName.FieldOfViewDescription);
		tagByName.put("ExposureControlSensingRegionsSequence",TagFromName.ExposureControlSensingRegionsSequence);
		tagByName.put("ExposureControlSensingRegionShape",TagFromName.ExposureControlSensingRegionShape);
		tagByName.put("ExposureControlSensingRegionLeftVerticalEdge",TagFromName.ExposureControlSensingRegionLeftVerticalEdge);
		tagByName.put("ExposureControlSensingRegionRightVerticalEdge",TagFromName.ExposureControlSensingRegionRightVerticalEdge);
		tagByName.put("ExposureControlSensingRegionUpperHorizontalEdge",TagFromName.ExposureControlSensingRegionUpperHorizontalEdge);
		tagByName.put("ExposureControlSensingRegionLowerHorizontalEdge",TagFromName.ExposureControlSensingRegionLowerHorizontalEdge);
		tagByName.put("CenterOfCircularExposureControlSensingRegion",TagFromName.CenterOfCircularExposureControlSensingRegion);
		tagByName.put("RadiusOfCircularExposureControlSensingRegion",TagFromName.RadiusOfCircularExposureControlSensingRegion);
		tagByName.put("VerticesOfThePolygonalExposureControlSensingRegion",TagFromName.VerticesOfThePolygonalExposureControlSensingRegion);
		tagByName.put("ColumnAngulationPatient",TagFromName.ColumnAngulationPatient);
		tagByName.put("BeamAngle",TagFromName.BeamAngle);
		tagByName.put("FrameDetectorParametersSequence",TagFromName.FrameDetectorParametersSequence);
		tagByName.put("CalculatedAnatomyThickness",TagFromName.CalculatedAnatomyThickness);
		tagByName.put("CalibrationSequence",TagFromName.CalibrationSequence);
		tagByName.put("ObjectThicknessSequence",TagFromName.ObjectThicknessSequence);
		tagByName.put("PlaneIdentification",TagFromName.PlaneIdentification);
		tagByName.put("FieldOfViewDimensionsInFloat",TagFromName.FieldOfViewDimensionsInFloat);
		tagByName.put("IsocenterReferenceSystemSequence",TagFromName.IsocenterReferenceSystemSequence);
		tagByName.put("PositionerIsocenterPrimaryAngle",TagFromName.PositionerIsocenterPrimaryAngle);
		tagByName.put("PositionerIsocenterSecondaryAngle",TagFromName.PositionerIsocenterSecondaryAngle);
		tagByName.put("PositionerIsocenterDetectorRotationAngle",TagFromName.PositionerIsocenterDetectorRotationAngle);
		tagByName.put("TableXPositionToIsocenter",TagFromName.TableXPositionToIsocenter);
		tagByName.put("TableYPositionToIsocenter",TagFromName.TableYPositionToIsocenter);
		tagByName.put("TableZPositionToIsocenter",TagFromName.TableZPositionToIsocenter);
		tagByName.put("TableHorizontalRotationAngle",TagFromName.TableHorizontalRotationAngle);
		tagByName.put("TableHeadTiltAngle",TagFromName.TableHeadTiltAngle);
		tagByName.put("TableCradleTiltAngle",TagFromName.TableCradleTiltAngle);
		tagByName.put("FrameDisplayShutterSequence",TagFromName.FrameDisplayShutterSequence);
		tagByName.put("AcquiredImageAreaDoseProduct",TagFromName.AcquiredImageAreaDoseProduct);
		tagByName.put("CArmPositionerTabletopRelationship",TagFromName.CArmPositionerTabletopRelationship);
		tagByName.put("XRayGeometrySequence",TagFromName.XRayGeometrySequence);
		tagByName.put("IrradiationEventIdentificationSequence",TagFromName.IrradiationEventIdentificationSequence);
		tagByName.put("XRay3DFrameTypeSequence",TagFromName.XRay3DFrameTypeSequence);
		tagByName.put("ContributingSourcesSequence",TagFromName.ContributingSourcesSequence);
		tagByName.put("XRay3DAcquisitionSequence",TagFromName.XRay3DAcquisitionSequence);
		tagByName.put("PrimaryPositionerScanArc",TagFromName.PrimaryPositionerScanArc);
		tagByName.put("SecondaryPositionerScanArc",TagFromName.SecondaryPositionerScanArc);
		tagByName.put("PrimaryPositionerScanStartAngle",TagFromName.PrimaryPositionerScanStartAngle);
		tagByName.put("SecondaryPositionerScanStartAngle",TagFromName.SecondaryPositionerScanStartAngle);
		tagByName.put("PrimaryPositionerIncrement",TagFromName.PrimaryPositionerIncrement);
		tagByName.put("SecondaryPositionerIncrement",TagFromName.SecondaryPositionerIncrement);
		tagByName.put("StartAcquisitionDateTime",TagFromName.StartAcquisitionDateTime);
		tagByName.put("EndAcquisitionDateTime",TagFromName.EndAcquisitionDateTime);
		tagByName.put("PrimaryPositionerIncrementSign",TagFromName.PrimaryPositionerIncrementSign);
		tagByName.put("SecondaryPositionerIncrementSign",TagFromName.SecondaryPositionerIncrementSign);
		tagByName.put("ApplicationName",TagFromName.ApplicationName);
		tagByName.put("ApplicationVersion",TagFromName.ApplicationVersion);
		tagByName.put("ApplicationManufacturer",TagFromName.ApplicationManufacturer);
		tagByName.put("AlgorithmType",TagFromName.AlgorithmType);
		tagByName.put("AlgorithmDescription",TagFromName.AlgorithmDescription);
		tagByName.put("XRay3DReconstructionSequence",TagFromName.XRay3DReconstructionSequence);
		tagByName.put("ReconstructionDescription",TagFromName.ReconstructionDescription);
		tagByName.put("PerProjectionAcquisitionSequence",TagFromName.PerProjectionAcquisitionSequence);
		tagByName.put("DetectorPositionSequence",TagFromName.DetectorPositionSequence);
		tagByName.put("XRayAcquisitionDoseSequence",TagFromName.XRayAcquisitionDoseSequence);
		tagByName.put("XRaySourceIsocenterPrimaryAngle",TagFromName.XRaySourceIsocenterPrimaryAngle);
		tagByName.put("XRaySourceIsocenterSecondaryAngle",TagFromName.XRaySourceIsocenterSecondaryAngle);
		tagByName.put("BreastSupportIsocenterPrimaryAngle",TagFromName.BreastSupportIsocenterPrimaryAngle);
		tagByName.put("BreastSupportIsocenterSecondaryAngle",TagFromName.BreastSupportIsocenterSecondaryAngle);
		tagByName.put("BreastSupportXPositionToIsocenter",TagFromName.BreastSupportXPositionToIsocenter);
		tagByName.put("BreastSupportYPositionToIsocenter",TagFromName.BreastSupportYPositionToIsocenter);
		tagByName.put("BreastSupportZPositionToIsocenter",TagFromName.BreastSupportZPositionToIsocenter);
		tagByName.put("DetectorIsocenterPrimaryAngle",TagFromName.DetectorIsocenterPrimaryAngle);
		tagByName.put("DetectorIsocenterSecondaryAngle",TagFromName.DetectorIsocenterSecondaryAngle);
		tagByName.put("DetectorXPositionToIsocenter",TagFromName.DetectorXPositionToIsocenter);
		tagByName.put("DetectorYPositionToIsocenter",TagFromName.DetectorYPositionToIsocenter);
		tagByName.put("DetectorZPositionToIsocenter",TagFromName.DetectorZPositionToIsocenter);
		tagByName.put("XRayGridSequence",TagFromName.XRayGridSequence);
		tagByName.put("XRayFilterSequence",TagFromName.XRayFilterSequence);
		tagByName.put("DetectorActiveAreaTLHCPosition",TagFromName.DetectorActiveAreaTLHCPosition);
		tagByName.put("DetectorActiveAreaOrientation",TagFromName.DetectorActiveAreaOrientation);
		tagByName.put("PositionerPrimaryAngleDirection",TagFromName.PositionerPrimaryAngleDirection);
		tagByName.put("DiffusionBMatrixSequence",TagFromName.DiffusionBMatrixSequence);
		tagByName.put("DiffusionBValueXX",TagFromName.DiffusionBValueXX);
		tagByName.put("DiffusionBValueXY",TagFromName.DiffusionBValueXY);
		tagByName.put("DiffusionBValueXZ",TagFromName.DiffusionBValueXZ);
		tagByName.put("DiffusionBValueYY",TagFromName.DiffusionBValueYY);
		tagByName.put("DiffusionBValueYZ",TagFromName.DiffusionBValueYZ);
		tagByName.put("DiffusionBValueZZ",TagFromName.DiffusionBValueZZ);
		tagByName.put("DecayCorrectionDateTime",TagFromName.DecayCorrectionDateTime);
		tagByName.put("StartDensityThreshold",TagFromName.StartDensityThreshold);
		tagByName.put("StartRelativeDensityDifferenceThreshold",TagFromName.StartRelativeDensityDifferenceThreshold);
		tagByName.put("StartCardiacTriggerCountThreshold",TagFromName.StartCardiacTriggerCountThreshold);
		tagByName.put("StartRespiratoryTriggerCountThreshold",TagFromName.StartRespiratoryTriggerCountThreshold);
		tagByName.put("TerminationCountsThreshold",TagFromName.TerminationCountsThreshold);
		tagByName.put("TerminationDensityThreshold",TagFromName.TerminationDensityThreshold);
		tagByName.put("TerminationRelativeDensityThreshold",TagFromName.TerminationRelativeDensityThreshold);
		tagByName.put("TerminationTimeThreshold",TagFromName.TerminationTimeThreshold);
		tagByName.put("TerminationCardiacTriggerCountThreshold",TagFromName.TerminationCardiacTriggerCountThreshold);
		tagByName.put("TerminationRespiratoryTriggerCountThreshold",TagFromName.TerminationRespiratoryTriggerCountThreshold);
		tagByName.put("DetectorGeometry",TagFromName.DetectorGeometry);
		tagByName.put("TransverseDetectorSeparation",TagFromName.TransverseDetectorSeparation);
		tagByName.put("AxialDetectorDimension",TagFromName.AxialDetectorDimension);
		tagByName.put("RadiopharmaceuticalAgentNumber",TagFromName.RadiopharmaceuticalAgentNumber);
		tagByName.put("PETFrameAcquisitionSequence",TagFromName.PETFrameAcquisitionSequence);
		tagByName.put("PETDetectorMotionDetailsSequence",TagFromName.PETDetectorMotionDetailsSequence);
		tagByName.put("PETTableDynamicsSequence",TagFromName.PETTableDynamicsSequence);
		tagByName.put("PETPositionSequence",TagFromName.PETPositionSequence);
		tagByName.put("PETFrameCorrectionFactorsSequence",TagFromName.PETFrameCorrectionFactorsSequence);
		tagByName.put("RadiopharmaceuticalUsageSequence",TagFromName.RadiopharmaceuticalUsageSequence);
		tagByName.put("AttenuationCorrectionSource",TagFromName.AttenuationCorrectionSource);
		tagByName.put("NumberOfIterations",TagFromName.NumberOfIterations);
		tagByName.put("NumberOfSubsets",TagFromName.NumberOfSubsets);
		tagByName.put("PETReconstructionSequence",TagFromName.PETReconstructionSequence);
		tagByName.put("PETFrameTypeSequence",TagFromName.PETFrameTypeSequence);
		tagByName.put("TimeOfFlightInformationUsed",TagFromName.TimeOfFlightInformationUsed);
		tagByName.put("ReconstructionType",TagFromName.ReconstructionType);
		tagByName.put("DecayCorrected",TagFromName.DecayCorrected);
		tagByName.put("AttenuationCorrected",TagFromName.AttenuationCorrected);
		tagByName.put("ScatterCorrected",TagFromName.ScatterCorrected);
		tagByName.put("DeadTimeCorrected",TagFromName.DeadTimeCorrected);
		tagByName.put("GantryMotionCorrected",TagFromName.GantryMotionCorrected);
		tagByName.put("PatientMotionCorrected",TagFromName.PatientMotionCorrected);
		tagByName.put("CountLossNormalizationCorrected",TagFromName.CountLossNormalizationCorrected);
		tagByName.put("RandomsCorrected",TagFromName.RandomsCorrected);
		tagByName.put("NonUniformRadialSamplingCorrected",TagFromName.NonUniformRadialSamplingCorrected);
		tagByName.put("SensitivityCalibrated",TagFromName.SensitivityCalibrated);
		tagByName.put("DetectorNormalizationCorrection",TagFromName.DetectorNormalizationCorrection);
		tagByName.put("IterativeReconstructionMethod",TagFromName.IterativeReconstructionMethod);
		tagByName.put("AttenuationCorrectionTemporalRelationship",TagFromName.AttenuationCorrectionTemporalRelationship);
		tagByName.put("PatientPhysiologicalStateSequence",TagFromName.PatientPhysiologicalStateSequence);
		tagByName.put("PatientPhysiologicalStateCodeSequence",TagFromName.PatientPhysiologicalStateCodeSequence);
		tagByName.put("DepthsOfFocus",TagFromName.DepthsOfFocus);
		tagByName.put("ExcludedIntervalsSequence",TagFromName.ExcludedIntervalsSequence);
		tagByName.put("ExclusionStartDateTime",TagFromName.ExclusionStartDateTime);
		tagByName.put("ExclusionDuration",TagFromName.ExclusionDuration);
		tagByName.put("USImageDescriptionSequence",TagFromName.USImageDescriptionSequence);
		tagByName.put("ImageDataTypeSequence",TagFromName.ImageDataTypeSequence);
		tagByName.put("DataType",TagFromName.DataType);
		tagByName.put("TransducerScanPatternCodeSequence",TagFromName.TransducerScanPatternCodeSequence);
		tagByName.put("AliasedDataType",TagFromName.AliasedDataType);
		tagByName.put("PositionMeasuringDeviceUsed",TagFromName.PositionMeasuringDeviceUsed);
		tagByName.put("TransducerGeometryCodeSequence",TagFromName.TransducerGeometryCodeSequence);
		tagByName.put("TransducerBeamSteeringCodeSequence",TagFromName.TransducerBeamSteeringCodeSequence);
		tagByName.put("TransducerApplicationCodeSequence",TagFromName.TransducerApplicationCodeSequence);
		tagByName.put("ZeroVelocityPixelValue",TagFromName.ZeroVelocityPixelValue);
		tagByName.put("ContributingEquipmentSequence",TagFromName.ContributingEquipmentSequence);
		tagByName.put("ContributionDateTime",TagFromName.ContributionDateTime);
		tagByName.put("ContributionDescription",TagFromName.ContributionDescription);
		tagByName.put("StudyInstanceUID",TagFromName.StudyInstanceUID);
		tagByName.put("SeriesInstanceUID",TagFromName.SeriesInstanceUID);
		tagByName.put("StudyID",TagFromName.StudyID);
		tagByName.put("SeriesNumber",TagFromName.SeriesNumber);
		tagByName.put("AcquisitionNumber",TagFromName.AcquisitionNumber);
		tagByName.put("InstanceNumber",TagFromName.InstanceNumber);
		tagByName.put("IsotopeNumber",TagFromName.IsotopeNumber);
		tagByName.put("PhaseNumber",TagFromName.PhaseNumber);
		tagByName.put("IntervalNumber",TagFromName.IntervalNumber);
		tagByName.put("TimeSlotNumber",TagFromName.TimeSlotNumber);
		tagByName.put("AngleNumber",TagFromName.AngleNumber);
		tagByName.put("ItemNumber",TagFromName.ItemNumber);
		tagByName.put("PatientOrientation",TagFromName.PatientOrientation);
		tagByName.put("OverlayNumber",TagFromName.OverlayNumber);
		tagByName.put("CurveNumber",TagFromName.CurveNumber);
		tagByName.put("LUTNumber",TagFromName.LUTNumber);
		tagByName.put("ImagePosition",TagFromName.ImagePosition);
		tagByName.put("ImagePositionPatient",TagFromName.ImagePositionPatient);
		tagByName.put("ImageOrientation",TagFromName.ImageOrientation);
		tagByName.put("ImageOrientationPatient",TagFromName.ImageOrientationPatient);
		tagByName.put("Location",TagFromName.Location);
		tagByName.put("FrameOfReferenceUID",TagFromName.FrameOfReferenceUID);
		tagByName.put("Laterality",TagFromName.Laterality);
		tagByName.put("ImageLaterality",TagFromName.ImageLaterality);
		tagByName.put("ImageGeometryType",TagFromName.ImageGeometryType);
		tagByName.put("MaskingImage",TagFromName.MaskingImage);
		tagByName.put("ReportNumber",TagFromName.ReportNumber);
		tagByName.put("TemporalPositionIdentifier",TagFromName.TemporalPositionIdentifier);
		tagByName.put("NumberOfTemporalPositions",TagFromName.NumberOfTemporalPositions);
		tagByName.put("TemporalResolution",TagFromName.TemporalResolution);
		tagByName.put("SynchronizationFrameOfReferenceUID",TagFromName.SynchronizationFrameOfReferenceUID);
		tagByName.put("SOPInstanceUIDOfConcatenationSource",TagFromName.SOPInstanceUIDOfConcatenationSource);
		tagByName.put("SeriesInStudy",TagFromName.SeriesInStudy);
		tagByName.put("AcquisitionsInSeries",TagFromName.AcquisitionsInSeries);
		tagByName.put("ImagesInAcquisition",TagFromName.ImagesInAcquisition);
		tagByName.put("ImagesInSeries",TagFromName.ImagesInSeries);
		tagByName.put("AcquisitionsInStudy",TagFromName.AcquisitionsInStudy);
		tagByName.put("ImagesInStudy",TagFromName.ImagesInStudy);
		tagByName.put("Reference",TagFromName.Reference);
		tagByName.put("PositionReferenceIndicator",TagFromName.PositionReferenceIndicator);
		tagByName.put("SliceLocation",TagFromName.SliceLocation);
		tagByName.put("OtherStudyNumbers",TagFromName.OtherStudyNumbers);
		tagByName.put("NumberOfPatientRelatedStudies",TagFromName.NumberOfPatientRelatedStudies);
		tagByName.put("NumberOfPatientRelatedSeries",TagFromName.NumberOfPatientRelatedSeries);
		tagByName.put("NumberOfPatientRelatedInstances",TagFromName.NumberOfPatientRelatedInstances);
		tagByName.put("NumberOfStudyRelatedSeries",TagFromName.NumberOfStudyRelatedSeries);
		tagByName.put("NumberOfStudyRelatedInstances",TagFromName.NumberOfStudyRelatedInstances);
		tagByName.put("NumberOfSeriesRelatedInstances",TagFromName.NumberOfSeriesRelatedInstances);
		tagByName.put("SourceImageID",TagFromName.SourceImageID);
		tagByName.put("ModifyingDeviceID",TagFromName.ModifyingDeviceID);
		tagByName.put("ModifiedImageID",TagFromName.ModifiedImageID);
		tagByName.put("ModifiedImageDate",TagFromName.ModifiedImageDate);
		tagByName.put("ModifyingDeviceManufacturer",TagFromName.ModifyingDeviceManufacturer);
		tagByName.put("ModifiedImageTime",TagFromName.ModifiedImageTime);
		tagByName.put("ModifiedImageDescription",TagFromName.ModifiedImageDescription);
		tagByName.put("ImageComments",TagFromName.ImageComments);
		tagByName.put("OriginalImageIdentification",TagFromName.OriginalImageIdentification);
		tagByName.put("OriginalImageIdentificationNomenclature",TagFromName.OriginalImageIdentificationNomenclature);
		tagByName.put("StackID",TagFromName.StackID);
		tagByName.put("InStackPositionNumber",TagFromName.InStackPositionNumber);
		tagByName.put("FrameAnatomySequence",TagFromName.FrameAnatomySequence);
		tagByName.put("FrameLaterality",TagFromName.FrameLaterality);
		tagByName.put("FrameContentSequence",TagFromName.FrameContentSequence);
		tagByName.put("PlanePositionSequence",TagFromName.PlanePositionSequence);
		tagByName.put("PlaneOrientationSequence",TagFromName.PlaneOrientationSequence);
		tagByName.put("TemporalPositionIndex",TagFromName.TemporalPositionIndex);
		tagByName.put("NominalCardiacTriggerDelayTime",TagFromName.NominalCardiacTriggerDelayTime);
		tagByName.put("NominalCardiacTriggerTimePriorToRPeak",TagFromName.NominalCardiacTriggerTimePriorToRPeak);
		tagByName.put("ActualCardiacTriggerTimePriorToRPeak",TagFromName.ActualCardiacTriggerTimePriorToRPeak);
		tagByName.put("FrameAcquisitionNumber",TagFromName.FrameAcquisitionNumber);
		tagByName.put("DimensionIndexValues",TagFromName.DimensionIndexValues);
		tagByName.put("FrameComments",TagFromName.FrameComments);
		tagByName.put("ConcatenationUID",TagFromName.ConcatenationUID);
		tagByName.put("InConcatenationNumber",TagFromName.InConcatenationNumber);
		tagByName.put("InConcatenationTotalNumber",TagFromName.InConcatenationTotalNumber);
		tagByName.put("DimensionOrganizationUID",TagFromName.DimensionOrganizationUID);
		tagByName.put("DimensionIndexPointer",TagFromName.DimensionIndexPointer);
		tagByName.put("FunctionalGroupPointer",TagFromName.FunctionalGroupPointer);
		tagByName.put("UnassignedSharedConvertedAttributesSequence",TagFromName.UnassignedSharedConvertedAttributesSequence);
		tagByName.put("UnassignedPerFrameConvertedAttributesSequence",TagFromName.UnassignedPerFrameConvertedAttributesSequence);
		tagByName.put("ConversionSourceAttributesSequence",TagFromName.ConversionSourceAttributesSequence);
		tagByName.put("DimensionIndexPrivateCreator",TagFromName.DimensionIndexPrivateCreator);
		tagByName.put("DimensionOrganizationSequence",TagFromName.DimensionOrganizationSequence);
		tagByName.put("DimensionIndexSequence",TagFromName.DimensionIndexSequence);
		tagByName.put("ConcatenationFrameOffsetNumber",TagFromName.ConcatenationFrameOffsetNumber);
		tagByName.put("FunctionalGroupPrivateCreator",TagFromName.FunctionalGroupPrivateCreator);
		tagByName.put("NominalPercentageOfCardiacPhase",TagFromName.NominalPercentageOfCardiacPhase);
		tagByName.put("NominalPercentageOfRespiratoryPhase",TagFromName.NominalPercentageOfRespiratoryPhase);
		tagByName.put("StartingRespiratoryAmplitude",TagFromName.StartingRespiratoryAmplitude);
		tagByName.put("StartingRespiratoryPhase",TagFromName.StartingRespiratoryPhase);
		tagByName.put("EndingRespiratoryAmplitude",TagFromName.EndingRespiratoryAmplitude);
		tagByName.put("EndingRespiratoryPhase",TagFromName.EndingRespiratoryPhase);
		tagByName.put("RespiratoryTriggerType",TagFromName.RespiratoryTriggerType);
		tagByName.put("RRIntervalTimeNominal",TagFromName.RRIntervalTimeNominal);
		tagByName.put("ActualCardiacTriggerDelayTime",TagFromName.ActualCardiacTriggerDelayTime);
		tagByName.put("RespiratorySynchronizationSequence",TagFromName.RespiratorySynchronizationSequence);
		tagByName.put("RespiratoryIntervalTime",TagFromName.RespiratoryIntervalTime);
		tagByName.put("NominalRespiratoryTriggerDelayTime",TagFromName.NominalRespiratoryTriggerDelayTime);
		tagByName.put("RespiratoryTriggerDelayThreshold",TagFromName.RespiratoryTriggerDelayThreshold);
		tagByName.put("ActualRespiratoryTriggerDelayTime",TagFromName.ActualRespiratoryTriggerDelayTime);
		tagByName.put("ImagePositionVolume",TagFromName.ImagePositionVolume);
		tagByName.put("ImageOrientationVolume",TagFromName.ImageOrientationVolume);
		tagByName.put("UltrasoundAcquisitionGeometry",TagFromName.UltrasoundAcquisitionGeometry);
		tagByName.put("ApexPosition",TagFromName.ApexPosition);
		tagByName.put("VolumeToTransducerMappingMatrix",TagFromName.VolumeToTransducerMappingMatrix);
		tagByName.put("VolumeToTableMappingMatrix",TagFromName.VolumeToTableMappingMatrix);
		tagByName.put("VolumeToTransducerRelationship",TagFromName.VolumeToTransducerRelationship);
		tagByName.put("PatientFrameOfReferenceSource",TagFromName.PatientFrameOfReferenceSource);
		tagByName.put("TemporalPositionTimeOffset",TagFromName.TemporalPositionTimeOffset);
		tagByName.put("PlanePositionVolumeSequence",TagFromName.PlanePositionVolumeSequence);
		tagByName.put("PlaneOrientationVolumeSequence",TagFromName.PlaneOrientationVolumeSequence);
		tagByName.put("TemporalPositionSequence",TagFromName.TemporalPositionSequence);
		tagByName.put("DimensionOrganizationType",TagFromName.DimensionOrganizationType);
		tagByName.put("VolumeFrameOfReferenceUID",TagFromName.VolumeFrameOfReferenceUID);
		tagByName.put("TableFrameOfReferenceUID",TagFromName.TableFrameOfReferenceUID);
		tagByName.put("DimensionDescriptionLabel",TagFromName.DimensionDescriptionLabel);
		tagByName.put("PatientOrientationInFrameSequence",TagFromName.PatientOrientationInFrameSequence);
		tagByName.put("FrameLabel",TagFromName.FrameLabel);
		tagByName.put("AcquisitionIndex",TagFromName.AcquisitionIndex);
		tagByName.put("ContributingSOPInstancesReferenceSequence",TagFromName.ContributingSOPInstancesReferenceSequence);
		tagByName.put("ReconstructionIndex",TagFromName.ReconstructionIndex);
		tagByName.put("LightPathFilterPassThroughWavelength",TagFromName.LightPathFilterPassThroughWavelength);
		tagByName.put("LightPathFilterPassBand",TagFromName.LightPathFilterPassBand);
		tagByName.put("ImagePathFilterPassThroughWavelength",TagFromName.ImagePathFilterPassThroughWavelength);
		tagByName.put("ImagePathFilterPassBand",TagFromName.ImagePathFilterPassBand);
		tagByName.put("PatientEyeMovementCommanded",TagFromName.PatientEyeMovementCommanded);
		tagByName.put("PatientEyeMovementCommandCodeSequence",TagFromName.PatientEyeMovementCommandCodeSequence);
		tagByName.put("SphericalLensPower",TagFromName.SphericalLensPower);
		tagByName.put("CylinderLensPower",TagFromName.CylinderLensPower);
		tagByName.put("CylinderAxis",TagFromName.CylinderAxis);
		tagByName.put("EmmetropicMagnification",TagFromName.EmmetropicMagnification);
		tagByName.put("IntraOcularPressure",TagFromName.IntraOcularPressure);
		tagByName.put("HorizontalFieldOfView",TagFromName.HorizontalFieldOfView);
		tagByName.put("PupilDilated",TagFromName.PupilDilated);
		tagByName.put("DegreeOfDilation",TagFromName.DegreeOfDilation);
		tagByName.put("StereoBaselineAngle",TagFromName.StereoBaselineAngle);
		tagByName.put("StereoBaselineDisplacement",TagFromName.StereoBaselineDisplacement);
		tagByName.put("StereoHorizontalPixelOffset",TagFromName.StereoHorizontalPixelOffset);
		tagByName.put("StereoVerticalPixelOffset",TagFromName.StereoVerticalPixelOffset);
		tagByName.put("StereoRotation",TagFromName.StereoRotation);
		tagByName.put("AcquisitionDeviceTypeCodeSequence",TagFromName.AcquisitionDeviceTypeCodeSequence);
		tagByName.put("IlluminationTypeCodeSequence",TagFromName.IlluminationTypeCodeSequence);
		tagByName.put("LightPathFilterTypeStackCodeSequence",TagFromName.LightPathFilterTypeStackCodeSequence);
		tagByName.put("ImagePathFilterTypeStackCodeSequence",TagFromName.ImagePathFilterTypeStackCodeSequence);
		tagByName.put("LensesCodeSequence",TagFromName.LensesCodeSequence);
		tagByName.put("ChannelDescriptionCodeSequence",TagFromName.ChannelDescriptionCodeSequence);
		tagByName.put("RefractiveStateSequence",TagFromName.RefractiveStateSequence);
		tagByName.put("MydriaticAgentCodeSequence",TagFromName.MydriaticAgentCodeSequence);
		tagByName.put("RelativeImagePositionCodeSequence",TagFromName.RelativeImagePositionCodeSequence);
		tagByName.put("CameraAngleOfView",TagFromName.CameraAngleOfView);
		tagByName.put("StereoPairsSequence",TagFromName.StereoPairsSequence);
		tagByName.put("LeftImageSequence",TagFromName.LeftImageSequence);
		tagByName.put("RightImageSequence",TagFromName.RightImageSequence);
		tagByName.put("StereoPairsPresent",TagFromName.StereoPairsPresent);
		tagByName.put("AxialLengthOfTheEye",TagFromName.AxialLengthOfTheEye);
		tagByName.put("OphthalmicFrameLocationSequence",TagFromName.OphthalmicFrameLocationSequence);
		tagByName.put("ReferenceCoordinates",TagFromName.ReferenceCoordinates);
		tagByName.put("DepthSpatialResolution",TagFromName.DepthSpatialResolution);
		tagByName.put("MaximumDepthDistortion",TagFromName.MaximumDepthDistortion);
		tagByName.put("AlongScanSpatialResolution",TagFromName.AlongScanSpatialResolution);
		tagByName.put("MaximumAlongScanDistortion",TagFromName.MaximumAlongScanDistortion);
		tagByName.put("OphthalmicImageOrientation",TagFromName.OphthalmicImageOrientation);
		tagByName.put("DepthOfTransverseImage",TagFromName.DepthOfTransverseImage);
		tagByName.put("MydriaticAgentConcentrationUnitsSequence",TagFromName.MydriaticAgentConcentrationUnitsSequence);
		tagByName.put("AcrossScanSpatialResolution",TagFromName.AcrossScanSpatialResolution);
		tagByName.put("MaximumAcrossScanDistortion",TagFromName.MaximumAcrossScanDistortion);
		tagByName.put("MydriaticAgentConcentration",TagFromName.MydriaticAgentConcentration);
		tagByName.put("IlluminationWaveLength",TagFromName.IlluminationWaveLength);
		tagByName.put("IlluminationPower",TagFromName.IlluminationPower);
		tagByName.put("IlluminationBandwidth",TagFromName.IlluminationBandwidth);
		tagByName.put("MydriaticAgentSequence",TagFromName.MydriaticAgentSequence);
		tagByName.put("OphthalmicAxialMeasurementsRightEyeSequence",TagFromName.OphthalmicAxialMeasurementsRightEyeSequence);
		tagByName.put("OphthalmicAxialMeasurementsLeftEyeSequence",TagFromName.OphthalmicAxialMeasurementsLeftEyeSequence);
		tagByName.put("OphthalmicAxialMeasurementsDeviceType",TagFromName.OphthalmicAxialMeasurementsDeviceType);
		tagByName.put("OphthalmicAxialLengthMeasurementsType",TagFromName.OphthalmicAxialLengthMeasurementsType);
		tagByName.put("OphthalmicAxialLengthSequence",TagFromName.OphthalmicAxialLengthSequence);
		tagByName.put("OphthalmicAxialLength",TagFromName.OphthalmicAxialLength);
		tagByName.put("LensStatusCodeSequence",TagFromName.LensStatusCodeSequence);
		tagByName.put("VitreousStatusCodeSequence",TagFromName.VitreousStatusCodeSequence);
		tagByName.put("IOLFormulaCodeSequence",TagFromName.IOLFormulaCodeSequence);
		tagByName.put("IOLFormulaDetail",TagFromName.IOLFormulaDetail);
		tagByName.put("KeratometerIndex",TagFromName.KeratometerIndex);
		tagByName.put("SourceOfOphthalmicAxialLengthCodeSequence",TagFromName.SourceOfOphthalmicAxialLengthCodeSequence);
		tagByName.put("TargetRefraction",TagFromName.TargetRefraction);
		tagByName.put("RefractiveProcedureOccurred",TagFromName.RefractiveProcedureOccurred);
		tagByName.put("RefractiveSurgeryTypeCodeSequence",TagFromName.RefractiveSurgeryTypeCodeSequence);
		tagByName.put("OphthalmicUltrasoundMethodCodeSequence",TagFromName.OphthalmicUltrasoundMethodCodeSequence);
		tagByName.put("OphthalmicAxialLengthMeasurementsSequence",TagFromName.OphthalmicAxialLengthMeasurementsSequence);
		tagByName.put("IOLPower",TagFromName.IOLPower);
		tagByName.put("PredictedRefractiveError",TagFromName.PredictedRefractiveError);
		tagByName.put("OphthalmicAxialLengthVelocity",TagFromName.OphthalmicAxialLengthVelocity);
		tagByName.put("LensStatusDescription",TagFromName.LensStatusDescription);
		tagByName.put("VitreousStatusDescription",TagFromName.VitreousStatusDescription);
		tagByName.put("IOLPowerSequence",TagFromName.IOLPowerSequence);
		tagByName.put("LensConstantSequence",TagFromName.LensConstantSequence);
		tagByName.put("IOLManufacturer",TagFromName.IOLManufacturer);
		tagByName.put("LensConstantDescription",TagFromName.LensConstantDescription);
		tagByName.put("ImplantName",TagFromName.ImplantName);
		tagByName.put("KeratometryMeasurementTypeCodeSequence",TagFromName.KeratometryMeasurementTypeCodeSequence);
		tagByName.put("ImplantPartNumber",TagFromName.ImplantPartNumber);
		tagByName.put("ReferencedOphthalmicAxialMeasurementsSequence",TagFromName.ReferencedOphthalmicAxialMeasurementsSequence);
		tagByName.put("OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence",TagFromName.OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence);
		tagByName.put("RefractiveErrorBeforeRefractiveSurgeryCodeSequence",TagFromName.RefractiveErrorBeforeRefractiveSurgeryCodeSequence);
		tagByName.put("IOLPowerForExactEmmetropia",TagFromName.IOLPowerForExactEmmetropia);
		tagByName.put("IOLPowerForExactTargetRefraction",TagFromName.IOLPowerForExactTargetRefraction);
		tagByName.put("AnteriorChamberDepthDefinitionCodeSequence",TagFromName.AnteriorChamberDepthDefinitionCodeSequence);
		tagByName.put("LensThicknessSequence",TagFromName.LensThicknessSequence);
		tagByName.put("AnteriorChamberDepthSequence",TagFromName.AnteriorChamberDepthSequence);
		tagByName.put("LensThickness",TagFromName.LensThickness);
		tagByName.put("AnteriorChamberDepth",TagFromName.AnteriorChamberDepth);
		tagByName.put("SourceOfLensThicknessDataCodeSequence",TagFromName.SourceOfLensThicknessDataCodeSequence);
		tagByName.put("SourceOfAnteriorChamberDepthDataCodeSequence",TagFromName.SourceOfAnteriorChamberDepthDataCodeSequence);
		tagByName.put("SourceOfRefractiveMeasurementsSequence",TagFromName.SourceOfRefractiveMeasurementsSequence);
		tagByName.put("SourceOfRefractiveMeasurementsCodeSequence",TagFromName.SourceOfRefractiveMeasurementsCodeSequence);
		tagByName.put("OphthalmicAxialLengthMeasurementModified",TagFromName.OphthalmicAxialLengthMeasurementModified);
		tagByName.put("OphthalmicAxialLengthDataSourceCodeSequence",TagFromName.OphthalmicAxialLengthDataSourceCodeSequence);
		tagByName.put("OphthalmicAxialLengthAcquisitionMethodCodeSequence",TagFromName.OphthalmicAxialLengthAcquisitionMethodCodeSequence);
		tagByName.put("SignalToNoiseRatio",TagFromName.SignalToNoiseRatio);
		tagByName.put("OphthalmicAxialLengthDataSourceDescription",TagFromName.OphthalmicAxialLengthDataSourceDescription);
		tagByName.put("OphthalmicAxialLengthMeasurementsTotalLengthSequence",TagFromName.OphthalmicAxialLengthMeasurementsTotalLengthSequence);
		tagByName.put("OphthalmicAxialLengthMeasurementsSegmentalLengthSequence",TagFromName.OphthalmicAxialLengthMeasurementsSegmentalLengthSequence);
		tagByName.put("OphthalmicAxialLengthMeasurementsLengthSummationSequence",TagFromName.OphthalmicAxialLengthMeasurementsLengthSummationSequence);
		tagByName.put("UltrasoundOphthalmicAxialLengthMeasurementsSequence",TagFromName.UltrasoundOphthalmicAxialLengthMeasurementsSequence);
		tagByName.put("OpticalOphthalmicAxialLengthMeasurementsSequence",TagFromName.OpticalOphthalmicAxialLengthMeasurementsSequence);
		tagByName.put("UltrasoundSelectedOphthalmicAxialLengthSequence",TagFromName.UltrasoundSelectedOphthalmicAxialLengthSequence);
		tagByName.put("OphthalmicAxialLengthSelectionMethodCodeSequence",TagFromName.OphthalmicAxialLengthSelectionMethodCodeSequence);
		tagByName.put("OpticalSelectedOphthalmicAxialLengthSequence",TagFromName.OpticalSelectedOphthalmicAxialLengthSequence);
		tagByName.put("SelectedSegmentalOphthalmicAxialLengthSequence",TagFromName.SelectedSegmentalOphthalmicAxialLengthSequence);
		tagByName.put("SelectedTotalOphthalmicAxialLengthSequence",TagFromName.SelectedTotalOphthalmicAxialLengthSequence);
		tagByName.put("OphthalmicAxialLengthQualityMetricSequence",TagFromName.OphthalmicAxialLengthQualityMetricSequence);
		tagByName.put("OphthalmicAxialLengthQualityMetricTypeCodeSequence",TagFromName.OphthalmicAxialLengthQualityMetricTypeCodeSequence);
		tagByName.put("OphthalmicAxialLengthQualityMetricTypeDescription",TagFromName.OphthalmicAxialLengthQualityMetricTypeDescription);
		tagByName.put("IntraocularLensCalculationsRightEyeSequence",TagFromName.IntraocularLensCalculationsRightEyeSequence);
		tagByName.put("IntraocularLensCalculationsLeftEyeSequence",TagFromName.IntraocularLensCalculationsLeftEyeSequence);
		tagByName.put("ReferencedOphthalmicAxialLengthMeasurementQCImageSequence",TagFromName.ReferencedOphthalmicAxialLengthMeasurementQCImageSequence);
		tagByName.put("OphthalmicMappingDeviceType",TagFromName.OphthalmicMappingDeviceType);
		tagByName.put("AcquisitionMethodCodeSequence",TagFromName.AcquisitionMethodCodeSequence);
		tagByName.put("AcquisitionMethodAlgorithmSequence",TagFromName.AcquisitionMethodAlgorithmSequence);
		tagByName.put("OphthalmicThicknessMapTypeCodeSequence",TagFromName.OphthalmicThicknessMapTypeCodeSequence);
		tagByName.put("OphthalmicThicknessMappingNormalsSequence",TagFromName.OphthalmicThicknessMappingNormalsSequence);
		tagByName.put("RetinalThicknessDefinitionCodeSequence",TagFromName.RetinalThicknessDefinitionCodeSequence);
		tagByName.put("PixelValueMappingToCodedConceptSequence",TagFromName.PixelValueMappingToCodedConceptSequence);
		tagByName.put("MappedPixelValue",TagFromName.MappedPixelValue);
		tagByName.put("PixelValueMappingExplanation",TagFromName.PixelValueMappingExplanation);
		tagByName.put("OphthalmicThicknessMapQualityThresholdSequence",TagFromName.OphthalmicThicknessMapQualityThresholdSequence);
		tagByName.put("OphthalmicThicknessMapThresholdQualityRating",TagFromName.OphthalmicThicknessMapThresholdQualityRating);
		tagByName.put("AnatomicStructureReferencePoint",TagFromName.AnatomicStructureReferencePoint);
		tagByName.put("RegistrationToLocalizerSequence",TagFromName.RegistrationToLocalizerSequence);
		tagByName.put("RegisteredLocalizerUnits",TagFromName.RegisteredLocalizerUnits);
		tagByName.put("RegisteredLocalizerTopLeftHandCorner",TagFromName.RegisteredLocalizerTopLeftHandCorner);
		tagByName.put("RegisteredLocalizerBottomRightHandCorner",TagFromName.RegisteredLocalizerBottomRightHandCorner);
		tagByName.put("OphthalmicThicknessMapQualityRatingSequence",TagFromName.OphthalmicThicknessMapQualityRatingSequence);
		tagByName.put("RelevantOPTAttributesSequence",TagFromName.RelevantOPTAttributesSequence);
		tagByName.put("TransformationMethodCodeSequence",TagFromName.TransformationMethodCodeSequence);
		tagByName.put("TransformationAlgorithmSequence",TagFromName.TransformationAlgorithmSequence);
		tagByName.put("OphthalmicAxialLengthMethod",TagFromName.OphthalmicAxialLengthMethod);
		tagByName.put("OphthalmicFOV",TagFromName.OphthalmicFOV);
		tagByName.put("TwoDimensionalToThreeDimensionalMapSequence",TagFromName.TwoDimensionalToThreeDimensionalMapSequence);
		tagByName.put("WideFieldOphthalmicPhotographyQualityRatingSequence",TagFromName.WideFieldOphthalmicPhotographyQualityRatingSequence);
		tagByName.put("WideFieldOphthalmicPhotographyQualityThresholdSequence",TagFromName.WideFieldOphthalmicPhotographyQualityThresholdSequence);
		tagByName.put("WideFieldOphthalmicPhotographyThresholdQualityRating",TagFromName.WideFieldOphthalmicPhotographyThresholdQualityRating);
		tagByName.put("XCoordinatesCenterPixelViewAngle",TagFromName.XCoordinatesCenterPixelViewAngle);
		tagByName.put("YCoordinatesCenterPixelViewAngle",TagFromName.YCoordinatesCenterPixelViewAngle);
		tagByName.put("NumberOfMapPoints",TagFromName.NumberOfMapPoints);
		tagByName.put("TwoDimensionalToThreeDimensionalMapData",TagFromName.TwoDimensionalToThreeDimensionalMapData);
		tagByName.put("VisualFieldHorizontalExtent",TagFromName.VisualFieldHorizontalExtent);
		tagByName.put("VisualFieldVerticalExtent",TagFromName.VisualFieldVerticalExtent);
		tagByName.put("VisualFieldShape",TagFromName.VisualFieldShape);
		tagByName.put("ScreeningTestModeCodeSequence",TagFromName.ScreeningTestModeCodeSequence);
		tagByName.put("MaximumStimulusLuminance",TagFromName.MaximumStimulusLuminance);
		tagByName.put("BackgroundLuminance",TagFromName.BackgroundLuminance);
		tagByName.put("StimulusColorCodeSequence",TagFromName.StimulusColorCodeSequence);
		tagByName.put("BackgroundIlluminationColorCodeSequence",TagFromName.BackgroundIlluminationColorCodeSequence);
		tagByName.put("StimulusArea",TagFromName.StimulusArea);
		tagByName.put("StimulusPresentationTime",TagFromName.StimulusPresentationTime);
		tagByName.put("FixationSequence",TagFromName.FixationSequence);
		tagByName.put("FixationMonitoringCodeSequence",TagFromName.FixationMonitoringCodeSequence);
		tagByName.put("VisualFieldCatchTrialSequence",TagFromName.VisualFieldCatchTrialSequence);
		tagByName.put("FixationCheckedQuantity",TagFromName.FixationCheckedQuantity);
		tagByName.put("PatientNotProperlyFixatedQuantity",TagFromName.PatientNotProperlyFixatedQuantity);
		tagByName.put("PresentedVisualStimuliDataFlag",TagFromName.PresentedVisualStimuliDataFlag);
		tagByName.put("NumberOfVisualStimuli",TagFromName.NumberOfVisualStimuli);
		tagByName.put("ExcessiveFixationLossesDataFlag",TagFromName.ExcessiveFixationLossesDataFlag);
		tagByName.put("ExcessiveFixationLosses",TagFromName.ExcessiveFixationLosses);
		tagByName.put("StimuliRetestingQuantity",TagFromName.StimuliRetestingQuantity);
		tagByName.put("CommentsOnPatientPerformanceOfVisualField",TagFromName.CommentsOnPatientPerformanceOfVisualField);
		tagByName.put("FalseNegativesEstimateFlag",TagFromName.FalseNegativesEstimateFlag);
		tagByName.put("FalseNegativesEstimate",TagFromName.FalseNegativesEstimate);
		tagByName.put("NegativeCatchTrialsQuantity",TagFromName.NegativeCatchTrialsQuantity);
		tagByName.put("FalseNegativesQuantity",TagFromName.FalseNegativesQuantity);
		tagByName.put("ExcessiveFalseNegativesDataFlag",TagFromName.ExcessiveFalseNegativesDataFlag);
		tagByName.put("ExcessiveFalseNegatives",TagFromName.ExcessiveFalseNegatives);
		tagByName.put("FalsePositivesEstimateFlag",TagFromName.FalsePositivesEstimateFlag);
		tagByName.put("FalsePositivesEstimate",TagFromName.FalsePositivesEstimate);
		tagByName.put("CatchTrialsDataFlag",TagFromName.CatchTrialsDataFlag);
		tagByName.put("PositiveCatchTrialsQuantity",TagFromName.PositiveCatchTrialsQuantity);
		tagByName.put("TestPointNormalsDataFlag",TagFromName.TestPointNormalsDataFlag);
		tagByName.put("TestPointNormalsSequence",TagFromName.TestPointNormalsSequence);
		tagByName.put("GlobalDeviationProbabilityNormalsFlag",TagFromName.GlobalDeviationProbabilityNormalsFlag);
		tagByName.put("FalsePositivesQuantity",TagFromName.FalsePositivesQuantity);
		tagByName.put("ExcessiveFalsePositivesDataFlag",TagFromName.ExcessiveFalsePositivesDataFlag);
		tagByName.put("ExcessiveFalsePositives",TagFromName.ExcessiveFalsePositives);
		tagByName.put("VisualFieldTestNormalsFlag",TagFromName.VisualFieldTestNormalsFlag);
		tagByName.put("ResultsNormalsSequence",TagFromName.ResultsNormalsSequence);
		tagByName.put("AgeCorrectedSensitivityDeviationAlgorithmSequence",TagFromName.AgeCorrectedSensitivityDeviationAlgorithmSequence);
		tagByName.put("GlobalDeviationFromNormal",TagFromName.GlobalDeviationFromNormal);
		tagByName.put("GeneralizedDefectSensitivityDeviationAlgorithmSequence",TagFromName.GeneralizedDefectSensitivityDeviationAlgorithmSequence);
		tagByName.put("LocalizedDeviationFromNormal",TagFromName.LocalizedDeviationFromNormal);
		tagByName.put("PatientReliabilityIndicator",TagFromName.PatientReliabilityIndicator);
		tagByName.put("VisualFieldMeanSensitivity",TagFromName.VisualFieldMeanSensitivity);
		tagByName.put("GlobalDeviationProbability",TagFromName.GlobalDeviationProbability);
		tagByName.put("LocalDeviationProbabilityNormalsFlag",TagFromName.LocalDeviationProbabilityNormalsFlag);
		tagByName.put("LocalizedDeviationProbability",TagFromName.LocalizedDeviationProbability);
		tagByName.put("ShortTermFluctuationCalculated",TagFromName.ShortTermFluctuationCalculated);
		tagByName.put("ShortTermFluctuation",TagFromName.ShortTermFluctuation);
		tagByName.put("ShortTermFluctuationProbabilityCalculated",TagFromName.ShortTermFluctuationProbabilityCalculated);
		tagByName.put("ShortTermFluctuationProbability",TagFromName.ShortTermFluctuationProbability);
		tagByName.put("CorrectedLocalizedDeviationFromNormalCalculated",TagFromName.CorrectedLocalizedDeviationFromNormalCalculated);
		tagByName.put("CorrectedLocalizedDeviationFromNormal",TagFromName.CorrectedLocalizedDeviationFromNormal);
		tagByName.put("CorrectedLocalizedDeviationFromNormalProbabilityCalculated",TagFromName.CorrectedLocalizedDeviationFromNormalProbabilityCalculated);
		tagByName.put("CorrectedLocalizedDeviationFromNormalProbability",TagFromName.CorrectedLocalizedDeviationFromNormalProbability);
		tagByName.put("GlobalDeviationProbabilitySequence",TagFromName.GlobalDeviationProbabilitySequence);
		tagByName.put("LocalizedDeviationProbabilitySequence",TagFromName.LocalizedDeviationProbabilitySequence);
		tagByName.put("FovealSensitivityMeasured",TagFromName.FovealSensitivityMeasured);
		tagByName.put("FovealSensitivity",TagFromName.FovealSensitivity);
		tagByName.put("VisualFieldTestDuration",TagFromName.VisualFieldTestDuration);
		tagByName.put("VisualFieldTestPointSequence",TagFromName.VisualFieldTestPointSequence);
		tagByName.put("VisualFieldTestPointXCoordinate",TagFromName.VisualFieldTestPointXCoordinate);
		tagByName.put("VisualFieldTestPointYCoordinate",TagFromName.VisualFieldTestPointYCoordinate);
		tagByName.put("AgeCorrectedSensitivityDeviationValue",TagFromName.AgeCorrectedSensitivityDeviationValue);
		tagByName.put("StimulusResults",TagFromName.StimulusResults);
		tagByName.put("SensitivityValue",TagFromName.SensitivityValue);
		tagByName.put("RetestStimulusSeen",TagFromName.RetestStimulusSeen);
		tagByName.put("RetestSensitivityValue",TagFromName.RetestSensitivityValue);
		tagByName.put("VisualFieldTestPointNormalsSequence",TagFromName.VisualFieldTestPointNormalsSequence);
		tagByName.put("QuantifiedDefect",TagFromName.QuantifiedDefect);
		tagByName.put("AgeCorrectedSensitivityDeviationProbabilityValue",TagFromName.AgeCorrectedSensitivityDeviationProbabilityValue);
		tagByName.put("GeneralizedDefectCorrectedSensitivityDeviationFlag",TagFromName.GeneralizedDefectCorrectedSensitivityDeviationFlag);
		tagByName.put("GeneralizedDefectCorrectedSensitivityDeviationValue",TagFromName.GeneralizedDefectCorrectedSensitivityDeviationValue);
		tagByName.put("GeneralizedDefectCorrectedSensitivityDeviationProbabilityValue",TagFromName.GeneralizedDefectCorrectedSensitivityDeviationProbabilityValue);
		tagByName.put("MinimumSensitivityValue",TagFromName.MinimumSensitivityValue);
		tagByName.put("BlindSpotLocalized",TagFromName.BlindSpotLocalized);
		tagByName.put("BlindSpotXCoordinate",TagFromName.BlindSpotXCoordinate);
		tagByName.put("BlindSpotYCoordinate",TagFromName.BlindSpotYCoordinate);
		tagByName.put("VisualAcuityMeasurementSequence",TagFromName.VisualAcuityMeasurementSequence);
		tagByName.put("RefractiveParametersUsedOnPatientSequence",TagFromName.RefractiveParametersUsedOnPatientSequence);
		tagByName.put("MeasurementLaterality",TagFromName.MeasurementLaterality);
		tagByName.put("OphthalmicPatientClinicalInformationLeftEyeSequence",TagFromName.OphthalmicPatientClinicalInformationLeftEyeSequence);
		tagByName.put("OphthalmicPatientClinicalInformationRightEyeSequence",TagFromName.OphthalmicPatientClinicalInformationRightEyeSequence);
		tagByName.put("FovealPointNormativeDataFlag",TagFromName.FovealPointNormativeDataFlag);
		tagByName.put("FovealPointProbabilityValue",TagFromName.FovealPointProbabilityValue);
		tagByName.put("ScreeningBaselineMeasured",TagFromName.ScreeningBaselineMeasured);
		tagByName.put("ScreeningBaselineMeasuredSequence",TagFromName.ScreeningBaselineMeasuredSequence);
		tagByName.put("ScreeningBaselineType",TagFromName.ScreeningBaselineType);
		tagByName.put("ScreeningBaselineValue",TagFromName.ScreeningBaselineValue);
		tagByName.put("AlgorithmSource",TagFromName.AlgorithmSource);
		tagByName.put("DataSetName",TagFromName.DataSetName);
		tagByName.put("DataSetVersion",TagFromName.DataSetVersion);
		tagByName.put("DataSetSource",TagFromName.DataSetSource);
		tagByName.put("DataSetDescription",TagFromName.DataSetDescription);
		tagByName.put("VisualFieldTestReliabilityGlobalIndexSequence",TagFromName.VisualFieldTestReliabilityGlobalIndexSequence);
		tagByName.put("VisualFieldGlobalResultsIndexSequence",TagFromName.VisualFieldGlobalResultsIndexSequence);
		tagByName.put("DataObservationSequence",TagFromName.DataObservationSequence);
		tagByName.put("IndexNormalsFlag",TagFromName.IndexNormalsFlag);
		tagByName.put("IndexProbability",TagFromName.IndexProbability);
		tagByName.put("IndexProbabilitySequence",TagFromName.IndexProbabilitySequence);
		tagByName.put("SamplesPerPixel",TagFromName.SamplesPerPixel);
		tagByName.put("SamplesPerPixelUsed",TagFromName.SamplesPerPixelUsed);
		tagByName.put("PhotometricInterpretation",TagFromName.PhotometricInterpretation);
		tagByName.put("ImageDimensions",TagFromName.ImageDimensions);
		tagByName.put("PlanarConfiguration",TagFromName.PlanarConfiguration);
		tagByName.put("NumberOfFrames",TagFromName.NumberOfFrames);
		tagByName.put("FrameIncrementPointer",TagFromName.FrameIncrementPointer);
		tagByName.put("FrameDimensionPointer",TagFromName.FrameDimensionPointer);
		tagByName.put("Rows",TagFromName.Rows);
		tagByName.put("Columns",TagFromName.Columns);
		tagByName.put("Planes",TagFromName.Planes);
		tagByName.put("UltrasoundColorDataPresent",TagFromName.UltrasoundColorDataPresent);
		tagByName.put("PixelSpacing",TagFromName.PixelSpacing);
		tagByName.put("ZoomFactor",TagFromName.ZoomFactor);
		tagByName.put("ZoomCenter",TagFromName.ZoomCenter);
		tagByName.put("PixelAspectRatio",TagFromName.PixelAspectRatio);
		tagByName.put("ImageFormat",TagFromName.ImageFormat);
		tagByName.put("ManipulatedImage",TagFromName.ManipulatedImage);
		tagByName.put("CorrectedImage",TagFromName.CorrectedImage);
		tagByName.put("CompressionRecognitionCode",TagFromName.CompressionRecognitionCode);
		tagByName.put("CompressionCode",TagFromName.CompressionCode);
		tagByName.put("CompressionOriginator",TagFromName.CompressionOriginator);
		tagByName.put("CompressionLabel",TagFromName.CompressionLabel);
		tagByName.put("CompressionDescription",TagFromName.CompressionDescription);
		tagByName.put("CompressionSequence",TagFromName.CompressionSequence);
		tagByName.put("CompressionStepPointers",TagFromName.CompressionStepPointers);
		tagByName.put("RepeatInterval",TagFromName.RepeatInterval);
		tagByName.put("BitsGrouped",TagFromName.BitsGrouped);
		tagByName.put("PerimeterTable",TagFromName.PerimeterTable);
		tagByName.put("PerimeterValue",TagFromName.PerimeterValue);
		tagByName.put("PredictorRows",TagFromName.PredictorRows);
		tagByName.put("PredictorColumns",TagFromName.PredictorColumns);
		tagByName.put("PredictorConstants",TagFromName.PredictorConstants);
		tagByName.put("BlockedPixels",TagFromName.BlockedPixels);
		tagByName.put("BlockRows",TagFromName.BlockRows);
		tagByName.put("BlockColumns",TagFromName.BlockColumns);
		tagByName.put("RowOverlap",TagFromName.RowOverlap);
		tagByName.put("ColumnOverlap",TagFromName.ColumnOverlap);
		tagByName.put("BitsAllocated",TagFromName.BitsAllocated);
		tagByName.put("BitsStored",TagFromName.BitsStored);
		tagByName.put("HighBit",TagFromName.HighBit);
		tagByName.put("PixelRepresentation",TagFromName.PixelRepresentation);
		tagByName.put("SmallestValidPixelValue",TagFromName.SmallestValidPixelValue);
		tagByName.put("LargestValidPixelValue",TagFromName.LargestValidPixelValue);
		tagByName.put("SmallestImagePixelValue",TagFromName.SmallestImagePixelValue);
		tagByName.put("LargestImagePixelValue",TagFromName.LargestImagePixelValue);
		tagByName.put("SmallestPixelValueInSeries",TagFromName.SmallestPixelValueInSeries);
		tagByName.put("LargestPixelValueInSeries",TagFromName.LargestPixelValueInSeries);
		tagByName.put("SmallestImagePixelValueInPlane",TagFromName.SmallestImagePixelValueInPlane);
		tagByName.put("LargestImagePixelValueInPlane",TagFromName.LargestImagePixelValueInPlane);
		tagByName.put("PixelPaddingValue",TagFromName.PixelPaddingValue);
		tagByName.put("PixelPaddingRangeLimit",TagFromName.PixelPaddingRangeLimit);
		tagByName.put("FloatPixelPaddingValue",TagFromName.FloatPixelPaddingValue);
		tagByName.put("DoubleFloatPixelPaddingValue",TagFromName.DoubleFloatPixelPaddingValue);
		tagByName.put("FloatPixelPaddingRangeLimit",TagFromName.FloatPixelPaddingRangeLimit);
		tagByName.put("DoubleFloatPixelPaddingRangeLimit",TagFromName.DoubleFloatPixelPaddingRangeLimit);
		tagByName.put("ImageLocation",TagFromName.ImageLocation);
		tagByName.put("QualityControlImage",TagFromName.QualityControlImage);
		tagByName.put("BurnedInAnnotation",TagFromName.BurnedInAnnotation);
		tagByName.put("RecognizableVisualFeatures",TagFromName.RecognizableVisualFeatures);
		tagByName.put("LongitudinalTemporalInformationModified",TagFromName.LongitudinalTemporalInformationModified);
		tagByName.put("ReferencedColorPaletteInstanceUID",TagFromName.ReferencedColorPaletteInstanceUID);
		tagByName.put("TransformLabel",TagFromName.TransformLabel);
		tagByName.put("TransformVersionNumber",TagFromName.TransformVersionNumber);
		tagByName.put("NumberOfTransformSteps",TagFromName.NumberOfTransformSteps);
		tagByName.put("SequenceOfCompressedData",TagFromName.SequenceOfCompressedData);
		tagByName.put("DetailsOfCoefficients",TagFromName.DetailsOfCoefficients);
		tagByName.put("DCTLabel",TagFromName.DCTLabel);
		tagByName.put("DataBlockDescription",TagFromName.DataBlockDescription);
		tagByName.put("DataBlock",TagFromName.DataBlock);
		tagByName.put("NormalizationFactorFormat",TagFromName.NormalizationFactorFormat);
		tagByName.put("ZonalMapNumberFormat",TagFromName.ZonalMapNumberFormat);
		tagByName.put("ZonalMapLocation",TagFromName.ZonalMapLocation);
		tagByName.put("ZonalMapFormat",TagFromName.ZonalMapFormat);
		tagByName.put("AdaptiveMapFormat",TagFromName.AdaptiveMapFormat);
		tagByName.put("CodeNumberFormat",TagFromName.CodeNumberFormat);
		tagByName.put("PixelSpacingCalibrationType",TagFromName.PixelSpacingCalibrationType);
		tagByName.put("PixelSpacingCalibrationDescription",TagFromName.PixelSpacingCalibrationDescription);
		tagByName.put("PixelIntensityRelationship",TagFromName.PixelIntensityRelationship);
		tagByName.put("PixelIntensityRelationshipSign",TagFromName.PixelIntensityRelationshipSign);
		tagByName.put("WindowCenter",TagFromName.WindowCenter);
		tagByName.put("WindowWidth",TagFromName.WindowWidth);
		tagByName.put("RescaleIntercept",TagFromName.RescaleIntercept);
		tagByName.put("RescaleSlope",TagFromName.RescaleSlope);
		tagByName.put("RescaleType",TagFromName.RescaleType);
		tagByName.put("WindowCenterWidthExplanation",TagFromName.WindowCenterWidthExplanation);
		tagByName.put("VOILUTFunction",TagFromName.VOILUTFunction);
		tagByName.put("GrayScale",TagFromName.GrayScale);
		tagByName.put("RecommendedViewingMode",TagFromName.RecommendedViewingMode);
		tagByName.put("GrayLookupTableDescriptor",TagFromName.GrayLookupTableDescriptor);
		tagByName.put("RedPaletteColorLookupTableDescriptor",TagFromName.RedPaletteColorLookupTableDescriptor);
		tagByName.put("GreenPaletteColorLookupTableDescriptor",TagFromName.GreenPaletteColorLookupTableDescriptor);
		tagByName.put("BluePaletteColorLookupTableDescriptor",TagFromName.BluePaletteColorLookupTableDescriptor);
		tagByName.put("AlphaPaletteColorLookupTableDescriptor",TagFromName.AlphaPaletteColorLookupTableDescriptor);
		tagByName.put("LargeRedPaletteColorLookupTableDescriptor",TagFromName.LargeRedPaletteColorLookupTableDescriptor);
		tagByName.put("LargeGreenPaletteColorLookupTableDescriptor",TagFromName.LargeGreenPaletteColorLookupTableDescriptor);
		tagByName.put("LargeBluePaletteColorLookupTableDescriptor",TagFromName.LargeBluePaletteColorLookupTableDescriptor);
		tagByName.put("PaletteColorLookupTableUID",TagFromName.PaletteColorLookupTableUID);
		tagByName.put("GrayLookupTableData",TagFromName.GrayLookupTableData);
		tagByName.put("RedPaletteColorLookupTableData",TagFromName.RedPaletteColorLookupTableData);
		tagByName.put("GreenPaletteColorLookupTableData",TagFromName.GreenPaletteColorLookupTableData);
		tagByName.put("BluePaletteColorLookupTableData",TagFromName.BluePaletteColorLookupTableData);
		tagByName.put("AlphaPaletteColorLookupTableData",TagFromName.AlphaPaletteColorLookupTableData);
		tagByName.put("LargeRedPaletteColorLookupTableData",TagFromName.LargeRedPaletteColorLookupTableData);
		tagByName.put("LargeGreenPaletteColorLookupTableData",TagFromName.LargeGreenPaletteColorLookupTableData);
		tagByName.put("LargeBluePaletteColorLookupTableData",TagFromName.LargeBluePaletteColorLookupTableData);
		tagByName.put("LargePaletteColorLookupTableUID",TagFromName.LargePaletteColorLookupTableUID);
		tagByName.put("SegmentedRedPaletteColorLookupTableData",TagFromName.SegmentedRedPaletteColorLookupTableData);
		tagByName.put("SegmentedGreenPaletteColorLookupTableData",TagFromName.SegmentedGreenPaletteColorLookupTableData);
		tagByName.put("SegmentedBluePaletteColorLookupTableData",TagFromName.SegmentedBluePaletteColorLookupTableData);
		tagByName.put("SegmentedAlphaPaletteColorLookupTableData",TagFromName.SegmentedAlphaPaletteColorLookupTableData);
		tagByName.put("BreastImplantPresent",TagFromName.BreastImplantPresent);
		tagByName.put("PartialView",TagFromName.PartialView);
		tagByName.put("PartialViewDescription",TagFromName.PartialViewDescription);
		tagByName.put("PartialViewCodeSequence",TagFromName.PartialViewCodeSequence);
		tagByName.put("SpatialLocationsPreserved",TagFromName.SpatialLocationsPreserved);
		tagByName.put("DataFrameAssignmentSequence",TagFromName.DataFrameAssignmentSequence);
		tagByName.put("DataPathAssignment",TagFromName.DataPathAssignment);
		tagByName.put("BitsMappedToColorLookupTable",TagFromName.BitsMappedToColorLookupTable);
		tagByName.put("BlendingLUT1Sequence",TagFromName.BlendingLUT1Sequence);
		tagByName.put("BlendingLUT1TransferFunction",TagFromName.BlendingLUT1TransferFunction);
		tagByName.put("BlendingWeightConstant",TagFromName.BlendingWeightConstant);
		tagByName.put("BlendingLookupTableDescriptor",TagFromName.BlendingLookupTableDescriptor);
		tagByName.put("BlendingLookupTableData",TagFromName.BlendingLookupTableData);
		tagByName.put("EnhancedPaletteColorLookupTableSequence",TagFromName.EnhancedPaletteColorLookupTableSequence);
		tagByName.put("BlendingLUT2Sequence",TagFromName.BlendingLUT2Sequence);
		tagByName.put("BlendingLUT2TransferFunction",TagFromName.BlendingLUT2TransferFunction);
		tagByName.put("DataPathID",TagFromName.DataPathID);
		tagByName.put("RGBLUTTransferFunction",TagFromName.RGBLUTTransferFunction);
		tagByName.put("AlphaLUTTransferFunction",TagFromName.AlphaLUTTransferFunction);
		tagByName.put("ICCProfile",TagFromName.ICCProfile);
		tagByName.put("ColorSpace",TagFromName.ColorSpace);
		tagByName.put("LossyImageCompression",TagFromName.LossyImageCompression);
		tagByName.put("LossyImageCompressionRatio",TagFromName.LossyImageCompressionRatio);
		tagByName.put("LossyImageCompressionMethod",TagFromName.LossyImageCompressionMethod);
		tagByName.put("ModalityLUTSequence",TagFromName.ModalityLUTSequence);
		tagByName.put("LUTDescriptor",TagFromName.LUTDescriptor);
		tagByName.put("LUTExplanation",TagFromName.LUTExplanation);
		tagByName.put("ModalityLUTType",TagFromName.ModalityLUTType);
		tagByName.put("LUTData",TagFromName.LUTData);
		tagByName.put("VOILUTSequence",TagFromName.VOILUTSequence);
		tagByName.put("SoftcopyVOILUTSequence",TagFromName.SoftcopyVOILUTSequence);
		tagByName.put("ImagePresentationComments",TagFromName.ImagePresentationComments);
		tagByName.put("BiPlaneAcquisitionSequence",TagFromName.BiPlaneAcquisitionSequence);
		tagByName.put("RepresentativeFrameNumber",TagFromName.RepresentativeFrameNumber);
		tagByName.put("FrameNumbersOfInterest",TagFromName.FrameNumbersOfInterest);
		tagByName.put("FrameOfInterestDescription",TagFromName.FrameOfInterestDescription);
		tagByName.put("FrameOfInterestType",TagFromName.FrameOfInterestType);
		tagByName.put("MaskPointers",TagFromName.MaskPointers);
		tagByName.put("RWavePointer",TagFromName.RWavePointer);
		tagByName.put("MaskSubtractionSequence",TagFromName.MaskSubtractionSequence);
		tagByName.put("MaskOperation",TagFromName.MaskOperation);
		tagByName.put("ApplicableFrameRange",TagFromName.ApplicableFrameRange);
		tagByName.put("MaskFrameNumbers",TagFromName.MaskFrameNumbers);
		tagByName.put("ContrastFrameAveraging",TagFromName.ContrastFrameAveraging);
		tagByName.put("MaskSubPixelShift",TagFromName.MaskSubPixelShift);
		tagByName.put("TIDOffset",TagFromName.TIDOffset);
		tagByName.put("MaskOperationExplanation",TagFromName.MaskOperationExplanation);
		tagByName.put("EquipmentAdministratorSequence",TagFromName.EquipmentAdministratorSequence);
		tagByName.put("NumberOfDisplaySubsystems",TagFromName.NumberOfDisplaySubsystems);
		tagByName.put("CurrentConfigurationID",TagFromName.CurrentConfigurationID);
		tagByName.put("DisplaySystemID",TagFromName.DisplaySystemID);
		tagByName.put("DisplaySubsystemName",TagFromName.DisplaySubsystemName);
		tagByName.put("DisplaySubsystemDescription",TagFromName.DisplaySubsystemDescription);
		tagByName.put("SystemStatus",TagFromName.SystemStatus);
		tagByName.put("SystemStatusComment",TagFromName.SystemStatusComment);
		tagByName.put("TargetLuminanceCharacteristicsSequence",TagFromName.TargetLuminanceCharacteristicsSequence);
		tagByName.put("LuminanceCharacteristicsID",TagFromName.LuminanceCharacteristicsID);
		tagByName.put("DisplaySubsystemConfigurationSequence",TagFromName.DisplaySubsystemConfigurationSequence);
		tagByName.put("ConfigurationID",TagFromName.ConfigurationID);
		tagByName.put("ConfigurationName",TagFromName.ConfigurationName);
		tagByName.put("ConfigurationDescription",TagFromName.ConfigurationDescription);
		tagByName.put("ReferencedTargetLuminanceCharacteristicsID",TagFromName.ReferencedTargetLuminanceCharacteristicsID);
		tagByName.put("QAResultsSequence",TagFromName.QAResultsSequence);
		tagByName.put("DisplaySubsystemQAResultsSequence",TagFromName.DisplaySubsystemQAResultsSequence);
		tagByName.put("ConfigurationQAResultsSequence",TagFromName.ConfigurationQAResultsSequence);
		tagByName.put("MeasurementEquipmentSequence",TagFromName.MeasurementEquipmentSequence);
		tagByName.put("MeasurementFunctions",TagFromName.MeasurementFunctions);
		tagByName.put("MeasurementEquipmentType",TagFromName.MeasurementEquipmentType);
		tagByName.put("VisualEvaluationResultSequence",TagFromName.VisualEvaluationResultSequence);
		tagByName.put("DisplayCalibrationResultSequence",TagFromName.DisplayCalibrationResultSequence);
		tagByName.put("DDLValue",TagFromName.DDLValue);
		tagByName.put("CIExyWhitePoint",TagFromName.CIExyWhitePoint);
		tagByName.put("DisplayFunctionType",TagFromName.DisplayFunctionType);
		tagByName.put("GammaValue",TagFromName.GammaValue);
		tagByName.put("NumberOfLuminancePoints",TagFromName.NumberOfLuminancePoints);
		tagByName.put("LuminanceResponseSequence",TagFromName.LuminanceResponseSequence);
		tagByName.put("TargetMinimumLuminance",TagFromName.TargetMinimumLuminance);
		tagByName.put("TargetMaximumLuminance",TagFromName.TargetMaximumLuminance);
		tagByName.put("LuminanceValue",TagFromName.LuminanceValue);
		tagByName.put("LuminanceResponseDescription",TagFromName.LuminanceResponseDescription);
		tagByName.put("WhitePointFlag",TagFromName.WhitePointFlag);
		tagByName.put("DisplayDeviceTypeCodeSequence",TagFromName.DisplayDeviceTypeCodeSequence);
		tagByName.put("DisplaySubsystemSequence",TagFromName.DisplaySubsystemSequence);
		tagByName.put("LuminanceResultSequence",TagFromName.LuminanceResultSequence);
		tagByName.put("AmbientLightValueSource",TagFromName.AmbientLightValueSource);
		tagByName.put("MeasuredCharacteristics",TagFromName.MeasuredCharacteristics);
		tagByName.put("LuminanceUniformityResultSequence",TagFromName.LuminanceUniformityResultSequence);
		tagByName.put("VisualEvaluationTestSequence",TagFromName.VisualEvaluationTestSequence);
		tagByName.put("TestResult",TagFromName.TestResult);
		tagByName.put("TestResultComment",TagFromName.TestResultComment);
		tagByName.put("TestImageValidation",TagFromName.TestImageValidation);
		tagByName.put("TestPatternCodeSequence",TagFromName.TestPatternCodeSequence);
		tagByName.put("MeasurementPatternCodeSequence",TagFromName.MeasurementPatternCodeSequence);
		tagByName.put("VisualEvaluationMethodCodeSequence",TagFromName.VisualEvaluationMethodCodeSequence);
		tagByName.put("PixelDataProviderURL",TagFromName.PixelDataProviderURL);
		tagByName.put("DataPointRows",TagFromName.DataPointRows);
		tagByName.put("DataPointColumns",TagFromName.DataPointColumns);
		tagByName.put("SignalDomainColumns",TagFromName.SignalDomainColumns);
		tagByName.put("LargestMonochromePixelValue",TagFromName.LargestMonochromePixelValue);
		tagByName.put("DataRepresentation",TagFromName.DataRepresentation);
		tagByName.put("PixelMeasuresSequence",TagFromName.PixelMeasuresSequence);
		tagByName.put("FrameVOILUTSequence",TagFromName.FrameVOILUTSequence);
		tagByName.put("PixelValueTransformationSequence",TagFromName.PixelValueTransformationSequence);
		tagByName.put("SignalDomainRows",TagFromName.SignalDomainRows);
		tagByName.put("DisplayFilterPercentage",TagFromName.DisplayFilterPercentage);
		tagByName.put("FramePixelShiftSequence",TagFromName.FramePixelShiftSequence);
		tagByName.put("SubtractionItemID",TagFromName.SubtractionItemID);
		tagByName.put("PixelIntensityRelationshipLUTSequence",TagFromName.PixelIntensityRelationshipLUTSequence);
		tagByName.put("FramePixelDataPropertiesSequence",TagFromName.FramePixelDataPropertiesSequence);
		tagByName.put("GeometricalProperties",TagFromName.GeometricalProperties);
		tagByName.put("GeometricMaximumDistortion",TagFromName.GeometricMaximumDistortion);
		tagByName.put("ImageProcessingApplied",TagFromName.ImageProcessingApplied);
		tagByName.put("MaskSelectionMode",TagFromName.MaskSelectionMode);
		tagByName.put("LUTFunction",TagFromName.LUTFunction);
		tagByName.put("MaskVisibilityPercentage",TagFromName.MaskVisibilityPercentage);
		tagByName.put("PixelShiftSequence",TagFromName.PixelShiftSequence);
		tagByName.put("RegionPixelShiftSequence",TagFromName.RegionPixelShiftSequence);
		tagByName.put("VerticesOfTheRegion",TagFromName.VerticesOfTheRegion);
		tagByName.put("MultiFramePresentationSequence",TagFromName.MultiFramePresentationSequence);
		tagByName.put("PixelShiftFrameRange",TagFromName.PixelShiftFrameRange);
		tagByName.put("LUTFrameRange",TagFromName.LUTFrameRange);
		tagByName.put("ImageToEquipmentMappingMatrix",TagFromName.ImageToEquipmentMappingMatrix);
		tagByName.put("EquipmentCoordinateSystemIdentification",TagFromName.EquipmentCoordinateSystemIdentification);
		tagByName.put("StudyStatusID",TagFromName.StudyStatusID);
		tagByName.put("StudyPriorityID",TagFromName.StudyPriorityID);
		tagByName.put("StudyIDIssuer",TagFromName.StudyIDIssuer);
		tagByName.put("StudyVerifiedDate",TagFromName.StudyVerifiedDate);
		tagByName.put("StudyVerifiedTime",TagFromName.StudyVerifiedTime);
		tagByName.put("StudyReadDate",TagFromName.StudyReadDate);
		tagByName.put("StudyReadTime",TagFromName.StudyReadTime);
		tagByName.put("ScheduledStudyStartDate",TagFromName.ScheduledStudyStartDate);
		tagByName.put("ScheduledStudyStartTime",TagFromName.ScheduledStudyStartTime);
		tagByName.put("ScheduledStudyStopDate",TagFromName.ScheduledStudyStopDate);
		tagByName.put("ScheduledStudyStopTime",TagFromName.ScheduledStudyStopTime);
		tagByName.put("ScheduledStudyLocation",TagFromName.ScheduledStudyLocation);
		tagByName.put("ScheduledStudyLocationAETitle",TagFromName.ScheduledStudyLocationAETitle);
		tagByName.put("ReasonForStudy",TagFromName.ReasonForStudy);
		tagByName.put("RequestingPhysicianIdentificationSequence",TagFromName.RequestingPhysicianIdentificationSequence);
		tagByName.put("RequestingPhysician",TagFromName.RequestingPhysician);
		tagByName.put("RequestingService",TagFromName.RequestingService);
		tagByName.put("RequestingServiceCodeSequence",TagFromName.RequestingServiceCodeSequence);
		tagByName.put("StudyArrivalDate",TagFromName.StudyArrivalDate);
		tagByName.put("StudyArrivalTime",TagFromName.StudyArrivalTime);
		tagByName.put("StudyCompletionDate",TagFromName.StudyCompletionDate);
		tagByName.put("StudyCompletionTime",TagFromName.StudyCompletionTime);
		tagByName.put("StudyComponentStatusID",TagFromName.StudyComponentStatusID);
		tagByName.put("RequestedProcedureDescription",TagFromName.RequestedProcedureDescription);
		tagByName.put("RequestedProcedureCodeSequence",TagFromName.RequestedProcedureCodeSequence);
		tagByName.put("RequestedContrastAgent",TagFromName.RequestedContrastAgent);
		tagByName.put("StudyComments",TagFromName.StudyComments);
		tagByName.put("ReferencedPatientAliasSequence",TagFromName.ReferencedPatientAliasSequence);
		tagByName.put("VisitStatusID",TagFromName.VisitStatusID);
		tagByName.put("AdmissionID",TagFromName.AdmissionID);
		tagByName.put("IssuerOfAdmissionID",TagFromName.IssuerOfAdmissionID);
		tagByName.put("IssuerOfAdmissionIDSequence",TagFromName.IssuerOfAdmissionIDSequence);
		tagByName.put("RouteOfAdmissions",TagFromName.RouteOfAdmissions);
		tagByName.put("ScheduledAdmissionDate",TagFromName.ScheduledAdmissionDate);
		tagByName.put("ScheduledAdmissionTime",TagFromName.ScheduledAdmissionTime);
		tagByName.put("ScheduledDischargeDate",TagFromName.ScheduledDischargeDate);
		tagByName.put("ScheduledDischargeTime",TagFromName.ScheduledDischargeTime);
		tagByName.put("ScheduledPatientInstitutionResidence",TagFromName.ScheduledPatientInstitutionResidence);
		tagByName.put("AdmittingDate",TagFromName.AdmittingDate);
		tagByName.put("AdmittingTime",TagFromName.AdmittingTime);
		tagByName.put("DischargeDate",TagFromName.DischargeDate);
		tagByName.put("DischargeTime",TagFromName.DischargeTime);
		tagByName.put("DischargeDiagnosisDescription",TagFromName.DischargeDiagnosisDescription);
		tagByName.put("DischargeDiagnosisCodeSequence",TagFromName.DischargeDiagnosisCodeSequence);
		tagByName.put("SpecialNeeds",TagFromName.SpecialNeeds);
		tagByName.put("ServiceEpisodeID",TagFromName.ServiceEpisodeID);
		tagByName.put("IssuerOfServiceEpisodeID",TagFromName.IssuerOfServiceEpisodeID);
		tagByName.put("ServiceEpisodeDescription",TagFromName.ServiceEpisodeDescription);
		tagByName.put("IssuerOfServiceEpisodeIDSequence",TagFromName.IssuerOfServiceEpisodeIDSequence);
		tagByName.put("PertinentDocumentsSequence",TagFromName.PertinentDocumentsSequence);
		tagByName.put("PertinentResourcesSequence",TagFromName.PertinentResourcesSequence);
		tagByName.put("ResourceDescription",TagFromName.ResourceDescription);
		tagByName.put("CurrentPatientLocation",TagFromName.CurrentPatientLocation);
		tagByName.put("PatientInstitutionResidence",TagFromName.PatientInstitutionResidence);
		tagByName.put("PatientState",TagFromName.PatientState);
		tagByName.put("PatientClinicalTrialParticipationSequence",TagFromName.PatientClinicalTrialParticipationSequence);
		tagByName.put("VisitComments",TagFromName.VisitComments);
		tagByName.put("WaveformOriginality",TagFromName.WaveformOriginality);
		tagByName.put("NumberOfWaveformChannels",TagFromName.NumberOfWaveformChannels);
		tagByName.put("NumberOfWaveformSamples",TagFromName.NumberOfWaveformSamples);
		tagByName.put("SamplingFrequency",TagFromName.SamplingFrequency);
		tagByName.put("MultiplexGroupLabel",TagFromName.MultiplexGroupLabel);
		tagByName.put("ChannelDefinitionSequence",TagFromName.ChannelDefinitionSequence);
		tagByName.put("WaveformChannelNumber",TagFromName.WaveformChannelNumber);
		tagByName.put("ChannelLabel",TagFromName.ChannelLabel);
		tagByName.put("ChannelStatus",TagFromName.ChannelStatus);
		tagByName.put("ChannelSourceSequence",TagFromName.ChannelSourceSequence);
		tagByName.put("ChannelSourceModifiersSequence",TagFromName.ChannelSourceModifiersSequence);
		tagByName.put("SourceWaveformSequence",TagFromName.SourceWaveformSequence);
		tagByName.put("ChannelDerivationDescription",TagFromName.ChannelDerivationDescription);
		tagByName.put("ChannelSensitivity",TagFromName.ChannelSensitivity);
		tagByName.put("ChannelSensitivityUnitsSequence",TagFromName.ChannelSensitivityUnitsSequence);
		tagByName.put("ChannelSensitivityCorrectionFactor",TagFromName.ChannelSensitivityCorrectionFactor);
		tagByName.put("ChannelBaseline",TagFromName.ChannelBaseline);
		tagByName.put("ChannelTimeSkew",TagFromName.ChannelTimeSkew);
		tagByName.put("ChannelSampleSkew",TagFromName.ChannelSampleSkew);
		tagByName.put("ChannelOffset",TagFromName.ChannelOffset);
		tagByName.put("WaveformBitsStored",TagFromName.WaveformBitsStored);
		tagByName.put("FilterLowFrequency",TagFromName.FilterLowFrequency);
		tagByName.put("FilterHighFrequency",TagFromName.FilterHighFrequency);
		tagByName.put("NotchFilterFrequency",TagFromName.NotchFilterFrequency);
		tagByName.put("NotchFilterBandwidth",TagFromName.NotchFilterBandwidth);
		tagByName.put("WaveformDataDisplayScale",TagFromName.WaveformDataDisplayScale);
		tagByName.put("WaveformDisplayBackgroundCIELabValue",TagFromName.WaveformDisplayBackgroundCIELabValue);
		tagByName.put("WaveformPresentationGroupSequence",TagFromName.WaveformPresentationGroupSequence);
		tagByName.put("PresentationGroupNumber",TagFromName.PresentationGroupNumber);
		tagByName.put("ChannelDisplaySequence",TagFromName.ChannelDisplaySequence);
		tagByName.put("ChannelRecommendedDisplayCIELabValue",TagFromName.ChannelRecommendedDisplayCIELabValue);
		tagByName.put("ChannelPosition",TagFromName.ChannelPosition);
		tagByName.put("DisplayShadingFlag",TagFromName.DisplayShadingFlag);
		tagByName.put("FractionalChannelDisplayScale",TagFromName.FractionalChannelDisplayScale);
		tagByName.put("AbsoluteChannelDisplayScale",TagFromName.AbsoluteChannelDisplayScale);
		tagByName.put("MultiplexedAudioChannelsDescriptionCodeSequence",TagFromName.MultiplexedAudioChannelsDescriptionCodeSequence);
		tagByName.put("ChannelIdentificationCode",TagFromName.ChannelIdentificationCode);
		tagByName.put("ChannelMode",TagFromName.ChannelMode);
		tagByName.put("ScheduledStationAETitle",TagFromName.ScheduledStationAETitle);
		tagByName.put("ScheduledProcedureStepStartDate",TagFromName.ScheduledProcedureStepStartDate);
		tagByName.put("ScheduledProcedureStepStartTime",TagFromName.ScheduledProcedureStepStartTime);
		tagByName.put("ScheduledProcedureStepEndDate",TagFromName.ScheduledProcedureStepEndDate);
		tagByName.put("ScheduledProcedureStepEndTime",TagFromName.ScheduledProcedureStepEndTime);
		tagByName.put("ScheduledPerformingPhysicianName",TagFromName.ScheduledPerformingPhysicianName);
		tagByName.put("ScheduledProcedureStepDescription",TagFromName.ScheduledProcedureStepDescription);
		tagByName.put("ScheduledProtocolCodeSequence",TagFromName.ScheduledProtocolCodeSequence);
		tagByName.put("ScheduledProcedureStepID",TagFromName.ScheduledProcedureStepID);
		tagByName.put("StageCodeSequence",TagFromName.StageCodeSequence);
		tagByName.put("ScheduledPerformingPhysicianIdentificationSequence",TagFromName.ScheduledPerformingPhysicianIdentificationSequence);
		tagByName.put("ScheduledStationName",TagFromName.ScheduledStationName);
		tagByName.put("ScheduledProcedureStepLocation",TagFromName.ScheduledProcedureStepLocation);
		tagByName.put("PreMedication",TagFromName.PreMedication);
		tagByName.put("ScheduledProcedureStepStatus",TagFromName.ScheduledProcedureStepStatus);
		tagByName.put("OrderPlacerIdentifierSequence",TagFromName.OrderPlacerIdentifierSequence);
		tagByName.put("OrderFillerIdentifierSequence",TagFromName.OrderFillerIdentifierSequence);
		tagByName.put("LocalNamespaceEntityID",TagFromName.LocalNamespaceEntityID);
		tagByName.put("UniversalEntityID",TagFromName.UniversalEntityID);
		tagByName.put("UniversalEntityIDType",TagFromName.UniversalEntityIDType);
		tagByName.put("IdentifierTypeCode",TagFromName.IdentifierTypeCode);
		tagByName.put("AssigningFacilitySequence",TagFromName.AssigningFacilitySequence);
		tagByName.put("AssigningJurisdictionCodeSequence",TagFromName.AssigningJurisdictionCodeSequence);
		tagByName.put("AssigningAgencyOrDepartmentCodeSequence",TagFromName.AssigningAgencyOrDepartmentCodeSequence);
		tagByName.put("ScheduledProcedureStepSequence",TagFromName.ScheduledProcedureStepSequence);
		tagByName.put("ReferencedNonImageCompositeSOPInstanceSequence",TagFromName.ReferencedNonImageCompositeSOPInstanceSequence);
		tagByName.put("PerformedStationAETitle",TagFromName.PerformedStationAETitle);
		tagByName.put("PerformedStationName",TagFromName.PerformedStationName);
		tagByName.put("PerformedLocation",TagFromName.PerformedLocation);
		tagByName.put("PerformedProcedureStepStartDate",TagFromName.PerformedProcedureStepStartDate);
		tagByName.put("PerformedProcedureStepStartTime",TagFromName.PerformedProcedureStepStartTime);
		tagByName.put("PerformedProcedureStepEndDate",TagFromName.PerformedProcedureStepEndDate);
		tagByName.put("PerformedProcedureStepEndTime",TagFromName.PerformedProcedureStepEndTime);
		tagByName.put("PerformedProcedureStepStatus",TagFromName.PerformedProcedureStepStatus);
		tagByName.put("PerformedProcedureStepID",TagFromName.PerformedProcedureStepID);
		tagByName.put("PerformedProcedureStepDescription",TagFromName.PerformedProcedureStepDescription);
		tagByName.put("PerformedProcedureTypeDescription",TagFromName.PerformedProcedureTypeDescription);
		tagByName.put("PerformedProtocolCodeSequence",TagFromName.PerformedProtocolCodeSequence);
		tagByName.put("PerformedProtocolType",TagFromName.PerformedProtocolType);
		tagByName.put("ScheduledStepAttributesSequence",TagFromName.ScheduledStepAttributesSequence);
		tagByName.put("RequestAttributesSequence",TagFromName.RequestAttributesSequence);
		tagByName.put("CommentsOnThePerformedProcedureStep",TagFromName.CommentsOnThePerformedProcedureStep);
		tagByName.put("PerformedProcedureStepDiscontinuationReasonCodeSequence",TagFromName.PerformedProcedureStepDiscontinuationReasonCodeSequence);
		tagByName.put("QuantitySequence",TagFromName.QuantitySequence);
		tagByName.put("Quantity",TagFromName.Quantity);
		tagByName.put("MeasuringUnitsSequence",TagFromName.MeasuringUnitsSequence);
		tagByName.put("BillingItemSequence",TagFromName.BillingItemSequence);
		tagByName.put("TotalTimeOfFluoroscopy",TagFromName.TotalTimeOfFluoroscopy);
		tagByName.put("TotalNumberOfExposures",TagFromName.TotalNumberOfExposures);
		tagByName.put("EntranceDose",TagFromName.EntranceDose);
		tagByName.put("ExposedArea",TagFromName.ExposedArea);
		tagByName.put("DistanceSourceToEntrance",TagFromName.DistanceSourceToEntrance);
		tagByName.put("DistanceSourceToSupport",TagFromName.DistanceSourceToSupport);
		tagByName.put("ExposureDoseSequence",TagFromName.ExposureDoseSequence);
		tagByName.put("CommentsOnRadiationDose",TagFromName.CommentsOnRadiationDose);
		tagByName.put("XRayOutput",TagFromName.XRayOutput);
		tagByName.put("HalfValueLayer",TagFromName.HalfValueLayer);
		tagByName.put("OrganDose",TagFromName.OrganDose);
		tagByName.put("OrganExposed",TagFromName.OrganExposed);
		tagByName.put("BillingProcedureStepSequence",TagFromName.BillingProcedureStepSequence);
		tagByName.put("FilmConsumptionSequence",TagFromName.FilmConsumptionSequence);
		tagByName.put("BillingSuppliesAndDevicesSequence",TagFromName.BillingSuppliesAndDevicesSequence);
		tagByName.put("ReferencedProcedureStepSequence",TagFromName.ReferencedProcedureStepSequence);
		tagByName.put("PerformedSeriesSequence",TagFromName.PerformedSeriesSequence);
		tagByName.put("CommentsOnTheScheduledProcedureStep",TagFromName.CommentsOnTheScheduledProcedureStep);
		tagByName.put("ProtocolContextSequence",TagFromName.ProtocolContextSequence);
		tagByName.put("ContentItemModifierSequence",TagFromName.ContentItemModifierSequence);
		tagByName.put("ScheduledSpecimenSequence",TagFromName.ScheduledSpecimenSequence);
		tagByName.put("SpecimenAccessionNumber",TagFromName.SpecimenAccessionNumber);
		tagByName.put("ContainerIdentifier",TagFromName.ContainerIdentifier);
		tagByName.put("IssuerOfTheContainerIdentifierSequence",TagFromName.IssuerOfTheContainerIdentifierSequence);
		tagByName.put("AlternateContainerIdentifierSequence",TagFromName.AlternateContainerIdentifierSequence);
		tagByName.put("ContainerTypeCodeSequence",TagFromName.ContainerTypeCodeSequence);
		tagByName.put("ContainerDescription",TagFromName.ContainerDescription);
		tagByName.put("ContainerComponentSequence",TagFromName.ContainerComponentSequence);
		tagByName.put("SpecimenSequence",TagFromName.SpecimenSequence);
		tagByName.put("SpecimenIdentifier",TagFromName.SpecimenIdentifier);
		tagByName.put("SpecimenDescriptionSequenceTrial",TagFromName.SpecimenDescriptionSequenceTrial);
		tagByName.put("SpecimenDescriptionTrial",TagFromName.SpecimenDescriptionTrial);
		tagByName.put("SpecimenUID",TagFromName.SpecimenUID);
		tagByName.put("AcquisitionContextSequence",TagFromName.AcquisitionContextSequence);
		tagByName.put("AcquisitionContextDescription",TagFromName.AcquisitionContextDescription);
		tagByName.put("SpecimenDescriptionSequence",TagFromName.SpecimenDescriptionSequence);
		tagByName.put("IssuerOfTheSpecimenIdentifierSequence",TagFromName.IssuerOfTheSpecimenIdentifierSequence);
		tagByName.put("SpecimenTypeCodeSequence",TagFromName.SpecimenTypeCodeSequence);
		tagByName.put("SpecimenShortDescription",TagFromName.SpecimenShortDescription);
		tagByName.put("SpecimenDetailedDescription",TagFromName.SpecimenDetailedDescription);
		tagByName.put("SpecimenPreparationSequence",TagFromName.SpecimenPreparationSequence);
		tagByName.put("SpecimenPreparationStepContentItemSequence",TagFromName.SpecimenPreparationStepContentItemSequence);
		tagByName.put("SpecimenLocalizationContentItemSequence",TagFromName.SpecimenLocalizationContentItemSequence);
		tagByName.put("SlideIdentifier",TagFromName.SlideIdentifier);
		tagByName.put("ImageCenterPointCoordinatesSequence",TagFromName.ImageCenterPointCoordinatesSequence);
		tagByName.put("XOffsetInSlideCoordinateSystem",TagFromName.XOffsetInSlideCoordinateSystem);
		tagByName.put("YOffsetInSlideCoordinateSystem",TagFromName.YOffsetInSlideCoordinateSystem);
		tagByName.put("ZOffsetInSlideCoordinateSystem",TagFromName.ZOffsetInSlideCoordinateSystem);
		tagByName.put("PixelSpacingSequence",TagFromName.PixelSpacingSequence);
		tagByName.put("CoordinateSystemAxisCodeSequence",TagFromName.CoordinateSystemAxisCodeSequence);
		tagByName.put("MeasurementUnitsCodeSequence",TagFromName.MeasurementUnitsCodeSequence);
		tagByName.put("VitalStainCodeSequenceTrial",TagFromName.VitalStainCodeSequenceTrial);
		tagByName.put("RequestedProcedureID",TagFromName.RequestedProcedureID);
		tagByName.put("ReasonForTheRequestedProcedure",TagFromName.ReasonForTheRequestedProcedure);
		tagByName.put("RequestedProcedurePriority",TagFromName.RequestedProcedurePriority);
		tagByName.put("PatientTransportArrangements",TagFromName.PatientTransportArrangements);
		tagByName.put("RequestedProcedureLocation",TagFromName.RequestedProcedureLocation);
		tagByName.put("PlacerOrderNumberProcedure",TagFromName.PlacerOrderNumberProcedure);
		tagByName.put("FillerOrderNumberProcedure",TagFromName.FillerOrderNumberProcedure);
		tagByName.put("ConfidentialityCode",TagFromName.ConfidentialityCode);
		tagByName.put("ReportingPriority",TagFromName.ReportingPriority);
		tagByName.put("ReasonForRequestedProcedureCodeSequence",TagFromName.ReasonForRequestedProcedureCodeSequence);
		tagByName.put("NamesOfIntendedRecipientsOfResults",TagFromName.NamesOfIntendedRecipientsOfResults);
		tagByName.put("IntendedRecipientsOfResultsIdentificationSequence",TagFromName.IntendedRecipientsOfResultsIdentificationSequence);
		tagByName.put("ReasonForPerformedProcedureCodeSequence",TagFromName.ReasonForPerformedProcedureCodeSequence);
		tagByName.put("RequestedProcedureDescriptionTrial",TagFromName.RequestedProcedureDescriptionTrial);
		tagByName.put("PersonIdentificationCodeSequence",TagFromName.PersonIdentificationCodeSequence);
		tagByName.put("PersonAddress",TagFromName.PersonAddress);
		tagByName.put("PersonTelephoneNumbers",TagFromName.PersonTelephoneNumbers);
		tagByName.put("PersonTelecomInformation",TagFromName.PersonTelecomInformation);
		tagByName.put("RequestedProcedureComments",TagFromName.RequestedProcedureComments);
		tagByName.put("ReasonForTheImagingServiceRequest",TagFromName.ReasonForTheImagingServiceRequest);
		tagByName.put("IssueDateOfImagingServiceRequest",TagFromName.IssueDateOfImagingServiceRequest);
		tagByName.put("IssueTimeOfImagingServiceRequest",TagFromName.IssueTimeOfImagingServiceRequest);
		tagByName.put("PlacerOrderNumberImagingServiceRequestRetired",TagFromName.PlacerOrderNumberImagingServiceRequestRetired);
		tagByName.put("FillerOrderNumberImagingServiceRequestRetired",TagFromName.FillerOrderNumberImagingServiceRequestRetired);
		tagByName.put("OrderEnteredBy",TagFromName.OrderEnteredBy);
		tagByName.put("OrderEntererLocation",TagFromName.OrderEntererLocation);
		tagByName.put("OrderCallbackPhoneNumber",TagFromName.OrderCallbackPhoneNumber);
		tagByName.put("OrderCallbackTelecomInformation",TagFromName.OrderCallbackTelecomInformation);
		tagByName.put("PlacerOrderNumberImagingServiceRequest",TagFromName.PlacerOrderNumberImagingServiceRequest);
		tagByName.put("FillerOrderNumberImagingServiceRequest",TagFromName.FillerOrderNumberImagingServiceRequest);
		tagByName.put("ImagingServiceRequestComments",TagFromName.ImagingServiceRequestComments);
		tagByName.put("ConfidentialityConstraintOnPatientDataDescription",TagFromName.ConfidentialityConstraintOnPatientDataDescription);
		tagByName.put("GeneralPurposeScheduledProcedureStepStatus",TagFromName.GeneralPurposeScheduledProcedureStepStatus);
		tagByName.put("GeneralPurposePerformedProcedureStepStatus",TagFromName.GeneralPurposePerformedProcedureStepStatus);
		tagByName.put("GeneralPurposeScheduledProcedureStepPriority",TagFromName.GeneralPurposeScheduledProcedureStepPriority);
		tagByName.put("ScheduledProcessingApplicationsCodeSequence",TagFromName.ScheduledProcessingApplicationsCodeSequence);
		tagByName.put("ScheduledProcedureStepStartDateTime",TagFromName.ScheduledProcedureStepStartDateTime);
		tagByName.put("MultipleCopiesFlag",TagFromName.MultipleCopiesFlag);
		tagByName.put("PerformedProcessingApplicationsCodeSequence",TagFromName.PerformedProcessingApplicationsCodeSequence);
		tagByName.put("HumanPerformerCodeSequence",TagFromName.HumanPerformerCodeSequence);
		tagByName.put("ScheduledProcedureStepModificationDateTime",TagFromName.ScheduledProcedureStepModificationDateTime);
		tagByName.put("ExpectedCompletionDateTime",TagFromName.ExpectedCompletionDateTime);
		tagByName.put("ResultingGeneralPurposePerformedProcedureStepsSequence",TagFromName.ResultingGeneralPurposePerformedProcedureStepsSequence);
		tagByName.put("ReferencedGeneralPurposeScheduledProcedureStepSequence",TagFromName.ReferencedGeneralPurposeScheduledProcedureStepSequence);
		tagByName.put("ScheduledWorkitemCodeSequence",TagFromName.ScheduledWorkitemCodeSequence);
		tagByName.put("PerformedWorkitemCodeSequence",TagFromName.PerformedWorkitemCodeSequence);
		tagByName.put("InputAvailabilityFlag",TagFromName.InputAvailabilityFlag);
		tagByName.put("InputInformationSequence",TagFromName.InputInformationSequence);
		tagByName.put("RelevantInformationSequence",TagFromName.RelevantInformationSequence);
		tagByName.put("ReferencedGeneralPurposeScheduledProcedureStepTransactionUID",TagFromName.ReferencedGeneralPurposeScheduledProcedureStepTransactionUID);
		tagByName.put("ScheduledStationNameCodeSequence",TagFromName.ScheduledStationNameCodeSequence);
		tagByName.put("ScheduledStationClassCodeSequence",TagFromName.ScheduledStationClassCodeSequence);
		tagByName.put("ScheduledStationGeographicLocationCodeSequence",TagFromName.ScheduledStationGeographicLocationCodeSequence);
		tagByName.put("PerformedStationNameCodeSequence",TagFromName.PerformedStationNameCodeSequence);
		tagByName.put("PerformedStationClassCodeSequence",TagFromName.PerformedStationClassCodeSequence);
		tagByName.put("PerformedStationGeographicLocationCodeSequence",TagFromName.PerformedStationGeographicLocationCodeSequence);
		tagByName.put("RequestedSubsequentWorkitemCodeSequence",TagFromName.RequestedSubsequentWorkitemCodeSequence);
		tagByName.put("NonDICOMOutputCodeSequence",TagFromName.NonDICOMOutputCodeSequence);
		tagByName.put("OutputInformationSequence",TagFromName.OutputInformationSequence);
		tagByName.put("ScheduledHumanPerformersSequence",TagFromName.ScheduledHumanPerformersSequence);
		tagByName.put("ActualHumanPerformersSequence",TagFromName.ActualHumanPerformersSequence);
		tagByName.put("HumanPerformerOrganization",TagFromName.HumanPerformerOrganization);
		tagByName.put("HumanPerformerName",TagFromName.HumanPerformerName);
		tagByName.put("RawDataHandling",TagFromName.RawDataHandling);
		tagByName.put("InputReadinessState",TagFromName.InputReadinessState);
		tagByName.put("PerformedProcedureStepStartDateTime",TagFromName.PerformedProcedureStepStartDateTime);
		tagByName.put("PerformedProcedureStepEndDateTime",TagFromName.PerformedProcedureStepEndDateTime);
		tagByName.put("ProcedureStepCancellationDateTime",TagFromName.ProcedureStepCancellationDateTime);
		tagByName.put("OutputDestinationSequence",TagFromName.OutputDestinationSequence);
		tagByName.put("DICOMStorageSequence",TagFromName.DICOMStorageSequence);
		tagByName.put("STOWRSStorageSequence",TagFromName.STOWRSStorageSequence);
		tagByName.put("StorageURL",TagFromName.StorageURL);
		tagByName.put("XDSStorageSequence",TagFromName.XDSStorageSequence);
		tagByName.put("EntranceDoseInmGy",TagFromName.EntranceDoseInmGy);
		tagByName.put("ParametricMapFrameTypeSequence",TagFromName.ParametricMapFrameTypeSequence);
		tagByName.put("ReferencedImageRealWorldValueMappingSequence",TagFromName.ReferencedImageRealWorldValueMappingSequence);
		tagByName.put("RealWorldValueMappingSequence",TagFromName.RealWorldValueMappingSequence);
		tagByName.put("PixelValueMappingCodeSequence",TagFromName.PixelValueMappingCodeSequence);
		tagByName.put("LUTLabel",TagFromName.LUTLabel);
		tagByName.put("RealWorldValueLastValueMapped",TagFromName.RealWorldValueLastValueMapped);
		tagByName.put("RealWorldValueLUTData",TagFromName.RealWorldValueLUTData);
		tagByName.put("DoubleFloatRealWorldValueLastValueMapped",TagFromName.DoubleFloatRealWorldValueLastValueMapped);
		tagByName.put("DoubleFloatRealWorldValueFirstValueMapped",TagFromName.DoubleFloatRealWorldValueFirstValueMapped);
		tagByName.put("RealWorldValueFirstValueMapped",TagFromName.RealWorldValueFirstValueMapped);
		tagByName.put("QuantityDefinitionSequence",TagFromName.QuantityDefinitionSequence);
		tagByName.put("RealWorldValueIntercept",TagFromName.RealWorldValueIntercept);
		tagByName.put("RealWorldValueSlope",TagFromName.RealWorldValueSlope);
		tagByName.put("FindingsFlagTrial",TagFromName.FindingsFlagTrial);
		tagByName.put("RelationshipType",TagFromName.RelationshipType);
		tagByName.put("FindingsSequenceTrial",TagFromName.FindingsSequenceTrial);
		tagByName.put("FindingsGroupUIDTrial",TagFromName.FindingsGroupUIDTrial);
		tagByName.put("ReferencedFindingsGroupUIDTrial",TagFromName.ReferencedFindingsGroupUIDTrial);
		tagByName.put("FindingsGroupRecordingDateTrial",TagFromName.FindingsGroupRecordingDateTrial);
		tagByName.put("FindingsGroupRecordingTimeTrial",TagFromName.FindingsGroupRecordingTimeTrial);
		tagByName.put("FindingsSourceCategoryCodeSequenceTrial",TagFromName.FindingsSourceCategoryCodeSequenceTrial);
		tagByName.put("VerifyingOrganization",TagFromName.VerifyingOrganization);
		tagByName.put("DocumentingOrganizationIdentifierCodeSequenceTrial",TagFromName.DocumentingOrganizationIdentifierCodeSequenceTrial);
		tagByName.put("VerificationDateTime",TagFromName.VerificationDateTime);
		tagByName.put("ObservationDateTime",TagFromName.ObservationDateTime);
		tagByName.put("ValueType",TagFromName.ValueType);
		tagByName.put("ConceptNameCodeSequence",TagFromName.ConceptNameCodeSequence);
		tagByName.put("MeasurementPrecisionDescriptionTrial",TagFromName.MeasurementPrecisionDescriptionTrial);
		tagByName.put("ContinuityOfContent",TagFromName.ContinuityOfContent);
		tagByName.put("UrgencyOrPriorityAlertsTrial",TagFromName.UrgencyOrPriorityAlertsTrial);
		tagByName.put("SequencingIndicatorTrial",TagFromName.SequencingIndicatorTrial);
		tagByName.put("DocumentIdentifierCodeSequenceTrial",TagFromName.DocumentIdentifierCodeSequenceTrial);
		tagByName.put("DocumentAuthorTrial",TagFromName.DocumentAuthorTrial);
		tagByName.put("DocumentAuthorIdentifierCodeSequenceTrial",TagFromName.DocumentAuthorIdentifierCodeSequenceTrial);
		tagByName.put("IdentifierCodeSequenceTrial",TagFromName.IdentifierCodeSequenceTrial);
		tagByName.put("VerifyingObserverSequence",TagFromName.VerifyingObserverSequence);
		tagByName.put("ObjectBinaryIdentifierTrial",TagFromName.ObjectBinaryIdentifierTrial);
		tagByName.put("VerifyingObserverName",TagFromName.VerifyingObserverName);
		tagByName.put("DocumentingObserverIdentifierCodeSequenceTrial",TagFromName.DocumentingObserverIdentifierCodeSequenceTrial);
		tagByName.put("AuthorObserverSequence",TagFromName.AuthorObserverSequence);
		tagByName.put("ParticipantSequence",TagFromName.ParticipantSequence);
		tagByName.put("CustodialOrganizationSequence",TagFromName.CustodialOrganizationSequence);
		tagByName.put("ParticipationType",TagFromName.ParticipationType);
		tagByName.put("ParticipationDateTime",TagFromName.ParticipationDateTime);
		tagByName.put("ObserverType",TagFromName.ObserverType);
		tagByName.put("ProcedureIdentifierCodeSequenceTrial",TagFromName.ProcedureIdentifierCodeSequenceTrial);
		tagByName.put("VerifyingObserverIdentificationCodeSequence",TagFromName.VerifyingObserverIdentificationCodeSequence);
		tagByName.put("ObjectDirectoryBinaryIdentifierTrial",TagFromName.ObjectDirectoryBinaryIdentifierTrial);
		tagByName.put("EquivalentCDADocumentSequence",TagFromName.EquivalentCDADocumentSequence);
		tagByName.put("ReferencedWaveformChannels",TagFromName.ReferencedWaveformChannels);
		tagByName.put("DateOfDocumentOrVerbalTransactionTrial",TagFromName.DateOfDocumentOrVerbalTransactionTrial);
		tagByName.put("TimeOfDocumentCreationOrVerbalTransactionTrial",TagFromName.TimeOfDocumentCreationOrVerbalTransactionTrial);
		tagByName.put("DateTime",TagFromName.DateTime);
		tagByName.put("Date",TagFromName.Date);
		tagByName.put("Time",TagFromName.Time);
		tagByName.put("PersonName",TagFromName.PersonName);
		tagByName.put("UID",TagFromName.UID);
		tagByName.put("ReportStatusIDTrial",TagFromName.ReportStatusIDTrial);
		tagByName.put("TemporalRangeType",TagFromName.TemporalRangeType);
		tagByName.put("ReferencedSamplePositions",TagFromName.ReferencedSamplePositions);
		tagByName.put("ReferencedFrameNumbers",TagFromName.ReferencedFrameNumbers);
		tagByName.put("ReferencedTimeOffsets",TagFromName.ReferencedTimeOffsets);
		tagByName.put("ReferencedDateTime",TagFromName.ReferencedDateTime);
		tagByName.put("TextValue",TagFromName.TextValue);
		tagByName.put("FloatingPointValue",TagFromName.FloatingPointValue);
		tagByName.put("RationalNumeratorValue",TagFromName.RationalNumeratorValue);
		tagByName.put("RationalDenominatorValue",TagFromName.RationalDenominatorValue);
		tagByName.put("ObservationCategoryCodeSequenceTrial",TagFromName.ObservationCategoryCodeSequenceTrial);
		tagByName.put("ConceptCodeSequence",TagFromName.ConceptCodeSequence);
		tagByName.put("BibliographicCitationTrial",TagFromName.BibliographicCitationTrial);
		tagByName.put("PurposeOfReferenceCodeSequence",TagFromName.PurposeOfReferenceCodeSequence);
		tagByName.put("ObservationUID",TagFromName.ObservationUID);
		tagByName.put("ReferencedObservationUIDTrial",TagFromName.ReferencedObservationUIDTrial);
		tagByName.put("ReferencedObservationClassTrial",TagFromName.ReferencedObservationClassTrial);
		tagByName.put("ReferencedObjectObservationClassTrial",TagFromName.ReferencedObjectObservationClassTrial);
		tagByName.put("AnnotationGroupNumber",TagFromName.AnnotationGroupNumber);
		tagByName.put("ObservationDateTrial",TagFromName.ObservationDateTrial);
		tagByName.put("ObservationTimeTrial",TagFromName.ObservationTimeTrial);
		tagByName.put("MeasurementAutomationTrial",TagFromName.MeasurementAutomationTrial);
		tagByName.put("ModifierCodeSequence",TagFromName.ModifierCodeSequence);
		tagByName.put("IdentificationDescriptionTrial",TagFromName.IdentificationDescriptionTrial);
		tagByName.put("CoordinatesSetGeometricTypeTrial",TagFromName.CoordinatesSetGeometricTypeTrial);
		tagByName.put("AlgorithmCodeSequenceTrial",TagFromName.AlgorithmCodeSequenceTrial);
		tagByName.put("AlgorithmDescriptionTrial",TagFromName.AlgorithmDescriptionTrial);
		tagByName.put("PixelCoordinatesSetTrial",TagFromName.PixelCoordinatesSetTrial);
		tagByName.put("MeasuredValueSequence",TagFromName.MeasuredValueSequence);
		tagByName.put("NumericValueQualifierCodeSequence",TagFromName.NumericValueQualifierCodeSequence);
		tagByName.put("CurrentObserverTrial",TagFromName.CurrentObserverTrial);
		tagByName.put("NumericValue",TagFromName.NumericValue);
		tagByName.put("ReferencedAccessionSequenceTrial",TagFromName.ReferencedAccessionSequenceTrial);
		tagByName.put("ReportStatusCommentTrial",TagFromName.ReportStatusCommentTrial);
		tagByName.put("ProcedureContextSequenceTrial",TagFromName.ProcedureContextSequenceTrial);
		tagByName.put("VerbalSourceTrial",TagFromName.VerbalSourceTrial);
		tagByName.put("AddressTrial",TagFromName.AddressTrial);
		tagByName.put("TelephoneNumberTrial",TagFromName.TelephoneNumberTrial);
		tagByName.put("VerbalSourceIdentifierCodeSequenceTrial",TagFromName.VerbalSourceIdentifierCodeSequenceTrial);
		tagByName.put("PredecessorDocumentsSequence",TagFromName.PredecessorDocumentsSequence);
		tagByName.put("ReferencedRequestSequence",TagFromName.ReferencedRequestSequence);
		tagByName.put("PerformedProcedureCodeSequence",TagFromName.PerformedProcedureCodeSequence);
		tagByName.put("CurrentRequestedProcedureEvidenceSequence",TagFromName.CurrentRequestedProcedureEvidenceSequence);
		tagByName.put("ReportDetailSequenceTrial",TagFromName.ReportDetailSequenceTrial);
		tagByName.put("PertinentOtherEvidenceSequence",TagFromName.PertinentOtherEvidenceSequence);
		tagByName.put("HL7StructuredDocumentReferenceSequence",TagFromName.HL7StructuredDocumentReferenceSequence);
		tagByName.put("ObservationSubjectUIDTrial",TagFromName.ObservationSubjectUIDTrial);
		tagByName.put("ObservationSubjectClassTrial",TagFromName.ObservationSubjectClassTrial);
		tagByName.put("ObservationSubjectTypeCodeSequenceTrial",TagFromName.ObservationSubjectTypeCodeSequenceTrial);
		tagByName.put("CompletionFlag",TagFromName.CompletionFlag);
		tagByName.put("CompletionFlagDescription",TagFromName.CompletionFlagDescription);
		tagByName.put("VerificationFlag",TagFromName.VerificationFlag);
		tagByName.put("ArchiveRequested",TagFromName.ArchiveRequested);
		tagByName.put("PreliminaryFlag",TagFromName.PreliminaryFlag);
		tagByName.put("ContentTemplateSequence",TagFromName.ContentTemplateSequence);
		tagByName.put("IdenticalDocumentsSequence",TagFromName.IdenticalDocumentsSequence);
		tagByName.put("ObservationSubjectContextFlagTrial",TagFromName.ObservationSubjectContextFlagTrial);
		tagByName.put("ObserverContextFlagTrial",TagFromName.ObserverContextFlagTrial);
		tagByName.put("ProcedureContextFlagTrial",TagFromName.ProcedureContextFlagTrial);
		tagByName.put("ContentSequence",TagFromName.ContentSequence);
		tagByName.put("RelationshipSequenceTrial",TagFromName.RelationshipSequenceTrial);
		tagByName.put("RelationshipTypeCodeSequenceTrial",TagFromName.RelationshipTypeCodeSequenceTrial);
		tagByName.put("LanguageCodeSequenceTrial",TagFromName.LanguageCodeSequenceTrial);
		tagByName.put("UniformResourceLocatorTrial",TagFromName.UniformResourceLocatorTrial);
		tagByName.put("WaveformAnnotationSequence",TagFromName.WaveformAnnotationSequence);
		tagByName.put("TemplateIdentifier",TagFromName.TemplateIdentifier);
		tagByName.put("TemplateVersion",TagFromName.TemplateVersion);
		tagByName.put("TemplateLocalVersion",TagFromName.TemplateLocalVersion);
		tagByName.put("TemplateExtensionFlag",TagFromName.TemplateExtensionFlag);
		tagByName.put("TemplateExtensionOrganizationUID",TagFromName.TemplateExtensionOrganizationUID);
		tagByName.put("TemplateExtensionCreatorUID",TagFromName.TemplateExtensionCreatorUID);
		tagByName.put("ReferencedContentItemIdentifier",TagFromName.ReferencedContentItemIdentifier);
		tagByName.put("HL7InstanceIdentifier",TagFromName.HL7InstanceIdentifier);
		tagByName.put("HL7DocumentEffectiveTime",TagFromName.HL7DocumentEffectiveTime);
		tagByName.put("HL7DocumentTypeCodeSequence",TagFromName.HL7DocumentTypeCodeSequence);
		tagByName.put("DocumentClassCodeSequence",TagFromName.DocumentClassCodeSequence);
		tagByName.put("RetrieveURI",TagFromName.RetrieveURI);
		tagByName.put("RetrieveLocationUID",TagFromName.RetrieveLocationUID);
		tagByName.put("TypeOfInstances",TagFromName.TypeOfInstances);
		tagByName.put("DICOMRetrievalSequence",TagFromName.DICOMRetrievalSequence);
		tagByName.put("DICOMMediaRetrievalSequence",TagFromName.DICOMMediaRetrievalSequence);
		tagByName.put("WADORetrievalSequence",TagFromName.WADORetrievalSequence);
		tagByName.put("XDSRetrievalSequence",TagFromName.XDSRetrievalSequence);
		tagByName.put("WADORSRetrievalSequence",TagFromName.WADORSRetrievalSequence);
		tagByName.put("RepositoryUniqueID",TagFromName.RepositoryUniqueID);
		tagByName.put("HomeCommunityID",TagFromName.HomeCommunityID);
		tagByName.put("DocumentTitle",TagFromName.DocumentTitle);
		tagByName.put("EncapsulatedDocument",TagFromName.EncapsulatedDocument);
		tagByName.put("MIMETypeOfEncapsulatedDocument",TagFromName.MIMETypeOfEncapsulatedDocument);
		tagByName.put("SourceInstanceSequence",TagFromName.SourceInstanceSequence);
		tagByName.put("ListOfMIMETypes",TagFromName.ListOfMIMETypes);
		tagByName.put("ProductPackageIdentifier",TagFromName.ProductPackageIdentifier);
		tagByName.put("SubstanceAdministrationApproval",TagFromName.SubstanceAdministrationApproval);
		tagByName.put("ApprovalStatusFurtherDescription",TagFromName.ApprovalStatusFurtherDescription);
		tagByName.put("ApprovalStatusDateTime",TagFromName.ApprovalStatusDateTime);
		tagByName.put("ProductTypeCodeSequence",TagFromName.ProductTypeCodeSequence);
		tagByName.put("ProductName",TagFromName.ProductName);
		tagByName.put("ProductDescription",TagFromName.ProductDescription);
		tagByName.put("ProductLotIdentifier",TagFromName.ProductLotIdentifier);
		tagByName.put("ProductExpirationDateTime",TagFromName.ProductExpirationDateTime);
		tagByName.put("SubstanceAdministrationDateTime",TagFromName.SubstanceAdministrationDateTime);
		tagByName.put("SubstanceAdministrationNotes",TagFromName.SubstanceAdministrationNotes);
		tagByName.put("SubstanceAdministrationDeviceID",TagFromName.SubstanceAdministrationDeviceID);
		tagByName.put("ProductParameterSequence",TagFromName.ProductParameterSequence);
		tagByName.put("SubstanceAdministrationParameterSequence",TagFromName.SubstanceAdministrationParameterSequence);
		tagByName.put("LensDescription",TagFromName.LensDescription);
		tagByName.put("RightLensSequence",TagFromName.RightLensSequence);
		tagByName.put("LeftLensSequence",TagFromName.LeftLensSequence);
		tagByName.put("UnspecifiedLateralityLensSequence",TagFromName.UnspecifiedLateralityLensSequence);
		tagByName.put("CylinderSequence",TagFromName.CylinderSequence);
		tagByName.put("PrismSequence",TagFromName.PrismSequence);
		tagByName.put("HorizontalPrismPower",TagFromName.HorizontalPrismPower);
		tagByName.put("HorizontalPrismBase",TagFromName.HorizontalPrismBase);
		tagByName.put("VerticalPrismPower",TagFromName.VerticalPrismPower);
		tagByName.put("VerticalPrismBase",TagFromName.VerticalPrismBase);
		tagByName.put("LensSegmentType",TagFromName.LensSegmentType);
		tagByName.put("OpticalTransmittance",TagFromName.OpticalTransmittance);
		tagByName.put("ChannelWidth",TagFromName.ChannelWidth);
		tagByName.put("PupilSize",TagFromName.PupilSize);
		tagByName.put("CornealSize",TagFromName.CornealSize);
		tagByName.put("AutorefractionRightEyeSequence",TagFromName.AutorefractionRightEyeSequence);
		tagByName.put("AutorefractionLeftEyeSequence",TagFromName.AutorefractionLeftEyeSequence);
		tagByName.put("DistancePupillaryDistance",TagFromName.DistancePupillaryDistance);
		tagByName.put("NearPupillaryDistance",TagFromName.NearPupillaryDistance);
		tagByName.put("IntermediatePupillaryDistance",TagFromName.IntermediatePupillaryDistance);
		tagByName.put("OtherPupillaryDistance",TagFromName.OtherPupillaryDistance);
		tagByName.put("KeratometryRightEyeSequence",TagFromName.KeratometryRightEyeSequence);
		tagByName.put("KeratometryLeftEyeSequence",TagFromName.KeratometryLeftEyeSequence);
		tagByName.put("SteepKeratometricAxisSequence",TagFromName.SteepKeratometricAxisSequence);
		tagByName.put("RadiusOfCurvature",TagFromName.RadiusOfCurvature);
		tagByName.put("KeratometricPower",TagFromName.KeratometricPower);
		tagByName.put("KeratometricAxis",TagFromName.KeratometricAxis);
		tagByName.put("FlatKeratometricAxisSequence",TagFromName.FlatKeratometricAxisSequence);
		tagByName.put("BackgroundColor",TagFromName.BackgroundColor);
		tagByName.put("Optotype",TagFromName.Optotype);
		tagByName.put("OptotypePresentation",TagFromName.OptotypePresentation);
		tagByName.put("SubjectiveRefractionRightEyeSequence",TagFromName.SubjectiveRefractionRightEyeSequence);
		tagByName.put("SubjectiveRefractionLeftEyeSequence",TagFromName.SubjectiveRefractionLeftEyeSequence);
		tagByName.put("AddNearSequence",TagFromName.AddNearSequence);
		tagByName.put("AddIntermediateSequence",TagFromName.AddIntermediateSequence);
		tagByName.put("AddOtherSequence",TagFromName.AddOtherSequence);
		tagByName.put("AddPower",TagFromName.AddPower);
		tagByName.put("ViewingDistance",TagFromName.ViewingDistance);
		tagByName.put("VisualAcuityTypeCodeSequence",TagFromName.VisualAcuityTypeCodeSequence);
		tagByName.put("VisualAcuityRightEyeSequence",TagFromName.VisualAcuityRightEyeSequence);
		tagByName.put("VisualAcuityLeftEyeSequence",TagFromName.VisualAcuityLeftEyeSequence);
		tagByName.put("VisualAcuityBothEyesOpenSequence",TagFromName.VisualAcuityBothEyesOpenSequence);
		tagByName.put("ViewingDistanceType",TagFromName.ViewingDistanceType);
		tagByName.put("VisualAcuityModifiers",TagFromName.VisualAcuityModifiers);
		tagByName.put("DecimalVisualAcuity",TagFromName.DecimalVisualAcuity);
		tagByName.put("OptotypeDetailedDefinition",TagFromName.OptotypeDetailedDefinition);
		tagByName.put("ReferencedRefractiveMeasurementsSequence",TagFromName.ReferencedRefractiveMeasurementsSequence);
		tagByName.put("SpherePower",TagFromName.SpherePower);
		tagByName.put("CylinderPower",TagFromName.CylinderPower);
		tagByName.put("CornealTopographySurface",TagFromName.CornealTopographySurface);
		tagByName.put("CornealVertexLocation",TagFromName.CornealVertexLocation);
		tagByName.put("PupilCentroidXCoordinate",TagFromName.PupilCentroidXCoordinate);
		tagByName.put("PupilCentroidYCoordinate",TagFromName.PupilCentroidYCoordinate);
		tagByName.put("EquivalentPupilRadius",TagFromName.EquivalentPupilRadius);
		tagByName.put("CornealTopographyMapTypeCodeSequence",TagFromName.CornealTopographyMapTypeCodeSequence);
		tagByName.put("VerticesOfTheOutlineOfPupil",TagFromName.VerticesOfTheOutlineOfPupil);
		tagByName.put("CornealTopographyMappingNormalsSequence",TagFromName.CornealTopographyMappingNormalsSequence);
		tagByName.put("MaximumCornealCurvatureSequence",TagFromName.MaximumCornealCurvatureSequence);
		tagByName.put("MaximumCornealCurvature",TagFromName.MaximumCornealCurvature);
		tagByName.put("MaximumCornealCurvatureLocation",TagFromName.MaximumCornealCurvatureLocation);
		tagByName.put("MinimumKeratometricSequence",TagFromName.MinimumKeratometricSequence);
		tagByName.put("SimulatedKeratometricCylinderSequence",TagFromName.SimulatedKeratometricCylinderSequence);
		tagByName.put("AverageCornealPower",TagFromName.AverageCornealPower);
		tagByName.put("CornealISValue",TagFromName.CornealISValue);
		tagByName.put("AnalyzedArea",TagFromName.AnalyzedArea);
		tagByName.put("SurfaceRegularityIndex",TagFromName.SurfaceRegularityIndex);
		tagByName.put("SurfaceAsymmetryIndex",TagFromName.SurfaceAsymmetryIndex);
		tagByName.put("CornealEccentricityIndex",TagFromName.CornealEccentricityIndex);
		tagByName.put("KeratoconusPredictionIndex",TagFromName.KeratoconusPredictionIndex);
		tagByName.put("DecimalPotentialVisualAcuity",TagFromName.DecimalPotentialVisualAcuity);
		tagByName.put("CornealTopographyMapQualityEvaluation",TagFromName.CornealTopographyMapQualityEvaluation);
		tagByName.put("SourceImageCornealProcessedDataSequence",TagFromName.SourceImageCornealProcessedDataSequence);
		tagByName.put("CornealPointLocation",TagFromName.CornealPointLocation);
		tagByName.put("CornealPointEstimated",TagFromName.CornealPointEstimated);
		tagByName.put("AxialPower",TagFromName.AxialPower);
		tagByName.put("TangentialPower",TagFromName.TangentialPower);
		tagByName.put("RefractivePower",TagFromName.RefractivePower);
		tagByName.put("RelativeElevation",TagFromName.RelativeElevation);
		tagByName.put("CornealWavefront",TagFromName.CornealWavefront);
		tagByName.put("ImagedVolumeWidth",TagFromName.ImagedVolumeWidth);
		tagByName.put("ImagedVolumeHeight",TagFromName.ImagedVolumeHeight);
		tagByName.put("ImagedVolumeDepth",TagFromName.ImagedVolumeDepth);
		tagByName.put("TotalPixelMatrixColumns",TagFromName.TotalPixelMatrixColumns);
		tagByName.put("TotalPixelMatrixRows",TagFromName.TotalPixelMatrixRows);
		tagByName.put("TotalPixelMatrixOriginSequence",TagFromName.TotalPixelMatrixOriginSequence);
		tagByName.put("SpecimenLabelInImage",TagFromName.SpecimenLabelInImage);
		tagByName.put("FocusMethod",TagFromName.FocusMethod);
		tagByName.put("ExtendedDepthOfField",TagFromName.ExtendedDepthOfField);
		tagByName.put("NumberOfFocalPlanes",TagFromName.NumberOfFocalPlanes);
		tagByName.put("DistanceBetweenFocalPlanes",TagFromName.DistanceBetweenFocalPlanes);
		tagByName.put("RecommendedAbsentPixelCIELabValue",TagFromName.RecommendedAbsentPixelCIELabValue);
		tagByName.put("IlluminatorTypeCodeSequence",TagFromName.IlluminatorTypeCodeSequence);
		tagByName.put("ImageOrientationSlide",TagFromName.ImageOrientationSlide);
		tagByName.put("OpticalPathSequence",TagFromName.OpticalPathSequence);
		tagByName.put("OpticalPathIdentifier",TagFromName.OpticalPathIdentifier);
		tagByName.put("OpticalPathDescription",TagFromName.OpticalPathDescription);
		tagByName.put("IlluminationColorCodeSequence",TagFromName.IlluminationColorCodeSequence);
		tagByName.put("SpecimenReferenceSequence",TagFromName.SpecimenReferenceSequence);
		tagByName.put("CondenserLensPower",TagFromName.CondenserLensPower);
		tagByName.put("ObjectiveLensPower",TagFromName.ObjectiveLensPower);
		tagByName.put("ObjectiveLensNumericalAperture",TagFromName.ObjectiveLensNumericalAperture);
		tagByName.put("PaletteColorLookupTableSequence",TagFromName.PaletteColorLookupTableSequence);
		tagByName.put("ReferencedImageNavigationSequence",TagFromName.ReferencedImageNavigationSequence);
		tagByName.put("TopLeftHandCornerOfLocalizerArea",TagFromName.TopLeftHandCornerOfLocalizerArea);
		tagByName.put("BottomRightHandCornerOfLocalizerArea",TagFromName.BottomRightHandCornerOfLocalizerArea);
		tagByName.put("OpticalPathIdentificationSequence",TagFromName.OpticalPathIdentificationSequence);
		tagByName.put("PlanePositionSlideSequence",TagFromName.PlanePositionSlideSequence);
		tagByName.put("ColumnPositionInTotalImagePixelMatrix",TagFromName.ColumnPositionInTotalImagePixelMatrix);
		tagByName.put("RowPositionInTotalImagePixelMatrix",TagFromName.RowPositionInTotalImagePixelMatrix);
		tagByName.put("PixelOriginInterpretation",TagFromName.PixelOriginInterpretation);
		tagByName.put("CalibrationImage",TagFromName.CalibrationImage);
		tagByName.put("DeviceSequence",TagFromName.DeviceSequence);
		tagByName.put("ContainerComponentTypeCodeSequence",TagFromName.ContainerComponentTypeCodeSequence);
		tagByName.put("ContainerComponentThickness",TagFromName.ContainerComponentThickness);
		tagByName.put("DeviceLength",TagFromName.DeviceLength);
		tagByName.put("ContainerComponentWidth",TagFromName.ContainerComponentWidth);
		tagByName.put("DeviceDiameter",TagFromName.DeviceDiameter);
		tagByName.put("DeviceDiameterUnits",TagFromName.DeviceDiameterUnits);
		tagByName.put("DeviceVolume",TagFromName.DeviceVolume);
		tagByName.put("InterMarkerDistance",TagFromName.InterMarkerDistance);
		tagByName.put("ContainerComponentMaterial",TagFromName.ContainerComponentMaterial);
		tagByName.put("ContainerComponentID",TagFromName.ContainerComponentID);
		tagByName.put("ContainerComponentLength",TagFromName.ContainerComponentLength);
		tagByName.put("ContainerComponentDiameter",TagFromName.ContainerComponentDiameter);
		tagByName.put("ContainerComponentDescription",TagFromName.ContainerComponentDescription);
		tagByName.put("DeviceDescription",TagFromName.DeviceDescription);
		tagByName.put("ContrastBolusIngredientPercentByVolume",TagFromName.ContrastBolusIngredientPercentByVolume);
		tagByName.put("OCTFocalDistance",TagFromName.OCTFocalDistance);
		tagByName.put("BeamSpotSize",TagFromName.BeamSpotSize);
		tagByName.put("EffectiveRefractiveIndex",TagFromName.EffectiveRefractiveIndex);
		tagByName.put("OCTAcquisitionDomain",TagFromName.OCTAcquisitionDomain);
		tagByName.put("OCTOpticalCenterWavelength",TagFromName.OCTOpticalCenterWavelength);
		tagByName.put("AxialResolution",TagFromName.AxialResolution);
		tagByName.put("RangingDepth",TagFromName.RangingDepth);
		tagByName.put("ALineRate",TagFromName.ALineRate);
		tagByName.put("ALinesPerFrame",TagFromName.ALinesPerFrame);
		tagByName.put("CatheterRotationalRate",TagFromName.CatheterRotationalRate);
		tagByName.put("ALinePixelSpacing",TagFromName.ALinePixelSpacing);
		tagByName.put("ModeOfPercutaneousAccessSequence",TagFromName.ModeOfPercutaneousAccessSequence);
		tagByName.put("IntravascularOCTFrameTypeSequence",TagFromName.IntravascularOCTFrameTypeSequence);
		tagByName.put("OCTZOffsetApplied",TagFromName.OCTZOffsetApplied);
		tagByName.put("IntravascularFrameContentSequence",TagFromName.IntravascularFrameContentSequence);
		tagByName.put("IntravascularLongitudinalDistance",TagFromName.IntravascularLongitudinalDistance);
		tagByName.put("IntravascularOCTFrameContentSequence",TagFromName.IntravascularOCTFrameContentSequence);
		tagByName.put("OCTZOffsetCorrection",TagFromName.OCTZOffsetCorrection);
		tagByName.put("CatheterDirectionOfRotation",TagFromName.CatheterDirectionOfRotation);
		tagByName.put("SeamLineLocation",TagFromName.SeamLineLocation);
		tagByName.put("FirstALineLocation",TagFromName.FirstALineLocation);
		tagByName.put("SeamLineIndex",TagFromName.SeamLineIndex);
		tagByName.put("NumberOfPaddedALines",TagFromName.NumberOfPaddedALines);
		tagByName.put("InterpolationType",TagFromName.InterpolationType);
		tagByName.put("RefractiveIndexApplied",TagFromName.RefractiveIndexApplied);
		tagByName.put("EnergyWindowVector",TagFromName.EnergyWindowVector);
		tagByName.put("NumberOfEnergyWindows",TagFromName.NumberOfEnergyWindows);
		tagByName.put("EnergyWindowInformationSequence",TagFromName.EnergyWindowInformationSequence);
		tagByName.put("EnergyWindowRangeSequence",TagFromName.EnergyWindowRangeSequence);
		tagByName.put("EnergyWindowLowerLimit",TagFromName.EnergyWindowLowerLimit);
		tagByName.put("EnergyWindowUpperLimit",TagFromName.EnergyWindowUpperLimit);
		tagByName.put("RadiopharmaceuticalInformationSequence",TagFromName.RadiopharmaceuticalInformationSequence);
		tagByName.put("ResidualSyringeCounts",TagFromName.ResidualSyringeCounts);
		tagByName.put("EnergyWindowName",TagFromName.EnergyWindowName);
		tagByName.put("DetectorVector",TagFromName.DetectorVector);
		tagByName.put("NumberOfDetectors",TagFromName.NumberOfDetectors);
		tagByName.put("DetectorInformationSequence",TagFromName.DetectorInformationSequence);
		tagByName.put("PhaseVector",TagFromName.PhaseVector);
		tagByName.put("NumberOfPhases",TagFromName.NumberOfPhases);
		tagByName.put("PhaseInformationSequence",TagFromName.PhaseInformationSequence);
		tagByName.put("NumberOfFramesInPhase",TagFromName.NumberOfFramesInPhase);
		tagByName.put("PhaseDelay",TagFromName.PhaseDelay);
		tagByName.put("PauseBetweenFrames",TagFromName.PauseBetweenFrames);
		tagByName.put("PhaseDescription",TagFromName.PhaseDescription);
		tagByName.put("RotationVector",TagFromName.RotationVector);
		tagByName.put("NumberOfRotations",TagFromName.NumberOfRotations);
		tagByName.put("RotationInformationSequence",TagFromName.RotationInformationSequence);
		tagByName.put("NumberOfFramesInRotation",TagFromName.NumberOfFramesInRotation);
		tagByName.put("RRIntervalVector",TagFromName.RRIntervalVector);
		tagByName.put("NumberOfRRIntervals",TagFromName.NumberOfRRIntervals);
		tagByName.put("GatedInformationSequence",TagFromName.GatedInformationSequence);
		tagByName.put("DataInformationSequence",TagFromName.DataInformationSequence);
		tagByName.put("TimeSlotVector",TagFromName.TimeSlotVector);
		tagByName.put("NumberOfTimeSlots",TagFromName.NumberOfTimeSlots);
		tagByName.put("TimeSlotInformationSequence",TagFromName.TimeSlotInformationSequence);
		tagByName.put("TimeSlotTime",TagFromName.TimeSlotTime);
		tagByName.put("SliceVector",TagFromName.SliceVector);
		tagByName.put("NumberOfSlices",TagFromName.NumberOfSlices);
		tagByName.put("AngularViewVector",TagFromName.AngularViewVector);
		tagByName.put("TimeSliceVector",TagFromName.TimeSliceVector);
		tagByName.put("NumberOfTimeSlices",TagFromName.NumberOfTimeSlices);
		tagByName.put("StartAngle",TagFromName.StartAngle);
		tagByName.put("TypeOfDetectorMotion",TagFromName.TypeOfDetectorMotion);
		tagByName.put("TriggerVector",TagFromName.TriggerVector);
		tagByName.put("NumberOfTriggersInPhase",TagFromName.NumberOfTriggersInPhase);
		tagByName.put("ViewCodeSequence",TagFromName.ViewCodeSequence);
		tagByName.put("ViewModifierCodeSequence",TagFromName.ViewModifierCodeSequence);
		tagByName.put("RadionuclideCodeSequence",TagFromName.RadionuclideCodeSequence);
		tagByName.put("AdministrationRouteCodeSequence",TagFromName.AdministrationRouteCodeSequence);
		tagByName.put("RadiopharmaceuticalCodeSequence",TagFromName.RadiopharmaceuticalCodeSequence);
		tagByName.put("CalibrationDataSequence",TagFromName.CalibrationDataSequence);
		tagByName.put("EnergyWindowNumber",TagFromName.EnergyWindowNumber);
		tagByName.put("ImageID",TagFromName.ImageID);
		tagByName.put("PatientOrientationCodeSequence",TagFromName.PatientOrientationCodeSequence);
		tagByName.put("PatientOrientationModifierCodeSequence",TagFromName.PatientOrientationModifierCodeSequence);
		tagByName.put("PatientGantryRelationshipCodeSequence",TagFromName.PatientGantryRelationshipCodeSequence);
		tagByName.put("SliceProgressionDirection",TagFromName.SliceProgressionDirection);
		tagByName.put("ScanProgressionDirection",TagFromName.ScanProgressionDirection);
		tagByName.put("SeriesType",TagFromName.SeriesType);
		tagByName.put("Units",TagFromName.Units);
		tagByName.put("CountsSource",TagFromName.CountsSource);
		tagByName.put("ReprojectionMethod",TagFromName.ReprojectionMethod);
		tagByName.put("SUVType",TagFromName.SUVType);
		tagByName.put("RandomsCorrectionMethod",TagFromName.RandomsCorrectionMethod);
		tagByName.put("AttenuationCorrectionMethod",TagFromName.AttenuationCorrectionMethod);
		tagByName.put("DecayCorrection",TagFromName.DecayCorrection);
		tagByName.put("ReconstructionMethod",TagFromName.ReconstructionMethod);
		tagByName.put("DetectorLinesOfResponseUsed",TagFromName.DetectorLinesOfResponseUsed);
		tagByName.put("ScatterCorrectionMethod",TagFromName.ScatterCorrectionMethod);
		tagByName.put("AxialAcceptance",TagFromName.AxialAcceptance);
		tagByName.put("AxialMash",TagFromName.AxialMash);
		tagByName.put("TransverseMash",TagFromName.TransverseMash);
		tagByName.put("DetectorElementSize",TagFromName.DetectorElementSize);
		tagByName.put("CoincidenceWindowWidth",TagFromName.CoincidenceWindowWidth);
		tagByName.put("SecondaryCountsType",TagFromName.SecondaryCountsType);
		tagByName.put("FrameReferenceTime",TagFromName.FrameReferenceTime);
		tagByName.put("PrimaryPromptsCountsAccumulated",TagFromName.PrimaryPromptsCountsAccumulated);
		tagByName.put("SecondaryCountsAccumulated",TagFromName.SecondaryCountsAccumulated);
		tagByName.put("SliceSensitivityFactor",TagFromName.SliceSensitivityFactor);
		tagByName.put("DecayFactor",TagFromName.DecayFactor);
		tagByName.put("DoseCalibrationFactor",TagFromName.DoseCalibrationFactor);
		tagByName.put("ScatterFractionFactor",TagFromName.ScatterFractionFactor);
		tagByName.put("DeadTimeFactor",TagFromName.DeadTimeFactor);
		tagByName.put("ImageIndex",TagFromName.ImageIndex);
		tagByName.put("CountsIncluded",TagFromName.CountsIncluded);
		tagByName.put("DeadTimeCorrectionFlag",TagFromName.DeadTimeCorrectionFlag);
		tagByName.put("HistogramSequence",TagFromName.HistogramSequence);
		tagByName.put("HistogramNumberOfBins",TagFromName.HistogramNumberOfBins);
		tagByName.put("HistogramFirstBinValue",TagFromName.HistogramFirstBinValue);
		tagByName.put("HistogramLastBinValue",TagFromName.HistogramLastBinValue);
		tagByName.put("HistogramBinWidth",TagFromName.HistogramBinWidth);
		tagByName.put("HistogramExplanation",TagFromName.HistogramExplanation);
		tagByName.put("HistogramData",TagFromName.HistogramData);
		tagByName.put("SegmentationType",TagFromName.SegmentationType);
		tagByName.put("SegmentSequence",TagFromName.SegmentSequence);
		tagByName.put("SegmentedPropertyCategoryCodeSequence",TagFromName.SegmentedPropertyCategoryCodeSequence);
		tagByName.put("SegmentNumber",TagFromName.SegmentNumber);
		tagByName.put("SegmentLabel",TagFromName.SegmentLabel);
		tagByName.put("SegmentDescription",TagFromName.SegmentDescription);
		tagByName.put("SegmentAlgorithmType",TagFromName.SegmentAlgorithmType);
		tagByName.put("SegmentAlgorithmName",TagFromName.SegmentAlgorithmName);
		tagByName.put("SegmentIdentificationSequence",TagFromName.SegmentIdentificationSequence);
		tagByName.put("ReferencedSegmentNumber",TagFromName.ReferencedSegmentNumber);
		tagByName.put("RecommendedDisplayGrayscaleValue",TagFromName.RecommendedDisplayGrayscaleValue);
		tagByName.put("RecommendedDisplayCIELabValue",TagFromName.RecommendedDisplayCIELabValue);
		tagByName.put("MaximumFractionalValue",TagFromName.MaximumFractionalValue);
		tagByName.put("SegmentedPropertyTypeCodeSequence",TagFromName.SegmentedPropertyTypeCodeSequence);
		tagByName.put("SegmentationFractionalType",TagFromName.SegmentationFractionalType);
		tagByName.put("SegmentedPropertyTypeModifierCodeSequence",TagFromName.SegmentedPropertyTypeModifierCodeSequence);
		tagByName.put("UsedSegmentsSequence",TagFromName.UsedSegmentsSequence);
		tagByName.put("DeformableRegistrationSequence",TagFromName.DeformableRegistrationSequence);
		tagByName.put("SourceFrameOfReferenceUID",TagFromName.SourceFrameOfReferenceUID);
		tagByName.put("DeformableRegistrationGridSequence",TagFromName.DeformableRegistrationGridSequence);
		tagByName.put("GridDimensions",TagFromName.GridDimensions);
		tagByName.put("GridResolution",TagFromName.GridResolution);
		tagByName.put("VectorGridData",TagFromName.VectorGridData);
		tagByName.put("PreDeformationMatrixRegistrationSequence",TagFromName.PreDeformationMatrixRegistrationSequence);
		tagByName.put("PostDeformationMatrixRegistrationSequence",TagFromName.PostDeformationMatrixRegistrationSequence);
		tagByName.put("NumberOfSurfaces",TagFromName.NumberOfSurfaces);
		tagByName.put("SurfaceSequence",TagFromName.SurfaceSequence);
		tagByName.put("SurfaceNumber",TagFromName.SurfaceNumber);
		tagByName.put("SurfaceComments",TagFromName.SurfaceComments);
		tagByName.put("SurfaceProcessing",TagFromName.SurfaceProcessing);
		tagByName.put("SurfaceProcessingRatio",TagFromName.SurfaceProcessingRatio);
		tagByName.put("SurfaceProcessingDescription",TagFromName.SurfaceProcessingDescription);
		tagByName.put("RecommendedPresentationOpacity",TagFromName.RecommendedPresentationOpacity);
		tagByName.put("RecommendedPresentationType",TagFromName.RecommendedPresentationType);
		tagByName.put("FiniteVolume",TagFromName.FiniteVolume);
		tagByName.put("Manifold",TagFromName.Manifold);
		tagByName.put("SurfacePointsSequence",TagFromName.SurfacePointsSequence);
		tagByName.put("SurfacePointsNormalsSequence",TagFromName.SurfacePointsNormalsSequence);
		tagByName.put("SurfaceMeshPrimitivesSequence",TagFromName.SurfaceMeshPrimitivesSequence);
		tagByName.put("NumberOfSurfacePoints",TagFromName.NumberOfSurfacePoints);
		tagByName.put("PointCoordinatesData",TagFromName.PointCoordinatesData);
		tagByName.put("PointPositionAccuracy",TagFromName.PointPositionAccuracy);
		tagByName.put("MeanPointDistance",TagFromName.MeanPointDistance);
		tagByName.put("MaximumPointDistance",TagFromName.MaximumPointDistance);
		tagByName.put("PointsBoundingBoxCoordinates",TagFromName.PointsBoundingBoxCoordinates);
		tagByName.put("AxisOfRotation",TagFromName.AxisOfRotation);
		tagByName.put("CenterOfRotation",TagFromName.CenterOfRotation);
		tagByName.put("NumberOfVectors",TagFromName.NumberOfVectors);
		tagByName.put("VectorDimensionality",TagFromName.VectorDimensionality);
		tagByName.put("VectorAccuracy",TagFromName.VectorAccuracy);
		tagByName.put("VectorCoordinateData",TagFromName.VectorCoordinateData);
		tagByName.put("TrianglePointIndexList",TagFromName.TrianglePointIndexList);
		tagByName.put("EdgePointIndexList",TagFromName.EdgePointIndexList);
		tagByName.put("VertexPointIndexList",TagFromName.VertexPointIndexList);
		tagByName.put("TriangleStripSequence",TagFromName.TriangleStripSequence);
		tagByName.put("TriangleFanSequence",TagFromName.TriangleFanSequence);
		tagByName.put("LineSequence",TagFromName.LineSequence);
		tagByName.put("PrimitivePointIndexList",TagFromName.PrimitivePointIndexList);
		tagByName.put("SurfaceCount",TagFromName.SurfaceCount);
		tagByName.put("ReferencedSurfaceSequence",TagFromName.ReferencedSurfaceSequence);
		tagByName.put("ReferencedSurfaceNumber",TagFromName.ReferencedSurfaceNumber);
		tagByName.put("SegmentSurfaceGenerationAlgorithmIdentificationSequence",TagFromName.SegmentSurfaceGenerationAlgorithmIdentificationSequence);
		tagByName.put("SegmentSurfaceSourceInstanceSequence",TagFromName.SegmentSurfaceSourceInstanceSequence);
		tagByName.put("AlgorithmFamilyCodeSequence",TagFromName.AlgorithmFamilyCodeSequence);
		tagByName.put("AlgorithmNameCodeSequence",TagFromName.AlgorithmNameCodeSequence);
		tagByName.put("AlgorithmVersion",TagFromName.AlgorithmVersion);
		tagByName.put("AlgorithmParameters",TagFromName.AlgorithmParameters);
		tagByName.put("FacetSequence",TagFromName.FacetSequence);
		tagByName.put("SurfaceProcessingAlgorithmIdentificationSequence",TagFromName.SurfaceProcessingAlgorithmIdentificationSequence);
		tagByName.put("AlgorithmName",TagFromName.AlgorithmName);
		tagByName.put("RecommendedPointRadius",TagFromName.RecommendedPointRadius);
		tagByName.put("RecommendedLineThickness",TagFromName.RecommendedLineThickness);
		tagByName.put("TrackSetSequence",TagFromName.TrackSetSequence);
		tagByName.put("TrackSequence",TagFromName.TrackSequence);
		tagByName.put("RecommendedDisplayCIELabValueList",TagFromName.RecommendedDisplayCIELabValueList);
		tagByName.put("TrackingAlgorithmIdentificationSequence",TagFromName.TrackingAlgorithmIdentificationSequence);
		tagByName.put("TrackSetNumber",TagFromName.TrackSetNumber);
		tagByName.put("TrackSetLabel",TagFromName.TrackSetLabel);
		tagByName.put("TrackSetDescription",TagFromName.TrackSetDescription);
		tagByName.put("TrackSetAnatomicalTypeCodeSequence",TagFromName.TrackSetAnatomicalTypeCodeSequence);
		tagByName.put("MeasurementsSequence",TagFromName.MeasurementsSequence);
		tagByName.put("TrackSetStatisticsSequence",TagFromName.TrackSetStatisticsSequence);
		tagByName.put("FloatingPointValues",TagFromName.FloatingPointValues);
		tagByName.put("TrackPointIndexList",TagFromName.TrackPointIndexList);
		tagByName.put("TrackStatisticsSequence",TagFromName.TrackStatisticsSequence);
		tagByName.put("MeasurementValuesSequence",TagFromName.MeasurementValuesSequence);
		tagByName.put("DiffusionAcquisitionCodeSequence",TagFromName.DiffusionAcquisitionCodeSequence);
		tagByName.put("ImplantSize",TagFromName.ImplantSize);
		tagByName.put("ImplantTemplateVersion",TagFromName.ImplantTemplateVersion);
		tagByName.put("ReplacedImplantTemplateSequence",TagFromName.ReplacedImplantTemplateSequence);
		tagByName.put("ImplantType",TagFromName.ImplantType);
		tagByName.put("DerivationImplantTemplateSequence",TagFromName.DerivationImplantTemplateSequence);
		tagByName.put("OriginalImplantTemplateSequence",TagFromName.OriginalImplantTemplateSequence);
		tagByName.put("EffectiveDateTime",TagFromName.EffectiveDateTime);
		tagByName.put("ImplantTargetAnatomySequence",TagFromName.ImplantTargetAnatomySequence);
		tagByName.put("InformationFromManufacturerSequence",TagFromName.InformationFromManufacturerSequence);
		tagByName.put("NotificationFromManufacturerSequence",TagFromName.NotificationFromManufacturerSequence);
		tagByName.put("InformationIssueDateTime",TagFromName.InformationIssueDateTime);
		tagByName.put("InformationSummary",TagFromName.InformationSummary);
		tagByName.put("ImplantRegulatoryDisapprovalCodeSequence",TagFromName.ImplantRegulatoryDisapprovalCodeSequence);
		tagByName.put("OverallTemplateSpatialTolerance",TagFromName.OverallTemplateSpatialTolerance);
		tagByName.put("HPGLDocumentSequence",TagFromName.HPGLDocumentSequence);
		tagByName.put("HPGLDocumentID",TagFromName.HPGLDocumentID);
		tagByName.put("HPGLDocumentLabel",TagFromName.HPGLDocumentLabel);
		tagByName.put("ViewOrientationCodeSequence",TagFromName.ViewOrientationCodeSequence);
		tagByName.put("ViewOrientationModifier",TagFromName.ViewOrientationModifier);
		tagByName.put("HPGLDocumentScaling",TagFromName.HPGLDocumentScaling);
		tagByName.put("HPGLDocument",TagFromName.HPGLDocument);
		tagByName.put("HPGLContourPenNumber",TagFromName.HPGLContourPenNumber);
		tagByName.put("HPGLPenSequence",TagFromName.HPGLPenSequence);
		tagByName.put("HPGLPenNumber",TagFromName.HPGLPenNumber);
		tagByName.put("HPGLPenLabel",TagFromName.HPGLPenLabel);
		tagByName.put("HPGLPenDescription",TagFromName.HPGLPenDescription);
		tagByName.put("RecommendedRotationPoint",TagFromName.RecommendedRotationPoint);
		tagByName.put("BoundingRectangle",TagFromName.BoundingRectangle);
		tagByName.put("ImplantTemplate3DModelSurfaceNumber",TagFromName.ImplantTemplate3DModelSurfaceNumber);
		tagByName.put("SurfaceModelDescriptionSequence",TagFromName.SurfaceModelDescriptionSequence);
		tagByName.put("SurfaceModelLabel",TagFromName.SurfaceModelLabel);
		tagByName.put("SurfaceModelScalingFactor",TagFromName.SurfaceModelScalingFactor);
		tagByName.put("MaterialsCodeSequence",TagFromName.MaterialsCodeSequence);
		tagByName.put("CoatingMaterialsCodeSequence",TagFromName.CoatingMaterialsCodeSequence);
		tagByName.put("ImplantTypeCodeSequence",TagFromName.ImplantTypeCodeSequence);
		tagByName.put("FixationMethodCodeSequence",TagFromName.FixationMethodCodeSequence);
		tagByName.put("MatingFeatureSetsSequence",TagFromName.MatingFeatureSetsSequence);
		tagByName.put("MatingFeatureSetID",TagFromName.MatingFeatureSetID);
		tagByName.put("MatingFeatureSetLabel",TagFromName.MatingFeatureSetLabel);
		tagByName.put("MatingFeatureSequence",TagFromName.MatingFeatureSequence);
		tagByName.put("MatingFeatureID",TagFromName.MatingFeatureID);
		tagByName.put("MatingFeatureDegreeOfFreedomSequence",TagFromName.MatingFeatureDegreeOfFreedomSequence);
		tagByName.put("DegreeOfFreedomID",TagFromName.DegreeOfFreedomID);
		tagByName.put("DegreeOfFreedomType",TagFromName.DegreeOfFreedomType);
		tagByName.put("TwoDMatingFeatureCoordinatesSequence",TagFromName.TwoDMatingFeatureCoordinatesSequence);
		tagByName.put("ReferencedHPGLDocumentID",TagFromName.ReferencedHPGLDocumentID);
		tagByName.put("TwoDMatingPoint",TagFromName.TwoDMatingPoint);
		tagByName.put("TwoDMatingAxes",TagFromName.TwoDMatingAxes);
		tagByName.put("TwoDDegreeOfFreedomSequence",TagFromName.TwoDDegreeOfFreedomSequence);
		tagByName.put("ThreeDDegreeOfFreedomAxis",TagFromName.ThreeDDegreeOfFreedomAxis);
		tagByName.put("RangeOfFreedom",TagFromName.RangeOfFreedom);
		tagByName.put("ThreeDMatingPoint",TagFromName.ThreeDMatingPoint);
		tagByName.put("ThreeDMatingAxes",TagFromName.ThreeDMatingAxes);
		tagByName.put("TwoDDegreeOfFreedomAxis",TagFromName.TwoDDegreeOfFreedomAxis);
		tagByName.put("PlanningLandmarkPointSequence",TagFromName.PlanningLandmarkPointSequence);
		tagByName.put("PlanningLandmarkLineSequence",TagFromName.PlanningLandmarkLineSequence);
		tagByName.put("PlanningLandmarkPlaneSequence",TagFromName.PlanningLandmarkPlaneSequence);
		tagByName.put("PlanningLandmarkID",TagFromName.PlanningLandmarkID);
		tagByName.put("PlanningLandmarkDescription",TagFromName.PlanningLandmarkDescription);
		tagByName.put("PlanningLandmarkIdentificationCodeSequence",TagFromName.PlanningLandmarkIdentificationCodeSequence);
		tagByName.put("TwoDPointCoordinatesSequence",TagFromName.TwoDPointCoordinatesSequence);
		tagByName.put("TwoDPointCoordinates",TagFromName.TwoDPointCoordinates);
		tagByName.put("ThreeDPointCoordinates",TagFromName.ThreeDPointCoordinates);
		tagByName.put("TwoDLineCoordinatesSequence",TagFromName.TwoDLineCoordinatesSequence);
		tagByName.put("TwoDLineCoordinates",TagFromName.TwoDLineCoordinates);
		tagByName.put("ThreeDLineCoordinates",TagFromName.ThreeDLineCoordinates);
		tagByName.put("TwoDPlaneCoordinatesSequence",TagFromName.TwoDPlaneCoordinatesSequence);
		tagByName.put("TwoDPlaneIntersection",TagFromName.TwoDPlaneIntersection);
		tagByName.put("ThreeDPlaneOrigin",TagFromName.ThreeDPlaneOrigin);
		tagByName.put("ThreeDPlaneNormal",TagFromName.ThreeDPlaneNormal);
		tagByName.put("GraphicAnnotationSequence",TagFromName.GraphicAnnotationSequence);
		tagByName.put("GraphicLayer",TagFromName.GraphicLayer);
		tagByName.put("BoundingBoxAnnotationUnits",TagFromName.BoundingBoxAnnotationUnits);
		tagByName.put("AnchorPointAnnotationUnits",TagFromName.AnchorPointAnnotationUnits);
		tagByName.put("GraphicAnnotationUnits",TagFromName.GraphicAnnotationUnits);
		tagByName.put("UnformattedTextValue",TagFromName.UnformattedTextValue);
		tagByName.put("TextObjectSequence",TagFromName.TextObjectSequence);
		tagByName.put("GraphicObjectSequence",TagFromName.GraphicObjectSequence);
		tagByName.put("BoundingBoxTopLeftHandCorner",TagFromName.BoundingBoxTopLeftHandCorner);
		tagByName.put("BoundingBoxBottomRightHandCorner",TagFromName.BoundingBoxBottomRightHandCorner);
		tagByName.put("BoundingBoxTextHorizontalJustification",TagFromName.BoundingBoxTextHorizontalJustification);
		tagByName.put("AnchorPoint",TagFromName.AnchorPoint);
		tagByName.put("AnchorPointVisibility",TagFromName.AnchorPointVisibility);
		tagByName.put("GraphicDimensions",TagFromName.GraphicDimensions);
		tagByName.put("NumberOfGraphicPoints",TagFromName.NumberOfGraphicPoints);
		tagByName.put("GraphicData",TagFromName.GraphicData);
		tagByName.put("GraphicType",TagFromName.GraphicType);
		tagByName.put("GraphicFilled",TagFromName.GraphicFilled);
		tagByName.put("ImageRotationRetired",TagFromName.ImageRotationRetired);
		tagByName.put("ImageHorizontalFlip",TagFromName.ImageHorizontalFlip);
		tagByName.put("ImageRotation",TagFromName.ImageRotation);
		tagByName.put("DisplayedAreaTopLeftHandCornerTrial",TagFromName.DisplayedAreaTopLeftHandCornerTrial);
		tagByName.put("DisplayedAreaBottomRightHandCornerTrial",TagFromName.DisplayedAreaBottomRightHandCornerTrial);
		tagByName.put("DisplayedAreaTopLeftHandCorner",TagFromName.DisplayedAreaTopLeftHandCorner);
		tagByName.put("DisplayedAreaBottomRightHandCorner",TagFromName.DisplayedAreaBottomRightHandCorner);
		tagByName.put("DisplayedAreaSelectionSequence",TagFromName.DisplayedAreaSelectionSequence);
		tagByName.put("GraphicLayerSequence",TagFromName.GraphicLayerSequence);
		tagByName.put("GraphicLayerOrder",TagFromName.GraphicLayerOrder);
		tagByName.put("GraphicLayerRecommendedDisplayGrayscaleValue",TagFromName.GraphicLayerRecommendedDisplayGrayscaleValue);
		tagByName.put("GraphicLayerRecommendedDisplayRGBValue",TagFromName.GraphicLayerRecommendedDisplayRGBValue);
		tagByName.put("GraphicLayerDescription",TagFromName.GraphicLayerDescription);
		tagByName.put("ContentLabel",TagFromName.ContentLabel);
		tagByName.put("ContentDescription",TagFromName.ContentDescription);
		tagByName.put("PresentationCreationDate",TagFromName.PresentationCreationDate);
		tagByName.put("PresentationCreationTime",TagFromName.PresentationCreationTime);
		tagByName.put("ContentCreatorName",TagFromName.ContentCreatorName);
		tagByName.put("ContentCreatorIdentificationCodeSequence",TagFromName.ContentCreatorIdentificationCodeSequence);
		tagByName.put("AlternateContentDescriptionSequence",TagFromName.AlternateContentDescriptionSequence);
		tagByName.put("PresentationSizeMode",TagFromName.PresentationSizeMode);
		tagByName.put("PresentationPixelSpacing",TagFromName.PresentationPixelSpacing);
		tagByName.put("PresentationPixelAspectRatio",TagFromName.PresentationPixelAspectRatio);
		tagByName.put("PresentationPixelMagnificationRatio",TagFromName.PresentationPixelMagnificationRatio);
		tagByName.put("GraphicGroupLabel",TagFromName.GraphicGroupLabel);
		tagByName.put("GraphicGroupDescription",TagFromName.GraphicGroupDescription);
		tagByName.put("CompoundGraphicSequence",TagFromName.CompoundGraphicSequence);
		tagByName.put("CompoundGraphicInstanceID",TagFromName.CompoundGraphicInstanceID);
		tagByName.put("FontName",TagFromName.FontName);
		tagByName.put("FontNameType",TagFromName.FontNameType);
		tagByName.put("CSSFontName",TagFromName.CSSFontName);
		tagByName.put("RotationAngle",TagFromName.RotationAngle);
		tagByName.put("TextStyleSequence",TagFromName.TextStyleSequence);
		tagByName.put("LineStyleSequence",TagFromName.LineStyleSequence);
		tagByName.put("FillStyleSequence",TagFromName.FillStyleSequence);
		tagByName.put("GraphicGroupSequence",TagFromName.GraphicGroupSequence);
		tagByName.put("TextColorCIELabValue",TagFromName.TextColorCIELabValue);
		tagByName.put("HorizontalAlignment",TagFromName.HorizontalAlignment);
		tagByName.put("VerticalAlignment",TagFromName.VerticalAlignment);
		tagByName.put("ShadowStyle",TagFromName.ShadowStyle);
		tagByName.put("ShadowOffsetX",TagFromName.ShadowOffsetX);
		tagByName.put("ShadowOffsetY",TagFromName.ShadowOffsetY);
		tagByName.put("ShadowColorCIELabValue",TagFromName.ShadowColorCIELabValue);
		tagByName.put("Underlined",TagFromName.Underlined);
		tagByName.put("Bold",TagFromName.Bold);
		tagByName.put("Italic",TagFromName.Italic);
		tagByName.put("PatternOnColorCIELabValue",TagFromName.PatternOnColorCIELabValue);
		tagByName.put("PatternOffColorCIELabValue",TagFromName.PatternOffColorCIELabValue);
		tagByName.put("LineThickness",TagFromName.LineThickness);
		tagByName.put("LineDashingStyle",TagFromName.LineDashingStyle);
		tagByName.put("LinePattern",TagFromName.LinePattern);
		tagByName.put("FillPattern",TagFromName.FillPattern);
		tagByName.put("FillMode",TagFromName.FillMode);
		tagByName.put("ShadowOpacity",TagFromName.ShadowOpacity);
		tagByName.put("GapLength",TagFromName.GapLength);
		tagByName.put("DiameterOfVisibility",TagFromName.DiameterOfVisibility);
		tagByName.put("RotationPoint",TagFromName.RotationPoint);
		tagByName.put("TickAlignment",TagFromName.TickAlignment);
		tagByName.put("ShowTickLabel",TagFromName.ShowTickLabel);
		tagByName.put("TickLabelAlignment",TagFromName.TickLabelAlignment);
		tagByName.put("CompoundGraphicUnits",TagFromName.CompoundGraphicUnits);
		tagByName.put("PatternOnOpacity",TagFromName.PatternOnOpacity);
		tagByName.put("PatternOffOpacity",TagFromName.PatternOffOpacity);
		tagByName.put("MajorTicksSequence",TagFromName.MajorTicksSequence);
		tagByName.put("TickPosition",TagFromName.TickPosition);
		tagByName.put("TickLabel",TagFromName.TickLabel);
		tagByName.put("CompoundGraphicType",TagFromName.CompoundGraphicType);
		tagByName.put("GraphicGroupID",TagFromName.GraphicGroupID);
		tagByName.put("ShapeType",TagFromName.ShapeType);
		tagByName.put("RegistrationSequence",TagFromName.RegistrationSequence);
		tagByName.put("MatrixRegistrationSequence",TagFromName.MatrixRegistrationSequence);
		tagByName.put("MatrixSequence",TagFromName.MatrixSequence);
		tagByName.put("FrameOfReferenceToDisplayedCoordinateSystemTransformationMatrix",TagFromName.FrameOfReferenceToDisplayedCoordinateSystemTransformationMatrix);
		tagByName.put("FrameOfReferenceTransformationMatrixType",TagFromName.FrameOfReferenceTransformationMatrixType);
		tagByName.put("RegistrationTypeCodeSequence",TagFromName.RegistrationTypeCodeSequence);
		tagByName.put("FiducialDescription",TagFromName.FiducialDescription);
		tagByName.put("FiducialIdentifier",TagFromName.FiducialIdentifier);
		tagByName.put("FiducialIdentifierCodeSequence",TagFromName.FiducialIdentifierCodeSequence);
		tagByName.put("ContourUncertaintyRadius",TagFromName.ContourUncertaintyRadius);
		tagByName.put("UsedFiducialsSequence",TagFromName.UsedFiducialsSequence);
		tagByName.put("GraphicCoordinatesDataSequence",TagFromName.GraphicCoordinatesDataSequence);
		tagByName.put("FiducialUID",TagFromName.FiducialUID);
		tagByName.put("FiducialSetSequence",TagFromName.FiducialSetSequence);
		tagByName.put("FiducialSequence",TagFromName.FiducialSequence);
		tagByName.put("GraphicLayerRecommendedDisplayCIELabValue",TagFromName.GraphicLayerRecommendedDisplayCIELabValue);
		tagByName.put("BlendingSequence",TagFromName.BlendingSequence);
		tagByName.put("RelativeOpacity",TagFromName.RelativeOpacity);
		tagByName.put("ReferencedSpatialRegistrationSequence",TagFromName.ReferencedSpatialRegistrationSequence);
		tagByName.put("BlendingPosition",TagFromName.BlendingPosition);
		tagByName.put("PresentationDisplayCollectionUID",TagFromName.PresentationDisplayCollectionUID);
		tagByName.put("PresentationSequenceCollectionUID",TagFromName.PresentationSequenceCollectionUID);
		tagByName.put("PresentationSequencePositionIndex",TagFromName.PresentationSequencePositionIndex);
		tagByName.put("RenderedImageReferenceSequence",TagFromName.RenderedImageReferenceSequence);
		tagByName.put("VolumetricPresentationStateInputSequence",TagFromName.VolumetricPresentationStateInputSequence);
		tagByName.put("PresentationInputType",TagFromName.PresentationInputType);
		tagByName.put("InputSequencePositionIndex",TagFromName.InputSequencePositionIndex);
		tagByName.put("Crop",TagFromName.Crop);
		tagByName.put("CroppingSpecificationIndex",TagFromName.CroppingSpecificationIndex);
		tagByName.put("CompositingMethod",TagFromName.CompositingMethod);
		tagByName.put("VolumetricPresentationInputNumber",TagFromName.VolumetricPresentationInputNumber);
		tagByName.put("ImageVolumeGeometry",TagFromName.ImageVolumeGeometry);
		tagByName.put("VolumeCroppingSequence",TagFromName.VolumeCroppingSequence);
		tagByName.put("VolumeCroppingMethod",TagFromName.VolumeCroppingMethod);
		tagByName.put("BoundingBoxCrop",TagFromName.BoundingBoxCrop);
		tagByName.put("ObliqueCroppingPlaneSequence",TagFromName.ObliqueCroppingPlaneSequence);
		tagByName.put("ObliqueCroppingPlane",TagFromName.ObliqueCroppingPlane);
		tagByName.put("ObliqueCroppingPlaneNormal",TagFromName.ObliqueCroppingPlaneNormal);
		tagByName.put("CroppingSpecificationNumber",TagFromName.CroppingSpecificationNumber);
		tagByName.put("MultiPlanarReconstructionStyle",TagFromName.MultiPlanarReconstructionStyle);
		tagByName.put("MPRThicknessType",TagFromName.MPRThicknessType);
		tagByName.put("MPRSlabThickness",TagFromName.MPRSlabThickness);
		tagByName.put("MPRTopLeftHandCorner",TagFromName.MPRTopLeftHandCorner);
		tagByName.put("MPRViewWidthDirection",TagFromName.MPRViewWidthDirection);
		tagByName.put("MPRViewWidth",TagFromName.MPRViewWidth);
		tagByName.put("NumberOfVolumetricCurvePoints",TagFromName.NumberOfVolumetricCurvePoints);
		tagByName.put("VolumetricCurvePoints",TagFromName.VolumetricCurvePoints);
		tagByName.put("MPRViewHeightDirection",TagFromName.MPRViewHeightDirection);
		tagByName.put("MPRViewHeight",TagFromName.MPRViewHeight);
		tagByName.put("PresentationStateClassificationComponentSequence",TagFromName.PresentationStateClassificationComponentSequence);
		tagByName.put("ComponentType",TagFromName.ComponentType);
		tagByName.put("ComponentInputSequence",TagFromName.ComponentInputSequence);
		tagByName.put("VolumetricPresentationInputIndex",TagFromName.VolumetricPresentationInputIndex);
		tagByName.put("PresentationStateCompositorComponentSequence",TagFromName.PresentationStateCompositorComponentSequence);
		tagByName.put("WeightingTransferFunctionSequence",TagFromName.WeightingTransferFunctionSequence);
		tagByName.put("WeightingLookupTableDescriptor",TagFromName.WeightingLookupTableDescriptor);
		tagByName.put("WeightingLookupTableData",TagFromName.WeightingLookupTableData);
		tagByName.put("VolumetricAnnotationSequence",TagFromName.VolumetricAnnotationSequence);
		tagByName.put("ReferencedStructuredContextSequence",TagFromName.ReferencedStructuredContextSequence);
		tagByName.put("ReferencedContentItem",TagFromName.ReferencedContentItem);
		tagByName.put("VolumetricPresentationInputAnnotationSequence",TagFromName.VolumetricPresentationInputAnnotationSequence);
		tagByName.put("AnnotationClipping",TagFromName.AnnotationClipping);
		tagByName.put("PresentationAnimationStyle",TagFromName.PresentationAnimationStyle);
		tagByName.put("RecommendedAnimationRate",TagFromName.RecommendedAnimationRate);
		tagByName.put("AnimationCurveSequence",TagFromName.AnimationCurveSequence);
		tagByName.put("AnimationStepSize",TagFromName.AnimationStepSize);
		tagByName.put("HangingProtocolName",TagFromName.HangingProtocolName);
		tagByName.put("HangingProtocolDescription",TagFromName.HangingProtocolDescription);
		tagByName.put("HangingProtocolLevel",TagFromName.HangingProtocolLevel);
		tagByName.put("HangingProtocolCreator",TagFromName.HangingProtocolCreator);
		tagByName.put("HangingProtocolCreationDateTime",TagFromName.HangingProtocolCreationDateTime);
		tagByName.put("HangingProtocolDefinitionSequence",TagFromName.HangingProtocolDefinitionSequence);
		tagByName.put("HangingProtocolUserIdentificationCodeSequence",TagFromName.HangingProtocolUserIdentificationCodeSequence);
		tagByName.put("HangingProtocolUserGroupName",TagFromName.HangingProtocolUserGroupName);
		tagByName.put("SourceHangingProtocolSequence",TagFromName.SourceHangingProtocolSequence);
		tagByName.put("NumberOfPriorsReferenced",TagFromName.NumberOfPriorsReferenced);
		tagByName.put("ImageSetsSequence",TagFromName.ImageSetsSequence);
		tagByName.put("ImageSetSelectorSequence",TagFromName.ImageSetSelectorSequence);
		tagByName.put("ImageSetSelectorUsageFlag",TagFromName.ImageSetSelectorUsageFlag);
		tagByName.put("SelectorAttribute",TagFromName.SelectorAttribute);
		tagByName.put("SelectorValueNumber",TagFromName.SelectorValueNumber);
		tagByName.put("TimeBasedImageSetsSequence",TagFromName.TimeBasedImageSetsSequence);
		tagByName.put("ImageSetNumber",TagFromName.ImageSetNumber);
		tagByName.put("ImageSetSelectorCategory",TagFromName.ImageSetSelectorCategory);
		tagByName.put("RelativeTime",TagFromName.RelativeTime);
		tagByName.put("RelativeTimeUnits",TagFromName.RelativeTimeUnits);
		tagByName.put("AbstractPriorValue",TagFromName.AbstractPriorValue);
		tagByName.put("AbstractPriorCodeSequence",TagFromName.AbstractPriorCodeSequence);
		tagByName.put("ImageSetLabel",TagFromName.ImageSetLabel);
		tagByName.put("SelectorAttributeVR",TagFromName.SelectorAttributeVR);
		tagByName.put("SelectorSequencePointer",TagFromName.SelectorSequencePointer);
		tagByName.put("SelectorSequencePointerPrivateCreator",TagFromName.SelectorSequencePointerPrivateCreator);
		tagByName.put("SelectorAttributePrivateCreator",TagFromName.SelectorAttributePrivateCreator);
		tagByName.put("SelectorATValue",TagFromName.SelectorATValue);
		tagByName.put("SelectorCSValue",TagFromName.SelectorCSValue);
		tagByName.put("SelectorISValue",TagFromName.SelectorISValue);
		tagByName.put("SelectorLOValue",TagFromName.SelectorLOValue);
		tagByName.put("SelectorLTValue",TagFromName.SelectorLTValue);
		tagByName.put("SelectorPNValue",TagFromName.SelectorPNValue);
		tagByName.put("SelectorSHValue",TagFromName.SelectorSHValue);
		tagByName.put("SelectorSTValue",TagFromName.SelectorSTValue);
		tagByName.put("SelectorUTValue",TagFromName.SelectorUTValue);
		tagByName.put("SelectorDSValue",TagFromName.SelectorDSValue);
		tagByName.put("SelectorFDValue",TagFromName.SelectorFDValue);
		tagByName.put("SelectorFLValue",TagFromName.SelectorFLValue);
		tagByName.put("SelectorULValue",TagFromName.SelectorULValue);
		tagByName.put("SelectorUSValue",TagFromName.SelectorUSValue);
		tagByName.put("SelectorSLValue",TagFromName.SelectorSLValue);
		tagByName.put("SelectorSSValue",TagFromName.SelectorSSValue);
		tagByName.put("SelectorUIValue",TagFromName.SelectorUIValue);
		tagByName.put("SelectorCodeSequenceValue",TagFromName.SelectorCodeSequenceValue);
		tagByName.put("NumberOfScreens",TagFromName.NumberOfScreens);
		tagByName.put("NominalScreenDefinitionSequence",TagFromName.NominalScreenDefinitionSequence);
		tagByName.put("NumberOfVerticalPixels",TagFromName.NumberOfVerticalPixels);
		tagByName.put("NumberOfHorizontalPixels",TagFromName.NumberOfHorizontalPixels);
		tagByName.put("DisplayEnvironmentSpatialPosition",TagFromName.DisplayEnvironmentSpatialPosition);
		tagByName.put("ScreenMinimumGrayscaleBitDepth",TagFromName.ScreenMinimumGrayscaleBitDepth);
		tagByName.put("ScreenMinimumColorBitDepth",TagFromName.ScreenMinimumColorBitDepth);
		tagByName.put("ApplicationMaximumRepaintTime",TagFromName.ApplicationMaximumRepaintTime);
		tagByName.put("DisplaySetsSequence",TagFromName.DisplaySetsSequence);
		tagByName.put("DisplaySetNumber",TagFromName.DisplaySetNumber);
		tagByName.put("DisplaySetLabel",TagFromName.DisplaySetLabel);
		tagByName.put("DisplaySetPresentationGroup",TagFromName.DisplaySetPresentationGroup);
		tagByName.put("DisplaySetPresentationGroupDescription",TagFromName.DisplaySetPresentationGroupDescription);
		tagByName.put("PartialDataDisplayHandling",TagFromName.PartialDataDisplayHandling);
		tagByName.put("SynchronizedScrollingSequence",TagFromName.SynchronizedScrollingSequence);
		tagByName.put("DisplaySetScrollingGroup",TagFromName.DisplaySetScrollingGroup);
		tagByName.put("NavigationIndicatorSequence",TagFromName.NavigationIndicatorSequence);
		tagByName.put("NavigationDisplaySet",TagFromName.NavigationDisplaySet);
		tagByName.put("ReferenceDisplaySets",TagFromName.ReferenceDisplaySets);
		tagByName.put("ImageBoxesSequence",TagFromName.ImageBoxesSequence);
		tagByName.put("ImageBoxNumber",TagFromName.ImageBoxNumber);
		tagByName.put("ImageBoxLayoutType",TagFromName.ImageBoxLayoutType);
		tagByName.put("ImageBoxTileHorizontalDimension",TagFromName.ImageBoxTileHorizontalDimension);
		tagByName.put("ImageBoxTileVerticalDimension",TagFromName.ImageBoxTileVerticalDimension);
		tagByName.put("ImageBoxScrollDirection",TagFromName.ImageBoxScrollDirection);
		tagByName.put("ImageBoxSmallScrollType",TagFromName.ImageBoxSmallScrollType);
		tagByName.put("ImageBoxSmallScrollAmount",TagFromName.ImageBoxSmallScrollAmount);
		tagByName.put("ImageBoxLargeScrollType",TagFromName.ImageBoxLargeScrollType);
		tagByName.put("ImageBoxLargeScrollAmount",TagFromName.ImageBoxLargeScrollAmount);
		tagByName.put("ImageBoxOverlapPriority",TagFromName.ImageBoxOverlapPriority);
		tagByName.put("CineRelativeToRealTime",TagFromName.CineRelativeToRealTime);
		tagByName.put("FilterOperationsSequence",TagFromName.FilterOperationsSequence);
		tagByName.put("FilterByCategory",TagFromName.FilterByCategory);
		tagByName.put("FilterByAttributePresence",TagFromName.FilterByAttributePresence);
		tagByName.put("FilterByOperator",TagFromName.FilterByOperator);
		tagByName.put("StructuredDisplayBackgroundCIELabValue",TagFromName.StructuredDisplayBackgroundCIELabValue);
		tagByName.put("EmptyImageBoxCIELabValue",TagFromName.EmptyImageBoxCIELabValue);
		tagByName.put("StructuredDisplayImageBoxSequence",TagFromName.StructuredDisplayImageBoxSequence);
		tagByName.put("StructuredDisplayTextBoxSequence",TagFromName.StructuredDisplayTextBoxSequence);
		tagByName.put("ReferencedFirstFrameSequence",TagFromName.ReferencedFirstFrameSequence);
		tagByName.put("ImageBoxSynchronizationSequence",TagFromName.ImageBoxSynchronizationSequence);
		tagByName.put("SynchronizedImageBoxList",TagFromName.SynchronizedImageBoxList);
		tagByName.put("TypeOfSynchronization",TagFromName.TypeOfSynchronization);
		tagByName.put("BlendingOperationType",TagFromName.BlendingOperationType);
		tagByName.put("ReformattingOperationType",TagFromName.ReformattingOperationType);
		tagByName.put("ReformattingThickness",TagFromName.ReformattingThickness);
		tagByName.put("ReformattingInterval",TagFromName.ReformattingInterval);
		tagByName.put("ReformattingOperationInitialViewDirection",TagFromName.ReformattingOperationInitialViewDirection);
		tagByName.put("ThreeDRenderingType",TagFromName.ThreeDRenderingType);
		tagByName.put("SortingOperationsSequence",TagFromName.SortingOperationsSequence);
		tagByName.put("SortByCategory",TagFromName.SortByCategory);
		tagByName.put("SortingDirection",TagFromName.SortingDirection);
		tagByName.put("DisplaySetPatientOrientation",TagFromName.DisplaySetPatientOrientation);
		tagByName.put("VOIType",TagFromName.VOIType);
		tagByName.put("PseudoColorType",TagFromName.PseudoColorType);
		tagByName.put("PseudoColorPaletteInstanceReferenceSequence",TagFromName.PseudoColorPaletteInstanceReferenceSequence);
		tagByName.put("ShowGrayscaleInverted",TagFromName.ShowGrayscaleInverted);
		tagByName.put("ShowImageTrueSizeFlag",TagFromName.ShowImageTrueSizeFlag);
		tagByName.put("ShowGraphicAnnotationFlag",TagFromName.ShowGraphicAnnotationFlag);
		tagByName.put("ShowPatientDemographicsFlag",TagFromName.ShowPatientDemographicsFlag);
		tagByName.put("ShowAcquisitionTechniquesFlag",TagFromName.ShowAcquisitionTechniquesFlag);
		tagByName.put("DisplaySetHorizontalJustification",TagFromName.DisplaySetHorizontalJustification);
		tagByName.put("DisplaySetVerticalJustification",TagFromName.DisplaySetVerticalJustification);
		tagByName.put("ContinuationStartMeterset",TagFromName.ContinuationStartMeterset);
		tagByName.put("ContinuationEndMeterset",TagFromName.ContinuationEndMeterset);
		tagByName.put("ProcedureStepState",TagFromName.ProcedureStepState);
		tagByName.put("ProcedureStepProgressInformationSequence",TagFromName.ProcedureStepProgressInformationSequence);
		tagByName.put("ProcedureStepProgress",TagFromName.ProcedureStepProgress);
		tagByName.put("ProcedureStepProgressDescription",TagFromName.ProcedureStepProgressDescription);
		tagByName.put("ProcedureStepCommunicationsURISequence",TagFromName.ProcedureStepCommunicationsURISequence);
		tagByName.put("ContactURI",TagFromName.ContactURI);
		tagByName.put("ContactDisplayName",TagFromName.ContactDisplayName);
		tagByName.put("ProcedureStepDiscontinuationReasonCodeSequence",TagFromName.ProcedureStepDiscontinuationReasonCodeSequence);
		tagByName.put("BeamTaskSequence",TagFromName.BeamTaskSequence);
		tagByName.put("BeamTaskType",TagFromName.BeamTaskType);
		tagByName.put("BeamOrderIndexTrial",TagFromName.BeamOrderIndexTrial);
		tagByName.put("AutosequenceFlag",TagFromName.AutosequenceFlag);
		tagByName.put("TableTopVerticalAdjustedPosition",TagFromName.TableTopVerticalAdjustedPosition);
		tagByName.put("TableTopLongitudinalAdjustedPosition",TagFromName.TableTopLongitudinalAdjustedPosition);
		tagByName.put("TableTopLateralAdjustedPosition",TagFromName.TableTopLateralAdjustedPosition);
		tagByName.put("PatientSupportAdjustedAngle",TagFromName.PatientSupportAdjustedAngle);
		tagByName.put("TableTopEccentricAdjustedAngle",TagFromName.TableTopEccentricAdjustedAngle);
		tagByName.put("TableTopPitchAdjustedAngle",TagFromName.TableTopPitchAdjustedAngle);
		tagByName.put("TableTopRollAdjustedAngle",TagFromName.TableTopRollAdjustedAngle);
		tagByName.put("DeliveryVerificationImageSequence",TagFromName.DeliveryVerificationImageSequence);
		tagByName.put("VerificationImageTiming",TagFromName.VerificationImageTiming);
		tagByName.put("DoubleExposureFlag",TagFromName.DoubleExposureFlag);
		tagByName.put("DoubleExposureOrdering",TagFromName.DoubleExposureOrdering);
		tagByName.put("DoubleExposureMetersetTrial",TagFromName.DoubleExposureMetersetTrial);
		tagByName.put("DoubleExposureFieldDeltaTrial",TagFromName.DoubleExposureFieldDeltaTrial);
		tagByName.put("RelatedReferenceRTImageSequence",TagFromName.RelatedReferenceRTImageSequence);
		tagByName.put("GeneralMachineVerificationSequence",TagFromName.GeneralMachineVerificationSequence);
		tagByName.put("ConventionalMachineVerificationSequence",TagFromName.ConventionalMachineVerificationSequence);
		tagByName.put("IonMachineVerificationSequence",TagFromName.IonMachineVerificationSequence);
		tagByName.put("FailedAttributesSequence",TagFromName.FailedAttributesSequence);
		tagByName.put("OverriddenAttributesSequence",TagFromName.OverriddenAttributesSequence);
		tagByName.put("ConventionalControlPointVerificationSequence",TagFromName.ConventionalControlPointVerificationSequence);
		tagByName.put("IonControlPointVerificationSequence",TagFromName.IonControlPointVerificationSequence);
		tagByName.put("AttributeOccurrenceSequence",TagFromName.AttributeOccurrenceSequence);
		tagByName.put("AttributeOccurrencePointer",TagFromName.AttributeOccurrencePointer);
		tagByName.put("AttributeItemSelector",TagFromName.AttributeItemSelector);
		tagByName.put("AttributeOccurrencePrivateCreator",TagFromName.AttributeOccurrencePrivateCreator);
		tagByName.put("SelectorSequencePointerItems",TagFromName.SelectorSequencePointerItems);
		tagByName.put("ScheduledProcedureStepPriority",TagFromName.ScheduledProcedureStepPriority);
		tagByName.put("WorklistLabel",TagFromName.WorklistLabel);
		tagByName.put("ProcedureStepLabel",TagFromName.ProcedureStepLabel);
		tagByName.put("ScheduledProcessingParametersSequence",TagFromName.ScheduledProcessingParametersSequence);
		tagByName.put("PerformedProcessingParametersSequence",TagFromName.PerformedProcessingParametersSequence);
		tagByName.put("UnifiedProcedureStepPerformedProcedureSequence",TagFromName.UnifiedProcedureStepPerformedProcedureSequence);
		tagByName.put("RelatedProcedureStepSequence",TagFromName.RelatedProcedureStepSequence);
		tagByName.put("ProcedureStepRelationshipType",TagFromName.ProcedureStepRelationshipType);
		tagByName.put("ReplacedProcedureStepSequence",TagFromName.ReplacedProcedureStepSequence);
		tagByName.put("DeletionLock",TagFromName.DeletionLock);
		tagByName.put("ReceivingAE",TagFromName.ReceivingAE);
		tagByName.put("RequestingAE",TagFromName.RequestingAE);
		tagByName.put("ReasonForCancellation",TagFromName.ReasonForCancellation);
		tagByName.put("SCPStatus",TagFromName.SCPStatus);
		tagByName.put("SubscriptionListStatus",TagFromName.SubscriptionListStatus);
		tagByName.put("UnifiedProcedureStepListStatus",TagFromName.UnifiedProcedureStepListStatus);
		tagByName.put("BeamOrderIndex",TagFromName.BeamOrderIndex);
		tagByName.put("DoubleExposureMeterset",TagFromName.DoubleExposureMeterset);
		tagByName.put("DoubleExposureFieldDelta",TagFromName.DoubleExposureFieldDelta);
		tagByName.put("BrachyTaskSequence",TagFromName.BrachyTaskSequence);
		tagByName.put("ContinuationStartTotalReferenceAirKerma",TagFromName.ContinuationStartTotalReferenceAirKerma);
		tagByName.put("ContinuationEndTotalReferenceAirKerma",TagFromName.ContinuationEndTotalReferenceAirKerma);
		tagByName.put("ContinuationPulseNumber",TagFromName.ContinuationPulseNumber);
		tagByName.put("ChannelDeliveryOrderSequence",TagFromName.ChannelDeliveryOrderSequence);
		tagByName.put("ReferencedChannelNumber",TagFromName.ReferencedChannelNumber);
		tagByName.put("StartCumulativeTimeWeight",TagFromName.StartCumulativeTimeWeight);
		tagByName.put("EndCumulativeTimeWeight",TagFromName.EndCumulativeTimeWeight);
		tagByName.put("OmittedChannelSequence",TagFromName.OmittedChannelSequence);
		tagByName.put("ReasonForChannelOmission",TagFromName.ReasonForChannelOmission);
		tagByName.put("ReasonForChannelOmissionDescription",TagFromName.ReasonForChannelOmissionDescription);
		tagByName.put("ChannelDeliveryOrderIndex",TagFromName.ChannelDeliveryOrderIndex);
		tagByName.put("ChannelDeliveryContinuationSequence",TagFromName.ChannelDeliveryContinuationSequence);
		tagByName.put("OmittedApplicationSetupSequence",TagFromName.OmittedApplicationSetupSequence);
		tagByName.put("ImplantAssemblyTemplateName",TagFromName.ImplantAssemblyTemplateName);
		tagByName.put("ImplantAssemblyTemplateIssuer",TagFromName.ImplantAssemblyTemplateIssuer);
		tagByName.put("ImplantAssemblyTemplateVersion",TagFromName.ImplantAssemblyTemplateVersion);
		tagByName.put("ReplacedImplantAssemblyTemplateSequence",TagFromName.ReplacedImplantAssemblyTemplateSequence);
		tagByName.put("ImplantAssemblyTemplateType",TagFromName.ImplantAssemblyTemplateType);
		tagByName.put("OriginalImplantAssemblyTemplateSequence",TagFromName.OriginalImplantAssemblyTemplateSequence);
		tagByName.put("DerivationImplantAssemblyTemplateSequence",TagFromName.DerivationImplantAssemblyTemplateSequence);
		tagByName.put("ImplantAssemblyTemplateTargetAnatomySequence",TagFromName.ImplantAssemblyTemplateTargetAnatomySequence);
		tagByName.put("ProcedureTypeCodeSequence",TagFromName.ProcedureTypeCodeSequence);
		tagByName.put("SurgicalTechnique",TagFromName.SurgicalTechnique);
		tagByName.put("ComponentTypesSequence",TagFromName.ComponentTypesSequence);
		tagByName.put("ComponentTypeCodeSequence",TagFromName.ComponentTypeCodeSequence);
		tagByName.put("ExclusiveComponentType",TagFromName.ExclusiveComponentType);
		tagByName.put("MandatoryComponentType",TagFromName.MandatoryComponentType);
		tagByName.put("ComponentSequence",TagFromName.ComponentSequence);
		tagByName.put("ComponentID",TagFromName.ComponentID);
		tagByName.put("ComponentAssemblySequence",TagFromName.ComponentAssemblySequence);
		tagByName.put("Component1ReferencedID",TagFromName.Component1ReferencedID);
		tagByName.put("Component1ReferencedMatingFeatureSetID",TagFromName.Component1ReferencedMatingFeatureSetID);
		tagByName.put("Component1ReferencedMatingFeatureID",TagFromName.Component1ReferencedMatingFeatureID);
		tagByName.put("Component2ReferencedID",TagFromName.Component2ReferencedID);
		tagByName.put("Component2ReferencedMatingFeatureSetID",TagFromName.Component2ReferencedMatingFeatureSetID);
		tagByName.put("Component2ReferencedMatingFeatureID",TagFromName.Component2ReferencedMatingFeatureID);
		tagByName.put("ImplantTemplateGroupName",TagFromName.ImplantTemplateGroupName);
		tagByName.put("ImplantTemplateGroupDescription",TagFromName.ImplantTemplateGroupDescription);
		tagByName.put("ImplantTemplateGroupIssuer",TagFromName.ImplantTemplateGroupIssuer);
		tagByName.put("ImplantTemplateGroupVersion",TagFromName.ImplantTemplateGroupVersion);
		tagByName.put("ReplacedImplantTemplateGroupSequence",TagFromName.ReplacedImplantTemplateGroupSequence);
		tagByName.put("ImplantTemplateGroupTargetAnatomySequence",TagFromName.ImplantTemplateGroupTargetAnatomySequence);
		tagByName.put("ImplantTemplateGroupMembersSequence",TagFromName.ImplantTemplateGroupMembersSequence);
		tagByName.put("ImplantTemplateGroupMemberID",TagFromName.ImplantTemplateGroupMemberID);
		tagByName.put("ThreeDImplantTemplateGroupMemberMatchingPoint",TagFromName.ThreeDImplantTemplateGroupMemberMatchingPoint);
		tagByName.put("ThreeDImplantTemplateGroupMemberMatchingAxes",TagFromName.ThreeDImplantTemplateGroupMemberMatchingAxes);
		tagByName.put("ImplantTemplateGroupMemberMatching2DCoordinatesSequence",TagFromName.ImplantTemplateGroupMemberMatching2DCoordinatesSequence);
		tagByName.put("TwoDImplantTemplateGroupMemberMatchingPoint",TagFromName.TwoDImplantTemplateGroupMemberMatchingPoint);
		tagByName.put("TwoDImplantTemplateGroupMemberMatchingAxes",TagFromName.TwoDImplantTemplateGroupMemberMatchingAxes);
		tagByName.put("ImplantTemplateGroupVariationDimensionSequence",TagFromName.ImplantTemplateGroupVariationDimensionSequence);
		tagByName.put("ImplantTemplateGroupVariationDimensionName",TagFromName.ImplantTemplateGroupVariationDimensionName);
		tagByName.put("ImplantTemplateGroupVariationDimensionRankSequence",TagFromName.ImplantTemplateGroupVariationDimensionRankSequence);
		tagByName.put("ReferencedImplantTemplateGroupMemberID",TagFromName.ReferencedImplantTemplateGroupMemberID);
		tagByName.put("ImplantTemplateGroupVariationDimensionRank",TagFromName.ImplantTemplateGroupVariationDimensionRank);
		tagByName.put("SurfaceScanAcquisitionTypeCodeSequence",TagFromName.SurfaceScanAcquisitionTypeCodeSequence);
		tagByName.put("SurfaceScanModeCodeSequence",TagFromName.SurfaceScanModeCodeSequence);
		tagByName.put("RegistrationMethodCodeSequence",TagFromName.RegistrationMethodCodeSequence);
		tagByName.put("ShotDurationTime",TagFromName.ShotDurationTime);
		tagByName.put("ShotOffsetTime",TagFromName.ShotOffsetTime);
		tagByName.put("SurfacePointPresentationValueData",TagFromName.SurfacePointPresentationValueData);
		tagByName.put("SurfacePointColorCIELabValueData",TagFromName.SurfacePointColorCIELabValueData);
		tagByName.put("UVMappingSequence",TagFromName.UVMappingSequence);
		tagByName.put("TextureLabel",TagFromName.TextureLabel);
		tagByName.put("UValueData",TagFromName.UValueData);
		tagByName.put("VValueData",TagFromName.VValueData);
		tagByName.put("ReferencedTextureSequence",TagFromName.ReferencedTextureSequence);
		tagByName.put("ReferencedSurfaceDataSequence",TagFromName.ReferencedSurfaceDataSequence);
		tagByName.put("StorageMediaFileSetID",TagFromName.StorageMediaFileSetID);
		tagByName.put("StorageMediaFileSetUID",TagFromName.StorageMediaFileSetUID);
		tagByName.put("IconImageSequence",TagFromName.IconImageSequence);
		tagByName.put("TopicTitle",TagFromName.TopicTitle);
		tagByName.put("TopicSubject",TagFromName.TopicSubject);
		tagByName.put("TopicAuthor",TagFromName.TopicAuthor);
		tagByName.put("TopicKeywords",TagFromName.TopicKeywords);
		tagByName.put("SOPInstanceStatus",TagFromName.SOPInstanceStatus);
		tagByName.put("SOPAuthorizationDateTime",TagFromName.SOPAuthorizationDateTime);
		tagByName.put("SOPAuthorizationComment",TagFromName.SOPAuthorizationComment);
		tagByName.put("AuthorizationEquipmentCertificationNumber",TagFromName.AuthorizationEquipmentCertificationNumber);
		tagByName.put("MACIDNumber",TagFromName.MACIDNumber);
		tagByName.put("MACCalculationTransferSyntaxUID",TagFromName.MACCalculationTransferSyntaxUID);
		tagByName.put("MACAlgorithm",TagFromName.MACAlgorithm);
		tagByName.put("DataElementsSigned",TagFromName.DataElementsSigned);
		tagByName.put("DigitalSignatureUID",TagFromName.DigitalSignatureUID);
		tagByName.put("DigitalSignatureDateTime",TagFromName.DigitalSignatureDateTime);
		tagByName.put("CertificateType",TagFromName.CertificateType);
		tagByName.put("CertificateOfSigner",TagFromName.CertificateOfSigner);
		tagByName.put("Signature",TagFromName.Signature);
		tagByName.put("CertifiedTimestampType",TagFromName.CertifiedTimestampType);
		tagByName.put("CertifiedTimestamp",TagFromName.CertifiedTimestamp);
		tagByName.put("DigitalSignaturePurposeCodeSequence",TagFromName.DigitalSignaturePurposeCodeSequence);
		tagByName.put("ReferencedDigitalSignatureSequence",TagFromName.ReferencedDigitalSignatureSequence);
		tagByName.put("ReferencedSOPInstanceMACSequence",TagFromName.ReferencedSOPInstanceMACSequence);
		tagByName.put("MAC",TagFromName.MAC);
		tagByName.put("EncryptedAttributesSequence",TagFromName.EncryptedAttributesSequence);
		tagByName.put("EncryptedContentTransferSyntaxUID",TagFromName.EncryptedContentTransferSyntaxUID);
		tagByName.put("EncryptedContent",TagFromName.EncryptedContent);
		tagByName.put("ModifiedAttributesSequence",TagFromName.ModifiedAttributesSequence);
		tagByName.put("OriginalAttributesSequence",TagFromName.OriginalAttributesSequence);
		tagByName.put("AttributeModificationDateTime",TagFromName.AttributeModificationDateTime);
		tagByName.put("ModifyingSystem",TagFromName.ModifyingSystem);
		tagByName.put("SourceOfPreviousValues",TagFromName.SourceOfPreviousValues);
		tagByName.put("ReasonForTheAttributeModification",TagFromName.ReasonForTheAttributeModification);
		tagByName.put("ZonalMap",TagFromName.ZonalMap);
		tagByName.put("NumberOfCopies",TagFromName.NumberOfCopies);
		tagByName.put("PrinterConfigurationSequence",TagFromName.PrinterConfigurationSequence);
		tagByName.put("PrintPriority",TagFromName.PrintPriority);
		tagByName.put("MediumType",TagFromName.MediumType);
		tagByName.put("FilmDestination",TagFromName.FilmDestination);
		tagByName.put("FilmSessionLabel",TagFromName.FilmSessionLabel);
		tagByName.put("MemoryAllocation",TagFromName.MemoryAllocation);
		tagByName.put("MaximumMemoryAllocation",TagFromName.MaximumMemoryAllocation);
		tagByName.put("ColorImagePrintingFlag",TagFromName.ColorImagePrintingFlag);
		tagByName.put("CollationFlag",TagFromName.CollationFlag);
		tagByName.put("AnnotationFlag",TagFromName.AnnotationFlag);
		tagByName.put("ImageOverlayFlag",TagFromName.ImageOverlayFlag);
		tagByName.put("PresentationLUTFlag",TagFromName.PresentationLUTFlag);
		tagByName.put("ImageBoxPresentationLUTFlag",TagFromName.ImageBoxPresentationLUTFlag);
		tagByName.put("MemoryBitDepth",TagFromName.MemoryBitDepth);
		tagByName.put("PrintingBitDepth",TagFromName.PrintingBitDepth);
		tagByName.put("MediaInstalledSequence",TagFromName.MediaInstalledSequence);
		tagByName.put("OtherMediaAvailableSequence",TagFromName.OtherMediaAvailableSequence);
		tagByName.put("SupportedImageDisplayFormatsSequence",TagFromName.SupportedImageDisplayFormatsSequence);
		tagByName.put("ReferencedFilmBoxSequence",TagFromName.ReferencedFilmBoxSequence);
		tagByName.put("ReferencedStoredPrintSequence",TagFromName.ReferencedStoredPrintSequence);
		tagByName.put("ImageDisplayFormat",TagFromName.ImageDisplayFormat);
		tagByName.put("AnnotationDisplayFormatID",TagFromName.AnnotationDisplayFormatID);
		tagByName.put("FilmOrientation",TagFromName.FilmOrientation);
		tagByName.put("FilmSizeID",TagFromName.FilmSizeID);
		tagByName.put("PrinterResolutionID",TagFromName.PrinterResolutionID);
		tagByName.put("DefaultPrinterResolutionID",TagFromName.DefaultPrinterResolutionID);
		tagByName.put("MagnificationType",TagFromName.MagnificationType);
		tagByName.put("SmoothingType",TagFromName.SmoothingType);
		tagByName.put("DefaultMagnificationType",TagFromName.DefaultMagnificationType);
		tagByName.put("OtherMagnificationTypesAvailable",TagFromName.OtherMagnificationTypesAvailable);
		tagByName.put("DefaultSmoothingType",TagFromName.DefaultSmoothingType);
		tagByName.put("OtherSmoothingTypesAvailable",TagFromName.OtherSmoothingTypesAvailable);
		tagByName.put("BorderDensity",TagFromName.BorderDensity);
		tagByName.put("EmptyImageDensity",TagFromName.EmptyImageDensity);
		tagByName.put("MinDensity",TagFromName.MinDensity);
		tagByName.put("MaxDensity",TagFromName.MaxDensity);
		tagByName.put("Trim",TagFromName.Trim);
		tagByName.put("ConfigurationInformation",TagFromName.ConfigurationInformation);
		tagByName.put("ConfigurationInformationDescription",TagFromName.ConfigurationInformationDescription);
		tagByName.put("MaximumCollatedFilms",TagFromName.MaximumCollatedFilms);
		tagByName.put("Illumination",TagFromName.Illumination);
		tagByName.put("ReflectedAmbientLight",TagFromName.ReflectedAmbientLight);
		tagByName.put("PrinterPixelSpacing",TagFromName.PrinterPixelSpacing);
		tagByName.put("ReferencedFilmSessionSequence",TagFromName.ReferencedFilmSessionSequence);
		tagByName.put("ReferencedImageBoxSequence",TagFromName.ReferencedImageBoxSequence);
		tagByName.put("ReferencedBasicAnnotationBoxSequence",TagFromName.ReferencedBasicAnnotationBoxSequence);
		tagByName.put("ImageBoxPosition",TagFromName.ImageBoxPosition);
		tagByName.put("Polarity",TagFromName.Polarity);
		tagByName.put("RequestedImageSize",TagFromName.RequestedImageSize);
		tagByName.put("RequestedDecimateCropBehavior",TagFromName.RequestedDecimateCropBehavior);
		tagByName.put("RequestedResolutionID",TagFromName.RequestedResolutionID);
		tagByName.put("RequestedImageSizeFlag",TagFromName.RequestedImageSizeFlag);
		tagByName.put("DecimateCropResult",TagFromName.DecimateCropResult);
		tagByName.put("BasicGrayscaleImageSequence",TagFromName.BasicGrayscaleImageSequence);
		tagByName.put("BasicColorImageSequence",TagFromName.BasicColorImageSequence);
		tagByName.put("ReferencedImageOverlayBoxSequence",TagFromName.ReferencedImageOverlayBoxSequence);
		tagByName.put("ReferencedVOILUTBoxSequence",TagFromName.ReferencedVOILUTBoxSequence);
		tagByName.put("AnnotationPosition",TagFromName.AnnotationPosition);
		tagByName.put("TextString",TagFromName.TextString);
		tagByName.put("ReferencedOverlayPlaneSequence",TagFromName.ReferencedOverlayPlaneSequence);
		tagByName.put("ReferencedOverlayPlaneGroups",TagFromName.ReferencedOverlayPlaneGroups);
		tagByName.put("OverlayPixelDataSequence",TagFromName.OverlayPixelDataSequence);
		tagByName.put("OverlayMagnificationType",TagFromName.OverlayMagnificationType);
		tagByName.put("OverlaySmoothingType",TagFromName.OverlaySmoothingType);
		tagByName.put("OverlayOrImageMagnification",TagFromName.OverlayOrImageMagnification);
		tagByName.put("MagnifyToNumberOfColumns",TagFromName.MagnifyToNumberOfColumns);
		tagByName.put("OverlayForegroundDensity",TagFromName.OverlayForegroundDensity);
		tagByName.put("OverlayBackgroundDensity",TagFromName.OverlayBackgroundDensity);
		tagByName.put("OverlayMode",TagFromName.OverlayMode);
		tagByName.put("ThresholdDensity",TagFromName.ThresholdDensity);
		tagByName.put("ReferencedImageBoxSequenceRetired",TagFromName.ReferencedImageBoxSequenceRetired);
		tagByName.put("PresentationLUTSequence",TagFromName.PresentationLUTSequence);
		tagByName.put("PresentationLUTShape",TagFromName.PresentationLUTShape);
		tagByName.put("ReferencedPresentationLUTSequence",TagFromName.ReferencedPresentationLUTSequence);
		tagByName.put("PrintJobID",TagFromName.PrintJobID);
		tagByName.put("ExecutionStatus",TagFromName.ExecutionStatus);
		tagByName.put("ExecutionStatusInfo",TagFromName.ExecutionStatusInfo);
		tagByName.put("CreationDate",TagFromName.CreationDate);
		tagByName.put("CreationTime",TagFromName.CreationTime);
		tagByName.put("Originator",TagFromName.Originator);
		tagByName.put("DestinationAE",TagFromName.DestinationAE);
		tagByName.put("OwnerID",TagFromName.OwnerID);
		tagByName.put("NumberOfFilms",TagFromName.NumberOfFilms);
		tagByName.put("ReferencedPrintJobSequencePullStoredPrint",TagFromName.ReferencedPrintJobSequencePullStoredPrint);
		tagByName.put("PrinterStatus",TagFromName.PrinterStatus);
		tagByName.put("PrinterStatusInfo",TagFromName.PrinterStatusInfo);
		tagByName.put("PrinterName",TagFromName.PrinterName);
		tagByName.put("PrintQueueID",TagFromName.PrintQueueID);
		tagByName.put("QueueStatus",TagFromName.QueueStatus);
		tagByName.put("PrintJobDescriptionSequence",TagFromName.PrintJobDescriptionSequence);
		tagByName.put("ReferencedPrintJobSequence",TagFromName.ReferencedPrintJobSequence);
		tagByName.put("PrintManagementCapabilitiesSequence",TagFromName.PrintManagementCapabilitiesSequence);
		tagByName.put("PrinterCharacteristicsSequence",TagFromName.PrinterCharacteristicsSequence);
		tagByName.put("FilmBoxContentSequence",TagFromName.FilmBoxContentSequence);
		tagByName.put("ImageBoxContentSequence",TagFromName.ImageBoxContentSequence);
		tagByName.put("AnnotationContentSequence",TagFromName.AnnotationContentSequence);
		tagByName.put("ImageOverlayBoxContentSequence",TagFromName.ImageOverlayBoxContentSequence);
		tagByName.put("PresentationLUTContentSequence",TagFromName.PresentationLUTContentSequence);
		tagByName.put("ProposedStudySequence",TagFromName.ProposedStudySequence);
		tagByName.put("OriginalImageSequence",TagFromName.OriginalImageSequence);
		tagByName.put("LabelUsingInformationExtractedFromInstances",TagFromName.LabelUsingInformationExtractedFromInstances);
		tagByName.put("LabelText",TagFromName.LabelText);
		tagByName.put("LabelStyleSelection",TagFromName.LabelStyleSelection);
		tagByName.put("MediaDisposition",TagFromName.MediaDisposition);
		tagByName.put("BarcodeValue",TagFromName.BarcodeValue);
		tagByName.put("BarcodeSymbology",TagFromName.BarcodeSymbology);
		tagByName.put("AllowMediaSplitting",TagFromName.AllowMediaSplitting);
		tagByName.put("IncludeNonDICOMObjects",TagFromName.IncludeNonDICOMObjects);
		tagByName.put("IncludeDisplayApplication",TagFromName.IncludeDisplayApplication);
		tagByName.put("PreserveCompositeInstancesAfterMediaCreation",TagFromName.PreserveCompositeInstancesAfterMediaCreation);
		tagByName.put("TotalNumberOfPiecesOfMediaCreated",TagFromName.TotalNumberOfPiecesOfMediaCreated);
		tagByName.put("RequestedMediaApplicationProfile",TagFromName.RequestedMediaApplicationProfile);
		tagByName.put("ReferencedStorageMediaSequence",TagFromName.ReferencedStorageMediaSequence);
		tagByName.put("FailureAttributes",TagFromName.FailureAttributes);
		tagByName.put("AllowLossyCompression",TagFromName.AllowLossyCompression);
		tagByName.put("RequestPriority",TagFromName.RequestPriority);
		tagByName.put("RTImageLabel",TagFromName.RTImageLabel);
		tagByName.put("RTImageName",TagFromName.RTImageName);
		tagByName.put("RTImageDescription",TagFromName.RTImageDescription);
		tagByName.put("ReportedValuesOrigin",TagFromName.ReportedValuesOrigin);
		tagByName.put("RTImagePlane",TagFromName.RTImagePlane);
		tagByName.put("XRayImageReceptorTranslation",TagFromName.XRayImageReceptorTranslation);
		tagByName.put("XRayImageReceptorAngle",TagFromName.XRayImageReceptorAngle);
		tagByName.put("RTImageOrientation",TagFromName.RTImageOrientation);
		tagByName.put("ImagePlanePixelSpacing",TagFromName.ImagePlanePixelSpacing);
		tagByName.put("RTImagePosition",TagFromName.RTImagePosition);
		tagByName.put("RadiationMachineName",TagFromName.RadiationMachineName);
		tagByName.put("RadiationMachineSAD",TagFromName.RadiationMachineSAD);
		tagByName.put("RadiationMachineSSD",TagFromName.RadiationMachineSSD);
		tagByName.put("RTImageSID",TagFromName.RTImageSID);
		tagByName.put("SourceToReferenceObjectDistance",TagFromName.SourceToReferenceObjectDistance);
		tagByName.put("FractionNumber",TagFromName.FractionNumber);
		tagByName.put("ExposureSequence",TagFromName.ExposureSequence);
		tagByName.put("MetersetExposure",TagFromName.MetersetExposure);
		tagByName.put("DiaphragmPosition",TagFromName.DiaphragmPosition);
		tagByName.put("FluenceMapSequence",TagFromName.FluenceMapSequence);
		tagByName.put("FluenceDataSource",TagFromName.FluenceDataSource);
		tagByName.put("FluenceDataScale",TagFromName.FluenceDataScale);
		tagByName.put("PrimaryFluenceModeSequence",TagFromName.PrimaryFluenceModeSequence);
		tagByName.put("FluenceMode",TagFromName.FluenceMode);
		tagByName.put("FluenceModeID",TagFromName.FluenceModeID);
		tagByName.put("DVHType",TagFromName.DVHType);
		tagByName.put("DoseUnits",TagFromName.DoseUnits);
		tagByName.put("DoseType",TagFromName.DoseType);
		tagByName.put("SpatialTransformOfDose",TagFromName.SpatialTransformOfDose);
		tagByName.put("DoseComment",TagFromName.DoseComment);
		tagByName.put("NormalizationPoint",TagFromName.NormalizationPoint);
		tagByName.put("DoseSummationType",TagFromName.DoseSummationType);
		tagByName.put("GridFrameOffsetVector",TagFromName.GridFrameOffsetVector);
		tagByName.put("DoseGridScaling",TagFromName.DoseGridScaling);
		tagByName.put("RTDoseROISequence",TagFromName.RTDoseROISequence);
		tagByName.put("DoseValue",TagFromName.DoseValue);
		tagByName.put("TissueHeterogeneityCorrection",TagFromName.TissueHeterogeneityCorrection);
		tagByName.put("DVHNormalizationPoint",TagFromName.DVHNormalizationPoint);
		tagByName.put("DVHNormalizationDoseValue",TagFromName.DVHNormalizationDoseValue);
		tagByName.put("DVHSequence",TagFromName.DVHSequence);
		tagByName.put("DVHDoseScaling",TagFromName.DVHDoseScaling);
		tagByName.put("DVHVolumeUnits",TagFromName.DVHVolumeUnits);
		tagByName.put("DVHNumberOfBins",TagFromName.DVHNumberOfBins);
		tagByName.put("DVHData",TagFromName.DVHData);
		tagByName.put("DVHReferencedROISequence",TagFromName.DVHReferencedROISequence);
		tagByName.put("DVHROIContributionType",TagFromName.DVHROIContributionType);
		tagByName.put("DVHMinimumDose",TagFromName.DVHMinimumDose);
		tagByName.put("DVHMaximumDose",TagFromName.DVHMaximumDose);
		tagByName.put("DVHMeanDose",TagFromName.DVHMeanDose);
		tagByName.put("StructureSetLabel",TagFromName.StructureSetLabel);
		tagByName.put("StructureSetName",TagFromName.StructureSetName);
		tagByName.put("StructureSetDescription",TagFromName.StructureSetDescription);
		tagByName.put("StructureSetDate",TagFromName.StructureSetDate);
		tagByName.put("StructureSetTime",TagFromName.StructureSetTime);
		tagByName.put("ReferencedFrameOfReferenceSequence",TagFromName.ReferencedFrameOfReferenceSequence);
		tagByName.put("RTReferencedStudySequence",TagFromName.RTReferencedStudySequence);
		tagByName.put("RTReferencedSeriesSequence",TagFromName.RTReferencedSeriesSequence);
		tagByName.put("ContourImageSequence",TagFromName.ContourImageSequence);
		tagByName.put("PredecessorStructureSetSequence",TagFromName.PredecessorStructureSetSequence);
		tagByName.put("StructureSetROISequence",TagFromName.StructureSetROISequence);
		tagByName.put("ROINumber",TagFromName.ROINumber);
		tagByName.put("ReferencedFrameOfReferenceUID",TagFromName.ReferencedFrameOfReferenceUID);
		tagByName.put("ROIName",TagFromName.ROIName);
		tagByName.put("ROIDescription",TagFromName.ROIDescription);
		tagByName.put("ROIDisplayColor",TagFromName.ROIDisplayColor);
		tagByName.put("ROIVolume",TagFromName.ROIVolume);
		tagByName.put("RTRelatedROISequence",TagFromName.RTRelatedROISequence);
		tagByName.put("RTROIRelationship",TagFromName.RTROIRelationship);
		tagByName.put("ROIGenerationAlgorithm",TagFromName.ROIGenerationAlgorithm);
		tagByName.put("ROIGenerationDescription",TagFromName.ROIGenerationDescription);
		tagByName.put("ROIContourSequence",TagFromName.ROIContourSequence);
		tagByName.put("ContourSequence",TagFromName.ContourSequence);
		tagByName.put("ContourGeometricType",TagFromName.ContourGeometricType);
		tagByName.put("ContourSlabThickness",TagFromName.ContourSlabThickness);
		tagByName.put("ContourOffsetVector",TagFromName.ContourOffsetVector);
		tagByName.put("NumberOfContourPoints",TagFromName.NumberOfContourPoints);
		tagByName.put("ContourNumber",TagFromName.ContourNumber);
		tagByName.put("AttachedContours",TagFromName.AttachedContours);
		tagByName.put("ContourData",TagFromName.ContourData);
		tagByName.put("RTROIObservationsSequence",TagFromName.RTROIObservationsSequence);
		tagByName.put("ObservationNumber",TagFromName.ObservationNumber);
		tagByName.put("ReferencedROINumber",TagFromName.ReferencedROINumber);
		tagByName.put("ROIObservationLabel",TagFromName.ROIObservationLabel);
		tagByName.put("RTROIIdentificationCodeSequence",TagFromName.RTROIIdentificationCodeSequence);
		tagByName.put("ROIObservationDescription",TagFromName.ROIObservationDescription);
		tagByName.put("RelatedRTROIObservationsSequence",TagFromName.RelatedRTROIObservationsSequence);
		tagByName.put("RTROIInterpretedType",TagFromName.RTROIInterpretedType);
		tagByName.put("ROIInterpreter",TagFromName.ROIInterpreter);
		tagByName.put("ROIPhysicalPropertiesSequence",TagFromName.ROIPhysicalPropertiesSequence);
		tagByName.put("ROIPhysicalProperty",TagFromName.ROIPhysicalProperty);
		tagByName.put("ROIPhysicalPropertyValue",TagFromName.ROIPhysicalPropertyValue);
		tagByName.put("ROIElementalCompositionSequence",TagFromName.ROIElementalCompositionSequence);
		tagByName.put("ROIElementalCompositionAtomicNumber",TagFromName.ROIElementalCompositionAtomicNumber);
		tagByName.put("ROIElementalCompositionAtomicMassFraction",TagFromName.ROIElementalCompositionAtomicMassFraction);
		tagByName.put("AdditionalRTROIClassificationCodeSequence",TagFromName.AdditionalRTROIClassificationCodeSequence);
		tagByName.put("FrameOfReferenceRelationshipSequence",TagFromName.FrameOfReferenceRelationshipSequence);
		tagByName.put("RelatedFrameOfReferenceUID",TagFromName.RelatedFrameOfReferenceUID);
		tagByName.put("FrameOfReferenceTransformationType",TagFromName.FrameOfReferenceTransformationType);
		tagByName.put("FrameOfReferenceTransformationMatrix",TagFromName.FrameOfReferenceTransformationMatrix);
		tagByName.put("FrameOfReferenceTransformationComment",TagFromName.FrameOfReferenceTransformationComment);
		tagByName.put("MeasuredDoseReferenceSequence",TagFromName.MeasuredDoseReferenceSequence);
		tagByName.put("MeasuredDoseDescription",TagFromName.MeasuredDoseDescription);
		tagByName.put("MeasuredDoseType",TagFromName.MeasuredDoseType);
		tagByName.put("MeasuredDoseValue",TagFromName.MeasuredDoseValue);
		tagByName.put("TreatmentSessionBeamSequence",TagFromName.TreatmentSessionBeamSequence);
		tagByName.put("TreatmentSessionIonBeamSequence",TagFromName.TreatmentSessionIonBeamSequence);
		tagByName.put("CurrentFractionNumber",TagFromName.CurrentFractionNumber);
		tagByName.put("TreatmentControlPointDate",TagFromName.TreatmentControlPointDate);
		tagByName.put("TreatmentControlPointTime",TagFromName.TreatmentControlPointTime);
		tagByName.put("TreatmentTerminationStatus",TagFromName.TreatmentTerminationStatus);
		tagByName.put("TreatmentTerminationCode",TagFromName.TreatmentTerminationCode);
		tagByName.put("TreatmentVerificationStatus",TagFromName.TreatmentVerificationStatus);
		tagByName.put("ReferencedTreatmentRecordSequence",TagFromName.ReferencedTreatmentRecordSequence);
		tagByName.put("SpecifiedPrimaryMeterset",TagFromName.SpecifiedPrimaryMeterset);
		tagByName.put("SpecifiedSecondaryMeterset",TagFromName.SpecifiedSecondaryMeterset);
		tagByName.put("DeliveredPrimaryMeterset",TagFromName.DeliveredPrimaryMeterset);
		tagByName.put("DeliveredSecondaryMeterset",TagFromName.DeliveredSecondaryMeterset);
		tagByName.put("SpecifiedTreatmentTime",TagFromName.SpecifiedTreatmentTime);
		tagByName.put("DeliveredTreatmentTime",TagFromName.DeliveredTreatmentTime);
		tagByName.put("ControlPointDeliverySequence",TagFromName.ControlPointDeliverySequence);
		tagByName.put("IonControlPointDeliverySequence",TagFromName.IonControlPointDeliverySequence);
		tagByName.put("SpecifiedMeterset",TagFromName.SpecifiedMeterset);
		tagByName.put("DeliveredMeterset",TagFromName.DeliveredMeterset);
		tagByName.put("MetersetRateSet",TagFromName.MetersetRateSet);
		tagByName.put("MetersetRateDelivered",TagFromName.MetersetRateDelivered);
		tagByName.put("ScanSpotMetersetsDelivered",TagFromName.ScanSpotMetersetsDelivered);
		tagByName.put("DoseRateDelivered",TagFromName.DoseRateDelivered);
		tagByName.put("TreatmentSummaryCalculatedDoseReferenceSequence",TagFromName.TreatmentSummaryCalculatedDoseReferenceSequence);
		tagByName.put("CumulativeDoseToDoseReference",TagFromName.CumulativeDoseToDoseReference);
		tagByName.put("FirstTreatmentDate",TagFromName.FirstTreatmentDate);
		tagByName.put("MostRecentTreatmentDate",TagFromName.MostRecentTreatmentDate);
		tagByName.put("NumberOfFractionsDelivered",TagFromName.NumberOfFractionsDelivered);
		tagByName.put("OverrideSequence",TagFromName.OverrideSequence);
		tagByName.put("ParameterSequencePointer",TagFromName.ParameterSequencePointer);
		tagByName.put("OverrideParameterPointer",TagFromName.OverrideParameterPointer);
		tagByName.put("ParameterItemIndex",TagFromName.ParameterItemIndex);
		tagByName.put("MeasuredDoseReferenceNumber",TagFromName.MeasuredDoseReferenceNumber);
		tagByName.put("ParameterPointer",TagFromName.ParameterPointer);
		tagByName.put("OverrideReason",TagFromName.OverrideReason);
		tagByName.put("CorrectedParameterSequence",TagFromName.CorrectedParameterSequence);
		tagByName.put("CorrectionValue",TagFromName.CorrectionValue);
		tagByName.put("CalculatedDoseReferenceSequence",TagFromName.CalculatedDoseReferenceSequence);
		tagByName.put("CalculatedDoseReferenceNumber",TagFromName.CalculatedDoseReferenceNumber);
		tagByName.put("CalculatedDoseReferenceDescription",TagFromName.CalculatedDoseReferenceDescription);
		tagByName.put("CalculatedDoseReferenceDoseValue",TagFromName.CalculatedDoseReferenceDoseValue);
		tagByName.put("StartMeterset",TagFromName.StartMeterset);
		tagByName.put("EndMeterset",TagFromName.EndMeterset);
		tagByName.put("ReferencedMeasuredDoseReferenceSequence",TagFromName.ReferencedMeasuredDoseReferenceSequence);
		tagByName.put("ReferencedMeasuredDoseReferenceNumber",TagFromName.ReferencedMeasuredDoseReferenceNumber);
		tagByName.put("ReferencedCalculatedDoseReferenceSequence",TagFromName.ReferencedCalculatedDoseReferenceSequence);
		tagByName.put("ReferencedCalculatedDoseReferenceNumber",TagFromName.ReferencedCalculatedDoseReferenceNumber);
		tagByName.put("BeamLimitingDeviceLeafPairsSequence",TagFromName.BeamLimitingDeviceLeafPairsSequence);
		tagByName.put("RecordedWedgeSequence",TagFromName.RecordedWedgeSequence);
		tagByName.put("RecordedCompensatorSequence",TagFromName.RecordedCompensatorSequence);
		tagByName.put("RecordedBlockSequence",TagFromName.RecordedBlockSequence);
		tagByName.put("TreatmentSummaryMeasuredDoseReferenceSequence",TagFromName.TreatmentSummaryMeasuredDoseReferenceSequence);
		tagByName.put("RecordedSnoutSequence",TagFromName.RecordedSnoutSequence);
		tagByName.put("RecordedRangeShifterSequence",TagFromName.RecordedRangeShifterSequence);
		tagByName.put("RecordedLateralSpreadingDeviceSequence",TagFromName.RecordedLateralSpreadingDeviceSequence);
		tagByName.put("RecordedRangeModulatorSequence",TagFromName.RecordedRangeModulatorSequence);
		tagByName.put("RecordedSourceSequence",TagFromName.RecordedSourceSequence);
		tagByName.put("SourceSerialNumber",TagFromName.SourceSerialNumber);
		tagByName.put("TreatmentSessionApplicationSetupSequence",TagFromName.TreatmentSessionApplicationSetupSequence);
		tagByName.put("ApplicationSetupCheck",TagFromName.ApplicationSetupCheck);
		tagByName.put("RecordedBrachyAccessoryDeviceSequence",TagFromName.RecordedBrachyAccessoryDeviceSequence);
		tagByName.put("ReferencedBrachyAccessoryDeviceNumber",TagFromName.ReferencedBrachyAccessoryDeviceNumber);
		tagByName.put("RecordedChannelSequence",TagFromName.RecordedChannelSequence);
		tagByName.put("SpecifiedChannelTotalTime",TagFromName.SpecifiedChannelTotalTime);
		tagByName.put("DeliveredChannelTotalTime",TagFromName.DeliveredChannelTotalTime);
		tagByName.put("SpecifiedNumberOfPulses",TagFromName.SpecifiedNumberOfPulses);
		tagByName.put("DeliveredNumberOfPulses",TagFromName.DeliveredNumberOfPulses);
		tagByName.put("SpecifiedPulseRepetitionInterval",TagFromName.SpecifiedPulseRepetitionInterval);
		tagByName.put("DeliveredPulseRepetitionInterval",TagFromName.DeliveredPulseRepetitionInterval);
		tagByName.put("RecordedSourceApplicatorSequence",TagFromName.RecordedSourceApplicatorSequence);
		tagByName.put("ReferencedSourceApplicatorNumber",TagFromName.ReferencedSourceApplicatorNumber);
		tagByName.put("RecordedChannelShieldSequence",TagFromName.RecordedChannelShieldSequence);
		tagByName.put("ReferencedChannelShieldNumber",TagFromName.ReferencedChannelShieldNumber);
		tagByName.put("BrachyControlPointDeliveredSequence",TagFromName.BrachyControlPointDeliveredSequence);
		tagByName.put("SafePositionExitDate",TagFromName.SafePositionExitDate);
		tagByName.put("SafePositionExitTime",TagFromName.SafePositionExitTime);
		tagByName.put("SafePositionReturnDate",TagFromName.SafePositionReturnDate);
		tagByName.put("SafePositionReturnTime",TagFromName.SafePositionReturnTime);
		tagByName.put("PulseSpecificBrachyControlPointDeliveredSequence",TagFromName.PulseSpecificBrachyControlPointDeliveredSequence);
		tagByName.put("PulseNumber",TagFromName.PulseNumber);
		tagByName.put("BrachyPulseControlPointDeliveredSequence",TagFromName.BrachyPulseControlPointDeliveredSequence);
		tagByName.put("CurrentTreatmentStatus",TagFromName.CurrentTreatmentStatus);
		tagByName.put("TreatmentStatusComment",TagFromName.TreatmentStatusComment);
		tagByName.put("FractionGroupSummarySequence",TagFromName.FractionGroupSummarySequence);
		tagByName.put("ReferencedFractionNumber",TagFromName.ReferencedFractionNumber);
		tagByName.put("FractionGroupType",TagFromName.FractionGroupType);
		tagByName.put("BeamStopperPosition",TagFromName.BeamStopperPosition);
		tagByName.put("FractionStatusSummarySequence",TagFromName.FractionStatusSummarySequence);
		tagByName.put("TreatmentDate",TagFromName.TreatmentDate);
		tagByName.put("TreatmentTime",TagFromName.TreatmentTime);
		tagByName.put("RTPlanLabel",TagFromName.RTPlanLabel);
		tagByName.put("RTPlanName",TagFromName.RTPlanName);
		tagByName.put("RTPlanDescription",TagFromName.RTPlanDescription);
		tagByName.put("RTPlanDate",TagFromName.RTPlanDate);
		tagByName.put("RTPlanTime",TagFromName.RTPlanTime);
		tagByName.put("TreatmentProtocols",TagFromName.TreatmentProtocols);
		tagByName.put("PlanIntent",TagFromName.PlanIntent);
		tagByName.put("TreatmentSites",TagFromName.TreatmentSites);
		tagByName.put("RTPlanGeometry",TagFromName.RTPlanGeometry);
		tagByName.put("PrescriptionDescription",TagFromName.PrescriptionDescription);
		tagByName.put("DoseReferenceSequence",TagFromName.DoseReferenceSequence);
		tagByName.put("DoseReferenceNumber",TagFromName.DoseReferenceNumber);
		tagByName.put("DoseReferenceUID",TagFromName.DoseReferenceUID);
		tagByName.put("DoseReferenceStructureType",TagFromName.DoseReferenceStructureType);
		tagByName.put("NominalBeamEnergyUnit",TagFromName.NominalBeamEnergyUnit);
		tagByName.put("DoseReferenceDescription",TagFromName.DoseReferenceDescription);
		tagByName.put("DoseReferencePointCoordinates",TagFromName.DoseReferencePointCoordinates);
		tagByName.put("NominalPriorDose",TagFromName.NominalPriorDose);
		tagByName.put("DoseReferenceType",TagFromName.DoseReferenceType);
		tagByName.put("ConstraintWeight",TagFromName.ConstraintWeight);
		tagByName.put("DeliveryWarningDose",TagFromName.DeliveryWarningDose);
		tagByName.put("DeliveryMaximumDose",TagFromName.DeliveryMaximumDose);
		tagByName.put("TargetMinimumDose",TagFromName.TargetMinimumDose);
		tagByName.put("TargetPrescriptionDose",TagFromName.TargetPrescriptionDose);
		tagByName.put("TargetMaximumDose",TagFromName.TargetMaximumDose);
		tagByName.put("TargetUnderdoseVolumeFraction",TagFromName.TargetUnderdoseVolumeFraction);
		tagByName.put("OrganAtRiskFullVolumeDose",TagFromName.OrganAtRiskFullVolumeDose);
		tagByName.put("OrganAtRiskLimitDose",TagFromName.OrganAtRiskLimitDose);
		tagByName.put("OrganAtRiskMaximumDose",TagFromName.OrganAtRiskMaximumDose);
		tagByName.put("OrganAtRiskOverdoseVolumeFraction",TagFromName.OrganAtRiskOverdoseVolumeFraction);
		tagByName.put("ToleranceTableSequence",TagFromName.ToleranceTableSequence);
		tagByName.put("ToleranceTableNumber",TagFromName.ToleranceTableNumber);
		tagByName.put("ToleranceTableLabel",TagFromName.ToleranceTableLabel);
		tagByName.put("GantryAngleTolerance",TagFromName.GantryAngleTolerance);
		tagByName.put("BeamLimitingDeviceAngleTolerance",TagFromName.BeamLimitingDeviceAngleTolerance);
		tagByName.put("BeamLimitingDeviceToleranceSequence",TagFromName.BeamLimitingDeviceToleranceSequence);
		tagByName.put("BeamLimitingDevicePositionTolerance",TagFromName.BeamLimitingDevicePositionTolerance);
		tagByName.put("SnoutPositionTolerance",TagFromName.SnoutPositionTolerance);
		tagByName.put("PatientSupportAngleTolerance",TagFromName.PatientSupportAngleTolerance);
		tagByName.put("TableTopEccentricAngleTolerance",TagFromName.TableTopEccentricAngleTolerance);
		tagByName.put("TableTopPitchAngleTolerance",TagFromName.TableTopPitchAngleTolerance);
		tagByName.put("TableTopRollAngleTolerance",TagFromName.TableTopRollAngleTolerance);
		tagByName.put("TableTopVerticalPositionTolerance",TagFromName.TableTopVerticalPositionTolerance);
		tagByName.put("TableTopLongitudinalPositionTolerance",TagFromName.TableTopLongitudinalPositionTolerance);
		tagByName.put("TableTopLateralPositionTolerance",TagFromName.TableTopLateralPositionTolerance);
		tagByName.put("RTPlanRelationship",TagFromName.RTPlanRelationship);
		tagByName.put("FractionGroupSequence",TagFromName.FractionGroupSequence);
		tagByName.put("FractionGroupNumber",TagFromName.FractionGroupNumber);
		tagByName.put("FractionGroupDescription",TagFromName.FractionGroupDescription);
		tagByName.put("NumberOfFractionsPlanned",TagFromName.NumberOfFractionsPlanned);
		tagByName.put("NumberOfFractionPatternDigitsPerDay",TagFromName.NumberOfFractionPatternDigitsPerDay);
		tagByName.put("RepeatFractionCycleLength",TagFromName.RepeatFractionCycleLength);
		tagByName.put("FractionPattern",TagFromName.FractionPattern);
		tagByName.put("NumberOfBeams",TagFromName.NumberOfBeams);
		tagByName.put("BeamDoseSpecificationPoint",TagFromName.BeamDoseSpecificationPoint);
		tagByName.put("BeamDose",TagFromName.BeamDose);
		tagByName.put("BeamMeterset",TagFromName.BeamMeterset);
		tagByName.put("BeamDosePointDepth",TagFromName.BeamDosePointDepth);
		tagByName.put("BeamDosePointEquivalentDepth",TagFromName.BeamDosePointEquivalentDepth);
		tagByName.put("BeamDosePointSSD",TagFromName.BeamDosePointSSD);
		tagByName.put("BeamDoseMeaning",TagFromName.BeamDoseMeaning);
		tagByName.put("BeamDoseVerificationControlPointSequence",TagFromName.BeamDoseVerificationControlPointSequence);
		tagByName.put("AverageBeamDosePointDepth",TagFromName.AverageBeamDosePointDepth);
		tagByName.put("AverageBeamDosePointEquivalentDepth",TagFromName.AverageBeamDosePointEquivalentDepth);
		tagByName.put("AverageBeamDosePointSSD",TagFromName.AverageBeamDosePointSSD);
		tagByName.put("BeamDoseType",TagFromName.BeamDoseType);
		tagByName.put("AlternateBeamDose",TagFromName.AlternateBeamDose);
		tagByName.put("AlternateBeamDoseType",TagFromName.AlternateBeamDoseType);
		tagByName.put("NumberOfBrachyApplicationSetups",TagFromName.NumberOfBrachyApplicationSetups);
		tagByName.put("BrachyApplicationSetupDoseSpecificationPoint",TagFromName.BrachyApplicationSetupDoseSpecificationPoint);
		tagByName.put("BrachyApplicationSetupDose",TagFromName.BrachyApplicationSetupDose);
		tagByName.put("BeamSequence",TagFromName.BeamSequence);
		tagByName.put("TreatmentMachineName",TagFromName.TreatmentMachineName);
		tagByName.put("PrimaryDosimeterUnit",TagFromName.PrimaryDosimeterUnit);
		tagByName.put("SourceAxisDistance",TagFromName.SourceAxisDistance);
		tagByName.put("BeamLimitingDeviceSequence",TagFromName.BeamLimitingDeviceSequence);
		tagByName.put("RTBeamLimitingDeviceType",TagFromName.RTBeamLimitingDeviceType);
		tagByName.put("SourceToBeamLimitingDeviceDistance",TagFromName.SourceToBeamLimitingDeviceDistance);
		tagByName.put("IsocenterToBeamLimitingDeviceDistance",TagFromName.IsocenterToBeamLimitingDeviceDistance);
		tagByName.put("NumberOfLeafJawPairs",TagFromName.NumberOfLeafJawPairs);
		tagByName.put("LeafPositionBoundaries",TagFromName.LeafPositionBoundaries);
		tagByName.put("BeamNumber",TagFromName.BeamNumber);
		tagByName.put("BeamName",TagFromName.BeamName);
		tagByName.put("BeamDescription",TagFromName.BeamDescription);
		tagByName.put("BeamType",TagFromName.BeamType);
		tagByName.put("BeamDeliveryDurationLimit",TagFromName.BeamDeliveryDurationLimit);
		tagByName.put("RadiationType",TagFromName.RadiationType);
		tagByName.put("HighDoseTechniqueType",TagFromName.HighDoseTechniqueType);
		tagByName.put("ReferenceImageNumber",TagFromName.ReferenceImageNumber);
		tagByName.put("PlannedVerificationImageSequence",TagFromName.PlannedVerificationImageSequence);
		tagByName.put("ImagingDeviceSpecificAcquisitionParameters",TagFromName.ImagingDeviceSpecificAcquisitionParameters);
		tagByName.put("TreatmentDeliveryType",TagFromName.TreatmentDeliveryType);
		tagByName.put("NumberOfWedges",TagFromName.NumberOfWedges);
		tagByName.put("WedgeSequence",TagFromName.WedgeSequence);
		tagByName.put("WedgeNumber",TagFromName.WedgeNumber);
		tagByName.put("WedgeType",TagFromName.WedgeType);
		tagByName.put("WedgeID",TagFromName.WedgeID);
		tagByName.put("WedgeAngle",TagFromName.WedgeAngle);
		tagByName.put("WedgeFactor",TagFromName.WedgeFactor);
		tagByName.put("TotalWedgeTrayWaterEquivalentThickness",TagFromName.TotalWedgeTrayWaterEquivalentThickness);
		tagByName.put("WedgeOrientation",TagFromName.WedgeOrientation);
		tagByName.put("IsocenterToWedgeTrayDistance",TagFromName.IsocenterToWedgeTrayDistance);
		tagByName.put("SourceToWedgeTrayDistance",TagFromName.SourceToWedgeTrayDistance);
		tagByName.put("WedgeThinEdgePosition",TagFromName.WedgeThinEdgePosition);
		tagByName.put("BolusID",TagFromName.BolusID);
		tagByName.put("BolusDescription",TagFromName.BolusDescription);
		tagByName.put("EffectiveWedgeAngle",TagFromName.EffectiveWedgeAngle);
		tagByName.put("NumberOfCompensators",TagFromName.NumberOfCompensators);
		tagByName.put("MaterialID",TagFromName.MaterialID);
		tagByName.put("TotalCompensatorTrayFactor",TagFromName.TotalCompensatorTrayFactor);
		tagByName.put("CompensatorSequence",TagFromName.CompensatorSequence);
		tagByName.put("CompensatorNumber",TagFromName.CompensatorNumber);
		tagByName.put("CompensatorID",TagFromName.CompensatorID);
		tagByName.put("SourceToCompensatorTrayDistance",TagFromName.SourceToCompensatorTrayDistance);
		tagByName.put("CompensatorRows",TagFromName.CompensatorRows);
		tagByName.put("CompensatorColumns",TagFromName.CompensatorColumns);
		tagByName.put("CompensatorPixelSpacing",TagFromName.CompensatorPixelSpacing);
		tagByName.put("CompensatorPosition",TagFromName.CompensatorPosition);
		tagByName.put("CompensatorTransmissionData",TagFromName.CompensatorTransmissionData);
		tagByName.put("CompensatorThicknessData",TagFromName.CompensatorThicknessData);
		tagByName.put("NumberOfBoli",TagFromName.NumberOfBoli);
		tagByName.put("CompensatorType",TagFromName.CompensatorType);
		tagByName.put("CompensatorTrayID",TagFromName.CompensatorTrayID);
		tagByName.put("NumberOfBlocks",TagFromName.NumberOfBlocks);
		tagByName.put("TotalBlockTrayFactor",TagFromName.TotalBlockTrayFactor);
		tagByName.put("TotalBlockTrayWaterEquivalentThickness",TagFromName.TotalBlockTrayWaterEquivalentThickness);
		tagByName.put("BlockSequence",TagFromName.BlockSequence);
		tagByName.put("BlockTrayID",TagFromName.BlockTrayID);
		tagByName.put("SourceToBlockTrayDistance",TagFromName.SourceToBlockTrayDistance);
		tagByName.put("IsocenterToBlockTrayDistance",TagFromName.IsocenterToBlockTrayDistance);
		tagByName.put("BlockType",TagFromName.BlockType);
		tagByName.put("AccessoryCode",TagFromName.AccessoryCode);
		tagByName.put("BlockDivergence",TagFromName.BlockDivergence);
		tagByName.put("BlockMountingPosition",TagFromName.BlockMountingPosition);
		tagByName.put("BlockNumber",TagFromName.BlockNumber);
		tagByName.put("BlockName",TagFromName.BlockName);
		tagByName.put("BlockThickness",TagFromName.BlockThickness);
		tagByName.put("BlockTransmission",TagFromName.BlockTransmission);
		tagByName.put("BlockNumberOfPoints",TagFromName.BlockNumberOfPoints);
		tagByName.put("BlockData",TagFromName.BlockData);
		tagByName.put("ApplicatorSequence",TagFromName.ApplicatorSequence);
		tagByName.put("ApplicatorID",TagFromName.ApplicatorID);
		tagByName.put("ApplicatorType",TagFromName.ApplicatorType);
		tagByName.put("ApplicatorDescription",TagFromName.ApplicatorDescription);
		tagByName.put("CumulativeDoseReferenceCoefficient",TagFromName.CumulativeDoseReferenceCoefficient);
		tagByName.put("FinalCumulativeMetersetWeight",TagFromName.FinalCumulativeMetersetWeight);
		tagByName.put("NumberOfControlPoints",TagFromName.NumberOfControlPoints);
		tagByName.put("ControlPointSequence",TagFromName.ControlPointSequence);
		tagByName.put("ControlPointIndex",TagFromName.ControlPointIndex);
		tagByName.put("NominalBeamEnergy",TagFromName.NominalBeamEnergy);
		tagByName.put("DoseRateSet",TagFromName.DoseRateSet);
		tagByName.put("WedgePositionSequence",TagFromName.WedgePositionSequence);
		tagByName.put("WedgePosition",TagFromName.WedgePosition);
		tagByName.put("BeamLimitingDevicePositionSequence",TagFromName.BeamLimitingDevicePositionSequence);
		tagByName.put("LeafJawPositions",TagFromName.LeafJawPositions);
		tagByName.put("GantryAngle",TagFromName.GantryAngle);
		tagByName.put("GantryRotationDirection",TagFromName.GantryRotationDirection);
		tagByName.put("BeamLimitingDeviceAngle",TagFromName.BeamLimitingDeviceAngle);
		tagByName.put("BeamLimitingDeviceRotationDirection",TagFromName.BeamLimitingDeviceRotationDirection);
		tagByName.put("PatientSupportAngle",TagFromName.PatientSupportAngle);
		tagByName.put("PatientSupportRotationDirection",TagFromName.PatientSupportRotationDirection);
		tagByName.put("TableTopEccentricAxisDistance",TagFromName.TableTopEccentricAxisDistance);
		tagByName.put("TableTopEccentricAngle",TagFromName.TableTopEccentricAngle);
		tagByName.put("TableTopEccentricRotationDirection",TagFromName.TableTopEccentricRotationDirection);
		tagByName.put("TableTopVerticalPosition",TagFromName.TableTopVerticalPosition);
		tagByName.put("TableTopLongitudinalPosition",TagFromName.TableTopLongitudinalPosition);
		tagByName.put("TableTopLateralPosition",TagFromName.TableTopLateralPosition);
		tagByName.put("IsocenterPosition",TagFromName.IsocenterPosition);
		tagByName.put("SurfaceEntryPoint",TagFromName.SurfaceEntryPoint);
		tagByName.put("SourceToSurfaceDistance",TagFromName.SourceToSurfaceDistance);
		tagByName.put("AverageBeamDosePointSourceToExternalContourSurfaceDistance",TagFromName.AverageBeamDosePointSourceToExternalContourSurfaceDistance);
		tagByName.put("SourceToExternalContourDistance",TagFromName.SourceToExternalContourDistance);
		tagByName.put("ExternalContourEntryPoint",TagFromName.ExternalContourEntryPoint);
		tagByName.put("CumulativeMetersetWeight",TagFromName.CumulativeMetersetWeight);
		tagByName.put("TableTopPitchAngle",TagFromName.TableTopPitchAngle);
		tagByName.put("TableTopPitchRotationDirection",TagFromName.TableTopPitchRotationDirection);
		tagByName.put("TableTopRollAngle",TagFromName.TableTopRollAngle);
		tagByName.put("TableTopRollRotationDirection",TagFromName.TableTopRollRotationDirection);
		tagByName.put("HeadFixationAngle",TagFromName.HeadFixationAngle);
		tagByName.put("GantryPitchAngle",TagFromName.GantryPitchAngle);
		tagByName.put("GantryPitchRotationDirection",TagFromName.GantryPitchRotationDirection);
		tagByName.put("GantryPitchAngleTolerance",TagFromName.GantryPitchAngleTolerance);
		tagByName.put("PatientSetupSequence",TagFromName.PatientSetupSequence);
		tagByName.put("PatientSetupNumber",TagFromName.PatientSetupNumber);
		tagByName.put("PatientSetupLabel",TagFromName.PatientSetupLabel);
		tagByName.put("PatientAdditionalPosition",TagFromName.PatientAdditionalPosition);
		tagByName.put("FixationDeviceSequence",TagFromName.FixationDeviceSequence);
		tagByName.put("FixationDeviceType",TagFromName.FixationDeviceType);
		tagByName.put("FixationDeviceLabel",TagFromName.FixationDeviceLabel);
		tagByName.put("FixationDeviceDescription",TagFromName.FixationDeviceDescription);
		tagByName.put("FixationDevicePosition",TagFromName.FixationDevicePosition);
		tagByName.put("FixationDevicePitchAngle",TagFromName.FixationDevicePitchAngle);
		tagByName.put("FixationDeviceRollAngle",TagFromName.FixationDeviceRollAngle);
		tagByName.put("ShieldingDeviceSequence",TagFromName.ShieldingDeviceSequence);
		tagByName.put("ShieldingDeviceType",TagFromName.ShieldingDeviceType);
		tagByName.put("ShieldingDeviceLabel",TagFromName.ShieldingDeviceLabel);
		tagByName.put("ShieldingDeviceDescription",TagFromName.ShieldingDeviceDescription);
		tagByName.put("ShieldingDevicePosition",TagFromName.ShieldingDevicePosition);
		tagByName.put("SetupTechnique",TagFromName.SetupTechnique);
		tagByName.put("SetupTechniqueDescription",TagFromName.SetupTechniqueDescription);
		tagByName.put("SetupDeviceSequence",TagFromName.SetupDeviceSequence);
		tagByName.put("SetupDeviceType",TagFromName.SetupDeviceType);
		tagByName.put("SetupDeviceLabel",TagFromName.SetupDeviceLabel);
		tagByName.put("SetupDeviceDescription",TagFromName.SetupDeviceDescription);
		tagByName.put("SetupDeviceParameter",TagFromName.SetupDeviceParameter);
		tagByName.put("SetupReferenceDescription",TagFromName.SetupReferenceDescription);
		tagByName.put("TableTopVerticalSetupDisplacement",TagFromName.TableTopVerticalSetupDisplacement);
		tagByName.put("TableTopLongitudinalSetupDisplacement",TagFromName.TableTopLongitudinalSetupDisplacement);
		tagByName.put("TableTopLateralSetupDisplacement",TagFromName.TableTopLateralSetupDisplacement);
		tagByName.put("BrachyTreatmentTechnique",TagFromName.BrachyTreatmentTechnique);
		tagByName.put("BrachyTreatmentType",TagFromName.BrachyTreatmentType);
		tagByName.put("TreatmentMachineSequence",TagFromName.TreatmentMachineSequence);
		tagByName.put("SourceSequence",TagFromName.SourceSequence);
		tagByName.put("SourceNumber",TagFromName.SourceNumber);
		tagByName.put("SourceType",TagFromName.SourceType);
		tagByName.put("SourceManufacturer",TagFromName.SourceManufacturer);
		tagByName.put("ActiveSourceDiameter",TagFromName.ActiveSourceDiameter);
		tagByName.put("ActiveSourceLength",TagFromName.ActiveSourceLength);
		tagByName.put("SourceModelID",TagFromName.SourceModelID);
		tagByName.put("SourceDescription",TagFromName.SourceDescription);
		tagByName.put("SourceEncapsulationNominalThickness",TagFromName.SourceEncapsulationNominalThickness);
		tagByName.put("SourceEncapsulationNominalTransmission",TagFromName.SourceEncapsulationNominalTransmission);
		tagByName.put("SourceIsotopeName",TagFromName.SourceIsotopeName);
		tagByName.put("SourceIsotopeHalfLife",TagFromName.SourceIsotopeHalfLife);
		tagByName.put("SourceStrengthUnits",TagFromName.SourceStrengthUnits);
		tagByName.put("ReferenceAirKermaRate",TagFromName.ReferenceAirKermaRate);
		tagByName.put("SourceStrength",TagFromName.SourceStrength);
		tagByName.put("SourceStrengthReferenceDate",TagFromName.SourceStrengthReferenceDate);
		tagByName.put("SourceStrengthReferenceTime",TagFromName.SourceStrengthReferenceTime);
		tagByName.put("ApplicationSetupSequence",TagFromName.ApplicationSetupSequence);
		tagByName.put("ApplicationSetupType",TagFromName.ApplicationSetupType);
		tagByName.put("ApplicationSetupNumber",TagFromName.ApplicationSetupNumber);
		tagByName.put("ApplicationSetupName",TagFromName.ApplicationSetupName);
		tagByName.put("ApplicationSetupManufacturer",TagFromName.ApplicationSetupManufacturer);
		tagByName.put("TemplateNumber",TagFromName.TemplateNumber);
		tagByName.put("TemplateType",TagFromName.TemplateType);
		tagByName.put("TemplateName",TagFromName.TemplateName);
		tagByName.put("TotalReferenceAirKerma",TagFromName.TotalReferenceAirKerma);
		tagByName.put("BrachyAccessoryDeviceSequence",TagFromName.BrachyAccessoryDeviceSequence);
		tagByName.put("BrachyAccessoryDeviceNumber",TagFromName.BrachyAccessoryDeviceNumber);
		tagByName.put("BrachyAccessoryDeviceID",TagFromName.BrachyAccessoryDeviceID);
		tagByName.put("BrachyAccessoryDeviceType",TagFromName.BrachyAccessoryDeviceType);
		tagByName.put("BrachyAccessoryDeviceName",TagFromName.BrachyAccessoryDeviceName);
		tagByName.put("BrachyAccessoryDeviceNominalThickness",TagFromName.BrachyAccessoryDeviceNominalThickness);
		tagByName.put("BrachyAccessoryDeviceNominalTransmission",TagFromName.BrachyAccessoryDeviceNominalTransmission);
		tagByName.put("ChannelSequence",TagFromName.ChannelSequence);
		tagByName.put("ChannelNumber",TagFromName.ChannelNumber);
		tagByName.put("ChannelLength",TagFromName.ChannelLength);
		tagByName.put("ChannelTotalTime",TagFromName.ChannelTotalTime);
		tagByName.put("SourceMovementType",TagFromName.SourceMovementType);
		tagByName.put("NumberOfPulses",TagFromName.NumberOfPulses);
		tagByName.put("PulseRepetitionInterval",TagFromName.PulseRepetitionInterval);
		tagByName.put("SourceApplicatorNumber",TagFromName.SourceApplicatorNumber);
		tagByName.put("SourceApplicatorID",TagFromName.SourceApplicatorID);
		tagByName.put("SourceApplicatorType",TagFromName.SourceApplicatorType);
		tagByName.put("SourceApplicatorName",TagFromName.SourceApplicatorName);
		tagByName.put("SourceApplicatorLength",TagFromName.SourceApplicatorLength);
		tagByName.put("SourceApplicatorManufacturer",TagFromName.SourceApplicatorManufacturer);
		tagByName.put("SourceApplicatorWallNominalThickness",TagFromName.SourceApplicatorWallNominalThickness);
		tagByName.put("SourceApplicatorWallNominalTransmission",TagFromName.SourceApplicatorWallNominalTransmission);
		tagByName.put("SourceApplicatorStepSize",TagFromName.SourceApplicatorStepSize);
		tagByName.put("TransferTubeNumber",TagFromName.TransferTubeNumber);
		tagByName.put("TransferTubeLength",TagFromName.TransferTubeLength);
		tagByName.put("ChannelShieldSequence",TagFromName.ChannelShieldSequence);
		tagByName.put("ChannelShieldNumber",TagFromName.ChannelShieldNumber);
		tagByName.put("ChannelShieldID",TagFromName.ChannelShieldID);
		tagByName.put("ChannelShieldName",TagFromName.ChannelShieldName);
		tagByName.put("ChannelShieldNominalThickness",TagFromName.ChannelShieldNominalThickness);
		tagByName.put("ChannelShieldNominalTransmission",TagFromName.ChannelShieldNominalTransmission);
		tagByName.put("FinalCumulativeTimeWeight",TagFromName.FinalCumulativeTimeWeight);
		tagByName.put("BrachyControlPointSequence",TagFromName.BrachyControlPointSequence);
		tagByName.put("ControlPointRelativePosition",TagFromName.ControlPointRelativePosition);
		tagByName.put("ControlPoint3DPosition",TagFromName.ControlPoint3DPosition);
		tagByName.put("CumulativeTimeWeight",TagFromName.CumulativeTimeWeight);
		tagByName.put("CompensatorDivergence",TagFromName.CompensatorDivergence);
		tagByName.put("CompensatorMountingPosition",TagFromName.CompensatorMountingPosition);
		tagByName.put("SourceToCompensatorDistance",TagFromName.SourceToCompensatorDistance);
		tagByName.put("TotalCompensatorTrayWaterEquivalentThickness",TagFromName.TotalCompensatorTrayWaterEquivalentThickness);
		tagByName.put("IsocenterToCompensatorTrayDistance",TagFromName.IsocenterToCompensatorTrayDistance);
		tagByName.put("CompensatorColumnOffset",TagFromName.CompensatorColumnOffset);
		tagByName.put("IsocenterToCompensatorDistances",TagFromName.IsocenterToCompensatorDistances);
		tagByName.put("CompensatorRelativeStoppingPowerRatio",TagFromName.CompensatorRelativeStoppingPowerRatio);
		tagByName.put("CompensatorMillingToolDiameter",TagFromName.CompensatorMillingToolDiameter);
		tagByName.put("IonRangeCompensatorSequence",TagFromName.IonRangeCompensatorSequence);
		tagByName.put("CompensatorDescription",TagFromName.CompensatorDescription);
		tagByName.put("RadiationMassNumber",TagFromName.RadiationMassNumber);
		tagByName.put("RadiationAtomicNumber",TagFromName.RadiationAtomicNumber);
		tagByName.put("RadiationChargeState",TagFromName.RadiationChargeState);
		tagByName.put("ScanMode",TagFromName.ScanMode);
		tagByName.put("ModulatedScanModeType",TagFromName.ModulatedScanModeType);
		tagByName.put("VirtualSourceAxisDistances",TagFromName.VirtualSourceAxisDistances);
		tagByName.put("SnoutSequence",TagFromName.SnoutSequence);
		tagByName.put("SnoutPosition",TagFromName.SnoutPosition);
		tagByName.put("SnoutID",TagFromName.SnoutID);
		tagByName.put("NumberOfRangeShifters",TagFromName.NumberOfRangeShifters);
		tagByName.put("RangeShifterSequence",TagFromName.RangeShifterSequence);
		tagByName.put("RangeShifterNumber",TagFromName.RangeShifterNumber);
		tagByName.put("RangeShifterID",TagFromName.RangeShifterID);
		tagByName.put("RangeShifterType",TagFromName.RangeShifterType);
		tagByName.put("RangeShifterDescription",TagFromName.RangeShifterDescription);
		tagByName.put("NumberOfLateralSpreadingDevices",TagFromName.NumberOfLateralSpreadingDevices);
		tagByName.put("LateralSpreadingDeviceSequence",TagFromName.LateralSpreadingDeviceSequence);
		tagByName.put("LateralSpreadingDeviceNumber",TagFromName.LateralSpreadingDeviceNumber);
		tagByName.put("LateralSpreadingDeviceID",TagFromName.LateralSpreadingDeviceID);
		tagByName.put("LateralSpreadingDeviceType",TagFromName.LateralSpreadingDeviceType);
		tagByName.put("LateralSpreadingDeviceDescription",TagFromName.LateralSpreadingDeviceDescription);
		tagByName.put("LateralSpreadingDeviceWaterEquivalentThickness",TagFromName.LateralSpreadingDeviceWaterEquivalentThickness);
		tagByName.put("NumberOfRangeModulators",TagFromName.NumberOfRangeModulators);
		tagByName.put("RangeModulatorSequence",TagFromName.RangeModulatorSequence);
		tagByName.put("RangeModulatorNumber",TagFromName.RangeModulatorNumber);
		tagByName.put("RangeModulatorID",TagFromName.RangeModulatorID);
		tagByName.put("RangeModulatorType",TagFromName.RangeModulatorType);
		tagByName.put("RangeModulatorDescription",TagFromName.RangeModulatorDescription);
		tagByName.put("BeamCurrentModulationID",TagFromName.BeamCurrentModulationID);
		tagByName.put("PatientSupportType",TagFromName.PatientSupportType);
		tagByName.put("PatientSupportID",TagFromName.PatientSupportID);
		tagByName.put("PatientSupportAccessoryCode",TagFromName.PatientSupportAccessoryCode);
		tagByName.put("FixationLightAzimuthalAngle",TagFromName.FixationLightAzimuthalAngle);
		tagByName.put("FixationLightPolarAngle",TagFromName.FixationLightPolarAngle);
		tagByName.put("MetersetRate",TagFromName.MetersetRate);
		tagByName.put("RangeShifterSettingsSequence",TagFromName.RangeShifterSettingsSequence);
		tagByName.put("RangeShifterSetting",TagFromName.RangeShifterSetting);
		tagByName.put("IsocenterToRangeShifterDistance",TagFromName.IsocenterToRangeShifterDistance);
		tagByName.put("RangeShifterWaterEquivalentThickness",TagFromName.RangeShifterWaterEquivalentThickness);
		tagByName.put("LateralSpreadingDeviceSettingsSequence",TagFromName.LateralSpreadingDeviceSettingsSequence);
		tagByName.put("LateralSpreadingDeviceSetting",TagFromName.LateralSpreadingDeviceSetting);
		tagByName.put("IsocenterToLateralSpreadingDeviceDistance",TagFromName.IsocenterToLateralSpreadingDeviceDistance);
		tagByName.put("RangeModulatorSettingsSequence",TagFromName.RangeModulatorSettingsSequence);
		tagByName.put("RangeModulatorGatingStartValue",TagFromName.RangeModulatorGatingStartValue);
		tagByName.put("RangeModulatorGatingStopValue",TagFromName.RangeModulatorGatingStopValue);
		tagByName.put("RangeModulatorGatingStartWaterEquivalentThickness",TagFromName.RangeModulatorGatingStartWaterEquivalentThickness);
		tagByName.put("RangeModulatorGatingStopWaterEquivalentThickness",TagFromName.RangeModulatorGatingStopWaterEquivalentThickness);
		tagByName.put("IsocenterToRangeModulatorDistance",TagFromName.IsocenterToRangeModulatorDistance);
		tagByName.put("ScanSpotTuneID",TagFromName.ScanSpotTuneID);
		tagByName.put("NumberOfScanSpotPositions",TagFromName.NumberOfScanSpotPositions);
		tagByName.put("ScanSpotPositionMap",TagFromName.ScanSpotPositionMap);
		tagByName.put("ScanSpotMetersetWeights",TagFromName.ScanSpotMetersetWeights);
		tagByName.put("ScanningSpotSize",TagFromName.ScanningSpotSize);
		tagByName.put("NumberOfPaintings",TagFromName.NumberOfPaintings);
		tagByName.put("IonToleranceTableSequence",TagFromName.IonToleranceTableSequence);
		tagByName.put("IonBeamSequence",TagFromName.IonBeamSequence);
		tagByName.put("IonBeamLimitingDeviceSequence",TagFromName.IonBeamLimitingDeviceSequence);
		tagByName.put("IonBlockSequence",TagFromName.IonBlockSequence);
		tagByName.put("IonControlPointSequence",TagFromName.IonControlPointSequence);
		tagByName.put("IonWedgeSequence",TagFromName.IonWedgeSequence);
		tagByName.put("IonWedgePositionSequence",TagFromName.IonWedgePositionSequence);
		tagByName.put("ReferencedSetupImageSequence",TagFromName.ReferencedSetupImageSequence);
		tagByName.put("SetupImageComment",TagFromName.SetupImageComment);
		tagByName.put("MotionSynchronizationSequence",TagFromName.MotionSynchronizationSequence);
		tagByName.put("ControlPointOrientation",TagFromName.ControlPointOrientation);
		tagByName.put("GeneralAccessorySequence",TagFromName.GeneralAccessorySequence);
		tagByName.put("GeneralAccessoryID",TagFromName.GeneralAccessoryID);
		tagByName.put("GeneralAccessoryDescription",TagFromName.GeneralAccessoryDescription);
		tagByName.put("GeneralAccessoryType",TagFromName.GeneralAccessoryType);
		tagByName.put("GeneralAccessoryNumber",TagFromName.GeneralAccessoryNumber);
		tagByName.put("SourceToGeneralAccessoryDistance",TagFromName.SourceToGeneralAccessoryDistance);
		tagByName.put("ApplicatorGeometrySequence",TagFromName.ApplicatorGeometrySequence);
		tagByName.put("ApplicatorApertureShape",TagFromName.ApplicatorApertureShape);
		tagByName.put("ApplicatorOpening",TagFromName.ApplicatorOpening);
		tagByName.put("ApplicatorOpeningX",TagFromName.ApplicatorOpeningX);
		tagByName.put("ApplicatorOpeningY",TagFromName.ApplicatorOpeningY);
		tagByName.put("SourceToApplicatorMountingPositionDistance",TagFromName.SourceToApplicatorMountingPositionDistance);
		tagByName.put("NumberOfBlockSlabItems",TagFromName.NumberOfBlockSlabItems);
		tagByName.put("BlockSlabSequence",TagFromName.BlockSlabSequence);
		tagByName.put("BlockSlabThickness",TagFromName.BlockSlabThickness);
		tagByName.put("BlockSlabNumber",TagFromName.BlockSlabNumber);
		tagByName.put("DeviceMotionControlSequence",TagFromName.DeviceMotionControlSequence);
		tagByName.put("DeviceMotionExecutionMode",TagFromName.DeviceMotionExecutionMode);
		tagByName.put("DeviceMotionObservationMode",TagFromName.DeviceMotionObservationMode);
		tagByName.put("DeviceMotionParameterCodeSequence",TagFromName.DeviceMotionParameterCodeSequence);
		tagByName.put("ReferencedRTPlanSequence",TagFromName.ReferencedRTPlanSequence);
		tagByName.put("ReferencedBeamSequence",TagFromName.ReferencedBeamSequence);
		tagByName.put("ReferencedBeamNumber",TagFromName.ReferencedBeamNumber);
		tagByName.put("ReferencedReferenceImageNumber",TagFromName.ReferencedReferenceImageNumber);
		tagByName.put("StartCumulativeMetersetWeight",TagFromName.StartCumulativeMetersetWeight);
		tagByName.put("EndCumulativeMetersetWeight",TagFromName.EndCumulativeMetersetWeight);
		tagByName.put("ReferencedBrachyApplicationSetupSequence",TagFromName.ReferencedBrachyApplicationSetupSequence);
		tagByName.put("ReferencedBrachyApplicationSetupNumber",TagFromName.ReferencedBrachyApplicationSetupNumber);
		tagByName.put("ReferencedSourceNumber",TagFromName.ReferencedSourceNumber);
		tagByName.put("ReferencedFractionGroupSequence",TagFromName.ReferencedFractionGroupSequence);
		tagByName.put("ReferencedFractionGroupNumber",TagFromName.ReferencedFractionGroupNumber);
		tagByName.put("ReferencedVerificationImageSequence",TagFromName.ReferencedVerificationImageSequence);
		tagByName.put("ReferencedReferenceImageSequence",TagFromName.ReferencedReferenceImageSequence);
		tagByName.put("ReferencedDoseReferenceSequence",TagFromName.ReferencedDoseReferenceSequence);
		tagByName.put("ReferencedDoseReferenceNumber",TagFromName.ReferencedDoseReferenceNumber);
		tagByName.put("BrachyReferencedDoseReferenceSequence",TagFromName.BrachyReferencedDoseReferenceSequence);
		tagByName.put("ReferencedStructureSetSequence",TagFromName.ReferencedStructureSetSequence);
		tagByName.put("ReferencedPatientSetupNumber",TagFromName.ReferencedPatientSetupNumber);
		tagByName.put("ReferencedDoseSequence",TagFromName.ReferencedDoseSequence);
		tagByName.put("ReferencedToleranceTableNumber",TagFromName.ReferencedToleranceTableNumber);
		tagByName.put("ReferencedBolusSequence",TagFromName.ReferencedBolusSequence);
		tagByName.put("ReferencedWedgeNumber",TagFromName.ReferencedWedgeNumber);
		tagByName.put("ReferencedCompensatorNumber",TagFromName.ReferencedCompensatorNumber);
		tagByName.put("ReferencedBlockNumber",TagFromName.ReferencedBlockNumber);
		tagByName.put("ReferencedControlPointIndex",TagFromName.ReferencedControlPointIndex);
		tagByName.put("ReferencedControlPointSequence",TagFromName.ReferencedControlPointSequence);
		tagByName.put("ReferencedStartControlPointIndex",TagFromName.ReferencedStartControlPointIndex);
		tagByName.put("ReferencedStopControlPointIndex",TagFromName.ReferencedStopControlPointIndex);
		tagByName.put("ReferencedRangeShifterNumber",TagFromName.ReferencedRangeShifterNumber);
		tagByName.put("ReferencedLateralSpreadingDeviceNumber",TagFromName.ReferencedLateralSpreadingDeviceNumber);
		tagByName.put("ReferencedRangeModulatorNumber",TagFromName.ReferencedRangeModulatorNumber);
		tagByName.put("OmittedBeamTaskSequence",TagFromName.OmittedBeamTaskSequence);
		tagByName.put("ReasonForOmission",TagFromName.ReasonForOmission);
		tagByName.put("ReasonForOmissionDescription",TagFromName.ReasonForOmissionDescription);
		tagByName.put("ApprovalStatus",TagFromName.ApprovalStatus);
		tagByName.put("ReviewDate",TagFromName.ReviewDate);
		tagByName.put("ReviewTime",TagFromName.ReviewTime);
		tagByName.put("ReviewerName",TagFromName.ReviewerName);
		tagByName.put("Arbitrary",TagFromName.Arbitrary);
		tagByName.put("TextComments",TagFromName.TextComments);
		tagByName.put("ResultsID",TagFromName.ResultsID);
		tagByName.put("ResultsIDIssuer",TagFromName.ResultsIDIssuer);
		tagByName.put("ReferencedInterpretationSequence",TagFromName.ReferencedInterpretationSequence);
		tagByName.put("ReportProductionStatusTrial",TagFromName.ReportProductionStatusTrial);
		tagByName.put("InterpretationRecordedDate",TagFromName.InterpretationRecordedDate);
		tagByName.put("InterpretationRecordedTime",TagFromName.InterpretationRecordedTime);
		tagByName.put("InterpretationRecorder",TagFromName.InterpretationRecorder);
		tagByName.put("ReferenceToRecordedSound",TagFromName.ReferenceToRecordedSound);
		tagByName.put("InterpretationTranscriptionDate",TagFromName.InterpretationTranscriptionDate);
		tagByName.put("InterpretationTranscriptionTime",TagFromName.InterpretationTranscriptionTime);
		tagByName.put("InterpretationTranscriber",TagFromName.InterpretationTranscriber);
		tagByName.put("InterpretationText",TagFromName.InterpretationText);
		tagByName.put("InterpretationAuthor",TagFromName.InterpretationAuthor);
		tagByName.put("InterpretationApproverSequence",TagFromName.InterpretationApproverSequence);
		tagByName.put("InterpretationApprovalDate",TagFromName.InterpretationApprovalDate);
		tagByName.put("InterpretationApprovalTime",TagFromName.InterpretationApprovalTime);
		tagByName.put("PhysicianApprovingInterpretation",TagFromName.PhysicianApprovingInterpretation);
		tagByName.put("InterpretationDiagnosisDescription",TagFromName.InterpretationDiagnosisDescription);
		tagByName.put("InterpretationDiagnosisCodeSequence",TagFromName.InterpretationDiagnosisCodeSequence);
		tagByName.put("ResultsDistributionListSequence",TagFromName.ResultsDistributionListSequence);
		tagByName.put("DistributionName",TagFromName.DistributionName);
		tagByName.put("DistributionAddress",TagFromName.DistributionAddress);
		tagByName.put("InterpretationID",TagFromName.InterpretationID);
		tagByName.put("InterpretationIDIssuer",TagFromName.InterpretationIDIssuer);
		tagByName.put("InterpretationTypeID",TagFromName.InterpretationTypeID);
		tagByName.put("InterpretationStatusID",TagFromName.InterpretationStatusID);
		tagByName.put("Impressions",TagFromName.Impressions);
		tagByName.put("ResultsComments",TagFromName.ResultsComments);
		tagByName.put("LowEnergyDetectors",TagFromName.LowEnergyDetectors);
		tagByName.put("HighEnergyDetectors",TagFromName.HighEnergyDetectors);
		tagByName.put("DetectorGeometrySequence",TagFromName.DetectorGeometrySequence);
		tagByName.put("ThreatROIVoxelSequence",TagFromName.ThreatROIVoxelSequence);
		tagByName.put("ThreatROIBase",TagFromName.ThreatROIBase);
		tagByName.put("ThreatROIExtents",TagFromName.ThreatROIExtents);
		tagByName.put("ThreatROIBitmap",TagFromName.ThreatROIBitmap);
		tagByName.put("RouteSegmentID",TagFromName.RouteSegmentID);
		tagByName.put("GantryType",TagFromName.GantryType);
		tagByName.put("OOIOwnerType",TagFromName.OOIOwnerType);
		tagByName.put("RouteSegmentSequence",TagFromName.RouteSegmentSequence);
		tagByName.put("PotentialThreatObjectID",TagFromName.PotentialThreatObjectID);
		tagByName.put("ThreatSequence",TagFromName.ThreatSequence);
		tagByName.put("ThreatCategory",TagFromName.ThreatCategory);
		tagByName.put("ThreatCategoryDescription",TagFromName.ThreatCategoryDescription);
		tagByName.put("ATDAbilityAssessment",TagFromName.ATDAbilityAssessment);
		tagByName.put("ATDAssessmentFlag",TagFromName.ATDAssessmentFlag);
		tagByName.put("ATDAssessmentProbability",TagFromName.ATDAssessmentProbability);
		tagByName.put("Mass",TagFromName.Mass);
		tagByName.put("Density",TagFromName.Density);
		tagByName.put("ZEffective",TagFromName.ZEffective);
		tagByName.put("BoardingPassID",TagFromName.BoardingPassID);
		tagByName.put("CenterOfMass",TagFromName.CenterOfMass);
		tagByName.put("CenterOfPTO",TagFromName.CenterOfPTO);
		tagByName.put("BoundingPolygon",TagFromName.BoundingPolygon);
		tagByName.put("RouteSegmentStartLocationID",TagFromName.RouteSegmentStartLocationID);
		tagByName.put("RouteSegmentEndLocationID",TagFromName.RouteSegmentEndLocationID);
		tagByName.put("RouteSegmentLocationIDType",TagFromName.RouteSegmentLocationIDType);
		tagByName.put("AbortReason",TagFromName.AbortReason);
		tagByName.put("VolumeOfPTO",TagFromName.VolumeOfPTO);
		tagByName.put("AbortFlag",TagFromName.AbortFlag);
		tagByName.put("RouteSegmentStartTime",TagFromName.RouteSegmentStartTime);
		tagByName.put("RouteSegmentEndTime",TagFromName.RouteSegmentEndTime);
		tagByName.put("TDRType",TagFromName.TDRType);
		tagByName.put("InternationalRouteSegment",TagFromName.InternationalRouteSegment);
		tagByName.put("ThreatDetectionAlgorithmAndVersion",TagFromName.ThreatDetectionAlgorithmAndVersion);
		tagByName.put("AssignedLocation",TagFromName.AssignedLocation);
		tagByName.put("AlarmDecisionTime",TagFromName.AlarmDecisionTime);
		tagByName.put("AlarmDecision",TagFromName.AlarmDecision);
		tagByName.put("NumberOfTotalObjects",TagFromName.NumberOfTotalObjects);
		tagByName.put("NumberOfAlarmObjects",TagFromName.NumberOfAlarmObjects);
		tagByName.put("PTORepresentationSequence",TagFromName.PTORepresentationSequence);
		tagByName.put("ATDAssessmentSequence",TagFromName.ATDAssessmentSequence);
		tagByName.put("TIPType",TagFromName.TIPType);
		tagByName.put("DICOSVersion",TagFromName.DICOSVersion);
		tagByName.put("OOIOwnerCreationTime",TagFromName.OOIOwnerCreationTime);
		tagByName.put("OOIType",TagFromName.OOIType);
		tagByName.put("OOISize",TagFromName.OOISize);
		tagByName.put("AcquisitionStatus",TagFromName.AcquisitionStatus);
		tagByName.put("BasisMaterialsCodeSequence",TagFromName.BasisMaterialsCodeSequence);
		tagByName.put("PhantomType",TagFromName.PhantomType);
		tagByName.put("OOIOwnerSequence",TagFromName.OOIOwnerSequence);
		tagByName.put("ScanType",TagFromName.ScanType);
		tagByName.put("ItineraryID",TagFromName.ItineraryID);
		tagByName.put("ItineraryIDType",TagFromName.ItineraryIDType);
		tagByName.put("ItineraryIDAssigningAuthority",TagFromName.ItineraryIDAssigningAuthority);
		tagByName.put("RouteID",TagFromName.RouteID);
		tagByName.put("RouteIDAssigningAuthority",TagFromName.RouteIDAssigningAuthority);
		tagByName.put("InboundArrivalType",TagFromName.InboundArrivalType);
		tagByName.put("CarrierID",TagFromName.CarrierID);
		tagByName.put("CarrierIDAssigningAuthority",TagFromName.CarrierIDAssigningAuthority);
		tagByName.put("SourceOrientation",TagFromName.SourceOrientation);
		tagByName.put("SourcePosition",TagFromName.SourcePosition);
		tagByName.put("BeltHeight",TagFromName.BeltHeight);
		tagByName.put("AlgorithmRoutingCodeSequence",TagFromName.AlgorithmRoutingCodeSequence);
		tagByName.put("TransportClassification",TagFromName.TransportClassification);
		tagByName.put("OOITypeDescriptor",TagFromName.OOITypeDescriptor);
		tagByName.put("TotalProcessingTime",TagFromName.TotalProcessingTime);
		tagByName.put("DetectorCalibrationData",TagFromName.DetectorCalibrationData);
		tagByName.put("AdditionalScreeningPerformed",TagFromName.AdditionalScreeningPerformed);
		tagByName.put("AdditionalInspectionSelectionCriteria",TagFromName.AdditionalInspectionSelectionCriteria);
		tagByName.put("AdditionalInspectionMethodSequence",TagFromName.AdditionalInspectionMethodSequence);
		tagByName.put("AITDeviceType",TagFromName.AITDeviceType);
		tagByName.put("QRMeasurementsSequence",TagFromName.QRMeasurementsSequence);
		tagByName.put("TargetMaterialSequence",TagFromName.TargetMaterialSequence);
		tagByName.put("SNRThreshold",TagFromName.SNRThreshold);
		tagByName.put("ImageScaleRepresentation",TagFromName.ImageScaleRepresentation);
		tagByName.put("ReferencedPTOSequence",TagFromName.ReferencedPTOSequence);
		tagByName.put("ReferencedTDRInstanceSequence",TagFromName.ReferencedTDRInstanceSequence);
		tagByName.put("PTOLocationDescription",TagFromName.PTOLocationDescription);
		tagByName.put("AnomalyLocatorIndicatorSequence",TagFromName.AnomalyLocatorIndicatorSequence);
		tagByName.put("AnomalyLocatorIndicator",TagFromName.AnomalyLocatorIndicator);
		tagByName.put("PTORegionSequence",TagFromName.PTORegionSequence);
		tagByName.put("InspectionSelectionCriteria",TagFromName.InspectionSelectionCriteria);
		tagByName.put("SecondaryInspectionMethodSequence",TagFromName.SecondaryInspectionMethodSequence);
		tagByName.put("PRCSToRCSOrientation",TagFromName.PRCSToRCSOrientation);
		tagByName.put("MACParametersSequence",TagFromName.MACParametersSequence);
		tagByName.put("CurveDimensions",TagFromName.CurveDimensions);
		tagByName.put("NumberOfPoints",TagFromName.NumberOfPoints);
		tagByName.put("TypeOfData",TagFromName.TypeOfData);
		tagByName.put("CurveDescription",TagFromName.CurveDescription);
		tagByName.put("AxisUnits",TagFromName.AxisUnits);
		tagByName.put("AxisLabels",TagFromName.AxisLabels);
		tagByName.put("DataValueRepresentation",TagFromName.DataValueRepresentation);
		tagByName.put("MinimumCoordinateValue",TagFromName.MinimumCoordinateValue);
		tagByName.put("MaximumCoordinateValue",TagFromName.MaximumCoordinateValue);
		tagByName.put("CurveRange",TagFromName.CurveRange);
		tagByName.put("CurveDataDescriptor",TagFromName.CurveDataDescriptor);
		tagByName.put("CoordinateStartValue",TagFromName.CoordinateStartValue);
		tagByName.put("CoordinateStepValue",TagFromName.CoordinateStepValue);
		tagByName.put("CurveActivationLayer",TagFromName.CurveActivationLayer);
		tagByName.put("AudioType",TagFromName.AudioType);
		tagByName.put("AudioSampleFormat",TagFromName.AudioSampleFormat);
		tagByName.put("NumberOfChannels",TagFromName.NumberOfChannels);
		tagByName.put("NumberOfSamples",TagFromName.NumberOfSamples);
		tagByName.put("SampleRate",TagFromName.SampleRate);
		tagByName.put("TotalTime",TagFromName.TotalTime);
		tagByName.put("AudioSampleData",TagFromName.AudioSampleData);
		tagByName.put("AudioComments",TagFromName.AudioComments);
		tagByName.put("CurveLabel",TagFromName.CurveLabel);
		tagByName.put("CurveReferencedOverlaySequence",TagFromName.CurveReferencedOverlaySequence);
		tagByName.put("CurveReferencedOverlayGroup",TagFromName.CurveReferencedOverlayGroup);
		tagByName.put("CurveData",TagFromName.CurveData);
		tagByName.put("SharedFunctionalGroupsSequence",TagFromName.SharedFunctionalGroupsSequence);
		tagByName.put("PerFrameFunctionalGroupsSequence",TagFromName.PerFrameFunctionalGroupsSequence);
		tagByName.put("WaveformSequence",TagFromName.WaveformSequence);
		tagByName.put("ChannelMinimumValue",TagFromName.ChannelMinimumValue);
		tagByName.put("ChannelMaximumValue",TagFromName.ChannelMaximumValue);
		tagByName.put("WaveformBitsAllocated",TagFromName.WaveformBitsAllocated);
		tagByName.put("WaveformSampleInterpretation",TagFromName.WaveformSampleInterpretation);
		tagByName.put("WaveformPaddingValue",TagFromName.WaveformPaddingValue);
		tagByName.put("WaveformData",TagFromName.WaveformData);
		tagByName.put("FirstOrderPhaseCorrectionAngle",TagFromName.FirstOrderPhaseCorrectionAngle);
		tagByName.put("SpectroscopyData",TagFromName.SpectroscopyData);
		tagByName.put("OverlayRows",TagFromName.OverlayRows);
		tagByName.put("OverlayColumns",TagFromName.OverlayColumns);
		tagByName.put("OverlayPlanes",TagFromName.OverlayPlanes);
		tagByName.put("NumberOfFramesInOverlay",TagFromName.NumberOfFramesInOverlay);
		tagByName.put("OverlayDescription",TagFromName.OverlayDescription);
		tagByName.put("OverlayType",TagFromName.OverlayType);
		tagByName.put("OverlaySubtype",TagFromName.OverlaySubtype);
		tagByName.put("OverlayOrigin",TagFromName.OverlayOrigin);
		tagByName.put("ImageFrameOrigin",TagFromName.ImageFrameOrigin);
		tagByName.put("OverlayPlaneOrigin",TagFromName.OverlayPlaneOrigin);
		tagByName.put("OverlayCompressionCode",TagFromName.OverlayCompressionCode);
		tagByName.put("OverlayCompressionOriginator",TagFromName.OverlayCompressionOriginator);
		tagByName.put("OverlayCompressionLabel",TagFromName.OverlayCompressionLabel);
		tagByName.put("OverlayCompressionDescription",TagFromName.OverlayCompressionDescription);
		tagByName.put("OverlayCompressionStepPointers",TagFromName.OverlayCompressionStepPointers);
		tagByName.put("OverlayRepeatInterval",TagFromName.OverlayRepeatInterval);
		tagByName.put("OverlayBitsGrouped",TagFromName.OverlayBitsGrouped);
		tagByName.put("OverlayBitsAllocated",TagFromName.OverlayBitsAllocated);
		tagByName.put("OverlayBitPosition",TagFromName.OverlayBitPosition);
		tagByName.put("OverlayFormat",TagFromName.OverlayFormat);
		tagByName.put("OverlayLocation",TagFromName.OverlayLocation);
		tagByName.put("OverlayCodeLabel",TagFromName.OverlayCodeLabel);
		tagByName.put("OverlayNumberOfTables",TagFromName.OverlayNumberOfTables);
		tagByName.put("OverlayCodeTableLocation",TagFromName.OverlayCodeTableLocation);
		tagByName.put("OverlayBitsForCodeWord",TagFromName.OverlayBitsForCodeWord);
		tagByName.put("OverlayActivationLayer",TagFromName.OverlayActivationLayer);
		tagByName.put("OverlayDescriptorGray",TagFromName.OverlayDescriptorGray);
		tagByName.put("OverlayDescriptorRed",TagFromName.OverlayDescriptorRed);
		tagByName.put("OverlayDescriptorGreen",TagFromName.OverlayDescriptorGreen);
		tagByName.put("OverlayDescriptorBlue",TagFromName.OverlayDescriptorBlue);
		tagByName.put("OverlayGray",TagFromName.OverlayGray);
		tagByName.put("OverlayRed",TagFromName.OverlayRed);
		tagByName.put("OverlayGreen",TagFromName.OverlayGreen);
		tagByName.put("OverlayBlue",TagFromName.OverlayBlue);
		tagByName.put("ROIArea",TagFromName.ROIArea);
		tagByName.put("ROIMean",TagFromName.ROIMean);
		tagByName.put("ROIStandardDeviation",TagFromName.ROIStandardDeviation);
		tagByName.put("OverlayLabel",TagFromName.OverlayLabel);
		tagByName.put("OverlayData",TagFromName.OverlayData);
		tagByName.put("OverlayComments",TagFromName.OverlayComments);
		tagByName.put("FloatPixelData",TagFromName.FloatPixelData);
		tagByName.put("DoubleFloatPixelData",TagFromName.DoubleFloatPixelData);
		tagByName.put("PixelData",TagFromName.PixelData);
		tagByName.put("CoefficientsSDVN",TagFromName.CoefficientsSDVN);
		tagByName.put("CoefficientsSDHN",TagFromName.CoefficientsSDHN);
		tagByName.put("CoefficientsSDDN",TagFromName.CoefficientsSDDN);
		tagByName.put("VariablePixelData",TagFromName.VariablePixelData);
		tagByName.put("VariableNextDataGroup",TagFromName.VariableNextDataGroup);
		tagByName.put("VariableCoefficientsSDVN",TagFromName.VariableCoefficientsSDVN);
		tagByName.put("VariableCoefficientsSDHN",TagFromName.VariableCoefficientsSDHN);
		tagByName.put("VariableCoefficientsSDDN",TagFromName.VariableCoefficientsSDDN);
		tagByName.put("DigitalSignaturesSequence",TagFromName.DigitalSignaturesSequence);
		tagByName.put("DataSetTrailingPadding",TagFromName.DataSetTrailingPadding);
		
		// include old toolkit keywords prior to CP 850 establishment of official keywords, in case old code uses them ...
		
		tagByName.put("FileSetCharacterSet",TagFromName.SpecificCharacterSetOfFileSetDescriptorFile);
		tagByName.put("RootDirectoryFirstRecord",TagFromName.OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity);
		tagByName.put("RootDirectoryLastRecord",TagFromName.OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity);
		tagByName.put("NextDirectoryRecordOffset",TagFromName.OffsetOfTheNextDirectoryRecord);
		tagByName.put("LowerLevelDirectoryOffset",TagFromName.OffsetOfReferencedLowerLevelDirectoryEntity);
		tagByName.put("ReferringPhysicianTelephoneNumber",TagFromName.ReferringPhysicianTelephoneNumbers);
		tagByName.put("PhysicianOfRecord",TagFromName.PhysiciansOfRecord);
		tagByName.put("PhysicianOfRecordIdentificationSequence",TagFromName.PhysiciansOfRecordIdentificationSequence);
		tagByName.put("PhysicianReadingStudy",TagFromName.NameOfPhysiciansReadingStudy);
		tagByName.put("PhysicianReadingStudyIdentificationSequence",TagFromName.PhysiciansReadingStudyIdentificationSequence);
		tagByName.put("OperatorName",TagFromName.OperatorsName);
		tagByName.put("OldLossyImageCompression",TagFromName.LossyImageCompressionRetired);
		tagByName.put("EventElapsedTime",TagFromName.EventElapsedTimes);
		tagByName.put("EventTimerName",TagFromName.EventTimerNames);
		tagByName.put("OtherPatientID",TagFromName.OtherPatientIDs);
		tagByName.put("OtherPatientName",TagFromName.OtherPatientNames);
		tagByName.put("OtherPatientIDSequence",TagFromName.OtherPatientIDsSequence);
		tagByName.put("PatientTelephoneNumber",TagFromName.PatientTelephoneNumbers);
		tagByName.put("EchoNumber",TagFromName.EchoNumbers);
		tagByName.put("SecondaryCaptureDeviceSoftwareVersion",TagFromName.SecondaryCaptureDeviceSoftwareVersions);
		tagByName.put("SoftwareVersion",TagFromName.SoftwareVersions);
		tagByName.put("FocalSpot",TagFromName.FocalSpots);
		tagByName.put("VerticesOfPolygonalShutter",TagFromName.VerticesOfThePolygonalShutter);
		tagByName.put("VerticesOfPolygonalCollimator",TagFromName.VerticesOfThePolygonalCollimator);
		tagByName.put("MultiplanarExcitation",TagFromName.MultiPlanarExcitation);
		tagByName.put("MetaboliteCodeSequence",TagFromName.MetaboliteMapCodeSequence);
		tagByName.put("ChemicalShiftMinimumIntegrationLimitInPPM",TagFromName.ChemicalShiftMinimumIntegrationLimitInppm);
		tagByName.put("ChemicalShiftMaximumIntegrationLimitInPPM",TagFromName.ChemicalShiftMaximumIntegrationLimitInppm);
		tagByName.put("VerticesOfPolygonalExposureControlSensingRegion",TagFromName.VerticesOfThePolygonalExposureControlSensingRegion);
		tagByName.put("DiffusionBMatrixValueXX",TagFromName.DiffusionBValueXX);
		tagByName.put("DiffusionBMatrixValueXY",TagFromName.DiffusionBValueXY);
		tagByName.put("DiffusionBMatrixValueXZ",TagFromName.DiffusionBValueXZ);
		tagByName.put("DiffusionBMatrixValueYY",TagFromName.DiffusionBValueYY);
		tagByName.put("DiffusionBMatrixValueYZ",TagFromName.DiffusionBValueYZ);
		tagByName.put("DiffusionBMatrixValueZZ",TagFromName.DiffusionBValueZZ);
		tagByName.put("ReportNumberTrial",TagFromName.ReportNumber);
		tagByName.put("PatientFrameofReferenceSource",TagFromName.PatientFrameOfReferenceSource);
		tagByName.put("PatientEyeMovementCommandedCodeSequence",TagFromName.PatientEyeMovementCommandCodeSequence);
		tagByName.put("AxialLengthOfEye",TagFromName.AxialLengthOfTheEye);
		tagByName.put("SmallestPixelValueInPlane",TagFromName.SmallestImagePixelValueInPlane);
		tagByName.put("LargestPixelValueInPlane",TagFromName.LargestImagePixelValueInPlane);
		tagByName.put("BiplaneAcquisitionSequence",TagFromName.BiPlaneAcquisitionSequence);
		tagByName.put("MaskPointer",TagFromName.MaskPointers);
		tagByName.put("MultiframePresentationSequence",TagFromName.MultiFramePresentationSequence);
		tagByName.put("CommentsOnPerformedProcedureStep",TagFromName.CommentsOnThePerformedProcedureStep);
		tagByName.put("CommentsOnScheduledProcedureStep",TagFromName.CommentsOnTheScheduledProcedureStep);
		tagByName.put("ReasonForRequestedProcedure",TagFromNam