/* Tic-Tac-Toe plasmoid
 * Copyright (C) 2009 Mauro E. Bender <mbender@dc.uba.ar>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "appearanceSettings.h"
#include <QVBoxLayout>
#include <QGroupBox>
#include <klocalizedstring.h>

AppearanceSettings::AppearanceSettings( Plasma::Svg *xoSvg, Theme currentTheme, QWidget *parent ) : QWidget( parent ) {
	_currentTheme = currentTheme;
	
	_comboBox = new QComboBox;
	_comboBox->addItem( xoSvg->pixmap( QString("x_%1").arg( GRAY ) ), "Gray" );
	_comboBox->addItem( xoSvg->pixmap( QString("x_%1").arg( ORANGE ) ), "Orange" );
	_comboBox->addItem( xoSvg->pixmap( QString("x_%1").arg( GREEN ) ), "Green" );
	_comboBox->addItem( xoSvg->pixmap( QString("x_%1").arg( WHITE ) ), "White" );
	_comboBox->setIconSize( QSize(50,50) );
	_comboBox->setCurrentIndex( currentTheme );
	
	QGroupBox *grpBox1 = new QGroupBox( i18n("Themes") );
	QVBoxLayout *lyCB = new QVBoxLayout;
	lyCB->addWidget( _comboBox );
	grpBox1->setLayout( lyCB );
	
	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget( grpBox1 );
	
	setLayout( mainLayout );
}

void AppearanceSettings::setCurrentTheme( Theme currentTheme ){
	_currentTheme = currentTheme;
}

Theme AppearanceSettings::getCurrentTheme(){
	return (Theme) _comboBox->currentIndex();
}