/*************************************************
*    The PMW Music Typesetter - 3rd incarnation  *
*************************************************/

/* Copyright (c) Philip Hazel, 2013 */

/* This file contains one function, which sets up the current version string,
the version in binary for comparison, and the copyright string. The version
string includes the date of compilation. It is a fiddly bit of code, but we
want the string in a particular format. */

#include "pmwhdr.h"

#define version    4270      /* In fixed-point format */
#define COPYRIGHT  US"Copyright (c) Philip Hazel 2013"

void version_init(void)
{
uschar today[20];
copyright = COPYRIGHT;
Ustrcpy(today, __DATE__);
if (today[4] == ' ') today[4] = '0';
today[3] = today[6] = '-';
version_fixed  = version;
format_sprintf(version_string, "%f%s (Built ", version,
  (version%1000 == 0)? ".00" : (version%100 == 0)? "0" : "");
Ustrncat(version_string, today + 4, 3);
Ustrncat(version_string, today, 4);
Ustrncat(version_string, today + 7, 4);
Ustrcat(version_string, ")");
}

/* End of version.c */
