#!/bin/sh
### BEGIN INIT INFO
# Provides:          popfile
# Required-Start:    $local_fs $network
# Required-Stop:     $local_fs $network
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Start popfile proxy/daemon
### END INIT INFO


PATH=/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/share/popfile/start_popfile.sh
NAME=popfile
DESC=popfile
PIDFILE=/var/run/popfile/popfile.pid

test -f $DAEMON || exit 0

set -e

if [ -e /etc/default/popfile ]
then
	. /etc/default/popfile
fi

if [ ! -d /var/run/popfile ] ; then
	install -o popfile -g popfile -m 755 -d /var/run/popfile || return 2
fi

EXTRA_OPTS=
if [ "$NICE_LEVEL" != "" ]
then
	EXTRA_OPTS="$EXTRA_OPTS --nicelevel $NICE_LEVEL"
fi

start() {
	echo -n "Starting $DESC: "
	NOSTART=0
	if [ -e $PIDFILE ]; then
		if kill -0 `cat $PIDFILE` >/dev/null 2>&1; then
			echo "$NAME already running."
			NOSTART=1
		fi
	fi
	if [ "$NOSTART" = "0" ]; then
		start-stop-daemon --start --exec $DAEMON --pidfile $PIDFILE \
			--chuid popfile --background --oknodo $EXTRA_OPTS -- $DAEMON_OPTS
		echo "$NAME."
	fi
}

stop() {
	echo -n "Stopping $DESC: "
	if [ -e $PIDFILE ]; then
		start-stop-daemon --stop --pidfile $PIDFILE --retry 60 --oknodo
		echo "$NAME."
	else
		echo "$NAME not running."
	fi
}

case "$1" in
  start)
	start
	;;
  stop)
	stop
	;;
  restart|force-reload)
	stop
	sleep 1
	start
	;;
  *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
