require 'spec_helper'

describe 'neutron::db::sync' do

  shared_examples_for 'neutron-dbsync' do

    it 'runs neutron-db-sync' do
      is_expected.to contain_exec('neutron-db-sync').with(
        :command     => 'neutron-db-manage --config-file /etc/neutron/neutron.conf --config-file /etc/neutron/plugin.ini upgrade head',
        :path        => '/usr/bin',
        :refreshonly => 'true',
        :logoutput   => 'on_failure'
      )
    end

    describe "overriding extra_params" do
    let :params do
      {
        :extra_params => '--config-file /etc/neutron/neutron.conf',
      }
    end

    it {
        is_expected.to contain_exec('neutron-db-sync').with(
          :command     => 'neutron-db-manage --config-file /etc/neutron/neutron.conf upgrade head',
          :path        => '/usr/bin',
          :refreshonly => 'true',
          :logoutput   => 'on_failure'
        )
    }
    end

  end

  context 'on a RedHat osfamily' do
    let :facts do
      {
        :osfamily                 => 'RedHat',
        :operatingsystemrelease   => '7.0',
        :concat_basedir => '/var/lib/puppet/concat'
      }
    end

    it_configures 'neutron-dbsync'
  end

  context 'on a Debian osfamily' do
    let :facts do
      {
        :operatingsystemrelease => '7.8',
        :operatingsystem        => 'Debian',
        :osfamily               => 'Debian',
        :concat_basedir => '/var/lib/puppet/concat'
      }
    end

    it_configures 'neutron-dbsync'
  end

end
