# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .format_write_settings_py3 import FormatWriteSettings


class JsonWriteSettings(FormatWriteSettings):
    """Json write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.
    :type type: str
    :param file_pattern: File pattern of JSON. This setting controls the way a
     collection of JSON objects will be treated. The default value is
     'setOfObjects'. It is case-sensitive. Possible values include:
     'setOfObjects', 'arrayOfObjects'
    :type file_pattern: str or
     ~azure.mgmt.datafactory.models.JsonWriteFilePattern
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'file_pattern': {'key': 'filePattern', 'type': 'str'},
    }

    def __init__(self, *, type: str, additional_properties=None, file_pattern=None, **kwargs) -> None:
        super(JsonWriteSettings, self).__init__(additional_properties=additional_properties, type=type, **kwargs)
        self.file_pattern = file_pattern
