# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.mongocluster import MongoClusterMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMongoClusterMgmtUsersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MongoClusterMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_users_get(self, resource_group):
        response = self.client.users.get(
            resource_group_name=resource_group.name,
            mongo_cluster_name="str",
            user_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_users_begin_create_or_update(self, resource_group):
        response = self.client.users.begin_create_or_update(
            resource_group_name=resource_group.name,
            mongo_cluster_name="str",
            user_name="str",
            resource={
                "id": "str",
                "name": "str",
                "properties": {
                    "identityProvider": "identity_provider",
                    "provisioningState": "str",
                    "roles": [{"db": "str", "role": "str"}],
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_users_begin_delete(self, resource_group):
        response = self.client.users.begin_delete(
            resource_group_name=resource_group.name,
            mongo_cluster_name="str",
            user_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_users_list_by_mongo_cluster(self, resource_group):
        response = self.client.users.list_by_mongo_cluster(
            resource_group_name=resource_group.name,
            mongo_cluster_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
