#! /usr/bin/env python
"""
setup.py - Setup package with the help Python's DistUtils

$Id: setup.py,v 1.7 2003/05/23 17:13:53 michael Exp $
"""

import sys,os
from distutils.core import setup

##################################################################
# Weird Hack to grab release version from local dir
##################################################################
exec_startdir = os.path.dirname(os.path.abspath(sys.argv[0]))
package_init_file_name = reduce(os.path.join,[exec_startdir,'pyweblib','__init__.py'])
f = open(package_init_file_name,'r')
s = f.readline()
while s:
  s = f.readline().strip()
  if s[0:11]=='__version__':
    version = eval(s.split('=')[1])
    break
  s = f.readline()
f.close()

sys.path.insert(0,os.getcwd())

import pyweblib

setup(
  #-- Package description
  name = 'pyweblib',
  license = 'GPL (GNU GENERAL PUBLIC LICENSE) Version 2',
  version = version,
  description = 'web application library',
  long_description = """Web application library:
pyweblib.forms        class library for handling <FORM> input
pyweblib.session      server-side web session handling
pyweblib.helper       misc. stuff useful in CGI-BINs
pyweblib.sslenv       retrieves SSL-related env vars
pyweblib.httphelper   very basic HTTP functions
""",
  author = 'Michael Stroeder', 
  author_email = 'michael@stroeder.com',
  maintainer = 'Michael Stroeder', 
  maintainer_email = 'michael@stroeder.com',
  url = 'http://www.stroeder.com/pylib/PyWebLib/',
  packages = ['pyweblib'],
#  keywords = ['web programming','CGI-BIN','session handling','form handling']
)

