/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "userlisticonformat.h"

#include "globals.h"

UserListIconFormat::UserListIconFormat(int tw, int th,
                                       int sw, int sh, int sx, int sy,
                                       int gw, int gh, int gx, int gy,
                                       int aw, int ah, int ax, int ay) :
  m_totalWidth   (tw),
  m_totalHeight  (th),
  m_statusWidth  (sw),
  m_statusHeight (sh),
  m_statusXoffset(sx),
  m_statusYoffset(sy),
  m_genderWidth  (gw),
  m_genderHeight (gh),
  m_genderXoffset(gx),
  m_genderYoffset(gy),
  m_avatarWidth  (aw),
  m_avatarHeight (ah),
  m_avatarXoffset(ax),
  m_avatarYoffset(ay),
  m_text         ("%nick")
{
}

UserListIconFormat::~UserListIconFormat()
{
}

QByteArray UserListIconFormat::save() const
{
  QByteArray ba;
  char size[2];

  catUS2str(size, m_text.toUtf8().size());

  ba.append(m_totalWidth);
  ba.append(m_totalHeight);
  ba.append(m_statusWidth);
  ba.append(m_statusHeight);
  ba.append(m_genderWidth);
  ba.append(m_genderHeight);
  ba.append(m_statusXoffset);
  ba.append(m_statusYoffset);
  ba.append(m_genderXoffset);
  ba.append(m_genderYoffset);
  ba.append(m_avatarWidth);
  ba.append(m_avatarHeight);
  ba.append(m_avatarXoffset);
  ba.append(m_avatarYoffset);

  ba.append(size[0]);
  ba.append(size[1]);

  ba.append(m_text.toUtf8());

  return ba;
}

bool UserListIconFormat::restore(const QByteArray & ba)
{
  char sizeArr[2];
  int  size;

  if(ba.size() < 14)
    return false;

  m_totalWidth    = ba[0];
  m_totalHeight   = ba[1];
  m_statusWidth   = ba[2];
  m_statusHeight  = ba[3];
  m_genderWidth   = ba[4];
  m_genderHeight  = ba[5];

  m_statusXoffset = ba[6];
  m_statusYoffset = ba[7];
  m_genderXoffset = ba[8];
  m_genderYoffset = ba[9];

  m_avatarWidth   = ba[10];
  m_avatarHeight  = ba[11];
  m_avatarXoffset = ba[12];
  m_avatarYoffset = ba[13];

  if(ba.size() < 16)
    return false;

  sizeArr[0]      = ba[14];
  sizeArr[1]      = ba[15];

  size = str2US(sizeArr);

  if(ba.size() < 16 + size)
    return false;

  m_text = QString().fromUtf8(ba.right(size));

  return true;
}

