########################################################################
#
# File:   previous_testrun.py
# Author: Stefan Seefeld
# Date:   2006-11-16
#
# Contents:
#   QMTest PreviousTestRun extension class.
#
# Copyright (c) 2006 by CodeSourcery, Inc.  All rights reserved. 
#
# For license terms see the file COPYING.
#
########################################################################

########################################################################
# Imports
########################################################################

from qm.fields import TextField, PythonField
from qm.test.expectation_database import ExpectationDatabase
from qm.test.result import Result
from qm.test.base import load_results

########################################################################
# Classes
########################################################################

class PreviousTestRun(ExpectationDatabase):
    """A 'PreviousTestRun' uses test results as expectations.

    A 'PreviousTestRun' uses a ResultsFile such as generated by
    'qmtest run' to determine the expected outcome for the current
    test run."""

    file_name = TextField(description="The name of the results file.")
    results_file = PythonField("The results file.")


    def __init__(self, **args):

        super(PreviousTestRun, self).__init__(**args)
        if not self.results_file:
            self.results_file = open(self.file_name, "rb")
        results = load_results(self.results_file, self.test_database)
        self._results = {}
        for r in results:
            # Keep test results only.
            if r.GetKind() == Result.TEST:
                self._results[r.GetId()] = r

        
    def Lookup(self, test_id):

        return self._results.get(test_id) or Result(Result.TEST, test_id)
