% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip.r
\name{filter}
\alias{filter}
\title{Return rows with matching conditions}
\usage{
filter(.data, ..., .preserve = FALSE)
}
\arguments{
\item{.data}{A tbl. All main verbs are S3 generics and provide methods
for \code{\link[=tbl_df]{tbl_df()}}, \code{\link[dtplyr:tbl_dt]{dtplyr::tbl_dt()}} and \code{\link[dbplyr:tbl_dbi]{dbplyr::tbl_dbi()}}.}

\item{...}{Logical predicates defined in terms of the variables in \code{.data}.
Multiple conditions are combined with \code{&}. Only rows where the
condition evaluates to \code{TRUE} are kept.

The arguments in \code{...} are automatically \link[rlang:quo]{quoted} and
\link[rlang:eval_tidy]{evaluated} in the context of the data
frame. They support \link[rlang:quasiquotation]{unquoting} and
splicing. See \code{vignette("programming")} for an introduction to
these concepts.}

\item{.preserve}{when \code{FALSE} (the default), the grouping structure
is recalculated based on the resulting data, otherwise it is kept as is.}
}
\value{
An object of the same class as \code{.data}.
}
\description{
Use \code{filter()} to choose rows/cases where conditions are true. Unlike
base subsetting with \code{[}, rows where the condition evaluates to \code{NA} are
dropped.
}
\details{
Note that dplyr is not yet smart enough to optimise filtering optimisation
on grouped datasets that don't need grouped calculations. For this reason,
filtering is often considerably faster on \code{\link[=ungroup]{ungroup()}}ed data.
}
\section{Useful filter functions}{

\itemize{
\item \code{\link{==}}, \code{\link{>}}, \code{\link{>=}} etc
\item \code{\link{&}}, \code{\link{|}}, \code{\link{!}}, \code{\link[=xor]{xor()}}
\item \code{\link[=is.na]{is.na()}}
\item \code{\link[=between]{between()}}, \code{\link[=near]{near()}}
}
}

\section{Grouped tibbles}{


Because filtering expressions are computed within groups, they may
yield different results on grouped tibbles. This will be the case
as soon as an aggregating, lagging, or ranking function is
involved. Compare this ungrouped filtering:\preformatted{starwars \%>\% filter(mass > mean(mass, na.rm = TRUE))
}

With the grouped equivalent:\preformatted{starwars \%>\% group_by(gender) \%>\% filter(mass > mean(mass, na.rm = TRUE))
}

The former keeps rows with \code{mass} greater than the global average
whereas the latter keeps rows with \code{mass} greater than the gender
average.

It is valid to use grouping variables in filter expressions.

When applied on a grouped tibble, \code{filter()} automatically \link[=arrange]{rearranges}
the tibble by groups for performance reasons.
}

\section{Tidy data}{

When applied to a data frame, row names are silently dropped. To preserve,
convert to an explicit variable with \code{\link[tibble:rownames_to_column]{tibble::rownames_to_column()}}.
}

\section{Scoped filtering}{

The three \link{scoped} variants (\code{\link[=filter_all]{filter_all()}}, \code{\link[=filter_if]{filter_if()}} and
\code{\link[=filter_at]{filter_at()}}) make it easy to apply a filtering condition to a
selection of variables.
}

\examples{
filter(starwars, species == "Human")
filter(starwars, mass > 1000)

# Multiple criteria
filter(starwars, hair_color == "none" & eye_color == "black")
filter(starwars, hair_color == "none" | eye_color == "black")

# Multiple arguments are equivalent to and
filter(starwars, hair_color == "none", eye_color == "black")


# The filtering operation may yield different results on grouped
# tibbles because the expressions are computed within groups.
#
# The following filters rows where `mass` is greater than the
# global average:
starwars \%>\% filter(mass > mean(mass, na.rm = TRUE))

# Whereas this keeps rows with `mass` greater than the gender
# average:
starwars \%>\% group_by(gender) \%>\% filter(mass > mean(mass, na.rm = TRUE))


# Refer to column names stored as strings with the `.data` pronoun:
vars <- c("mass", "height")
cond <- c(80, 150)
starwars \%>\%
  filter(
    .data[[vars[[1]]]] > cond[[1]],
    .data[[vars[[2]]]] > cond[[2]]
  )

# For more complex cases, knowledge of tidy evaluation and the
# unquote operator `!!` is required. See https://tidyeval.tidyverse.org/
#
# One useful and simple tidy eval technique is to use `!!` to bypass
# the data frame and its columns. Here is how to filter the columns
# `mass` and `height` relative to objects of the same names:
mass <- 80
height <- 150
filter(starwars, mass > !!mass, height > !!height)
}
\seealso{
\code{\link[=filter_all]{filter_all()}}, \code{\link[=filter_if]{filter_if()}} and \code{\link[=filter_at]{filter_at()}}.

Other single table verbs: \code{\link{arrange}},
  \code{\link{mutate}}, \code{\link{select}},
  \code{\link{slice}}, \code{\link{summarise}}
}
\concept{single table verbs}
