% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunks.R
\name{makeChunks}
\alias{makeChunks}
\title{Create Chunks of Index Vectors}
\usage{
makeChunks(
  nbrOfElements,
  nbrOfWorkers,
  future.scheduling = 1,
  future.chunk.size = NULL
)
}
\arguments{
\item{nbrOfElements}{(integer) Total number of elements to iterate over.}

\item{future.scheduling}{(numeric) A strictly positive scalar.
Only used if argument \code{future.chunk.size} is \code{NULL}.}

\item{future.chunk.size}{(numeric) The maximum number of elements per
chunk, or \code{NULL}.  If \code{NULL}, then the chunk sizes are given by the
\code{future.scheduling} argument.}

\item{nbrOfWorker}{(integer) Number of workers available.}
}
\value{
A list of chunks, where each chunk is an integer vector of
unique indices \code{[1, nbrOfElements]}.  The union of all chunks
holds \code{nbrOfElements} elements and equals \code{1:nbrOfElements}.
If \code{nbrOfElements == 0}, then an empty list is returned.
}
\description{
\emph{This is an internal function.}
}
\section{Control processing order of elements}{

Attribute \code{ordering} of \code{future.chunk.size} or \code{future.scheduling} can
be used to control the ordering the elements are iterated over, which
only affects the processing order \emph{not} the order values are returned.
This attribute can take the following values:
\itemize{
\item index vector - an numeric vector of length \code{nbrOfElements} specifying
how elements are remapped
\item function     - an function taking one argument which is called as
\code{ordering(nbrOfElements)} and which much return an
index vector of length \code{nbrOfElements}, e.g.
\code{function(n) rev(seq_len(n))} for reverse ordering.
\item \code{"random"}   - this will randomize the ordering via random index
vector \code{sample.int(nbrOfElements)}.
}
}

\keyword{internal}
