% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fold.R
\name{fold}
\alias{fold}
\title{Efficient fold / reduce / accumulate / combine of a vector}
\usage{
fold(x, f, left = TRUE, unname = TRUE, threshold = 1000L)
}
\arguments{
\item{x}{A vector.}

\item{f}{A binary function, i.e. a function take takes two arguments.}

\item{left}{If `TRUE`, vector is combined from the left (the first element),
otherwise the right (the last element).}

\item{unname}{If `TRUE`, function `f` is called as `f(unname(y), x[[ii]])`,
otherwise as `f(y, x[[ii]])`, which may introduce name `"y"`.}

\item{threshold}{An integer (>= 2) specifying the length where the
recursive divide'and'conquer call will stop and incremental building of
the partial value is performed.  Using `threshold = +Inf` will disable
recursive folding.}
}
\value{
A vector.
}
\description{
Efficient fold / reduce / accumulate / combine of a vector
}
\details{
In order for recursive folding to give the same results as non-recursive
folding, binary function `f` must be _associative_ with itself, i.e.
`f(f(x[[1]], x[[2]]), x[[3]])` equals `f(x[[1]], f(x[[2]]), x[[3]])`.

This function is a more efficient (memory and speed) of
[`base::Reduce(f, x, right = !left, accumulate = FALSE)`][base::Reduce],
especially when `x` is long.
}
