% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs4_auth.R
\name{gs4_scopes}
\alias{gs4_scopes}
\title{Produce scopes specific to the Sheets API}
\usage{
gs4_scopes(scopes = NULL)
}
\arguments{
\item{scopes}{One or more API scopes. Each scope can be specified in full or,
for Sheets API-specific scopes, in an abbreviated form that is recognized by
\code{\link[=gs4_scopes]{gs4_scopes()}}:
\itemize{
\item "spreadsheets" = "https://www.googleapis.com/auth/spreadsheets"
(the default)
\item "spreadsheets.readonly" =
"https://www.googleapis.com/auth/spreadsheets.readonly"
\item "drive" = "https://www.googleapis.com/auth/drive"
\item "drive.readonly" = "https://www.googleapis.com/auth/drive.readonly"
\item "drive.file" = "https://www.googleapis.com/auth/drive.file"
}

See
\url{https://developers.google.com/identity/protocols/oauth2/scopes#sheets} for
details on the permissions for each scope.}
}
\value{
A character vector of scopes.
}
\description{
When called with no arguments, \code{gs4_scopes()} returns a named character
vector of scopes associated with the Sheets API. If \code{gs4_scopes(scopes =)} is
given, an abbreviated entry such as \code{"sheets.readonly"} is expanded to a full
scope (\code{"https://www.googleapis.com/auth/sheets.readonly"} in this case).
Unrecognized scopes are passed through unchanged.
}
\examples{
gs4_scopes("spreadsheets")
gs4_scopes("spreadsheets.readonly")
gs4_scopes("drive")
gs4_scopes()
}
\seealso{
\url{https://developers.google.com/identity/protocols/oauth2/scopes#sheets} for
details on the permissions for each scope.

Other auth functions: 
\code{\link{gs4_auth_configure}()},
\code{\link{gs4_auth}()},
\code{\link{gs4_deauth}()}
}
\concept{auth functions}
