% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FailureModel.R
\name{FailureModel}
\alias{FailureModel}
\title{Failure model.}
\description{
A subclass of \link{WrappedModel}. It is created
\itemize{
\item if you set the respective option in \link{configureMlr} -
when a model internally crashed during training.
The model always predicts NAs.
}

The if mlr option \code{on.error.dump} is \code{TRUE}, the
\code{FailureModel} contains the debug trace of the error.
It can be accessed with \code{getFailureModelDump} and
inspected with \code{debugger}.

Its encapsulated \code{learner.model} is simply a string:
The error message that was generated when the model crashed.
The following code shows how to access the message.
}
\examples{
configureMlr(on.learner.error = "warn")
data = iris
data$newfeat = 1 # will make LDA crash
task = makeClassifTask(data = data, target = "Species")
m = train("classif.lda", task) # LDA crashed, but mlr catches this
print(m)
print(m$learner.model) # the error message
p = predict(m, task) # this will predict NAs
print(p)
print(performance(p))
configureMlr(on.learner.error = "stop")
}
\seealso{
Other debug: 
\code{\link{ResampleResult}},
\code{\link{getPredictionDump}()},
\code{\link{getRRDump}()}
}
\concept{debug}
