% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.order.R
\name{list.sort}
\alias{list.sort}
\title{Sort a list by given expressions}
\usage{
list.sort(.data, ..., na.last = NA)
}
\arguments{
\item{.data}{a \code{list} or \code{vector}}

\item{...}{A group of lambda expressions. For each expression, the data
is sorted ascending by default unless the expression is enclosed by ().}

\item{na.last}{The way to deal with \code{NA}s.}
}
\description{
Sort a list by given expressions
}
\examples{
x <- list(p1 = list(type='A',score=list(c1=10,c2=8)),
       p2 = list(type='B',score=list(c1=9,c2=9)),
       p3 = list(type='B',score=list(c1=9,c2=7)))
list.sort(x, type, (score$c2)) # sort by score$c2 in descending order
list.sort(x, min(score$c1,score$c2))
}
\seealso{
\code{\link{list.order}}
}

