% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{PrepareBridgeReference}
\alias{PrepareBridgeReference}
\title{Prepare the bridge and reference datasets}
\usage{
PrepareBridgeReference(
  reference,
  bridge,
  reference.reduction = "pca",
  reference.dims = 1:50,
  normalization.method = c("SCT", "LogNormalize"),
  reference.assay = NULL,
  bridge.ref.assay = "RNA",
  bridge.query.assay = "ATAC",
  supervised.reduction = c("slsi", "spca", NULL),
  bridge.query.reduction = NULL,
  bridge.query.features = NULL,
  laplacian.reduction.name = "lap",
  laplacian.reduction.key = "lap_",
  laplacian.reduction.dims = 1:50,
  verbose = TRUE
)
}
\arguments{
\item{reference}{A reference Seurat object}

\item{bridge}{A multi-omic bridge Seurat object}

\item{reference.reduction}{Name of dimensional reduction of the reference object (default is 'pca')}

\item{reference.dims}{Number of dimensions used for the reference.reduction (default is 50)}

\item{normalization.method}{Name of normalization method used: LogNormalize
or SCT}

\item{reference.assay}{Assay name for reference (default is \code{\link{DefaultAssay}})}

\item{bridge.ref.assay}{Assay name for bridge used for reference mapping. RNA by default}

\item{bridge.query.assay}{Assay name for bridge used for query mapping. ATAC by default}

\item{supervised.reduction}{Type of supervised dimensional reduction to be performed
for integrating the bridge and query.
#' Options are:
\itemize{
   \item{slsi: Perform supervised LSI as the dimensional reduction for
   the bridge-query integration}
   \item{spca: Perform supervised PCA as the dimensional reduction for
   the bridge-query integration}
   \item{NULL: no supervised dimensional reduction will be calculated.
   bridge.query.reduction is used for the bridge-query integration}
}}

\item{bridge.query.reduction}{Name of dimensions used for the bridge-query harmonization.
'bridge.query.reduction' and 'supervised.reduction' cannot be NULL together.}

\item{bridge.query.features}{Features used for bridge query dimensional reduction
(default is NULL which uses VariableFeatures from the bridge object)}

\item{laplacian.reduction.name}{Name of dimensional reduction name of graph laplacian eigenspace (default is 'lap')}

\item{laplacian.reduction.key}{Dimensional reduction key (default is 'lap_')}

\item{laplacian.reduction.dims}{Number of dimensions used for graph laplacian eigenspace (default is 50)}

\item{verbose}{Print progress and message (default is TRUE)}
}
\value{
Returns a \code{BridgeReferenceSet} that can be used as input to
 \code{\link{FindBridgeTransferAnchors}}.
The parameters used are stored in the \code{BridgeReferenceSet} as well
}
\description{
Preprocess the multi-omic bridge and unimodal reference datasets into
an extended reference.
This function performs the following three steps:
1. Performs within-modality harmonization between bridge and reference
2. Performs dimensional reduction on the SNN graph of bridge datasets via
Laplacian Eigendecomposition
3. Constructs a bridge dictionary representation for unimodal reference cells
}
