% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/escape.R
\name{stri_escape_unicode}
\alias{stri_escape_unicode}
\title{Escape Unicode Code Points}
\usage{
stri_escape_unicode(str)
}
\arguments{
\item{str}{character vector}
}
\value{
Returns a character vector.
}
\description{
Generates an ASCII string where all non-printable characters
and non-ASCII characters are converted to escape sequences.
}
\details{
For non-printable and certain special (well-known,
see also the R man page \link{Quotes})
ASCII characters, the following
(also recognized in R) convention is used.
We get \code{\\a}, \code{\\b}, \code{\\t}, \code{\\n}, \code{\\v},
\code{\\f}, \code{\\r}, \code{\"}, \code{\'}, \code{\\\\}
or either \code{\\uXXXX} (4 hex digits) or \code{\\UXXXXXXXX} (8 hex digits)
otherwise.


As usual in stringi, any input string is converted to Unicode
before executing the escape process.
}
\examples{
stri_escape_unicode('a\u0105!')

}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other escape: 
\code{\link{stri_unescape_unicode}()}
}
\concept{escape}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
