% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rng.R
\name{with_rng_version}
\alias{with_rng_version}
\alias{local_rng_version}
\title{RNG version}
\usage{
with_rng_version(version, code)

local_rng_version(version, .local_envir = parent.frame())
}
\arguments{
\item{version}{\verb{[character(1)]} an R version number, e.g.
\code{"3.5.0"}, to switch to the RNG this version of R uses.
See \code{\link[=RNGversion]{RNGversion()}}.}

\item{code}{\code{[any]}\cr Code to execute in the temporary environment}

\item{.local_envir}{The environment to apply the change to.}
}
\value{
\code{[any]}\cr The results of the evaluation of the \code{code}
argument.
}
\description{
Change the RNG version and restore it afterwards.
}
\details{
\code{with_rng_version()} runs the code with the specified RNG version and
resets it afterwards.

\code{local_rng_version()} changes the RNG version for the caller
execution environment.
}
\examples{
RNGkind()
with_rng_version("3.0.0", RNGkind())
with_rng_version("1.6.0", RNGkind())

with_rng_version("3.0.0",
  with_seed(42, sample(1:100, 3)))

with_rng_version("1.6.0",
  with_seed(42, sample(1:100, 3)))

RNGkind()

fun1 <- function() {
  local_rng_version("3.0.0")
  with_seed(42, sample(1:100, 3))
}

fun2 <- function() {
  local_rng_version("1.6.0")
  with_seed(42, sample(1:100, 3))
}

RNGkind()
fun1()
fun2()
RNGkind()
}
\seealso{
\code{\link{withr}} for examples

\code{\link[=RNGversion]{RNGversion()}}, \code{\link[=RNGkind]{RNGkind()}}, \code{\link[=with_seed]{with_seed()}}.
}
