# Announce: Rakudo Perl 6 compiler, Release #102 (2016.08)

On behalf of the Rakudo development team, I’m very happy to announce the
August 2016 release of Rakudo Perl 6 #102. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo, but no new features.

Upcoming releases in 2016 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2016.08:
 + Fixes:
    + Numerous improvements to content of error messages and addition
        of new previously-undetected warnings, such as on sinks and ... terms
    + Concatenation/substr with strings constructed with repeat operator
        no longer results in incorrect strings
    + Fixed error for unknown symbol in parametric type
    + Fixed compilation and behaviour of :D on subsets
    + Assigning Nil to a :D variable now fails (unless its default is :D)
    + Fixed merge global symbols failures when changing repositories
    + Fixed -Ilib and friends not overriding installed dependencies
    + Fixed <[a..z]> ranges breaking grapheme awareness
    + Fixed a race condition in Channel.Supply
    + Fixed an occasional deadlock when using the supply/react syntax
    + Fixed a race condition involving tearing down listening async sockets
    + @a.splice now returns array with correct descriptor
    + Range.rotor with Rat arguments no longer crashes
    + .hash on Bag, Mix, BagHash, and MixHash types no longer stringifies keys
    + .abspath on filenames starting with '-' no longer results in empty string
    + loop and repeat now properly self-sink
    + for { ... .map } now properly sinks
    + Bool.Int now properly returns an Int
    + Starting the REPL with a module loading error, will now just exit
    + Fixed loading of modules when a FileSystem repo doesn't actually exist
 + Additions:
    + Str.samemark('') now returns self instead of failing
    + Test.pm now provides bail-out()
    + Added PERL6_TEST_DIE_ON_FAIL env var in Test.pm6 to bail out of the
        test suite on first failure
    + Implemented $?MODULE and ::?MODULE
    + Implemented CompUnit::Repository::Installation::installed
    + .min/.max can now be called on Hashes
    + Invocant marker (:) can now be used in bare signatures
    + Added X::Syntax::NonListAssociative exception type
    + Buf.push|append|unshift|prepend also allow Blob:D
    + .succ now increments additional 29 digit ranges, such as Thai digits
    + Implemented :exists on multi-dim assoc subscript literals
 + Efficiency:
    + Improved dynamic variable lookup (2x as fast)
    + Hash.AT-KEY is about 35% faster
    + Hash.ASSIGN-KEY about 2x as fast
    + Hash.DELETE-KEY about 2x as fast
    + Hash[Any,Any].AT-KEY about 20% faster
    + Hash[Any,Any].ASSIGN-KEY about 15% faster
    + Hash[Any,Any].BIND-KEY about 15% faster
    + Hash[Any,Any].EXISTS-KEY about 10% faster
    + Hash[Any,Any].DELETE-KEY 10% faster
    + Repeated calls on Bag.WHICH now 5x as fast
    + Backtrace creation 25% faster
    + .first/.first(:end) iteration is now about 10% faster
        after testing 1000 elements
    + .minmax about 25% faster
    + .min/.max about 40% faster
    + min/max/minmax on native arrays is between 15x and 25x faster than
        non-native equivalent
    + Array.splice() almost infinitely faster and is much easier on memory (no
        longer copies anything but instead transplants internals)
    + Array.splice(offset,size) is now 20x to 40x faster for
        small offsets and sizes
    + Array.splice(offset,size,@) is about 10x faster
    + 10% improvement to .map/for in special cases of one-argument block that
        has a return signature that excludes Slips,
        such as -> Int $_ --> Str { .Str }
    + Many Set/SetHash methods are now at least 5% faster
    + Coercing a MixHash/BagHash to a Mix/Bag is now 300x faster
    + Coercing a Bag/BagHash to Mix coercion is now 1000x faster
    + Coercing a SetHash to a Set is now 80x faster

These are only some of the changes in this release. For a more
detailed list, see “docs/ChangeLog”.

The following people contributed to this release:

Zoffix Znet, Wenzel P. P. Peppmeyer, Elizabeth Mattijsen, Pawel Murias,
Jonathan Worthington, Altai-man, Larry Wall, Tom Browder, Will "Coke" Coleda,
Jan-Olof Hendig, Stefan Seifert, Moritz Lenz, Itsuki Toyota,
Christopher Bottoms, Aleks-Daniel Jakimenko-Aleksejev, Christian Bartolomäus,
Sterling Hanenkamp, Timo Paulssen, Steve Mynott, Claudio Ramirez, LemonBoy,
Brian S. Julin, Clifton Wood, Daniel Green, Brian Duggan, Nick Logan,
LE Manh Cuong, Pepe Schwarz, Daniel Dehennin, cognominal, David Warring,
LLFourn, smls, Jonathan Stowe, Jimmy Zhuo, Brent Laabs, Trey Harris, nsvedberg,
Bill Barry, 0racle, dmaestro, Eike Frost, ab5tract

Regrettably, a deficiency has been discovered in the contributor gathering
script, where it silently left out contributors to perl6/doc repository, if
the release manager did not have it checked out at a specific location. Due to
this, those contributors very likely have been accidentally left out from
previous announcements. Since Christmas 2015, the following people contributed
to our ever-improving documentation:

Wenzel P. P. Peppmeyer, Zoffix Znet, Jan-Olof Hendig, Tom Browder,
Aleks-Daniel Jakimenko-Aleksejev, Altai-man, Jonathan Stowe, Josh Soref,
Will "Coke" Coleda, Steve Mynott, Elizabeth Mattijsen, Brian S. Julin,
Daniel Green, Itsuki Toyota, Moritz Lenz, Brock Wilcox, Simon Ruderich,
Christopher Bottoms, raiph, Sterling Hanenkamp, Ahmad M. Zawawi, Daniel Perrett,
Claudio Ramirez, David Brunton, Jonathan Worthington, Jake Russo,
Salvador Ortiz, Siavash Askari Nasr, Bruce Gray, jjatria, John Gabriele,
Paul Cochrane, Jim Davis, Timo Paulssen, sylvarant, David H. Adler,
Sylvain Colinet, Donald Hunter, LLFourn, Shlomi Fish, Tobias Leich,
Eric de Hont, Mathieu Gagnon, parabolize, Brian Duggan, Jason Cole, dogbert17,
Fritz Zaucker, cognominal, Marcel Timmerman, Larry Wall, Dave Olszewski,
Dabrien 'Dabe' Murphy, smls, Emeric54, ab5tract, Jeffrey Goff, VZ, okaoka,
Steve Bertrand, ianmcb, Daniel Dehennin, vinc17fr, Dave Rolsky, Matt Oates,
Trey Harris, Nat, Altai-ch, nsvedberg, Bill Barry, fireartist, 0racle,
Robert Newbould, Coleoid, Brad Gilbert, James ( Jeremy ) Carman,
Stéphane Payrard, Dale Evans, Nick Logan, thundergnat, dmaestro, Carl Masak,
Eike Frost, Martin Dørum Nygaard, gotoexit, Neil Shadrach, Stefan Seifert

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

The next release of Rakudo (#103), is tentatively scheduled for 2016-09-17.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility.
