#! /bin/sh
#
#	recite - english text speech synthesizer
#	Copyright (C) 1993 Peter Miller.
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 1, or (at your option)
#	any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# MANIFEST: shell script to generate Makefile file
#
recite_files=
common=
test_files=
clean_files=core
echo  "#"
echo  "# extra includes required for your system"
echo  "#"
echo  "# H ="
echo  "H = -I/usr/demo/SOUND"
echo  ""
echo  "#"
echo  "# the name of the compiler to use"
echo  "#"
echo  "CC = cc"
echo  "# CC = gcc"
echo
echo  "#"
echo  "# The compiler flags to use, except for include path."
echo  "#"
echo  "CFLAGS = -O"
echo  "# CFLAGS = -g"
echo  "# CFLAGS = -O -Wall -ansi	# gcc"
echo  ""
echo  "#"
echo  "# extra libraries required for your system"
echo  "#"
echo  "# LIBRARIES ="
echo  "LIBRARIES = -L/usr/demo/SOUND -laudio"
echo  ""
echo  "# You should not need to alter anything below this point."
echo  "#------------------------------------------------------------"
echo  ""
echo  "all: bin/recite"
echo  ""
rm common/conf.h
for file in $*
do
	case $file in

	*/*.c)
		dir=`dirname $file`
		root=`basename $file .c`
		dep=`c_incl -nc -I$dir -Icommon -ns $file`
		echo ""
		echo "$dir/${root}.o: $file" $dep
		echo "	$(CC) $(CFLAGS) -I$dir -Icommon $(H) -c $file"
		echo "	mv ${root}.o $dir"
		recite_files="$recite_files $dir/${root}.o"
		clean_files="$clean_files $dir/${root}.o"
		;;

	test/*/*)
		root=`basename $file .sh`
		echo ""
		echo "${root}: all $file"
		echo "	sh $file"
		test_files="$test_files ${root}"
		;;

	*)
		;;
	esac
done

echo ""
echo "ReciteObj =" $recite_files

echo ""
echo "bin/recite: $(ReciteObj)"
echo "	-mkdir bin"
echo "	$(CC) -o bin/recite $(ReciteObj) $(LIBRARIES) -lm"

echo ""
echo "sure:" $test_files
echo "	@echo Passed All Tests"

echo ""
echo "clean:"
echo "	rm -f" $clean_files

echo ""
echo "clobber: clean"
echo "	rm -f bin/recite"

exit 0
