#include <features.h>
#include <rules.h>
#include <trace.h>
#include <var.h>
#include <vowel.h>


void
gen_vowel(phone, segdur, prev_phone, next_phone)
	int		phone;
	int		segdur;
	int		prev_phone;
	int		next_phone;
{
	int		j;
	unsigned long	features;
	unsigned long	next_feat=-1;
	unsigned long	prev_feat=-1;
	int		off;
	int		interp=0;
	double		prcnt;
	double		f0_temp;
	double		f1_temp;
	double		f2_temp;
	double		f3_temp;
	double		bw1_temp;
	double		bw2_temp;
	double		bw3_temp;
	double		av_temp;
	double		n_av	= 0;
	double		n_f1	= 0;
	double		n_f2	= 0;
	double		n_f3	= 0;
	double		n_bw1	= 0;
	double		n_bw2	= 0;
	double		n_bw3	= 0;
	int		time_const;
	int		time_count;

	trace(("gen_vowel(phone = %s, segdur = %d, prev_phone = %s, next_phone = %s)\n{\n"/*}*/, phonemes_name(phone), segdur, phonemes_name(prev_phone), phonemes_name(next_phone)));
	features = Features[phone];

	if (prev_phone != -1)
		prev_feat = Features[prev_phone];
	if (next_phone != -1) 
		next_feat = Features[next_phone];

	if (prev_feat != -1)
	{
		if (prev_feat & VOWEL || prev_feat & SONOR)
		{
			if (prev_feat & FRICA)
				prcnt = .30;
			else 
				prcnt = .95;
				
			f1[0] -= (f1[0] - LastTarget.f1) * prcnt;
			f2[0] -= (f2[0] - LastTarget.f2) * prcnt;
			f3[0] -= (f3[0] - LastTarget.f3) * prcnt;
			bw1[0] -= (bw1[0] - LastTarget.bw1) * prcnt;
			bw2[0] -= (bw2[0] - LastTarget.bw2) * prcnt;
			bw3[0] -= (bw3[0] - LastTarget.bw3) * prcnt;
		}
	}
	if (next_feat != -1)
	{
		if (next_feat & NASAL)
		{
			translate_phone(next_phone,&off);
			n_av = Nasals[off].av;
			n_f1 = Nasals[off].f1;
			n_f2 = Nasals[off].f2;
			n_f3 = Nasals[off].f3;
			n_bw1 = Nasals[off].bw1;
			n_bw2 = Nasals[off].bw2;
			n_bw3 = Nasals[off].bw3;
		}
	}

	f0_temp = f0[0]; 
	f1_temp = f1[0]; 
	f2_temp = f2[0]; 
	f3_temp = f3[0]; 
	bw1_temp = bw1[0];
	bw2_temp = bw2[0];
	bw3_temp = bw3[0];
	av_temp = av[0];

	time_const = segdur;
	time_count = 0;
	for (j=0;j < segdur;j+=10)
	{
		frame_ty	frame;

		frame.f0 = f0_temp; 
		frame.f1 = f1_temp; 
		frame.f2 = f2_temp; 
		frame.f3 = f3_temp; 
		frame.bw1 = bw1_temp;
		frame.bw2 = bw2_temp;
		frame.bw3 = bw3_temp;
		frame.fnz = fnz;
		frame.fnp = fnp;
		frame.av = av_temp;
		frame.anp = 0;
		frame.asp = asp;
		frame.af = af;
		frame.a1 = a1;
		frame.a2 = a2;
		frame.a3 = a3;
		frame.a4 = a4;
		frame.a5 = a5;
		frame.a6 = a6;
		frame.ab = ab;

		if (j < (segdur/3)) 
			f0[0] += 40;
		else
		{
			if (f0_change != -1000)
				f0[0] -= 25;
			else 
				f0[0] -= 10;
		}

		f0_temp = f0[0];

		if (next_feat != -1)
		{
			if ((next_feat & NASAL) && (j >= segdur-35 && j < segdur-25))
			{
				f1[0] = f1_temp;
				f2[0] = f2_temp;
				f3[0] = f3_temp;
				bw1[0] = bw1_temp;
				bw2[0] = bw2_temp;
				bw3[0] = bw3_temp;
				av[0] = av_temp;

				f1[1] = n_f1;
				f2[1] = n_f2;
				f3[1] = n_f3;
				bw1[1] = n_bw1;
				bw2[1] = n_bw2;
				bw3[1] = n_bw3;
				av[1] = n_av;
				
				time_const = 10;
				time_count = 0;
				interp = 1;
			}
		}

		if ((features & DIPTH) || interp)
		{
			f0_temp = gen_curve(f0[0],f0[1],time_const/4,time_count);
			f1_temp = gen_curve(f1[0],f1[1],time_const/4,time_count); 
			f2_temp = gen_curve(f2[0],f2[1],time_const/4,time_count); 
			f3_temp = gen_curve(f3[0],f3[1],time_const/4,time_count); 
			bw1_temp = gen_curve(bw1[0],bw1[1],time_const/4,time_count); 
			bw2_temp = gen_curve(bw2[0],bw2[1],time_const/4,time_count); 
			bw3_temp = gen_curve(bw3[0],bw3[1],time_const/4,time_count);
			av_temp = gen_curve(av[0],av[1],time_const/4,time_count);
		}
		time_count += 10;
		frame_out(&frame);
		LastTarget = frame;
	}
	trace((/*{*/"}\n"));
}
