#! /usr/bin/env perl

# Test package that computes default database settings:

use strict;
use warnings;
use utf8;
use Data::Dumper;

use lib 'lib';
use Database;

binmode( STDOUT, "utf8" );

my $pwd = `pwd`;
$pwd =~ s/\n$//;

my $db_settings = {
    content_db => {
        DB => "$pwd/db/localhost.db",
        engine => 'SQLite'            
    }
};

my $db = Database->new( $db_settings );

# Hiding metadata tables:
delete $db->{db}{meta};

$db->connect();

$Data::Dumper::Sortkeys = 1;
$Data::Dumper::Indent   = 1;
print Dumper $db->get_column_formats( 'images' );
print Dumper { $db->get_column_type_hash( 'images' ) };

print "-----------------\n";
print Dumper { $db->get_column_type_hash( 'bibliography' ) };
print Dumper { $db->get_column_lengths( 'bibliography' ) };
