/**
 * Copyright 2005-2012 Restlet S.A.S.
 * 
 * The contents of this file are subject to the terms of one of the following
 * open source licenses: Apache 2.0 or LGPL 3.0 or LGPL 2.1 or CDDL 1.0 or EPL
 * 1.0 (the "Licenses"). You can select the license that you prefer but you may
 * not use this file except in compliance with one of these Licenses.
 * 
 * You can obtain a copy of the Apache 2.0 license at
 * http://www.opensource.org/licenses/apache-2.0
 * 
 * You can obtain a copy of the LGPL 3.0 license at
 * http://www.opensource.org/licenses/lgpl-3.0
 * 
 * You can obtain a copy of the LGPL 2.1 license at
 * http://www.opensource.org/licenses/lgpl-2.1
 * 
 * You can obtain a copy of the CDDL 1.0 license at
 * http://www.opensource.org/licenses/cddl1
 * 
 * You can obtain a copy of the EPL 1.0 license at
 * http://www.opensource.org/licenses/eclipse-1.0
 * 
 * See the Licenses for the specific language governing permissions and
 * limitations under the Licenses.
 * 
 * Alternatively, you can obtain a royalty free commercial license with less
 * limitations, transferable or non-transferable, directly at
 * http://www.restlet.com/products/restlet-framework
 * 
 * Restlet is a registered trademark of Restlet S.A.S.
 */

package org.restlet.example.book.restlet.ch07.sec4.sub5;

import java.util.Calendar;
import java.util.GregorianCalendar;

import org.restlet.data.CacheDirective;
import org.restlet.data.MediaType;
import org.restlet.data.Tag;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.restlet.resource.ServerResource;

public class CachingServerResource extends ServerResource {

    @Get
    public Representation represent() {
        // Modification date (Fri, 17 Apr 2009 10:10:10 GMT) unchanged.
        Calendar cal = new GregorianCalendar(2009, 3, 17, 10, 10, 10);
        Representation result = new StringRepresentation("<a href="
                + getReference() + ">" + System.currentTimeMillis() + "</a>");
        result.setMediaType(MediaType.TEXT_HTML);
        result.setModificationDate(cal.getTime());

        // Expiration date (Fri, 17 Apr 2019 10:10:10 GMT) unchanged.
        cal = new GregorianCalendar(2019, 3, 17, 10, 10, 10);
        result.setExpirationDate(cal.getTime());

        // Setting E-Tag
        result.setTag(new Tag("xyz123"));

        // Setting a cache directive
        getResponse().getCacheDirectives().add(CacheDirective.publicInfo());

        return result;
    }

    @Put
    public void store(Representation entity) {
        System.out.println("Storing a new entity.");
    }
}
