#include "rheolef.h"
using namespace rheolef;
using namespace std;
int main(int argc, char**argv) {
  geo omega (argv[1]);
  space Xh (omega, argv[2]);
  Xh.block ("boundary");
  form a (Xh, Xh, "grad_grad");
  form m (Xh, Xh, "mass");
  field fh (Xh, 1);
  field uh (Xh);
  uh ["boundary"] = 0;
  if (omega.dimension() < 3) {
    ssk<Float> fact = ldlt(a.uu);
    uh.u = fact.solve (m.uu*fh.u + m.ub*fh.b - a.ub*uh.b);
  } else {
    size_t max_iter = 10000;
    Float tol = 1e-15;
    uh.u = 0;
    int status = pcg (a.uu, uh.u, m.uu*fh.u + m.ub*fh.b - a.ub*uh.b,
                  ic0(a.uu), max_iter, tol, &cerr);
  }
  cout << uh;
  return 0;
}
