///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/form_manip.h"
using namespace rheolef;
using namespace std;
namespace rheolef { 

form_manip::form_manip()
  : _verbose(true),
    _nform(0),
    _nrowbloc(0),
    _ncolbloc(0),
    _a(0)
{
}
form_manip::size_type
form_manip::nform() const
{
    return _nform;
}
form_manip::size_type 
form_manip::nrowbloc() const
{
    return _nrowbloc;
}
form_manip::size_type 
form_manip::ncolbloc() const
{
    return _ncolbloc;
}
form&
form_manip::bloc(size_type i, size_type j)
{
    return _a[_ncolbloc*i+j];
}
const form&
form_manip::bloc (size_type i, size_type j) const
{
    return _a[_ncolbloc*i+j];
}
form_manip&
form_manip::operator << (const form& a) 
{
    _a.insert (_a.end(),a);
    _nform++; 
    return *this;
}
form_manip&
form_manip::operator >> (form& a)
{
  if (_nform != _nrowbloc*_ncolbloc) {
      error_macro("bad bloc number: " << _nform << ", expect " << _nrowbloc*_ncolbloc);
  }
  check_macro (_ncolbloc >0 && _nrowbloc > 0, "size(n,m) may be non-zero in form_manip");
  //
  // initialize (X,Y) spaces as product spaces
  //
  a.X_ = bloc(0,0).X_;
  for (size_t j = 1; j < _ncolbloc; j++) {
    a.X_ = a.X_ * bloc(0,j).X_;
  }
  a.Y_ = bloc(0,0).Y_;
  for (size_t i = 1; i < _nrowbloc; i++) {
    a.Y_ = a.Y_ * bloc(i,0).Y_;
  }
  //
  // big switch: there is not yet a general case !!!
  //
  switch(_nrowbloc) {

  case 1:
    switch(_ncolbloc) {
    case 1: // scalaire    -> scalaire
      a.uu = bloc(0,0).uu ; a.ub = bloc(0,0).ub ;
      a.bu = bloc(0,0).bu ; a.bb = bloc(0,0).bb ;
      break ;
    case 2: // vecteur(2D) -> scalaire
      a.uu = hcat(bloc(0,0).uu,bloc(0,1).uu) ; a.ub = hcat(bloc(0,0).ub,bloc(0,1).ub) ;
      a.bu = hcat(bloc(0,0).bu,bloc(0,1).bu) ; a.bb = hcat(bloc(0,0).bb,bloc(0,1).bb) ;
      break ;
    case 3: // vecteur(3D) -> scalaire ou tenseur sym(2D) -> scalaire
      trace_macro("3D not yet: 2d sym. tenseur sym -> scalar");
      a.uu = hcat(bloc(0,0).uu,hcat(bloc(0,1).uu,bloc(0,2).uu)) ; 
      a.ub = hcat(bloc(0,0).ub,hcat(bloc(0,1).ub,bloc(0,2).ub)) ;
      a.bu = hcat(bloc(0,0).bu,hcat(bloc(0,1).bu,bloc(0,2).bu)) ; 
      a.bb = hcat(bloc(0,0).bb,hcat(bloc(0,1).bb,bloc(0,2).bb)) ;
      break ;
    default:
      error_macro("vector(" << _ncolbloc << "D) is scalar");
    }
    break ;
    
  case 2:
    switch(_ncolbloc) {
    case 1: // scalaire    -> vecteur(2D)
      a.uu = vcat(bloc(0,0).uu,bloc(1,0).uu) ; a.ub = vcat(bloc(0,0).ub,bloc(1,0).ub) ; 
      a.bu = vcat(bloc(0,0).bu,bloc(1,0).bu) ; a.bb = vcat(bloc(0,0).bb,bloc(1,0).bb) ; 
      break ;
    case 2: // vecteur(2D) -> vecteur(2D) 
      a.uu = vcat( hcat(bloc(0,0).uu,bloc(0,1).uu) , hcat(bloc(1,0).uu,bloc(1,1).uu) ) ;
      a.ub = vcat( hcat(bloc(0,0).ub,bloc(0,1).ub) , hcat(bloc(1,0).ub,bloc(1,1).ub) ) ;
      a.bu = vcat( hcat(bloc(0,0).bu,bloc(0,1).bu) , hcat(bloc(1,0).bu,bloc(1,1).bu) ) ;
      a.bb = vcat( hcat(bloc(0,0).bb,bloc(0,1).bb) , hcat(bloc(1,0).bb,bloc(1,1).bb) ) ;
      break ;
    case 3: // tenseur(2D) -> vecteur(2D)
      a.uu = vcat( hcat( hcat(bloc(0,0).uu,bloc(0,1).uu) , bloc(0,2).uu ) ,
		   hcat( hcat(bloc(1,0).uu,bloc(1,1).uu) , bloc(1,2).uu ) );  
      a.ub = vcat( hcat( hcat(bloc(0,0).ub,bloc(0,1).ub) , bloc(0,2).ub ) ,
		   hcat( hcat(bloc(1,0).ub,bloc(1,1).ub) , bloc(1,2).ub ) ) ;  
      a.bu = vcat( hcat( hcat(bloc(0,0).bu,bloc(0,1).bu) , bloc(0,2).bu ) ,
		   hcat( hcat(bloc(1,0).bu,bloc(1,1).bu) , bloc(1,2).bu ) ) ;  
      a.bb = vcat( hcat( hcat(bloc(0,0).bb,bloc(0,1).bb) , bloc(0,2).bb ) ,
		   hcat( hcat(bloc(1,0).bb,bloc(1,1).bb) , bloc(1,2).bb ) ) ;   
      break ;
    case 4: // tenseur(2Daxi) -> vecteur(2D)
      a.uu = vcat( hcat( hcat(bloc(0,0).uu,bloc(0,1).uu) , hcat(bloc(0,2).uu,bloc(0,3).uu) ) ,
		   hcat( hcat(bloc(1,0).uu,bloc(1,1).uu) , hcat(bloc(1,2).uu,bloc(1,3).uu) ) );  
      a.ub = vcat( hcat( hcat(bloc(0,0).ub,bloc(0,1).ub) , hcat(bloc(0,2).ub,bloc(0,3).ub) ) ,
		   hcat( hcat(bloc(1,0).ub,bloc(1,1).ub) , hcat(bloc(1,2).ub,bloc(1,3).ub) ) ) ;  
      a.bu = vcat( hcat( hcat(bloc(0,0).bu,bloc(0,1).bu) , hcat(bloc(0,2).bu,bloc(0,3).bu) ) ,
		   hcat( hcat(bloc(1,0).bu,bloc(1,1).bu) , hcat(bloc(1,2).bu,bloc(1,3).bu) ) ) ;  
      a.bb = vcat( hcat( hcat(bloc(0,0).bb,bloc(0,1).bb) , hcat(bloc(0,2).bb,bloc(0,3).bb) ) ,
		   hcat( hcat(bloc(1,0).bb,bloc(1,1).bb) , hcat(bloc(1,2).bb,bloc(1,3).bb) ) ) ;   
      break ;
    default:
      error_macro("vector (" << _ncolbloc << "D) is vecteur(2D)");
    }
    break ;
    
  case 3:
    switch(_ncolbloc) {
    case 1: // scalaire -> vecteur(3D) ou scalaire -> tenseur sym(2D)
      trace_macro("3D not yet: scalaire -> tenseur sym(2D)");
      a.uu = vcat(bloc(0,0).uu,vcat(bloc(1,0).uu,bloc(2,0).uu)) ; 
      a.ub = vcat(bloc(0,0).ub,vcat(bloc(1,0).ub,bloc(2,0).ub)) ;
      a.bu = vcat(bloc(0,0).bu,vcat(bloc(1,0).bu,bloc(2,0).bu)) ; 
      a.bb = vcat(bloc(0,0).bb,vcat(bloc(1,0).bb,bloc(2,0).bb)) ;      
      break ;
    case 2: // vecteur(2D) -> tenseur(2D)
      a.uu = hcat( vcat( vcat(bloc(0,0).uu,bloc(1,0).uu) , bloc(2,0).uu ) ,
		   vcat( vcat(bloc(0,1).uu,bloc(1,1).uu) , bloc(2,1).uu ) ) ;  
      a.ub = hcat( vcat( vcat(bloc(0,0).ub,bloc(1,0).ub) , bloc(2,0).ub ) ,
		   vcat( vcat(bloc(0,1).ub,bloc(1,1).ub) , bloc(2,1).ub ) ) ;  
      a.bu = hcat( vcat( vcat(bloc(0,0).bu,bloc(1,0).bu) , bloc(2,0).bu ) ,
		   vcat( vcat(bloc(0,1).bu,bloc(1,1).bu) , bloc(2,1).bu ) ) ;  
      a.bb = hcat( vcat( vcat(bloc(0,0).bb,bloc(1,0).bb) , bloc(2,0).bb ) ,
		   vcat( vcat(bloc(0,1).bb,bloc(1,1).bb) , bloc(2,1).bb ) ) ;  
      break ;
    case 3: // tenseur(2D) -> tenseur(2D) et vecteur(3D) -> vecteur(3D)
      trace_macro("3D in test...");
      a.uu = hcat( hcat(bloc(0,0).uu,bloc(0,1).uu) , bloc(0,2).uu ) ;
      a.ub = hcat( hcat(bloc(0,0).ub,bloc(0,1).ub) , bloc(0,2).ub ) ;
      a.bu = hcat( hcat(bloc(0,0).bu,bloc(0,1).bu) , bloc(0,2).bu ) ;
      a.bb = hcat( hcat(bloc(0,0).bb,bloc(0,1).bb) , bloc(0,2).bb ) ;
      a.uu = vcat( a.uu , hcat( hcat(bloc(1,0).uu,bloc(1,1).uu) , bloc(1,2).uu ) ) ;  
      a.ub = vcat( a.ub , hcat( hcat(bloc(1,0).ub,bloc(1,1).ub) , bloc(1,2).ub ) ) ;  
      a.bu = vcat( a.bu , hcat( hcat(bloc(1,0).bu,bloc(1,1).bu) , bloc(1,2).bu ) ) ;  
      a.bb = vcat( a.bb , hcat( hcat(bloc(1,0).bb,bloc(1,1).bb) , bloc(1,2).bb ) ) ;  
      a.uu = vcat( a.uu , hcat( hcat(bloc(2,0).uu,bloc(2,1).uu) , bloc(2,2).uu ) ) ;  
      a.ub = vcat( a.ub , hcat( hcat(bloc(2,0).ub,bloc(2,1).ub) , bloc(2,2).ub ) ) ;  
      a.bu = vcat( a.bu , hcat( hcat(bloc(2,0).bu,bloc(2,1).bu) , bloc(2,2).bu ) ) ;  
      a.bb = vcat( a.bb , hcat( hcat(bloc(2,0).bb,bloc(2,1).bb) , bloc(2,2).bb ) ) ;  
      break ;
    case 6:
      // tenseur(3D) -> vecteur(3D)
      break ;
    default:
      error_macro("vecteur (" << _ncolbloc << "D) -> tenseur (2D)");
    }	   
    break ;
    
  case 6:
    trace_macro("3D not yet");
    switch(_ncolbloc) {
    case 3: break ;// vecteur(3D) -> tenseur(3D)
    case 6: break ;// tenseur(3D) -> tenseur(3D)
    default:
      error_macro("vecteur (" << _ncolbloc << "D) -> tenseur (3D)");
    }
    break ;

  default:
    error_macro("vector (" << _ncolbloc << "D) -> vector (" << _nrowbloc << "D)");
  } // fin du switch(_nrowbloc)
  return (*this) ;
}
form_manip&
form_manip::operator << (form_manip& (*pf)(form_manip&))
{
    return (*pf)(*this);
}  
form_manip&
verbose (form_manip &fm) 
{
    fm._verbose = true;
    return fm;
}
form_manip&
noverbose (form_manip &fm) 
{
    fm._verbose = false;
    return fm;
}
size::size (size_type nrowbloc1, size_type ncolbloc1)
  : _nrowbloc(nrowbloc1),
    _ncolbloc(ncolbloc1)
{
}
form_manip&
operator << (form_manip &fm, const size& s)
{
    fm._nrowbloc = s._nrowbloc;
    fm._ncolbloc = s._ncolbloc;
    return fm ;
}
}// namespace rheolef
