///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
/*
 * test de geo_element
 */

#include "rheolef/geo_element.h"
using namespace rheolef;
using namespace std;

int main(int argc, char**argv)
{

  if (argc <= 1)
    {
      cerr << "tst_gel [e][t][q][T][H][P]\n" ;
      exit(1) ;
    }

  char t = argv[1][0] ;
  
  cout << "\nL''element de type:" << t << "\n\n" ;

  geo_element K;
  K.type(t) ;

  cout << "n_vertices: " << K.size()      << "\n"
       << "n_edges   : " << K.n_edges()   << "\n"
    //       << "n_faces   : " << K.n_faces()   << "\n"
       << "dimension : " << K.dimension() << "\n\n" ;

  for(geo_element::size_type i=0 ; i<K.size() ; i++)
    K[i] = i*10 ;

  for(geo_element::size_type i=0 ; i<K.n_edges() ; i++)
    K.set_edge(i, i*10+5) ;

  cout << "vertices: local -> global\n" ;
  for (geo_element::size_type vloc=0 ; vloc < K.size() ; vloc++)
    cout << vloc << "-> " << K[vloc] << "\n" ;
  
  cout << "\nedges: local -> global\n" ;
  for (geo_element::size_type eloc=0 ; eloc < K.n_edges() ; eloc++)
    {
      geo_element::size_type vloc1, vloc2 ;
      K.loc_vertex_from_loc_edge(vloc1, vloc2, eloc) ;
      cout << eloc << "-> " << K.get_edge(eloc) << "\n"
	   << "loc_vertex_from_edge(" << eloc 
	   << ") -> (" << vloc1 << ", " << vloc2 << ")\n" ;
      
    }

}
