# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: src/proto/grpc/testing/services.proto for package 'grpc.testing'
# Original file comments:
# Copyright 2015, Google Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#     * Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above
# copyright notice, this list of conditions and the following disclaimer
# in the documentation and/or other materials provided with the
# distribution.
#     * Neither the name of Google Inc. nor the names of its
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# An integration test service that covers all the method signature permutations
# of unary/streaming requests/responses.

require 'grpc'
require 'src/proto/grpc/testing/services_pb'

module Grpc
  module Testing
    module BenchmarkService
      class Service

        include GRPC::GenericService

        self.marshal_class_method = :encode
        self.unmarshal_class_method = :decode
        self.service_name = 'grpc.testing.BenchmarkService'

        # One request followed by one response.
        # The server returns the client payload as-is.
        rpc :UnaryCall, SimpleRequest, SimpleResponse
        # One request followed by one response.
        # The server returns the client payload as-is.
        rpc :StreamingCall, stream(SimpleRequest), stream(SimpleResponse)
      end

      Stub = Service.rpc_stub_class
    end
    module WorkerService
      class Service

        include GRPC::GenericService

        self.marshal_class_method = :encode
        self.unmarshal_class_method = :decode
        self.service_name = 'grpc.testing.WorkerService'

        # Start server with specified workload.
        # First request sent specifies the ServerConfig followed by ServerStatus
        # response. After that, a "Mark" can be sent anytime to request the latest
        # stats. Closing the stream will initiate shutdown of the test server
        # and once the shutdown has finished, the OK status is sent to terminate
        # this RPC.
        rpc :RunServer, stream(ServerArgs), stream(ServerStatus)
        # Start client with specified workload.
        # First request sent specifies the ClientConfig followed by ClientStatus
        # response. After that, a "Mark" can be sent anytime to request the latest
        # stats. Closing the stream will initiate shutdown of the test client
        # and once the shutdown has finished, the OK status is sent to terminate
        # this RPC.
        rpc :RunClient, stream(ClientArgs), stream(ClientStatus)
        # Just return the core count - unary call
        rpc :CoreCount, CoreRequest, CoreResponse
        # Quit this worker
        rpc :QuitWorker, Void, Void
      end

      Stub = Service.rpc_stub_class
    end
  end
end
